/*
 * hiperface.c
 *
 *  Created on: 2025 Jul 24
 *      Author: Gejian
 */

#include "hiperface.h"
#include "board_cfg.h"
#include "gs32_math.h"

HPF_DATASTRUCT enc0Data;

void HPF_encInit(uint32_t baud)
{
	volatile uint32_t beftime,aftime,difftime;
	uint8_t encStatus,flag;
	uint32_t absPos,period;
	volatile uint16_t rxNum;

	/**
	 * The function of TXEN initialization
	 */
	hpf_txenInit(baud);
	hpf_uartInit(baud);

    /**
     * Power on and wait for 100ms
     * for the encoder to complete its initialization.
     */
//	GPIO_writePin(HPF_POWER_PIN, 0);

	hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_INIT_DELAY_TIME);

	/**
	 * If communication is carried out with the default configuration
	 */
	hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_SET_UART_DELAY_TIME);
	hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_OPER_DELAY_TIME);

	do{
		/**
		 * Get the encoder status.
		 * If there is an anomaly, report it and actively eliminate the anomaly.
		 * If there are no abnormalities, continue the operation.
		 */
	    enc0Data.cmdID = HPF_CMD_RD_ENC_STAT;
	    enc0Data.txNum = HPF_TX_BYTE_NUM_RD_ENC_STAT;
	    enc0Data.rxNum = HPF_RX_BYTE_NUM_RD_ENC_STAT;
	    hpf_readEncoderStatus(enc0Data.addrFrame);

	    HPF_recieveData();

	    while(enc0Data.dataReady != TRUE);

	    flag = hpf_checkout();

	    if (flag == HPF_EEROR_RESP)
	    {
		    enc0Data.cmdID = HPF_CMD_ENC_RST;
		    enc0Data.txNum = HPF_TX_BYTE_NUM_ENC_RST;
		    enc0Data.rxNum = HPF_RX_BYTE_NUM_ENC_RST;
		    hpf_sendCommandNoData(enc0Data.addrFrame,HPF_CMD_ENC_RST);
			hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_INIT_DELAY_TIME);
		}

	}while(flag);

	hpf_delayMcycle(DEVICE_SYSCLK_FREQ,600);

    /**
     * Get Encoder type label
     */
    enc0Data.cmdID = HPF_CMD_RD_TYPE_LABEL;
    enc0Data.txNum = HPF_TX_BYTE_NUM_RD_TYPE_LABEL;
    enc0Data.rxNum = HPF_RX_BYTE_NUM_RD_TYPE_LABEL;
    hpf_readTypeLabel(enc0Data.addrFrame);

    HPF_recieveData();
    while(enc0Data.dataReady != TRUE);
    flag = hpf_checkout();
    hpf_recieveTypeLabel(&hpf_enc_typeLabel);

	hpf_delayMcycle(DEVICE_SYSCLK_FREQ,600);

    /**
     * Read Absolute Position
     */
    enc0Data.cmdID = HPF_CMD_READ_POS;
    enc0Data.txNum = HPF_TX_BYTE_NUM_READ_POS;
    enc0Data.rxNum = HPF_RX_BYTE_NUM_READ_POS;
    hpf_readPosition(enc0Data.addrFrame);

    HPF_recieveData();
    while(enc0Data.dataReady != TRUE);
    flag = hpf_checkout();
    absPos = (HPF_GETABSPOS & HPF_SINGLETURN_BITNUM_MASK);
    period = HPF_GET_PERIODNUM(absPos);

    hpf_setAnaCountValue(period);
}

uint8_t HPF_changeEncBandrate(void)
{
	uint8_t errorID;
	HPF_SERIAL_IF hpf_new_serial;

    enc0Data.cmdID = HPF_CMD_SET_UART_PARA;
    enc0Data.txNum = HPF_TX_BYTE_NUM_SET_UART_PARA;
    enc0Data.rxNum = HPF_RX_BYTE_NUM_SET_UART_PARA;

    /**
     * Ҫ޸ĵUART
     * 1Ϊ38400
     * 28bit żУģʽ
     * 3ӳԼΪ22s/(38400) = 0.57291ms
     * 4׼ӻģʽ
     */
	hpf_new_serial.bit.dataRate = HPF_DATA_RATE_38400HZ;
	hpf_new_serial.bit.parity = HPF_PARITY_MODE_EVEN;
	hpf_new_serial.bit.timeout = HPF_TIMEOUT_MODE_22S;
	hpf_new_serial.bit.busMode = HPF_BUS_MODE_ST_SLAVE;

	/**
	 * ָ0x57޸ı
	 */
	hpf_setSerialInterface(enc0Data.addrFrame,hpf_new_serial.all);
    HPF_recieveData();
    while(enc0Data.dataReady != TRUE);
    errorID = hpf_checkout();
    if (errorID != 0)
    {
    	return errorID;
	}

    hpf_delayMcycle(DEVICE_SYSCLK_FREQ,5000);

    /**
     * λ
     */
    enc0Data.cmdID = HPF_CMD_ENC_RST;
    enc0Data.txNum = HPF_TX_BYTE_NUM_ENC_RST;
    enc0Data.rxNum = HPF_RX_BYTE_NUM_ENC_RST;
    hpf_resetEncoder(enc0Data.addrFrame);

    /**
     * Ӳʼ׶
     */
    hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_INIT_DELAY_TIME);
    /**
     * ĬϲͨѶ׶
     */
    hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_SET_UART_DELAY_TIME);
    /**
     * ûԶ岨ͨѶ׶
     */
    hpf_delayMcycle(DEVICE_SYSCLK_FREQ,HPF_ENC_OPER_DELAY_TIME);

    /**
     * ޸UART
     */
    SCI_setBaud(HPF_UART_BASE, HPF_UART_WORK_RATE, 9600);
    /*
     * ޸TXENοƵͬUART
     */
    hpf_setTxRate(9600);
    /**
     * ޸TXENӳʱΪ1bit
     */
    hpf_setTxenDelay(9600,1);

    /**
     * ȡ״̬
     */
    enc0Data.cmdID = HPF_CMD_RD_ENC_STAT;
    enc0Data.txNum = HPF_TX_BYTE_NUM_RD_ENC_STAT;
    enc0Data.rxNum = HPF_RX_BYTE_NUM_RD_ENC_STAT;
    hpf_readEncoderStatus(enc0Data.addrFrame);

    HPF_recieveData();
    while(enc0Data.dataReady != TRUE);
    errorID = hpf_checkout();
    if (errorID != 0)
    {
    	return errorID;
	}
    return 0;

}

uint16_t hpf_checkout()
{
	if (hpfRxDateArr[1]&0x80)
	{
		enc0Data.warningBit = 1;
		return HPF_WARING;
	}
	enc0Data.warningBit=0;
	if (hpfRxDateArr[enc0Data.rxNum-1] != enc0Data.checkSum)
	{
		return HPF_CHECKSUM_ERR;
	}
	if (hpfRxDateArr[0] != enc0Data.addrFrame)
	{
		return HPF_ADDR_ERR;
	}
	return HPF_NO_FAULT;
}

double hpf_getAnaAngle(uint16_t zeroPosValue)
{
	double fineAngle,count,pos;
	float fSina,fCosb;
	uint32_t absPos;

	count = (float)(hpf_getAnaCountValue()/4);

	fSina = (float)(ADC_readResult(SIN_ADC_BASE+0x400,ADC_SOC_NUMBER0)-zeroPosValue);
	fCosb = (float)(ADC_readResult(COS_ADC_BASE+0x400,ADC_SOC_NUMBER0)-zeroPosValue);

	fineAngle = __atan2puf32((float)(fSina),(float)(fCosb));

	if (fineAngle<0)
	{
		fineAngle = 1.0+fineAngle;
	}

	pos = (double)(count+fineAngle);

	return pos;
}

void HPF_recieveData()
{
	uint16_t i;
	uint8_t checkSumValue = 0;

	while(SCI_getRxFIFOStatus(HPF_UART_BASE) < enc0Data.rxNum);

	for (i = 0; i < enc0Data.rxNum-1; ++i)
	{
		hpfRxDateArr[i] = SCI_readCharBlockingFIFO(HPF_UART_BASE);
		checkSumValue ^= hpfRxDateArr[i];
	}
	hpfRxDateArr[i] = SCI_readCharBlockingFIFO(HPF_UART_BASE);
	enc0Data.checkSum = checkSumValue;

	enc0Data.dataReady = TRUE;
}

