/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hpf_include.h"
#include "log.h"
#include "board.h"
#include "hiperface.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
uint8_t hpf_accessCodeArr[4];		/*  */
HPF_ENC_MSG hpf_enc_typeLabel;		/* Ϣ洢ṹ */
volatile uint8_t hpfRxDateArr[134]; /*  */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

void hpf_dataInit()
{
	enc0Data.addrFrame = HPF_ENC_ADDR_FIELD(0);
	enc0Data.cmdID = 0;
	enc0Data.txNum = 0;
	enc0Data.rxNum = 0;
	enc0Data.errorCode = 0;
	enc0Data.checkSum = 0;
	enc0Data.warningBit = FALSE;
	enc0Data.dataReady = FALSE;

	hpf_accessCodeArr[0] = HPF_ACCESS_CODE0;
	hpf_accessCodeArr[1] = HPF_ACCESS_CODE1;
	hpf_accessCodeArr[2] = HPF_ACCESS_CODE2;
	hpf_accessCodeArr[3] = HPF_ACCESS_CODE3;

}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
	volatile double pos;
	volatile uint32_t beftime,aftime,difftime;

    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    Board_init();

    hpf_dataInit();

    HPF_encInit(HPF_DATA_RATE);

//    HPF_changeEncBandrate();

    __enable_irq();

    while(1)
    {
    	pos = hpf_getAnaAngle(3060);
    	DEVICE_DELAY_US(100);
    }

    return 0;
}

