/*
 * board.c
 *
 *  Created on: 2024 Oct 8
 *      Author: Gejian
 */

#include "board.h"

void GPIO_init()
{
	GPIO_writePin(TFORMAT_GPIO_PWRCTRL, 0);
	GPIO_setPadConfig(TFORMAT_GPIO_PWRCTRL, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(TFORMAT_GPIO_PWRCTRL, GPIO_QUAL_SYNC);
	GPIO_setDirectionMode(TFORMAT_GPIO_PWRCTRL, GPIO_DIR_MODE_OUT);

	GPIO_writePin(TFORMAT_SPI_CS, 1);
	GPIO_setPadConfig(TFORMAT_SPI_CS, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(TFORMAT_SPI_CS, GPIO_QUAL_SYNC);
	GPIO_setDirectionMode(TFORMAT_SPI_CS, GPIO_DIR_MODE_OUT);
}

void PinMux_init()
{
	/* POWER GPIO0 */
	GPIO_setPinConfig(TFOMAT_PWRCTRL_PIN_COMFIG);

	/* SPI CS */
	GPIO_setPinConfig(TFOMAT_CS_PIN_COMFIG);

	/* GPIO22 SPI CLK	 */
	GPIO_setPinConfig(TFORMAT_CLB_OUTPUTXBAR_SPICLK_TEST_PIN_CLBOUTPUTXBAR_PIN_CONFIG);

	/* GPIO47 TXEN	 */
	GPIO_setPinConfig(TFORMAT_CLB_OUTPUTXBAR_TXEN_CLBOUTPUTXBAR_PIN_CONFIG);

	/* SPIA_STE_GP15 */
	GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

	/* SPIA_CLK_GP4 */
	GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	/* SPIA_SIMO_GP7 */
	GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	/* SPIA_SOMI_GP6 */
	GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

}

void CLB_OUTPUTXBAR_init()
{
	/* SPI CLK */
	XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX00_CLB1_OUT1);
	XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_MUX00);

	/* TXEN */
	XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX04_CLB1_OUT5);
	XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2, XBAR_MUX04);
}
