/*
 * board.h
 *
 *  Created on: 2024 Oct 8
 *      Author: Gejian
 */

#ifndef BOARD_H_
#define BOARD_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "device.h"
/*
 * SPIB_SIMO - GPIO Settings
 */
#define GPIO_PIN_SPIB_SIMO 7
#define mySPI0_SPISIMO_GPIO 7
#define mySPI0_SPISIMO_PIN_CONFIG GPIO_7_SPIB_SIMO

/*
 * SPIA_SOMI - GPIO Settings
 */
#define GPIO_PIN_SPIB_SOMI 6
#define mySPI0_SPISOMI_GPIO 6
#define mySPI0_SPISOMI_PIN_CONFIG GPIO_6_SPIB_SOMI

/*
 * SPIA_CLK - GPIO Settings
 */
#define GPIO_PIN_SPIB_CLK 4
#define mySPI0_SPICLK_GPIO 4
#define mySPI0_SPICLK_PIN_CONFIG GPIO_4_SPIB_CLK

/*
 * SPIA_STE - GPIO Settings
 */
#define GPIO_PIN_SPIB_STE 15
#define mySPI0_SPISTE_GPIO 15
#define mySPI0_SPISTE_PIN_CONFIG GPIO_15_SPIB_STE

/*
 * Power up
 */
#define TFORMAT_GPIO_PWRCTRL 0
#define TFOMAT_PWRCTRL_PIN_COMFIG GPIO_0_GPIO0

/*
 * GPIO10 as SPI CS
 */
#define TFORMAT_SPI_CS	10
#define TFOMAT_CS_PIN_COMFIG GPIO_10_GPIO10

/*
 * CLB_OUTPUTXBAR1
 */
#define TFORMAT_CLB_OUTPUTXBAR_SPICLK_TEST_PIN_CLBOUTPUTXBAR_PIN_CONFIG GPIO_22_CLB_OUTPUTXBAR1

/*
 * CLB_OUTPUTXBAR2
 */
#define TFORMAT_CLB_OUTPUTXBAR_TXEN_CLBOUTPUTXBAR_PIN_CONFIG GPIO_47_CLB_OUTPUTXBAR2


void Board_init();
void GPIO_init();
void PinMux_init();
void CLB_OUTPUTXBAR_init();

#ifdef __cplusplus
}
#endif

#endif /* BOARD_H_ */
