//###########################################################################
//
// FILE:   flash_programming.h
//
// TITLE:  flash program header
//
//###########################################################################
#ifndef FLASH_PROGRAMMING_GS32_H_
#define FLASH_PROGRAMMING_GS32_H_

#if IS_GS32F00xx(0x12)
#include "cs12_sector.h"
#elif IS_GS32F00xx(0x30)
#include "cs30_sector.h"
#elif IS_GS32F3xx(0x21,0x22)
#include "cs22_sector.h"
#else
#error "Use the GS32F00xx or GS32F3xx macro to define the specific chip model."
#endif

#ifndef RAMFUNC_T
#define RAMFUNC_T                       __attribute__ ((section (".RamFunc")))
#endif
#ifndef RAM_FUNC_T
#define RAM_FUNC_T                      __attribute__ ((section (".RamFunc")))
#endif

//flash control reg parameter
#define FLASH_DATA_REG_COUNT		4
#define FLASH_WRITE_MIN_PAGE_SIZE		(FLASH_DATA_REG_COUNT*sizeof(uint32))

//flash size define
#define FlashMainSzie2MB        0x200000U
#define FlashMainSzie512KB		0x80000U
#define FlashMainSzie256KB		0x40000U
#define FlashLineNumberOfPage	16U

//define program buff words
#if IS_GS32F00xx(0x12)
#define FlashProgramBuffWordsOf16Bit   (8)
#elif IS_GS32F00xx(0x30)
#define FlashProgramBuffWordsOf16Bit   (8)
#elif IS_GS32F3xx(0x21,0x22)
#define FlashProgramBuffWordsOf16Bit   (8)
#else
#error "Use the GS32F00xx or GS32F3xx macro to define the specific chip model."
#endif

/* This is for 1.1ES and 2.0ES ADC specific initialization */
#if IS_GS32F00xx(0x12)

#define FLASH_CONTROL_ERASE_OKAY	(FLASH_STATUS_WRITE_COMP_STATUS | FLASH_STATUS_DISABLE_REDUND)
#define FLASH_CONTROL_PROGRAM_OKAY  (FLASH_CONTROL_ERASE_OKAY)
#define FLASH_CONTROL_IDLE			(FLASH_STATUS_DISABLE_REDUND)
#define FLASH_CONTROL_ECC			(FLASH_STATUS_SEC_DETECTED|FLASH_STATUS_WRITE_COMP_STATUS)

#elif IS_GS32F3xx(0x21,0x22)

#define FLASH_CONTROL_ERASE_OKAY	(FLASH_STATUS_WRITE_COMP_STATUS | FLASH_STATUS_DISABLE_REDUND)
#define FLASH_CONTROL_PROGRAM_OKAY  (FLASH_CONTROL_ERASE_OKAY)
#define FLASH_CONTROL_IDLE			(FLASH_STATUS_DISABLE_REDUND)
#define FLASH_CONTROL_ECC			(FLASH_STATUS_SEC_DETECTED|FLASH_STATUS_WRITE_COMP_STATUS)

#elif IS_GS32F00xx(0x30)

#define FLASH_CONTROL_ERASE_OKAY	(FLASH_STATUS_WRITE_COMP_STATUS|FLASH_STATUS_DISABLE_REDUND)
#define FLASH_CONTROL_PROGRAM_OKAY  (FLASH_CONTROL_ERASE_OKAY)
#define FLASH_CONTROL_IDLE			(FLASH_STATUS_DISABLE_REDUND)
#define FLASH_CONTROL_ECC			(FLASH_STATUS_SEC_DETECTED|FLASH_STATUS_WRITE_COMP_STATUS)

#else
#error "Use the GS32F00xx or GS32F3xx macro to define the specific chip model."
#endif

#endif /* FLASH_PROGRAMMING_GS32_H_ */
