/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    sysctl_dig.h
*   @brief   digital system top level configuration
*
*/


#ifndef PM_BISSC_INCLUDE_H_
#define PM_BISSC_INCLUDE_H_

#ifdef __cplusplus
extern "C"{
#endif



typedef struct  {                                 // bit descriptions
	uint16_t  cd_status;	// 0 - start new cd; 1 - cd transfer ongoing; 2 - cd rx'd; 3 - cd parsed & complete
	int16_t  remaining_cd_bits;
	uint16_t  cd_bits_to_send;

	uint32_t  cdm;

	uint32_t  cds_stream;
	uint16_t  cds_raw;      // cds without the crc

	uint16_t  cd_register_xfer_address;
	uint16_t  cd_register_xfer_rxdata;
	uint16_t  cd_register_xfer_txdata;
	uint16_t  cd_register_xfer_is_write;

	uint64_t  scd_raw;      //scd without the crc
	uint16_t  scd_crc;
	uint64_t  position;
    uint16_t  scd_error;
    uint16_t  scd_warning;
    uint16_t  crc_incorrect_count;

    uint16_t  dataReady;

    uint32_t sdata[16];     // Send data buffer
    uint32_t rdata[16];     // Receive data buffer
    uint16_t fifo_level;

    uint16_t xfer_address_withCTS;

    volatile struct SPI_REGS *spi;

} BISSC_DATA_STRUCT;


extern BISSC_DATA_STRUCT bissc_data_struct;

extern void PM_bissc_setFreq(uint32_t Freq_us);
extern void PM_bissc_startOperation(void);
extern void PM_bissc_setCDBit(uint32_t);
extern void PM_bissc_setupPeriph(void);
extern uint64_t PM_bissc_getBits (uint16_t len, uint16_t bitsParsed, uint16_t charBits);
extern void PM_bissc_generateCRCTable(uint16_t nBits, uint16_t polynomial, uint16_t *pTable);
extern uint16_t PM_bissc_getCRC(uint16_t input_crc_accum, uint16_t nBitsData,  uint16_t nBitsPoly, uint16_t * msg, uint16_t *crc_table, uint16_t rxLen);
extern void PM_bissc_setupNewSCDTransfer(uint16_t nDataClks, uint16_t spi_fifo_width);





#ifdef __cplusplus
}
#endif

#endif /* PM_endat22_Include*/


