/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

//###########################################################################
//
// FILE:   aes.c
// 2024.7.12 Fanzhe add
//###########################################################################


#ifdef __cplusplus
extern "C"{
#endif

#include "gs32_version.h"

#if IS_GS32F00xx(0x12)

#include "aes.h"

//*****************************************************************************
//
// AES_configMode
//
//*****************************************************************************
GS32_DRIVER_AES_FUNC_T void
AES_configMode(uint32_t base, const AES_ConfigParams *configParams)
{
	__attribute__((aligned(8))) volatile uint32_t srcAddr[2] = {(uint32_t)(configParams->srcAddr), configParams->packetLength};
	__attribute__((aligned(8))) volatile uint32_t desAddr[2] = {(uint32_t)(configParams->destAddr), configParams->destLength};

	HWREG(base + AES_O_STAT_POP) 	= 0U;	// Clear the FIFO to write to the CTRL register
	HWREG(base + AES_O_SRC_PTR) 	= (uint32_t)(srcAddr);
	HWREG(base + AES_O_DST_PTR) 	= (uint32_t)(desAddr);
	HWREG(base + AES_O_PROC_LEN)	= (uint32_t)(configParams->packetLength);
	HWREG(base + AES_O_KEY_SZ)		= (uint32_t)(configParams->keySize);

	if(configParams->keySize != AES_KEY_SIZE_NULL)
	{
		volatile uint32_t keySize4Byte = ((configParams->keySize)& 0x11) / 4;	// Get how many addresses the key accounts for

		for(volatile int i = 0;i<keySize4Byte;i++)
		{
			HWREG(base + AES_O_KEY_CTX+i*4) = HWREG((configParams->keyAddr)+i); //KEY_CTX   Deposit key
		}
	}

	HWREG(base + AES_O_CTRL)		= 	(configParams->direction)|(configParams->cipherMode) | (configParams->cipherAlgorithm) |
										((0x2)<<28)	| (configParams->hashMode) | (configParams->hashAlgorithm);
};


#endif	/* #if IS_GS32F00xx(0x12) */


#ifdef __cplusplus
}
#endif
