/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    driverlib.h
*   @brief   include all driverlib header files for user application
*
*/

#ifndef GS32_DRIVERLIB_H
#define GS32_DRIVERLIB_H

#ifdef __cplusplus
extern "C"{
#endif

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
#include "gs32_version.h"
#include "adc.h"
#include "can.h"
#include "hal_can.h"
#include "cmpss.h"
#include "cpu.h"
#include "cputimer.h"
#include "crc.h"
#include "dac.h"
#include "debug.h"
#include "dma.h"
#include "xdma.h"
#include "ecap.h"
#include "epwm.h"
#include "eqep.h"
#include "flash.h"
#include "gpio.h"
#include "hrpwm.h"
#include "i2c.h"
#include "i2c_v30.h"
#include "pmbus.h"
#include "spi.h"
#include "sysctl.h"
#include "uart.h"
#include "wd.h"
#include "xbar.h"
#include "qspi.h"
#include "lin.h"
#include "clb.h"
#include "sdfm.h"
#include "ipc.h"

#if IS_GS32F3xx()
#include "fsmc.h"
#endif

#include "pinmap.h"

#include "interrupt.h"

#ifdef __cplusplus
}
#endif

#endif  // end of GS32_DRIVERLIB_H definition

