/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  @file   ecap.h
 *  @brief  
 *  [note: This file is automatically generated and does not need to be 
 *  manually edited. If you want to modify it, use the py script to generate]
 *
 *  commit history:
 *  2024/04/17, ZhaoLei, repalce sysctl_xxx.h with sysctl.h
 *  2024/04/23, ZhaoLei, Compatible with 3.0
 */

#ifndef DEVICE_DRIVERLIB_ECAP_H_
#define DEVICE_DRIVERLIB_ECAP_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "gs32_version.h"

#include "inc/hw_ecap.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "sysctl.h"
#include "debug.h"
#include "stdbool.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//*****************************************************************************
//
// Define to mask out the bits in the signal monitoring unit.
//
//*****************************************************************************
#define ECAP_MUNIT_STEP            (ECAP_O_MUNIT_2_CTL - ECAP_O_MUNIT_1_CTL)



//  Maximum Pre-scaler value

#define ECAP_MAX_PRESCALER_VALUE       32U

//  Values that can be passed to ECAP_enableInterrupt(),
//  ECAP_disableInterrupt(), ECAP_clearInterrupt() and ECAP_forceInterrupt() as
//  the intFlags parameter and returned by ECAP_getInterruptSource().

#define ECAP_ISR_SOURCE_CAPTURE_EVENT_1 0x2U    //Event 1 generates interrupt
#define ECAP_ISR_SOURCE_CAPTURE_EVENT_2 0x4U    //Event 2 generates interrupt
#define ECAP_ISR_SOURCE_CAPTURE_EVENT_3 0x8U    //Event 3 generates interrupt
#define ECAP_ISR_SOURCE_CAPTURE_EVENT_4 0x10U   //Event 4 generates interrupt
#define ECAP_ISR_SOURCE_COUNTER_OVERFLOW 0x20U  //Counter overflow generates interrupt
#define ECAP_ISR_SOURCE_COUNTER_PERIOD  0x40U    //Counter equals period generates interrupt
#define ECAP_ISR_SOURCE_COUNTER_COMPARE 0x80U   //Counter equals compare generates interrupt

#if   IS_GS32F00xx(0x30)
//! Monitoring unit 1 error event 1 ISR source
//!
#define ECAP_ISR_SOURCE_MUNIT_1_ERROR_EVT1 0x200U
//! Monitoring unit 1 error event 2 ISR source
//!
#define ECAP_ISR_SOURCE_MUNIT_1_ERROR_EVT2 0x400U
//! Monitoring unit 2 error event 1 ISR source
//!
#define ECAP_ISR_SOURCE_MUNIT_2_ERROR_EVT1 0x800U
//! Monitoring unit 2 error event 2 ISR source
//!
#define ECAP_ISR_SOURCE_MUNIT_2_ERROR_EVT2 0x1000U
#endif
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

//  Values that can be passed to ECAP_setEventPolarity(),ECAP_setCaptureMode(),
//  ECAP_enableCounterResetOnEvent(),ECAP_disableCounterResetOnEvent(),
//  ECAP_getEventTimeStamp(),ECAP_setDMASource() as the \e event parameter.

typedef enum
{
    ECAP_EVENT_1 = 0U,   //eCAP event 1
    ECAP_EVENT_2 = 1U,   //eCAP event 2
    ECAP_EVENT_3 = 2U,   //eCAP event 3
    ECAP_EVENT_4 = 3U    //eCAP event 4
}ECAP_Events;

//  Values that can be passed to ECAP_setEventPolarity() as the \e polarity parameter.

typedef enum
{
    ECAP_EVENT_RISING_EDGE   = 0U, //Rising edge polarity
	ECAP_EVNT_RISING_EDGE   = 0U,
    ECAP_EVENT_FALLING_EDGE  = 1U,  //Falling edge polarity
	ECAP_EVNT_FALLING_EDGE  = 1U
}ECAP_EventPolarity;

//  Values that can be passed to ECAP_setCaptureMode() as the \e mode parameter.

typedef enum
{
    ECAP_CONTINUOUS_CAPTURE_MODE    = 0U,   //eCAP operates in continuous capture mode
    ECAP_ONE_SHOT_CAPTURE_MODE      = 1U    //eCAP operates in one shot capture mode
}ECAP_CaptureMode;

//  Values that can be passed to ECAP_setSyncInPulseSource() as the \e mode parameter.


//  Values that can be passed to ECAP_setSyncOutMode() as the \e mode parameter.

typedef enum
{
    ECAP_SYNC_OUT_SYNCI         = 0x00U,    //sync out on the sync in signal and software force
    ECAP_SYNC_OUT_COUNTER_PRD   = 0x40U,    //sync out on counter equals period
    ECAP_SYNC_OUT_DISABLED      = 0x80U     //Disable sync out signal
}ECAP_SyncOutMode;

//  Values that can be passed to ECAP_setAPWMPolarity() as the \e polarity parameter.

typedef enum
{
    ECAP_APWM_ACTIVE_HIGH   = 0x000U, //APWM is active high
    ECAP_APWM_ACTIVE_LOW    = 0x400U  //APWM is active low
}ECAP_APWMPolarity;

//*****************************************************************************
//
// Values that can be passed to HRCAP_enableCalibrationInterrupt(),
// HRCAP_disableCalibrationInterrupt() as the intFlags parameter and
// HRCAP_clearCalibrationFlags() and HRCAP_forceCalibrationFlags() as the flags
// parameter and returned by HRCAP_getCalibrationFlags().
//
//*****************************************************************************
//! Global calibration interrupt flag
//!
#define HRCAP_GLOBAL_CALIBRATION_INTERRUPT 0x1U
//! Calibration done flag
//!
#define HRCAP_CALIBRATION_DONE  0x2U
//! Calibration period overflow flag
//!
#define HRCAP_CALIBRATION_PERIOD_OVERFLOW  0x4U

//*****************************************************************************
//
//! Values that can be passed to HRCAP_getCalibrationClockPeriod() as the
//! \e clockSource parameter.
//
//*****************************************************************************
typedef enum
{
    HRCAP_CALIBRATION_CLOCK_SYSCLK = 0x0, //!< Use SYSCLK for period match.
    HRCAP_CALIBRATION_CLOCK_HRCLK  = 0x8  //!< Use HRCLK for period match.
}HRCAP_CalibrationClockSource;

//*****************************************************************************
//
//! Values that can be passed to HRCAP_setCalibrationMode(),
//! as the \e continuousMode parameter.
//
//*****************************************************************************
typedef enum
{
    //! Continuous calibration disabled.
    HRCAP_CONTINUOUS_CALIBRATION_DISABLED = 0x00,
    //! Continuous calibration enabled.
    HRCAP_CONTINUOUS_CALIBRATION_ENABLED =  0x20
}HRCAP_ContinuousCalibrationMode;


//*****************************************************************************
//
//! Values that can be passed to MUNIT_Monitoring(),
//! as the \e MUNIT parameter.
//
//*****************************************************************************
typedef enum
{
    ECAP_MONITORING_UNIT_1  = 0,
    ECAP_MONITORING_UNIT_2  = 1,
}MUNIT_Number;


typedef enum
{
	SysclkDiv2  = 0,
	SysclkDiv3  = 1,
	SysclkDiv4  = 2,
	SysclkDiv5  = 3,
}CLK_DIVNUM;



//  Values that can be passed to ECAP_selectECAPInput() as the \e input parameter.
#if IS_GS32F00xx(0x10)
typedef enum
{
    //! GPIO43
    ECAP_INPUT_GPIO43 = 0,
    //! GPIO42
    ECAP_INPUT_GPIO42 = 1,
    //! GPIO41
    ECAP_INPUT_GPIO41 = 2,
    //! GPIO40
    ECAP_INPUT_GPIO40 = 3,
    //! GPIO39
    ECAP_INPUT_GPIO39 = 4,
    //! GPIO38
    ECAP_INPUT_GPIO38 = 5,
    //! GPIO37
    ECAP_INPUT_GPIO37 = 6,
    //! GPIO36
    ECAP_INPUT_GPIO36 = 7,
    //! GPIO35
    ECAP_INPUT_GPIO35 = 8,
    //! GPIO34
    ECAP_INPUT_GPIO34 = 9,
    //! GPIO33
    ECAP_INPUT_GPIO33 = 10,
    //! GPIO32
    ECAP_INPUT_GPIO32 = 11,
    //! GPIO31
    ECAP_INPUT_GPIO31 = 12,
    //! GPIO30
    ECAP_INPUT_GPIO30 = 13,
    //! GPIO29
    ECAP_INPUT_GPIO29 = 14,
    //! GPIO28
    ECAP_INPUT_GPIO28 = 15,
    //! GPIO27
    ECAP_INPUT_GPIO27 = 16,
    //! GPIO26
    ECAP_INPUT_GPIO26 = 17,
    //! GPIO25
    ECAP_INPUT_GPIO25 = 18,
    //! GPIO24
    ECAP_INPUT_GPIO24 = 19,
    //! GPIO23
	ECAP_INPUT_GPIO23 = 20,
    //! GPIO22
	ECAP_INPUT_GPIO22 = 21,
    //! GPIO21
	ECAP_INPUT_GPIO21 = 22,
    //! GPIO20
	ECAP_INPUT_GPIO20 = 23,
    //! GPIO19
	ECAP_INPUT_GPIO19 = 24,
    //! GPIO18
	ECAP_INPUT_GPIO18 = 25,
    //! GPIO17
	ECAP_INPUT_GPIO17 = 26,
    //! GPIO16
	ECAP_INPUT_GPIO16 = 27,
    //! GPIO15
	ECAP_INPUT_GPIO15 = 28,
    //! GPIO14
	ECAP_INPUT_GPIO14 = 29,
    //! GPIO13
	ECAP_INPUT_GPIO13 = 30,
    //! GPIO12
	ECAP_INPUT_GPIO12 = 31,
    //! GPIO11
	ECAP_INPUT_GPIO11 = 32,
    //! GPIO10
	ECAP_INPUT_GPIO10 = 33,
    //! GPIO9
	ECAP_INPUT_GPIO9 = 34,
    //! GPIO8
	ECAP_INPUT_GPIO8 = 35,
    //! GPIO7
	ECAP_INPUT_GPIO7 = 36,
    //! GPIO6
	ECAP_INPUT_GPIO6 = 37,
    //! GPIO5
	ECAP_INPUT_GPIO5 = 38,
    //! GPIO4
	ECAP_INPUT_GPIO4 = 39,
    //! GPIO3
	ECAP_INPUT_GPIO3 = 40,
    //! GPIO2
	ECAP_INPUT_GPIO2 = 41,
    //! GPIO1
	ECAP_INPUT_GPIO1 = 42,
    //! GPIO0
	ECAP_INPUT_GPIO0 = 43,
    //! OUTPUTXBAR_OUTPUT8
	ECAP_INPUT_OUTPUTXBAR8 = 44,
    //! OUTPUTXBAR_OUTPUT7
	ECAP_INPUT_OUTPUTXBAR7 = 45,
    //! OUTPUTXBAR_OUTPUT6
	ECAP_INPUT_OUTPUTXBAR6 = 46,
    //! OUTPUTXBAR_OUTPUT5
	ECAP_INPUT_OUTPUTXBAR5 = 47,
    //! OUTPUTXBAR_OUTPUT4
	ECAP_INPUT_OUTPUTXBAR4 = 48,
    //! OUTPUTXBAR_OUTPUT3
	ECAP_INPUT_OUTPUTXBAR3 = 49,
    //! OUTPUTXBAR_OUTPUT2
	ECAP_INPUT_OUTPUTXBAR2 = 50,
    //! OUTPUTXBAR_OUTPUT1
	ECAP_INPUT_OUTPUTXBAR1 = 51,
    //! INPUTXBAR_SEL16_OUT
	ECAP_INPUT_INPUTXBAR16 = 52,
    //! INPUTXBAR_SEL15_OUT
	ECAP_INPUT_INPUTXBAR15 = 53,
    //! INPUTXBAR_SEL14_OUT
	ECAP_INPUT_INPUTXBAR14 = 54,
    //! INPUTXBAR_SEL13_OUT
	ECAP_INPUT_INPUTXBAR13 = 55,
    //! INPUTXBAR_SEL12_OUT
	ECAP_INPUT_INPUTXBAR12 = 56,
    //! INPUTXBAR_SEL11_OUT
	ECAP_INPUT_INPUTXBAR11 = 57,
    //! INPUTXBAR_SEL10_OUT
	ECAP_INPUT_INPUTXBAR10 = 58,
    //! INPUTXBAR_SEL9_OUT
	ECAP_INPUT_INPUTXBAR9 = 59,
    //! INPUTXBAR_SEL8_OUT
	ECAP_INPUT_INPUTXBAR8 = 60,
    //! INPUTXBAR_SEL7_OUT
	ECAP_INPUT_INPUTXBAR7 = 61,
    //! INPUTXBAR_SEL6_OUT
	ECAP_INPUT_INPUTXBAR6 = 62,
    //! INPUTXBAR_SEL5_OUT
	ECAP_INPUT_INPUTXBAR5 = 63,
    //! INPUTXBAR_SEL4_OUT
	ECAP_INPUT_INPUTXBAR4 = 64,
    //! INPUTXBAR_SEL3_OUT
	ECAP_INPUT_INPUTXBAR3 = 65,
    //! INPUTXBAR_SEL2_OUT
	ECAP_INPUT_INPUTXBAR2 = 66,
    //! INPUTXBAR_SEL1_OUT
	ECAP_INPUT_INPUTXBAR1 = 67,
    //! PLU1_LC3_OUT0
	ECAP_INPUT_PLU1_LC3_OUT0 = 68,
    //! PLU1_LC3_OUT1
	ECAP_INPUT_PLU1_LC3_OUT1 = 69,
    //! PLU1_LC3_OUT2
	ECAP_INPUT_PLU1_LC3_OUT2 = 70,
    //! PLU1_LC3_OUT3
	ECAP_INPUT_PLU1_LC3_OUT3 = 71,
    //! PLU1_LC2_OUT0
	ECAP_INPUT_PLU1_LC2_OUT0 = 72,
    //! PLU1_LC2_OUT1
	ECAP_INPUT_PLU1_LC2_OUT1 = 73,
    //! PLU1_LC2_OUT2
	ECAP_INPUT_PLU1_LC2_OUT2 = 74,
    //! PLU1_LC2_OUT3
	ECAP_INPUT_PLU1_LC2_OUT3 = 75,
    //! PLU1_LC1_OUT0
	ECAP_INPUT_PLU1_LC1_OUT0 = 76,
    //! PLU1_LC1_OUT1
	ECAP_INPUT_PLU1_LC1_OUT1 = 77,
    //! PLU1_LC1_OUT2
	ECAP_INPUT_PLU1_LC1_OUT2 = 78,
    //! PLU1_LC1_OUT3
	ECAP_INPUT_PLU1_LC1_OUT3 = 79,
    //! CANB_INT
	ECAP_INPUT_CANB_INT = 80,
    //! CANA_INT
	ECAP_INPUT_CANA_INT = 81,
    //! ADCC_Event4
	ECAP_INPUT_ADC_C_EVENT4 = 82,
    //! ADCC_Event3
	ECAP_INPUT_ADC_C_EVENT3 = 83,
    //! ADCC_Event2
	ECAP_INPUT_ADC_C_EVENT2 = 84,
    //! ADCC_Event1
	ECAP_INPUT_ADC_C_EVENT1 = 85,
    //! ADCB_Event4
	ECAP_INPUT_ADC_B_EVENT4 = 86,
    //! ADCB_Event3
	ECAP_INPUT_ADC_B_EVENT3 = 87,
    //! ADCB_Event2
	ECAP_INPUT_ADC_B_EVENT2 = 88,
    //! ADCB_Event1
	ECAP_INPUT_ADC_B_EVENT1 = 89,
    //! ADCA_Event4
	ECAP_INPUT_ADC_A_EVENT4 = 90,
    //! ADCA_Event3
	ECAP_INPUT_ADC_A_EVENT3 = 91,
    //! ADCA_Event2
	ECAP_INPUT_ADC_A_EVENT2 = 92,
	//! ADCA_Event1
	ECAP_INPUT_ADC_A_EVENT1 = 93,
    //! SDFM1_FLT4_COMPARE_Z
    ECAP_INPUT_SDFM1_FLT4_COMPARE_Z = 94,
    //! SDFM1_FLT4_COMPARE_LOW
    ECAP_INPUT_SDFM1_FLT4_COMPARE_LOW = 95,
    //! SDFM1_FLT4_COMPARE_HIGH
    ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH = 96,
    //! SDFM1_FLT3_COMPARE_Z
    ECAP_INPUT_SDFM1_FLT3_COMPARE_Z = 97,
    //! SDFM1_FLT3_COMPARE_LOW
    ECAP_INPUT_SDFM1_FLT3_COMPARE_LOW = 98,
    //! SDFM1_FLT3_COMPARE_HIGH
    ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH = 99,
    //! SDFM1_FLT2_COMPARE_Z
    ECAP_INPUT_SDFM1_FLT2_COMPARE_Z = 100,
    //! SDFM1_FLT2_COMPARE_LOW
    ECAP_INPUT_SDFM1_FLT2_COMPARE_LOW = 101,
    //! SDFM1_FLT2_COMPARE_HIGH
    ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH = 102,
    //! SDFM1_FLT1_COMPARE_Z
    ECAP_INPUT_SDFM1_FLT1_COMPARE_Z = 103,
    //! SDFM1_FLT1_COMPARE_LOW
    ECAP_INPUT_SDFM1_FLT1_COMPARE_LOW = 104,
    //! SDFM1_FLT1_COMPARE_HIGH
    ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH = 105,
    //! CMPSS7_CTRIP_LOW
    ECAP_INPUT_CMPSS7_CTRIP_LOW = 106,
    //! CMPSS6_CTRIP_LOW
    ECAP_INPUT_CMPSS6_CTRIP_LOW = 107,
    //! CMPSS5_CTRIP_LOW
    ECAP_INPUT_CMPSS5_CTRIP_LOW = 108,
    //! CMPSS4_CTRIP_LOW
    ECAP_INPUT_CMPSS4_CTRIP_LOW = 109,
    //! CMPSS3_CTRIP_LOW
    ECAP_INPUT_CMPSS3_CTRIP_LOW = 110,
    //! CMPSS2_CTRIP_LOW
    ECAP_INPUT_CMPSS2_CTRIP_LOW = 111,
    //! CMPSS1_CTRIP_LOW
    ECAP_INPUT_CMPSS1_CTRIP_LOW = 112,
    //! CMPSS7_CTRIP_HIGH
    ECAP_INPUT_CMPSS7_CTRIP_HIGH = 113,
    //! CMPSS6_CTRIP_HIGH
    ECAP_INPUT_CMPSS6_CTRIP_HIGH = 114,
    //! CMPSS5_CTRIP_HIGH
    ECAP_INPUT_CMPSS5_CTRIP_HIGH = 115,
    //! CMPSS4_CTRIP_HIGH
    ECAP_INPUT_CMPSS4_CTRIP_HIGH = 116,
    //! CMPSS3_CTRIP_HIGH
    ECAP_INPUT_CMPSS3_CTRIP_HIGH = 117,
    //! CMPSS2_CTRIP_HIGH
    ECAP_INPUT_CMPSS2_CTRIP_HIGH = 118,
    //! CMPSS1_CTRIP_HIGH
    ECAP_INPUT_CMPSS1_CTRIP_HIGH = 119,
    //! CMPSS7_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS7_CTRIP_HIGH_OR_LOW = 120,
    //! CMPSS6_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS6_CTRIP_HIGH_OR_LOW = 121,
    //! CMPSS5_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS5_CTRIP_HIGH_OR_LOW = 122,
    //! CMPSS4_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS4_CTRIP_HIGH_OR_LOW = 123,
    //! CMPSS3_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS3_CTRIP_HIGH_OR_LOW = 124,
    //! CMPSS2_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS2_CTRIP_HIGH_OR_LOW = 125,
    //! CMPSS1_CTRIP_HIGH_OR_LOW
    ECAP_INPUT_CMPSS1_CTRIP_HIGH_OR_LOW = 126,
    //! fixed connection to 0
    ECAP_INPUT_ZERO = 127,
}ECAP_InputCaptureSignals;
#elif IS_GS32F00xx(0x12)
typedef enum
{

	//! INPUTXBAR_SEL1_OUT
	ECAP_INPUT_INPUTXBAR1 = 0,
	//! INPUTXBAR_SEL2_OUT
	ECAP_INPUT_INPUTXBAR2 = 1,
	//! INPUTXBAR_SEL3_OUT
	ECAP_INPUT_INPUTXBAR3 = 2,
	//! INPUTXBAR_SEL4_OUT
	ECAP_INPUT_INPUTXBAR4 = 3,
	//! INPUTXBAR_SEL5_OUT
	ECAP_INPUT_INPUTXBAR5 = 4,
	//! INPUTXBAR_SEL6_OUT
	ECAP_INPUT_INPUTXBAR6 = 5,
	//! INPUTXBAR_SEL7_OUT
	ECAP_INPUT_INPUTXBAR7 = 6,
	//! INPUTXBAR_SEL8_OUT
	ECAP_INPUT_INPUTXBAR8 = 7,
	//! INPUTXBAR_SEL9_OUT
	ECAP_INPUT_INPUTXBAR9 = 8,
	//! INPUTXBAR_SEL10_OUT
	ECAP_INPUT_INPUTXBAR10 = 9,
	//! INPUTXBAR_SEL11_OUT
	ECAP_INPUT_INPUTXBAR11 = 10,
	//! INPUTXBAR_SEL12_OUT
	ECAP_INPUT_INPUTXBAR12 = 11,
	//! INPUTXBAR_SEL13_OUT
	ECAP_INPUT_INPUTXBAR13 = 12,
	//! INPUTXBAR_SEL14_OUT
	ECAP_INPUT_INPUTXBAR14 = 13,
	//! INPUTXBAR_SEL15_OUT
	ECAP_INPUT_INPUTXBAR15 = 14,
	//! INPUTXBAR_SEL16_OUT
	ECAP_INPUT_INPUTXBAR16 = 15,
    //! PLU1_LC1_OUT0
    ECAP_INPUT_PLU1_LC1_OUT0 = 16,
    //! PLU1_LC1_OUT1
    ECAP_INPUT_PLU1_LC1_OUT1 = 17,
    //! PLU1_LC1_OUT2
    ECAP_INPUT_PLU1_LC1_OUT2 = 18,
    //! PLU1_LC1_OUT3
    ECAP_INPUT_PLU1_LC1_OUT3 = 19,
    //! CANA INT0 Input
    ECAP_INPUT_CANA_INT0 = 20,
    //! CANA INT1 Input
    ECAP_INPUT_CANA_INT1 = 21,
    //! Output Xbar Output-1
    ECAP_INPUT_OUTPUTXBAR1 = 24,
    //! Output Xbar Output-2
    ECAP_INPUT_OUTPUTXBAR2 = 25,
    //! Output Xbar Output-3
    ECAP_INPUT_OUTPUTXBAR3 = 26,
    //! Output Xbar Output-4
    ECAP_INPUT_OUTPUTXBAR4 = 27,
    //! Output Xbar Output-5
    ECAP_INPUT_OUTPUTXBAR5 = 28,
    //! Output Xbar Output-6
    ECAP_INPUT_OUTPUTXBAR6 = 29,
    //! Output Xbar Output-7
    ECAP_INPUT_OUTPUTXBAR7 = 30,
    //! Output Xbar Output-8
    ECAP_INPUT_OUTPUTXBAR8 = 31,
    //! ADCC Event1
    ECAP_INPUT_ADC_C_EVENT1 = 36,
    //! ADCC Event2
    ECAP_INPUT_ADC_C_EVENT2 = 37,
    //! ADCC Event3
    ECAP_INPUT_ADC_C_EVENT3 = 38,
    //! ADCC Event4
    ECAP_INPUT_ADC_C_EVENT4 = 39,
    //! ADCB Event1
    ECAP_INPUT_ADC_B_EVENT1 = 40,
    //! ADCB Event2
    ECAP_INPUT_ADC_B_EVENT2 = 41,
    //! ADCB Event3
    ECAP_INPUT_ADC_B_EVENT3 = 42,
    //! ADCB Event4
    ECAP_INPUT_ADC_B_EVENT4 = 43,
    //! ADCA Event1
    ECAP_INPUT_ADC_A_EVENT1 = 44,
    //! ADCA Event2
    ECAP_INPUT_ADC_A_EVENT2 = 45,
    //! ADCA Event3
    ECAP_INPUT_ADC_A_EVENT3 = 46,
    //! ADCA Event4
    ECAP_INPUT_ADC_A_EVENT4 = 47,
    //! Output Xbar Output-9
	ECAP_INPUT_OUTPUTXBAR9 = 48,
	//! Output Xbar Output-10
	ECAP_INPUT_OUTPUTXBAR10 = 49,
	//! Output Xbar Output-11
	ECAP_INPUT_OUTPUTXBAR11 = 50,
	//! Output Xbar Output-12
	ECAP_INPUT_OUTPUTXBAR12 = 51,
	//! PLU1_LC2_OUT0
	ECAP_INPUT_PLU1_LC2_OUT0 =56,
	//! PLU1_LC2_OUT1
	ECAP_INPUT_PLU1_LC2_OUT1 =57,
	//! PLU1_LC2_OUT2
	ECAP_INPUT_PLU1_LC2_OUT2 =58,
	//! PLU1_LC2_OUT3
	ECAP_INPUT_PLU1_LC2_OUT3 =59,
    //! SDFM-2 Filter-1 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_LOW = 60,
    //! SDFM-2 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_LOW = 61,
    //! SDFM-2 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_LOW = 62,
    //! SDFM-2 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_LOW = 63,
    //! SDFM-1 Filter-1 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_LOW = 64,
    //! SDFM-1 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_LOW = 65,
    //! SDFM-1 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_LOW = 66,
    //! SDFM-1 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_LOW = 67,
    //! SDFM-2 Filter-1 Compare Z Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_Z = 68,
    //! SDFM-2 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_Z = 69,
    //! SDFM-2 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_Z = 70,
    //! SDFM-2 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_Z = 71,
    //! SDFM-1 Filter-1 Compare Z Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_Z = 72,
    //! SDFM-1 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_Z = 73,
    //! SDFM-1 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_Z = 74,
    //! SDFM-1 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_Z = 75,
    //! SDFM-2 Filter-1 Compare High Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_HIGH = 76,
    //! SDFM-2 Filter-2 Compare High Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_HIGH = 77,
    //! SDFM-2 Filter-3 Compare High Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_HIGH = 78,
    //! SDFM-2 Filter-4 Compare High Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_HIGH = 79,
    //! SDFM-1 Filter-1 Compare High Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH = 80,
    //! SDFM-1 Filter-2 Compare High Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH = 81,
    //! SDFM-1 Filter-3 Compare High Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH = 82,
    //! SDFM-1 Filter-4 Compare High Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH = 83,
    //! SDFM-2 Filter-1 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_HIGH_OR_LOW = 84,
    //! SDFM-2 Filter-2 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_HIGH_OR_LOW = 85,
    //! SDFM-2 Filter-3 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_HIGH_OR_LOW = 86,
    //! SDFM-2 Filter-4 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_HIGH_OR_LOW = 87,
    //! SDFM-1 Filter-1 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH_OR_LOW = 88,
    //! SDFM-1 Filter-2 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH_OR_LOW = 89,
    //! SDFM-1 Filter-3 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH_OR_LOW = 90,
    //! SDFM-1 Filter-4 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH_OR_LOW = 91,
    //! Compare Subsystem-1 Low Trip
    ECAP_INPUT_CMPSS1_CTRIP_LOW = 96,
    //! Compare Subsystem-2 Low Trip
    ECAP_INPUT_CMPSS2_CTRIP_LOW = 97,
    //! Compare Subsystem-3 Low Trip
    ECAP_INPUT_CMPSS3_CTRIP_LOW = 98,
    //! Compare Subsystem-4 Low Trip
    ECAP_INPUT_CMPSS4_CTRIP_LOW = 99,
    //! Compare Subsystem-5 Low Trip
    ECAP_INPUT_CMPSS5_CTRIP_LOW = 100,
    //! Compare Subsystem-6 Low Trip
    ECAP_INPUT_CMPSS6_CTRIP_LOW = 101,
    //! Compare Subsystem-7 Low Trip
    ECAP_INPUT_CMPSS7_CTRIP_LOW = 102,
    //! Compare Subsystem-1 High Trip
    ECAP_INPUT_CMPSS1_CTRIP_HIGH = 108,
    //! Compare Subsystem-2 High Trip
    ECAP_INPUT_CMPSS2_CTRIP_HIGH = 109,
    //! Compare Subsystem-3 High Trip
    ECAP_INPUT_CMPSS3_CTRIP_HIGH = 110,
    //! Compare Subsystem-4 High Trip
    ECAP_INPUT_CMPSS4_CTRIP_HIGH = 111,
    //! Compare Subsystem-5 High Trip
	ECAP_INPUT_CMPSS5_CTRIP_HIGH = 112,
	//! Compare Subsystem-6 High Trip
	ECAP_INPUT_CMPSS6_CTRIP_HIGH = 113,
	//! Compare Subsystem-7 High Trip
	ECAP_INPUT_CMPSS7_CTRIP_HIGH = 114,
    //! GPIO8
    ECAP_INPUT_GPIO8 = 115,
    //! GPIO9
    ECAP_INPUT_GPIO9 = 116,
    //! GPIO22
    ECAP_INPUT_GPIO22 = 117,
    //! GPIO23
    ECAP_INPUT_GPIO23 = 118,
    //! Compare Subsystem-1 High Trip or Low Trip
    ECAP_INPUT_CMPSS1_CTRIP_HIGH_OR_LOW = 120,
    //! Compare Subsystem-2 High Trip or Low Trip
    ECAP_INPUT_CMPSS2_CTRIP_HIGH_OR_LOW = 121,
    //! Compare Subsystem-3 High Trip or Low Trip
    ECAP_INPUT_CMPSS3_CTRIP_HIGH_OR_LOW = 122,
    //! Compare Subsystem-4 High Trip or Low Trip
    ECAP_INPUT_CMPSS4_CTRIP_HIGH_OR_LOW = 123,
    //! Compare Subsystem-5 High Trip or Low Trip
    ECAP_INPUT_CMPSS5_CTRIP_HIGH_OR_LOW = 124,
    //! Compare Subsystem-6 High Trip or Low Trip
    ECAP_INPUT_CMPSS6_CTRIP_HIGH_OR_LOW = 125,
    //! Compare Subsystem-7 High Trip or Low Trip
    ECAP_INPUT_CMPSS7_CTRIP_HIGH_OR_LOW = 126,
	//! INPUTXBAR_SEL7_OUT
	ECAP_INPUT_ECAP1_INPUTXBAR7 = 127,
	//! INPUTXBAR_SEL8_OUT
	ECAP_INPUT_ECAP2_INPUTXBAR8 = 127,
	//! INPUTXBAR_SEL9_OUT
	ECAP_INPUT_ECAP3_INPUTXBAR9 = 127,
	//! INPUTXBAR_SEL10_OUT
	ECAP_INPUT_ECAP4_INPUTXBAR10 = 127,
	//! INPUTXBAR_SEL11_OUT
	ECAP_INPUT_ECAP5_INPUTXBAR11 = 127,
	//! INPUTXBAR_SEL12_OUT
	ECAP_INPUT_ECAP6_INPUTXBAR12 = 127,
	//! INPUTXBAR_SEL13_OUT
	ECAP_INPUT_ECAP6_INPUTXBAR13 = 127,
	//! PLU1_LC3_OUT0
	ECAP_INPUT_PLU1_LC3_OUT0 = 190,
	//! PLU1_LC3_OUT1
	ECAP_INPUT_PLU1_LC3_OUT1 = 191,
	//! PLU1_LC3_OUT2
	ECAP_INPUT_PLU1_LC3_OUT2 = 192,
	//! PLU1_LC3_OUT3
	ECAP_INPUT_PLU1_LC3_OUT3 = 193,
	//! PLU2_LC1_OUT0
	ECAP_INPUT_PLU2_LC1_OUT0 = 194,
	//! PLU2_LC1_OUT1
	ECAP_INPUT_PLU2_LC1_OUT1 = 195,
	//! PLU2_LC1_OUT2
	ECAP_INPUT_PLU2_LC1_OUT2 = 196,
	//! PLU2_LC1_OUT3
	ECAP_INPUT_PLU2_LC1_OUT3 = 197,
	//! PLU2_LC2_OUT0
	ECAP_INPUT_PLU2_LC2_OUT0 = 198,
	//! PLU2_LC2_OUT1
	ECAP_INPUT_PLU2_LC2_OUT1 = 199,
	//! PLU2_LC2_OUT2
	ECAP_INPUT_PLU2_LC2_OUT2 = 200,
	//! PLU2_LC2_OUT3
	ECAP_INPUT_PLU2_LC2_OUT3 = 201,
	//! PLU2_LC3_OUT0
	ECAP_INPUT_PLU2_LC3_OUT0 = 202,
	//! PLU2_LC3_OUT1
	ECAP_INPUT_PLU2_LC3_OUT1 = 203,
	//! PLU2_LC3_OUT2
	ECAP_INPUT_PLU2_LC3_OUT2 = 204,
	//! PLU2_LC3_OUT3
	ECAP_INPUT_PLU2_LC3_OUT3 = 205,
	//! PLU3_LC1_OUT0
	ECAP_INPUT_PLU3_LC1_OUT0 = 206,
	//! PLU3_LC1_OUT1
	ECAP_INPUT_PLU3_LC1_OUT1 = 207,
	//! PLU3_LC1_OUT2
	ECAP_INPUT_PLU3_LC1_OUT2 = 208,
	//! PLU3_LC1_OUT3
	ECAP_INPUT_PLU3_LC1_OUT3 = 209,
	//! PLU3_LC2_OUT0
	ECAP_INPUT_PLU3_LC2_OUT0 = 210,
	//! PLU3_LC2_OUT1
	ECAP_INPUT_PLU3_LC2_OUT1 = 211,
	//! PLU3_LC2_OUT2
	ECAP_INPUT_PLU3_LC2_OUT2 = 212,
	//! PLU3_LC2_OUT3
	ECAP_INPUT_PLU3_LC2_OUT3 = 213,
	//! PLU3_LC3_OUT0
	ECAP_INPUT_PLU3_LC3_OUT0 = 214,
	//! PLU3_LC3_OUT1
	ECAP_INPUT_PLU3_LC3_OUT1 = 215,
	//! PLU3_LC3_OUT2
	ECAP_INPUT_PLU3_LC3_OUT2 = 216,
	//! PLU3_LC3_OUT3
	ECAP_INPUT_PLU3_LC3_OUT3 = 217,
	//! PLU4_LC1_OUT0
	ECAP_INPUT_PLU4_LC1_OUT0 = 218,
	//! PLU4_LC1_OUT1
	ECAP_INPUT_PLU4_LC1_OUT1 = 219,
	//! PLU4_LC1_OUT2
	ECAP_INPUT_PLU4_LC1_OUT2 = 220,
	//! PLU4_LC1_OUT3
	ECAP_INPUT_PLU4_LC1_OUT3 = 221,
	//! PLU4_LC2_OUT0
	ECAP_INPUT_PLU4_LC2_OUT0 = 222,
	//! PLU4_LC2_OUT1
	ECAP_INPUT_PLU4_LC2_OUT1 = 223,
	//! PLU4_LC2_OUT2
	ECAP_INPUT_PLU4_LC2_OUT2 = 224,
	//! PLU4_LC2_OUT3
	ECAP_INPUT_PLU4_LC2_OUT3 = 225,
	//! PLU4_LC3_OUT0
	ECAP_INPUT_PLU4_LC3_OUT0 = 226,
	//! PLU4_LC3_OUT1
	ECAP_INPUT_PLU4_LC3_OUT1 = 227,
	//! PLU4_LC3_OUT2
	ECAP_INPUT_PLU4_LC3_OUT2 = 228,
	//! PLU4_LC3_OUT3
	ECAP_INPUT_PLU4_LC3_OUT3 = 229,

}ECAP_InputCaptureSignals;

#elif IS_GS32F00xx(0x30) || IS_GS32F3xx(0x22)

typedef enum
{

	//! INPUTXBAR_SEL1_OUT
	ECAP_INPUT_INPUTXBAR1 = 0,
	//! INPUTXBAR_SEL2_OUT
	ECAP_INPUT_INPUTXBAR2 = 1,
	//! INPUTXBAR_SEL3_OUT
	ECAP_INPUT_INPUTXBAR3 = 2,
	//! INPUTXBAR_SEL4_OUT
	ECAP_INPUT_INPUTXBAR4 = 3,
	//! INPUTXBAR_SEL5_OUT
	ECAP_INPUT_INPUTXBAR5 = 4,
	//! INPUTXBAR_SEL6_OUT
	ECAP_INPUT_INPUTXBAR6 = 5,
	//! INPUTXBAR_SEL7_OUT
	ECAP_INPUT_INPUTXBAR7 = 6,
	//! INPUTXBAR_SEL8_OUT
	ECAP_INPUT_INPUTXBAR8 = 7,
	//! INPUTXBAR_SEL9_OUT
	ECAP_INPUT_INPUTXBAR9 = 8,
	//! INPUTXBAR_SEL10_OUT
	ECAP_INPUT_INPUTXBAR10 = 9,
	//! INPUTXBAR_SEL11_OUT
	ECAP_INPUT_INPUTXBAR11 = 10,
	//! INPUTXBAR_SEL12_OUT
	ECAP_INPUT_INPUTXBAR12 = 11,
	//! INPUTXBAR_SEL13_OUT
	ECAP_INPUT_INPUTXBAR13 = 12,
	//! INPUTXBAR_SEL14_OUT
	ECAP_INPUT_INPUTXBAR14 = 13,
	//! INPUTXBAR_SEL15_OUT
	ECAP_INPUT_INPUTXBAR15 = 14,
	//! INPUTXBAR_SEL16_OUT
	ECAP_INPUT_INPUTXBAR16 = 15,
    //! PLU1_LC1_OUT0
    ECAP_INPUT_PLU1_LC1_OUT0 = 16,
    //! CLB1 CLBOUT14 input for ECAP1 instance
    ECAP_INPUT_ECAP1_CLB1_CLBOUT14 = 16,
    //! CLB2 CLBOUT14 input for ECAP2 instance
    ECAP_INPUT_ECAP2_CLB2_CLBOUT14 = 16,
    //! CLB1 CLBOUT14 input for ECAP3 instance
    ECAP_INPUT_ECAP3_CLB1_CLBOUT14 = 16,
    //! PLU1_LC1_OUT1
    ECAP_INPUT_PLU1_LC1_OUT1 = 17,
    //! CLB1 CLBOUT15 input for ECAP1 instance
    ECAP_INPUT_ECAP1_CLB1_CLBOUT15 = 17,
    //! CLB2 CLBOUT15 input for ECAP2 instance
    ECAP_INPUT_ECAP2_CLB2_CLBOUT15 = 17,
    //! CLB1 CLBOUT15 input for ECAP3 instance
    ECAP_INPUT_ECAP3_CLB1_CLBOUT15 = 17,
    //! PLU1_LC1_OUT2
    ECAP_INPUT_PLU1_LC1_OUT2 = 18,
    //! CLB2 CLBOUT14 input for ECAP1 instance
    ECAP_INPUT_ECAP1_CLB2_CLBOUT14 = 18,
    //! CLB1 CLBOUT14 input for ECAP2 instance
    ECAP_INPUT_ECAP2_CLB1_CLBOUT14 = 18,
    //! CLB2 CLBOUT14 input for ECAP3 instance
    ECAP_INPUT_ECAP3_CLB2_CLBOUT14 = 18,
    //! PLU1_LC1_OUT3
    ECAP_INPUT_PLU1_LC1_OUT3 = 19,
    //! CLB2 CLBOUT15 input for ECAP1 instance
    ECAP_INPUT_ECAP1_CLB2_CLBOUT15 = 19,
    //! CLB1 CLBOUT15 input for ECAP2 instance
    ECAP_INPUT_ECAP2_CLB1_CLBOUT15 = 19,
    //! CLB2 CLBOUT15 input for ECAP3 instance
    ECAP_INPUT_ECAP3_CLB2_CLBOUT15 = 19,
    //! CANA INT0 Input
    ECAP_INPUT_CANA_INT0 = 20,
    //! CANA INT1 Input
    ECAP_INPUT_CANA_INT1 = 21,
    //! Output Xbar Output-1
    ECAP_INPUT_OUTPUTXBAR1 = 24,
    //! Output Xbar Output-2
    ECAP_INPUT_OUTPUTXBAR2 = 25,
    //! Output Xbar Output-3
    ECAP_INPUT_OUTPUTXBAR3 = 26,
    //! Output Xbar Output-4
    ECAP_INPUT_OUTPUTXBAR4 = 27,
    //! Output Xbar Output-5
    ECAP_INPUT_OUTPUTXBAR5 = 28,
    //! Output Xbar Output-6
    ECAP_INPUT_OUTPUTXBAR6 = 29,
    //! Output Xbar Output-7
    ECAP_INPUT_OUTPUTXBAR7 = 30,
    //! Output Xbar Output-8
    ECAP_INPUT_OUTPUTXBAR8 = 31,
    //! ADCD Event4
    ECAP_INPUT_ADC_D_EVENT4 = 32,
    //! ADCD Event3
    ECAP_INPUT_ADC_D_EVENT3 = 33,
    //! ADCD Event2
    ECAP_INPUT_ADC_D_EVENT2 = 34,
    //! ADCD Event1
    ECAP_INPUT_ADC_D_EVENT1 = 35,
    //! ADCC Event4
    ECAP_INPUT_ADC_C_EVENT4 = 36,
    //! ADCC Event3
    ECAP_INPUT_ADC_C_EVENT3 = 37,
    //! ADCC Event2
    ECAP_INPUT_ADC_C_EVENT2 = 38,
    //! ADCC Event1
    ECAP_INPUT_ADC_C_EVENT1 = 39,
    //! ADCB Event4
    ECAP_INPUT_ADC_B_EVENT4 = 40,
    //! ADCB Event3
    ECAP_INPUT_ADC_B_EVENT3 = 41,
    //! ADCB Event2
    ECAP_INPUT_ADC_B_EVENT2 = 42,
    //! ADCB Event1
    ECAP_INPUT_ADC_B_EVENT1 = 43,
    //! ADCA Event4
    ECAP_INPUT_ADC_A_EVENT4 = 44,
    //! ADCA Event3
    ECAP_INPUT_ADC_A_EVENT3 = 45,
    //! ADCA Event2
    ECAP_INPUT_ADC_A_EVENT2 = 46,
    //! ADCA Event1
    ECAP_INPUT_ADC_A_EVENT1 = 47,
    //! Output Xbar Output-9
	ECAP_INPUT_OUTPUTXBAR9 = 48,
	//! Output Xbar Output-10
	ECAP_INPUT_OUTPUTXBAR10 = 49,
	//! Output Xbar Output-11
	ECAP_INPUT_OUTPUTXBAR11 = 50,
	//! Output Xbar Output-12
	ECAP_INPUT_OUTPUTXBAR12 = 51,
	//! Output Xbar Output-13
	ECAP_INPUT_OUTPUTXBAR13 = 52,
	//! Output Xbar Output-14
	ECAP_INPUT_OUTPUTXBAR14 = 53,
	//! Output Xbar Output-15
	ECAP_INPUT_OUTPUTXBAR15 = 54,
	//! Output Xbar Output-16
	ECAP_INPUT_OUTPUTXBAR16 = 55,
	//! PLU1_LC2_OUT0
	ECAP_INPUT_PLU1_LC2_OUT0 =56,
	//! PLU1_LC2_OUT1
	ECAP_INPUT_PLU1_LC2_OUT1 =57,
	//! PLU1_LC2_OUT2
	ECAP_INPUT_PLU1_LC2_OUT2 =58,
	//! PLU1_LC2_OUT3
	ECAP_INPUT_PLU1_LC2_OUT3 =59,
    //! SDFM-2 Filter-1 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_LOW = 60,
    //! SDFM-2 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_LOW = 61,
    //! SDFM-2 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_LOW = 62,
    //! SDFM-2 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_LOW = 63,
    //! SDFM-1 Filter-1 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_LOW = 64,
    //! SDFM-1 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_LOW = 65,
    //! SDFM-1 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_LOW = 66,
    //! SDFM-1 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_LOW = 67,
    //! SDFM-2 Filter-1 Compare Z Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_Z = 68,
    //! SDFM-2 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_Z = 69,
    //! SDFM-2 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_Z = 70,
    //! SDFM-2 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_Z = 71,
    //! SDFM-1 Filter-1 Compare Z Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_Z = 72,
    //! SDFM-1 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_Z = 73,
    //! SDFM-1 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_Z = 74,
    //! SDFM-1 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_Z = 75,
    //! SDFM-2 Filter-1 Compare High Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_HIGH = 76,
    //! SDFM-2 Filter-2 Compare High Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_HIGH = 77,
    //! SDFM-2 Filter-3 Compare High Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_HIGH = 78,
    //! SDFM-2 Filter-4 Compare High Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_HIGH = 79,
    //! SDFM-1 Filter-1 Compare High Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH = 80,
    //! SDFM-1 Filter-2 Compare High Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH = 81,
    //! SDFM-1 Filter-3 Compare High Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH = 82,
    //! SDFM-1 Filter-4 Compare High Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH = 83,
    //! SDFM-2 Filter-1 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT1_COMPARE_HIGH_OR_LOW = 84,
    //! SDFM-2 Filter-2 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT2_COMPARE_HIGH_OR_LOW = 85,
    //! SDFM-2 Filter-3 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT3_COMPARE_HIGH_OR_LOW = 86,
    //! SDFM-2 Filter-4 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM2_FLT4_COMPARE_HIGH_OR_LOW = 87,
    //! SDFM-1 Filter-1 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT1_COMPARE_HIGH_OR_LOW = 88,
    //! SDFM-1 Filter-2 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT2_COMPARE_HIGH_OR_LOW = 89,
    //! SDFM-1 Filter-3 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT3_COMPARE_HIGH_OR_LOW = 90,
    //! SDFM-1 Filter-4 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM1_FLT4_COMPARE_HIGH_OR_LOW = 91,
    //! Compare Subsystem-1 Low Trip
    ECAP_INPUT_CMPSS1_CTRIP_LOW = 96,
    //! Compare Subsystem-2 Low Trip
    ECAP_INPUT_CMPSS2_CTRIP_LOW = 97,
    //! Compare Subsystem-3 Low Trip
    ECAP_INPUT_CMPSS3_CTRIP_LOW = 98,
    //! Compare Subsystem-4 Low Trip
    ECAP_INPUT_CMPSS4_CTRIP_LOW = 99,
    //! Compare Subsystem-5 Low Trip
    ECAP_INPUT_CMPSS5_CTRIP_LOW = 100,
    //! Compare Subsystem-6 Low Trip
    ECAP_INPUT_CMPSS6_CTRIP_LOW = 101,
    //! Compare Subsystem-7 Low Trip
    ECAP_INPUT_CMPSS7_CTRIP_LOW = 102,
    //! Compare Subsystem-8 Low Trip
    ECAP_INPUT_CMPSS8_CTRIP_LOW = 103,
    //! Compare Subsystem-1 High Trip
    ECAP_INPUT_CMPSS1_CTRIP_HIGH = 107,
    //! Compare Subsystem-2 High Trip
    ECAP_INPUT_CMPSS2_CTRIP_HIGH = 108,
    //! Compare Subsystem-3 High Trip
    ECAP_INPUT_CMPSS3_CTRIP_HIGH = 109,
    //! Compare Subsystem-4 High Trip
    ECAP_INPUT_CMPSS4_CTRIP_HIGH = 110,
    //! Compare Subsystem-5 High Trip
	ECAP_INPUT_CMPSS5_CTRIP_HIGH = 111,
	//! Compare Subsystem-6 High Trip
	ECAP_INPUT_CMPSS6_CTRIP_HIGH = 112,
	//! Compare Subsystem-7 High Trip
	ECAP_INPUT_CMPSS7_CTRIP_HIGH = 113,
	//! Compare Subsystem-8 High Trip
	ECAP_INPUT_CMPSS8_CTRIP_HIGH = 114,
    //! GPIO8
    ECAP_INPUT_GPIO8 = 115,
    //! GPIO9
    ECAP_INPUT_GPIO9 = 116,
    //! GPIO22
    ECAP_INPUT_GPIO22 = 117,
    //! GPIO23
    ECAP_INPUT_GPIO23 = 118,
    //! Compare Subsystem-1 High Trip or Low Trip
    ECAP_INPUT_CMPSS1_CTRIP_HIGH_OR_LOW = 119,
    //! Compare Subsystem-2 High Trip or Low Trip
    ECAP_INPUT_CMPSS2_CTRIP_HIGH_OR_LOW = 120,
    //! Compare Subsystem-3 High Trip or Low Trip
    ECAP_INPUT_CMPSS3_CTRIP_HIGH_OR_LOW = 121,
    //! Compare Subsystem-4 High Trip or Low Trip
    ECAP_INPUT_CMPSS4_CTRIP_HIGH_OR_LOW = 122,
    //! Compare Subsystem-5 High Trip or Low Trip
    ECAP_INPUT_CMPSS5_CTRIP_HIGH_OR_LOW = 123,
    //! Compare Subsystem-6 High Trip or Low Trip
    ECAP_INPUT_CMPSS6_CTRIP_HIGH_OR_LOW = 124,
    //! Compare Subsystem-7 High Trip or Low Trip
    ECAP_INPUT_CMPSS7_CTRIP_HIGH_OR_LOW = 125,
    //! Compare Subsystem-8 High Trip or Low Trip
    ECAP_INPUT_CMPSS8_CTRIP_HIGH_OR_LOW = 126,
	//! INPUTXBAR_SEL7_OUT
	ECAP_INPUT_ECAP1_INPUTXBAR7 = 127,
	//! INPUTXBAR_SEL8_OUT
	ECAP_INPUT_ECAP2_INPUTXBAR8 = 127,
	//! INPUTXBAR_SEL9_OUT
	ECAP_INPUT_ECAP3_INPUTXBAR9 = 127,
    //! SDFM-4 Filter-1 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT1_COMPARE_LOW = 128,
    //! SDFM-4 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT2_COMPARE_LOW = 129,
    //! SDFM-4 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT3_COMPARE_LOW = 130,
    //! SDFM-4 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT4_COMPARE_LOW = 131,
    //! SDFM-3 Filter-1 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT1_COMPARE_LOW = 132,
    //! SDFM-3 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT2_COMPARE_LOW = 133,
    //! SDFM-3 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT3_COMPARE_LOW = 134,
    //! SDFM-3 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT4_COMPARE_LOW = 135,
    //! SDFM-4 Filter-1 Compare Z Trip
    ECAP_INPUT_SDFM4_FLT1_COMPARE_Z = 136,
    //! SDFM-4 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT2_COMPARE_Z = 137,
    //! SDFM-4 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT3_COMPARE_Z = 138,
    //! SDFM-4 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM4_FLT4_COMPARE_Z = 139,
    //! SDFM-3 Filter-1 Compare Z Trip
    ECAP_INPUT_SDFM3_FLT1_COMPARE_Z = 140,
    //! SDFM-3 Filter-2 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT2_COMPARE_Z = 141,
    //! SDFM-3 Filter-3 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT3_COMPARE_Z = 142,
    //! SDFM-3 Filter-4 Compare Low Trip
    ECAP_INPUT_SDFM3_FLT4_COMPARE_Z = 143,
    //! SDFM-4 Filter-1 Compare High Trip
    ECAP_INPUT_SDFM4_FLT1_COMPARE_HIGH = 144,
    //! SDFM-4 Filter-2 Compare High Trip
    ECAP_INPUT_SDFM4_FLT2_COMPARE_HIGH = 145,
    //! SDFM-4 Filter-3 Compare High Trip
    ECAP_INPUT_SDFM4_FLT3_COMPARE_HIGH = 146,
    //! SDFM-4 Filter-4 Compare High Trip
    ECAP_INPUT_SDFM4_FLT4_COMPARE_HIGH = 147,
    //! SDFM-3 Filter-1 Compare High Trip
    ECAP_INPUT_SDFM3_FLT1_COMPARE_HIGH = 148,
    //! SDFM-3 Filter-2 Compare High Trip
    ECAP_INPUT_SDFM3_FLT2_COMPARE_HIGH = 149,
    //! SDFM-3 Filter-3 Compare High Trip
    ECAP_INPUT_SDFM3_FLT3_COMPARE_HIGH = 150,
    //! SDFM-3 Filter-4 Compare High Trip
    ECAP_INPUT_SDFM3_FLT4_COMPARE_HIGH = 151,
    //! SDFM-4 Filter-1 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM4_FLT1_COMPARE_HIGH_OR_LOW = 152,
    //! SDFM-4 Filter-2 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM4_FLT2_COMPARE_HIGH_OR_LOW = 153,
    //! SDFM-4 Filter-3 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM4_FLT3_COMPARE_HIGH_OR_LOW = 154,
    //! SDFM-4 Filter-4 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM4_FLT4_COMPARE_HIGH_OR_LOW = 155,
    //! SDFM-3 Filter-1 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM3_FLT1_COMPARE_HIGH_OR_LOW = 156,
    //! SDFM-3 Filter-2 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM3_FLT2_COMPARE_HIGH_OR_LOW = 157,
    //! SDFM-3 Filter-3 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM3_FLT3_COMPARE_HIGH_OR_LOW = 158,
    //! SDFM-3 Filter-4 Compare High Trip or Low Trip
    ECAP_INPUT_SDFM3_FLT4_COMPARE_HIGH_OR_LOW = 159,
    //! Compare Subsystem-9 Low Trip
    ECAP_INPUT_CMPSS9_CTRIP_LOW = 178,
    //! Compare Subsystem-10 Low Trip
    ECAP_INPUT_CMPSS10_CTRIP_LOW = 179,
    //! Compare Subsystem_11 Low Trip
    ECAP_INPUT_CMPSS11_CTRIP_LOW = 180,
    //! Compare Subsystem-12 Low Trip
    ECAP_INPUT_CMPSS12_CTRIP_LOW = 181,
    //! Compare Subsystem-9 High Trip
    ECAP_INPUT_CMPSS9_CTRIP_HIGH = 182,
    //! Compare Subsystem-10 High Trip
    ECAP_INPUT_CMPSS10_CTRIP_HIGH = 183,
    //! Compare Subsystem-11 High Trip
    ECAP_INPUT_CMPSS11_CTRIP_HIGH = 184,
    //! Compare Subsystem-12 High Trip
    ECAP_INPUT_CMPSS12_CTRIP_HIGH = 185,
    //! Compare Subsystem-9 High Trip or Low Trip
    ECAP_INPUT_CMPSS9_CTRIP_HIGH_OR_LOW = 186,
    //! Compare Subsystem-10 High Trip or Low Trip
    ECAP_INPUT_CMPSS10_CTRIP_HIGH_OR_LOW = 187,
    //! Compare Subsystem-11 High Trip or Low Trip
    ECAP_INPUT_CMPSS11_CTRIP_HIGH_OR_LOW = 188,
    //! Compare Subsystem-12 High Trip or Low Trip
    ECAP_INPUT_CMPSS12_CTRIP_HIGH_OR_LOW = 189,
	//! PLU1_LC3_OUT0
	ECAP_INPUT_PLU1_LC3_OUT0 = 190,
	//! PLU1_LC3_OUT1
	ECAP_INPUT_PLU1_LC3_OUT1 = 191,
	//! PLU1_LC3_OUT2
	ECAP_INPUT_PLU1_LC3_OUT2 = 192,
	//! PLU1_LC3_OUT3
	ECAP_INPUT_PLU1_LC3_OUT3 = 193,
	//! PLU2_LC1_OUT0
	ECAP_INPUT_PLU2_LC1_OUT0 = 194,
	//! PLU2_LC1_OUT1
	ECAP_INPUT_PLU2_LC1_OUT1 = 195,
	//! PLU2_LC1_OUT2
	ECAP_INPUT_PLU2_LC1_OUT2 = 196,
	//! PLU2_LC1_OUT3
	ECAP_INPUT_PLU2_LC1_OUT3 = 197,
	//! PLU2_LC2_OUT0
	ECAP_INPUT_PLU2_LC2_OUT0 = 198,
	//! PLU2_LC2_OUT1
	ECAP_INPUT_PLU2_LC2_OUT1 = 199,
	//! PLU2_LC2_OUT2
	ECAP_INPUT_PLU2_LC2_OUT2 = 200,
	//! PLU2_LC2_OUT3
	ECAP_INPUT_PLU2_LC2_OUT3 = 201,
	//! PLU2_LC3_OUT0
	ECAP_INPUT_PLU2_LC3_OUT0 = 202,
	//! PLU2_LC3_OUT1
	ECAP_INPUT_PLU2_LC3_OUT1 = 203,
	//! PLU2_LC3_OUT2
	ECAP_INPUT_PLU2_LC3_OUT2 = 204,
	//! PLU2_LC3_OUT3
	ECAP_INPUT_PLU2_LC3_OUT3 = 205,
	//! PLU3_LC1_OUT0
	ECAP_INPUT_PLU3_LC1_OUT0 = 206,
	//! PLU3_LC1_OUT1
	ECAP_INPUT_PLU3_LC1_OUT1 = 207,
	//! PLU3_LC1_OUT2
	ECAP_INPUT_PLU3_LC1_OUT2 = 208,
	//! PLU3_LC1_OUT3
	ECAP_INPUT_PLU3_LC1_OUT3 = 209,
	//! PLU3_LC2_OUT0
	ECAP_INPUT_PLU3_LC2_OUT0 = 210,
	//! PLU3_LC2_OUT1
	ECAP_INPUT_PLU3_LC2_OUT1 = 211,
	//! PLU3_LC2_OUT2
	ECAP_INPUT_PLU3_LC2_OUT2 = 212,
	//! PLU3_LC2_OUT3
	ECAP_INPUT_PLU3_LC2_OUT3 = 213,
	//! PLU3_LC3_OUT0
	ECAP_INPUT_PLU3_LC3_OUT0 = 214,
	//! PLU3_LC3_OUT1
	ECAP_INPUT_PLU3_LC3_OUT1 = 215,
	//! PLU3_LC3_OUT2
	ECAP_INPUT_PLU3_LC3_OUT2 = 216,
	//! PLU3_LC3_OUT3
	ECAP_INPUT_PLU3_LC3_OUT3 = 217,
	//! PLU4_LC1_OUT0
	ECAP_INPUT_PLU4_LC1_OUT0 = 218,
	//! PLU4_LC1_OUT1
	ECAP_INPUT_PLU4_LC1_OUT1 = 219,
	//! PLU4_LC1_OUT2
	ECAP_INPUT_PLU4_LC1_OUT2 = 220,
	//! PLU4_LC1_OUT3
	ECAP_INPUT_PLU4_LC1_OUT3 = 221,
	//! PLU4_LC2_OUT0
	ECAP_INPUT_PLU4_LC2_OUT0 = 222,
	//! PLU4_LC2_OUT1
	ECAP_INPUT_PLU4_LC2_OUT1 = 223,
	//! PLU4_LC2_OUT2
	ECAP_INPUT_PLU4_LC2_OUT2 = 224,
	//! PLU4_LC2_OUT3
	ECAP_INPUT_PLU4_LC2_OUT3 = 225,
	//! PLU4_LC3_OUT0
	ECAP_INPUT_PLU4_LC3_OUT0 = 226,
	//! PLU4_LC3_OUT1
	ECAP_INPUT_PLU4_LC3_OUT1 = 227,
	//! PLU4_LC3_OUT2
	ECAP_INPUT_PLU4_LC3_OUT2 = 228,
	//! PLU4_LC3_OUT3
	ECAP_INPUT_PLU4_LC3_OUT3 = 229,
	//! PLU5_LC1_OUT0
	ECAP_INPUT_PLU5_LC1_OUT0 = 230,
	//! PLU5_LC1_OUT1
	ECAP_INPUT_PLU5_LC1_OUT1 = 231,
	//! PLU5_LC1_OUT2
	ECAP_INPUT_PLU5_LC1_OUT2 = 232,
	//! PLU5_LC1_OUT3
	ECAP_INPUT_PLU5_LC1_OUT3 = 233,
	//! PLU5_LC2_OUT0
	ECAP_INPUT_PLU5_LC2_OUT0 = 234,
	//! PLU5_LC2_OUT1
	ECAP_INPUT_PLU5_LC2_OUT1 = 235,
	//! PLU5_LC2_OUT2
	ECAP_INPUT_PLU5_LC2_OUT2 = 236,
	//! PLU5_LC2_OUT3
	ECAP_INPUT_PLU5_LC2_OUT3 = 237,
	//! PLU5_LC3_OUT0
	ECAP_INPUT_PLU5_LC3_OUT0 = 238,
	//! PLU5_LC3_OUT1
	ECAP_INPUT_PLU5_LC3_OUT1 = 239,
	//! PLU5_LC3_OUT2
	ECAP_INPUT_PLU5_LC3_OUT2 = 240,
	//! PLU5_LC3_OUT3
	ECAP_INPUT_PLU5_LC3_OUT3 = 241,
    //! GPIO11
	ECAP_INPUT_GPIO11 = 251,
    //! GPIO12
	ECAP_INPUT_GPIO12 = 252,
    //! GPIO13
	ECAP_INPUT_GPIO13 = 253,
    //! GPIO14
	ECAP_INPUT_GPIO14 = 254,
	//!EPG1_DATAOUT53
	ECAP_INPUT_EPG1_DATAOUT53=255,
	//!EPG1_DATAOUT54
	ECAP_INPUT_EPG1_DATAOUT54=255,
	//!EPG1_DATAOUT55
	ECAP_INPUT_EPG1_DATAOUT55=255,


}ECAP_InputCaptureSignals;


//*****************************************************************************
//
//! Values that can be passed to ECAP_selectMonitoringType() as the
//! \e monSel parameter.
//
//*****************************************************************************
typedef enum
{
    //! High Pulse Width
    ECAP_MUNIT_HIGH_PULSE_WIDTH = 0U,
    //! Low Pulse Width
    ECAP_MUNIT_LOW_PULSE_WIDTH = 1U,
    //! Period width from rise to rise
    ECAP_MUNIT_PERIOD_WIDTH_RISE_RISE = 2U,
    //! Period width from fall to fall
    ECAP_MUNIT_PERIOD_WIDTH_FALL_FALL = 3U,
    //! Monitor rise edge
    ECAP_MUNIT_MONITOR_RISE_EDGE = 4U,
    //! Monitor fall edge
    ECAP_MUNIT_MONITOR_FALL_EDGE = 5U,
}ECAP_MonitoringTypeSelect;


//*****************************************************************************
//
//! Values that can be passed to ECAP_selectTripSignal() &
//! ECAP_selectGlobalLoadStrobe() as the \e tripSel and \e strobe parameter.
//
//*****************************************************************************
typedef enum
{
    //! Disabled
    ECAP_MUNIT_TRIP_DISABLED = 0U,
    //! MUNIT trip source is PWMXBAR-A output 0
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT0 = 1U,
    //! MUNIT trip source is PWMXBAR-A output 1
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT1 = 2U,
    //! MUNIT trip source is PWMXBAR-A output 2
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT2 = 3U,
    //! MUNIT trip source is PWMXBAR-A output 3
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT3 = 4U,
    //! MUNIT trip source is PWMXBAR-A output 4
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT4 = 5U,
    //! MUNIT trip source is PWMXBAR-A output 5
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT5 = 6U,
    //! MUNIT trip source is PWMXBAR-A output 6
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT6 = 7U,
    //! MUNIT trip source is PWMXBAR-A output 7
    ECAP_MUNIT_TRIP_EPWM_XBARA_OUT7 = 8U,
    //! MUNIT trip source is PWMXBAR-B output 0
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT0 = 9U,
    //! MUNIT trip source is PWMXBAR-B output 1
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT1 = 10U,
    //! MUNIT trip source is PWMXBAR-B output 2
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT2 = 11U,
    //! MUNIT trip source is PWMXBAR-B output 3
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT3 = 12U,
    //! MUNIT trip source is PWMXBAR-B output 4
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT4 = 13U,
    //! MUNIT trip source is PWMXBAR-B output 5
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT5 = 14U,
    //! MUNIT trip source is PWMXBAR-B output 6
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT6 = 15U,
    //! MUNIT trip source is PWMXBAR-B output 7
    ECAP_MUNIT_TRIP_EPWM_XBARB_OUT7 = 16U,
    //! MUNIT trip source is EPWM1 trip out signal
    ECAP_MUNIT_TRIP_EPWM1_TRIPOUT = 32U,
    //! MUNIT trip source is EPWM2 trip out signal
    ECAP_MUNIT_TRIP_EPWM2_TRIPOUT = 33U,
    //! MUNIT trip source is EPWM3 trip out signal
    ECAP_MUNIT_TRIP_EPWM3_TRIPOUT = 34U,
    //! MUNIT trip source is EPWM4 trip out signal
    ECAP_MUNIT_TRIP_EPWM4_TRIPOUT = 35U,
    //! MUNIT trip source is EPWM5 trip out signal
    ECAP_MUNIT_TRIP_EPWM5_TRIPOUT = 36U,
    //! MUNIT trip source is EPWM6 trip out signal
    ECAP_MUNIT_TRIP_EPWM6_TRIPOUT = 37U,
    //! MUNIT trip source is EPWM7 trip out signal
    ECAP_MUNIT_TRIP_EPWM7_TRIPOUT = 38U,
    //! MUNIT trip source is EPWM8 trip out signal
    ECAP_MUNIT_TRIP_EPWM8_TRIPOUT = 39U,
    //! MUNIT trip source is EPWM9 trip out signal
    ECAP_MUNIT_TRIP_EPWM9_TRIPOUT = 40U,
    //! MUNIT trip source is EPWM10 trip out signal
    ECAP_MUNIT_TRIP_EPWM10_TRIPOUT = 41U,
    //! MUNIT trip source is EPWM11 trip out signal
    ECAP_MUNIT_TRIP_EPWM11_TRIPOUT = 42U,
    //! MUNIT trip source is EPWM12 trip out signal
    ECAP_MUNIT_TRIP_EPWM12_TRIPOUT = 43U,
    //! MUNIT trip source is EPWM13 trip out signal
    ECAP_MUNIT_TRIP_EPWM13_TRIPOUT = 44U,
    //! MUNIT trip source is EPWM14 trip out signal
    ECAP_MUNIT_TRIP_EPWM14_TRIPOUT = 45U,
    //! MUNIT trip source is EPWM15 trip out signal
    ECAP_MUNIT_TRIP_EPWM15_TRIPOUT = 46U,
    //! MUNIT trip source is EPWM16 trip out signal
    ECAP_MUNIT_TRIP_EPWM16_TRIPOUT = 47U,
    //! MUNIT trip source is EPWM17 trip out signal
    ECAP_MUNIT_TRIP_EPWM17_TRIPOUT = 48U,
    //! MUNIT trip source is EPWM18 trip out signal
    ECAP_MUNIT_TRIP_EPWM18_TRIPOUT = 49U
}ECAP_MunitTripInputSelect;



#else
#error "unknown sdfm version"
#endif



#if IS_GS32F00xx(0x12)
#if(GS32_PART_NUM==0x0039) || (GS32_PART_NUM==0x0025A) || (GS32_PART_NUM==0x0049) || (GS32_PART_NUM==0x00137A)|| (GS32_PART_NUM==0x5000A)
//*****************************************************************************
//
//! Values that can be passed to ECAP_setSyncInPulseSource() as the \e mode
//! parameter.
//
//*****************************************************************************
typedef enum
{
    //! Disable Sync-in
    ECAP_SYNC_IN_PULSE_SRC_DISABLE         = 0x0,
    //! Sync-in source is EPWM1 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1   = 0x1,
    //! Sync-in source is EPWM2 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM2   = 0x2,
    //! Sync-in source is EPWM3 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3   = 0x3,
    //! Sync-in source is EPWM4 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM4   = 0x4,
    //! Sync-in source is EPWM5 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM5   = 0x5,
    //! Sync-in source is EPWM6 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM6   = 0x6,
    //! Sync-in source is EPWM7 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM7   = 0x7,
    //! Sync-in source is EPWM8 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM8   = 0x8,
    //! Sync-in source is EPWM9 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM9   = 0x9,
    //! Sync-in source is EPWM10 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM10  = 0xA,
    //! Sync-in source is EPWM11 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM11  = 0xB,
    //! Sync-in source is EPWM12 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM12  = 0xC,
    //! Sync-in source is ECAP1 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP1   = 0x11,
    //! Sync-in source is ECAP2 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP2   = 0x12,
    //! Sync-in source is ECAP3 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP3   = 0x13,
    //! Sync-in source is ECAP4 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP4   = 0x14,
    //! Sync-in source is ECAP5 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP5   = 0x15,
    //! Sync-in source is ECAP6 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP6   = 0x16,
    //! Sync-in source is ECAP7 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP7   = 0x17,
    //! Sync-in source is EXT sync-in1 signal
	ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1     = 0x18,
    //! Sync-in source is EXT sync-in2 signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT2     = 0x19

}ECAP_SyncInPulseSource;

#endif
#elif IS_GS32F00xx(0x30) || IS_GS32F3xx(0x22)

//*****************************************************************************
//
//! Values that can be passed to ECAP_setSyncInPulseSource() as the \e mode
//! parameter.
//
//*****************************************************************************
typedef enum
{
    //! Disable Sync-in
    ECAP_SYNC_IN_PULSE_SRC_DISABLE         = 0x0,
    //! Sync-in source is EPWM1 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1   = 0x1,
    //! Sync-in source is EPWM2 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM2   = 0x2,
    //! Sync-in source is EPWM3 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3   = 0x3,
    //! Sync-in source is EPWM4 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM4   = 0x4,
    //! Sync-in source is EPWM5 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM5   = 0x5,
    //! Sync-in source is EPWM6 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM6   = 0x6,
    //! Sync-in source is EPWM7 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM7   = 0x7,
    //! Sync-in source is EPWM8 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM8   = 0x8,
    //! Sync-in source is EPWM9 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM9   = 0x9,
//    //! Sync-in source is EPWM10 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM10  = 0xA,
//    //! Sync-in source is EPWM11 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM11  = 0xB,
//    //! Sync-in source is EPWM12 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM12  = 0xC,
//    //! Sync-in source is EPWM13 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM13  = 0xD,
//    //! Sync-in source is EPWM14 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM14  = 0xE,
//    //! Sync-in source is EPWM15 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM15  = 0xF,
//    //! Sync-in source is EPWM16 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM16  = 0x10,
    //! Sync-in source is ECAP1 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP1   = 0x11,
    //! Sync-in source is ECAP2 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP2   = 0x12,
    //! Sync-in source is ECAP3 sync-out signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP3   = 0x13,
    //! Sync-in source is ECAP4 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP4   = 0x14,
//    //! Sync-in source is ECAP5 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP5   = 0x15,
//    //! Sync-in source is ECAP6 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP6   = 0x16,
//    //! Sync-in source is ECAP7 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_ECAP7   = 0x17,
    //! Sync-in source is EXT sync-in1 signal
	ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1     = 0x18,
    //! Sync-in source is EXT sync-in2 signal
    ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT2     = 0x19,
    //! Sync-in source is EPWM17 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM17  = 0x1C,
//    //! Sync-in source is EPWM18 sync-out signal
//    ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM18  = 0x1D,

}ECAP_SyncInPulseSource;
#else

#error "unknown sdfm version"

#endif
//  Values that can be passed to ECAP_setEmulationMode() as the \e mode parameter.

typedef enum
{
    ECAP_EMULATION_STOP             = 0x0U,     //TSCTR is stopped on emulation suspension
    
    ECAP_EMULATION_RUN_TO_ZERO      = 0x1U,     //TSCTR runs until 0 before stopping on emulation suspension
    
    ECAP_EMULATION_FREE_RUN         = 0x2U      //TSCTR is not affected by emulation suspension
}ECAP_EmulationMode;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/**
 * \brief   This function determines if an eCAP module base address is valid.
 *
 * \param   base   specifies the eCAP module base address.
 *
 * \retval  Returns \b true if the base address is valid and \b false otherwise.
 */
#ifdef DEBUG
static bool ECAP_isBaseValid(uint32_t base)
{
    return (
            (base == ECAP1_BASE) ||
            (base == ECAP2_BASE) ||
            (base == ECAP3_BASE)
#ifdef ECAP4_BASE
         || (base == ECAP4_BASE)
         || (base == ECAP5_BASE)
         || (base == ECAP6_BASE)
         || (base == ECAP7_BASE)
#endif
           );
}
#endif

/**
 * \brief   This function divides the ECAP input scaler. The pre scale value is
 *          doubled inside the module. For example a preScalerValue of 5 will divide the
 *          scaler by 10. Use a value of 1 to divide the pre scaler by 1. 
 *          The \e preScalerValue should be less than \b ECAP_MAX_PRESCALER_VALUE.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   preScalerValue   preScalerValue is the pre scaler value for ECAP input.
 *          0h (R/W) = Divide by 1 (i.e,. no prescale, by-pass the prescaler)
			1h (R/W) = Divide by 2
			2h (R/W) = Divide by 4
			3h (R/W) = Divide by 6
			4h (R/W) = Divide by 8
			5h (R/W) = Divide by 10
			1Eh (R/W) = Divide by 60
			1Fh (R/W) = Divide by 62
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setEventPrescaler(uint32_t base, 
                                          uint16_t preScalerValue)
{
    ASSERT(ECAP_isBaseValid(base));

    ASSERT(preScalerValue < ECAP_MAX_PRESCALER_VALUE);

    // Write to PRESCALE bit

    HWREGH(base + ECAP_O_ECCTL1) = ((HWREGH(base + ECAP_O_ECCTL1) & (~ECAP_ECCTL1_PRESCALE_M)) |
                                  (preScalerValue << ECAP_ECCTL1_PRESCALE_S));
}

/**
 * \brief   This function sets the polarity of a given event. The value of event
 *          is between \b ECAP_EVENT_1 and \b ECAP_EVENT_4 inclusive corresponding to
 *          the four available events.For each event the polarity value determines the
 *          edge on which the capture is activated. For a rising edge use a polarity
 *          value of \b ECAP_EVENT_RISING_EDGE and for a falling edge use a polarity of
 *          \b ECAP_EVENT_FALLING_EDGE.
 * 
 * \param   base   base is the base address of the ECAP module.
 * \param   event  event is the event number.
 * \param   polarity   polarity is the polarity of the event.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setEventPolarity(uint32_t base, 
                                  ECAP_Events event, 
                                  ECAP_EventPolarity polarity)
{
    uint16_t shift;

    ASSERT(ECAP_isBaseValid(base));

    shift = ((uint16_t)event) << 1U;

    // Write to CAP1POL, CAP2POL, CAP3POL or CAP4POL

    HWREGH(base + ECAP_O_ECCTL1) = (((HWREGH(base + ECAP_O_ECCTL1)) & ~(1U << shift)) |
                                  (((uint16_t)polarity) << shift));
}

/**
 * \brief   This function sets the eCAP module to a continuous or one-shot mode.
 *          The value of mode should be either \b ECAP_CONTINUOUS_CAPTURE_MODE or
 *          \b ECAP_ONE_SHOT_CAPTURE_MODE corresponding to continuous or one-shot mode 
 *          respectively.
 *          
 *          The value of event determines the event number at which the counter stops
 *          (in one-shot mode) or the counter wraps (in continuous mode). The value of
 *          event should be between \b ECAP_EVENT_1 and \b ECAP_EVENT_4 corresponding
 *          to the valid event numbers.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   mode   mode is the capture mode.
 * \param   event   event is the event number at which the counter stops or wraps.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setCaptureMode(uint32_t base,
                                ECAP_CaptureMode mode,
                                ECAP_Events event)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to CONT/ONESHT

    HWREGH(base + ECAP_O_ECCTL2) = ((HWREGH(base + ECAP_O_ECCTL2) & (~ECAP_ECCTL2_CONT_ONESHT)) | 
                                  ((uint16_t)mode));

    // Write to STOP_WRAP

    HWREGH(base + ECAP_O_ECCTL2) = ((HWREGH(base + ECAP_O_ECCTL2) & (~ECAP_ECCTL2_STOP_WRAP_M)) |
                                  ((uint16_t)event << ECAP_ECCTL2_STOP_WRAP_S));
}

/**
 * \brief   This function re-arms the eCAP module.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_reArm(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to RE-ARM bit

    HWREGH(base + ECAP_O_ECCTL2) |= ECAP_ECCTL2_REARM;
}

/**
 * \brief   This function sets and enables eCAP interrupt source. The following are
 *          valid interrupt sources.
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_1 - Event 1 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_2 - Event 2 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_3 - Event 3 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_4 - Event 4 generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_OVERFLOW - Counter overflow generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_PERIOD   - Counter equal period generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_COMPARE  - Counter equal compare generates interrupt
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   intFlags   intFlags is the interrupt source to be enabled.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_enableInterrupt(uint32_t base,
                                        uint16_t intFlags)
{
    ASSERT(ECAP_isBaseValid(base));

    ASSERT((intFlags & ~(ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |
                         ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
                         ECAP_ISR_SOURCE_COUNTER_PERIOD |
                         ECAP_ISR_SOURCE_COUNTER_COMPARE)) == 0U);

    // Set bits in ECAP_ECEINT_FLG register
    
    HWREGH(base + ECAP_O_ECEINT) |= intFlags;
}

/**
 * \brief   This function clears and disables eCAP interrupt source. The following are 
 *          valid interrupt sources.
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_1 - Event 1 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_2 - Event 2 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_3 - Event 3 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_4 - Event 4 generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_OVERFLOW - Counter overflow generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_PERIOD   - Counter equal period generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_COMPARE  - Counter equal compare generates interrupt
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   intFlags   intFlags is the interrupt source to be enabled.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_disableInterrupt(uint32_t base,
                                         uint16_t intFlags)
{
    ASSERT(ECAP_isBaseValid(base));

    ASSERT((intFlags & ~(ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |
                         ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
                         ECAP_ISR_SOURCE_COUNTER_PERIOD |
                         ECAP_ISR_SOURCE_COUNTER_COMPARE)) == 0U);

    // Clear bits in ECAP_ECEINT_FLG register

    HWREGH(base + ECAP_O_ECEINT) &= ~intFlags;
}

/**
 * \brief   This function returns the eCAP interrupt flag. 
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  Returns the eCAP interrupt that has occurred. The following are 
 *          valid interrupt sources.
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_1 - Event 1 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_2 - Event 2 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_3 - Event 3 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_4 - Event 4 generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_OVERFLOW - Counter overflow generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_PERIOD   - Counter equal period generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_COMPARE  - Counter equal compare generates interrupt
 *          User can check if a combination of various interrupts have occurred by
 *          ORing the above return values.
 */
__STATIC_INLINE uint32_t ECAP_getInterruptSource(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Return contents of ECAP_ECEINT_FLG register

    return (HWREGH(base + ECAP_O_ECFLG) & 0x1EFEU);
}

/**
 * \brief   This function returns the eCAP Global interrupt flag.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  Returns true if there is a global eCAP interrupt, false otherwise.
 */
__STATIC_INLINE boolean ECAP_getGlobalInterruptStatus(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Return contents of Global interrupt bit

    return ((HWREGH(base + ECAP_O_ECFLG) & ECAP_ECFLG_INT) == (ECAP_ECFLG_INT));
}

/**
 * \brief   This function clears eCAP interrupt flags. The following are 
 *          valid interrupt sources.
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_1 - Event 1 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_2 - Event 2 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_3 - Event 3 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_4 - Event 4 generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_OVERFLOW - Counter overflow generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_PERIOD   - Counter equal period generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_COMPARE  - Counter equal compare generates interrupt
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   intFlags   intFlags is the interrupt source to be enabled.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_clearInterrupt(uint32_t base,
                                uint16_t intFlags)
{
    ASSERT(ECAP_isBaseValid(base));

    ASSERT((intFlags & ~(ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |
                         ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
                         ECAP_ISR_SOURCE_COUNTER_PERIOD |
                         ECAP_ISR_SOURCE_COUNTER_COMPARE)) == 0U);

    // Write to ECAP_ECCLR_FRC register

    HWREGH(base + ECAP_O_ECCLR) = intFlags;
}

/**
 * \brief   This function clears the global interrupt bit.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_clearGlobalInterrupt(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to INT bit

    HWREGH(base + ECAP_O_ECCLR) = ECAP_ECCLR_INT;
}

/**
 * \brief   This function forces and enables eCAP interrupt source. The following are
 *          valid interrupt sources.
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_1 - Event 1 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_2 - Event 2 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_3 - Event 3 generates interrupt
 *          - ECAP_ISR_SOURCE_CAPTURE_EVENT_4 - Event 4 generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_OVERFLOW - Counter overflow generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_PERIOD   - Counter equal period generates interrupt
 *          - ECAP_ISR_SOURCE_COUNTER_COMPARE  - Counter equal compare generates interrupt
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   intFlags   intFlags is the interrupt source to be enabled.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_forceInterrupt(uint32_t base,
                                       uint16_t intFlags)
{
    ASSERT(ECAP_isBaseValid(base));

    ASSERT((intFlags & ~(ECAP_ISR_SOURCE_CAPTURE_EVENT_1 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_2 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_3 |
                         ECAP_ISR_SOURCE_CAPTURE_EVENT_4 |
                         ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
                         ECAP_ISR_SOURCE_COUNTER_PERIOD |
                         ECAP_ISR_SOURCE_COUNTER_COMPARE)) == 0U);

    // Write to ECAP_ECCLR_FRC register

    HWREGH(base + ECAP_O_ECFRC) = intFlags;
}

/**
 * \brief   This function sets the eCAP module to operate in Capture mode.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_enableCaptureMode(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Clear CAP/APWM bit

    HWREGH(base + ECAP_O_ECCTL2) &= ~ECAP_ECCTL2_CAP_APWM;
}

/**
 * \brief   This function sets the eCAP module to operate in APWM mode.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_enableAPWMMode(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Set CAP/APWM bit

    HWREGH(base + ECAP_O_ECCTL2) |= ECAP_ECCTL2_CAP_APWM;
}

/**
 * \brief   This function enables the base timer, TSCTR, to be reset on capture
 *          event provided by the variable event. Valid inputs for event are
 *          \b ECAP_EVENT_1 to \b ECAP_EVENT_4.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   event   event is the event number the time base gets reset.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_enableCounterResetOnEvent(uint32_t base, 
                                                  ECAP_Events event)
{
    ASSERT(ECAP_isBaseValid(base));

    // Set CTRRST1,CTRRST2,CTRRST3 or CTRRST4 bits

    HWREGH(base + ECAP_O_ECCTL1) |= 1U << ((2U * (uint16_t)event) + 1U);
}

/**
 * \brief   This function disables the base timer, TSCTR, from being reset on capture
 *          event provided by the variable event. Valid inputs for event are
 *          \b ECAP_EVENT_1 to \b ECAP_EVENT_4.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   event   event is the event number the time base gets reset.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_disableCounterResetOnEvent(uint32_t base, 
                                                   ECAP_Events event)
{
    ASSERT(ECAP_isBaseValid(base));

    // Clear CTRRST1,CTRRST2,CTRRST3 or CTRRST4 bits

    HWREGH(base + ECAP_O_ECCTL1) &= ~(1U << ((2U * (uint16_t)event) + 1U));
}

/**
 * \brief   This function enables time stamp count to be captured
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_enableTimeStampCapture(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Set CAPLDEN bit

    HWREGH(base + ECAP_O_ECCTL1) |= ECAP_ECCTL1_CAPLDEN;
}

/**
 * \brief   This function disables time stamp count to be captured
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_disableTimeStampCapture(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Clear CAPLDEN bit

    HWREGH(base + ECAP_O_ECCTL1) &= ~ECAP_ECCTL1_CAPLDEN;
}

/**
 * \brief   This function writes a phase shift value to be loaded into the 
 *          main time stamp counter.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   shiftCount   shiftCount is the phase shift value.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setPhaseShiftCount(uint32_t base, 
                                           uint32_t shiftCount)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to CTRPHS

    HWREG(base + ECAP_O_CTRPHS) = shiftCount;
}



#if IS_GS32F00xx(0x12)
#if(GS32_PART_NUM==0x0039) || (GS32_PART_NUM==0x0025A) || (GS32_PART_NUM==0x0049) || (GS32_PART_NUM==0x00137A)|| (GS32_PART_NUM==0x5000A)
/**
 * \brief   This function set the sync out pulse mode.
 *
 * \param   base   base is the base address of the Sysctl_commm_para module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setSyncInPulseSource(uint32_t base, 
                                      ECAP_SyncInPulseSource source)
{
    // The function is implemented in sysctl.h by SysCtl_setECAPSyncInPulseSource().
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Set ECAP Sync-In Source Mode.
    //
    HWREGH(base + ECAP_O_ECAPSYNCINSEL) =
            (HWREGH(base + ECAP_O_ECAPSYNCINSEL) & (~ECAP_ECCTL0_INPUTSEL_M)) |
            ((uint16_t)source );

    EDIS;
}
#endif
#elif IS_GS32F00xx(0x30) || IS_GS32F3xx(0x22)
/**
 * \brief   This function set the sync out pulse mode.
 *
 * \param   base   base is the base address of the Sysctl_commm_para module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setSyncInPulseSource(uint32_t base,
                                      ECAP_SyncInPulseSource source)
{
    // The function is implemented in sysctl.h by SysCtl_setECAPSyncInPulseSource().
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Set ECAP Sync-In Source Mode.
    //
    HWREGH(base + ECAP_O_ECAPSYNCINSEL) =
            (HWREGH(base + ECAP_O_ECAPSYNCINSEL) & (~ECAP_ECCTL0_INPUTSEL_M)) |
            ((uint16_t)source);

    EDIS;
}
#endif


/**
 * \brief   This function enables loading of the counter with the value present in the
 *          phase shift counter as defined by the ECAP_setPhaseShiftCount() function.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_enableLoadCounter(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to SYNCI_EN

    HWREGH(base + ECAP_O_ECCTL2) |= ECAP_ECCTL2_SYNCI_EN;
}

/**
 * \brief   This function disables loading of the counter with the value present in the
 *          phase shift counter as defined by the ECAP_setPhaseShiftCount() function.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_disableLoadCounter(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to SYNCI_EN

    HWREGH(base + ECAP_O_ECCTL2) &= ~ECAP_ECCTL2_SYNCI_EN;
}

/**
 * \brief   This function forces the value in the phase shift counter register to be
 *          loaded into Time stamp counter register.
 *          Make sure to enable loading of Time stamp counter by calling
 *          ECAP_enableLoadCounter() function before calling this function.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_loadCounter(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to SWSYNC

    HWREGH(base + ECAP_O_ECCTL2) |= ECAP_ECCTL2_SWSYNC;
}

/**
 * \brief   This function sets the sync out mode. Valid parameters for mode are:
 *          - ECAP_SYNC_OUT_SYNCI - Trigger sync out on sync-in event.
 *          - ECAP_SYNC_OUT_COUNTER_PRD - Trigger sync out when counter equals period.
 *          - ECAP_SYNC_OUT_DISABLED - Disable sync out.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   mode   mode is the sync out mode.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setSyncOutMode(uint32_t base,
                                       ECAP_SyncOutMode mode)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to SYNCO_SEL

    HWREGH(base + ECAP_O_ECCTL2) = ((HWREGH(base + ECAP_O_ECCTL2) & (~ECAP_ECCTL2_SYNCO_SEL_M)) |
                                  ((uint16_t)mode));
}

/**
 * \brief   This function stops the time stamp counter.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_stopCounter(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Clear TSCTR

    HWREGH(base + ECAP_O_ECCTL2) &= ~ECAP_ECCTL2_TSCTRSTOP;
}

/**
 * \brief   This function starts the time stamp counter.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_startCounter(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Set TSCTR

    HWREGH(base + ECAP_O_ECCTL2) |= ECAP_ECCTL2_TSCTRSTOP;
}

/**
 * \brief   This function sets the polarity of the eCAP in APWM mode. Valid inputs for
 *          polarity are:
 *          - ECAP_APWM_ACTIVE_HIGH - For active high.
 *          - ECAP_APWM_ACTIVE_LOW - For active low.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   polarity   polarity is the polarity of APWM
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setAPWMPolarity(uint32_t base,
                                        ECAP_APWMPolarity polarity)
{
    ASSERT(ECAP_isBaseValid(base));

    HWREGH(base + ECAP_O_ECCTL2) = ((HWREGH(base + ECAP_O_ECCTL2) & ~ECAP_ECCTL2_APWMPOL) |
                                  ((uint16_t)polarity));
}

/**
 * \brief   This function sets the period count of the APWM waveform.
 *          periodCount takes the actual count which is written to the register. The
 *          user is responsible for converting the desired frequency or time into
 *          the period count.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   periodCount   periodCount is the period count for APWM.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setAPWMPeriod(uint32_t base, 
                                      uint32_t periodCount)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to CAP1

    HWREG(base + ECAP_O_CAP1) = periodCount;
}

/**
 * \brief   This function sets the on or off time count of the APWM waveform depending
 *          on the polarity of the output. If the output , as set by
 *          ECAP_setAPWMPolarity(), is active high then compareCount determines the on
 *          time. If the output is active low then compareCount determines the off
 *          time. compareCount takes the actual count which is written to the register.
 *          The user is responsible for converting the desired frequency or time into
 *          the appropriate count value.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   compareCount   compareCount is the on or off count for APWM.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setAPWMCompare(uint32_t base, 
                                       uint32_t compareCount)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to CAP2

    HWREG(base + ECAP_O_CAP2) = compareCount;
}

/**
 * \brief   This function sets the shadow period count of the APWM waveform.
 *          periodCount takes the actual count which is written to the register. The
 *          user is responsible for converting the desired frequency or time into
 *          the period count.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   periodCount   periodCount is the shadow period count for APWM.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setAPWMShadowPeriod(uint32_t base,
                                            uint32_t periodCount)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to CAP3

    HWREG(base + ECAP_O_CAP3) = periodCount;
}

/**
 * \brief   This function sets the shadow on or off time count of the APWM waveform
 *          depending on the polarity of the output. If the output , as set by
 *          ECAP_setAPWMPolarity() , is active high then compareCount determines the
 *          on time. If the output is active low then compareCount determines the off
 *          time. compareCount takes the actual count which is written to the register.
 *          The user is responsible for converting the desired frequency or time into
 *          the appropriate count value.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   compareCount   compareCount is the on or off count for APWM.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setAPWMShadowCompare(uint32_t base, 
                                             uint32_t compareCount)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to CAP4

    HWREG(base + ECAP_O_CAP4) = compareCount;
}

/**
 * \brief   This function returns the time base counter value.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  Returns the time base counter value
 */
__STATIC_INLINE uint32_t ECAP_getTimeBaseCounter(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Read the Time base counter value

    return (HWREG(base + ECAP_O_TSCTR));
}

/**
 * \brief   This function sets the time base counter value.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  none
 */
__STATIC_INLINE void ECAP_setTimeBaseCounter(uint32_t base, uint32_t val)
{
    ASSERT(ECAP_isBaseValid(base));

    // Read the Time base counter value

    (HWREG(base + ECAP_O_TSCTR)) = val;
}

/**
 * \brief   This function returns the current time stamp count of the given event.
 *          Valid values for event are \b ECAP_EVENT_1 to \b ECAP_EVENT_4.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   event   event is the event number.
 *
 * \retval  Event time stamp value or 0 if \e event is invalid.
 */
__STATIC_INLINE uint32_t ECAP_getEventTimeStamp(uint32_t base, 
                                              ECAP_Events event)
{
    uint32_t count;

    ASSERT(ECAP_isBaseValid(base));

    switch(event)
    {
        case ECAP_EVENT_1:

            // Read CAP1 register

            count = HWREG(base + ECAP_O_CAP1);
        break;

        case ECAP_EVENT_2:

            // Read CAP2 register

            count = HWREG(base + ECAP_O_CAP2);
        break;

        case ECAP_EVENT_3:

            // Read CAP3 register

            count = HWREG(base + ECAP_O_CAP3);
        break;

        case ECAP_EVENT_4:

            // Read CAP4 register

            count = HWREG(base + ECAP_O_CAP4);
        break;

        default:

            // Invalid event parameter

            count = 0U;
        break;
    }

    return count;
}

/**
 * \brief   This function selects the eCAP input signal.
 *          Please refer to the ::ECAP_InputCaptureSignals Enum for the valid values
 *          to be passed to \e input parameter.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   input   input is the eCAP input signal.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_selectECAPInput(uint32_t base,
                                        ECAP_InputCaptureSignals input)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to ECCTL0

    HWREG(base + ECAP_O_ECCTL0) = ((HWREG(base + ECAP_O_ECCTL0) & ~ECAP_ECCTL0_INPUTSEL_M) |
                                ((uint32_t)input));
}

/**
 * \brief   This function resets the main counter (TSCTR register), event filter,
 *          modulo counter, capture events and counter overflow flags.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_resetCounters(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to ECCTL2

    HWREGH(base + ECAP_O_ECCTL2) |= ECAP_ECCTL2_CTRFILTRESET;
}

/**
 * \brief   This function sets the eCAP event source for the DMA trigger.
 *          Valid values for \e event are \b ECAP_EVENT_1 to \b ECAP_EVENT_4.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   event   event is the eCAP event for the DMA.
*           Capture Mode:
			00b (R/W) = DMA interrupt source is CEVT1
			01b (R/W) = DMA interrupt source is CEVT2
			10b (R/W) = DMA interrupt source is CEVT3
			11b (R/W) = DMA interrupt source is CEVT4
			APWM Mode:
			00b (R/W) = DMA interrupt source is period match
			01b (R/W) = DMA interrupt source is compare match
			10b (R/W) = DMA interrupt source is period match or compare match
			11b (R/W) = Disabled
 * \retval  None
 */
__STATIC_INLINE void ECAP_setDMASource(uint32_t base, 
                                     ECAP_Events event)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to ECCTL2

    HWREGH(base + ECAP_O_ECCTL2) = ((HWREGH(base + ECAP_O_ECCTL2) & ~ECAP_ECCTL2_DMAEVTSEL_M) |
                                  ((uint16_t)event << ECAP_ECCTL2_DMAEVTSEL_S));
}

/**
 * \brief   This function returns the modulo counter status, indicating which register
 *          gets loaded on the next capture event.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  Returns an \b ECAP_EVENT_n value indicating that CAPn is the
 *          register to be loaded on the next event.
 */
__STATIC_INLINE ECAP_Events ECAP_getModuloCounterStatus(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    uint16_t counterStatusValue = (((HWREGH(base + ECAP_O_ECCTL2) & ECAP_ECCTL2_MODCNTRSTS_M) >> 
                                  ECAP_ECCTL2_MODCNTRSTS_S));

    // Read MODCNTRSTS bit

    return ((ECAP_Events)counterStatusValue);
}

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
/**
 * \brief  Configure the threshold to qualify the inversion of output level.
 *
 * \param   base   base is the base address of the ECAP module.
 *
 * \retval  None
 */
__STATIC_INLINE void ECAP_setDBFilterCfg(uint32_t base,uint32_t value)
{
    ASSERT(ECAP_isBaseValid(base));

	HWREGH(base + ECAP_O_DB_FILTER_CFG) = value;

}
#elif IS_GS32F00xx(0x30)

/* \brief  Configure the threshold to qualify the inversion of output level.
*
* \param   base   base is the base address of the ECAP module. The value less than 0xF
*
* \retval  None
*/
__STATIC_INLINE void ECAP_setDBFilterCfg(uint32_t base,uint32_t value)
{
    ASSERT(ECAP_isBaseValid(base));

    HWREG(base + ECAP_O_ECCTL0) = ((HWREG(base + ECAP_O_ECCTL0) & ~ECAP_ECCTL0_QUALPRD) |
                                ((uint32_t)value << 12));
}

/* \brief  Configure the ADC SOC event select.
*
* \param   base   base is the base address of the ECAP module. The value less than 0xF
* \param  value   Capture Mode:
*					00b (R/W) = SOC trigger source is CEVT1
*					01b (R/W) = SOC trigger source is CEVT2
*					10b (R/W) = SOC trigger source is CEVT3
*					11b (R/W) = SOC trigger source is CEVT4
*					APWM Mode:
*					00b (R/W) = SOC trigger interrupt source is period match
*					01b (R/W) = SOC trigger interrupt source is compare match
*					10b (R/W) = SOC trigger interrupt source is period match or compare match
*					11b (R/W) = Disabled
* \retval  None
*/
__STATIC_INLINE void ECAP_setAdcEventSelect(uint32_t base,uint32_t value)
{
    ASSERT(ECAP_isBaseValid(base));

    HWREG(base + ECAP_O_ECCTL0) = ((HWREG(base + ECAP_O_ECCTL0) & ~ECAP_ECCTL0_SOCEVTSEL) |
                                ((uint32_t)value << 16));
}
#endif

//*****************************************************************************
//
//! \internal
//! Checks HRCAP base address.
//!
//! \param base specifies the HRCAP module base address.
//!
//! This function determines if an HRCAP module base address is valid.
//!
//! \return Returns \b true if the base address is valid and \b false
//! otherwise.
//
//*****************************************************************************
#ifdef DEBUG
static inline bool
HRCAP_isBaseValid(uint32_t base)
{
//    return(
//           (base == HRCAP3_BASE)
//          );
	return 1;
}
#endif

//*****************************************************************************
//
//! enables HRCAP.
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function enables High Resolution Capture module.
//!
//! \note High resolution clock must be enabled before High Resolution Module
//!       is enabled.
//!
//! \return None.
//
//*****************************************************************************
#if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
static inline void
HRCAP_enableHighResolution(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Set HRE bit.
    //
    HWREGH(base + HRCAP_O_HRCTL) |= HRCAP_HRCTL_HRE;
    EDIS;
}

//*****************************************************************************
//
//! Disables HRCAP.
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function disable High Resolution Capture module.
//!
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_disableHighResolution(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Set HRE bit.
    //
    HWREGH(base + HRCAP_O_HRCTL) &= ~HRCAP_HRCTL_HRE;
    EDIS;
}

//*****************************************************************************
//
//! Enables high resolution clock.
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function enables High Resolution clock.
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_enableHighResolutionClock(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;
    //
    // Set HRCLKE bit.
    //
    HWREGH(base + HRCAP_O_HRCTL) |= HRCAP_HRCTL_HRCLKE;
    EDIS;
}

//*****************************************************************************
//
//! Disables High resolution clock.
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function disables High Resolution clock.
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_disbleHighResolutionClock(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Clear HRCLKE bit.
    //
    HWREGH(base + HRCAP_O_HRCTL) &= ~HRCAP_HRCTL_HRCLKE;
    EDIS;
}

//*****************************************************************************
//
//! Starts calibration.
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function starts calibration.
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_startCalibration(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Set CALIBSTART bit.
    //
    HWREGH(base + HRCAP_O_HRCTL) |= HRCAP_HRCTL_CALIBSTART;
    EDIS;
}

//*****************************************************************************
//
//! Sets the calibration mode.
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function sets the the calibration mode by turning on continuous
//! calibration.
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_setCalibrationMode(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;

    //
    // Write to CALIBSTS and CALIBCONT bits.
    //
    HWREGH(base + HRCAP_O_HRCTL) |= HRCAP_HRCTL_CALIBCONT;
    EDIS;
}

//*****************************************************************************
//
//! Enables calibration interrupt.
//!
//! \param base is the base address of the HRCAP module.
//! \param intFlags is the calibration interrupt flags to be enabled.
//!
//! This function enables HRCAP calibration interrupt flags.
//! Valid values for intFlags are:
//!     - HRCAP_CALIBRATION_DONE   - Calibration done interrupt.
//!     - HRCAP_CALIBRATION_PERIOD_OVERFLOW - Calibration period overflow
//!                                                check interrupt.
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_enableCalibrationInterrupt(uint32_t base, uint16_t intFlags)
{
    ASSERT(ECAP_isBaseValid(base));
    ASSERT((intFlags & ~(HRCAP_CALIBRATION_DONE |
                       HRCAP_CALIBRATION_PERIOD_OVERFLOW)) == 0U);

    EALLOW;

    //
    // Set CALIBDONE or CALPRDCHKSTS.
    //
    HWREGH(base + HRCAP_O_HRINTEN) |= intFlags;
    EDIS;
}

//*****************************************************************************
//
//! Disables calibration interrupt source.
//!
//! \param base is the base address of the HRCAP module.
//! \param intFlags is the calibration interrupt flags to be disabled.
//!
//! This function disables HRCAP calibration interrupt flags.
//! Valid values for intFlags are:
//!     - HRCAP_CALIBRATION_DONE   - Calibration done interrupt.
//!     - HRCAP_CALIBRATION_PERIOD_OVERFLOW - Calibration period check
//!                                                   interrupt.
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_disableCalibrationInterrupt(uint32_t base, uint16_t intFlags)
{
    ASSERT(ECAP_isBaseValid(base));
    ASSERT((intFlags & ~(HRCAP_CALIBRATION_DONE |
                       HRCAP_CALIBRATION_PERIOD_OVERFLOW)) == 0U);

    EALLOW;

    //
    // Clear CALIBDONE or CALPRDCHKSTS.
    //
    HWREGH(base + HRCAP_O_HRINTEN) &= ~intFlags;
    EDIS;
}

//*****************************************************************************
//
//! Returns the calibration interrupt source.
//!
//! \param base is the base address of the HRCAP module.
//!
//! This function returns the HRCAP calibration interrupt source.
//!
//! \return Returns the HRCAP interrupt that has occurred. The following are
//!         valid return values.
//!          - HRCAP_GLOBAL_CALIBRATION_INTERRUPT - Global calibration
//!                                                 interrupt.
//!          - HRCAP_CALIBRATION_DONE   - Calibration done interrupt.
//!          - HRCAP_CALIBRATION_PERIOD_OVERFLOW - Calibration period overflow
//!                                                interrupt.
//!
//! \note - User can check if a combination of the interrupts have occurred
//!         by ORing the above return values.
//
//*****************************************************************************
static inline uint16_t
HRCAP_getCalibrationFlags(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    //
    // Return contents of HRFLG register.
    //
    return((uint16_t)(HWREGH(base + HRCAP_O_HRFLG) & 0x7U));
}

//*****************************************************************************
//
//! Clears calibration flags.
//!
//! \param base is the base address of the HRCAP module.
//! \param flags is the calibration flags to be cleared.
//!
//! This function clears HRCAP calibration flags.
//! The following are valid values for flags.
//!     - HRCAP_GLOBAL_CALIBRATION_INTERRUPT - Global calibration interrupt.
//!     - HRCAP_CALIBRATION_DONE   - Calibration done flag.
//!     - HRCAP_CALIBRATION_PERIOD_OVERFLOW - Calibration period overflow flag.
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_clearCalibrationFlags(uint32_t base, uint16_t flags)
{
    ASSERT(ECAP_isBaseValid(base));
    ASSERT((flags == (HRCAP_CALIBRATION_DONE |
                      HRCAP_GLOBAL_CALIBRATION_INTERRUPT)) ||
           (flags == (HRCAP_CALIBRATION_PERIOD_OVERFLOW |
                      HRCAP_GLOBAL_CALIBRATION_INTERRUPT)) ||
           (flags == (HRCAP_CALIBRATION_DONE |
                      HRCAP_GLOBAL_CALIBRATION_INTERRUPT |
                      HRCAP_CALIBRATION_PERIOD_OVERFLOW)));

    //
    // Write to HRCLR register.
    //
    HWREGH(base + HRCAP_O_HRCLR) |= flags;
}

//*****************************************************************************
//
//! Return the Calibration status
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function returns the calibration status.
//!
//! \return This functions returns true if the calibration is in process,false
//!         if there is no active calibration.
//
//*****************************************************************************
static inline bool
HRCAP_isCalibrationBusy(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    //
    // Read CALIBSTS bit.
    //
    return((HWREGH(base + HRCAP_O_HRCTL) & HRCAP_HRCTL_CALIBSTS) ==
             HRCAP_HRCTL_CALIBSTS);
}

//*****************************************************************************
//
//! Force a software based calibration
//!
//! \param base is the base address of the HRCAP instance used.
//! \param flag is the calibration flag source.
//!
//! This function forces a software based calibration done flag.
//! The following are valid values for flag.
//!     - HRCAP_CALIBRATION_DONE - Calibration done flag.
//!     - HRCAP_CALIBRATION_PERIOD_OVERFLOW - Calibration period overflow flag.
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_forceCalibrationFlags(uint32_t base, uint16_t flag)
{
    ASSERT(ECAP_isBaseValid(base));
    ASSERT((flag & ~(HRCAP_CALIBRATION_DONE |
                    HRCAP_CALIBRATION_PERIOD_OVERFLOW)) == 0U);

    EALLOW;

    //
    // Write to CALIBDONE or CALPRDCHKSTS bit.
    //
    HWREGH(base + HRCAP_O_HRFRC) |= flag;
    EDIS;
}

//*****************************************************************************
//
//! Sets the calibration period count
//!
//! \param base is the base address of the HRCAP instance used.
//! \param sysclkHz is the rate of the SYSCLK in Hz.
//!
//! This function sets the calibration period count value to achieve a period
//! of 1.6 milliseconds given the SYSCLK frequency in Hz (the \e sysclkHz
//! parameter).
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_setCalibrationPeriod(uint32_t base, uint32_t sysclkHz)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;
    HWREG(base + HRCAP_O_HRCALPRD) = (sysclkHz * 16U) / 10000U;
    EDIS;
}

//*****************************************************************************
//
//! Sets the calibration period count at a user configurable value.
//!
//! \param base is the base address of the HRCAP instance used.
//! \param sysclkHz is the rate of the SYSCLK in Hz.
//! \param periodInMs is the calibration period to be configured.
//!
//! This function sets the calibration period count value to the provided
//! period in milliseconds given the SYSCLK frequency in Hz (the \e sysclkHz
//! parameter).
//!
//! \return None.
//
//*****************************************************************************
static inline void
HRCAP_configCalibrationPeriod(uint32_t base, uint32_t sysclkHz,
                                                     float periodInMs)
{
    ASSERT(ECAP_isBaseValid(base));

    EALLOW;
    HWREG(base + HRCAP_O_HRCALPRD) =
                    (uint32_t)((float32_t)sysclkHz * periodInMs / 1000.0F);
    EDIS;
}

//*****************************************************************************
//
//! Returns the calibration clock period
//!
//! \param base is the base address of the HRCAP instance used.
//! \param clockSource is the calibration clock source
//! (\b HRCAP_CALIBRATION_CLOCK_SYSCLK or \b HRCAP_CALIBRATION_CLOCK_HRCLK).
//!
//! This function returns the period match value of the calibration clock. The
//! return value has a valid count when a period match occurs.
//!
//! \return This function returns the captured value of the clock counter
//!         specified by clockSource.
//
//*****************************************************************************
static inline uint32_t
HRCAP_getCalibrationClockPeriod(uint32_t base,
                                HRCAP_CalibrationClockSource clockSource)
{
    ASSERT(ECAP_isBaseValid(base));

    //
    // Return HRCAP_O_HRSYSCLKCAP or HRCAP_O_HRCLKCAP.
    //
    return(HWREG(base + HRCAP_O_HRSYSCLKCAP + (uint32_t)clockSource));
}

//*****************************************************************************
//
//! Calculates the scale factor
//!
//! \param base is the base address of the HRCAP instance used.
//!
//! This function reads the SYSCLK and HRCLK calibration periods and then
//! uses them to calculate the scale factor.
//!
//! \return This function returns the calculated scale factor.
//
//*****************************************************************************
static inline float32_t
HRCAP_getScaleFactor(uint32_t base)
{
    ASSERT(ECAP_isBaseValid(base));

    //
    // Calculate and return the scale factor.
    //
    return((float32_t)HRCAP_getCalibrationClockPeriod(base,
                                            HRCAP_CALIBRATION_CLOCK_SYSCLK) /
           (float32_t)HRCAP_getCalibrationClockPeriod(base,
                                            HRCAP_CALIBRATION_CLOCK_HRCLK));
}
#endif
//*****************************************************************************
//
//! Returns event time stamp in nanoseconds
//!
//! \param timeStamp is a raw time stamp count returned by
//! ECAP_getEventTimeStamp().
//! \param scaleFactor is the calculated scale factor returned by
//! HRCAP_getScaleFactor().
//!
//! This function converts a raw CAP time stamp (the \e timeStamp parameter) to
//! nanoseconds using the provided scale factor (the \e scaleFactor parameter).
//!
//! \return Returns the converted time stamp in nanoseconds.
//
//*****************************************************************************
static inline float32_t
HRCAP_convertEventTimeStampNanoseconds(uint32_t timeStamp,
                                       float32_t scaleFactor)
{
    //
    // Convert the raw count value to nanoseconds using the given scale factor.
    //
    return((float32_t)timeStamp * scaleFactor * ((float32_t)25.0 /
                                                 (float32_t)384.0));
}

#if IS_GS32F00xx(0x30)


#ifdef DEBUG
__STATIC_FORCEINLINE
bool ECAP_isSignalMonitoringBaseValid(uint32_t base)
{
    return true;
}
#endif
//*****************************************************************************
//
//! Disable eCAP monitoring unit.
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function disables the eCAP signal monitoring unit.
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_disableSignalMonitoringUnit(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_CTL;

    //
    // Disable MUNIT
    //
    HWREG(base + munitOffset) &= ~ECAP_MUNIT_1_CTL_EN;
}
//*****************************************************************************
//
//! Enables debug mode to capture range from min to max
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function enables the eCAP debug mode for signal monitoring.
//! Range is captured in DEBUG_RANGE_MAX and DEBUG_RANGE_MIN registers.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_enableDebugRange(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_CTL;

    //
    // Enable debug mode for MUNIT 1
    //
    HWREG(base + munitOffset) |= ECAP_MUNIT_1_CTL_DEBUG_RANGE_EN;
}

//*****************************************************************************
//
//! Disables debug mode to capture range from min to max
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function disables the eCAP debug mode for signal monitoring.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_disableDebugRange(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_CTL;

    //
    // Disable debug mode for MUNIT
    //
    HWREG(base + munitOffset) &= ~ECAP_MUNIT_1_CTL_DEBUG_RANGE_EN;
}


//*****************************************************************************
//
//! Setup the early max error check
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param errorCheck is the functionality for early max error check
//!        to be enabled.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - errorCheck:
//!    - ECAP_PULSE_WIDTH_CROSS_MAX_VALUE - Max error generated as soon as
//!                                         pulse width crosses max value
//!    - ECAP_SECOND_EVENT_OCCURED        - Max error generated when second
//!                                         event has occured
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_setupEarlyMaxErrorCheck(uint32_t base, MUNIT_Number munit,
                             uint32_t errorCheck)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_CTL;

    //
    // Setup early max error check
    //
    HWREG(base + munitOffset) =
            ((HWREG(base + munitOffset) &
              ~ECAP_MUNIT_1_CTL_DISABLE_EARLY_MAX_ERR) | (errorCheck << 2U));
}

//*****************************************************************************
//
//! Selects the type of monitoring
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param monSel is the type of monitoring to be selected.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - monSel:
//!    - ECAP_MUNIT_HIGH_PULSE_WIDTH       - High Pulse Width
//!    - ECAP_MUNIT_LOW_PULSE_WIDTH        - Low Pulse Width
//!    - ECAP_MUNIT_PERIOD_WIDTH_RISE_RISE - Period width from rise to rise
//!    - ECAP_MUNIT_PERIOD_WIDTH_FALL_FALL - Period width from fall to fall
//!    - ECAP_MUNIT_MONITOR_RISE_EDGE      - Monitor rise edge
//!    - ECAP_MUNIT_MONITOR_FALL_EDGE      - Monitor fall edge
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_selectMonitoringType(uint32_t base, MUNIT_Number munit,
                          ECAP_MonitoringTypeSelect monSel)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_CTL;

    //
    // Select Monitoring Type for MUNIT
    //
    HWREG(base + munitOffset) =
            (HWREG(base + munitOffset) &
            ~ECAP_MUNIT_1_CTL_MON_SEL_M) |
            ((uint32_t)monSel << ECAP_MUNIT_1_CTL_MON_SEL_S);
    //
    // Enable MUNIT
    //
    HWREG(base + munitOffset) |= ECAP_MUNIT_1_CTL_EN;
}

//*****************************************************************************
//
//! Selects the trip signal to disable and enable monitoring automatically.
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param tripSel is the trip signal.
//!
//! Valid values for the input variables are:
//! - tripSel:
//!     - DISABLED
//!     - ECAP_MUNIT_TRIP_EPWM_XBARy_OUTn - y is A/B, n is 0-7
//!     - ECAP_MUNIT_TRIP_EPWMn_TRIPOUT - n is 1-18
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_selectTripSignal(uint32_t base, ECAP_MunitTripInputSelect tripSel)
{
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Select Monitoring Type
    //
    HWREG(base + ECAP_O_MUNIT_COMMON_CTL) =
            (HWREG(base + ECAP_O_MUNIT_COMMON_CTL) &
             ~ECAP_MUNIT_COMMON_CTL_TRIPSEL_M) |
            ((uint32_t)tripSel << ECAP_MUNIT_COMMON_CTL_TRIPSEL_S);
}

//*****************************************************************************
//
//! Selects the global load strobe to enable shadow to active loading
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param strobe is the type of monitoring to be selected.
//!
//! Valid values for the input variables are:
//! - strobe:
//!     - DISABLED
//!     - ECAP_MUNIT_TRIP_EPWM_XBARy_OUTn - y is A/B, n is 0-7
//!     - ECAP_MUNIT_TRIP_EPWMn_TRIPOUT - n is 1-18
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_selectGlobalLoadStrobe(uint32_t base, ECAP_MunitTripInputSelect strobe)
{
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Select the global load strobe
    //
    HWREG(base + ECAP_O_MUNIT_COMMON_CTL) =
            (HWREG(base + ECAP_O_MUNIT_COMMON_CTL) &
             ~ECAP_MUNIT_COMMON_CTL_GLDSTRBSEL_M) |
            ((uint32_t)strobe << ECAP_MUNIT_COMMON_CTL_GLDSTRBSEL_S);
}

//*****************************************************************************
//
//! Enables shadowing for min and max registers
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function enables the shadowing feature for min and max registers.
//!
//! Valid values for the input variable:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_enableShadowMinMaxRegisters(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_SHADOW_CTL;

    //
    // Enable shadowing for MUNIT 1
    //
    HWREG(base + munitOffset) |= ECAP_MUNIT_1_SHADOW_CTL_SYNCI_EN;
}

//*****************************************************************************
//
//! Disables shadowing for min and max registers
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function disables the shadowing feature for min and max registers.
//!
//! Valid values for the input variable:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_disableShadowMinMaxRegisters(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_SHADOW_CTL;

    //
    // Disable shadowing for MUNIT 1
    //
    HWREG(base + munitOffset) &= ~ECAP_MUNIT_1_SHADOW_CTL_SYNCI_EN;
}


//*****************************************************************************
//
//! Enables software sync operation
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function enables the SW Sync to copy min and max values from
//! shadow to active registers immediately is shadowing is enabled.
//!
//! Valid values for the input variable:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_enableSoftwareSync(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_SHADOW_CTL;

    //
    // Generates SW Sync for MUNIT
    //
    HWREG(base + munitOffset) |= ECAP_MUNIT_1_SHADOW_CTL_SWSYNC;
}


//*****************************************************************************
//
//! Selects the shadow to active load mode
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param loadMode is the shadow to active mode to be selected.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - loadMode:
//!    - ECAP_ACTIVE_LOAD_SYNC_EVT       - Active loaded with shadow on
//!                                        next sync event
//!    - ECAP_ACTIVE_LOAD_GLDLCSTRB_EVT  - Active loaded with shadow on
//!                                        EPWM GLDLCSTRB event
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_selectShadowLoadMode(uint32_t base, MUNIT_Number munit,
                          uint32_t loadMode)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_SHADOW_CTL;

    //
    // Select shadow to active load mode for MUNIT
    //
    HWREG(base + munitOffset) =
            (HWREG(base + munitOffset) &
             ~ECAP_MUNIT_1_SHADOW_CTL_LOADMODE) |
            (loadMode << 2U);
}



//*****************************************************************************
//
//! Configure minimum value for monitoring
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param minValue is the minimum value for monitoring.
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - minValue:
//!    - Range from 0x0 to 0xFFFFFFFF
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_configureMinValue(uint32_t base, MUNIT_Number munit,
                       uint32_t minValue)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_MIN;

    //
    // Load minimum value for monitoring
    //
    HWREG(base + munitOffset) = minValue;
}


//*****************************************************************************
//
//! Configure maximum value for monitoring
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param maxValue is the maximum value for monitoring.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - maxValue:
//!    - Range from 0x0 to 0xFFFFFFFF
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_configureMaxValue(uint32_t base, MUNIT_Number munit,
                       uint32_t maxValue)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_MAX;

    //
    // Load maximum value for monitoring
    //
    HWREG(base + munitOffset) = maxValue;
}


//*****************************************************************************
//
//! Configure minimum value for shadow register
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param minValue is the minimum value for monitoring.
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - minValue:
//!    - Range from 0x0 to 0xFFFFFFFF
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_configureShadowMinValue(uint32_t base, MUNIT_Number munit,
                             uint32_t minValue)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_MIN_SHADOW;

    //
    // Load minimum value for monitoring
    //
    HWREG(base + munitOffset) = minValue;
}



//*****************************************************************************
//
//! Configure maximum value for shadow register
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//! \param maxValue is the maximum value for monitoring.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//! - maxValue:
//!    - Range from 0x0 to 0xFFFFFFFF
//!
//! \return None.
//
//*****************************************************************************
static inline void
ECAP_configureShadowMaxValue(uint32_t base, MUNIT_Number munit,
                             uint32_t maxValue)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_MAX_SHADOW;

    //
    // Load maximum value for monitoring
    //
    HWREG(base + munitOffset) = maxValue;
}


//*****************************************************************************
//
//! Returns observed minimum value
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function returns the observed minimum value when the DEBUG_RANGE_EN
//! bit is set to 1.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return returns the observed minimum value.
//
//*****************************************************************************
static inline uint32_t
ECAP_observedMinValue(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_DEBUG_RANGE_MIN;

    //
    // Returns minimum value
    //
    return(HWREG(base + munitOffset));
}


//*****************************************************************************
//
//! Returns observed maximum value
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function returns the observed maximum value when the DEBUG_RANGE_EN
//! bit is set to 1.
//!
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return returns the observed maximum value.
//
//*****************************************************************************
static inline uint32_t
ECAP_observedMaxValue(uint32_t base, MUNIT_Number munit)
{
    uint32_t munitOffset;
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    munitOffset = (ECAP_MUNIT_STEP * munit) + ECAP_O_MUNIT_1_DEBUG_RANGE_MAX;

    //
    // Returns maximum value
    //
    return(HWREG(base + munitOffset));
}

//*****************************************************************************
//
//! systermclk divider
//!
//! \param base is the base address of the ECAP signal monitoring module.
//! \param munit is the monitoring unit, either 1 or 2.
//!
//! This function returns the observed maximum value when the DEBUG_RANGE_EN
//! bit is set to 1.
//![
//! Valid values for the input variables are:
//! - munit:
//!    - ECAP_MONITORING_UNIT_1 - ECAP Monitoring Unit 1
//!    - ECAP_MONITORING_UNIT_2 - ECAP Monitoring Unit 2
//!
//! \return returns the observed maximum value.
//
//*****************************************************************************
static inline void
ECAP_clkdiv(uint32_t base, CLK_DIVNUM div)
{
    //
    // Check the arguments
    //
    ASSERT(ECAP_isBaseValid(base));

    //
    // Get the offset to the appropriate MUNIT configuration register.
    //
    HWREG(base + ECAP_O_TSCTR_DIV) =div;
}
#endif



/**
 * \brief   This function configures the eCAP counter, TSCTR,  to the desired emulation
 *          mode when emulation suspension occurs. Valid inputs for mode are:
 *          - ECAP_EMULATION_STOP  - Counter is stopped immediately.
 *          - ECAP_EMULATION_RUN_TO_ZERO - Counter runs till it reaches 0.
 *          - ECAP_EMULATION_FREE_RUN - Counter is not affected.
 *
 * \param   base   base is the base address of the ECAP module.
 * \param   mode   mode is the emulation mode.
 *
 * \retval  None
 */
extern void ECAP_setEmulationMode(uint32_t base, 
                                  ECAP_EmulationMode mode);

 #ifdef __cplusplus
}
#endif

#endif

