/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    version.h
*   @brief   
*
*/
/*
 * commit history
 * 20240720, Jason, initial creation.
 */

#ifndef DRIVERLIB_VERSION_H_
#define DRIVERLIB_VERSION_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* GS32 Version Check */
#define __COUNT_ARGS(_0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _n, x...) _n
#define COUNT_ARGS(ver...) __COUNT_ARGS(, ##ver, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0)

#define __IS_GS32(...)                        __GS32_NAME(COUNT_ARGS(__VA_ARGS__))

#define __GS32_NAME(var_cnt)                  __GS32_NAME_1(var_cnt)
#define __GS32_NAME_1(var_cnt)                __GS32##_##var_cnt

#define __GS32_ASIC(part, ver)                ((GS32##part & 0xFF00) == ((ver)<<8))
#define __GS32_REVISION(part, ver)            ((GS32##part & 0x00FF) == (ver))
#define __GS32_ALL(part, ver)                 (__GS32_ASIC(part, ver) || __GS32_FPGA(part, ver))

#define __GS32_1__(part, suffix, ver)         __GS32##suffix(part, ver)
#define __GS32_2__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_1__(part, suffix, __VA_ARGS__)
#define __GS32_3__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_2__(part, suffix, __VA_ARGS__)
#define __GS32_4__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_3__(part, suffix, __VA_ARGS__)
#define __GS32_5__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_4__(part, suffix, __VA_ARGS__)
#define __GS32_6__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_5__(part, suffix, __VA_ARGS__)
#define __GS32_7__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_6__(part, suffix, __VA_ARGS__)
#define __GS32_8__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_7__(part, suffix, __VA_ARGS__)
#define __GS32_9__(part, suffix, ver, ...)    __GS32##suffix(part, ver) || __GS32_8__(part, suffix, __VA_ARGS__)

#define __GS32_0(part, suffix, ...)           (defined(GS32##part))
#define __GS32_1(part, suffix, ...)           (defined(GS32##part) && (__GS32_1__(part, suffix, __VA_ARGS__)))
#define __GS32_2(part, suffix, ...)           (defined(GS32##part) && (__GS32_2__(part, suffix, __VA_ARGS__)))
#define __GS32_3(part, suffix, ...)           (defined(GS32##part) && (__GS32_3__(part, suffix, __VA_ARGS__)))
#define __GS32_4(part, suffix, ...)           (defined(GS32##part) && (__GS32_4__(part, suffix, __VA_ARGS__)))
#define __GS32_5(part, suffix, ...)           (defined(GS32##part) && (__GS32_5__(part, suffix, __VA_ARGS__)))
#define __GS32_6(part, suffix, ...)           (defined(GS32##part) && (__GS32_6__(part, suffix, __VA_ARGS__)))
#define __GS32_7(part, suffix, ...)           (defined(GS32##part) && (__GS32_7__(part, suffix, __VA_ARGS__)))
#define __GS32_8(part, suffix, ...)           (defined(GS32##part) && (__GS32_8__(part, suffix, __VA_ARGS__)))
#define __GS32_9(part, suffix, ...)           (defined(GS32##part) && (__GS32_9__(part, suffix, __VA_ARGS__)))

/*
 * example:
 *  IS_GS32F3xx()           <==> defined(GS32F3xx)
 *  IS_GS32F3xx(0x20)       <==> defined(GS32F3xx) && ((GS32F3xx & 0xFF00) == 0x0020 || (GS32F3xx & 0xFF00) == 0x2000)
 *  IS_GS32F3xx(0x20, 0x22) <==> defined(GS32F3xx) && ((GS32F3xx & 0xFF00) == 0x0020 || (GS32F3xx & 0xFF00) == 0x2000  || \
 *                                                     (GS32F3xx & 0xFF00) == 0x0022 || (GS32F3xx & 0xFF00) == 0x2200)
 *  ....
 * */
#define IS_GS32F00xx(...)             __IS_GS32(__VA_ARGS__)(F00xx, _ASIC, __VA_ARGS__)
#define IS_GS32F3xx(...)              __IS_GS32(__VA_ARGS__)(F3xx, _ASIC, __VA_ARGS__)

/*
 * example:
 *  IS_GS32_REVISION(0)    <==> (defined(GS32F3xx) && (GS32F3xx & 0x00FF) == 0) || (defined(GS32F00xx) && (GS32F00xx & 0x00FF) == 0)
 *  IS_GS32_REVISION(0, 1) <==> (defined(GS32F3xx) && ((GS32F3xx & 0x00FF) == 0 || (GS32F3xx & 0x00FF) == 1) || \
 *                              (defined(GS32F00xx) && ((GS32F00xx & 0x00FF) == 0 || (GS32F00xx & 0x00FF) == 1)
 *  ....
 * */
#define IS_GS32_REVISION(...)         (__IS_GS32(__VA_ARGS__)(F00xx, _REVISION, __VA_ARGS__) || __IS_GS32(__VA_ARGS__)(F3xx, _REVISION, __VA_ARGS__))
#define IS_GS32_PROTOTYPE()           IS_GS32_REVISION(0xFF)

/*
 * example:
 *  GS32_REVISION >= 3
 *  ....
 * */
#ifdef GS32F00xx
#define GS32_REVISION                 (GS32F00xx & 0xFF)
#elif defined(GS32F3xx)
#define GS32_REVISION                 (GS32F3xx & 0xFF)
#else
#define GS32_REVISION                 (0)
#endif

/*
 * ADC version define
 */
#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
/* Convert 14 bits internally to 12 bits.
 * - Add repeater/oversampling/undersampling modes and corresponding PPB MAX/MIN/SUM processing.
 * - Add four new SOCs.
 */
#define ADC_VERSION             0002
// #define ADC_FEATURE_REPEAT		1
#elif IS_GS32F00xx(0x30)
/*
	for ADC_REGSx Registers:
	modify ADCSOC16/17/18/19CTL offset address, add ADCSOC20CTL
	ADCCTL1 ADCSOCCTL[0-19]bitfield was changed
	for ADC_RESULT_REGSx Registers
	add ADC_O_RESULT20,ADC_E_RESULT20,ADC_E_SCALE20,ADC_E_OFFSET20,all ADC_E_SCALE/OFFSET offset address was changed
*/
#define ADC_VERSION 0003 // support for 3.0

#else

    #error "unknown adc version"

#endif

/*
 * EPWM version define
 */
#if IS_GS32F00xx(0x12)
    #if GS32_PART_NUM==0x0049
    #define EPWM_VERSION             12
    #elif GS32_PART_NUM==0x0039 || GS32_PART_NUM==0x0025A || GS32_PART_NUM==0x00137A|| GS32_PART_NUM==0x5000A
    #define EPWM_VERSION             12
    #endif
#elif IS_GS32F3xx(0x22)
    #if GS32_PART_NUM==0x0379 || GS32_PART_NUM==0x0377 ||  GS32_PART_NUM==0x0374
    #define EPWM_VERSION             22
    #elif GS32_PART_NUM==0x0388A || GS32_PART_NUM==0x0650
    #define EPWM_VERSION             22
    #endif
#elif IS_GS32F00xx(0x30)
    #define EPWM_VERSION             30
#else
    #error "unknown epwm version"
#endif

#define GS32_FW_VERSION             1030501         //1.3.5.1

#define GS32_FW_VERSION_MAJOR       (GS32_FW_VERSION/100/100/100)
#define GS32_FW_VERSION_MINOR       ((GS32_FW_VERSION/10000)%100)
#define GS32_FW_VERSION_REVISION    ((GS32_FW_VERSION/100)%100)
#define GS32_FW_VERSION_PATCH       (GS32_FW_VERSION%100)

#define GS32_FW_VERSION_RC          0

#ifdef __cplusplus
}
#endif


#endif /* DRIVERLIB_VERSION_H_ */
