/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    hw_dsp_apb_cfg.h
 *   @brief
 *
 */

#ifndef DEVICE_DRIVERLIB_DSP_APB_CFG_H_
#define DEVICE_DRIVERLIB_DSP_APB_CFG_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the apb1_comm_para register offsets

#if IS_GS32F00xx(0x30)
/* Lock control register */
#define CFG_DSP_LOCK           0x0U

/* Exception mask signal in NICE */
#define CFG_NICE2CORE_EXCP_MSK 0x4U

/* NICE rounding mode encoding register */
#define CFG_NICE_FP_RND        0x8U

/* PWM mode */
#define CFG_DSP_PWM_MODE       0xCU

/* NICE rounding mode encoding register */
#define CFG_VEC_3P2L_OC_EN     0x10U

/* NICE interrupt source */
#define CFG_NICE_INTR_RAW      0x14U

/* NICE interrupt mask register */
#define CFG_NICE_INTR_MASK     0x18U

/* NICE interrupt report register */
#define CFG_NICE_INTR          0x1CU

/* Reserved register */
#define CFG_DSP_SPARE0         0x400U

/* Reserved register */
#define CFG_DSP_SPARE1         0x404U

/* Reserved register */
#define CFG_DSP_SPARE2         0x408U

/* ILM 64K space swap configuration */
#define ILM_SWAP_EN            0x800U

/* Software record register */
#define DIG_SYSCTL_POR_FLAG0   0x900U

/* Software record register */
#define DIG_SYSCTL_POR_FLAG1   0x904U

/* Software record register */
#define DIG_SYSCTL_SYS_FLAG0   0x908U

/* Software record register */
#define DIG_SYSCTL_SYS_FLAG1   0x90CU

/* Reserved register */
#define DIG_POR_SPARE0         0xF00U

/* Reserved register */
#define DIG_POR_SPARE1         0xF04U

/* Reserved register */
#define DIG_POR_SPARE2         0xF08U

/* Reserved register */
#define DIG_SYS_SPARE0         0xF10U

/* Reserved register */
#define DIG_SYS_SPARE1         0xF14U

/* Reserved register */
#define DIG_SYS_SPARE2         0xF18U

#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_DSP_LOCK register
//
//*************************************************************************************************
#define CFG_DSP_LOCK_CFG_DSP_LOCK_M 0XFFFFFFFFU
#define CFG_DSP_LOCK_CFG_DSP_LOCK_S 0U
#define CFG_DSP_LOCK_CFG_DSP_LOCK_UNLOCK_VALUE 0X5A5A5A5AU

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_NICE2CORE_EXCP_MSK register
//
//*************************************************************************************************
#define CFG_NICE2CORE_EXCP_MSK_CFG_NICE2CORE_EXCP_MSK_M 0XFFFFFFFFU
#define CFG_NICE2CORE_EXCP_MSK_CFG_NICE2CORE_EXCP_MSK_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_NICE_FP_RND register
//
//*************************************************************************************************
#define CFG_NICE_FP_RND_CFG_NICE_FP_RND_M 0X7U
#define CFG_NICE_FP_RND_CFG_NICE_FP_RND_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_DSP_PWM_MODE register
//
//*************************************************************************************************
#define CFG_DSP_PWM_MODE_CFG_DSP_PWM_MODE_M 0XFFU
#define CFG_DSP_PWM_MODE_CFG_DSP_PWM_MODE_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_VEC_3P2L_OC_EN register
//
//*************************************************************************************************
#define CFG_VEC_3P2L_OC_EN_CFG_VEC_3P2L_OC_EN_M 0X1U
#define CFG_VEC_3P2L_OC_EN_CFG_VEC_3P2L_OC_EN_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_NICE_INTR_RAW register
//
//*************************************************************************************************
#define CFG_NICE_INTR_RAW_CFG_NICE_INTR_RAW_M 0XFFFFFFFFU
#define CFG_NICE_INTR_RAW_CFG_NICE_INTR_RAW_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_NICE_INTR_MASK register
//
//*************************************************************************************************
#define CFG_NICE_INTR_MASK_CFG_NICE_INTR_MASK_M 0XFFFFFFFFU
#define CFG_NICE_INTR_MASK_CFG_NICE_INTR_MASK_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_NICE_INTR register
//
//*************************************************************************************************
#define CFG_NICE_INTR_CFG_NICE_INTR_M 0XFFFFFFFFU
#define CFG_NICE_INTR_CFG_NICE_INTR_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_DSP_SPARE0 register
//
//*************************************************************************************************
#define CFG_DSP_SPARE0_CFG_DSP_SPARE0_M 0XFFFFFFFFU
#define CFG_DSP_SPARE0_CFG_DSP_SPARE0_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_DSP_SPARE1 register
//
//*************************************************************************************************
#define CFG_DSP_SPARE1_CFG_DSP_SPARE1_M 0XFFFFFFFFU
#define CFG_DSP_SPARE1_CFG_DSP_SPARE1_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CFG_DSP_SPARE2 register
//
//*************************************************************************************************
#define CFG_DSP_SPARE2_CFG_DSP_SPARE2_M 0XFFFFFFFFU
#define CFG_DSP_SPARE2_CFG_DSP_SPARE2_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the ILM_SWAP_EN register
//
//*************************************************************************************************
#define ILM_SWAP_EN_SWAP_SRAM_SW_EN_M 0X2U
#define ILM_SWAP_EN_SWAP_SRAM_SW_EN_S 1U
#define ILM_SWAP_EN_LM_SWAP_EN_M 0X1U
#define ILM_SWAP_EN_LM_SWAP_EN_S 0U


//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYSCTL_POR_FLAG0 register
//
//*************************************************************************************************
#define DIG_SYSCTL_POR_FLAG0_DIG_SYSCTL_POR_FLAG0_M 0XFFFFFFFFU
#define DIG_SYSCTL_POR_FLAG0_DIG_SYSCTL_POR_FLAG0_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYSCTL_POR_FLAG1 register
//
//*************************************************************************************************
#define DIG_SYSCTL_POR_FLAG1_DIG_SYSCTL_POR_FLAG1_M 0XFFFFFFFFU
#define DIG_SYSCTL_POR_FLAG1_DIG_SYSCTL_POR_FLAG1_S 0U


//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYSCTL_SYS_FLAG0 register
//
//*************************************************************************************************
#define DIG_SYSCTL_SYS_FLAG0_DIG_SYSCTL_SYS_FLAG0_M 0XFFFFFFFFU
#define DIG_SYSCTL_SYS_FLAG0_DIG_SYSCTL_SYS_FLAG0_S 0U


//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYSCTL_SYS_FLAG1 register
//
//*************************************************************************************************
#define DIG_SYSCTL_SYS_FLAG1_DIG_SYSCTL_SYS_FLAG1_M 0XFFFFFFFFU
#define DIG_SYSCTL_SYS_FLAG1_DIG_SYSCTL_SYS_FLAG1_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_POR_SPARE0 register
//
//*************************************************************************************************
#define DIG_POR_SPARE0_DIG_POR_SPARE0_M 0XFFFFFFFFU
#define DIG_POR_SPARE0_DIG_POR_SPARE0_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_POR_SPARE1 register
//
//*************************************************************************************************
#define DIG_POR_SPARE1_DIG_POR_SPARE1_M 0XFFFFFFFFU
#define DIG_POR_SPARE1_DIG_POR_SPARE1_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_POR_SPARE2 register
//
//*************************************************************************************************
#define DIG_POR_SPARE2_DIG_POR_SPARE2_M 0XFFFFFFFFU
#define DIG_POR_SPARE2_DIG_POR_SPARE2_S 0U


//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYS_SPARE0 register
//
//*************************************************************************************************
#define DIG_SYS_SPARE0_DIG_SYS_SPARE0_M 0XFFFFFFFFU
#define DIG_SYS_SPARE0_DIG_SYS_SPARE0_S 0U

//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYS_SPARE1 register
//
//*************************************************************************************************
#define DIG_SYS_SPARE1_DIG_SYS_SPARE1_M 0XFFFFFFFFU
#define DIG_SYS_SPARE1_DIG_SYS_SPARE1_S 0U


//*************************************************************************************************
//
// The following are defines for the bit fields in the DIG_SYS_SPARE2 register
//
//*************************************************************************************************
#define DIG_SYS_SPARE2_DIG_SYS_SPARE2_M 0XFFFFFFFFU
#define DIG_SYS_SPARE2_DIG_SYS_SPARE2_S 0U

#ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_DSP_APB_CFG_H_ */
