/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_gpio.h
*   @brief   Definitions for the GPIO registers.
*
*/

#ifndef DEVICE_HW_GPIO_H_
#define DEVICE_HW_GPIO_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//Base
//#define GPIODATA_BASE             0x40310000U

//Offset
#define GPIO_DATA						0x0U		 // GPIO DATA Register (GPIO0 to 15)
#define GPIO_DATAOUT       	0x4U     // GPIO DATAOUT Register (GPIO0 to 15)
#define GPIO_OUTENSET       0x10U    // GPIO OUTENSET Register (GPIO0 to 15)
#define GPIO_OUTENCLR       0x14U    // GPIO OUTENCLR Register (GPIO0 to 15)
#define GPIO_INTENSET 			0x0020U	 // GPIO Interrupt enable set (GPIO0 to 15)
#define GPIO_INTENCLR 			0x0024U	 // GPIO Interrupt enable clear (GPIO0 to 15)
#define GPIO_INTTYPESET 		0x0028U	 // GPIO Interrupt type set (GPIO0 to 15)
#define GPIO_INTTYPECLR 		0x002CU	 // GPIO Interrupt type clear (GPIO0 to 15)
#define GPIO_INTPOLSET 			0x0030U	 // GPIO Polarity-level set (GPIO0 to 15)
#define GPIO_INTPOLCLR 			0x0034U	 // GPIO Polarity-level clear (GPIO0 to 15)
#define GPIO_INTSTATUS 			0x0038U	 // GPIO Interrupt status
#define GPIO_INTCLEAR 			0x0038U	 // GPIO Interrupt clear
#define GPIO_MASKLOWBYTE 		0x0400U	 // GPIO Lower eight bits masked access
#define GPIO_MASKHIGHBYTE 		0x0800U	 // GPIO Higher eight bits masked access





/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */


/* None */



#ifdef __cplusplus
}
#endif


#endif /* DEVICE_HW_GPIO_H_ */

