/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_QSPI.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_QSPI_H_
#define DEVICE_DRIVERLIB_HW_QSPI_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the QSPI register offsets

#define QSPI_CTRLR0		0X00U
#define QSPI_CTRLR1		0X04U
#define QSPI_SSIENR		0X08U
#define QSPI_MWCR		0X0CU
#define QSPI_SER		0X10U
#define QSPI_BAUDR		0X14U
#define QSPI_TXFTLR		0X18U
#define QSPI_RXFTLR		0X1CU
#define QSPI_TXFLR		0X20U
#define QSPI_RXFLR		0X24U
#define QSPI_SR		    0X28U
#define QSPI_IMR		0X2CU
#define QSPI_ISR		0X30U
#define QSPI_RISR		0X34U
#define QSPI_TXEICR		0X38U
#define QSPI_RXOICR		0X3CU
#define QSPI_RXUICR		0X40U
#define QSPI_MSTICR		0X44U
#define QSPI_ICR		0X48U
#define QSPI_DMACR		0X4CU
#define QSPI_DMATDLR		0X50U
#define QSPI_DMARDLR		0X54U
#define QSPI_IDR		0X58U
#define QSPI_DR0		0X60U
#define QSPI_SPI_CTRLR0		0XF4U
#define QSPI_DDR_DRIVE_EDGE		0XF8U
#define QSPI_XIP_MODE_BITS		0XFCU
#define QSPI_XIP_INCR_INST		0X100U
#define QSPI_XIP_WRAP_INST		0X104U
#define QSPI_XIP_CTRL		0X108U
#define QSPI_XRXOICR		0X110U
#define QSPI_XIP_CNT_TIME_OUT		0X114U
#define QSPI_SPI_CTRLR1		0X118U
#define QSPI_XIP_WRITE_INCR_INST		0X140U
#define QSPI_WRAP_WRITE_INST		0X144U
#define QSPI_XIP_WRITE_CTRL		0X148U

// The following are defines for the bit fields in the CTRLR0 register by QSPI

// This field selects if DWC_ssi is working in Controller or Target mode
// 0x1 (CONTROLLER): DWC_ssi is Controller
// 0x0 (TARGET): DWC_ssi is Target
#define QSPI_CTRLR0_SSI_IS_MST_M		0X80000000U
#define QSPI_CTRLR0_SSI_IS_MST_S		31U
// Clock loop back enable bit. Once this bit is set to 1, DWC_ssi will use looped back clock (mst_sclk_in)
// to capture read data
// 0x0 (DISABLE): Disable Clock Loop Back
// 0x1 (ENABLE): Enable Clock Loop Back
#define QSPI_CTRLR0_CLK_LOOP_EN_M		0X4000000U
#define QSPI_CTRLR0_CLK_LOOP_EN_S		26U
// Enable Dynamic wait states in SPI mode of operation. This field is only applicable when CTRLR0.FRF is
// set to 0 (Motorola SPI Frame Format).
// 0x0 (DISABLE): Disable SPI Dynamic Wait State
// 0x1 (ENABLE): Enable SPI Dynamic Wait State
#define QSPI_CTRLR0_SPI_DWS_EN_M		0X2000000U
#define QSPI_CTRLR0_SPI_DWS_EN_S		25U
//  SPI Hyperbus Frame format enable.
// 0x0 (DISABLE): Disable Hyperbus Format
// 0x1 (ENABLE): Enable Hyperbus Format
#define QSPI_CTRLR0_SPI_HYPERBUS_EN_M		0X1000000U
#define QSPI_CTRLR0_SPI_HYPERBUS_EN_S		24U
// SPI Frame Format Selects data frame format for Transmitting/Receiving the data. Bits only valid when
// SSIC_SPI_MODE is either set to "Dual" or "Quad" or "Octal" mode.
// 0x0 (SPI_STANDARD): Standard SPI Format
// 0x1 (SPI_DUAL): Dual SPI Format
// 0x2 (SPI_QUAD): Quad SPI Format
// 0x3 (SPI_OCTAL): Octal SPI Format
#define QSPI_CTRLR0_SPI_FRF_M		0XC00000U
#define QSPI_CTRLR0_SPI_FRF_S		22U
// Control Frame Size.Selects the length of the control word for the Microwire frame format.
// 0x0 (SIZE_01_BIT): 01-bit Control Word
// 0x1 (SIZE_02_BIT): 02-bit Control Word
// 0x2 (SIZE_03_BIT): 03-bit Control Word
// 0x3 (SIZE_04_BIT): 04-bit Control Word
// 0x4 (SIZE_05_BIT): 05-bit Control Word
// 0x5 (SIZE_06_BIT): 06-bit Control Word
// 0x6 (SIZE_07_BIT): 07-bit Control Word
// 0x7 (SIZE_08_BIT): 08-bit Control Word
// 0x8 (SIZE_09_BIT): 09-bit Control Word
// 0x9 (SIZE_10_BIT): 10-bit Control Word
// 0xa (SIZE_11_BIT): 11-bit Control Word
// 0xb (SIZE_12_BIT): 12-bit Control Word
// 0xc (SIZE_13_BIT): 13-bit Control Word
// 0xd (SIZE_14_BIT): 14-bit Control Word
// 0xe (SIZE_15_BIT): 15-bit Control Word
// 0xf (SIZE_16_BIT): 16-bit Control Word
#define QSPI_CTRLR0_CFS_M		0XF0000U
#define QSPI_CTRLR0_CFS_S		16U
// Target Select Toggle Enable.While operating in SPI mode with clock phase (SCPH) set to 0, this register
// controls the behavior of the chip select line (ss_*_n) between data frames.
// 0x1 (TOGGLE_EN): ss_*_n line will toggle between consecutive data frames, with the serial clock (sclk)
// being held to its default value while ss_*_n is high
// 0x0 (TOGGLE_DISABLE): ss_*_n will stay low and sclk will run continuously for the duration of the transfer
#define QSPI_CTRLR0_SSTE_M		0X4000U
#define QSPI_CTRLR0_SSTE_S		14U
// Shift Register Loop.Used for testing purposes only. When internally active, connects the transmit shift
// register output to the receive shift register input. 
// 0x1 (TESTING_MODE): Test Mode Operation
// 0x0 (NORMAL_MODE): Normal mode operation
#define QSPI_CTRLR0_SRL_M		0X2000U
#define QSPI_CTRLR0_SRL_S		13U
// Target Output Enable.Relevant only when the DWC_ssi is configured as a serial-target device. When configured
// as a serial controller, this bit field has no functionality. 
// 0x1 (DISABLED): Target Output is disabled
// 0x0 (ENABLED): Target Output is enabled
#define QSPI_CTRLR0_SLV_OE_M		0X1000U
#define QSPI_CTRLR0_SLV_OE_S		12U
// Transfer Mode.
// 0x0 (TX_AND_RX): Transmit & Receive; Not Applicable in enhanced SPI operating mode or when SSIC_HAS_TX_RX_EN
// is set to 0
// 0x1 (TX_ONLY): Transmit only mode; Or Write in enhanced SPI operating mode
// 0x2 (RX_ONLY): Receive only mode; Or Read in enhanced SPI operating mode
// 0x3 (EEPROM_READ): EEPROM Read mode; Not Applicable in enhanced SPI operating mode
#define QSPI_CTRLR0_TMOD_M		0XC00U
#define QSPI_CTRLR0_TMOD_S		10U
// Serial Clock Polarity.Valid when the frame format (FRF) is set to Motorola SPI. 
// 0x0 (INACTIVE_HIGH): Inactive state of serial clock is low
// 0x1 (INACTIVE_LOW): Inactive state of serial clock is high
#define QSPI_CTRLR0_SCPOL_M		0X200U
#define QSPI_CTRLR0_SCPOL_S		9U
// Serial Clock Phase.Valid when the frame format (FRF) is set to Motorola SPI. 
// When SCPH = 0, data are captured on the first edge of the serial clock. When SCPH = 1, the serial clock
// starts toggling one cycle after the chip select line is activated, and data are captured on the second
// edge of the serial clock.
// 0x1 (START_BIT): Serial clock toggles at start of first bit
// 0x0 (MIDDLE_BIT): Serial clock toggles in middle of first bit
#define QSPI_CTRLR0_SCPH_M		0X100U
#define QSPI_CTRLR0_SCPH_S		8U
//  Frame Format.Selects which serial protocol transfers the data.
// 0x0 (SPI): Motorola SPI Frame Format
// 0x1 (SSP): Texas Instruments SSP Frame Format
// 0x2 (MICROWIRE): National Semiconductors Microwire Frame Format
// 0x3 (RESERVED): Reserved
#define QSPI_CTRLR0_FRF_M		0XC0U
#define QSPI_CTRLR0_FRF_S		6U
// Data Frame Size.
// Note: When SSIC_SPI_MODE is set to "Dual", "Quad" or "Octal" mode and SPI_FRF is not set to 2'b00:
// DFS value must be a multiple of 2 if SPI_FRF = 01
// DFS value must be multiple of 4 if SPI_FRF = 10
// DFS value must be multiple of 8 if SPI_FRF = 11
// 0x0 (DFS_01_BIT): Reserved
// 0x1 (DFS_02_BIT): Reserved
// 0x2 (DFS_03_BIT): Reserved
// 0x3 (DFS_04_BIT): 04-bit serial data transfer
// 0x4 (DFS_05_BIT): 05-bit serial data transfer
// 0x5 (DFS_06_BIT): 06-bit serial data transfer
// 0x6 (DFS_07_BIT): 07-bit serial data transfer
// 0x7 (DFS_08_BIT): 08-bit serial data transfer
// 0x8 (DFS_09_BIT): 09-bit serial data transfer
// 0x9 (DFS_10_BIT): 10-bit serial data transfer
// 0xa (DFS_11_BIT): 11-bit serial data transfer
// 0xb (DFS_12_BIT): 12-bit serial data transfer
// 0xc (DFS_13_BIT): 13-bit serial data transfer
// 0xd (DFS_14_BIT): 14-bit serial data transfer
// 0xe (DFS_15_BIT): 15-bit serial data transfer
// 0xf (DFS_16_BIT): 16-bit serial data transfer
// 0x10 (DFS_17_BIT): 17-bit serial data transfer
// 0x11 (DFS_18_BIT): 18-bit serial data transfer
// 0x12 (DFS_19_BIT): 19-bit serial data transfer
// 0x13 (DFS_20_BIT): 20-bit serial data transfer
// 0x14 (DFS_21_BIT): 21-bit serial data transfer
// 0x15 (DFS_22_BIT): 22-bit serial data transfer
// 0x16 (DFS_23_BIT): 23-bit serial data transfer
// 0x17 (DFS_24_BIT): 24-bit serial data transfer
// 0x18 (DFS_25_BIT): 25-bit serial data transfer
// 0x19 (DFS_26_BIT): 26-bit serial data transfer
// 0x1a (DFS_27_BIT): 27-bit serial data transfer
// 0x1b (DFS_28_BIT): 28-bit serial data transfer
// 0x1c (DFS_29_BIT): 29-bit serial data transfer
// 0x1d (DFS_30_BIT): 30-bit serial data transfer
// 0x1e (DFS_31_BIT): 31-bit serial data transfer
// 0x1f (DFS_32_BIT): 32-bit serial data transfer
#define QSPI_CTRLR0_DFS_M		0X1FU
#define QSPI_CTRLR0_DFS_S		0U

// The following are defines for the bit fields in the CTRLR1 register by QSPI

// Number of Data Frames.
// When TMOD = 10 or TMOD = 11 , this register field sets the number of data frames to be continuously received
// by the DWC_ssi.
#define QSPI_CTRLR1_NDF_M		0XFFFFU
#define QSPI_CTRLR1_NDF_S		0U

// The following are defines for the bit fields in the SSIENR register by QSPI

// SSI Enable.
// Enables and disables all DWC_ssi operations. When disabled, all serial transfers are halted immediately.
// Transmit and receive FIFO buffers are cleared when the device is disabled. It is impossible to program
// some of the DWC_ssi control registers when enabled. When disabled, the ssi sleep output is set (after
// delay) to inform the system that it is safe to remove the ssi_clk, thus saving power consumption in
// the system.
// 0x1 (ENABLED): Enables DWC_ssi
// 0x0 (DISABLE): Disables DWC_ssi
#define QSPI_SSIENR_SSIC_EN_M		0X1U
#define QSPI_SSIENR_SSIC_EN_S		0U

// The following are defines for the bit fields in the MWCR register by QSPI

// Microwire Handshaking.
// 0x1 (ENABLED): handshaking interface is enabled
// 0x0 (DISABLE): handshaking interface is disabled
#define QSPI_MWCR_MHS_M		0X4U
#define QSPI_MWCR_MHS_S		2U
// Microwire Control.
// 0x1 (TRANSMIT): SSI transmits data
// 0x0 (RECEIVE): SSI receives data
#define QSPI_MWCR_MDD_M		0X2U
#define QSPI_MWCR_MDD_S		1U
// Microwire Transfer Mode.
// Defines whether the Microwire transfer is sequential or non-sequential. When sequential mode is used,
// only one control word is needed to transmit or receive a block of data words. When non-sequential mode
// is used, there must be a control word for each data word that is transmitted or received.
// 0x1 (SEQUENTIAL): Sequential Transfer
// 0x0 (NON_SEQUENTIAL): Non-Sequential Transfer
#define QSPI_MWCR_MWMOD_M		0X1U
#define QSPI_MWCR_MWMOD_S		0U

// The following are defines for the bit fields in the SER register by QSPI

// Chip Select Enable Flag.
#define QSPI_SER_SER_M		0X1U
#define QSPI_SER_SER_S		0U

// The following are defines for the bit fields in the BAUDR register by QSPI

// SSI Clock Divider.
// The LSB for this field is always set to 0 and is unaffected by a write operation, which ensures an even
// value is held in this register. If the value is 0, the serial output clock (sclk_out) is disabled. The
// frequency of the sclk_out is derived from the following equation:
// Fsclk_out = Fssi_clk/BAUDR
#define QSPI_BAUDR_SCKDV_M		0XFFFEU
#define QSPI_BAUDR_SCKDV_S		1U

// The following are defines for the bit fields in the TXFTLR register by QSPI

// Transfer start FIFO level.
// Used to control the level of entries in transmit FIFO above which transfer will start on serial line.
// This register can be used to ensure that sufficient data is present in transmit FIFO before starting
// a write operation on serial line.
// In Internal DMA mode, this field sets the minimum amount of data frames present in the FIFO after which
// DWC_ssi starts the transfer.
#define QSPI_TXFTLR_TXFTHR_M		0X1F0000U
#define QSPI_TXFTLR_TXFTHR_S		16U
// Transmit FIFO Threshold.
// Controls the level of entries (or below) at which the transmit FIFO controller triggers an interrupt.
// 
#define QSPI_TXFTLR_TFT_M		0X1FU
#define QSPI_TXFTLR_TFT_S		0U

// The following are defines for the bit fields in the RXFTLR register by QSPI

// Receive FIFO Threshold.

// Controls the level of entries (or above) at which the receive FIFO controller triggers an interrupt.
// 
#define QSPI_RXFTLR_RFT_M		0X1FU
#define QSPI_RXFTLR_RFT_S		0U

// The following are defines for the bit fields in the TXFLR register by QSPI

// Transmit FIFO Level.

// Contains the number of valid data entries in the transmit FIFO.
#define QSPI_TXFLR_TXTFL_M		0X3FU
#define QSPI_TXFLR_TXTFL_S		0U

// The following are defines for the bit fields in the RXFLR register by QSPI

// Receive FIFO Level.

// Contains the number of valid data entries in the receive FIFO.
#define QSPI_RXFLR_RXTFL_M		0X3FU
#define QSPI_RXFLR_RXTFL_S		0U

// The following are defines for the bit fields in the SR register by QSPI

// Completed Data frames This field indicates total data frames transferred in the previous internal DMA
// transfer
#define QSPI_SR_CMPLTD_DF_M		0XFFFF8000U
#define QSPI_SR_CMPLTD_DF_S		15U
// Data Collision Error.
// 0x1 (TX_COLLISION_ERROR): Transmit Data Collision Error
// 0x0 (NO_ERROR_CONDITION): No Error
#define QSPI_SR_DCOL_M		0X40U
#define QSPI_SR_DCOL_S		6U
// Transmission Error.
// Set if the transmit FIFO is empty when a transfer is started. This bit can be set only when the DWC_ssi
// is configured as a target device. Data from the previous transmission is resent on the txd line. This
// bit is cleared when read.
// 0x1 (TX_ERROR): Transmission Error
// 0x0 (NO_ERROR): No Error
#define QSPI_SR_TXE_M		0X20U
#define QSPI_SR_TXE_S		5U
// Receive FIFO Full.
// When the receive FIFO is completely full, this bit is set. When the receive FIFO contains one or more
// empty location, this bit is cleared.
// 0x1 (FULL): Receive FIFO is full
// 0x0 (NOT_FULL): Receive FIFO is not full
#define QSPI_SR_RFF_M		0X10U
#define QSPI_SR_RFF_S		4U
// Receive FIFO Not Empty.
// Set when the receive FIFO contains one or more entries and is cleared when the receive FIFO is empty.
// This bit can be polled by software to completely empty the receive FIFO.
// 0x1 (NOT_EMPTY): Receive FIFO is not empty
// 0x0 (EMPTY): Receive FIFO is empty
#define QSPI_SR_RFNE_M		0X8U
#define QSPI_SR_RFNE_S		3U
// Transmit FIFO Empty.
// When the transmit FIFO is completely empty, this bit is set. When the transmit FIFO contains one or more
// valid entries, this bit is cleared. This bit field does not request an interrupt.
// 0x1 (EMPTY): Transmit FIFO is empty
// 0x0 (NOT_EMPTY): Transmit FIFO is not empty
#define QSPI_SR_TFE_M		0X4U
#define QSPI_SR_TFE_S		2U
// Transmit FIFO Not Full.
// Set when the transmit FIFO contains one or more empty locations, and is cleared when the FIFO is full.
// 0x1 (NOT_FULL): Tx FIFO is not Full
// 0x0 (FULL): Tx FIFO is full
#define QSPI_SR_TFNF_M		0X2U
#define QSPI_SR_TFNF_S		1U
// SSI Busy Flag.
// When set, indicates that a serial transfer is in progress; when cleared indicates that the DWC_ssi is
// idle or disabled.
// 0x1 (ACTIVE): DWC_ssi is actively transferring data
// 0x0 (INACTIVE): DWC_ssi is idle or disabled
#define QSPI_SR_BUSY_M		0X1U
#define QSPI_SR_BUSY_S		0U

// The following are defines for the bit fields in the IMR register by QSPI

// SSI Done Interrupt Mask
// 0x1 (UNMASKED): ssi_done_intr interrupt is not masked
// 0x0 (MASKED): ssi_done_intr interrupt is masked
#define QSPI_IMR_DONEM_M		0X800U
#define QSPI_IMR_DONEM_S		11U
// SPI Transmit Error Interrupt Mask
// 0x1 (UNMASKED): ssi_spite_intr interrupt is not masked
// 0x0 (MASKED): ssi_spite_intr interrupt is masked
#define QSPI_IMR_SPITEM_M		0X400U
#define QSPI_IMR_SPITEM_S		10U
// AXI Error Interrupt Mask
// 0x1 (UNMASKED): ssi_axie_intr interrupt is not masked
// 0x0 (MASKED): ssi_axie_intr interrupt is masked
#define QSPI_IMR_AXIEM_M		0X100U
#define QSPI_IMR_AXIEM_S		8U
// Transmit FIFO Underflow Interrupt Mask
// 0x1 (UNMASKED): ssi_txu_intr interrupt is not masked
// 0x0 (MASKED): ssi_txu_intr interrupt is masked
#define QSPI_IMR_TXUIM_M		0X80U
#define QSPI_IMR_TXUIM_S		7U
// XIP Receive FIFO Overflow Interrupt Mask
// 0x1 (UNMASKED): ssi_xrxo_intr interrupt is not masked
// 0x0 (MASKED): ssi_xrxo_intr interrupt is masked
#define QSPI_IMR_XRXOIM_M		0X40U
#define QSPI_IMR_XRXOIM_S		6U
// Multi-Controller Contention Interrupt Mask. This bit field is not present if the DWC_ssi is configured
// as a serial-controller device.
// 0x1 (UNMASKED): ssi_mst_intr interrupt is not masked
// 0x0 (MASKED): ssi_mst_intr interrupt is masked
#define QSPI_IMR_MSTIM_M		0X20U
#define QSPI_IMR_MSTIM_S		5U
// Receive FIFO Full Interrupt Mask 0 - ssi_rxf_intr interrupt is masked 1 - ssi_rxf_intr interrupt is not
// masked
// 0x1 (UNMASKED): ssi_rxf_intr interrupt is not masked
// 0x0 (MASKED): ssi_rxf_intr interrupt is masked
#define QSPI_IMR_RXFIM_M		0X10U
#define QSPI_IMR_RXFIM_S		4U
// Receive FIFO Overflow Interrupt Mask
// 0x1 (UNMASKED): ssi_rxo_intr interrupt is not masked
// 0x0 (MASKED): ssi_rxo_intr interrupt is masked
#define QSPI_IMR_RXOIM_M		0X8U
#define QSPI_IMR_RXOIM_S		3U
// Receive FIFO Underflow Interrupt Mask
// 0x1 (UNMASKED): ssi_rxu_intr interrupt is not masked
// 0x0 (MASKED): ssi_rxu_intr interrupt is masked
#define QSPI_IMR_RXUIM_M		0X4U
#define QSPI_IMR_RXUIM_S		2U
// Transmit FIFO Overflow Interrupt Mask
// 0x1 (UNMASKED): ssi_txo_intr interrupt is not masked
// 0x0 (MASKED): ssi_txo_intr interrupt is masked
#define QSPI_IMR_TXOIM_M		0X2U
#define QSPI_IMR_TXOIM_S		1U
// Transmit FIFO Empty Interrupt Mask
// 0x1 (UNMASKED): ssi_txe_intr interrupt is not masked
// 0x0 (MASKED): ssi_txe_intr interrupt is masked
#define QSPI_IMR_TXEIM_M		0X1U
#define QSPI_IMR_TXEIM_S		0U

// The following are defines for the bit fields in the ISR register by QSPI

// SSI Done Interrupt Status
// 0x1 (ACTIVE): ssi_done_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_done_intr interrupt is not active after masking
#define QSPI_ISR_DONES_M		0X800U
#define QSPI_ISR_DONES_S		11U
// SPI Transmit Error Interrupt
// 0x1 (ACTIVE): ssi_spite_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_spite_intr interrupt is not active after masking
#define QSPI_ISR_SPITES_M		0X400U
#define QSPI_ISR_SPITES_S		10U
// AXI Error Interrupt Status
// 0x1 (ACTIVE): ssi_axie_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_axie_intr interrupt is not active after masking
#define QSPI_ISR_AXIES_M		0X100U
#define QSPI_ISR_AXIES_S		8U
// Transmit FIFO Underflow Interrupt Status
// 0x1 (ACTIVE): ssi_txu_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_txu_intr interrupt is not active after masking
#define QSPI_ISR_TXUIS_M		0X80U
#define QSPI_ISR_TXUIS_S		7U
// XIP Receive FIFO Overflow Interrupt Status
// 0x1 (ACTIVE): ssi_xrxo_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_xrxo_intr interrupt is not active after masking
#define QSPI_ISR_XRXOIS_M		0X40U
#define QSPI_ISR_XRXOIS_S		6U
// Multi-Controller Contention Interrupt Status. This bit field is not present if the DWC_ssi is configured
// as a serial-target device.
// 0x1 (ACTIVE): ssi_mst_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_mst_intr interrupt is not active after masking
#define QSPI_ISR_MSTIS_M		0X20U
#define QSPI_ISR_MSTIS_S		5U
// Receive FIFO Full Interrupt Status
// 0x1 (ACTIVE): ssi_rxf_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_rxf_intr interrupt is not active after masking
#define QSPI_ISR_RXFIS_M		0X10U
#define QSPI_ISR_RXFIS_S		4U
//  Receive FIFO Overflow Interrupt StatuS
// 0x1 (ACTIVE): ssi_rxo_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_rxo_intr interrupt is not active after masking
#define QSPI_ISR_RXOIS_M		0X8U
#define QSPI_ISR_RXOIS_S		3U
// Receive FIFO Underflow Interrupt Status
// 0x1 (ACTIVE): ssi_rxu_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_rxu_intr interrupt is not active after masking
#define QSPI_ISR_RXUIS_M		0X4U
#define QSPI_ISR_RXUIS_S		2U
// Transmit FIFO Overflow Interrupt Status
// 0x1 (ACTIVE): ssi_txo_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_txo_intr interrupt is not active after masking
#define QSPI_ISR_TXOIS_M		0X2U
#define QSPI_ISR_TXOIS_S		1U
// Transmit FIFO Empty Interrupt Status
// 0x1 (ACTIVE): ssi_txe_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_txe_intr interrupt is not active after masking
#define QSPI_ISR_TXEIS_M		0X1U
#define QSPI_ISR_TXEIS_S		0U

// The following are defines for the bit fields in the RISR register by QSPI

// SSI Done Interrupt Status
// 0x1 (ACTIVE): ssi_done_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_done_intr interrupt is not active prior to masking
#define QSPI_RISR_DONER_M		0X800U
#define QSPI_RISR_DONER_S		11U
// SPI Transmit Error Interrupt
// 0x1 (ACTIVE): ssi_spite_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_spite_intr interrupt is not active prior to masking
#define QSPI_RISR_SPITER_M		0X400U
#define QSPI_RISR_SPITER_S		10U
// AXI Error Interrupt Status
// 0x1 (ACTIVE): ssi_axie_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_axie_intr interrupt is not active prior to masking
#define QSPI_RISR_AXIER_M		0X100U
#define QSPI_RISR_AXIER_S		8U
// Transmit FIFO Underflow Interrupt Status
// 0x1 (ACTIVE): ssi_txu_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_txu_intr interrupt is not active prior to masking
#define QSPI_RISR_TXUIR_M		0X80U
#define QSPI_RISR_TXUIR_S		7U
// XIP Receive FIFO Overflow Interrupt Status
// 0x1 (ACTIVE): ssi_xrxo_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_xrxo_intr interrupt is not active prior to masking
#define QSPI_RISR_XRXOIR_M		0X40U
#define QSPI_RISR_XRXOIR_S		6U
// Multi-Controller Contention Interrupt Status. This bit field is not present if the DWC_ssi is configured
// as a serial-target device.
// 0x1 (ACTIVE): ssi_mst_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_mst_intr interrupt is not active prior to masking
#define QSPI_RISR_MSTIR_M		0X20U
#define QSPI_RISR_MSTIR_S		5U
// Receive FIFO Full Interrupt Status
// 0x1 (ACTIVE): ssi_rxf_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_rxf_intr interrupt is not active prior to masking
#define QSPI_RISR_RXFIR_M		0X10U
#define QSPI_RISR_RXFIR_S		4U
//  Receive FIFO Overflow Interrupt StatuS
// 0x1 (ACTIVE): ssi_rxo_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_rxo_intr interrupt is not active prior to masking
#define QSPI_RISR_RXOIR_M		0X8U
#define QSPI_RISR_RXOIR_S		3U
// Receive FIFO Underflow Interrupt Status
// 0x1 (ACTIVE): ssi_rxu_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_rxu_intr interrupt is not active prior to masking
#define QSPI_RISR_RXUIR_M		0X4U
#define QSPI_RISR_RXUIR_S		2U
// Transmit FIFO Overflow Interrupt Status
// 0x1 (ACTIVE): ssi_txo_intr interrupt is active prior to masking
// 0x0 (INACTIVE): ssi_txo_intr interrupt is not active prior to masking
#define QSPI_RISR_TXOIR_M		0X2U
#define QSPI_RISR_TXOIR_S		1U
// Transmit FIFO Empty Interrupt Status
// 0x1 (ACTIVE): ssi_txe_intr interrupt is active after masking
// 0x0 (INACTIVE): ssi_txe_intr interrupt is not active after masking
#define QSPI_RISR_TXEIR_M		0X1U
#define QSPI_RISR_TXEIR_S		0U

// The following are defines for the bit fields in the TXEICR register by QSPI

// Clear Transmit FIFO Overflow/Underflow Interrupt.
#define QSPI_TXEICR_TXEICR_M		0X1U
#define QSPI_TXEICR_TXEICR_S		0U

// The following are defines for the bit fields in the RXOICR register by QSPI

// Clear Receive FIFO Overflow Interrupt.
#define QSPI_RXOICR_RXOICR_M		0X1U
#define QSPI_RXOICR_RXOICR_S		0U

// The following are defines for the bit fields in the RXUICR register by QSPI

// Clear Receive FIFO Underflow Interrupt.
#define QSPI_RXUICR_RXUICR_M		0X1U
#define QSPI_RXUICR_RXUICR_S		0U

// The following are defines for the bit fields in the MSTICR register by QSPI

// Clear Multi-Controller Contention Interrupt.
#define QSPI_MSTICR_RXOICR_M		0X1U
#define QSPI_MSTICR_RXOICR_S		0U

// The following are defines for the bit fields in the ICR register by QSPI

// Clear Interrupts.A read clears
#define QSPI_ICR_ICR_M		0X1U
#define QSPI_ICR_ICR_S		0U

// The following are defines for the bit fields in the DMACR register by QSPI

// AXI awid/arid signal value.
#define QSPI_DMACR_AID_M		0X1F8000U
#define QSPI_DMACR_AID_S		15U
// AXI arprot/awprot signal value.
#define QSPI_DMACR_APROT_M		0X7000U
#define QSPI_DMACR_APROT_S		12U
// AXI arcache/awcache signal value.
#define QSPI_DMACR_ACACHE_M		0XF00U
#define QSPI_DMACR_ACACHE_S		8U
// Address Increment. Indicates whether to increment the AXI address on every transfer. 
// 1 = Increment 0 = No Change Note: Increment aligns the address to the next DMACR.ATW boundary
#define QSPI_DMACR_AINC_M		0X40U
#define QSPI_DMACR_AINC_S		6U
// AXI transfer width for DMA transfers mapped to arsize/awsize. This value must be less than or equal to
// SSIC_AXI_DW. Values:
// 0x0: 1byte
// 0x1: 2 bytes
// 0x2: 4 bytes
// 0x3: 8 bytes
#define QSPI_DMACR_ATW_M		0X18U
#define QSPI_DMACR_ATW_S		3U
// Internal DMA Enable. This bit should be enabled only when CTRLR0.FRF = 0 (Motorola SPI) and CTRLR0.SPI_FRF
// > 0.
#define QSPI_DMACR_IDMAE_M		0X4U
#define QSPI_DMACR_IDMAE_S		2U
// Transmit DMA Enable. This bit enables/disables the transmit FIFO DMA channel.
// 0x1 (ENABLED): Transmit DMA enabled
// 0x0 (DISABLE): Transmit DMA disabled
#define QSPI_DMACR_TDMAE_M		0X2U
#define QSPI_DMACR_TDMAE_S		1U
// Receive DMA Enable. This bit enables/disables the receive FIFO DMA channel.
// 0x1 (ENABLED): Receive DMA enabled
// 0x0 (DISABLE): Receive DMA disabled
#define QSPI_DMACR_RDMAE_M		0X1U
#define QSPI_DMACR_RDMAE_S		0U

// The following are defines for the bit fields in the DMATDLR register by QSPI

// Transmit Data Level. This bit field controls the level at which a DMA request is made by the transmit
// logic. It is equal to the watermark level; that is, the dma_tx_req signal is generated when the number
// of valid data entries in the transmit FIFO is equal to or below this field value, and TDMAE = 1.
#define QSPI_DMATDLR_DMATDL_M		0X1FU
#define QSPI_DMATDLR_DMATDL_S		0U

// The following are defines for the bit fields in the DMARDLR register by QSPI

// Receive Data Level. This bit field controls the level at which a DMA request is made by the receive logic.
// The watermark level = DMARDL+1; that is, dma_rx_req is generated when the number of valid data entries
// in the receive FIFO is equal to or above this field value + 1, and RDMAE=1.
#define QSPI_DMARDLR_DMARDL_M		0X1FU
#define QSPI_DMARDLR_DMARDL_S		0U

// The following are defines for the bit fields in the IDR register by QSPI

// Identification code. 
#define QSPI_IDR_IDCODE_M		0XFFFFFFFFU
#define QSPI_IDR_IDCODE_S		0U

// The following are defines for the bit fields in the DR0 register by QSPI

// Data Register. When writing to this register, you must right-justify the data. Read data are automatically
// right-justified.
// Read = Receive FIFO buffer
// Write = Transmit FIFO buffer.
#define QSPI_DR0_DR_M		0XFFFFFFFFU
#define QSPI_DR0_DR_S		0U

// The following are defines for the bit fields in the SPI_CTRLR0 register by QSPI

// Enables clock stretching capability in SPI transfers.
// In case of write, if the FIFO becomes empty DWC_ssi will stretch the clock until FIFO has enough data
// to continue the transfer.
// In case of read, if the receive FIFO becomes full DWC_ssi will stop the clock until data has been read
// from the FIFO.
#define QSPI_SPI_CTRLR0_CLK_STRETCH_EN_M		0X40000000U
#define QSPI_SPI_CTRLR0_CLK_STRETCH_EN_S		30U
// Enables XIP pre-fetch functionality in DWC_ssi. 
#define QSPI_SPI_CTRLR0_XIP_PREFETCH_EN_M		0X20000000U
#define QSPI_SPI_CTRLR0_XIP_PREFETCH_EN_S		29U
// XIP Mode bits length. Sets the length of mode bits in XIP mode of operation. These bits are valid only
// when SPI_CTRLR0.XIP_MD_BIT_EN is set to 1.
// 0x0 (MBL_2): Mode bits length equal to 2
// 0x1 (MBL_4): Mode bits length equal to 4
// 0x2 (MBL_8): Mode bits length equal to 8
// 0x3 (MBL_16): Mode bits length equal to 16
#define QSPI_SPI_CTRLR0_XIP_MBL_M		0XC000000U
#define QSPI_SPI_CTRLR0_XIP_MBL_S		26U
// Enable rxds signaling during address and command phase of Hyperbus transfer.
#define QSPI_SPI_CTRLR0_SPI_RXDS_SIG_EN_M		0X2000000U
#define QSPI_SPI_CTRLR0_SPI_RXDS_SIG_EN_S		25U
// SPI data mask enable bit.
#define QSPI_SPI_CTRLR0_SPI_DM_EN_M		0X1000000U
#define QSPI_SPI_CTRLR0_SPI_DM_EN_S		24U
// RXDS variable latency enable bit.
#define QSPI_SPI_CTRLR0_RXDS_VL_EN_M		0X800000U
#define QSPI_SPI_CTRLR0_RXDS_VL_EN_S		23U
// Enable continuous transfer in XIP mode. If this bit is set to 1 then continuous transfer mode in XIP
// will be enabled, in this mode DWC_ssi will keep target selected until a non-XIP transfer is detected
// on the AHB interface.
#define QSPI_SPI_CTRLR0_SSIC_XIP_CONT_XFER_EN_M		0X200000U
#define QSPI_SPI_CTRLR0_SSIC_XIP_CONT_XFER_EN_S		21U
// Shift Register Loop.Used for testing purposes only. When internally active, connects the transmit shift
// register output to the receive shift register input. 
// 0x1 (TESTING_MODE): Test Mode Operation
// 0x0 (NORMAL_MODE): Normal mode operation
#define QSPI_SPI_CTRLR0_XIP_INST_EN_M		0X100000U
#define QSPI_SPI_CTRLR0_XIP_INST_EN_S		20U
// Fix DFS for XIP transfers.  
// 1 then data frame size for XIP transfers will be fixed to the programmed value in CTRLR0.DFS. The number
// of data frames to fetch will be determined by HSIZE and HBURST signals. 
// 0 then data frame size and number of data frames to fetch will be determined by HSIZE and HBURST signals
#define QSPI_SPI_CTRLR0_XIP_DFS_HC_M		0X80000U
#define QSPI_SPI_CTRLR0_XIP_DFS_HC_S		19U
// Read data strobe enable bit. Once this bit is set to 1 DWC_ssi will use Read data strobe (rxds) to capture
// read data
#define QSPI_SPI_CTRLR0_SPI_RXDS_EN_M		0X40000U
#define QSPI_SPI_CTRLR0_SPI_RXDS_EN_S		18U
// Instruction DDR Enable bit. This will enable Dual-data rate transfer for Instruction phase.
#define QSPI_SPI_CTRLR0_INST_DDR_EN_M		0X20000U
#define QSPI_SPI_CTRLR0_INST_DDR_EN_S		17U
// SPI DDR Enable bit. This will enable Dual-data rate transfers in Enhanced SPI frame formats of SPI.
#define QSPI_SPI_CTRLR0_SPI_DDR_EN_M		0X10000U
#define QSPI_SPI_CTRLR0_SPI_DDR_EN_S		16U
// Wait cycles in Enhanced SPI mode between control frames transmit and data reception. Specified as number
// of SPI clock cycles.
#define QSPI_SPI_CTRLR0_WAIT_CYCLES_M		0XF800U
#define QSPI_SPI_CTRLR0_WAIT_CYCLES_S		11U
// Enhanced SPI mode instruction length in bits.
// 0x0 (INST_L0): No Instruction
// 0x1 (INST_L4): 4 bit Instruction length
// 0x2 (INST_L8): 8 bit Instruction length
// 0x3 (INST_L16): 16 bit Instruction length
#define QSPI_SPI_CTRLR0_INST_L_M		0X300U
#define QSPI_SPI_CTRLR0_INST_L_S		8U
// Mode bits enable in XIP mode.
#define QSPI_SPI_CTRLR0_XIP_MD_BIT_EN_M		0X80U
#define QSPI_SPI_CTRLR0_XIP_MD_BIT_EN_S		7U
// This bit defines Length of Address to be transmitted. Only after this much bits are programmed in to
// the FIFO the transfer can begin.
// 0x0 (ADDR_L0): No Address
// 0x1 (ADDR_L4): 4 bit Address length
// 0x2 (ADDR_L8): 8 bit Address length
// 0x3 (ADDR_L12): 12 bit Address length
// 0x4 (ADDR_L16): 16 bit Address length
// 0x5 (ADDR_L20): 20 bit Address length
// 0x6 (ADDR_L24): 24 bit Address length
// 0x7 (ADDR_L28): 28 bit Address length
// 0x8 (ADDR_L32): 32 bit Address length
// 0x9 (ADDR_L36): 36 bit Address length
// 0xa (ADDR_L40): 40 bit Address length
// 0xb (ADDR_L44): 44 bit Address length
// 0xc (ADDR_L48): 48 bit Address length
// 0xd (ADDR_L52): 52 bit Address length
// 0xe (ADDR_L56): 56 bit Address length
// 0xf (ADDR_L60): 60 bit Address length
#define QSPI_SPI_CTRLR0_ADDR_L_M		0X3CU
#define QSPI_SPI_CTRLR0_ADDR_L_S		2U
// Address and instruction transfer format.
// Selects whether DWC_ssi will transmit instruction/address either in Standard SPI mode or the SPI mode
// selected in CTRLR0.SPI_FRF field.
// 0x0 (TT0): Instruction and Address will be sent in Standard SPI Mode.
// 0x1 (TT1): Instruction will be sent in Standard SPI Mode and Address will be sent in the mode specified
// by CTRLR0.SPI_FRF.
// 0x2 (TT2): Both Instruction and Address will be sent in the mode specified by SPI_FRF.
// 0x3 (TT3): Dual Octal mode, the address and instruction are transferred in octal mode and data is transferred
// on 16 data lines.
#define QSPI_SPI_CTRLR0_TRANS_TYPE_M		0X3U
#define QSPI_SPI_CTRLR0_TRANS_TYPE_S		0U

// The following are defines for the bit fields in the DDR_DRIVE_EDGE register by QSPI

// TXD Drive edge register which decided the driving edge of transmit data.
// The maximum value of this register is = (BAUDR/2) -1.
#define QSPI_DDR_DRIVE_EDGE_TDE_M		0XFFU
#define QSPI_DDR_DRIVE_EDGE_TDE_S		0U

// The following are defines for the bit fields in the XIP_MODE_BITS register by QSPI

// XIP mode bits to be sent after address phase of XIP transfer.
#define QSPI_XIP_MODE_BITS_XIP_MD_BITS_M		0XFFFFU
#define QSPI_XIP_MODE_BITS_XIP_MD_BITS_S		0U

// The following are defines for the bit fields in the XIP_INCR_INST register by QSPI

// XIP INCR transfer opcode. When SPI_CTRLR0.XIP_INST_EN bit is set to 1, DWC_ssi sends instruction for
// all XIP transfers, this register field stores the instruction op-code to be sent when an INCR type transfer
// is requested on AHB bus. The number of bits to be send in instruction phase is determined by SPI_CTRLR0.INST_L
// field.
#define QSPI_XIP_INCR_INST_INCR_INST_M		0XFFFFU
#define QSPI_XIP_INCR_INST_INCR_INST_S		0U

// The following are defines for the bit fields in the XIP_WRAP_INST register by QSPI

// XIP WRAP transfer opcode. When SPI_CTRLR0.XIP_INST_EN bit is set to 1, DWC_ssi sends instruction for
// all XIP transfers, this register field stores the instruction op-code to be sent when an WRAP type transfer
// is requested on AHB bus. The number of bits to be send in instruction phase is determined by SPI_CTRLR0.INST_L
// field.
#define QSPI_XIP_WRAP_INST_WRAP_INST_M		0XFFFFU
#define QSPI_XIP_WRAP_INST_WRAP_INST_S		0U

// The following are defines for the bit fields in the XIP_CTRL register by QSPI

// RXDS variable latency enable bit.
// When this bit is set DWC_ssi waits for all the data to be sampled before stopping the SCLK_OUT clock.
// This enables the support for the devices which support variable latencies within the transfers for RXDS
// transfers.
#define QSPI_XIP_CTRL_RXDS_VL_EN_M		0X40000000U
#define QSPI_XIP_CTRL_RXDS_VL_EN_S		30U
// Enables XIP pre-fetch functionality in DWC_ssi. Once enabled DWC_ssi will pre-fetch data frames from
// next contiguous location, to reduce the latency for the upcoming contiguous transfer. If the next XIP
// request is not contiguous then pre-fetched bits will be discarded.
#define QSPI_XIP_CTRL_XIP_PREFETCH_EN_M		0X20000000U
#define QSPI_XIP_CTRL_XIP_PREFETCH_EN_S		29U
// XIP Mode bits length. Sets the length of mode bits in XIP mode of operation. These bits are valid only
// when SPI_CTRLR0.XIP_MD_BIT_EN is set to 1.
// 0x0 (MBL_2): Mode bits length equal to 2
// 0x1 (MBL_4): Mode bits length equal to 4
// 0x2 (MBL_8): Mode bits length equal to 8
// 0x3 (MBL_16): Mode bits length equal to 16
#define QSPI_XIP_CTRL_XIP_MBL_M		0XC000000U
#define QSPI_XIP_CTRL_XIP_MBL_S		26U
// Enable rxds signaling during address and command phase of Hyperbus transfer.
#define QSPI_XIP_CTRL_RXDS_SIG_EN_M		0X2000000U
#define QSPI_XIP_CTRL_RXDS_SIG_EN_S		25U
// SPI Hyperbus Frame format enable for XIP transfers.
#define QSPI_XIP_CTRL_XIP_HYPERBUS_EN_M		0X1000000U
#define QSPI_XIP_CTRL_XIP_HYPERBUS_EN_S		24U
// Enable continuous transfer in XIP mode. If this bit is set to 1 then continuous transfer mode in XIP
// will be enabled, in this mode DWC_ssi will keep target selected until a non-XIP transfer is detected
// on the AHB interface.
#define QSPI_XIP_CTRL_CONT_XFER_EN_M		0X800000U
#define QSPI_XIP_CTRL_CONT_XFER_EN_S		23U
// XIP instruction enable bit. If this bit is set to 1 then XIP transfers will also have instruction phase.
// The instruction op-codes will be chosen from XIP_INCR_INST or XIP_WRAP_INST registers bases on AHB transfer
// type.
#define QSPI_XIP_CTRL_INST_EN_M		0X400000U
#define QSPI_XIP_CTRL_INST_EN_S		22U
// Read data strobe enable bit. Once this bit is set to 1 DWC_ssi will use Read data strobe (rxds) to capture
// read data.
#define QSPI_XIP_CTRL_RXDS_EN_M		0X200000U
#define QSPI_XIP_CTRL_RXDS_EN_S		21U
// SPI DDR Enable bit. This will enable Dual-data rate transfers in Enhanced SPI frame formats of SPI.
#define QSPI_XIP_CTRL_INST_DDR_EN_M		0X100000U
#define QSPI_XIP_CTRL_INST_DDR_EN_S		20U
// Fix DFS for XIP transfers.  
// 1 then data frame size for XIP transfers will be fixed to the programmed value in CTRLR0.DFS. The number
// of data frames to fetch will be determined by HSIZE and HBURST signals. 
// 0 then data frame size and number of data frames to fetch will be determined by HSIZE and HBURST signals
#define QSPI_XIP_CTRL_DDR_EN_M		0X80000U
#define QSPI_XIP_CTRL_DDR_EN_S		19U
// Read data strobe enable bit. Once this bit is set to 1 DWC_ssi will use Read data strobe (rxds) to capture
// read data
#define QSPI_XIP_CTRL_DFS_HC_M		0X40000U
#define QSPI_XIP_CTRL_DFS_HC_S		18U
//  
// Wait cycles in Enhanced SPI mode between control frames transmit and data reception. Specified as number
// of SPI clock cycles.
#define QSPI_XIP_CTRL_WAIT_CYCLES_M		0X3E000U
#define QSPI_XIP_CTRL_WAIT_CYCLES_S		13U
//  
// Mode bits enable in XIP mode. If this bit is set to 1, then in XIP mode of operation DWC_ssi will insert
// mode bits after the address phase. These bits are set in register XIP_MODE_BITS register.
#define QSPI_XIP_CTRL_MD_BITS_EN_M		0X1000U
#define QSPI_XIP_CTRL_MD_BITS_EN_S		12U
//  
// Enhanced SPI mode instruction length in bits.
// 0x0 (INST_L0): No Instruction
// 0x1 (INST_L4): 4 bit Instruction length
// 0x2 (INST_L8): 8 bit Instruction length
// 0x3 (INST_L16): 16 bit Instruction length
#define QSPI_XIP_CTRL_INST_L_M		0X600U
#define QSPI_XIP_CTRL_INST_L_S		9U
// This bit defines Length of Address to be transmitted. Only after this much bits are programmed in to
// the FIFO the transfer can begin.
// 0x0 (ADDR_L0): No Address
// 0x1 (ADDR_L4): 4 bit Address length
// 0x2 (ADDR_L8): 8 bit Address length
// 0x3 (ADDR_L12): 12 bit Address length
// 0x4 (ADDR_L16): 16 bit Address length
// 0x5 (ADDR_L20): 20 bit Address length
// 0x6 (ADDR_L24): 24 bit Address length
// 0x7 (ADDR_L28): 28 bit Address length
// 0x8 (ADDR_L32): 32 bit Address length
// 0x9 (ADDR_L36): 36 bit Address length
// 0xa (ADDR_L40): 40 bit Address length
// 0xb (ADDR_L44): 44 bit Address length
// 0xc (ADDR_L48): 48 bit Address length
// 0xd (ADDR_L52): 52 bit Address length
// 0xe (ADDR_L56): 56 bit Address length
// 0xf (ADDR_L60): 60 bit Address length
#define QSPI_XIP_CTRL_ADDR_L_M		0XF0U
#define QSPI_XIP_CTRL_ADDR_L_S		4U
// Address and instruction transfer format.
// Selects whether DWC_ssi will transmit instruction/address either in Standard SPI mode or the SPI mode
// selected in CTRLR0.SPI_FRF field.
// 0x0 (TT0): Instruction and Address will be sent in Standard SPI Mode.
// 0x1 (TT1): Instruction will be sent in Standard SPI Mode and Address will be sent in the mode specified
// by CTRLR0.SPI_FRF.
// 0x2 (TT2): Both Instruction and Address will be sent in the mode specified by SPI_FRF.
// 0x3 (TT3): Dual Octal mode, the address and instruction are transferred in octal mode and data is transferred
// on 16 data lines.
#define QSPI_XIP_CTRL_TRANS_TYPE_M		0XCU
#define QSPI_XIP_CTRL_TRANS_TYPE_S		2U
// SPI Frame Format
// Selects data frame format for Transmitting/Receiving the data.
// 0x0 (SPI_STANDARD): Standard SPI Format
// 0x1 (SPI_DUAL): Dual SPI Format
// 0x2 (SPI_QUAD): Quad SPI Format
// 0x3 (SPI_OCTAL): Octal SPI Format
#define QSPI_XIP_CTRL_FRF_M		0X3U
#define QSPI_XIP_CTRL_FRF_S		0U

// The following are defines for the bit fields in the XRXOICR register by QSPI

// Clear XIP Receive FIFO Overflow Interrupt.
// This register reflects the status of the interrupt. A read from this register clears the ssi_xrxo_intr(_n)
// interrupt; writing has no effect.
#define QSPI_XRXOICR_XRXOICR_M		0X1U
#define QSPI_XRXOICR_XRXOICR_S		0U

// The following are defines for the bit fields in the XIP_CNT_TIME_OUT register by QSPI

// XIP time out value in terms of hclk. Once target is selected in continuous XIP mode this counter will
// be used to de-select the target if there is no request for the time specified in the counter.
#define QSPI_XIP_CNT_TIME_OUT_XTOC_M		0XFFU
#define QSPI_XIP_CNT_TIME_OUT_XTOC_S		0U

// The following are defines for the bit fields in the SPI_CTRLR1 register by QSPI

// Chip-Select Minimum HIGH period.
// This field is used to set the minimum time period (in terms of ssi_clk) between two back to back SPI
// operations.
#define QSPI_SPI_CTRLR1_CS_MIN_HIGH_M		0XF0000U
#define QSPI_SPI_CTRLR1_CS_MIN_HIGH_S		16U
// Maximum wait cycles allowed per transaction.
// This field indicate, up to how many times SPI target could insert the wait states. The internal counter
// is incremented every time when DWC_ssi controller checks for the status from the target and receives
// wait response.
#define QSPI_SPI_CTRLR1_MAX_WS_M		0XF00U
#define QSPI_SPI_CTRLR1_MAX_WS_S		8U
// SPI Dynamic Wait states field.
// This field is used to set the value for wait states which will be introduced when SPI target sends BUSY
// status to the Controller. The programmed value of wait States will be introduced before checking status
// again.
// Number of wait states = DYN_WS+1
#define QSPI_SPI_CTRLR1_DYN_WS_M		0XF0000U
#define QSPI_SPI_CTRLR1_DYN_WS_S		16U

// The following are defines for the bit fields in the XIP_WRITE_INCR_INST register by QSPI

// XIP Write INCR transfer opcode. When XIP_WRITE_CTRL.INST_L is not equal to 0, DWC_ssi sends instruction
// for all XIP write transfers, this register field stores the instruction op-code to be sent when an INCR
// type XIP Write transfer is requested on AHB bus. The number of bits to be send in instruction phase
// is determined by XIP_WRITE_CTRL.INST_L field.
#define QSPI_XIP_WRITE_INCR_INST_INCR_WRITE_INST_M		0XFFFFU
#define QSPI_XIP_WRITE_INCR_INST_INCR_WRITE_INST_S		0U

// The following are defines for the bit fields in the WRAP_WRITE_INST register by QSPI

//  
// XIP Write WRAP transfer opcode. When XIP_WRITE_CTRL.INST_L is not equal to 0, DWC_ssi sends instruction
// for all XIP write transfers, this register field stores the instruction op-code to be sent when an WRAP
// type XIP Write transfer is requested on AHB bus. The number of bits to be send in instruction phase
// is determined by XIP_WRITE_CTRL.INST_L field.
#define QSPI_WRAP_WRITE_INST_WRAP_WRITE_INST_M		0XFFFFU
#define QSPI_WRAP_WRITE_INST_WRAP_WRITE_INST_S		0U

// The following are defines for the bit fields in the XIP_WRITE_CTRL register by QSPI

//  
// Fix DFS for XIP transfers. If this bit is set to 1 then data frame size for XIP transfers will be fixed
// to the programmed value in CTRLR0.DFS. If this bit is set to 0 then data frame size will be determined
// by HSIZE signal.
#define QSPI_XIP_WRITE_CTRL_XIPWR_DFS_HC_M		0X200000U
#define QSPI_XIP_WRITE_CTRL_XIPWR_DFS_HC_S		21U
// Wait cycles in Enhanced SPI mode between control frames transmit and data reception. Specified as number
// of SPI clock cycles.
#define QSPI_XIP_WRITE_CTRL_XIPWR_WAIT_CYCLES_M		0X1F0000U
#define QSPI_XIP_WRITE_CTRL_XIPWR_WAIT_CYCLES_S		16U
// Enable rxds signaling during address and command phase of Hyperbus transfer.
#define QSPI_XIP_WRITE_CTRL_XIPWR_DM_EN_M		0X4000U
#define QSPI_XIP_WRITE_CTRL_XIPWR_DM_EN_S		14U
// Enable rxds signaling during address and command phase of Hyperbus transfer.
#define QSPI_XIP_WRITE_CTRL_XIPWR_RXDS_SIG_EN_M		0X2000U
#define QSPI_XIP_WRITE_CTRL_XIPWR_RXDS_SIG_EN_S		13U
// SPI Hyperbus Frame format enable for XIP Write transfers.
// Selects if data frame format for XIP Write transfers is in Hyperbus mode. This field is effective only
// when CTRLR0.FRF is set to SPI frame format.
#define QSPI_XIP_WRITE_CTRL_XIPWR_HYPERBUS_EN_M		0X1000U
#define QSPI_XIP_WRITE_CTRL_XIPWR_HYPERBUS_EN_S		12U
// Instruction DDR Enable bit. This will enable Dual-data rate transfer for Instruction phase.
#define QSPI_XIP_WRITE_CTRL_WR_INST_DDR_EN_M		0X800U
#define QSPI_XIP_WRITE_CTRL_WR_INST_DDR_EN_S		11U
// SPI DDR Enable bit. This will enable Dual-data rate transfers in Enhanced SPI frame formats of SPI.
#define QSPI_XIP_WRITE_CTRL_WR_SPI_DDR_EN_M		0X400U
#define QSPI_XIP_WRITE_CTRL_WR_SPI_DDR_EN_S		10U
// Enhanced SPI mode instruction length in bits.
// 0x0 (INST_L0): No Instruction
// 0x1 (INST_L4): 4 bit Instruction length
// 0x2 (INST_L8): 8 bit Instruction length
// 0x3 (INST_L16): 16 bit Instruction length
#define QSPI_XIP_WRITE_CTRL_WR_INST_L_M		0X300U
#define QSPI_XIP_WRITE_CTRL_WR_INST_L_S		8U
// This bit defines Length of Address to be transmitted. Only after this much bits are programmed in to
// the FIFO the transfer can begin.
// 0x0 (ADDR_L0): Reserved
// 0x1 (ADDR_L4): 4 bit Address length
// 0x2 (ADDR_L8): 8 bit Address length
// 0x3 (ADDR_L12): 12 bit Address length
// 0x4 (ADDR_L16): 16 bit Address length
// 0x5 (ADDR_L20): 20 bit Address length
// 0x6 (ADDR_L24): 24 bit Address length
// 0x7 (ADDR_L28): 28 bit Address length
// 0x8 (ADDR_L32): 32 bit Address length
#define QSPI_XIP_WRITE_CTRL_WR_ADDR_L_M		0XF0U
#define QSPI_XIP_WRITE_CTRL_WR_ADDR_L_S		4U
// Address and instruction transfer format.
// Selects whether DWC_ssi will transmit instruction/address either in Standard SPI mode or the SPI mode
// selected in CTRLR0.SPI_FRF field.
// 0x0 (TT0): Instruction and Address will be sent in Standard SPI Mode.
// 0x1 (TT1): Instruction will be sent in Standard SPI Mode and Address will be sent in the mode specified
// by CTRLR0.SPI_FRF.
// 0x2 (TT2): Both Instruction and Address will be sent in the mode specified by SPI_FRF.
// 0x3 (TT3): Dual Octal mode, the address and instruction are transferred in octal mode and data is transferred
// on 16 data lines.
#define QSPI_XIP_WRITE_CTRL_WR_TRANS_TYPE_M		0XCU
#define QSPI_XIP_WRITE_CTRL_WR_TRANS_TYPE_S		2U
// SPI Frame Format
// Selects data frame format for Transmitting the data.
// 0x0 (SPI_STANDARD): Standard SPI Format
// 0x1 (SPI_DUAL): Dual SPI Format
// 0x2 (SPI_QUAD): Quad SPI Format
// 0x3 (SPI_OCTAL): Octal SPI Format
#define QSPI_XIP_WRITE_CTRL_WR_FRF_M		0X3U
#define QSPI_XIP_WRITE_CTRL_WR_FRF_S		0U


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

 #ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_HW_QSPI_H_ */
