/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_crg_v22.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_CRG_V22_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_CRG_V22_H_

#include "gs32_version.h"

#if IS_GS32F3xx(0x22)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define CRG_CFG_O_CRG_CFG_LOCK                      0x000    // Lock control register.

#define CRG_CFG_O_REF_CLK_SEL                       0x004    // PLL reference clock selection
#define CRG_CFG_O_S2N_CLK_SEL                       0x008    // System clock fast/slow switch
#define CRG_CFG_O_CAN_CORE_CLK_SEL                  0x00C    // CAN CORE clock selection
#define CRG_CFG_O_CFG_DIV_DSP_CORE                  0x010    // DSP core clock divider configuration
#define CRG_CFG_O_CFG_DIV_PERI_SYS                  0x014    // Peripheral clock divider configuration
#define CRG_CFG_O_CFG_DIV_APB_SYS                   0x018    // APB clock divider configuration
#define CRG_CFG_O_CFG_SYS_DIV_LOAD_POS              0x01C    // System divider update indication
#define CRG_CFG_O_TRACE_CLK_DIV                     0x020    // Trace clock divider configuration
#define CRG_CFG_O_SMW_CLK_DIV                       0x024    // SMW clock divider configuration
#define CRG_CFG_O_CFG_DIV_CAN                       0x028    // CAN clock divider configuration
#define CRG_CFG_O_CFG_CPU1_WDG_CLK_PRE_DIV          0x038    // CPU1 watchdog clock pre-divider
#define CRG_CFG_O_CFG_CPU1_WDG_CLK_SCALER_DIV       0x03C    // CPU1 watchdog clock scaler configuration
#define CRG_CFG_O_CFG_CPU2_WDG_CLK_PRE_DIV          0x040    // CPU2 watchdog clock pre-divider
#define CRG_CFG_O_CFG_CPU2_WDG_CLK_SCALER_DIV       0x044    // CPU2 watchdog clock scaler configuration
#define CRG_CFG_O_CFG_DBG_WDT_HOLD_EN               0x048    // Debug watchdog pause enable
#define CRG_CFG_O_CPU1_WDG_RST_EN                   0x050    // CPU1 watchdog reset enable
#define CRG_CFG_O_CPU2_WDG_RST_EN                   0x054    // CPU2 watchdog reset enable
#define CRG_CFG_O_CFG_CMD_EN                        0x100    // CMD enable
#define CRG_CFG_O_CFG_CMD_ST_CLR                    0x104    // CMD_ST_CLR enable
#define CRG_CFG_O_CMD_CHECK_FAIL_RPT                0x108    // CMD check result report
#define CRG_CFG_O_TEST_MUX_EN                       0x10C    // TEST_MUX enable configuration
#define CRG_CFG_O_TEST_MUX_SEL                      0x110    // TEST_MUX select configuration
#define CRG_CFG_O_OBS_SIG_SEL                       0x114    // OBS_SIG select configuration
#define CRG_CFG_O_OBS_SIG_DIV                       0x118    // OBS_SIG divider configuration
#define CRG_CFG_O_X1_CNT                            0x11C    // X1 clock self-test register
#define CRG_CFG_O_CPU1_RST_RECORD                   0x120    // CPU1 reset reason record
#define CRG_CFG_O_CPU2_RST_RECORD                   0x124    // CPU2 reset reason record

#define CRG_CFG_O_PLL_PD                            0x200    // PLL power-down configuration
#define CRG_CFG_O_PLL_BYPASS                        0x204    // PLL bypass configuration
#define CRG_CFG_O_PLL_OTHPD_CFG                     0x208    // PLL functional power-down configuration
#define CRG_CFG_O_PLL_DIV_CFG                       0x20C    // PLL divider configuration
#define CRG_CFG_O_PLL_FBDIV_CFG                     0x210    // PLL feedback divider configuration
#define CRG_CFG_O_PLL_FRAC_CFG                      0x214    // PLL fractional divider configuration
#define CRG_CFG_O_PLL_DIVVAL                        0x21C    // PLL spread-spectrum DIVVAL configuration
#define CRG_CFG_O_PLL_SPREAD                        0x220    // PLL spread-spectrum SPREAD configuration
#define CRG_CFG_O_PLL_DOWNSPREAD                    0x224    // PLL spread-spectrum down-spread configuration
#define CRG_CFG_O_PLL_EXT_MAXADDR                   0x228    // PLL spread-spectrum EXT MAXADDR configuration
#define CRG_CFG_O_PLL_SEL_EXTWAVE                   0x22C    // PLL spread-spectrum EXT WAVE enable
#define CRG_CFG_O_PLL_RESETPTR                      0x230    // PLL spread-spectrum reset pointer
#define CRG_CFG_O_PLL_DISABLE_SSCG                  0x234    // PLL spread-spectrum disable configuration
#define CRG_CFG_O_PLL_UNLCK                         0x238    // PLL unlock status
#define CRG_CFG_O_PLL_LCK                           0x23C    // PLL lock status

#define CRG_CFG_O_OSC1_TRIM_OSC_EN                  0x300    // OSC1 calibration enable
#define CRG_CFG_O_OSC1_TRIM_OSC_STEP_NUM            0x304    // OSC1 calibration step configuration
#define CRG_CFG_O_OSC1_TRIM_OSC_CALC_NUM            0x308    // OSC1 calibration calculation length
#define CRG_CFG_O_OSC1_TRIM_OSC_WAIT_NUM            0x30C    // OSC1 refresh wait time
#define CRG_CFG_O_OSC1_TRIM_REF_CALC_NUM            0x310    // OSC1 reference calculation length
#define CRG_CFG_O_OSC1_TRIM_OVER                    0x314    // OSC1 calibration done
#define CRG_CFG_O_OSC2_TRIM_OSC_EN                  0x320    // OSC2 calibration enable
#define CRG_CFG_O_OSC2_TRIM_OSC_STEP_NUM            0x324    // OSC2 calibration step configuration
#define CRG_CFG_O_OSC2_TRIM_OSC_CALC_NUM            0x328    // OSC2 calibration calculation length
#define CRG_CFG_O_OSC2_TRIM_OSC_WAIT_NUM            0x32C    // OSC2 refresh wait time
#define CRG_CFG_O_OSC2_TRIM_REF_CALC_NUM            0x330    // OSC2 reference calculation length
#define CRG_CFG_O_OSC2_TRIM_OVER                    0x334    // OSC2 calibration done
#define CRG_CFG_O_OSC_TRIM_VALUE_RPT                0x340    // OSC trim value report

#define CRG_CFG_O_SRST_SYS                          0x400    // System soft reset configuration
#define CRG_CFG_O_SRST_CLUSTER_N                    0x404    // Cluster soft reset configuration
#define CRG_CFG_O_SRST_DSP_CPU2_N                   0x408    // DSP CPU2 soft reset configuration
#define CRG_CFG_O_SLV_CORE_RST_ON_SLV               0x410    // Slave core reset on slave
#define CRG_CFG_O_SLV_CORE_STOP_WITH_SLV            0x414    // Slave core stop with slave
#define CRG_CFG_O_FORCE_AHB_ISO                     0x418    // Force slave AHB master takeover
#define CRG_CFG_O_ISO_OVF_CNT_TH                    0x41C    // Takeover threshold configuration
#define CRG_CFG_O_DSP_CORE_STOP_ON_SET              0x44C    // DSP core stop set
#define CRG_CFG_O_DSP_CORE_STOP_ON_CLR              0x450    // DSP core stop clear
#define CRG_CFG_O_DSP_CORE_STOP_ON_RPT              0x454    // DSP core stop report
#define CRG_CFG_O_SRST_EFLASH_CTRL_N                0x504    // eFlash controller soft reset

#define CRG_CFG_O_EFLASH_CTRL_CLK_EN                0x600    // eFlash controller clock enable
#define CRG_CFG_O_TRACE_CLK_EN                      0x604    // Trace clock enable
#define CRG_CFG_O_DMA_CLK_ICG_BYPASS                0x608    // DMA auto clock gating bypass
#define CRG_CFG_O_DSP_CLK_ICG_BYPASS                0x60C    // DSP auto clock gating bypass
#define CRG_CFG_O_PARA_ICG_BYPASS                   0x6FC    // PARA ICG bypass

#define CRG_CFG_O_TOP_CRG_SPARE0                    0xF00    // Reserved register
#define CRG_CFG_O_TOP_CRG_SPARE1                    0xF04    // Reserved register
#define CRG_CFG_O_TOP_CRG_SPARE2                    0xF08    // Reserved register



#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_CRG_CFGIGH_H_ */
