/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_io_v12.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_GPIO_V12_H_
#define DEVICE_DRIVERLIB_HW_GPIO_V12_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)

#ifdef __cplusplus
extern "C"{
#endif

#define GPIO_O_IO_CFG_LOCK        0x300U   // Lock control register.

//*************************************************************************************************
//
// The following are defines for the GPIO register offsets
//
//*************************************************************************************************

#if IS_GS32F00xx(0x12)
//GPIO A (0x000~0x07C)
#define GPIO_O_GPACTRL            0x0U      // GPIO A Qualification Sampling Period Control (GPIO0 to 31)
#define GPIO_O_GPAQSEL1           0x4U      // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
#define GPIO_O_GPAQSEL2           0x8U      // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
#define GPIO_O_GPAMUX1            0xCU      // GPIO A Mux 1 Register (GPIO0 to 15)
#define GPIO_O_GPAMUX2            0x10U     // GPIO A Mux 2 Register (GPIO16 to 31)
#define GPIO_O_GPADIR             0x14U     // GPIO A Direction Register (GPIO0 to 31)
#define GPIO_O_GPAPUD             0x18U     // GPIO A Pull Up Disable Register (GPIO0 to 31)
#define GPIO_O_GPAINV             0x20U     // GPIO A Input Polarity Invert Registers (GPIO0 to 31)
#define GPIO_O_GPAAMSEL           0x28U     // GPIO A Analog Mode Select register (GPIO0 to GPIO31)
#define GPIO_O_GPAGMUX1           0x40U     // GPIO A Peripheral Group Mux (GPIO0 to 15)
#define GPIO_O_GPAGMUX2           0x44U     // GPIO A Peripheral Group Mux (GPIO16 to 31)

//GPIO B (0x080~0xFC)
#define GPIO_O_GPBCTRL            0x80U     // GPIO B Qualification Sampling Period Control (GPIO32 to 63)
#define GPIO_O_GPBQSEL1           0x84U     // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
#define GPIO_O_GPBQSEL2           0x88U     // GPIO B Qualifier Select 2 Register (GPIO48 to 63)
#define GPIO_O_GPBMUX1            0x8CU     // GPIO B Mux 1 Register (GPIO32 to 47)
#define GPIO_O_GPBMUX2            0x90U     // GPIO B Mux 2 Register (GPIO48 to 63)
#define GPIO_O_GPBDIR             0x94U     // GPIO B Direction Register (GPIO32 to 63)
#define GPIO_O_GPBPUD             0x98U     // GPIO B Pull Up Disable Register (GPIO32 to 63)
#define GPIO_O_GPBINV             0xA0U     // GPIO B Input Polarity Invert Registers (GPIO32 to 63)
#define GPIO_O_GPBAMSEL           0xA8U     // GPIO B Analog Mode Select register  (GPIO32 to 63)
#define GPIO_O_GPBGMUX1           0xC0U     // GPIO B Peripheral Group Mux (GPIO32 to 47)
#define GPIO_O_GPBGMUX2           0xC4U     // GPIO B Peripheral Group Mux (GPIO48 to 63)

//GPIO C (0x100~0x17C)
#define GPIO_O_GPCCTRL            0x100U    // GPIO C Qualification Sampling Period Control (GPIO64 to 68)
#define GPIO_O_GPCQSEL1           0x104U    // GPIO C Qualifier Select 1 Register (GPIO64 to 68)
#define GPIO_O_GPCMUX1            0x10CU    // GPIO C Mux 1 Register (GPIO64 to 68)
#define GPIO_O_GPCDIR             0x114U    // GPIO C Direction Register (GPIO64 to 68)
#define GPIO_O_GPCPUD             0x118U    // GPIO C Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPCINV             0x120U    // GPIO C Input Polarity Invert Registers (GPIO64 to 68)
#define GPIO_O_GPCGMUX1           0x130U    // GPIO C Peripheral Group Mux (GPIO64 to 68)

//GPIO H (0x380~0x3FC)
#define GPIO_O_GPHCTRL            0x380U    // GPIO H Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPHQSEL1           0x384U    // GPIO H Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPHQSEL2           0x388U    // GPIO H Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPHMUX1            0x38CU    // GPIO H Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPHMUX2            0x390U    // GPIO H Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPHINV             0x3A0U    // GPIO H Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPHAMSEL           0x3A8U    // GPIO H Analog Mode Select register (GPIO224 to GPIO255)
#define GPIO_O_GPHGMUX1           0x3C0U    // GPIO H Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPHGMUX2           0x3C4U    // GPIO H Peripheral Group Mux (GPIO240 to 255)

//GJ  GPIOA Extend Feature (0x180~0x19C)
#define GPIO_O_GPAPDD             0x180U    //GPIO A Pull Down Disable Register (GPIO0 to 31)
#define GPIO_O_GPADS1             0x184U    //GPIO A Drive Strength 1 Register1 (GPIO0 to 15)
#define GPIO_O_GPADS2             0x188U    //GPIO A Drive Strength Register2 (GPIO16 to 31)
#define GPIO_O_GPAIS              0x18CU    //GPIO A Schmitt Trigger Register (GPIO0 to 31)
#define GPIO_O_GPAOUTINV          0x190U    //GPIO A output Polarity Invert Registers (GPIO0 to 31)
#define GPIO_O_GPALOOPEN          0x194U    //GPIO A LOOP Enable Registers (GPIO0 to 31)
#define GPIO_O_GPAPI2C_MODE       0x198U    //GPIO A PI2C MODE Registers (GPIO0 to 31)
#define GPIO_O_GPA_POUT_RPT       0x19CU    //IO0~31 POUT Real time reporting

//GJ  GPIOB Extend Feature (0x1A0~0x1BC)
#define GPIO_O_GPBPDD             0x1A0U    //GPIO B Pull Down Disable Register (GPIO32 to 63)
#define GPIO_O_GPBDS1             0x1A4U    //GPIO B Drive Strength 1 Register1 (GPIO32 to 47)
#define GPIO_O_GPBDS2             0x1A8U    //GPIO B Drive Strength Register2 (GPIO48 to 63)
#define GPIO_O_GPBIS              0x1ACU    //GPIO B Schmitt Trigger Register (GPIO32 to 63)
#define GPIO_O_GPBOUTINV          0x1B0U    //GPIO B output Polarity Invert Registers (GPIO32 to 63)
#define GPIO_O_GPBLOOPEN          0x1B4U    //GPIO B LOOP Enable Registers (GPIO32 to 63)
#define GPIO_O_GPBPI2C_MODE       0x1B8U    //GPIO B PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPB_POUT_RPT       0x1BCU    //IO32~63 POUT Real time reporting

//GJ  GPIOC Extend Feature (0x1C0~0x1DC)
#define GPIO_O_GPCPDD             0x1C0U    //GPIO C Pull Down Disable Register (GPIO64 to 68)
#define GPIO_O_GPCDS1             0x1C4U    //GPIO C Drive Strength 1 Register1 (GPIO64 to 68)
#define GPIO_O_GPCIS              0x1CCU    //GPIO C Schmitt Trigger Register (GPIO64 to 68)
#define GPIO_O_GPCOUTINV          0x1D0U    //GPIO C output Polarity Invert Registers (GPIO64 to 68)
#define GPIO_O_GPCLOOPEN          0x1D4U    //GPIO C LOOP Enable Registers (GPIO64 to 68)
#define GPIO_O_GPC_POUT_RPT       0x1DCU    //IO64~68 POUT Real time reporting

//GJ  GPIOH Extend Feature (0x1E0~0x1FC)
#define GPIO_O_GPHIS              0x1E8     //GPIO H Schmitt Trigger Register (GPIO224 to 255)
#define GPIO_O_GPHIE              0x1F0     //GPIO H  input Enable Registers (GPIO224 to 255)

// (0x300~0x37C)
#if IS_GS32F00xx(0x12)
#define GPIO_O_HSE_CTRL           0x304     //HSE mode configuration
#define GPIO_O_IO_IE_MODE         0x308     //GPIO configuration IE mode selection
#define GPIO_O_LPMCR_QUALSTDBY    0x350     //
#define GPIO_O_IO_SET_STDBY       0x354     //
#define GPIO_O_GPIOLPMSEL0        0x358     //GPIO WAKE_UP SELECT0
#define GPIO_O_GPIOLPMSEL1        0x35C     //GPIO WAKE_UP SELECT1
#define GPIO_O_GPIOLPMSEL2        0x360     //GPIO WAKE_UP SELECT2
#elif IS_GS32F3xx(0x22)
#define GPIO_O_HSE_CTRL           0x504     //HSE mode configuration
#define GPIO_O_IO_IE_MODE         0x508     //GPIO configuration IE mode selection
#endif

#elif IS_GS32F3xx(0x22)
//GPIO A (0x000~0x07C)
#define GPIO_O_GPACTRL            0x0U      // GPIO A Qualification Sampling Period Control (GPIO0 to 31)
#define GPIO_O_GPAQSEL1           0x4U      // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
#define GPIO_O_GPAQSEL2           0x8U      // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
#define GPIO_O_GPAMUX1            0xCU      // GPIO A Mux 1 Register (GPIO0 to 15)
#define GPIO_O_GPAMUX2            0x10U     // GPIO A Mux 2 Register (GPIO16 to 31)
//#define GPIO_O_GPADIR             0x14U     // GPIO A Direction Register (GPIO0 to 31)
#define GPIO_O_GPAPUD             0x18U     // GPIO A Pull Up Disable Register (GPIO0 to 31)
#define GPIO_O_GPAINV             0x20U     // GPIO A Input Polarity Invert Registers (GPIO0 to 31)
#define GPIO_O_GPAAMSEL           0x28U     // GPIO A Analog Mode Select register (GPIO0 to GPIO31)
#define GPIO_O_GPAGMUX1           0x40U     // GPIO A Peripheral Group Mux (GPIO0 to 15)
#define GPIO_O_GPAGMUX2           0x44U     // GPIO A Peripheral Group Mux (GPIO16 to 31)

//GPIO B (0x080~0xFC)
#define GPIO_O_GPBCTRL            0x80U     // GPIO B Qualification Sampling Period Control (GPIO32 to 63)
#define GPIO_O_GPBQSEL1           0x84U     // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
#define GPIO_O_GPBQSEL2           0x88U     // GPIO B Qualifier Select 2 Register (GPIO48 to 63)
#define GPIO_O_GPBMUX1            0x8CU     // GPIO B Mux 1 Register (GPIO32 to 47)
#define GPIO_O_GPBMUX2            0x90U     // GPIO B Mux 2 Register (GPIO48 to 63)
//#define GPIO_O_GPBDIR             0x94U     // GPIO B Direction Register (GPIO32 to 63)
#define GPIO_O_GPBPUD             0x98U     // GPIO B Pull Up Disable Register (GPIO32 to 63)
#define GPIO_O_GPBINV             0xA0U     // GPIO B Input Polarity Invert Registers (GPIO32 to 63)
#define GPIO_O_GPBAMSEL           0xA8U     // GPIO B Analog Mode Select register  (GPIO32 to 63)
#define GPIO_O_GPBGMUX1           0xC0U     // GPIO B Peripheral Group Mux (GPIO32 to 47)
#define GPIO_O_GPBGMUX2           0xC4U     // GPIO B Peripheral Group Mux (GPIO48 to 63)

//GPIO C (0x100~0x17C)
#define GPIO_O_GPCCTRL            0x100U    // GPIO C Qualification Sampling Period Control (GPIO64 to 68)
#define GPIO_O_GPCQSEL1           0x104U    // GPIO C Qualifier Select 1 Register (GPIO64 to 68)
#define GPIO_O_GPCQSEL2           0x108U    // GPIO C Qualifier Select 1 Register (GPIO64 to 68)
#define GPIO_O_GPCMUX1            0x10CU    // GPIO C Mux 1 Register (GPIO64 to 68)
#define GPIO_O_GPCMUX2            0x110U    // GPIO C Mux 1 Register (GPIO64 to 68)
#define GPIO_O_GPCDIR             0x114U    // GPIO C Direction Register (GPIO64 to 68)
#define GPIO_O_GPCPUD             0x118U    // GPIO C Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPCINV             0x120U    // GPIO C Input Polarity Invert Registers (GPIO64 to 68)
#define GPIO_O_GPCGMUX1           0x140U    // GPIO C Peripheral Group Mux (GPIO64 to 68)
#define GPIO_O_GPCGMUX2           0x144U    // GPIO C Peripheral Group Mux (GPIO64 to 68)



//GPIO D (0x180~0x1FC)
#define GPIO_O_GPDCTRL            0x180U    // GPIO D Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPDQSEL1           0x184U    // GPIO D Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPDQSEL2           0x188U    // GPIO D Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPDMUX1            0x18CU    // GPIO D Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPDMUX2            0x190U    // GPIO D Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPDPUD             0x198U    // GPIO D Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPDINV             0x1A0U    // GPIO D Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPDGMUX1           0x1C0U    // GPIO D Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPDGMUX2           0x1C4U    // GPIO D Peripheral Group Mux (GPIO240 to 255)

//GPIO E (0x200~0x27C)
#define GPIO_O_GPECTRL            0x200U    // GPIO E Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPEQSEL1           0x204U    // GPIO E Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPEQSEL2           0x208U    // GPIO E Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPEMUX1            0x20CU    // GPIO E Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPEMUX2            0x210U    // GPIO E Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPEPUD             0x218U    // GPIO E Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPEINV             0x220U    // GPIO E Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPEGMUX1           0x240U    // GPIO E Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPEGMUX2           0x244U    // GPIO E Peripheral Group Mux (GPIO240 to 255)

//GPIO F (0x280~0x2FC)
#define GPIO_O_GPFCTRL            0x280U    // GPIO F Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPFQSEL1           0x284U    // GPIO F Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPFQSEL2           0x288U    // GPIO F Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPFMUX1            0x28CU    // GPIO F Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPFMUX2            0x290U    // GPIO F Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPFPUD             0x298U    // GPIO F Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPFINV             0x2A0U    // GPIO F Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPFGMUX1           0x2C0U    // GPIO F Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPFGMUX2           0x2C4U    // GPIO F Peripheral Group Mux (GPIO240 to 255)

//GPIO G (0x300~0x37C)
#define GPIO_O_GPGCTRL            0x300U    // GPIO G Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPGQSEL1           0x304U    // GPIO G Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPGQSEL2           0x308U    // GPIO G Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPGMUX1            0x30CU    // GPIO G Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPGMUX2            0x310U    // GPIO G Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPGPUD             0x318U    // GPIO G Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPGINV             0x320U    // GPIO G Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPGAMSEL           0x328U    // GPIO G Analog Mode Select register  (GPIO32 to 63)
#define GPIO_O_GPGGMUX1           0x340U    // GPIO G Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPGGMUX2           0x344U    // GPIO G Peripheral Group Mux (GPIO240 to 255)


//GPIO H (0x380~0x3FC)
#define GPIO_O_GPHCTRL            0x380U    // GPIO H Qualification Sampling Period Control (GPIO224 to 255)
#define GPIO_O_GPHQSEL1           0x384U    // GPIO H Qualifier Select 1 Register (GPIO224 to 239)
#define GPIO_O_GPHQSEL2           0x388U    // GPIO H Qualifier Select 2 Register (GPIO240 to 255)
#define GPIO_O_GPHMUX1            0x38CU    // GPIO H Mux 1 Register (GPIO224 to 239)
#define GPIO_O_GPHMUX2            0x390U    // GPIO H Mux 2 Register (GPIO240 to 255)
#define GPIO_O_GPHPUD             0x398U    // GPIO H Pull Up Disable Register (GPIO64 to 68)
#define GPIO_O_GPHINV             0x3A0U    // GPIO H Input Polarity Invert Registers (GPIO224 to 255)
#define GPIO_O_GPHAMSEL           0x3A8U    // GPIO H Analog Mode Select register (GPIO224 to GPIO255)
#define GPIO_O_GPHGMUX1           0x3C0U    // GPIO H Peripheral Group Mux (GPIO224 to 239)
#define GPIO_O_GPHGMUX2           0x3C4U    // GPIO H Peripheral Group Mux (GPIO240 to 255)

//GJ  GPIOA Extend Feature (0x400~0x41C)
#define GPIO_O_GPAPDD             0x400U    //GPIO A Pull Down Disable Register (GPIO0 to 31)
#define GPIO_O_GPADS1             0x404U    //GPIO A Drive Strength 1 Register1 (GPIO0 to 15)
#define GPIO_O_GPADS2             0x408U    //GPIO A Drive Strength Register2 (GPIO16 to 31)
#define GPIO_O_GPAIS              0x40CU    //GPIO A Schmitt Trigger Register (GPIO0 to 31)
#define GPIO_O_GPAOUTINV          0x410U    //GPIO A output Polarity Invert Registers (GPIO0 to 31)
#define GPIO_O_GPALOOPEN          0x414U    //GPIO A LOOP Enable Registers (GPIO0 to 31)
#define GPIO_O_GPAPI2C_MODE       0x418U    //GPIO A PI2C MODE Registers (GPIO0 to 31)
#define GPIO_O_GPA_POUT_RPT       0x41CU    //IO0~31 POUT Real time reporting

//GJ  GPIOB Extend Feature (0x420~0x43C)
#define GPIO_O_GPBPDD             0x420U    //GPIO B Pull Down Disable Register (GPIO32 to 63)
#define GPIO_O_GPBDS1             0x424U    //GPIO B Drive Strength 1 Register1 (GPIO32 to 47)
#define GPIO_O_GPBDS2             0x428U    //GPIO B Drive Strength Register2 (GPIO48 to 63)
#define GPIO_O_GPBIS              0x42CU    //GPIO B Schmitt Trigger Register (GPIO32 to 63)
#define GPIO_O_GPBOUTINV          0x430U    //GPIO B output Polarity Invert Registers (GPIO32 to 63)
#define GPIO_O_GPBLOOPEN          0x434U    //GPIO B LOOP Enable Registers (GPIO32 to 63)
#define GPIO_O_GPBPI2C_MODE       0x438U    //GPIO B PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPB_POUT_RPT       0x43CU    //IO32~63 POUT Real time reporting

//GJ  GPIOC Extend Feature (0x440~0x45C)
#define GPIO_O_GPCPDD             0x440U    //GPIO C Pull Down Disable Register (GPIO64 to 95)
#define GPIO_O_GPCDS1             0x444U    //GPIO C Drive Strength 1 Register1 (GPIO64 to 79)
#define GPIO_O_GPCDS2             0x448U    //GPIO C Drive Strength 1 Register1 (GPIO80 to 95)
#define GPIO_O_GPCIS              0x44CU    //GPIO C Schmitt Trigger Register (GPIO64 to 95)
#define GPIO_O_GPCOUTINV          0x450U    //GPIO C output Polarity Invert Registers (GPIO64 to 95)
#define GPIO_O_GPCLOOPEN          0x454U    //GPIO C LOOP Enable Registers (GPIO64 to 95)
#define GPIO_O_GPCPI2C_MODE       0x458U    //GPIO C PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPC_POUT_RPT       0x45CU    //IO64~95 POUT Real time reporting

//GJ  GPIOD Extend Feature (0x460~0x47C)
#define GPIO_O_GPDPDD             0x460U    //GPIO D Pull Down Disable Register (GPIO64 to 95)
#define GPIO_O_GPDDS1             0x464U    //GPIO D Drive Strength 1 Register1 (GPIO64 to 79)
#define GPIO_O_GPDDS2             0x468U    //GPIO D Drive Strength 1 Register1 (GPIO80 to 95)
#define GPIO_O_GPDIS              0x46CU    //GPIO D Schmitt Trigger Register (GPIO64 to 95)
#define GPIO_O_GPDOUTINV          0x470U    //GPIO D output Polarity Invert Registers (GPIO64 to 95)
#define GPIO_O_GPDLOOPEN          0x474U    //GPIO D LOOP Enable Registers (GPIO64 to 95)
#define GPIO_O_GPDPI2C_MODE       0x478U    //GPIO D PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPD_POUT_RPT       0x47CU    //IO64~95 POUT Real time reporting

//GJ  GPIOE Extend Feature (0x480~0x49C)
#define GPIO_O_GPEPDD             0x480U    //GPIO E Pull Down Disable Register (GPIO64 to 95)
#define GPIO_O_GPEDS1             0x484U    //GPIO E Drive Strength 1 Register1 (GPIO64 to 79)
#define GPIO_O_GPEDS2             0x488U    //GPIO E Drive Strength 1 Register1 (GPIO80 to 95)
#define GPIO_O_GPEIS              0x48CU    //GPIO E Schmitt Trigger Register (GPIO64 to 95)
#define GPIO_O_GPEOUTINV          0x490U    //GPIO E output Polarity Invert Registers (GPIO64 to 95)
#define GPIO_O_GPELOOPEN          0x494U    //GPIO E LOOP Enable Registers (GPIO64 to 95)
#define GPIO_O_GPEPI2C_MODE       0x498U    //GPIO E PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPE_POUT_RPT       0x49CU    //IO64~95 POUT Real time reporting

//GJ  GPIOF Extend Feature (0x4A0~0x4BC)
#define GPIO_O_GPFPDD             0x4A0U    //GPIO F Pull Down Disable Register (GPIO64 to 95)
#define GPIO_O_GPFDS1             0x4A4U    //GPIO F Drive Strength 1 Register1 (GPIO64 to 79)
#define GPIO_O_GPFDS2             0x4A8U    //GPIO F Drive Strength 1 Register1 (GPIO80 to 95)
#define GPIO_O_GPFIS              0x4ACU    //GPIO F Schmitt Trigger Register (GPIO64 to 95)
#define GPIO_O_GPFOUTINV          0x4B0U    //GPIO F output Polarity Invert Registers (GPIO64 to 95)
#define GPIO_O_GPFLOOPEN          0x4B4U    //GPIO F LOOP Enable Registers (GPIO64 to 95)
#define GPIO_O_GPFPI2C_MODE       0x4B8U    //GPIO F PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPF_POUT_RPT       0x4BCU    //IO64~95 POUT Real time reporting

//GJ  GPIOG Extend Feature (0x4C0~0x4DC)
#define GPIO_O_GPGPDD             0x4C0U    //GPIO G Pull Down Disable Register (GPIO64 to 95)
#define GPIO_O_GPGDS1             0x4C4U    //GPIO G Drive Strength 1 Register1 (GPIO64 to 79)
#define GPIO_O_GPGDS2             0x4C8U    //GPIO G Drive Strength 1 Register1 (GPIO80 to 95)
#define GPIO_O_GPGIS              0x4CCU    //GPIO G Schmitt Trigger Register (GPIO64 to 95)
#define GPIO_O_GPGOUTINV          0x4D0U    //GPIO G output Polarity Invert Registers (GPIO64 to 95)
#define GPIO_O_GPGLOOPEN          0x4D4U    //GPIO G LOOP Enable Registers (GPIO64 to 95)
#define GPIO_O_GPGPI2C_MODE       0x4D8U    //GPIO G PI2C MODE Registers (GPIO32 to 63)
#define GPIO_O_GPG_POUT_RPT       0x4DCU    //IO64~95 POUT Real time reporting

//GJ  GPIOH Extend Feature (0x4E0~0x4FC)
#define GPIO_O_GPHPDD             0x4E0U    //GPIO H Pull Down Disable Register (GPIO64 to 95)
#define GPIO_O_GPHIS              0x4ECU    //GPIO H Schmitt Trigger Register (GPIO224 to 255)
#define GPIO_O_GPHOUTINV          0x4F0U    //GPIO H output Polarity Invert Registers (GPIO64 to 95)
#define GPIO_O_GPHLOOPEN          0x4F4U    //GPIO H LOOP Enable Registers (GPIO64 to 95)
#define GPIO_O_GPHIE              0x4F8U    //GPIO H  input Enable Registers (GPIO224 to 255)
#define GPIO_O_GPH_POUT_RPT       0x4FCU    //IO64~95 POUT Real time reporting

// (0x300~0x37C)

#endif

#if IS_GS32F00xx(0x12)
#define GPIO_O_HSE_CTRL           0x304     //HSE mode configuration
#define GPIO_O_IO_IE_MODE         0x308     //GPIO configuration IE mode selection
#define GPIO_O_LPMCR_QUALSTDBY    0x350     //
#define GPIO_O_IO_SET_STDBY       0x354     //
#define GPIO_O_GPIOLPMSEL0        0x358     //GPIO WAKE_UP SELECT0
#define GPIO_O_GPIOLPMSEL1        0x35C     //GPIO WAKE_UP SELECT1
#define GPIO_O_GPIOLPMSEL2        0x360     //GPIO WAKE_UP SELECT2
#elif IS_GS32F3xx(0x22)
#define GPIO_O_HSE_CTRL           0x504     //HSE mode configuration
#define GPIO_O_IO_IE_MODE         0x508     //GPIO configuration IE mode selection
#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPACTRL register
//
//*************************************************************************************************
#define GPIO_GPACTRL_QUALPRD0_S   0U
#define GPIO_GPACTRL_QUALPRD0_M   0xFFU         // Qualification sampling period for GPIO0 to GPIO7
#define GPIO_GPACTRL_QUALPRD1_S   8U
#define GPIO_GPACTRL_QUALPRD1_M   0xFF00U       // Qualification sampling period for GPIO8 to
                                                // GPIO15
#define GPIO_GPACTRL_QUALPRD2_S   16U
#define GPIO_GPACTRL_QUALPRD2_M   0xFF0000U     // Qualification sampling period for GPIO16 to
                                                // GPIO23
#define GPIO_GPACTRL_QUALPRD3_S   24U
#define GPIO_GPACTRL_QUALPRD3_M   0xFF000000U   // Qualification sampling period for GPIO24 to
                                                // GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPAQSEL1_GPIO0_S    0U
#define GPIO_GPAQSEL1_GPIO0_M    0x3U          // Select input qualification type for GPIO0
#define GPIO_GPAQSEL1_GPIO1_S    2U
#define GPIO_GPAQSEL1_GPIO1_M    0xCU          // Select input qualification type for GPIO1
#define GPIO_GPAQSEL1_GPIO2_S    4U
#define GPIO_GPAQSEL1_GPIO2_M    0x30U         // Select input qualification type for GPIO2
#define GPIO_GPAQSEL1_GPIO3_S    6U
#define GPIO_GPAQSEL1_GPIO3_M    0xC0U         // Select input qualification type for GPIO3
#define GPIO_GPAQSEL1_GPIO4_S    8U
#define GPIO_GPAQSEL1_GPIO4_M    0x300U        // Select input qualification type for GPIO4
#define GPIO_GPAQSEL1_GPIO5_S    10U
#define GPIO_GPAQSEL1_GPIO5_M    0xC00U        // Select input qualification type for GPIO5
#define GPIO_GPAQSEL1_GPIO6_S    12U
#define GPIO_GPAQSEL1_GPIO6_M    0x3000U       // Select input qualification type for GPIO6
#define GPIO_GPAQSEL1_GPIO7_S    14U
#define GPIO_GPAQSEL1_GPIO7_M    0xC000U       // Select input qualification type for GPIO7
#define GPIO_GPAQSEL1_GPIO8_S    16U
#define GPIO_GPAQSEL1_GPIO8_M    0x30000U      // Select input qualification type for GPIO8
#define GPIO_GPAQSEL1_GPIO9_S    18U
#define GPIO_GPAQSEL1_GPIO9_M    0xC0000U      // Select input qualification type for GPIO9
#define GPIO_GPAQSEL1_GPIO10_S   20U
#define GPIO_GPAQSEL1_GPIO10_M   0x300000U     // Select input qualification type for GPIO10
#define GPIO_GPAQSEL1_GPIO11_S   22U
#define GPIO_GPAQSEL1_GPIO11_M   0xC00000U     // Select input qualification type for GPIO11
#define GPIO_GPAQSEL1_GPIO12_S   24U
#define GPIO_GPAQSEL1_GPIO12_M   0x3000000U    // Select input qualification type for GPIO12
#define GPIO_GPAQSEL1_GPIO13_S   26U
#define GPIO_GPAQSEL1_GPIO13_M   0xC000000U    // Select input qualification type for GPIO13
#define GPIO_GPAQSEL1_GPIO14_S   28U
#define GPIO_GPAQSEL1_GPIO14_M   0x30000000U   // Select input qualification type for GPIO14
#define GPIO_GPAQSEL1_GPIO15_S   30U
#define GPIO_GPAQSEL1_GPIO15_M   0xC0000000U   // Select input qualification type for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAQSEL2 register
//
//*************************************************************************************************
#define GPIO_GPAQSEL2_GPIO16_S   0U
#define GPIO_GPAQSEL2_GPIO16_M   0x3U          // Select input qualification type for GPIO16
#define GPIO_GPAQSEL2_GPIO17_S   2U
#define GPIO_GPAQSEL2_GPIO17_M   0xCU          // Select input qualification type for GPIO17
#define GPIO_GPAQSEL2_GPIO18_S   4U
#define GPIO_GPAQSEL2_GPIO18_M   0x30U         // Select input qualification type for GPIO18
#define GPIO_GPAQSEL2_GPIO19_S   6U
#define GPIO_GPAQSEL2_GPIO19_M   0xC0U         // Select input qualification type for GPIO19
#define GPIO_GPAQSEL2_GPIO20_S   8U
#define GPIO_GPAQSEL2_GPIO20_M   0x300U        // Select input qualification type for GPIO20
#define GPIO_GPAQSEL2_GPIO21_S   10U
#define GPIO_GPAQSEL2_GPIO21_M   0xC00U        // Select input qualification type for GPIO21
#define GPIO_GPAQSEL2_GPIO22_S   12U
#define GPIO_GPAQSEL2_GPIO22_M   0x3000U       // Select input qualification type for GPIO22
#define GPIO_GPAQSEL2_GPIO23_S   14U
#define GPIO_GPAQSEL2_GPIO23_M   0xC000U       // Select input qualification type for GPIO23
#define GPIO_GPAQSEL2_GPIO24_S   16U
#define GPIO_GPAQSEL2_GPIO24_M   0x30000U      // Select input qualification type for GPIO24
#define GPIO_GPAQSEL2_GPIO25_S   18U
#define GPIO_GPAQSEL2_GPIO25_M   0xC0000U      // Select input qualification type for GPIO25
#define GPIO_GPAQSEL2_GPIO26_S   20U
#define GPIO_GPAQSEL2_GPIO26_M   0x300000U     // Select input qualification type for GPIO26
#define GPIO_GPAQSEL2_GPIO27_S   22U
#define GPIO_GPAQSEL2_GPIO27_M   0xC00000U     // Select input qualification type for GPIO27
#define GPIO_GPAQSEL2_GPIO28_S   24U
#define GPIO_GPAQSEL2_GPIO28_M   0x3000000U    // Select input qualification type for GPIO28
#define GPIO_GPAQSEL2_GPIO29_S   26U
#define GPIO_GPAQSEL2_GPIO29_M   0xC000000U    // Select input qualification type for GPIO29
#define GPIO_GPAQSEL2_GPIO30_S   28U
#define GPIO_GPAQSEL2_GPIO30_M   0x30000000U   // Select input qualification type for GPIO30
#define GPIO_GPAQSEL2_GPIO31_S   30U
#define GPIO_GPAQSEL2_GPIO31_M   0xC0000000U   // Select input qualification type for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAMUX1 register
//
//*************************************************************************************************
#define GPIO_GPAMUX1_GPIO0_S    0U
#define GPIO_GPAMUX1_GPIO0_M    0x3U          // Defines pin-muxing selection for GPIO0
#define GPIO_GPAMUX1_GPIO1_S    2U
#define GPIO_GPAMUX1_GPIO1_M    0xCU          // Defines pin-muxing selection for GPIO1
#define GPIO_GPAMUX1_GPIO2_S    4U
#define GPIO_GPAMUX1_GPIO2_M    0x30U         // Defines pin-muxing selection for GPIO2
#define GPIO_GPAMUX1_GPIO3_S    6U
#define GPIO_GPAMUX1_GPIO3_M    0xC0U         // Defines pin-muxing selection for GPIO3
#define GPIO_GPAMUX1_GPIO4_S    8U
#define GPIO_GPAMUX1_GPIO4_M    0x300U        // Defines pin-muxing selection for GPIO4
#define GPIO_GPAMUX1_GPIO5_S    10U
#define GPIO_GPAMUX1_GPIO5_M    0xC00U        // Defines pin-muxing selection for GPIO5
#define GPIO_GPAMUX1_GPIO6_S    12U
#define GPIO_GPAMUX1_GPIO6_M    0x3000U       // Defines pin-muxing selection for GPIO6
#define GPIO_GPAMUX1_GPIO7_S    14U
#define GPIO_GPAMUX1_GPIO7_M    0xC000U       // Defines pin-muxing selection for GPIO7
#define GPIO_GPAMUX1_GPIO8_S    16U
#define GPIO_GPAMUX1_GPIO8_M    0x30000U      // Defines pin-muxing selection for GPIO8
#define GPIO_GPAMUX1_GPIO9_S    18U
#define GPIO_GPAMUX1_GPIO9_M    0xC0000U      // Defines pin-muxing selection for GPIO9
#define GPIO_GPAMUX1_GPIO10_S   20U
#define GPIO_GPAMUX1_GPIO10_M   0x300000U     // Defines pin-muxing selection for GPIO10
#define GPIO_GPAMUX1_GPIO11_S   22U
#define GPIO_GPAMUX1_GPIO11_M   0xC00000U     // Defines pin-muxing selection for GPIO11
#define GPIO_GPAMUX1_GPIO12_S   24U
#define GPIO_GPAMUX1_GPIO12_M   0x3000000U    // Defines pin-muxing selection for GPIO12
#define GPIO_GPAMUX1_GPIO13_S   26U
#define GPIO_GPAMUX1_GPIO13_M   0xC000000U    // Defines pin-muxing selection for GPIO13
#define GPIO_GPAMUX1_GPIO14_S   28U
#define GPIO_GPAMUX1_GPIO14_M   0x30000000U   // Defines pin-muxing selection for GPIO14
#define GPIO_GPAMUX1_GPIO15_S   30U
#define GPIO_GPAMUX1_GPIO15_M   0xC0000000U   // Defines pin-muxing selection for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAMUX2 register
//
//*************************************************************************************************
#define GPIO_GPAMUX2_GPIO16_S   0U
#define GPIO_GPAMUX2_GPIO16_M   0x3U          // Defines pin-muxing selection for GPIO16
#define GPIO_GPAMUX2_GPIO17_S   2U
#define GPIO_GPAMUX2_GPIO17_M   0xCU          // Defines pin-muxing selection for GPIO17
#define GPIO_GPAMUX2_GPIO18_S   4U
#define GPIO_GPAMUX2_GPIO18_M   0x30U         // Defines pin-muxing selection for GPIO18
#define GPIO_GPAMUX2_GPIO19_S   6U
#define GPIO_GPAMUX2_GPIO19_M   0xC0U         // Defines pin-muxing selection for GPIO19
#define GPIO_GPAMUX2_GPIO20_S   8U
#define GPIO_GPAMUX2_GPIO20_M   0x300U        // Defines pin-muxing selection for GPIO20
#define GPIO_GPAMUX2_GPIO21_S   10U
#define GPIO_GPAMUX2_GPIO21_M   0xC00U        // Defines pin-muxing selection for GPIO21
#define GPIO_GPAMUX2_GPIO22_S   12U
#define GPIO_GPAMUX2_GPIO22_M   0x3000U       // Defines pin-muxing selection for GPIO22
#define GPIO_GPAMUX2_GPIO23_S   14U
#define GPIO_GPAMUX2_GPIO23_M   0xC000U       // Defines pin-muxing selection for GPIO23
#define GPIO_GPAMUX2_GPIO24_S   16U
#define GPIO_GPAMUX2_GPIO24_M   0x30000U      // Defines pin-muxing selection for GPIO24
#define GPIO_GPAMUX2_GPIO25_S   18U
#define GPIO_GPAMUX2_GPIO25_M   0xC0000U      // Defines pin-muxing selection for GPIO25
#define GPIO_GPAMUX2_GPIO26_S   20U
#define GPIO_GPAMUX2_GPIO26_M   0x300000U     // Defines pin-muxing selection for GPIO26
#define GPIO_GPAMUX2_GPIO27_S   22U
#define GPIO_GPAMUX2_GPIO27_M   0xC00000U     // Defines pin-muxing selection for GPIO27
#define GPIO_GPAMUX2_GPIO28_S   24U
#define GPIO_GPAMUX2_GPIO28_M   0x3000000U    // Defines pin-muxing selection for GPIO28
#define GPIO_GPAMUX2_GPIO29_S   26U
#define GPIO_GPAMUX2_GPIO29_M   0xC000000U    // Defines pin-muxing selection for GPIO29
#define GPIO_GPAMUX2_GPIO30_S   28U
#define GPIO_GPAMUX2_GPIO30_M   0x30000000U   // Defines pin-muxing selection for GPIO30
#define GPIO_GPAMUX2_GPIO31_S   30U
#define GPIO_GPAMUX2_GPIO31_M   0xC0000000U   // Defines pin-muxing selection for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPADIR register
//
//*************************************************************************************************
#define GPIO_GPADIR_GPIO0    0x1U          // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO1    0x2U          // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO2    0x4U          // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO3    0x8U          // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO4    0x10U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO5    0x20U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO6    0x40U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO7    0x80U         // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO8    0x100U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO9    0x200U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO10   0x400U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO11   0x800U        // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO12   0x1000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO13   0x2000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO14   0x4000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO15   0x8000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO16   0x10000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO17   0x20000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO18   0x40000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO19   0x80000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO20   0x100000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO21   0x200000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO22   0x400000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO23   0x800000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO24   0x1000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO25   0x2000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO26   0x4000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO27   0x8000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO28   0x10000000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO29   0x20000000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO30   0x40000000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPADIR_GPIO31   0x80000000U   // Defines direction for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAPUD register
//
//*************************************************************************************************
#define GPIO_GPAPUD_GPIO0    0x1U          // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO1    0x2U          // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO2    0x4U          // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO3    0x8U          // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO4    0x10U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO5    0x20U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO6    0x40U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO7    0x80U         // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO8    0x100U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO9    0x200U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO10   0x400U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO11   0x800U        // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO12   0x1000U       // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO13   0x2000U       // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO14   0x4000U       // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO15   0x8000U       // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO16   0x10000U      // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO17   0x20000U      // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO18   0x40000U      // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO19   0x80000U      // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO20   0x100000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO21   0x200000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO22   0x400000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO23   0x800000U     // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO24   0x1000000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO25   0x2000000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO26   0x4000000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO27   0x8000000U    // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO28   0x10000000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO29   0x20000000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO30   0x40000000U   // Pull-Up Disable control for this pin
#define GPIO_GPAPUD_GPIO31   0x80000000U   // Pull-Up Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAINV register
//
//*************************************************************************************************
#define GPIO_GPAINV_GPIO0    0x1U          // Input inversion control for this pin
#define GPIO_GPAINV_GPIO1    0x2U          // Input inversion control for this pin
#define GPIO_GPAINV_GPIO2    0x4U          // Input inversion control for this pin
#define GPIO_GPAINV_GPIO3    0x8U          // Input inversion control for this pin
#define GPIO_GPAINV_GPIO4    0x10U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO5    0x20U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO6    0x40U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO7    0x80U         // Input inversion control for this pin
#define GPIO_GPAINV_GPIO8    0x100U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO9    0x200U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO10   0x400U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO11   0x800U        // Input inversion control for this pin
#define GPIO_GPAINV_GPIO12   0x1000U       // Input inversion control for this pin
#define GPIO_GPAINV_GPIO13   0x2000U       // Input inversion control for this pin
#define GPIO_GPAINV_GPIO14   0x4000U       // Input inversion control for this pin
#define GPIO_GPAINV_GPIO15   0x8000U       // Input inversion control for this pin
#define GPIO_GPAINV_GPIO16   0x10000U      // Input inversion control for this pin
#define GPIO_GPAINV_GPIO17   0x20000U      // Input inversion control for this pin
#define GPIO_GPAINV_GPIO18   0x40000U      // Input inversion control for this pin
#define GPIO_GPAINV_GPIO19   0x80000U      // Input inversion control for this pin
#define GPIO_GPAINV_GPIO20   0x100000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO21   0x200000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO22   0x400000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO23   0x800000U     // Input inversion control for this pin
#define GPIO_GPAINV_GPIO24   0x1000000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO25   0x2000000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO26   0x4000000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO27   0x8000000U    // Input inversion control for this pin
#define GPIO_GPAINV_GPIO28   0x10000000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO29   0x20000000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO30   0x40000000U   // Input inversion control for this pin
#define GPIO_GPAINV_GPIO31   0x80000000U   // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAAMSEL register
//
//*************************************************************************************************
#define GPIO_GPAAMSEL_GPIO20   0x100000U   // Analog Mode select for this pin
#define GPIO_GPAAMSEL_GPIO21   0x200000U   // Analog Mode select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPAGMUX1_GPIO0_S    0U
#define GPIO_GPAGMUX1_GPIO0_M    0x3U          // Defines pin-muxing selection for GPIO0
#define GPIO_GPAGMUX1_GPIO1_S    2U
#define GPIO_GPAGMUX1_GPIO1_M    0xCU          // Defines pin-muxing selection for GPIO1
#define GPIO_GPAGMUX1_GPIO2_S    4U
#define GPIO_GPAGMUX1_GPIO2_M    0x30U         // Defines pin-muxing selection for GPIO2
#define GPIO_GPAGMUX1_GPIO3_S    6U
#define GPIO_GPAGMUX1_GPIO3_M    0xC0U         // Defines pin-muxing selection for GPIO3
#define GPIO_GPAGMUX1_GPIO4_S    8U
#define GPIO_GPAGMUX1_GPIO4_M    0x300U        // Defines pin-muxing selection for GPIO4
#define GPIO_GPAGMUX1_GPIO5_S    10U
#define GPIO_GPAGMUX1_GPIO5_M    0xC00U        // Defines pin-muxing selection for GPIO5
#define GPIO_GPAGMUX1_GPIO6_S    12U
#define GPIO_GPAGMUX1_GPIO6_M    0x3000U       // Defines pin-muxing selection for GPIO6
#define GPIO_GPAGMUX1_GPIO7_S    14U
#define GPIO_GPAGMUX1_GPIO7_M    0xC000U       // Defines pin-muxing selection for GPIO7
#define GPIO_GPAGMUX1_GPIO8_S    16U
#define GPIO_GPAGMUX1_GPIO8_M    0x30000U      // Defines pin-muxing selection for GPIO8
#define GPIO_GPAGMUX1_GPIO9_S    18U
#define GPIO_GPAGMUX1_GPIO9_M    0xC0000U      // Defines pin-muxing selection for GPIO9
#define GPIO_GPAGMUX1_GPIO10_S   20U
#define GPIO_GPAGMUX1_GPIO10_M   0x300000U     // Defines pin-muxing selection for GPIO10
#define GPIO_GPAGMUX1_GPIO11_S   22U
#define GPIO_GPAGMUX1_GPIO11_M   0xC00000U     // Defines pin-muxing selection for GPIO11
#define GPIO_GPAGMUX1_GPIO12_S   24U
#define GPIO_GPAGMUX1_GPIO12_M   0x3000000U    // Defines pin-muxing selection for GPIO12
#define GPIO_GPAGMUX1_GPIO13_S   26U
#define GPIO_GPAGMUX1_GPIO13_M   0xC000000U    // Defines pin-muxing selection for GPIO13
#define GPIO_GPAGMUX1_GPIO14_S   28U
#define GPIO_GPAGMUX1_GPIO14_M   0x30000000U   // Defines pin-muxing selection for GPIO14
#define GPIO_GPAGMUX1_GPIO15_S   30U
#define GPIO_GPAGMUX1_GPIO15_M   0xC0000000U   // Defines pin-muxing selection for GPIO15

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPAGMUX2 register
//
//*************************************************************************************************
#define GPIO_GPAGMUX2_GPIO16_S   0U
#define GPIO_GPAGMUX2_GPIO16_M   0x3U          // Defines pin-muxing selection for GPIO16
#define GPIO_GPAGMUX2_GPIO17_S   2U
#define GPIO_GPAGMUX2_GPIO17_M   0xCU          // Defines pin-muxing selection for GPIO17
#define GPIO_GPAGMUX2_GPIO18_S   4U
#define GPIO_GPAGMUX2_GPIO18_M   0x30U         // Defines pin-muxing selection for GPIO18
#define GPIO_GPAGMUX2_GPIO19_S   6U
#define GPIO_GPAGMUX2_GPIO19_M   0xC0U         // Defines pin-muxing selection for GPIO19
#define GPIO_GPAGMUX2_GPIO20_S   8U
#define GPIO_GPAGMUX2_GPIO20_M   0x300U        // Defines pin-muxing selection for GPIO20
#define GPIO_GPAGMUX2_GPIO21_S   10U
#define GPIO_GPAGMUX2_GPIO21_M   0xC00U        // Defines pin-muxing selection for GPIO21
#define GPIO_GPAGMUX2_GPIO22_S   12U
#define GPIO_GPAGMUX2_GPIO22_M   0x3000U       // Defines pin-muxing selection for GPIO22
#define GPIO_GPAGMUX2_GPIO23_S   14U
#define GPIO_GPAGMUX2_GPIO23_M   0xC000U       // Defines pin-muxing selection for GPIO23
#define GPIO_GPAGMUX2_GPIO24_S   16U
#define GPIO_GPAGMUX2_GPIO24_M   0x30000U      // Defines pin-muxing selection for GPIO24
#define GPIO_GPAGMUX2_GPIO25_S   18U
#define GPIO_GPAGMUX2_GPIO25_M   0xC0000U      // Defines pin-muxing selection for GPIO25
#define GPIO_GPAGMUX2_GPIO26_S   20U
#define GPIO_GPAGMUX2_GPIO26_M   0x300000U     // Defines pin-muxing selection for GPIO26
#define GPIO_GPAGMUX2_GPIO27_S   22U
#define GPIO_GPAGMUX2_GPIO27_M   0xC00000U     // Defines pin-muxing selection for GPIO27
#define GPIO_GPAGMUX2_GPIO28_S   24U
#define GPIO_GPAGMUX2_GPIO28_M   0x3000000U    // Defines pin-muxing selection for GPIO28
#define GPIO_GPAGMUX2_GPIO29_S   26U
#define GPIO_GPAGMUX2_GPIO29_M   0xC000000U    // Defines pin-muxing selection for GPIO29
#define GPIO_GPAGMUX2_GPIO30_S   28U
#define GPIO_GPAGMUX2_GPIO30_M   0x30000000U   // Defines pin-muxing selection for GPIO30
#define GPIO_GPAGMUX2_GPIO31_S   30U
#define GPIO_GPAGMUX2_GPIO31_M   0xC0000000U   // Defines pin-muxing selection for GPIO31

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBCTRL register
//
//*************************************************************************************************
#define GPIO_GPBCTRL_QUALPRD0_S   0U
#define GPIO_GPBCTRL_QUALPRD0_M   0xFFU         // Qualification sampling period for GPIO32 to
                                                // GPIO39
#define GPIO_GPBCTRL_QUALPRD1_S   8U
#define GPIO_GPBCTRL_QUALPRD1_M   0xFF00U       // Qualification sampling period for GPIO40 to
                                                // GPIO47
#define GPIO_GPBCTRL_QUALPRD2_S   16U
#define GPIO_GPBCTRL_QUALPRD2_M   0xFF0000U     // Qualification sampling period for GPIO48 to
                                                // GPIO55
#define GPIO_GPBCTRL_QUALPRD3_S   24U
#define GPIO_GPBCTRL_QUALPRD3_M   0xFF000000U   // Qualification sampling period for GPIO56 to
                                                // GPIO63

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPBQSEL1_GPIO32_S   0U
#define GPIO_GPBQSEL1_GPIO32_M   0x3U          // Select input qualification type for GPIO32
#define GPIO_GPBQSEL1_GPIO33_S   2U
#define GPIO_GPBQSEL1_GPIO33_M   0xCU          // Select input qualification type for GPIO33
#define GPIO_GPBQSEL1_GPIO34_S   4U
#define GPIO_GPBQSEL1_GPIO34_M   0x30U         // Select input qualification type for GPIO34
#define GPIO_GPBQSEL1_GPIO35_S   6U
#define GPIO_GPBQSEL1_GPIO35_M   0xC0U         // Select input qualification type for GPIO35
#define GPIO_GPBQSEL1_GPIO37_S   10U
#define GPIO_GPBQSEL1_GPIO37_M   0xC00U        // Select input qualification type for GPIO37
#define GPIO_GPBQSEL1_GPIO39_S   14U
#define GPIO_GPBQSEL1_GPIO39_M   0xC000U       // Select input qualification type for GPIO39
#define GPIO_GPBQSEL1_GPIO40_S   16U
#define GPIO_GPBQSEL1_GPIO40_M   0x30000U      // Select input qualification type for GPIO40
#define GPIO_GPBQSEL1_GPIO41_S   18U
#define GPIO_GPBQSEL1_GPIO41_M   0xC0000U      // Select input qualification type for GPIO41
#define GPIO_GPBQSEL1_GPIO42_S   20U
#define GPIO_GPBQSEL1_GPIO42_M   0x300000U     // Select input qualification type for GPIO42
#define GPIO_GPBQSEL1_GPIO43_S   22U
#define GPIO_GPBQSEL1_GPIO43_M   0xC00000U     // Select input qualification type for GPIO43
#define GPIO_GPBQSEL1_GPIO44_S   24U
#define GPIO_GPBQSEL1_GPIO44_M   0x3000000U    // Select input qualification type for GPIO44
#define GPIO_GPBQSEL1_GPIO45_S   26U
#define GPIO_GPBQSEL1_GPIO45_M   0xC000000U    // Select input qualification type for GPIO45
#define GPIO_GPBQSEL1_GPIO46_S   28U
#define GPIO_GPBQSEL1_GPIO46_M   0x30000000U   // Select input qualification type for GPIO46
#define GPIO_GPBQSEL1_GPIO47_S   30U
#define GPIO_GPBQSEL1_GPIO47_M   0xC0000000U   // Select input qualification type for GPIO47

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBQSEL2 register
//
//*************************************************************************************************
#define GPIO_GPBQSEL2_GPIO48_S   0U
#define GPIO_GPBQSEL2_GPIO48_M   0x3U         // Select input qualification type for GPIO48
#define GPIO_GPBQSEL2_GPIO49_S   2U
#define GPIO_GPBQSEL2_GPIO49_M   0xCU         // Select input qualification type for GPIO49
#define GPIO_GPBQSEL2_GPIO50_S   4U
#define GPIO_GPBQSEL2_GPIO50_M   0x30U        // Select input qualification type for GPIO50
#define GPIO_GPBQSEL2_GPIO51_S   6U
#define GPIO_GPBQSEL2_GPIO51_M   0xC0U        // Select input qualification type for GPIO51
#define GPIO_GPBQSEL2_GPIO52_S   8U
#define GPIO_GPBQSEL2_GPIO52_M   0x300U       // Select input qualification type for GPIO52
#define GPIO_GPBQSEL2_GPIO53_S   10U
#define GPIO_GPBQSEL2_GPIO53_M   0xC00U       // Select input qualification type for GPIO53
#define GPIO_GPBQSEL2_GPIO54_S   12U
#define GPIO_GPBQSEL2_GPIO54_M   0x3000U      // Select input qualification type for GPIO54
#define GPIO_GPBQSEL2_GPIO55_S   14U
#define GPIO_GPBQSEL2_GPIO55_M   0xC000U      // Select input qualification type for GPIO55
#define GPIO_GPBQSEL2_GPIO56_S   16U
#define GPIO_GPBQSEL2_GPIO56_M   0x30000U     // Select input qualification type for GPIO56
#define GPIO_GPBQSEL2_GPIO57_S   18U
#define GPIO_GPBQSEL2_GPIO57_M   0xC0000U     // Select input qualification type for GPIO57
#define GPIO_GPBQSEL2_GPIO58_S   20U
#define GPIO_GPBQSEL2_GPIO58_M   0x300000U    // Select input qualification type for GPIO58
#define GPIO_GPBQSEL2_GPIO59_S   22U
#define GPIO_GPBQSEL2_GPIO59_M   0xC00000U    // Select input qualification type for GPIO59
#define GPIO_GPBQSEL2_GPIO60_S   24U
#define GPIO_GPBQSEL2_GPIO60_M   0x3000000U   // Select input qualification type for GPIO60
#define GPIO_GPBQSEL2_GPIO61_S   26U
#define GPIO_GPBQSEL2_GPIO61_M   0xC000000U   // Select input qualification type for GPIO61

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBMUX1 register
//
//*************************************************************************************************
#define GPIO_GPBMUX1_GPIO32_S   0U
#define GPIO_GPBMUX1_GPIO32_M   0x3U          // Defines pin-muxing selection for GPIO32
#define GPIO_GPBMUX1_GPIO33_S   2U
#define GPIO_GPBMUX1_GPIO33_M   0xCU          // Defines pin-muxing selection for GPIO33
#define GPIO_GPBMUX1_GPIO34_S   4U
#define GPIO_GPBMUX1_GPIO34_M   0x30U         // Defines pin-muxing selection for GPIO34
#define GPIO_GPBMUX1_GPIO35_S   6U
#define GPIO_GPBMUX1_GPIO35_M   0xC0U         // Defines pin-muxing selection for GPIO35
#define GPIO_GPBMUX1_GPIO37_S   10U
#define GPIO_GPBMUX1_GPIO37_M   0xC00U        // Defines pin-muxing selection for GPIO37
#define GPIO_GPBMUX1_GPIO39_S   14U
#define GPIO_GPBMUX1_GPIO39_M   0xC000U       // Defines pin-muxing selection for GPIO39
#define GPIO_GPBMUX1_GPIO40_S   16U
#define GPIO_GPBMUX1_GPIO40_M   0x30000U      // Defines pin-muxing selection for GPIO40
#define GPIO_GPBMUX1_GPIO41_S   18U
#define GPIO_GPBMUX1_GPIO41_M   0xC0000U      // Defines pin-muxing selection for GPIO41
#define GPIO_GPBMUX1_GPIO42_S   20U
#define GPIO_GPBMUX1_GPIO42_M   0x300000U     // Defines pin-muxing selection for GPIO42
#define GPIO_GPBMUX1_GPIO43_S   22U
#define GPIO_GPBMUX1_GPIO43_M   0xC00000U     // Defines pin-muxing selection for GPIO43
#define GPIO_GPBMUX1_GPIO44_S   24U
#define GPIO_GPBMUX1_GPIO44_M   0x3000000U    // Defines pin-muxing selection for GPIO44
#define GPIO_GPBMUX1_GPIO45_S   26U
#define GPIO_GPBMUX1_GPIO45_M   0xC000000U    // Defines pin-muxing selection for GPIO45
#define GPIO_GPBMUX1_GPIO46_S   28U
#define GPIO_GPBMUX1_GPIO46_M   0x30000000U   // Defines pin-muxing selection for GPIO46
#define GPIO_GPBMUX1_GPIO47_S   30U
#define GPIO_GPBMUX1_GPIO47_M   0xC0000000U   // Defines pin-muxing selection for GPIO47

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBMUX2 register
//
//*************************************************************************************************
#define GPIO_GPBMUX2_GPIO48_S   0U
#define GPIO_GPBMUX2_GPIO48_M   0x3U         // Defines pin-muxing selection for GPIO48
#define GPIO_GPBMUX2_GPIO49_S   2U
#define GPIO_GPBMUX2_GPIO49_M   0xCU         // Defines pin-muxing selection for GPIO49
#define GPIO_GPBMUX2_GPIO50_S   4U
#define GPIO_GPBMUX2_GPIO50_M   0x30U        // Defines pin-muxing selection for GPIO50
#define GPIO_GPBMUX2_GPIO51_S   6U
#define GPIO_GPBMUX2_GPIO51_M   0xC0U        // Defines pin-muxing selection for GPIO51
#define GPIO_GPBMUX2_GPIO52_S   8U
#define GPIO_GPBMUX2_GPIO52_M   0x300U       // Defines pin-muxing selection for GPIO52
#define GPIO_GPBMUX2_GPIO53_S   10U
#define GPIO_GPBMUX2_GPIO53_M   0xC00U       // Defines pin-muxing selection for GPIO53
#define GPIO_GPBMUX2_GPIO54_S   12U
#define GPIO_GPBMUX2_GPIO54_M   0x3000U      // Defines pin-muxing selection for GPIO54
#define GPIO_GPBMUX2_GPIO55_S   14U
#define GPIO_GPBMUX2_GPIO55_M   0xC000U      // Defines pin-muxing selection for GPIO55
#define GPIO_GPBMUX2_GPIO56_S   16U
#define GPIO_GPBMUX2_GPIO56_M   0x30000U     // Defines pin-muxing selection for GPIO56
#define GPIO_GPBMUX2_GPIO57_S   18U
#define GPIO_GPBMUX2_GPIO57_M   0xC0000U     // Defines pin-muxing selection for GPIO57
#define GPIO_GPBMUX2_GPIO58_S   20U
#define GPIO_GPBMUX2_GPIO58_M   0x300000U    // Defines pin-muxing selection for GPIO58
#define GPIO_GPBMUX2_GPIO59_S   22U
#define GPIO_GPBMUX2_GPIO59_M   0xC00000U    // Defines pin-muxing selection for GPIO59
#define GPIO_GPBMUX2_GPIO60_S   24U
#define GPIO_GPBMUX2_GPIO60_M   0x3000000U   // Defines pin-muxing selection for GPIO60
#define GPIO_GPBMUX2_GPIO61_S   26U
#define GPIO_GPBMUX2_GPIO61_M   0xC000000U   // Defines pin-muxing selection for GPIO61

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBDIR register
//
//*************************************************************************************************
#define GPIO_GPBDIR_GPIO32   0x1U          // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO33   0x2U          // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO34   0x4U          // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO35   0x8U          // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO37   0x20U         // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO39   0x80U         // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO40   0x100U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO41   0x200U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO42   0x400U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO43   0x800U        // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO44   0x1000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO45   0x2000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO46   0x4000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO47   0x8000U       // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO48   0x10000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO49   0x20000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO50   0x40000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO51   0x80000U      // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO52   0x100000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO53   0x200000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO54   0x400000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO55   0x800000U     // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO56   0x1000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO57   0x2000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO58   0x4000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO59   0x8000000U    // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO60   0x10000000U   // Defines direction for this pin in GPIO mode
#define GPIO_GPBDIR_GPIO61   0x20000000U   // Defines direction for this pin in GPIO mode

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBPUD register
//
//*************************************************************************************************
#define GPIO_GPBPUD_GPIO32   0x1U          // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO33   0x2U          // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO34   0x4U          // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO35   0x8U          // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO37   0x20U         // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO39   0x80U         // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO40   0x100U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO41   0x200U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO42   0x400U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO43   0x800U        // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO44   0x1000U       // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO45   0x2000U       // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO46   0x4000U       // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO47   0x8000U       // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO48   0x10000U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO49   0x20000U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO50   0x40000U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO51   0x80000U      // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO52   0x100000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO53   0x200000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO54   0x400000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO55   0x800000U     // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO56   0x1000000U    // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO57   0x2000000U    // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO58   0x4000000U    // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO59   0x8000000U    // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO60   0x10000000U   // Pull-Up Disable control for this pin
#define GPIO_GPBPUD_GPIO61   0x20000000U   // Pull-Up Disable control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBINV register
//
//*************************************************************************************************
#define GPIO_GPBINV_GPIO32   0x1U          // Input inversion control for this pin
#define GPIO_GPBINV_GPIO33   0x2U          // Input inversion control for this pin
#define GPIO_GPBINV_GPIO34   0x4U          // Input inversion control for this pin
#define GPIO_GPBINV_GPIO35   0x8U          // Input inversion control for this pin
#define GPIO_GPBINV_GPIO37   0x20U         // Input inversion control for this pin
#define GPIO_GPBINV_GPIO39   0x80U         // Input inversion control for this pin
#define GPIO_GPBINV_GPIO40   0x100U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO41   0x200U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO42   0x400U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO43   0x800U        // Input inversion control for this pin
#define GPIO_GPBINV_GPIO44   0x1000U       // Input inversion control for this pin
#define GPIO_GPBINV_GPIO45   0x2000U       // Input inversion control for this pin
#define GPIO_GPBINV_GPIO46   0x4000U       // Input inversion control for this pin
#define GPIO_GPBINV_GPIO47   0x8000U       // Input inversion control for this pin
#define GPIO_GPBINV_GPIO48   0x10000U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO49   0x20000U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO50   0x40000U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO51   0x80000U      // Input inversion control for this pin
#define GPIO_GPBINV_GPIO52   0x100000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO53   0x200000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO54   0x400000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO55   0x800000U     // Input inversion control for this pin
#define GPIO_GPBINV_GPIO56   0x1000000U    // Input inversion control for this pin
#define GPIO_GPBINV_GPIO57   0x2000000U    // Input inversion control for this pin
#define GPIO_GPBINV_GPIO58   0x4000000U    // Input inversion control for this pin
#define GPIO_GPBINV_GPIO59   0x8000000U    // Input inversion control for this pin
#define GPIO_GPBINV_GPIO60   0x10000000U   // Input inversion control for this pin
#define GPIO_GPBINV_GPIO61   0x20000000U   // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPBGMUX1_GPIO32_S   0U
#define GPIO_GPBGMUX1_GPIO32_M   0x3U          // Defines pin-muxing selection for GPIO32
#define GPIO_GPBGMUX1_GPIO33_S   2U
#define GPIO_GPBGMUX1_GPIO33_M   0xCU          // Defines pin-muxing selection for GPIO33
#define GPIO_GPBGMUX1_GPIO34_S   4U
#define GPIO_GPBGMUX1_GPIO34_M   0x30U         // Defines pin-muxing selection for GPIO34
#define GPIO_GPBGMUX1_GPIO35_S   6U
#define GPIO_GPBGMUX1_GPIO35_M   0xC0U         // Defines pin-muxing selection for GPIO35
#define GPIO_GPBGMUX1_GPIO37_S   10U
#define GPIO_GPBGMUX1_GPIO37_M   0xC00U        // Defines pin-muxing selection for GPIO37
#define GPIO_GPBGMUX1_GPIO39_S   14U
#define GPIO_GPBGMUX1_GPIO39_M   0xC000U       // Defines pin-muxing selection for GPIO39
#define GPIO_GPBGMUX1_GPIO40_S   16U
#define GPIO_GPBGMUX1_GPIO40_M   0x30000U      // Defines pin-muxing selection for GPIO40
#define GPIO_GPBGMUX1_GPIO41_S   18U
#define GPIO_GPBGMUX1_GPIO41_M   0xC0000U      // Defines pin-muxing selection for GPIO41
#define GPIO_GPBGMUX1_GPIO42_S   20U
#define GPIO_GPBGMUX1_GPIO42_M   0x300000U     // Defines pin-muxing selection for GPIO42
#define GPIO_GPBGMUX1_GPIO43_S   22U
#define GPIO_GPBGMUX1_GPIO43_M   0xC00000U     // Defines pin-muxing selection for GPIO43
#define GPIO_GPBGMUX1_GPIO44_S   24U
#define GPIO_GPBGMUX1_GPIO44_M   0x3000000U    // Defines pin-muxing selection for GPIO44
#define GPIO_GPBGMUX1_GPIO45_S   26U
#define GPIO_GPBGMUX1_GPIO45_M   0xC000000U    // Defines pin-muxing selection for GPIO45
#define GPIO_GPBGMUX1_GPIO46_S   28U
#define GPIO_GPBGMUX1_GPIO46_M   0x30000000U   // Defines pin-muxing selection for GPIO46
#define GPIO_GPBGMUX1_GPIO47_S   30U
#define GPIO_GPBGMUX1_GPIO47_M   0xC0000000U   // Defines pin-muxing selection for GPIO47

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPBGMUX2 register
//
//*************************************************************************************************
#define GPIO_GPBGMUX2_GPIO48_S   0U
#define GPIO_GPBGMUX2_GPIO48_M   0x3U         // Defines pin-muxing selection for GPIO48
#define GPIO_GPBGMUX2_GPIO49_S   2U
#define GPIO_GPBGMUX2_GPIO49_M   0xCU         // Defines pin-muxing selection for GPIO49
#define GPIO_GPBGMUX2_GPIO50_S   4U
#define GPIO_GPBGMUX2_GPIO50_M   0x30U        // Defines pin-muxing selection for GPIO50
#define GPIO_GPBGMUX2_GPIO51_S   6U
#define GPIO_GPBGMUX2_GPIO51_M   0xC0U        // Defines pin-muxing selection for GPIO51
#define GPIO_GPBGMUX2_GPIO52_S   8U
#define GPIO_GPBGMUX2_GPIO52_M   0x300U       // Defines pin-muxing selection for GPIO52
#define GPIO_GPBGMUX2_GPIO53_S   10U
#define GPIO_GPBGMUX2_GPIO53_M   0xC00U       // Defines pin-muxing selection for GPIO53
#define GPIO_GPBGMUX2_GPIO54_S   12U
#define GPIO_GPBGMUX2_GPIO54_M   0x3000U      // Defines pin-muxing selection for GPIO54
#define GPIO_GPBGMUX2_GPIO55_S   14U
#define GPIO_GPBGMUX2_GPIO55_M   0xC000U      // Defines pin-muxing selection for GPIO55
#define GPIO_GPBGMUX2_GPIO56_S   16U
#define GPIO_GPBGMUX2_GPIO56_M   0x30000U     // Defines pin-muxing selection for GPIO56
#define GPIO_GPBGMUX2_GPIO57_S   18U
#define GPIO_GPBGMUX2_GPIO57_M   0xC0000U     // Defines pin-muxing selection for GPIO57
#define GPIO_GPBGMUX2_GPIO58_S   20U
#define GPIO_GPBGMUX2_GPIO58_M   0x300000U    // Defines pin-muxing selection for GPIO58
#define GPIO_GPBGMUX2_GPIO59_S   22U
#define GPIO_GPBGMUX2_GPIO59_M   0xC00000U    // Defines pin-muxing selection for GPIO59
#define GPIO_GPBGMUX2_GPIO60_S   24U
#define GPIO_GPBGMUX2_GPIO60_M   0x3000000U   // Defines pin-muxing selection for GPIO60
#define GPIO_GPBGMUX2_GPIO61_S   26U
#define GPIO_GPBGMUX2_GPIO61_M   0xC000000U   // Defines pin-muxing selection for GPIO61

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHCTRL register
//
//*************************************************************************************************
#define GPIO_GPHCTRL_QUALPRD0_S   0U
#define GPIO_GPHCTRL_QUALPRD0_M   0xFFU         // Qualification sampling period for GPIO224 to
                                                // GPIO231
#define GPIO_GPHCTRL_QUALPRD1_S   8U
#define GPIO_GPHCTRL_QUALPRD1_M   0xFF00U       // Qualification sampling period for GPIO232 to
                                                // GPIO239
#define GPIO_GPHCTRL_QUALPRD2_S   16U
#define GPIO_GPHCTRL_QUALPRD2_M   0xFF0000U     // Qualification sampling period for GPIO240 to
                                                // GPIO247
#define GPIO_GPHCTRL_QUALPRD3_S   24U
#define GPIO_GPHCTRL_QUALPRD3_M   0xFF000000U   // Qualification sampling period for GPIO248 to
                                                // GPIO255

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHQSEL1 register
//
//*************************************************************************************************
#define GPIO_GPHQSEL1_GPIO224_S   0U
#define GPIO_GPHQSEL1_GPIO224_M   0x3U          // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO225_S   2U
#define GPIO_GPHQSEL1_GPIO225_M   0xCU          // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO226_S   4U
#define GPIO_GPHQSEL1_GPIO226_M   0x30U         // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO227_S   6U
#define GPIO_GPHQSEL1_GPIO227_M   0xC0U         // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO228_S   8U
#define GPIO_GPHQSEL1_GPIO228_M   0x300U        // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO229_S   10U
#define GPIO_GPHQSEL1_GPIO229_M   0xC00U        // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO230_S   12U
#define GPIO_GPHQSEL1_GPIO230_M   0x3000U       // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO231_S   14U
#define GPIO_GPHQSEL1_GPIO231_M   0xC000U       // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO232_S   16U
#define GPIO_GPHQSEL1_GPIO232_M   0x30000U      // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO233_S   18U
#define GPIO_GPHQSEL1_GPIO233_M   0xC0000U      // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO236_S   24U
#define GPIO_GPHQSEL1_GPIO236_M   0x3000000U    // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO237_S   26U
#define GPIO_GPHQSEL1_GPIO237_M   0xC000000U    // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO238_S   28U
#define GPIO_GPHQSEL1_GPIO238_M   0x30000000U   // Select input qualification type for this GPIO
                                                // Pin
#define GPIO_GPHQSEL1_GPIO239_S   30U
#define GPIO_GPHQSEL1_GPIO239_M   0xC0000000U   // Select input qualification type for this GPIO
                                                // Pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHQSEL2 register
//
//*************************************************************************************************
#define GPIO_GPHQSEL2_GPIO240_S   0U
#define GPIO_GPHQSEL2_GPIO240_M   0x3U         // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO241_S   2U
#define GPIO_GPHQSEL2_GPIO241_M   0xCU         // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO242_S   4U
#define GPIO_GPHQSEL2_GPIO242_M   0x30U        // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO244_S   8U
#define GPIO_GPHQSEL2_GPIO244_M   0x300U       // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO245_S   10U
#define GPIO_GPHQSEL2_GPIO245_M   0xC00U       // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO247_S   14U
#define GPIO_GPHQSEL2_GPIO247_M   0xC000U      // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO248_S   16U
#define GPIO_GPHQSEL2_GPIO248_M   0x30000U     // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO249_S   18U
#define GPIO_GPHQSEL2_GPIO249_M   0xC0000U     // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO251_S   22U
#define GPIO_GPHQSEL2_GPIO251_M   0xC00000U    // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO252_S   24U
#define GPIO_GPHQSEL2_GPIO252_M   0x3000000U   // Select input qualification type for this GPIO Pin
#define GPIO_GPHQSEL2_GPIO253_S   26U
#define GPIO_GPHQSEL2_GPIO253_M   0xC000000U   // Select input qualification type for this GPIO Pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHMUX1 register
//
//*************************************************************************************************
#define GPIO_GPHMUX1_GPIO224_S   0U
#define GPIO_GPHMUX1_GPIO224_M   0x3U          // Defines pin-muxing selection for GPIO224
#define GPIO_GPHMUX1_GPIO225_S   2U
#define GPIO_GPHMUX1_GPIO225_M   0xCU          // Defines pin-muxing selection for GPIO225
#define GPIO_GPHMUX1_GPIO226_S   4U
#define GPIO_GPHMUX1_GPIO226_M   0x30U         // Defines pin-muxing selection for GPIO226
#define GPIO_GPHMUX1_GPIO227_S   6U
#define GPIO_GPHMUX1_GPIO227_M   0xC0U         // Defines pin-muxing selection for GPIO227
#define GPIO_GPHMUX1_GPIO228_S   8U
#define GPIO_GPHMUX1_GPIO228_M   0x300U        // Defines pin-muxing selection for GPIO228
#define GPIO_GPHMUX1_GPIO230_S   12U
#define GPIO_GPHMUX1_GPIO230_M   0x3000U       // Defines pin-muxing selection for GPIO230
#define GPIO_GPHMUX1_GPIO231_S   14U
#define GPIO_GPHMUX1_GPIO231_M   0xC000U       // Defines pin-muxing selection for GPIO231
#define GPIO_GPHMUX1_GPIO232_S   16U
#define GPIO_GPHMUX1_GPIO232_M   0x30000U      // Defines pin-muxing selection for GPIO232
#define GPIO_GPHMUX1_GPIO233_S   18U
#define GPIO_GPHMUX1_GPIO233_M   0xC0000U      // Defines pin-muxing selection for GPIO233
#define GPIO_GPHMUX1_GPIO237_S   26U
#define GPIO_GPHMUX1_GPIO237_M   0xC000000U    // Defines pin-muxing selection for GPIO237
#define GPIO_GPHMUX1_GPIO238_S   28U
#define GPIO_GPHMUX1_GPIO238_M   0x30000000U   // Defines pin-muxing selection for GPIO238
#define GPIO_GPHMUX1_GPIO239_S   30U
#define GPIO_GPHMUX1_GPIO239_M   0xC0000000U   // Defines pin-muxing selection for GPIO239

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHMUX2 register
//
//*************************************************************************************************
#define GPIO_GPHMUX2_GPIO240_S   0U
#define GPIO_GPHMUX2_GPIO240_M   0x3U         // Defines pin-muxing selection for GPIO240
#define GPIO_GPHMUX2_GPIO241_S   2U
#define GPIO_GPHMUX2_GPIO241_M   0xCU         // Defines pin-muxing selection for GPIO241
#define GPIO_GPHMUX2_GPIO242_S   4U
#define GPIO_GPHMUX2_GPIO242_M   0x30U        // Defines pin-muxing selection for GPIO242
#define GPIO_GPHMUX2_GPIO244_S   8U
#define GPIO_GPHMUX2_GPIO244_M   0x300U       // Defines pin-muxing selection for GPIO244
#define GPIO_GPHMUX2_GPIO245_S   10U
#define GPIO_GPHMUX2_GPIO245_M   0xC00U       // Defines pin-muxing selection for GPIO245
#define GPIO_GPHMUX2_GPIO252_S   24U
#define GPIO_GPHMUX2_GPIO252_M   0x3000000U   // Defines pin-muxing selection for GPIO252

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHINV register
//
//*************************************************************************************************
#define GPIO_GPHINV_GPIO224   0x1U          // Input inversion control for this pin
#define GPIO_GPHINV_GPIO225   0x2U          // Input inversion control for this pin
#define GPIO_GPHINV_GPIO226   0x4U          // Input inversion control for this pin
#define GPIO_GPHINV_GPIO227   0x8U          // Input inversion control for this pin
#define GPIO_GPHINV_GPIO228   0x10U         // Input inversion control for this pin
#define GPIO_GPHINV_GPIO229   0x20U         // Input inversion control for this pin
#define GPIO_GPHINV_GPIO230   0x40U         // Input inversion control for this pin
#define GPIO_GPHINV_GPIO231   0x80U         // Input inversion control for this pin
#define GPIO_GPHINV_GPIO232   0x100U        // Input inversion control for this pin
#define GPIO_GPHINV_GPIO233   0x200U        // Input inversion control for this pin
#define GPIO_GPHINV_GPIO236   0x1000U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO237   0x2000U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO238   0x4000U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO239   0x8000U       // Input inversion control for this pin
#define GPIO_GPHINV_GPIO240   0x10000U      // Input inversion control for this pin
#define GPIO_GPHINV_GPIO241   0x20000U      // Input inversion control for this pin
#define GPIO_GPHINV_GPIO242   0x40000U      // Input inversion control for this pin
#define GPIO_GPHINV_GPIO244   0x100000U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO245   0x200000U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO247   0x800000U     // Input inversion control for this pin
#define GPIO_GPHINV_GPIO248   0x1000000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO249   0x2000000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO251   0x8000000U    // Input inversion control for this pin
#define GPIO_GPHINV_GPIO252   0x10000000U   // Input inversion control for this pin
#define GPIO_GPHINV_GPIO253   0x20000000U   // Input inversion control for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHAMSEL register
//
//*************************************************************************************************
#define GPIO_GPHAMSEL_GPIO224   0x1U          // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO225   0x2U          // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO226   0x4U          // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO227   0x8U          // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO228   0x10U         // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO229   0x20U         // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO230   0x40U         // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO231   0x80U         // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO232   0x100U        // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO233   0x200U        // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO236   0x1000U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO237   0x2000U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO238   0x4000U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO239   0x8000U       // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO240   0x10000U      // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO241   0x20000U      // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO242   0x40000U      // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO244   0x100000U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO245   0x200000U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO247   0x800000U     // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO248   0x1000000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO249   0x2000000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO251   0x8000000U    // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO252   0x10000000U   // Analog Mode select for this pin
#define GPIO_GPHAMSEL_GPIO253   0x20000000U   // Analog Mode select for this pin

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHGMUX1 register
//
//*************************************************************************************************
#define GPIO_GPHGMUX1_GPIO224_S   0U
#define GPIO_GPHGMUX1_GPIO224_M   0x3U          // Defines pin-muxing selection for GPIO224
#define GPIO_GPHGMUX1_GPIO225_S   2U
#define GPIO_GPHGMUX1_GPIO225_M   0xCU          // Defines pin-muxing selection for GPIO225
#define GPIO_GPHGMUX1_GPIO226_S   4U
#define GPIO_GPHGMUX1_GPIO226_M   0x30U         // Defines pin-muxing selection for GPIO226
#define GPIO_GPHGMUX1_GPIO227_S   6U
#define GPIO_GPHGMUX1_GPIO227_M   0xC0U         // Defines pin-muxing selection for GPIO227
#define GPIO_GPHGMUX1_GPIO228_S   8U
#define GPIO_GPHGMUX1_GPIO228_M   0x300U        // Defines pin-muxing selection for GPIO228
#define GPIO_GPHGMUX1_GPIO230_S   12U
#define GPIO_GPHGMUX1_GPIO230_M   0x3000U       // Defines pin-muxing selection for GPIO230
#define GPIO_GPHGMUX1_GPIO231_S   14U
#define GPIO_GPHGMUX1_GPIO231_M   0xC000U       // Defines pin-muxing selection for GPIO231
#define GPIO_GPHGMUX1_GPIO232_S   16U
#define GPIO_GPHGMUX1_GPIO232_M   0x30000U      // Defines pin-muxing selection for GPIO232
#define GPIO_GPHGMUX1_GPIO233_S   18U
#define GPIO_GPHGMUX1_GPIO233_M   0xC0000U      // Defines pin-muxing selection for GPIO233
#define GPIO_GPHGMUX1_GPIO237_S   26U
#define GPIO_GPHGMUX1_GPIO237_M   0xC000000U    // Defines pin-muxing selection for GPIO237
#define GPIO_GPHGMUX1_GPIO238_S   28U
#define GPIO_GPHGMUX1_GPIO238_M   0x30000000U   // Defines pin-muxing selection for GPIO238
#define GPIO_GPHGMUX1_GPIO239_S   30U
#define GPIO_GPHGMUX1_GPIO239_M   0xC0000000U   // Defines pin-muxing selection for GPIO239

//*************************************************************************************************
//
// The following are defines for the bit fields in the GPHGMUX2 register
//
//*************************************************************************************************
#define GPIO_GPHGMUX2_GPIO240_S   0U
#define GPIO_GPHGMUX2_GPIO240_M   0x3U         // Defines pin-muxing selection for GPIO240
#define GPIO_GPHGMUX2_GPIO241_S   2U
#define GPIO_GPHGMUX2_GPIO241_M   0xCU         // Defines pin-muxing selection for GPIO241
#define GPIO_GPHGMUX2_GPIO242_S   4U
#define GPIO_GPHGMUX2_GPIO242_M   0x30U        // Defines pin-muxing selection for GPIO242
#define GPIO_GPHGMUX2_GPIO244_S   8U
#define GPIO_GPHGMUX2_GPIO244_M   0x300U       // Defines pin-muxing selection for GPIO244
#define GPIO_GPHGMUX2_GPIO245_S   10U
#define GPIO_GPHGMUX2_GPIO245_M   0xC00U       // Defines pin-muxing selection for GPIO245
#define GPIO_GPHGMUX2_GPIO252_S   24U
#define GPIO_GPHGMUX2_GPIO252_M   0x3000000U   // Defines pin-muxing selection for GPIO252

#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_SYSCTL_APB_H_ */


