/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    pinmap.h
*   @brief   
*
*/

#ifndef PINMAP_H_
#define PINMAP_H_
#include "inc/hw_types.h"

#if IS_GS32F00xx()
#include "pinmap/pinmap_gs32f027.h"
#include "pinmap/pinmap_gs32f035.h"
#include "pinmap/pinmap_gs32f00xx.h"
#include "pinmap/pinmap_gs32f0013x.h"
#include "pinmap/pinmap_gs32f0015x.h"
#include "pinmap/pinmap_gs32fmtx000.h"
#include "pinmap/pinmap_gs32fp55a.h"
#elif IS_GS32F3xx()
#include "pinmap/pinmap_gs32f3xx.h"
#include "pinmap/pinmap_gs32p65.h"
#else
#error "unkown device name"
#endif


#ifdef __cplusplus
extern "C"{
#endif

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_H_ */
