/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    pinmap_gs32f0015x.h
 *   @brief
 *
 */

#ifndef PINMAP_GS32F0015x_H_
#define PINMAP_GS32F0015x_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

#if IS_GS32F00xx()

#if GS32_PART_NUM == 0x00157

/*****************************************************************************
 *
 * Values that can be passed to GPIO_setPinConfig() as the pinConfig parameter.
 *
 * Note: Refer to the corresponding data manual for detailed information
 * on each pin's reuse functions and configurations.
 *
 *****************************************************************************/
#define GPIO_0_GPIO0            0x000C0000U /* 157 */
#define GPIO_0_EPWM1_A          0x000C0001U /* 157 */
#define GPIO_0_CANA_RX          0x000C0002U /* 157 */
#define GPIO_0_OUTPUTXBAR7      0x000C0003U /* 157 */
#define GPIO_0_SCIA_RX          0x000C0005U /* 157 */
#define GPIO_0_I2CA_SDA         0x000C0006U /* 157 */
#define GPIO_0_SPIA_STE         0x000C0007U /* 157 */
#define GPIO_0_CANB_RX          0x000C000AU /* 157 */
#define GPIO_0_CLB_OUTPUTXBAR8  0x000C000BU /* 157 */
#define GPIO_0_EQEP1_INDEX      0x000C000DU /* 157 */
#define GPIO_0_EPWM3_A          0x000C000FU /* 157 */

#define GPIO_1_GPIO1            0x000C0200U /* 157 */
#define GPIO_1_EPWM1_B          0x000C0201U /* 157 */
#define GPIO_1_SCIA_TX          0x000C0205U /* 157 */
#define GPIO_1_I2CA_SCL         0x000C0206U /* 157 */
#define GPIO_1_SPIA_SOMI        0x000C0207U /* 157 */
#define GPIO_1_EQEP1_STROBE     0x000C0209U /* 157 */
#define GPIO_1_CANB_TX          0x000C020AU /* 157 */
#define GPIO_1_CLB_OUTPUTXBAR7  0x000C020BU /* 157 */
#define GPIO_1_EPWM3_B          0x000C020FU /* 157 */

#define GPIO_2_GPIO2            0x000C0400U /* 157 */
#define GPIO_2_EPWM2_A          0x000C0401U /* 157 */
#define GPIO_2_OUTPUTXBAR1      0x000C0405U /* 157 */
#define GPIO_2_PMBUSA_SDA       0x000C0406U /* 157 */
#define GPIO_2_SPIA_SIMO        0x000C0407U /* 157 */
#define GPIO_2_SCIA_TX          0x000C0409U /* 157 */
#define GPIO_2_I2CB_SDA         0x000C040BU /* 157 */
#define GPIO_2_CANA_TX          0x000C040EU /* 157 */
#define GPIO_2_EPWM4_A          0x000C040FU /* 157 */

#define GPIO_3_GPIO3            0x000C0600U /* 157 */
#define GPIO_3_EPWM2_B          0x000C0601U /* 157 */
#define GPIO_3_OUTPUTXBAR2      0x000C0602U /* 157 */
#define GPIO_3_PMBUSA_SCL       0x000C0606U /* 157 */
#define GPIO_3_SPIA_CLK         0x000C0607U /* 157 */
#define GPIO_3_SCIA_RX          0x000C0609U /* 157 */
#define GPIO_3_I2CB_SCL         0x000C060BU /* 157 */
#define GPIO_3_CANA_RX          0x000C060EU /* 157 */
#define GPIO_3_EPWM4_B          0x000C060FU /* 157 */

#define GPIO_4_GPIO4            0x000C0800U /* 157 */
#define GPIO_4_EPWM3_A          0x000C0801U /* 157 */
#define GPIO_4_I2CA_SCL         0x000C0802U /* 157 */
#define GPIO_4_CANB_TX          0x000C0803U /* 157 */
#define GPIO_4_OUTPUTXBAR3      0x000C0805U /* 157 */
#define GPIO_4_CANA_TX          0x000C0806U /* 157 */
#define GPIO_4_SPIB_CLK         0x000C0807U /* 157 */
#define GPIO_4_EQEP2_STROBE     0x000C0809U /* 157 */
#define GPIO_4_CLB_OUTPUTXBAR6  0x000C080BU /* 157 */
#define GPIO_4_SPIA_SOMI        0x000C080EU /* 157 */
#define GPIO_4_EPWM1_A          0x000C080FU /* 157 */

#define GPIO_5_GPIO5            0x000C0A00U /* 157 */
#define GPIO_5_EPWM3_B          0x000C0A01U /* 157 */
#define GPIO_5_I2CA_SDA         0x000C0A02U /* 157 */
#define GPIO_5_OUTPUTXBAR3      0x000C0A03U /* 157 */
#define GPIO_5_CANB_RX          0x000C0A05U /* 157 */
#define GPIO_5_CANA_RX          0x000C0A06U /* 157 */
#define GPIO_5_SPIA_STE         0x000C0A07U /* 157 */
#define GPIO_5_CLB_OUTPUTXBAR5  0x000C0A0AU /* 157 */
#define GPIO_5_SCIA_RX          0x000C0A0BU /* 157 */
#define GPIO_5_EPWM1_B          0x000C0A0FU /* 157 */

#define GPIO_6_GPIO6            0x000C0C00U /* 157 */
#define GPIO_6_EPWM4_A          0x000C0C01U /* 157 */
#define GPIO_6_OUTPUTXBAR4      0x000C0C02U /* 157 */
#define GPIO_6_SYNCOUT          0x000C0C03U /* 157 */
#define GPIO_6_EQEP1_A          0x000C0C05U /* 157 */
#define GPIO_6_CANB_TX          0x000C0C06U /* 157 */
#define GPIO_6_SPIB_SOMI        0x000C0C07U /* 157 */
#define GPIO_6_CLB_OUTPUTXBAR8  0x000C0C0EU /* 157 */
#define GPIO_6_EPWM2_A          0x000C0C0FU /* 157 */

#define GPIO_7_GPIO7            0x000C0E00U /* 157 */
#define GPIO_7_EPWM4_B          0x000C0E01U /* 157 */
#define GPIO_7_EPWM2_A          0x000C0E02U /* 157 */
#define GPIO_7_OUTPUTXBAR5      0x000C0E03U /* 157 */
#define GPIO_7_EQEP1_B          0x000C0E05U /* 157 */
#define GPIO_7_CANB_RX          0x000C0E06U /* 157 */
#define GPIO_7_SPIA_SIMO        0x000C0E07U /* 157 */
#define GPIO_7_CLB_OUTPUTXBAR2  0x000C0E0AU /* 157 */
#define GPIO_7_SCIA_TX          0x000C0E0BU /* 157 */
#define GPIO_7_CANA_TX          0x000C0E0EU /* 157 */
#define GPIO_7_EPWM2_B          0x000C0E0FU /* 157 */

#define GPIO_8_GPIO8            0x000C1000U /* 157 */
#define GPIO_8_EPWM5_A          0x000C1001U /* 157 */
#define GPIO_8_CANB_TX          0x000C1002U /* 157 */
#define GPIO_8_ADCSOCAO         0x000C1003U /* 157 */
#define GPIO_8_EQEP1_STROBE     0x000C1005U /* 157 */
#define GPIO_8_SCIA_TX          0x000C1006U /* 157 */
#define GPIO_8_SPIA_SIMO        0x000C1007U /* 157 */
#define GPIO_8_I2CA_SCL         0x000C1009U /* 157 */
#define GPIO_8_CLB_OUTPUTXBAR5  0x000C100BU /* 157 */

#define GPIO_9_GPIO9            0x000C1200U /* 157 */
#define GPIO_9_EPWM5_B          0x000C1201U /* 157 */
#define GPIO_9_SCIB_TX          0x000C1202U /* 157 */
#define GPIO_9_OUTPUTXBAR6      0x000C1203U /* 157 */
#define GPIO_9_EQEP1_INDEX      0x000C1205U /* 157 */
#define GPIO_9_SCIA_RX          0x000C1206U /* 157 */
#define GPIO_9_SPIA_CLK         0x000C1207U /* 157 */
#define GPIO_9_I2CB_SCL         0x000C120EU /* 157 */

#define GPIO_10_GPIO10          0x000C1400U /* 157 */
#define GPIO_10_EPWM6_A         0x000C1401U /* 157 */
#define GPIO_10_ADCSOCBO        0x000C1403U /* 157 */
#define GPIO_10_EQEP1_A         0x000C1405U /* 157 */
#define GPIO_10_SCIB_TX         0x000C1406U /* 157 */
#define GPIO_10_SPIA_SOMI       0x000C1407U /* 157 */
#define GPIO_10_I2CA_SDA        0x000C1409U /* 157 */

#define GPIO_11_GPIO11          0x000C1600U /* 157 */
#define GPIO_11_EPWM6_B         0x000C1601U /* 157 */
#define GPIO_11_CANA_RX         0x000C1602U /* 157 */
#define GPIO_11_OUTPUTXBAR7     0x000C1603U /* 157 */
#define GPIO_11_EQEP1_B         0x000C1605U /* 157 */
#define GPIO_11_SCIB_RX         0x000C1606U /* 157 */
#define GPIO_11_SPIA_STE        0x000C1607U /* 157 */
#define GPIO_11_EQEP2_A         0x000C160BU /* 157 */
#define GPIO_11_SPIA_SIMO       0x000C160DU /* 157 */

#define GPIO_12_GPIO12          0x000C1800U /* 157 */
#define GPIO_12_EPWM7_A         0x000C1801U /* 157 */
#define GPIO_12_CANB_RX         0x000C1803U /* 157 */
#define GPIO_12_EQEP1_STROBE    0x000C1805U /* 157 */
#define GPIO_12_SCIB_TX         0x000C1806U /* 157 */
#define GPIO_12_PMBUSA_CTL      0x000C1807U /* 157 */
#define GPIO_12_SPIA_CLK        0x000C180BU /* 157 */
#define GPIO_12_CANA_RX         0x000C180DU /* 157 */

#define GPIO_13_GPIO13          0x000C1A00U /* 157 */
#define GPIO_13_EPWM7_B         0x000C1A01U /* 157 */
#define GPIO_13_CANB_TX         0x000C1A03U /* 157 */
#define GPIO_13_EQEP1_INDEX     0x000C1A05U /* 157 */
#define GPIO_13_SCIB_RX         0x000C1A06U /* 157 */
#define GPIO_13_PMBUS_ALERT     0x000C1A07U /* 157 */
#define GPIO_13_SPIA_SOMI       0x000C1A0BU /* 157 */
#define GPIO_13_CANA_TX         0x000C1A0DU /* 157 */

#define GPIO_14_GPIO14          0x000C1C00U /* 157 */
#define GPIO_14_EPWM8_A         0x000C1C01U /* 157 */
#define GPIO_14_SCIB_TX         0x000C1C02U /* 157 */
#define GPIO_14_I2CB_SDA        0x000C1C05U /* 157 */
#define GPIO_14_OUTPUTXBAR3     0x000C1C06U /* 157 */
#define GPIO_14_PMBUSA_SDA      0x000C1C07U /* 157 */
#define GPIO_14_SPIB_CLK        0x000C1C09U /* 157 */
#define GPIO_14_EQEP2_A         0x000C1C0AU /* 157 */
#define GPIO_14_EPWM3_A         0x000C1C0DU /* 157 */
#define GPIO_14_CLB_OUTPUTXBAR7 0x000C1C0EU /* 157 */

#define GPIO_15_GPIO15          0x000C1E00U /* 157 */
#define GPIO_15_EPWM8_B         0x000C1E01U /* 157 */
#define GPIO_15_SCIB_RX         0x000C1E02U /* 157 */
#define GPIO_15_I2CB_SCL        0x000C1E05U /* 157 */
#define GPIO_15_OUTPUTXBAR4     0x000C1E06U /* 157 */
#define GPIO_15_PMBUSA_SCL      0x000C1E07U /* 157 */
#define GPIO_15_SPIB_STE        0x000C1E09U /* 157 */
#define GPIO_15_EQEP2_B         0x000C1E0AU /* 157 */
#define GPIO_15_EPWM3_B         0x000C1E0DU /* 157 */
#define GPIO_15_CLB_OUTPUTXBAR6 0x000C1E0EU /* 157 */

#define GPIO_16_GPIO16          0x00100000U /* 157 */
#define GPIO_16_SPIA_SIMO       0x00100001U /* 157 */
#define GPIO_16_OUTPUTXBAR7     0x00100003U /* 157 */
#define GPIO_16_EPWM5_A         0x00100005U /* 157 */
#define GPIO_16_SCIA_TX         0x00100006U /* 157 */
#define GPIO_16_SD1_D1          0x00100007U /* 157 */
#define GPIO_16_EQEP1_STROBE    0x00100009U /* 157 */
#define GPIO_16_PMBUSA_SCL      0x0010000AU /* 157 */
#define GPIO_16_XCLKOUT         0x0010000BU /* 157 */
#define GPIO_16_EQEP2_B         0x0010000DU /* 157 */
#define GPIO_16_SPIB_SOMI       0x0010000EU /* 157 */

#define GPIO_17_GPIO17          0x00100200U /* 157 */
#define GPIO_17_SPIA_SOMI       0x00100201U /* 157 */
#define GPIO_17_CANB_RX         0x00100202U /* 157 */
#define GPIO_17_OUTPUTXBAR8     0x00100203U /* 157 */
#define GPIO_17_EPWM5_B         0x00100205U /* 157 */
#define GPIO_17_SCIA_RX         0x00100206U /* 157 */
#define GPIO_17_SD1_C1          0x00100207U /* 157 */
#define GPIO_17_EQEP1_INDEX     0x00100209U /* 157 */
#define GPIO_17_PMBUSA_SDA      0x0010020AU /* 157 */
#define GPIO_17_CANA_TX         0x0010020BU /* 157 */
#define GPIO_17_EPWM6_A         0x0010020EU /* 157 */

#define GPIO_18_GPIO18          0x00100400U /* 157 */
#define GPIO_18_SPIA_CLK        0x00100401U /* 157 */
#define GPIO_18_SCIB_TX         0x00100402U /* 157 */
#define GPIO_18_CANA_RX         0x00100403U /* 157 */
#define GPIO_18_EPWM6_A         0x00100405U /* 157 */
#define GPIO_18_I2CA_SCL        0x00100406U /* 157 */
#define GPIO_18_SD1_D2          0x00100407U /* 157 */
#define GPIO_18_EQEP2_A         0x00100409U /* 157 */
#define GPIO_18_PMBUSA_CTL      0x0010040AU /* 157 */
#define GPIO_18_XCLKOUT         0x0010040BU /* 157 */

#define GPIO_19_GPIO19          0x00100600U /* 157 */
#define GPIO_19_SPIA_STE        0x00100601U /* 157 */
#define GPIO_19_SCIB_RX         0x00100602U /* 157 */
#define GPIO_19_CANA_TX         0x00100603U /* 157 */
#define GPIO_19_EPWM6_B         0x00100605U /* 157 */
#define GPIO_19_I2CA_SDA        0x00100606U /* 157 */
#define GPIO_19_SD1_C2          0x00100607U /* 157 */
#define GPIO_19_EQEP2_B         0x00100609U /* 157 */
#define GPIO_19_PMBUSA_ALERT    0x0010060AU /* 157 */
#define GPIO_19_CLB_OUTPUTXBAR1 0x0010060DU /* 157 */

#define GPIO_20_GPIO20          0x00100800U /* 157 */
#define GPIO_20_EQEP1_A         0x00100801U /* 157 */
#define GPIO_20_CANA_TX         0x00100803U /* 157 */
#define GPIO_20_SPIA_SIMO       0x00100806U /* 157 */
#define GPIO_20_SD1_D3          0x00100807U /* 157 */
#define GPIO_20_CANB_TX         0x00100809U /* 157 */
#define GPIO_20_I2CA_SCL        0x0010080BU /* 157 */
#define GPIO_20_SCIC_TX         0x0010080FU /* 157 */

#define GPIO_21_GPIO21          0x00100A00U /* 157 */
#define GPIO_21_EQEP1_B         0x00100A01U /* 157 */
#define GPIO_21_CANA_RX         0x00100A03U /* 157 */
#define GPIO_21_SPIA_SOMI       0x00100A06U /* 157 */
#define GPIO_21_SD1_C3          0x00100A07U /* 157 */
#define GPIO_21_CANB_RX         0x00100A09U /* 157 */
#define GPIO_21_I2CA_SDA        0x00100A0BU /* 157 */
#define GPIO_21_SCIC_RX         0x00100A0FU /* 157 */

#define GPIO_22_GPIO22          0x00100C00U /* 157 */
#define GPIO_22_EQEP1_STROBE    0x00100C01U /* 157 */
#define GPIO_22_SCIB_TX         0x00100C03U /* 157 */
#define GPIO_22_SPIB_CLK        0x00100C06U /* 157 */
#define GPIO_22_SD1_D4          0x00100C07U /* 157 */
#define GPIO_22_LINA_TX         0x00100C09U /* 157 */
#define GPIO_22_CLB_OUTPUTXBAR1 0x00100C0AU /* 157 */
#define GPIO_22_EPWM4_A         0x00100C0EU /* 157 */

#define GPIO_23_GPIO23          0x00100E00U /* 157 */
#define GPIO_23_EQEP1_INDEX     0x00100E01U /* 157 */
#define GPIO_23_SCIB_RX         0x00100E03U /* 157 */
#define GPIO_23_SPIB_STE        0x00100E06U /* 157 */
#define GPIO_23_SD1_C4          0x00100E07U /* 157 */
#define GPIO_23_LINA_RX         0x00100E09U /* 157 */
#define GPIO_23_CLB_OUTPUTXBAR3 0x00100E0AU /* 157 */
#define GPIO_23_EPWM4_B         0x00100E0EU /* 157 */

#define GPIO_24_GPIO24          0x00101000U /* 157 */
#define GPIO_24_OUTPUTXBAR1     0x00101001U /* 157 */
#define GPIO_24_EQEP2_A         0x00101002U /* 157 */
#define GPIO_24_SPIA_STE        0x00101003U /* 157 */
#define GPIO_24_EPWM4_A         0x00101005U /* 157 */
#define GPIO_24_SPIA_SIMO       0x00101006U /* 157 */
#define GPIO_24_PMBUSA_SCL      0x0010100AU /* 157 */
#define GPIO_24_SCIA_TX         0x0010100BU /* 157 */
#define GPIO_24_ERRORSTS        0x0010100DU /* 157 */

#define GPIO_25_GPIO25          0x00101200U /* 157 */
#define GPIO_25_OUTPUTXBAR2     0x00101201U /* 157 */
#define GPIO_25_EQEP2_B         0x00101202U /* 157 */
#define GPIO_25_EQEP1_A         0x00101205U /* 157 */
#define GPIO_25_SPIB_SOMI       0x00101206U /* 157 */
#define GPIO_25_PMBUSA_SDA      0x0010120AU /* 157 */
#define GPIO_25_SCIA_RX         0x0010120BU /* 157 */

#define GPIO_26_GPIO26          0x00101400U /* 157 */
#define GPIO_26_OUTPUTXBAR3     0x00101401U /* 157 */
#define GPIO_26_EQEP2_INDEX     0x00101402U /* 157 */
#define GPIO_26_SPIB_CLK        0x00101406U /* 157 */
#define GPIO_26_PMBUSA_CTL      0x0010140AU /* 157 */
#define GPIO_26_I2CA_SDA        0x0010140BU /* 157 */

#define GPIO_27_GPIO27          0x00101600U /* 157 */
#define GPIO_27_OUTPUTXBAR4     0x00101601U /* 157 */
#define GPIO_27_EQEP2_STROBE    0x00101602U /* 157 */
#define GPIO_27_SPIB_STE        0x00101606U /* 157 */
#define GPIO_27_PMBUSA_ALERT    0x0010160AU /* 157 */
#define GPIO_27_I2CA_SCL        0x0010160BU /* 157 */

#define GPIO_28_GPIO28          0x00101800U /* 157 */
#define GPIO_28_SCIA_RX         0x00101801U /* 157 */
#define GPIO_28_EPWM7_A         0x00101803U /* 157 */
#define GPIO_28_OUTPUTXBAR5     0x00101805U /* 157 */
#define GPIO_28_EQEP1_A         0x00101806U /* 157 */
#define GPIO_28_EQEP2_STROBE    0x00101809U /* 157 */
#define GPIO_28_LINA_TX         0x0010180AU /* 157 */
#define GPIO_28_SPIA_CLK        0x0010180BU /* 157 */
#define GPIO_28_ERRORSTS        0x0010180DU /* 157 */
#define GPIO_28_I2CB_SDA        0x0010180EU /* 157 */

#define GPIO_29_GPIO29          0x00101A00U /* 157 */
#define GPIO_29_SCIA_TX         0x00101A01U /* 157 */
#define GPIO_29_EPWM7_B         0x00101A03U /* 157 */
#define GPIO_29_OUTPUTXBAR6     0x00101A05U /* 157 */
#define GPIO_29_EQEP1_B         0x00101A06U /* 157 */
#define GPIO_29_EQEP2_INDEX     0x00101A09U /* 157 */
#define GPIO_29_LINA_RX         0x00101A0AU /* 157 */
#define GPIO_29_SPIA_STE        0x00101A0BU /* 157 */
#define GPIO_29_ERRORSTS        0x00101A0DU /* 157 */
#define GPIO_29_I2CB_SCL        0x00101A0EU /* 157 */

#define GPIO_30_GPIO30          0x00101C00U /* 157 */
#define GPIO_30_CANA_RX         0x00101C01U /* 157 */
#define GPIO_30_SPIB_SIMO       0x00101C03U /* 157 */
#define GPIO_30_OUTPUTXBAR7     0x00101C05U /* 157 */
#define GPIO_30_EQEP1_STROBE    0x00101C06U /* 157 */
#define GPIO_30_CANB_RX         0x00101C0AU /* 157 */
#define GPIO_30_EPWM1_A         0x00101C0BU /* 157 */

#define GPIO_31_GPIO31          0x00101E00U /* 157 */
#define GPIO_31_CANA_TX         0x00101E01U /* 157 */
#define GPIO_31_SPIB_SOMI       0x00101E03U /* 157 */
#define GPIO_31_OUTPUTXBAR8     0x00101E05U /* 157 */
#define GPIO_31_EQEP1_INDEX     0x00101E06U /* 157 */
#define GPIO_31_CANB_TX         0x00101E0AU /* 157 */
#define GPIO_31_EPWM1_B         0x00101E0BU /* 157 */

#define GPIO_32_GPIO32          0x008C0000U /* 157 */
#define GPIO_32_I2CA_SDA        0x008C0001U /* 157 */
#define GPIO_32_EQEP1_INDEX     0x008C0002U /* 157 */
#define GPIO_32_SPIA_CLK        0x008C0003U /* 157 */
#define GPIO_32_EPWM4_B         0x008C0005U /* 157 */
#define GPIO_32_LINA_TX         0x008C0006U /* 157 */
#define GPIO_32_SD1_D2          0x008C0007U /* 157 */
#define GPIO_32_CANA_TX         0x008C000AU /* 157 */
#define GPIO_32_PMBUSA_SDA      0x008C000BU /* 157 */
#define GPIO_32_ADCSOCBO        0x008C000DU /* 157 */

#define GPIO_33_GPIO33          0x008C0200U /* 157 */
#define GPIO_33_I2CA_SCL        0x008C0201U /* 157 */
#define GPIO_33_SPIB_STE        0x008C0203U /* 157 */
#define GPIO_33_OUTPUTXBAR4     0x008C0205U /* 157 */
#define GPIO_33_LINA_RX         0x008C0206U /* 157 */
#define GPIO_33_SD1_C2          0x008C0207U /* 157 */
#define GPIO_33_CANA_RX         0x008C020AU /* 157 */
#define GPIO_33_EQEP2_B         0x008C020BU /* 157 */
#define GPIO_33_ADCSOCAO        0x008C020DU /* 157 */
#define GPIO_33_SD1_C1          0x008C020EU /* 157 */

#define GPIO_34_GPIO34          0x008C0400U /* 157 */
#define GPIO_34_OUTPUTXBAR1     0x008C0401U /* 157 */
#define GPIO_34_PMBUSA_SDA      0x008C0406U /* 157 */
#define GPIO_34_I2CB_SDA        0x008C040EU /* 157 */

#define GPIO_35_GPIO35          0x008C0600U /* 157 */
#define GPIO_35_SCIA_RX         0x008C0601U /* 157 */
#define GPIO_35_SPIA_SOMI       0x008C0602U /* 157 */
#define GPIO_35_I2CA_SDA        0x008C0603U /* 157 */
#define GPIO_35_CANA_RX         0x008C0605U /* 157 */
#define GPIO_35_PMBUSA_SCL      0x008C0606U /* 157 */
#define GPIO_35_LINA_RX         0x008C0607U /* 157 */
#define GPIO_35_EQEP1_A         0x008C0609U /* 157 */
#define GPIO_35_PMBUSA_CTL      0x008C060AU /* 157 */
#define GPIO_35_EPWM5_B         0x008C060BU /* 157 */
#define GPIO_35_TDI             0x008C060FU /* 157 */

#define GPIO_37_GPIO37          0x008C0A00U /* 157 */
#define GPIO_37_OUTPUTXBAR2     0x008C0A01U /* 157 */
#define GPIO_37_SPIA_STE        0x008C0A02U /* 157 */
#define GPIO_37_I2CA_SCL        0x008C0A03U /* 157 */
#define GPIO_37_SCIA_TX         0x008C0A05U /* 157 */
#define GPIO_37_CANA_TX         0x008C0A06U /* 157 */
#define GPIO_37_LINA_TX         0x008C0A07U /* 157 */
#define GPIO_37_EQEP1_B         0x008C0A09U /* 157 */
#define GPIO_37_PMBUSA_ALERT    0x008C0A0AU /* 157 */
#define GPIO_37_EPWM5_A         0x008C0A0BU /* 157 */
#define GPIO_37_TDO             0x008C0A0FU /* 157 */

#define GPIO_39_GPIO39          0x008C0E00U /* 157 */
#define GPIO_39_CANB_RX         0x008C0E06U /* 157 */
#define GPIO_39_EQEP2_INDEX     0x008C0E09U /* 157 */
#define GPIO_39_CLB_OUTPUTXBAR2 0x008C0E0BU /* 157 */
#define GPIO_39_SYNCOUT         0x008C0E0DU /* 157 */
#define GPIO_39_EQEP1_INDEX     0x008C0E0EU /* 157 */

#define GPIO_40_GPIO40          0x008C1000U /* 157 */
#define GPIO_40_SPIB_SIMO       0x008C1001U /* 157 */
#define GPIO_40_EPWM2_B         0x008C1005U /* 157 */
#define GPIO_40_PMBUSA_SDA      0x008C1006U /* 157 */
#define GPIO_40_SCIB_TX         0x008C1009U /* 157 */
#define GPIO_40_EQEP1_A         0x008C100AU /* 157 */

#define GPIO_41_GPIO41          0x008C1200U /* 157 */
#define GPIO_41_EPWM7_A         0x008C1201U /* 157 */
#define GPIO_41_EPWM2_A         0x008C1205U /* 157 */
#define GPIO_41_PMBUSA_SCL      0x008C1206U /* 157 */
#define GPIO_41_SCIB_RX         0x008C1209U /* 157 */
#define GPIO_41_EQEP1_B         0x008C120AU /* 157 */
#define GPIO_41_SPIB_SOMI       0x008C120EU /* 157 */

#define GPIO_42_GPIO42          0x008C1400U /* 157 */
#define GPIO_42_LINA_RX         0x008C1402U /* 157 */
#define GPIO_42_OUTPUTXBAR5     0x008C1403U /* 157 */
#define GPIO_42_PMBUSA_CTL      0x008C1405U /* 157 */
#define GPIO_42_I2CA_SDA        0x008C1406U /* 157 */
#define GPIO_42_SCIC_RX         0x008C1407U /* 157 */
#define GPIO_42_EQEP1_STROBE    0x008C140AU /* 157 */
#define GPIO_42_CLB_OUTPUTXBAR3 0x008C140BU /* 157 */

#define GPIO_43_GPIO43          0x008C1600U /* 157 */
#define GPIO_43_OUTPUTXBAR6     0x008C1603U /* 157 */
#define GPIO_43_PMBUSA_ALERT    0x008C1605U /* 157 */
#define GPIO_43_I2CA_SCL        0x008C1606U /* 157 */
#define GPIO_43_SCIC_TX         0x008C1607U /* 157 */
#define GPIO_43_EQEP1_INDEX     0x008C160AU /* 157 */
#define GPIO_43_CLB_OUTPUTXBAR4 0x008C160BU /* 157 */

#define GPIO_44_GPIO44          0x008C1800U /* 157 */
#define GPIO_44_OUTPUTXBAR7     0x008C1803U /* 157 */
#define GPIO_44_EQEP1_A         0x008C1805U /* 157 */
#define GPIO_44_PMBUSA_SDA      0x008C1806U /* 157 */
#define GPIO_44_PMBUSA_CTL      0x008C1809U /* 157 */
#define GPIO_44_CLB_OUTPUTXBAR3 0x008C180AU /* 157 */

#define GPIO_45_GPIO45          0x008C1A00U /* 157 */
#define GPIO_45_OUTPUTXBAR8     0x008C1A03U /* 157 */
#define GPIO_45_PMBUSA_ALERT    0x008C1A09U /* 157 */
#define GPIO_45_CLB_OUTPUTXBAR4 0x008C1A0AU /* 157 */

#define GPIO_46_GPIO46          0x008C1C00U /* 157 */
#define GPIO_46_LINA_TX         0x008C1C03U /* 157 */
#define GPIO_46_CANB_TX         0x008C1C05U /* 157 */
#define GPIO_46_PMBUSA_SDA      0x008C1C09U /* 157 */

#define GPIO_48_GPIO48          0x00900000U /* 157 */
#define GPIO_48_OUTPUTXBAR3     0x00900001U /* 157 */
#define GPIO_48_CANA_TX         0x00900003U /* 157 */
#define GPIO_48_CANB_TX         0x00900005U /* 157 */
#define GPIO_48_SCIA_TX         0x00900006U /* 157 */
#define GPIO_48_SD1_D1          0x00900007U /* 157 */
#define GPIO_48_PMBUSA_SDA      0x00900009U /* 157 */

#define GPIO_49_GPIO49          0x00900200U /* 157 */
#define GPIO_49_OUTPUTXBAR4     0x00900201U /* 157 */
#define GPIO_49_CANA_RX         0x00900203U /* 157 */
#define GPIO_49_CANB_RX         0x00900205U /* 157 */
#define GPIO_49_SCIA_RX         0x00900206U /* 157 */
#define GPIO_49_SD1_C1          0x00900207U /* 157 */
#define GPIO_49_LINA_RX         0x00900209U /* 157 */

#define GPIO_224_GPIO224        0x038C0000U /* 157 */
#define GPIO_224_OUTPUTXBAR3    0x038C0005U /* 157 */
#define GPIO_224_SPIA_SIMO      0x038C0006U /* 157 */
#define GPIO_224_EPWM1_A        0x038C0007U /* 157 */
#define GPIO_224_CANA_TX        0x038C000AU /* 157 */
#define GPIO_224_EQEP1_A        0x038C000BU /* 157 */
#define GPIO_224_SCIC_TX        0x038C000EU /* 157 */

#define GPIO_225_GPIO225        0x038C0200U /* 157 */

#define GPIO_226_GPIO226        0x038C0400U /* 157 */
#define GPIO_226_LINA_RX        0x038C0403U /* 157 */
#define GPIO_226_EPWM6_A        0x038C0405U /* 157 */
#define GPIO_226_SPIA_CLK       0x038C0406U /* 157 */
#define GPIO_226_EPWM1_B        0x038C0409U /* 157 */
#define GPIO_226_EQEP1_STROBE   0x038C040BU /* 157 */
#define GPIO_226_SCIC_RX        0x038C040EU /* 157 */

#define GPIO_227_GPIO227        0x038C0600U /* 157 */
#define GPIO_227_I2CB_SCL       0x038C0601U /* 157 */
#define GPIO_227_SD1_C3         0x038C0602U /* 157 */
#define GPIO_227_EPWM3_A        0x038C0603U /* 157 */
#define GPIO_227_OUTPUTXBAR1    0x038C0605U /* 157 */
#define GPIO_227_EPWM2_B        0x038C0606U /* 157 */

#define GPIO_228_GPIO228        0x038C0800U /* 157 */
#define GPIO_228_ADCSOCAO       0x038C0803U /* 157 */
#define GPIO_228_CANA_TX        0x038C0805U /* 157 */
#define GPIO_228_SPIA_SOMI      0x038C0806U /* 157 */
#define GPIO_228_EPWM2_B        0x038C0809U /* 157 */
#define GPIO_228_EQEP1_B        0x038C080BU /* 157 */

#define GPIO_230_GPIO230        0x038C0C00U /* 157 */
#define GPIO_230_I2CB_SDA       0x038C0C01U /* 157 */
#define GPIO_230_SD1_C4         0x038C0C02U /* 157 */
#define GPIO_230_EPWM3_B        0x038C0C03U /* 157 */
#define GPIO_230_CANA_RX        0x038C0C05U /* 157 */
#define GPIO_230_EPWM2_A        0x038C0C06U /* 157 */
#define GPIO_230_I2CA_SDA       0x038C0C07U /* 157 */
#define GPIO_230_PMBUSA_SCL     0x038C0C09U /* 157 */

#define GPIO_231_GPIO231        0x038C0E00U /* 157 */
#define GPIO_231_SD1_C1         0x038C0E02U /* 157 */

#define GPIO_232_GPIO232        0x038C1000U /* 157 */
#define GPIO_232_SD1_D4         0x038C1002U /* 157 */

#define GPIO_233_GPIO233        0x038C1200U /* 157 */

#define GPIO_237_GPIO237        0x038C1A00U /* 157 */
#define GPIO_237_SD1_D2         0x038C1A02U /* 157 */

#define GPIO_238_GPIO238        0x038C1C00U /* 157 */

#define GPIO_239_GPIO239        0x038C1E00U /* 157 */
#define GPIO_239_SD1_D1         0x038C1E02U /* 157 */

#define GPIO_241_GPIO241        0x03900200U /* 157 */

#define GPIO_242_GPIO242        0x03900400U /* 157 */
#define GPIO_242_OUTPUTXBAR2    0x03900405U /* 157 */
#define GPIO_242_SPIA_STE       0x03900406U /* 157 */
#define GPIO_242_EPWM4_A        0x03900409U /* 157 */
#define GPIO_242_CANA_RX        0x0390040AU /* 157 */
#define GPIO_242_EQEP1_INDEX    0x0390040BU /* 157 */

#define GPIO_244_GPIO244        0x03900800U /* 157 */
#define GPIO_244_SD1_D3         0x03900802U /* 157 */

#define GPIO_245_GPIO245        0x03900A00U /* 157 */
#define GPIO_245_SD1_C2         0x03900A02U /* 157 */




#endif /* GS32_PART_NUM == 0x00157 */

#endif /* IS_GS32F00xx() */

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_GS32F0015x_H_ */
