/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS"AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    pinmap_gs32f035.h
 *   @brief
 *
 */

#ifndef PINMAP_GS32F035_H_
#define PINMAP_GS32F035_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

#if IS_GS32F00xx(0x30)

#if GS32_PART_NUM == 0x035 

#define GPIO_MUX_MASK       0x3
#define GPIO_MUX_DATA(x)    (x & GPIO_MUX_MASK)   

/*****************************************************************************
 *
 * Note: Refer to the corresponding data manual for detailed information
 * on each pin's reuse functions and configurations.
 *
 *****************************************************************************/
#define GPIO_0_GPIO0       0x080C0000U
#define GPIO_0_EPWM1A      0x080C0001U
#define GPIO_0_LINB_TX     0x080C0002U
#define GPIO_0_CMP1_HOUT   0x080C0003U

#define GPIO_1_GPIO1       0x080C0200U
#define GPIO_1_EPWM1B      0x080C0201U
#define GPIO_1_CMP1_LOUT   0x080C0203U

#define GPIO_2_GPIO2       0x080C0400U
#define GPIO_2_EPWM2A      0x080C0401U
#define GPIO_2_CMP2_HOUT   0x080C0403U

#define GPIO_3_GPIO3       0x080C0600U
#define GPIO_3_EPWM2B      0x080C0601U
#define GPIO_3_SPIA_SOMI   0x080C0602U
#define GPIO_3_CMP2_LOUT   0x080C0603U

#define GPIO_4_GPIO4       0x080C0800U
#define GPIO_4_EPWM3A      0x080C0801U

#define GPIO_5_GPIO5       0x080C0A00U
#define GPIO_5_EPWM3B      0x080C0A01U
#define GPIO_5_SPIA_SIMO   0x080C0A02U
#define GPIO_5_ECAP1       0x080C0A03U

#define GPIO_6_GPIO6       0x080C0C00U
#define GPIO_6_EPWM4A      0x080C0C01U
#define GPIO_6_EPWMSYNCI   0x080C0C02U
#define GPIO_6_EPWMSYNCO   0x080C0C03U

#define GPIO_7_GPIO7       0x080C0E00U
#define GPIO_7_EPWM4B      0x080C0E01U
#define GPIO_7_SCIA_RX     0x080C0E02U

#define GPIO_8_GPIO8       0x080C1000U
#define GPIO_8_EPWM5A      0x080C1001U
#define GPIO_8_CANB_TX     0x080C1002U
#define GPIO_8_ADCSOCAO    0x080C1003U

#define GPIO_9_GPIO9       0x080C1200U
#define GPIO_9_EPWM5B      0x080C1201U
#define GPIO_9_LINA_TX     0x080C1202U
#define GPIO_9_HRCAP1      0x080C1203U

#define GPIO_10_GPIO10     0x080C1400U
#define GPIO_10_EPWM6A     0x080C1401U
#define GPIO_10_CANB_RX    0x080C1402U
#define GPIO_10_ADCSOCBO   0x080C1403U

#define GPIO_11_GPIO11     0x080C1600U
#define GPIO_11_EPWM6B     0x080C1601U
#define GPIO_11_LINA_RX    0x080C1602U
#define GPIO_11_HRCAP2     0x080C1603U

#define GPIO_12_GPIO12     0x080C1800U
#define GPIO_12_TZ1        0x080C1801U
#define GPIO_12_SCIA_TX    0x080C1802U
#define GPIO_12_SPIB_SIMO  0x080C1803U

#define GPIO_13_GPIO13     0x080C1A00U
#define GPIO_13_TZ2        0x080C1A01U
#define GPIO_13_SPIB_SOMI  0x080C1A03U

#define GPIO_14_GPIO14     0x080C1C00U
#define GPIO_14_TZ3        0x080C1C01U
#define GPIO_14_LINA_TX    0x080C1C02U
#define GPIO_14_SPIB_CLK   0x080C1C03U

#define GPIO_15_GPIO15     0x080C1E00U
#define GPIO_15_TZ1        0x080C1E01U
#define GPIO_15_LINA_RX    0x080C1E02U
#define GPIO_15_SPIB_STEn  0x080C1E03U

#define GPIO_16_GPIO16     0x08100000U
#define GPIO_16_SPIA_SIMO  0x08100001U
#define GPIO_16_SCIB_TX    0x08100002U
#define GPIO_16_TZ2        0x08100003U

#define GPIO_17_GPIO17     0x08100200U
#define GPIO_17_SPIA_SOMI  0x08100201U
#define GPIO_17_SCIB_RX    0x08100202U
#define GPIO_17_TZ3        0x08100203U

#define GPIO_18_GPIO18     0x08100400U
#define GPIO_18_SPIA_CLK   0x08100401U
#define GPIO_18_LINA_TX    0x08100402U
#define GPIO_18_XCLKOUT    0x08100403U

#define GPIO_19_GPIO19     0x08100600U
#define GPIO_19_SPIA_STEn  0x08100601U
#define GPIO_19_LINA_RX    0x08100602U
#define GPIO_19_ECAP1      0x08100603U

#define GPIO_20_GPIO20     0x08100800U
#define GPIO_20_EQEP1A     0x08100801U
#define GPIO_20_SCIC_TX    0x08100802U
#define GPIO_20_CMP1_HOUT  0x08100803U

#define GPIO_21_GPIO21     0x08100A00U
#define GPIO_21_EQEP1B     0x08100A01U
#define GPIO_21_SCIC_RX    0x08100A02U
#define GPIO_21_CMP2_HOUT  0x08100A03U

#define GPIO_22_GPIO22     0x08100C00U
#define GPIO_22_EQEP1S     0x08100C01U
#define GPIO_22_CMP1_HOUT  0x08100C02U
#define GPIO_22_LINA_TX    0x08100C03U

#define GPIO_23_GPIO23     0x08100E00U
#define GPIO_23_EQEP1I     0x08100E01U
#define GPIO_23_CMP2_HOUT  0x08100E02U
#define GPIO_23_LINA_RX    0x08100E03U

#define GPIO_24_GPIO24     0x08101000U
#define GPIO_24_ECAP1      0x08101001U
#define GPIO_24_EQEP2A     0x08101002U
#define GPIO_24_SPIB_SIMO  0x08101003U

#define GPIO_25_GPIO25     0x08101200U
#define GPIO_25_EQEP2B     0x08101202U
#define GPIO_25_SPIB_SOMI  0x08101203U

#define GPIO_26_GPIO26     0x08101400U
#define GPIO_26_HRCAP1     0x08101401U
#define GPIO_26_EQEP2I     0x08101402U
#define GPIO_26_SPIB_CLK   0x08101403U

#define GPIO_27_GPIO27     0x08101600U
#define GPIO_27_HRCAP2     0x08101601U
#define GPIO_27_EQEP2S     0x08101602U
#define GPIO_27_SPIB_STEn  0x08101603U

#define GPIO_28_GPIO28     0x08101800U
#define GPIO_28_SCIA_RX    0x08101801U
#define GPIO_28_I2CA_SDA   0x08101802U
#define GPIO_28_TZ2        0x08101803U

#define GPIO_29_GPIO29     0x08101A00U
#define GPIO_29_SCIA_TX    0x08101A01U
#define GPIO_29_I2CA_SCL   0x08101A02U
#define GPIO_29_TZ3        0x08101A03U

#define GPIO_30_GPIO30     0x08101C00U
#define GPIO_30_CANA_RX    0x08101C01U
#define GPIO_30_I2CB_SDA   0x08101C03U

#define GPIO_31_GPIO31     0x08101E00U
#define GPIO_31_CANA_TX    0x08101E01U
#define GPIO_31_I2CB_SCL   0x08101E03U

#define GPIO_32_GPIO32     0x082C0000U
#define GPIO_32_I2CA_SDA   0x082C0001U
#define GPIO_32_EPWMSYNCI  0x082C0002U
#define GPIO_32_ADCSOCAO   0x082C0003U

#define GPIO_33_GPIO33     0x082C0200U
#define GPIO_33_I2CA_SCL   0x082C0201U
#define GPIO_33_EPWMSYNCO  0x082C0202U
#define GPIO_33_ADCSOCBO   0x082C0203U

#define GPIO_34_GPIO34     0x082C0400U
#define GPIO_34_CMP2_LOUT  0x082C0401U
#define GPIO_34_EQEP3A     0x082C0402U
#define GPIO_34_CMP3_LOUT  0x082C0403U

#define GPIO_35_GPIO35     0x082C0600U
#define GPIO_35_CMP2_HOUT  0x082C0601U
#define GPIO_35_EQEP3B     0x082C0602U
#define GPIO_35_CMP3_HOUT  0x082C0603U
// #define GPIO_35_TDI        

#define GPIO_36_GPIO36     0x082C0800U
#define GPIO_36_EQEP3S     0x082C0802U
// #define GPIO_36_TMS        

#define GPIO_37_GPIO37     0x082C0A00U
#define GPIO_37_EQEP3I     0x082C0A02U
// #define GPIO_37_TDO        

#define GPIO_38_GPIO38     0x082C0C00U
// #define GPIO_38_TCK        
// #define GPIO_38_XCLKIN     

#define GPIO_39_GPIO39     0x082C0E00U

#define GPIO_40_GPIO40     0x082C1000U
#define GPIO_40_EPWM7A     0x082C1001U
#define GPIO_40_PMBUSA_SCL 0x082C1002U
#define GPIO_40_CMP1_HOUT  0x082C1003U

#define GPIO_41_GPIO41     0x082C1200U
#define GPIO_41_EPWM7B     0x082C1201U
#define GPIO_41_PMBUSA_SDA 0x082C1202U
#define GPIO_41_CMP2_HOUT  0x082C1203U

#define GPIO_42_GPIO42     0x082C1400U
#define GPIO_42_EPWM8A     0x082C1401U
#define GPIO_42_PMBUSA_CTL 0x082C1402U
#define GPIO_42_CMP1_LOUT  0x082C1403U

#define GPIO_43_GPIO43     0x082C1600U
#define GPIO_43_EPWM8B     0x082C1601U
#define GPIO_43_PMBUSA_ALE 0x082C1602U
#define GPIO_43_CMP2_LOUT  0x082C1603U

#define GPIO_44_GPIO44     0x082C1800U

#define GPIO_45_GPIO45     0x082C1A00U



#endif /* GS32_PART_NUM==0x035 */

#endif /* IS_GS32F00xx(0x30) */

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_GS32F0xx_H_ */
