/* ========================================================================== */
/**
*   @file    regs_ana_cfg.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the script to generate]
*
*/
/* ========================================================================== */
/**
 *  Copyright (C) Gejian Semiconductors 2023
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 * 
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 * 
 *    Neither the name of Gejian Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/* ========================================================================== */

#ifndef REGS_ANA_CFG_H
#define REGS_ANA_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

#include "gs32_version.h"

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

// ANA_CFG Individual Register Bit Definitions:

//
// Temperature Sensor Control Register
//
struct TSNSCTL_BITS {			// bits   description
	uint16_t	TSNS_ENABLE:1;			// 0:0   Temperature Sensor Enable. This bit enables the temperature
	uint16_t	rsvd1:15;			// 15:1   Reserved
};

union TSNSCTL_REG {
	uint16_t 		 all;
	struct TSNSCTL_BITS 		 bit;
};

//
// Analog Reference Control Register
//
struct ANAREFCTL_BITS {			// bits   description
	uint16_t	ANAREFSEL:1;			// 0:0   Analog reference mode select. This bit selects whether the
	uint16_t	rsvd1:7;			// 7:1   Reserved
	uint16_t	ANAREF2P5SEL:1;			// 8:8   Analog reference 2.5V source select. In internal reference mode,
	uint16_t	rsvd2:7;			// 15:9   Reserved
};

union ANAREFCTL_REG {
	uint16_t 		 all;
	struct ANAREFCTL_BITS 		 bit;
};

//
// Voltage Monitor Control Register
//
struct VMONCTL_BITS {			// bits   description
	uint16_t	rsvd1:8;			// 7:0   Reserved
	uint16_t	BORLVMONDIS:1;			// 8:8   BORL disable on VDDIO.
	uint16_t	rsvd2:7;			// 15:9   Reserved
};

union VMONCTL_REG {
	uint16_t 		 all;
	struct VMONCTL_BITS 		 bit;
};

//
// Bits to select one of the many sources on CmpHP inputs
//
struct CMPHPMXSEL_BITS {			// bits   description
	uint32_t	CMP1_HP_SEL:3;			// 2:0   CMP-1HPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP2_HP_SEL:3;			// 5:3   CMP-2HPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP3_HP_SEL:3;			// 8:6   CMP-3HPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP4_HP_SEL:3;			// 11:9   CMP-4HPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP5_HP_SEL:3;			// 14:12   CMP-5HPMXSEL bits, Please refer to the analog group connections
	uint32_t	rsvd1:1;			// 15:15   Reserved
	uint32_t	CMP6_HP_SEL:3;			// 18:16   CMP-6HPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP7_HP_SEL:3;			// 21:19   CMP-7HPMXSEL bits, Please refer to the analog group connections
	uint32_t	rsvd2:10;			// 31:22   Reserved
};

union CMPHPMXSEL_REG {
	uint32_t 		 all;
	struct CMPHPMXSEL_BITS 		 bit;
};

//
// Bits to select one of the many sources on CmpLP inputs
//
struct CMPLPMXSEL_BITS {			// bits   description
	uint32_t	CMP1_LP_SEL:3;			// 2:0   CMP-1LPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP2_LP_SEL:3;			// 5:3   CMP-2LPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP3_LP_SEL:3;			// 8:6   CMP-3LPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP4_LP_SEL:3;			// 11:9   CMP-4LPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP5_LP_SEL:3;			// 14:12   CMP-5LPMXSEL bits, Please refer to the analog group connections
	uint32_t	rsvd1:1;			// 15:15   Reserved
	uint32_t	CMP6_LP_SEL:3;			// 18:16   CMP-6LPMXSEL bits, Please refer to the analog group connections
	uint32_t	CMP7_LP_SEL:3;			// 21:19   CMP-7LPMXSEL bits, Please refer to the analog group connections
	uint32_t	rsvd2:10;			// 31:22   Reserved
};

union CMPLPMXSEL_REG {
	uint32_t 		 all;
	struct CMPLPMXSEL_BITS 		 bit;
};

//
// Bits to select one of the many sources on CmpHN inputs
//
struct CMPHNMXSEL_BITS {			// bits   description
	uint16_t	CMP1_HN_SEL:1;			// 0:0   CMP1HNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP2_HN_SEL:1;			// 1:1   CMP2HNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP3_HN_SEL:1;			// 2:2   CMP3HNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP4_HN_SEL:1;			// 3:3   CMP4HNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP5_HN_SEL:1;			// 4:4   CMP5HNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP6_HN_SEL:1;			// 5:5   CMP6HNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP7_HN_SEL:1;			// 6:6   CMP7HNMXSEL bits, Please refer to the analog group connections
	uint16_t	rsvd1:9;			// 15:7   Reserved
};

union CMPHNMXSEL_REG {
	uint16_t 		 all;
	struct CMPHNMXSEL_BITS 		 bit;
};

//
// Bits to select one of the many sources on CmpLN inputs
//
struct CMPLNMXSEL_BITS {			// bits   description
	uint16_t	CMP1_LN_SEL:1;			// 0:0   CMP1LNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP2_LN_SEL:1;			// 1:1   CMP2LNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP3_LN_SEL:1;			// 2:2   CMP3LNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP4_LN_SEL:1;			// 3:3   CMP4LNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP5_LN_SEL:1;			// 4:4   CMP5LNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP6_LN_SEL:1;			// 5:5   CMP6LNMXSEL bits, Please refer to the analog group connections
	uint16_t	CMP7_LN_SEL:1;			// 6:6   CMP7LNMXSEL bits, Please refer to the analog group connections
	uint16_t	rsvd1:9;			// 15:7   Reserved
};

union CMPLNMXSEL_REG {
	uint16_t 		 all;
	struct CMPLNMXSEL_BITS 		 bit;
};

//
// Enable loopback from DAC to ADCs
//
struct ADCDACLOOPBACK_BITS {			// bits   description
	uint32_t	ADCDACLOOPBACK_ENLB2ADCA:1;			// 0:0   1 Loops back COMPDACA output to ADCA.
	uint32_t	ADCDACLOOPBACK_ENLB2ADCB:1;			// 1:1   1 Loops back COMPDACA output to ADCB.
	uint32_t	ADCDACLOOPBACK_ENLB2ADCC:1;			// 2:2   1 Loops back COMPDACA output to ADCC.
	uint32_t	rsvd1:29;			// 31:3   Reserved
};

union ADCDACLOOPBACK_REG {
	uint32_t 		 all;
	struct ADCDACLOOPBACK_BITS 		 bit;
};

//
// AGPIO control register
//
struct AGPIOCTRLA_BITS {			// bits   description
	uint32_t	rsvd1:20;			// 19:0   Reserved
	uint32_t	GPIO20:1;			// 20:20   One time configuration for GPIO20 to decide whether AGPIO PAD or
	uint32_t	GPIO21:1;			// 21:21   One time configuration for GPIO21 to decide whether AGPIO PAD or
	uint32_t	rsvd2:10;			// 31:22   Reserved
};

union AGPIOCTRLA_REG {
	uint32_t 		 all;
	struct AGPIOCTRLA_BITS 		 bit;
};

//
// BOR Configuration
//
struct ANA_BOR_CFG_BITS {			// bits   description
	uint32_t	rsvd1:1;			// 0:0   Reserved
	uint32_t	BOR_FALLING_SEL:3;			// 3:1   
	uint32_t	BOR_RISING_SEL:3;			// 6:4   
	uint32_t	BOR_TRIM:4;			// 10:7   
	uint32_t	BOR_TEST_EN:1;			// 11:11   
	uint32_t	rsvd2:20;			// 31:12   Reserved
};

union ANA_BOR_CFG_REG {
	uint32_t 		 all;
	struct ANA_BOR_CFG_BITS 		 bit;
};

//
// 1V1LDO Configuration
//
struct ANA_LDO_1V1_CFG_BITS {			// bits   description
	uint32_t	LDO_1V1_VSEL:5;			// 4:0   
	uint32_t	LDO_1V1_TEST_MODE:2;			// 6:5   
	uint32_t	LDO_1V1_CHOP_EN:1;			// 7:7   
	uint32_t	LDO_1V1_TEST_MUX_SEL:3;			// 10:8   
	uint32_t	LDO_1V1_TEST_EN:1;			// 11:11   
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union ANA_LDO_1V1_CFG_REG {
	uint32_t 		 all;
	struct ANA_LDO_1V1_CFG_BITS 		 bit;
};

//
// EFLASH_BOR Configuration
//
struct ANA_EFLASH_BOR_CFG_BITS {			// bits   description
	uint32_t	EFLASH_BOR_TEST_EN:1;			// 0:0   
	uint32_t	EFLASH_BOR_TEST_SEL:2;			// 2:1   
	uint32_t	rsvd1:29;			// 31:3   Reserved
};

union ANA_EFLASH_BOR_CFG_REG {
	uint32_t 		 all;
	struct ANA_EFLASH_BOR_CFG_BITS 		 bit;
};

//
// BG Configuration
//
struct ANA_TOP_BG_CFG_BITS {			// bits   description
	uint32_t	TOP_BG_CHOP_EN:1;			// 0:0   
	uint32_t	TOP_BG_TEST_MUX_EN:1;			// 1:1   
	uint32_t	TOP_BG_TEST_MUX_SEL:3;			// 4:2   
	uint32_t	rsvd1:27;			// 31:5   Reserved
};

union ANA_TOP_BG_CFG_REG {
	uint32_t 		 all;
	struct ANA_TOP_BG_CFG_BITS 		 bit;
};

//
// OSC TRIM Configuration
//
struct ANA_OSC_TRIM_BITS {			// bits   description
	uint32_t	CFG_OSC1_TRIM_VALUE:15;			// 14:0   
	uint32_t	rsvd1:1;			// 15:15   Reserved
	uint32_t	CFG_OSC2_TRIM_VALUE:15;			// 30:16   
	uint32_t	rsvd2:1;			// 31:31   Reserved
};

union ANA_OSC_TRIM_REG {
	uint32_t 		 all;
	struct ANA_OSC_TRIM_BITS 		 bit;
};

//
// PVM Configuration
//
struct ANA_PVM_CFG_BITS {			// bits   description
	uint32_t	PVM_EN:1;			// 0:0   
	uint32_t	PVM_FALLING_SEL:3;			// 3:1   
	uint32_t	PVM_RISING_SEL:3;			// 6:4   
	uint32_t	PVM_TRIM:4;			// 10:7   
	uint32_t	PVM_TEST_EN:1;			// 11:11   
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union ANA_PVM_CFG_REG {
	uint32_t 		 all;
	struct ANA_PVM_CFG_BITS 		 bit;
};

//
// POR_1V1 Configuration
//
struct ANA_POR_1V1_CFG_BITS {			// bits   description
	uint32_t	POR_1V1_TEST_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ANA_POR_1V1_CFG_REG {
	uint32_t 		 all;
	struct ANA_POR_1V1_CFG_BITS 		 bit;
};

//
// TOP_POR Configuration
//
struct ANA_TOP_POR_CFG_BITS {			// bits   description
	uint32_t	TOP_POR_TEST_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ANA_TOP_POR_CFG_REG {
	uint32_t 		 all;
	struct ANA_TOP_POR_CFG_BITS 		 bit;
};

//
// ADC_RST Register
//
struct ADC_RST_BITS {			// bits   description
	uint32_t	ADCA_RST:1;			// 0:0   Reset high is effective, power-on default reset state
	uint32_t	ADCB_RST:1;			// 1:1   Reset high is effective, power-on default reset state
	uint32_t	ADCC_RST:1;			// 2:2   Reset high is effective, power-on default reset state
	uint32_t	rsvd1:29;			// 31:3   Reserved
};

union ADC_RST_REG {
	uint32_t 		 all;
	struct ADC_RST_BITS 		 bit;
};

//
// ADC_SAMP_SEL Register
//
struct ADC_SAMP_SEL_BITS {			// bits   description
	uint32_t	ADCA_SAMP_SEL:3;			// 2:0   
	uint32_t	rsvd1:1;			// 3:3   Reserved
	uint32_t	ADCB_SAMP_SEL:3;			// 6:4   
	uint32_t	rsvd2:1;			// 7:7   Reserved
	uint32_t	ADCC_SAMP_SEL:3;			// 10:8   
	uint32_t	rsvd3:21;			// 31:11   Reserved
};

union ADC_SAMP_SEL_REG {
	uint32_t 		 all;
	struct ADC_SAMP_SEL_BITS 		 bit;
};

//
// CMP_EN Register
//
struct CMP_EN_BITS {			// bits   description
	uint32_t	CMP_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union CMP_EN_REG {
	uint32_t 		 all;
	struct CMP_EN_BITS 		 bit;
};

//
// CMP_RST Register
//
struct CMP_RST_BITS {			// bits   description
	uint32_t	CMP_RST:1;			// 0:0   Reset high is effective, power-on default reset state
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union CMP_RST_REG {
	uint32_t 		 all;
	struct CMP_RST_BITS 		 bit;
};

//
// DAC_TOP_EN Configuration Register
//
struct DAC_TOP_EN_BITS {			// bits   description
	uint32_t	DAC_TOP_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union DAC_TOP_EN_REG {
	uint32_t 		 all;
	struct DAC_TOP_EN_BITS 		 bit;
};

//
// DAC_RST Configuration Register
//
struct DAC_RST_BITS {			// bits   description
	uint32_t	DAC_RST:1;			// 0:0   Reset high is effective, power-on default reset state
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union DAC_RST_REG {
	uint32_t 		 all;
	struct DAC_RST_BITS 		 bit;
};

//
// DACA_BUF trim Value
//
struct DACA_BUF_TRIM_BITS {			// bits   description
	uint32_t	DACA_BUF_TRIM:6;			// 5:0   
	uint32_t	rsvd1:26;			// 31:6   Reserved
};

union DACA_BUF_TRIM_REG {
	uint32_t 		 all;
	struct DACA_BUF_TRIM_BITS 		 bit;
};

//
// DACB_BUF trim Value
//
struct DACB_BUF_TRIM_BITS {			// bits   description
	uint32_t	DACB_BUF_TRIM:6;			// 5:0   
	uint32_t	rsvd1:26;			// 31:6   Reserved
};

union DACB_BUF_TRIM_REG {
	uint32_t 		 all;
	struct DACB_BUF_TRIM_BITS 		 bit;
};

//
// band gap Configuration Register
//
struct BG_REG_BITS {			// bits   description
	uint32_t	BG_CHOP_EN:1;			// 0:0   
	uint32_t	rsvd1:2;			// 2:1   Reserved
	uint32_t	BG_MEAS:1;			// 3:3   
	uint32_t	rsvd2:28;			// 31:4   Reserved
};

union BG_REG_REG {
	uint32_t 		 all;
	struct BG_REG_BITS 		 bit;
};

//
// ana_clk trim Configuration Register
//
struct ANA_CLK_TRIM_BITS {			// bits   description
	uint32_t	ANA_CLK_TRIM:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union ANA_CLK_TRIM_REG {
	uint32_t 		 all;
	struct ANA_CLK_TRIM_BITS 		 bit;
};

//
// ana_ts_chop_en Configuration Register
//
struct ANA_TS_CHOP_EN_BITS {			// bits   description
	uint32_t	ANA_TS_CHOP_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ANA_TS_CHOP_EN_REG {
	uint32_t 		 all;
	struct ANA_TS_CHOP_EN_BITS 		 bit;
};

//
// ana_ts_meas_en Configuration Register
//
struct ANA_TS_MEAS_EN_BITS {			// bits   description
	uint32_t	ANA_TS_MEAS_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ANA_TS_MEAS_EN_REG {
	uint32_t 		 all;
	struct ANA_TS_MEAS_EN_BITS 		 bit;
};

//
// ana_ts_spare Configuration Register
//
struct ANA_TS_SPARE_BITS {			// bits   description
	uint32_t	ANA_TS_SPARE:10;			// 9:0   
	uint32_t	rsvd1:22;			// 31:10   Reserved
};

union ANA_TS_SPARE_REG {
	uint32_t 		 all;
	struct ANA_TS_SPARE_BITS 		 bit;
};

//
// ana_test_mux_sel Configuration Register
//
struct ANA_TEST_MUX_SEL_BITS {			// bits   description
	uint32_t	ANA_TEST_MUX0_SEL:4;			// 3:0   
	uint32_t	ANA_TEST_MUX1_SEL:4;			// 7:4   
	uint32_t	ANA_TEST_MUX2_SEL:4;			// 11:8   
	uint32_t	ANA_TEST_MUX3_SEL:4;			// 15:12   
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union ANA_TEST_MUX_SEL_REG {
	uint32_t 		 all;
	struct ANA_TEST_MUX_SEL_BITS 		 bit;
};

//
// ana_test_mux_en Configuration Register
//
struct ANA_TEST_MUX_EN_BITS {			// bits   description
	uint32_t	ANA_TEST_MUX0_EN:1;			// 0:0   
	uint32_t	ANA_TEST_MUX1_EN:1;			// 1:1   
	uint32_t	ANA_TEST_MUX2_EN:1;			// 2:2   
	uint32_t	ANA_TEST_MUX3_EN:1;			// 3:3   
	uint32_t	ANA_TEST_MUX0_MODE:1;			// 4:4   
	uint32_t	ANA_TEST_MUX1_MODE:1;			// 5:5   
	uint32_t	ANA_TEST_MUX2_MODE:1;			// 6:6   
	uint32_t	ANA_TEST_MUX3_MODE:1;			// 7:7   
	uint32_t	rsvd1:24;			// 31:8   Reserved
};

union ANA_TEST_MUX_EN_REG {
	uint32_t 		 all;
	struct ANA_TEST_MUX_EN_BITS 		 bit;
};

//
// LDO_ANA_TEST_EN Configuration
//
struct LDO_ANA_TEST_EN_BITS {			// bits   description
	uint32_t	LDO_ANA_TEST_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union LDO_ANA_TEST_EN_REG {
	uint32_t 		 all;
	struct LDO_ANA_TEST_EN_BITS 		 bit;
};

//
// LDO_ANA_VSEL Configuration
//
struct LDO_ANA_VSEL_BITS {			// bits   description
	uint32_t	LDO_ANA_VSEL:6;			// 5:0   
	uint32_t	rsvd1:26;			// 31:6   Reserved
};

union LDO_ANA_VSEL_REG {
	uint32_t 		 all;
	struct LDO_ANA_VSEL_BITS 		 bit;
};

//
// LDO_ANA_FASTON Configuration
//
struct LDO_ANA_FASTON_BITS {			// bits   description
	uint32_t	LDO_ANA_FASTON:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union LDO_ANA_FASTON_REG {
	uint32_t 		 all;
	struct LDO_ANA_FASTON_BITS 		 bit;
};

//
// DACA_ANA_CFG Configuration
//
struct DACA_ANA_CFG_BITS {			// bits   description
	uint32_t	DACA_ANA_REF_SEL:1;			// 0:0   
	uint32_t	DACA_ANA_REF_2P5:1;			// 1:1   
	uint32_t	DACA_VREF_EN:1;			// 2:2   
	uint32_t	rsvd1:29;			// 31:3   Reserved
};

union DACA_ANA_CFG_REG {
	uint32_t 		 all;
	struct DACA_ANA_CFG_BITS 		 bit;
};

//
// DACA_INL_OFF_DLY_TRIM Configuration
//
struct DACA_INL_OFF_DLY_TRIM_BITS {			// bits   description
	uint32_t	DACA_DLY_TRIM:8;			// 7:0   
	uint32_t	rsvd1:8;			// 15:8   Reserved
	uint32_t	DACA_INL_TRIM:16;			// 31:16   
};

union DACA_INL_OFF_DLY_TRIM_REG {
	uint32_t 		 all;
	struct DACA_INL_OFF_DLY_TRIM_BITS 		 bit;
};

//
// DACB_ANA_CFG Configuration
//
struct DACB_ANA_CFG_BITS {			// bits   description
	uint32_t	DACB_ANA_REF_SEL:1;			// 0:0   
	uint32_t	DACB_ANA_REF_2P5:1;			// 1:1   
	uint32_t	DACB_VREF_EN:1;			// 2:2   
	uint32_t	rsvd1:29;			// 31:3   Reserved
};

union DACB_ANA_CFG_REG {
	uint32_t 		 all;
	struct DACB_ANA_CFG_BITS 		 bit;
};

//
// DACB_INL_OFF_DLY_TRIM Configuration
//
struct DACB_INL_OFF_DLY_TRIM_BITS {			// bits   description
	uint32_t	DACB_DLY_TRIM:8;			// 7:0   
	uint32_t	rsvd1:8;			// 15:8   Reserved
	uint32_t	DACB_INL_TRIM:16;			// 31:16   reserved
};

union DACB_INL_OFF_DLY_TRIM_REG {
	uint32_t 		 all;
	struct DACB_INL_OFF_DLY_TRIM_BITS 		 bit;
};

//
// ADCA_BUFDAC2ADC_LBEN Configuration
//
struct ADCA_BUFDAC2ADC_LBEN_BITS {			// bits   description
	uint32_t	ADCA_BUFDAC2ADC_LBEN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADCA_BUFDAC2ADC_LBEN_REG {
	uint32_t 		 all;
	struct ADCA_BUFDAC2ADC_LBEN_BITS 		 bit;
};

//
// ADCB_BUFDAC2ADC_LBEN Configuration
//
struct ADCB_BUFDAC2ADC_LBEN_BITS {			// bits   description
	uint32_t	ADCB_BUFDAC2ADC_LBEN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADCB_BUFDAC2ADC_LBEN_REG {
	uint32_t 		 all;
	struct ADCB_BUFDAC2ADC_LBEN_BITS 		 bit;
};

//
// ADCC_BUFDAC2ADC_LBEN Configuration
//
struct ADCC_BUFDAC2ADC_LBEN_BITS {			// bits   description
	uint32_t	ADCC_BUFDAC2ADC_LBEN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADCC_BUFDAC2ADC_LBEN_REG {
	uint32_t 		 all;
	struct ADCC_BUFDAC2ADC_LBEN_BITS 		 bit;
};

//
// ADC_L2H_CFG Configuration
//
struct ADC_L2H_CFG_BITS {			// bits   description
	uint32_t	ADC_L2H_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADC_L2H_CFG_REG {
	uint32_t 		 all;
	struct ADC_L2H_CFG_BITS 		 bit;
};

//
// CMP_MX_EN Configuration
//
struct CMP_MX_EN_BITS {			// bits   description
	uint32_t	CMP1_LN_EN:1;			// 0:0   
	uint32_t	CMP1_LP_EN:1;			// 1:1   
	uint32_t	CMP1_HN_EN:1;			// 2:2   
	uint32_t	CMP1_HP_EN:1;			// 3:3   
	uint32_t	CMP2_LN_EN:1;			// 4:4   
	uint32_t	CMP2_LP_EN:1;			// 5:5   
	uint32_t	CMP2_HN_EN:1;			// 6:6   
	uint32_t	CMP2_HP_EN:1;			// 7:7   
	uint32_t	CMP3_LN_EN:1;			// 8:8   
	uint32_t	CMP3_LP_EN:1;			// 9:9   
	uint32_t	CMP3_HN_EN:1;			// 10:10   
	uint32_t	CMP3_HP_EN:1;			// 11:11   
	uint32_t	CMP4_LN_EN:1;			// 12:12   
	uint32_t	CMP4_LP_EN:1;			// 13:13   
	uint32_t	CMP4_HN_EN:1;			// 14:14   
	uint32_t	CMP4_HP_EN:1;			// 15:15   
	uint32_t	CMP5_LN_EN:1;			// 16:16   
	uint32_t	CMP5_LP_EN:1;			// 17:17   
	uint32_t	CMP5_HN_EN:1;			// 18:18   
	uint32_t	CMP5_HP_EN:1;			// 19:19   
	uint32_t	CMP6_LN_EN:1;			// 20:20   
	uint32_t	CMP6_LP_EN:1;			// 21:21   
	uint32_t	CMP6_HN_EN:1;			// 22:22   
	uint32_t	CMP6_HP_EN:1;			// 23:23   
	uint32_t	CMP7_LN_EN:1;			// 24:24   
	uint32_t	CMP7_LP_EN:1;			// 25:25   
	uint32_t	CMP7_HN_EN:1;			// 26:26   
	uint32_t	CMP7_HP_EN:1;			// 27:27   
	uint32_t	rsvd1:4;			// 31:28   Reserved
};

union CMP_MX_EN_REG {
	uint32_t 		 all;
	struct CMP_MX_EN_BITS 		 bit;
};

//
// MUX_IO_CFG Configuration
//
struct MUX_IO_EN_BITS {			// bits   description
	uint32_t	MUX_IO_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union MUX_IO_EN_REG {
	uint32_t 		 all;
	struct MUX_IO_EN_BITS 		 bit;
};


// ANA_CFG Register Definitions:

//struct ANA_CFG_PARA_REGS {
struct ANALOG_SUBSYS_REGS {
	uint32_t  						ANA_CFG_LOCK;
	uint32_t 						rsvd1[47]; 		 // Reserved
	union  TSNSCTL_REG			TSNSCTL;
	uint16_t 						rsvd2[7]; 		 // Reserved
	union  ANAREFCTL_REG			ANAREFCTL;
	uint16_t 						rsvd3[7]; 		 // Reserved
	union  VMONCTL_REG			VMONCTL;
	uint16_t 						rsvd4[17]; 		 // Reserved
	union  CMPHPMXSEL_REG			CMPHPMXSEL;
	union  CMPLPMXSEL_REG			CMPLPMXSEL;
	union  CMPHNMXSEL_REG			CMPHNMXSEL;
	union  CMPLNMXSEL_REG			CMPLNMXSEL;
	union  ADCDACLOOPBACK_REG			ADCDACLOOPBACK;
	uint32_t 						rsvd5[60]; 		 // Reserved
	union  AGPIOCTRLA_REG			AGPIOCTRLA;
	uint32_t 						rsvd6[63]; 		 // Reserved
	union  ANA_BOR_CFG_REG			ANA_BOR_CFG;
	union  ANA_LDO_1V1_CFG_REG			ANA_LDO_1V1_CFG;
	union  ANA_EFLASH_BOR_CFG_REG			ANA_EFLASH_BOR_CFG;
	union  ANA_TOP_BG_CFG_REG			ANA_TOP_BG_CFG;
	union  ANA_OSC_TRIM_REG			ANA_OSC_TRIM;
	union  ANA_PVM_CFG_REG			ANA_PVM_CFG;
	union  ANA_POR_1V1_CFG_REG			ANA_POR_1V1_CFG;
	union  ANA_TOP_POR_CFG_REG			ANA_TOP_POR_CFG;
	uint32_t 						rsvd7[55]; 		 // Reserved
	union  ADC_RST_REG			ADC_RST;
	union  ADC_SAMP_SEL_REG			ADC_SAMP_SEL;
	uint32_t  						ADCA_SPARE;
	uint32_t  						ADCB_SPARE;
	uint32_t  						ADCC_SPARE;
	uint32_t 						rsvd8; 		 // Reserved
	uint32_t  						ADC_TOP_SPARE;
	union  CMP_EN_REG			CMP_EN;
	union  CMP_RST_REG			CMP_RST;
	uint32_t 						rsvd9[36]; 		 // Reserved
	uint32_t  						CMP_TOP_SPARE;
	union  DAC_TOP_EN_REG			DAC_TOP_EN;
	union  DAC_RST_REG			DAC_RST;
	union  DACA_BUF_TRIM_REG			DACA_BUF_TRIM;
	union  DACB_BUF_TRIM_REG			DACB_BUF_TRIM;
	uint32_t 						rsvd10; 		 // Reserved
	uint32_t  						DACA_SPARE;
	uint32_t  						DACB_SPARE;
	uint32_t 						rsvd11; 		 // Reserved
	uint32_t  						DAC_TOP_SPARE;
	uint32_t  						TMUX;
	uint32_t  						V2I_A;
	uint32_t  						V2I_B;
	union  BG_REG_REG			BG_REG;
	union  ANA_CLK_TRIM_REG			ANA_CLK_TRIM;
	uint32_t  						ANA_CLK_SPARE;
	uint32_t 						rsvd12[4]; 		 // Reserved
	union  ANA_TS_CHOP_EN_REG			ANA_TS_CHOP_EN;
	union  ANA_TS_MEAS_EN_REG			ANA_TS_MEAS_EN;
	uint32_t 						rsvd13; 		 // Reserved
	union  ANA_TS_SPARE_REG			ANA_TS_SPARE;
	uint32_t 						rsvd14[4]; 		 // Reserved
	union  ANA_TEST_MUX_SEL_REG			ANA_TEST_MUX_SEL;
	union  ANA_TEST_MUX_EN_REG			ANA_TEST_MUX_EN;
	uint32_t 						rsvd15; 		 // Reserved
	union  LDO_ANA_TEST_EN_REG			LDO_ANA_TEST_EN;
	union  LDO_ANA_VSEL_REG			LDO_ANA_VSEL;
	union  LDO_ANA_FASTON_REG			LDO_ANA_FASTON;
	union  DACA_ANA_CFG_REG			DACA_ANA_CFG;
	union  DACA_INL_OFF_DLY_TRIM_REG			DACA_INL_OFF_DLY_TRIM;
	union  DACB_ANA_CFG_REG			DACB_ANA_CFG;
	union  DACB_INL_OFF_DLY_TRIM_REG			DACB_INL_OFF_DLY_TRIM;
	uint32_t 						rsvd16[2]; 		 // Reserved
	uint32_t  						ANA_TOP_SPARE1;
	uint32_t  						ANA_TOP_SPARE2;
	uint32_t  						ANA_TOP_SPARE3;
	uint32_t  						ANA_TOP_SPARE4;
	union  ADCA_BUFDAC2ADC_LBEN_REG			ADCA_BUFDAC2ADC_LBEN;
	union  ADCB_BUFDAC2ADC_LBEN_REG			ADCB_BUFDAC2ADC_LBEN;
	union  ADCC_BUFDAC2ADC_LBEN_REG			ADCC_BUFDAC2ADC_LBEN;
	uint32_t 						rsvd17; 		 // Reserved
	union  ADC_L2H_CFG_REG			ADC_L2H_CFG;
	union  CMP_MX_EN_REG			CMP_MX_EN;
	union  MUX_IO_EN_REG			MUX_IO_EN;
	uint32_t  						DACA_TRIM;
	uint32_t  						DACB_TRIM;
};

#elif IS_GS32F00xx(0x30)

/* Temperature Sensor Control Register */
struct TSNSCTL_BITS {				/* bits description */
	uint16_t	TSNS_ENABLE:1;		/* 0:0  Temperature Sensor Enable. */
	uint16_t	rsvd1:15;			/* 15:1 Reserved */
};

union TSNSCTL_REG {
	uint16_t 		 all;
	struct TSNSCTL_BITS 		 bit;
};

/* Analog Reference Control Register */
struct ANAREFCTL_BITS {				/* bits	description */
	uint16_t	ANAREFSEL:1;		/* 0:0  Analog reference mode select. */
	uint16_t	rsvd1:7;			/* 7:1  Reserved */
	uint16_t	ANAREF2P5SEL:1;		/* 8:8  Analog reference 2.5V source select. */
	uint16_t	rsvd2:6;			/* 14:9 Reserved */
	uint16_t	ANAREFSEL_SUP_OVERRIDE:1; /* 15:15 This configuration determines (overrides) the external reference selection for ADC */
};

union ANAREFCTL_REG {
	uint16_t 		 all;
	struct ANAREFCTL_BITS 		 bit;
};

/* Voltage Monitor Control Register */
struct VMONCTL_BITS {				/* bits description */
	uint16_t	rsvd1:8;			/* 7:0  Reserved */
	uint16_t	BORLVMONDIS:1;		/* 8:8  BORL disable on VDDIO. */
	uint16_t	rsvd2:7;			/* 15:9 Reserved */
};

union VMONCTL_REG {
	uint16_t 		 all;
	struct VMONCTL_BITS 		 bit;
};

/* Bits to select one of the many sources on CmpHP inputs */
struct CMPHPMXSEL_BITS {			/* bits	description */
	uint32_t	CMP1_HP_SEL:3;		/* 2:0		CMP-1HPMXSEL bits, Please refer to the analog group connections */
	uint32_t	CMP2_HP_SEL:3;		/* 5:3		CMP-2HPMXSEL bits, Please refer to the analog group connections */
	uint32_t	CMP3_HP_SEL:3;		/* 8:6		CMP-3HPMXSEL bits, Please refer to the analog group connections */
	uint32_t	CMP4_HP_SEL:3;		/* 11:9   	CMP-4HPMXSEL bits, Please refer to the analog group connections */
	uint32_t	rsvd1:1;			/* 12:31   	Reserved                                                        */
};

union CMPHPMXSEL_REG {
	uint32_t 		 all;
	struct CMPHPMXSEL_BITS 		 bit;
};

/* Bits to select one of the many sources on CmpLP inputs */
struct CMPLPMXSEL_BITS {			/* bits   description */
	uint32_t	CMP1_LP_SEL:3;		/* 2:0   CMP-1LPMXSEL bits, Please refer to the analog group connections */
	uint32_t	CMP2_LP_SEL:3;		/* 5:3   CMP-2LPMXSEL bits, Please refer to the analog group connections */
	uint32_t	CMP3_LP_SEL:3;		/* 8:6   CMP-3LPMXSEL bits, Please refer to the analog group connections */
	uint32_t	CMP4_LP_SEL:3;		/* 11:9  CMP-4LPMXSEL bits, Please refer to the analog group connections */
	uint32_t	rsvd1:1;			/* 15:15 Reserved */
};

union CMPLPMXSEL_REG {
	uint32_t 		 all;
	struct CMPLPMXSEL_BITS 		 bit;
};

/* Bits to select one of the many sources on CmpHN inputs */
struct CMPHNMXSEL_BITS {			/* bits   description */
	uint16_t	CMP1_HN_SEL:1;		/* 0:0   CMP1HNMXSEL bits, Please refer to the analog group connections */
	uint16_t	CMP2_HN_SEL:1;		/* 1:1   CMP2HNMXSEL bits, Please refer to the analog group connections */
	uint16_t	CMP3_HN_SEL:1;		/* 2:2   CMP3HNMXSEL bits, Please refer to the analog group connections */
	uint16_t	CMP4_HN_SEL:1;		/* 3:3   CMP4HNMXSEL bits, Please refer to the analog group connections */
	uint16_t	rsvd1:12;			/* 15:4   Reserved */
};

union CMPHNMXSEL_REG {
	uint16_t 		 all;
	struct CMPHNMXSEL_BITS 		 bit;
};

/* Bits to select one of the many sources on CmpLN inputs */
struct CMPLNMXSEL_BITS {			/* bits   description */
	uint16_t	CMP1_LN_SEL:1;		/* 0:0   CMP1LNMXSEL bits, Please refer to the analog group connections */
	uint16_t	CMP2_LN_SEL:1;		/* 1:1   CMP2LNMXSEL bits, Please refer to the analog group connections */
	uint16_t	CMP3_LN_SEL:1;		/* 2:2   CMP3LNMXSEL bits, Please refer to the analog group connections */
	uint16_t	CMP4_LN_SEL:1;		/* 3:3   CMP4LNMXSEL bits, Please refer to the analog group connections */
	uint16_t	rsvd1:9;			/* 15:4   Reserved */
};

union CMPLNMXSEL_REG {
	uint16_t 		 all;
	struct CMPLNMXSEL_BITS 		 bit;
};

/* Enable loopback from DAC to ADCs */
struct ADCDACLOOPBACK_BITS {		/* bits   description */
	uint32_t	ADCDACLOOPBACK_ENLB2ADCA:1;			/* 0:0   1 Loops back COMPDACA output to ADCA. */
	uint32_t	rsvd1:1;			/* 1:1   Reserved */
	uint32_t	ADCDACLOOPBACK_ENLB2ADCC:1;			/* 2:2   1 Loops back COMPDACA output to ADCC. */
	uint32_t	rsvd2:29;			/* 31:3   Reserved */
};

union ADCDACLOOPBACK_REG {
	uint32_t 		 all;
	struct ADCDACLOOPBACK_BITS 		 bit;
};

/* CMPSS Control Register A */
struct CMPSSCTL_BITS {
	uint16_t CMP1DACLOUTEN:1;	/* 0:0 CMPSS1.COMPL Disable,Associated DAC will act as a general purpose DAC*/
	uint16_t rsvd1:14;			/* 14:1 Reserved */
	uint16_t CMPSSCTLEN:1;		/* 15:15 Rest of the configurations in this register are disabled */
};

union CMPSSCTL_REG {
	uint16_t all;
	struct CMPSSCTL_BITS bit;
};

/* AGPIO control register */
struct AGPIOCTRLA_BITS {			/* bits   description */
	uint32_t	rsvd1:11;				/* 10:0   Reserved */
	uint32_t	GPIO11:1;	/* 11:11   One time configuration for GPIO11 to
											decide whether AGPIO functionality is enabled */
	uint32_t	GPIO12:1;	/* 12:12   One time configuration for GPIO12 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	GPIO13:1;	/* 13:13   One time configuration for GPIO13 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	rsvd2:2;				/* 15:14 Reserved */
	uint32_t	GPIO16:1;	/* 16:16   One time configuration for GPIO16 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	GPIO17:1;	/* 17:17   One time configuration for GPIO17 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	rsvd3:2;				/* 19:18 Reserved */
	uint32_t	GPIO20:1;	/* 20:20   One time configuration for GPIO20 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	GPIO21:1;	/* 21:21   One time configuration for GPIO21 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	rsvd4:2;				/* 23:22 Reserved */
	uint32_t	GPIO24:1;	/* 24:24   One time configuration for GPIO24 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	rsvd5:2;				/* 27:25 Reserved */
	uint32_t	GPIO28:1;	/* 28:28   One time configuration for GPIO28 to
											decide whether AGPIO functionality is enabled*/
	uint32_t	rsvd6:2;				/* 31:29 Reserved */
};

union AGPIOCTRLA_REG {
	uint32_t	all;
	struct AGPIOCTRLA_BITS	bit;
};

/* AGPIO control register B */
struct AGPIOCTRLB_BITS {			/* bits   description */
	uint32_t	rsvd1:1;				/* 0:0   Reserved */
	uint32_t	GPIO33:1;	/* 1:1   One time configuration for GPIO33 to
											decide whether AGPIO functionality is enabled */
	uint32_t	rsvd6:30;				/* 31:2 Reserved */
};

union AGPIOCTRLB_REG {
	uint32_t 		 all;
	struct AGPIOCTRLB_BITS 		 bit;
};

/* ADC Global SOC FORCE */
struct ADCSOCFRCGB_BITS{
	uint32_t ADCSOCFRCGB_SOC0:1;	/* 0:0 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC1:1;	/* 1:1 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC2:1;	/* 2:2 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC3:1;	/* 3:3 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC4:1;	/* 4:4 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC5:1;	/* 5:5 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC6:1;	/* 6:6 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC7:1;	/* 7:7 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC8:1;	/* 8:8 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC9:1;	/* 9:9 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC10:1;	/* 10:10 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC11:1;	/* 11:11 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC12:1;	/* 12:12 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC13:1;	/* 13:13 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC14:1;	/* 14:14 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC15:1;	/* 15:15 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC16:1;	/* 16:16 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC17:1;	/* 17:17 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC18:1;	/* 18:18 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC19:1;	/* 19:19 Indicate if SOC0 selected for global SW trigger */
	uint32_t ADCSOCFRCGB_SOC20:1;	/* 20:20 Indicate if SOC0 selected for global SW trigger */
	uint32_t rsvd1:11;				/* 31:21 Reserved */
};

union ADCSOCFRCGB_REG{
	uint32_t	all;
	struct ADCSOCFRCGB_BITS	bit;
};

/* ADC Global SOC Force Select */
struct ADCSOCFRCGBSEL_BITS{
	uint16_t ADCSOCFRCGSBSEL_ADCA:1;/* 0:0  Indicate if ADCA selected for global SW trigger */
	uint16_t rsvd1:1;				/* 1:1  Reserved */
	uint16_t ADCSOCFRCGSBSEL_ADCC:1;/* 2:2  Indicate if ADCC selected for global SW trigger */
	uint16_t rsvd2:1;				/* 15:3 Reserved */
};

union ADCSOCFRCGBSEL_REG{
	uint16_t	all;
	struct ADCSOCFRCGBSEL_BITS	bit;
};

/* AGPIO control register H */
struct AGPIOCTRLH_BITS{
	uint32_t GPIO224:1;	/* 0:0 One time configuration for GPIO224 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd1:1;				/* 1:1 RESERVED */
	uint32_t GPIO226:1;	/* 2:2 One time configuration for GPIO226 to
										decide whether AGPIO functionality is enabled*/
	uint32_t GPIO227:1;	/* 3:3 One time configuration for GPIO227 to
										decide whether AGPIO functionality is enabled*/
	uint32_t GPIO228:1;	/* 4:4 One time configuration for GPIO228 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd2:1;				/* 5:5 RESERVED */
	uint32_t GPIO230:1;	/* 6:6 One time configuration for GPIO230 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd3:5;				/* 11:7 RESERVED */
	uint32_t GPIO236:1;	/* 12:12 One time configuration for GPIO236 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd4:5;				/* 17:13 RESERVED */
	uint32_t GPIO242:1;	/* 18:18 One time configuration for GPIO236 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd5:4;				/* 22:19 RESERVED */
	uint32_t GPIO247:1;	/* 23:23 One time configuration for GPIO247 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd6:5;				/* 28:24 RESERVED */
	uint32_t GPIO253:1;	/* 29:29 One time configuration for GPIO236 to
										decide whether AGPIO functionality is enabled*/
	uint32_t rsvd7:2;				/* 31:30 RESERVED */

};

union AGPIOCTRLH_REG {
	uint32_t all;
	struct AGPIOCTRLH_BITS bit;
};

/* BOR Configuration */
struct ANA_BOR_CFG_BITS {			/* bits description */
	uint32_t	rsvd1:1;			/* 0:0 Reserved 	*/
	uint32_t	BOR_FALLING_SEL:3;	/* 3:1 				*/
	uint32_t	BOR_RISING_SEL:3;	/* 6:4 bor Threshold selection configuration */
	uint32_t	BOR_TRIM:4;			/* 10:7 */
	uint32_t	BOR_TEST_EN:1;		/* 11:11 */
	uint32_t	rsvd2:20;			/* 31:12   Reserved */
};

union ANA_BOR_CFG_REG {
	uint32_t 		 all;
	struct ANA_BOR_CFG_BITS 		 bit;
};

/* 1V1LDO Configuration */
struct ANA_LDO_1V1_CFG_BITS {		/* bits description */
	uint32_t	LDO_1V1_VSEL:5;			// 4:0   
	uint32_t	LDO_1V1_TEST_MODE:2;			// 6:5   
	uint32_t	LDO_1V1_CHOP_EN:1;			// 7:7   
	uint32_t	LDO_1V1_TEST_MUX_SEL:3;			// 10:8   
	uint32_t	LDO_1V1_TEST_EN:1;			// 11:11   
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union ANA_LDO_1V1_CFG_REG {
	uint32_t 		 all;
	struct ANA_LDO_1V1_CFG_BITS 		 bit;
};

/* EFLASH_BOR Configuration */
struct ANA_EFLASH_BOR_CFG_BITS {		/* bits description */
	uint32_t	EFLASH_BOR_TEST_EN:1;	/* 0:0 				*/
	uint32_t	EFLASH_BOR_TEST_SEL:2;	/* 2:1 				*/
	uint32_t	rsvd1:29;				/* 31:3   Reserved 	*/
};

union ANA_EFLASH_BOR_CFG_REG {
	uint32_t 		 all;
	struct ANA_EFLASH_BOR_CFG_BITS 		 bit;
};

/* BG Configuration */
struct ANA_TOP_BG_CFG_BITS {			/* bits   description */
	uint32_t	TOP_BG_CHOP_EN:1;		/* 0:0                */
	uint32_t	TOP_BG_TEST_MUX_EN:1;	/* 1:1                */
	uint32_t	TOP_BG_TEST_MUX_SEL:3;	/* 4:2                */
	uint32_t	rsvd1:27;				/* 31:5   Reserved    */
};

union ANA_TOP_BG_CFG_REG {
	uint32_t 		 all;
	struct ANA_TOP_BG_CFG_BITS 		 bit;
};

/* OSC TRIM Configuration */
struct ANA_OSC_TRIM_BITS {				/* bits   description */
	uint32_t	CFG_OSC1_TRIM_VALUE:15;	/* 14:0               */
	uint32_t	rsvd1:1;				/* 15:15   Reserved   */
	uint32_t	CFG_OSC2_TRIM_VALUE:15;	/* 30:16              */
	uint32_t	rsvd2:1;				/* 31:31   Reserved   */
};

union ANA_OSC_TRIM_REG {
	uint32_t 		 all;
	struct ANA_OSC_TRIM_BITS 		 bit;
};

/* PVM Configuration */
struct ANA_PVM_CFG_BITS {			/* bits   description */
	uint32_t	PVM_EN:1;			/* 0:0                */
	uint32_t	PVM_FALLING_SEL:3;	/* 3:1                */
	uint32_t	PVM_RISING_SEL:3;	/* 6:4                */
	uint32_t	PVM_TRIM:4;			/* 10:7               */
	uint32_t	PVM_TEST_EN:1;		/* 11:11              */
	uint32_t	rsvd1:20;			/* 31:12   Reserved   */
};

union ANA_PVM_CFG_REG {
	uint32_t 		 all;
	struct ANA_PVM_CFG_BITS 		 bit;
};

/* POR_1V1 Configuration */
struct ANA_POR_1V1_CFG_BITS {		/* bits   description */
	uint32_t	POR_1V1_TEST_EN:1;	/* 0:0                */
	uint32_t	rsvd1:31;			/* 31:1   Reserved    */
};

union ANA_POR_1V1_CFG_REG {
	uint32_t 		 all;
	struct ANA_POR_1V1_CFG_BITS 		 bit;
};

/* TOP_POR Configuration */
struct ANA_TOP_POR_CFG_BITS {		/* bits   description */
	uint32_t	TOP_POR_TEST_EN:1;	/* 0:0                */
	uint32_t	rsvd1:31;			/* 31:1   Reserved    */
};

union ANA_TOP_POR_CFG_REG {
	uint32_t 		 all;
	struct ANA_TOP_POR_CFG_BITS 		 bit;
};

/* ANA_OSC_CFG Configuration */
struct ANA_OSC_CFG_BITS {
	uint32_t rsvd1:1;			/* 0:0 Reserved */
	uint32_t OSC2_RES_SEL:1;	/* 1:1 The OSC2 oscillator switches between internal resistors and external resistors */
	uint32_t rsvd2:30;			/* 31:2 Reserved */
};

union ANA_OSC_CFG_REG {
	uint32_t all;
	struct ANA_OSC_CFG_BITS bit;
};

/* ANA_OSC2_SPARE Configuration */
struct ANA_OSC2_SPARE_BITS {
	uint32_t OSC2_SPARE:16;		/* 15:0 */
	uint32_t rsvd1:16;			/* 31:16 Reserved */
};

union ANA_OSC2_SPARE_REG {
	uint32_t all;
	struct ANA_OSC2_SPARE_BITS bit;
};

/* ADC_RST Register */
struct ADC_RST_BITS {			/* bits  description                                           */
	uint32_t	ADCA_RST:1;		/* 0:0   Reset high is effective, power-on default reset state  */
	uint32_t	rsvd1:1;		/* 1:1   Reserved                                               */
	uint32_t	ADCC_RST:1;		/* 2:2   Reset high is effective, power-on default reset state  */
	uint32_t	rsvd2:29;		/* 31:3  Reserved                                              */
};

union ADC_RST_REG {
	uint32_t 		 all;
	struct ADC_RST_BITS 		 bit;
};

/* ADC_SAMP_SEL Register */
struct ADC_SAMP_SEL_BITS {			/* bits   description */
	uint32_t	ADCA_SAMP_SEL:2;	/* 1:0                */
	uint32_t	rsvd1:6;			/* 7:2   Reserved     */
	uint32_t	ADCC_SAMP_SEL:2;	/* 9:8                */
	uint32_t	rsvd3:22;			/* 31:10   Reserved   */
};

union ADC_SAMP_SEL_REG {
	uint32_t 		 all;
	struct ADC_SAMP_SEL_BITS 		 bit;
};

struct ADCA_SPARE_BITS
{
    uint32_t ADC_CMP_OFFSET_TRIM_EN:1;  /* 0:0 ADC comparator offset calibration enable */
    uint32_t ADC_CP_EN:1;               /* 1:1 ADC comparator enable */
    uint32_t ADC_EOC_PULSE_WIDTH_SEL:1; /* 2:2 EOC pulse width selection */
    uint32_t ADC_TRIM_EN:1;             /* 3:3 Calibration enable */
    uint32_t ADC_SAMP_CLK_SEL:1;        /* 4:4 Sampling clock selection */
    uint32_t ADC_SAMP_CLK_EN:1;         /* 5:5 Sampling clock enable */
    uint32_t ADC_2V5_1V6_MODE_SEL:1;    /* 6:6 2.5V/1.65V mode selection */
    uint32_t ADC_OSDTECT_EN:1;          /* 7:7 OSDETECT function enable */
    uint32_t ADC_OFFSET_DIR:2;          /* 9:8 ADC offset direction selection */
    uint32_t ADC_VREFHI_BG:4;           /* 13:10 VREFHI BG reference voltage level selection */
    uint32_t ADC_VREFHI_EN:1;           /* 14:14 VREFHI enable */
    uint32_t ADC_VREFHI_GEAR:4;         /* 18:15 VREFHI GEAR level selection */
    uint32_t ADC_VREFHI_OUT_TRIM:2;     /* 20:19 VREFHI output trim */
    uint32_t ADC_VCM_BG:4;              /* 24:21 VCM BG reference selection */
    uint32_t ADC_VCM_EN:1;              /* 25:25 VCM enable */
    uint32_t ADC_VCM_GEAR:4;            /* 29:26 VCM GEAR reference selection */
    uint32_t ADC_VREFHI_SEL:1;          /* 30:30 VREFIN selection */
    uint32_t ADC_VCM_SEL:1;             /* 31:31 VCM trim */
};


union ADCA_SPARE_REG {
	uint32_t all;
	struct ADCA_SPARE_BITS bit;
};

struct ADCC_SPARE_BITS
{
    uint32_t ADC_CMP_OFFSET_TRIM_EN:1;  /* 0:0 ADC comparator offset calibration enable */
    uint32_t ADC_CP_EN:1;               /* 1:1 ADC comparator enable */
    uint32_t ADC_EOC_PULSE_WIDTH_SEL:1; /* 2:2 EOC pulse width selection */
    uint32_t ADC_TRIM_EN:1;             /* 3:3 Calibration enable */
    uint32_t ADC_SAMP_CLK_SEL:1;        /* 4:4 Sampling clock selection */
    uint32_t ADC_SAMP_CLK_EN:1;         /* 5:5 Sampling clock enable */
    uint32_t ADC_2V5_1V6_MODE_SEL:1;    /* 6:6 2.5V/1.65V mode selection */
    uint32_t ADC_OSDTECT_EN:1;          /* 7:7 OSDETECT function enable */
    uint32_t ADC_OFFSET_DIR:2;          /* 9:8 ADC offset direction selection */
    uint32_t rsvd1:11;                  /* 20:10 Reserved */
    uint32_t ADC_VCM_BG:4;              /* 24:21 VCM BG reference selection */
    uint32_t ADC_VCM_EN:1;              /* 25:25 VCM enable */
    uint32_t ADC_VCM_GEAR:4;            /* 29:26 VCM GEAR reference selection */
    uint32_t ADC_VREFHI_SEL:1;          /* 30:30 VREFIN selection */
    uint32_t ADC_VCM_SEL:1;             /* 31:31 VCM trim */
};


union ADCC_SPARE_REG {
	uint32_t all;
	struct ADCC_SPARE_BITS bit;
};

struct ADC_TOP_SPARE_BITS {
    uint32_t ADC_BG_CHOP_EN:1;           /* 0:0 ADC BG CHOP enable */
    uint32_t ADC_PRE_DIVSION_EN:1;       /* 1:1 Pre-divider selection */
    uint32_t ADC_ADCA_RST:1;             /* 2:2 ADCA reset signal */
    uint32_t ADC_ADCC_RST:1;             /* 3:3 ADCC reset signal */
    uint32_t ADC_ADCA_RST_SIGNAL_SEL:3;  /* 6:4 ADCA reset signal selection */
    uint32_t ADC_ADCC_RST_SIGNAL_SEL:3;  /* 9:7 ADCC reset signal selection */
    uint32_t rsvd1:10;                   /* 19:10 Reserved */
    uint32_t ADC_ADCC_CLK_SIGANL_TEST_EN:1; /* 20:20 ADCC clock signal test enable */
    uint32_t ADC_ADCC_SOC_SIGNAL_TEST_EN:1; /* 21:21 ADCC SOC signal test enable */
    uint32_t ADC_CLK_ENABLE:1;           /* 22:22 Clock enable */
    uint32_t ADC_ADCC_CLK_DIVSION:2;     /* 24:23 ADCC clock divider configuration */
    uint32_t ADC_ADCC_CLK_DUTY_CYCLE:1;  /* 25:25 ADCC clock duty cycle adjustment */
    uint32_t rsvd2:3;                    /* 28:26 Reserved */
    uint32_t ADC_ADCA_CLK_DIVSION:2;     /* 30:29 ADCA clock divider configuration */
};


union ADC_TOP_SPARE_REG{
	uint32_t all;
	struct ADC_TOP_SPARE_BITS bit;
};


/* CMP_EN Register */
struct CMP_EN_BITS {			/* bits   description */
	uint32_t	CMP_EN:1;		/* 0:0    CMPSS EN    */
	uint32_t	rsvd1:31;		/* 31:1   Reserved    */
};

union CMP_EN_REG {
	uint32_t 		 all;
	struct CMP_EN_BITS 		 bit;
};

/* CMP_RST Register */
struct CMP_RST_BITS {			// bits   description
	uint32_t	CMP_RST:1;		// 0:0   Reset high is effective, power-on default reset state
	uint32_t	rsvd1:31;		// 31:1   Reserved
};

union CMP_RST_REG {
	uint32_t 		 all;
	struct CMP_RST_BITS 		 bit;
};

struct CMP1_H_TRIM_BITS {
	uint32_t CMP1_H_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP1_H_TRIM_REG {
	uint32_t all;
	struct CMP1_H_TRIM_BITS bit;
};

struct CMP1_L_TRIM_BITS {
	uint32_t CMP1_L_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP1_L_TRIM_REG {
	uint32_t all;
	struct CMP1_L_TRIM_BITS bit;
};

struct CMP2_H_TRIM_BITS {
	uint32_t CMP2_H_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP2_H_TRIM_REG {
	uint32_t all;
	struct CMP2_H_TRIM_BITS bit;
};

struct CMP2_L_TRIM_BITS {
	uint32_t CMP2_L_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP2_L_TRIM_REG {
	uint32_t all;
	struct CMP2_L_TRIM_BITS bit;
};

struct CMP3_H_TRIM_BITS {
	uint32_t CMP3_H_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP3_H_TRIM_REG {
	uint32_t all;
	struct CMP3_H_TRIM_BITS bit;
};

struct CMP3_L_TRIM_BITS {
	uint32_t CMP3_L_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP3_L_TRIM_REG {
	uint32_t all;
	struct CMP3_L_TRIM_BITS bit;
};

struct CMP4_H_TRIM_BITS {
	uint32_t CMP4_H_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP4_H_TRIM_REG {
	uint32_t all;
	struct CMP4_H_TRIM_BITS bit;
};

struct CMP4_L_TRIM_BITS {
	uint32_t CMP4_L_TRIM:2;
	uint32_t rsvd1:30;
};

union CMP4_L_TRIM_REG {
	uint32_t all;
	struct CMP4_L_TRIM_BITS bit;
};

struct BG_REG_BITS{
	uint32_t BG_CHOP_EN:1;  /*0:0*/
	uint32_t rsvd1:2;		/*2:1*/
	uint32_t BG_MEAS:1;		/*3:3*/
	uint32_t rsvd2:28;		/*31:4*/
};

union BG_REG_REG{
	uint32_t all;
	struct BG_REG_BITS bit;
};

// ana_clk trim Configuration Register
struct ANA_CLK_TRIM_BITS {			// bits   description
	uint32_t	ANA_CLK_TRIM:16;	// 15:0
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union ANA_CLK_TRIM_REG {
	uint32_t 		 all;
	struct ANA_CLK_TRIM_BITS 		 bit;
};

// ana_ts_chop_en Configuration Register
struct ANA_TS_CHOP_EN_BITS {			// bits   description
	uint32_t	ANA_TS_CHOP_EN:1;		// 0:0
	uint32_t	rsvd1:31;				// 31:1   Reserved
};

union ANA_TS_CHOP_EN_REG {
	uint32_t 		 all;
	struct ANA_TS_CHOP_EN_BITS 		 bit;
};

// ana_ts_meas_en Configuration Register
struct ANA_TS_MEAS_EN_BITS {			// bits   description
	uint32_t	ANA_TS_MEAS_EN:1;		// 0:0
	uint32_t	rsvd1:31;				// 31:1   Reserved
};

union ANA_TS_MEAS_EN_REG {
	uint32_t 		 all;
	struct ANA_TS_MEAS_EN_BITS 		 bit;
};

// ana_ts_spare Configuration Register
struct ANA_TS_SPARE_BITS {			// bits   description
	uint32_t	ANA_TS_SPARE:10;	// 9:0
	uint32_t	rsvd1:22;			// 31:10   Reserved
};

union ANA_TS_SPARE_REG {
	uint32_t 		 all;
	struct ANA_TS_SPARE_BITS 		 bit;
};

// ana_test_mux_sel Configuration Register
struct ANA_TEST_MUX_SEL_BITS {			// bits   description
	uint32_t	ANA_TEST_MUX0_SEL:4;	// 3:0
	uint32_t	ANA_TEST_MUX1_SEL:4;	// 7:4
	uint32_t	ANA_TEST_MUX2_SEL:4;	// 11:8
	uint32_t	ANA_TEST_MUX3_SEL:4;	// 15:12
	uint32_t	rsvd1:16;				// 31:16   Reserved
};

union ANA_TEST_MUX_SEL_REG {
	uint32_t 		 all;
	struct ANA_TEST_MUX_SEL_BITS 		 bit;
};

// ana_test_mux_en Configuration Register
struct ANA_TEST_MUX_EN_BITS {			// bits description
	uint32_t	ANA_TEST_MUX0_EN:1;		// 0:0
	uint32_t	ANA_TEST_MUX1_EN:1;		// 1:1
	uint32_t	ANA_TEST_MUX2_EN:1;		// 2:2
	uint32_t	ANA_TEST_MUX3_EN:1;		// 3:3
	uint32_t	ANA_TEST_MUX0_MODE:1;	// 4:4
	uint32_t	ANA_TEST_MUX1_MODE:1;	// 5:5
	uint32_t	ANA_TEST_MUX2_MODE:1;	// 6:6
	uint32_t	ANA_TEST_MUX3_MODE:1;	// 7:7
	uint32_t	rsvd1:24;				// 31:8	Reserved
};

union ANA_TEST_MUX_EN_REG {
	uint32_t 		 all;
	struct ANA_TEST_MUX_EN_BITS 		 bit;
};

// LDO_ANA_TEST_EN Configuration
struct LDO_ANA_TEST_EN_BITS {			// bits   description
	uint32_t	LDO_ANA_TEST_EN:1;		// 0:0
	uint32_t	rsvd1:31;				// 31:1   Reserved
};

union LDO_ANA_TEST_EN_REG {
	uint32_t 		 all;
	struct LDO_ANA_TEST_EN_BITS 		 bit;
};

// LDO_ANA_VSEL Configuration
struct LDO_ANA_VSEL_BITS {			// bits   description
	uint32_t	LDO_ANA_VSEL:6;			// 5:0   
	uint32_t	rsvd1:26;			// 31:6   Reserved
};

union LDO_ANA_VSEL_REG {
	uint32_t 		 all;
	struct LDO_ANA_VSEL_BITS 		 bit;
};

// LDO_ANA_FASTON Configuration
struct LDO_ANA_FASTON_BITS {			// bits   description
	uint32_t	LDO_ANA_FASTON:1;		// 0:0
	uint32_t	rsvd1:31;				// 31:1   Reserved
};

union LDO_ANA_FASTON_REG {
	uint32_t 		 all;
	struct LDO_ANA_FASTON_BITS 		 bit;
};

// ADCA_BUFDAC2ADC_LPEN Configuration
struct ADCA_BUFDAC2ADC_LPEN_BITS {			// bits   description
	uint32_t	ADCA_BUFDAC2ADC_LPEN:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADCA_BUFDAC2ADC_LPEN_REG {
	uint32_t 		 all;
	struct ADCA_BUFDAC2ADC_LPEN_BITS 		 bit;
};

// ADCC_BUFDAC2ADC_LPEN Configuration
struct ADCC_BUFDAC2ADC_LPEN_BITS {			// bits   description
	uint32_t	ADCC_BUFDAC2ADC_LPEN:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADCC_BUFDAC2ADC_LPEN_REG {
	uint32_t 		 all;
	struct ADCC_BUFDAC2ADC_LPEN_BITS 		 bit;
};

//
// ADC_L2H_CFG Configuration
//
struct ADC_L2H_CFG_BITS {			// bits   description
	uint32_t	ADC_L2H_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union ADC_L2H_CFG_REG {
	uint32_t 		 all;
	struct ADC_L2H_CFG_BITS 		 bit;
};

// CMP_MX_EN Configuration
struct CMP_MX_EN_BITS {			// bits   description
	uint32_t	CMP1_LN_EN:1;			// 0:0   
	uint32_t	CMP1_LP_EN:1;			// 1:1   
	uint32_t	CMP1_HN_EN:1;			// 2:2   
	uint32_t	CMP1_HP_EN:1;			// 3:3   
	uint32_t	CMP2_LN_EN:1;			// 4:4   
	uint32_t	CMP2_LP_EN:1;			// 5:5   
	uint32_t	CMP2_HN_EN:1;			// 6:6   
	uint32_t	CMP2_HP_EN:1;			// 7:7   
	uint32_t	CMP3_LN_EN:1;			// 8:8   
	uint32_t	CMP3_LP_EN:1;			// 9:9   
	uint32_t	CMP3_HN_EN:1;			// 10:10   
	uint32_t	CMP3_HP_EN:1;			// 11:11   
	uint32_t	CMP4_LN_EN:1;			// 12:12   
	uint32_t	CMP4_LP_EN:1;			// 13:13   
	uint32_t	CMP4_HN_EN:1;			// 14:14   
	uint32_t	CMP4_HP_EN:1;			// 15:15
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union CMP_MX_EN_REG {
	uint32_t 		 all;
	struct CMP_MX_EN_BITS 		 bit;
};

// MUX_IO_CFG Configuration
struct MUX_IO_EN_BITS {			// bits   description
	uint32_t	MUX_IO_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union MUX_IO_EN_REG {
	uint32_t 		 all;
	struct MUX_IO_EN_BITS 		 bit;
};

struct CMP1DACCTL_BITS{
	uint32_t CMP1_DACL_GAIN:1;
	uint32_t CMP1_DACL_BUF_HIZ_EN:1;
	uint32_t CMP1_DACL_BUF_EN:1;
	uint32_t rsvd1:13;
	uint32_t CMP1_DACH_GAIN:1;
	uint32_t CMP1_DACH_BUF_HIZ_EN:1;
	uint32_t CMP1_DACH_BUF_EN:1;
	uint32_t rsvd2:13;
};

union CMP1DACCTL_REG {
	uint32_t all;
	struct CMP1DACCTL_BITS bit;
};


// ANA_CFG Register Definitions:

//struct ANA_CFG_PARA_REGS {
struct ANALOG_SUBSYS_REGS {
	uint32_t  						ANA_CFG_LOCK;		//0x400D6000

	uint32_t 						rsvd1[47]; 		//0x400D6004
	union  TSNSCTL_REG				TSNSCTL;			//0x400D60C0
	uint32_t 						rsvd2[3]; 		//0x400D60C4
	union  ANAREFCTL_REG			ANAREFCTL;			//0x400D60D0
	uint32_t 						rsvd3[3]; 		//0x400D60D4
	union  VMONCTL_REG				VMONCTL;			//0x400D60E0
	uint32_t 						rsvd4[8]; 		//0x400D60E4
	union  CMPHPMXSEL_REG			CMPHPMXSEL;			//0x400D6104
	union  CMPLPMXSEL_REG			CMPLPMXSEL;			//0x400D6108
	union  CMPHNMXSEL_REG			CMPHNMXSEL;			//0x400D610C
	union  CMPLNMXSEL_REG			CMPLNMXSEL;			//0x400D610E
	union  ADCDACLOOPBACK_REG		ADCDACLOOPBACK;		//0x400D6110
	uint16_t 						rsvd5;			//0x400D6114
	union  CMPSSCTL_REG				CMPSSCTL;			//0x400D6116
	uint32_t 						rsvd6[63]; 		//0x400D6118
	union  AGPIOCTRLA_REG			AGPIOCTRLA;			//0x400D6214
	union  AGPIOCTRLB_REG			AGPIOCTRLB;			//0x400D6218
	uint32_t 						rsvd7[5];		//0x400D621C
	union  AGPIOCTRLH_REG			AGPIOCTRLH;			//0x400D6230
	uint32_t 						rsvd8[14]; 		//0x400D6234
	union  ADCSOCFRCGB_REG			ADCSOCFRCGB;		//0x400D626C
	union  ADCSOCFRCGBSEL_REG		ADCSOCFRCGBSEL;		//0x400D6270

	uint16_t						rsvd9;			//0x400D6272
	uint32_t 						rsvd10[36];		//0x400D6274

	union  ANA_BOR_CFG_REG			ANA_BOR_CFG;		//0x400D6304
	union  ANA_LDO_1V1_CFG_REG		ANA_LDO_1V1_CFG;	//0x400D6308
	union  ANA_EFLASH_BOR_CFG_REG	ANA_EFLASH_BOR_CFG;	//0x400D630C
	union  ANA_TOP_BG_CFG_REG		ANA_TOP_BG_CFG;		//0x400D6310
	union  ANA_OSC_TRIM_REG			ANA_OSC_TRIM;		//0x400D6314
	union  ANA_PVM_CFG_REG			ANA_PVM_CFG;		//0x400D6318
	union  ANA_POR_1V1_CFG_REG		ANA_POR_1V1_CFG;	//0x400D631C
	union  ANA_TOP_POR_CFG_REG		ANA_TOP_POR_CFG;	//0x400D6320
	union  ANA_OSC_CFG_REG			ANA_OSC_CFG;		//0x400D6324
	union  ANA_OSC2_SPARE_REG		ANA_OSC2_SPARE;		//0x400D6328

	uint32_t 						rsvd11[53]; 	//0x400D632C
	union  ADC_RST_REG				ADC_RST;			//0x400D6400
	union  ADC_SAMP_SEL_REG			ADC_SAMP_SEL;		//0x400D6404
	union ADCA_SPARE_REG  			ADCA_SPARE;			//0x400D6408
	uint32_t  						rsvd12;			//0x400D640C
	union ADCC_SPARE_REG			ADCC_SPARE;			//0x400D6410
	uint32_t 						rsvd13; 		//0x400D6414
	union ADC_TOP_SPARE_REG			ADC_TOP_SPARE;		//0x400D6418
	union  CMP_EN_REG				CMP_EN;				//0x400D641C
	union  CMP_RST_REG				CMP_RST;			//0x400D6420
	union  CMP1_H_TRIM_REG			CMP1_H_TRIM;		//0x400D6424
	union  CMP1_L_TRIM_REG			CMP1_L_TRIM;		//0x400D6428
	union  CMP2_H_TRIM_REG			CMP2_H_TRIM;		//0x400D642C
	union  CMP2_L_TRIM_REG			CMP2_L_TRIM;		//0x400D6430
	union  CMP3_H_TRIM_REG			CMP3_H_TRIM;		//0x400D6434
	union  CMP3_L_TRIM_REG			CMP3_L_TRIM;		//0x400D6438
	union  CMP4_H_TRIM_REG			CMP4_H_TRIM;		//0x400D643C
	union  CMP4_L_TRIM_REG			CMP4_L_TRIM;		//0x400D6440

	uint32_t 						rsvd14[28]; 	//0x400D6444
	uint32_t  						CMP_TOP_SPARE;		//0x400D64B4
	uint32_t 						rsvd15[9];		//0x400D64B8
	uint32_t  						TMUX;				//0x400D64DC
	uint32_t  						V2I_A;				//0x400D64E0
	uint32_t  						V2I_B;				//0x400D64E4
	union  BG_REG_REG				BG_REG;				//0x400D64E8
	union  ANA_CLK_TRIM_REG			ANA_CLK_TRIM;		//0x400D64EC
	uint32_t  						ANA_CLK_SPARE;		//0x400D64F0
	uint32_t 						rsvd16[4]; 		//0x400D64F4
	union  ANA_TS_CHOP_EN_REG		ANA_TS_CHOP_EN;		//0x400D6504
	union  ANA_TS_MEAS_EN_REG		ANA_TS_MEAS_EN;		//0x400D6508
	uint32_t 						rsvd17; 		//0x400D650C
	union  ANA_TS_SPARE_REG			ANA_TS_SPARE;		//0x400D6510
	uint32_t 						rsvd18[4]; 		//0x400D6514
	union  ANA_TEST_MUX_SEL_REG		ANA_TEST_MUX_SEL;	//0x400D6524
	union  ANA_TEST_MUX_EN_REG		ANA_TEST_MUX_EN;	//0x400D6528
	uint32_t 						rsvd19; 		//0x400D652C
	union  LDO_ANA_TEST_EN_REG		LDO_ANA_TEST_EN;	//0x400D6530
	union  LDO_ANA_VSEL_REG			LDO_ANA_VSEL;		//0x400D6534
	union  LDO_ANA_FASTON_REG		LDO_ANA_FASTON;		//0x400D6538
	uint32_t 						rsvd20[6]; 		//0x400D653C
	uint32_t  						ANA_TOP_SPARE1;		//0x400D6554
	uint32_t  						ANA_TOP_SPARE2;		//0x400D6558
	uint32_t  						ANA_TOP_SPARE3;		//0x400D655C
	uint32_t  						ANA_TOP_SPARE4;		//0x400D6560
	union  ADCA_BUFDAC2ADC_LPEN_REG			ADCA_BUFDAC2ADC_LBEN;	//0x400D6564
	uint32_t 						rsvd21; 		//0x400D6568
	union  ADCA_BUFDAC2ADC_LPEN_REG			ADCC_BUFDAC2ADC_LBEN;	//0x400D656C
	uint32_t 						rsvd22; 		//0x400D6570
	union  ADC_L2H_CFG_REG			ADC_L2H_CFG;		//0x400D6574
	union  CMP_MX_EN_REG			CMP_MX_EN;			//0x400D6578
	union  MUX_IO_EN_REG			CMP_MUX_IO_EN;		//0x400D657C
	uint32_t 						rsvd23[2]; 		//0x400D6580
	union  CMP1DACCTL_REG			CMP1DACCTL;			//0x400D6588
};

#endif

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

// ANA_CFG External References & Function Declarations

extern volatile struct ANALOG_SUBSYS_REGS AnalogSubsysRegs;


#ifdef __cplusplus
}
#endif      /* extern "C" */


#endif      // end of REGS_ANA_CFG_H definition

/* ========================================================================== */
/*                                  End of file                               */
/* ========================================================================== */
