/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_clboutputxbar.h
*   @brief
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef __REGS_CLBOUTPUTXBAR_H__
#define __REGS_CLBOUTPUTXBAR_H__

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif


//---------------------------------------------------------------------------
// CLBXBAR Individual Register Bit Definitions:

struct CLBOUTPUT0MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT0 of CLB-XBAR
};

union CLBOUTPUT0MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT0MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT0MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT0 of CLB-XBAR
};

union CLBOUTPUT0MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT0MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT1MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT1 of CLB-XBAR
};

union CLBOUTPUT1MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT1MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT1MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT1 of CLB-XBAR
};

union CLBOUTPUT1MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT1MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT2MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT2 of CLB-XBAR
};

union CLBOUTPUT2MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT2MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT2MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT2 of CLB-XBAR
};

union CLBOUTPUT2MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT2MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT3MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT3 of CLB-XBAR
};

union CLBOUTPUT3MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT3MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT3MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT3 of CLB-XBAR
};

union CLBOUTPUT3MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT3MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT4MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT4 of CLB-XBAR
};

union CLBOUTPUT4MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT4MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT4MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT4 of CLB-XBAR
};

union CLBOUTPUT4MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT4MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT5MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT5 of CLB-XBAR
};

union CLBOUTPUT5MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT5MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT5MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT5 of CLB-XBAR
};

union CLBOUTPUT5MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT5MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT6MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT6 of CLB-XBAR
};

union CLBOUTPUT6MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT6MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT6MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT6 of CLB-XBAR
};

union CLBOUTPUT6MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT6MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT7MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for CLBOUTPUT7 of CLB-XBAR
};

union CLBOUTPUT7MUX0TO15CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT7MUX0TO15CFG_BITS  bit;
};

struct CLBOUTPUT7MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for CLBOUTPUT7 of CLB-XBAR
};

union CLBOUTPUT7MUX16TO31CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT7MUX16TO31CFG_BITS  bit;
};

struct CLBOUTPUT0MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT0 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT0 of CLB-XBAR
};

union CLBOUTPUT0MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT0MUXENABLE_BITS  bit;
};

struct CLBOUTPUT1MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT1 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT1 of CLB-XBAR
};

union CLBOUTPUT1MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT1MUXENABLE_BITS  bit;
};

struct CLBOUTPUT2MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT2 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT2 of CLB-XBAR
};

union CLBOUTPUT2MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT2MUXENABLE_BITS  bit;
};

struct CLBOUTPUT3MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT3 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT3 of CLB-XBAR
};

union CLBOUTPUT3MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT3MUXENABLE_BITS  bit;
};

struct CLBOUTPUT4MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT4 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT4 of CLB-XBAR
};

union CLBOUTPUT4MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT4MUXENABLE_BITS  bit;
};

struct CLBOUTPUT5MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT5 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT5 of CLB-XBAR
};

union CLBOUTPUT5MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT5MUXENABLE_BITS  bit;
};

struct CLBOUTPUT6MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT6 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT6 of CLB-XBAR
};

union CLBOUTPUT6MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT6MUXENABLE_BITS  bit;
};

struct CLBOUTPUT7MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive CLBOUTPUT7 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive CLBOUTPUT7 of CLB-XBAR
};

union CLBOUTPUT7MUXENABLE_REG {
    uint32_t  all;
    struct  CLBOUTPUT7MUXENABLE_BITS  bit;
};

struct CLBOUTPUTLATCH_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR0_LATCH:1;			// 0
	uint16_t	CLBOUTPUTXBAR1_LATCH:1;			// 1
	uint16_t	CLBOUTPUTXBAR2_LATCH:1;			// 2
	uint16_t	CLBOUTPUTXBAR3_LATCH:1;			// 3
	uint16_t	CLBOUTPUTXBAR4_LATCH:1;			// 4
	uint16_t	CLBOUTPUTXBAR5_LATCH:1;			// 5
	uint16_t	CLBOUTPUTXBAR6_LATCH:1;			// 6
	uint16_t	CLBOUTPUTXBAR7_LATCH:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUTLATCH_REG {
	uint32_t 		 all;
	struct CLBOUTPUTLATCH_BITS 		 bit;
};

struct CLBOUTPUTLATCHCLR_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR0_LATCH_CLR:1;			// 0
	uint16_t	CLBOUTPUTXBAR1_LATCH_CLR:1;			// 1
	uint16_t	CLBOUTPUTXBAR2_LATCH_CLR:1;			// 2
	uint16_t	CLBOUTPUTXBAR3_LATCH_CLR:1;			// 3
	uint16_t	CLBOUTPUTXBAR4_LATCH_CLR:1;			// 4
	uint16_t	CLBOUTPUTXBAR5_LATCH_CLR:1;			// 5
	uint16_t	CLBOUTPUTXBAR6_LATCH_CLR:1;			// 6
	uint16_t	CLBOUTPUTXBAR7_LATCH_CLR:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUTLATCHCLR_REG {
	uint32_t 		 all;
	//struct CLBOUTPUTLATCHCLR_BITS 		 bit;
};


struct CLBOUTPUTLATCHFRC_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR0_LATCH_FRC:1;			// 0
	uint16_t	CLBOUTPUTXBAR1_LATCH_FRC:1;			// 1
	uint16_t	CLBOUTPUTXBAR2_LATCH_FRC:1;			// 2
	uint16_t	CLBOUTPUTXBAR3_LATCH_FRC:1;			// 3
	uint16_t	CLBOUTPUTXBAR4_LATCH_FRC:1;			// 4
	uint16_t	CLBOUTPUTXBAR5_LATCH_FRC:1;			// 5
	uint16_t	CLBOUTPUTXBAR6_LATCH_FRC:1;			// 6
	uint16_t	CLBOUTPUTXBAR7_LATCH_FRC:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUTLATCHFRC_REG {
	uint32_t 		 all;
	struct CLBOUTPUTLATCHFRC_BITS 		 bit;
};


struct CLBOUTPUTLATCHEN_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR0_LATCH_EN:1;			// 0
	uint16_t	CLBOUTPUTXBAR1_LATCH_EN:1;			// 1
	uint16_t	CLBOUTPUTXBAR2_LATCH_EN:1;			// 2
	uint16_t	CLBOUTPUTXBAR3_LATCH_EN:1;			// 3
	uint16_t	CLBOUTPUTXBAR4_LATCH_EN:1;			// 4
	uint16_t	CLBOUTPUTXBAR5_LATCH_EN:1;			// 5
	uint16_t	CLBOUTPUTXBAR6_LATCH_EN:1;			// 6
	uint16_t	CLBOUTPUTXBAR7_LATCH_EN:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUTLATCHEN_REG {
	uint32_t 		 all;
	struct CLBOUTPUTLATCHEN_BITS 		 bit;
};

struct CLBOUTPUT2LATCH_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR8_LATCH:1;			    // 0
	uint16_t	CLBOUTPUTXBAR9_LATCH:1;			    // 1
	uint16_t	CLBOUTPUTXBAR10_LATCH:1;			// 2
	uint16_t	CLBOUTPUTXBAR11_LATCH:1;			// 3
	uint16_t	CLBOUTPUTXBAR12_LATCH:1;			// 4
	uint16_t	CLBOUTPUTXBAR13_LATCH:1;			// 5
	uint16_t	CLBOUTPUTXBAR14_LATCH:1;			// 6
	uint16_t	CLBOUTPUTXBAR15_LATCH:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUT2LATCH_REG {
	uint32_t 		 all;
	struct CLBOUTPUT2LATCH_BITS 		 bit;
};


struct CLBOUTPUT2LATCHCLR_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR8_LATCH_CLR:1;			// 0
	uint16_t	CLBOUTPUTXBAR9_LATCH_CLR:1;			// 1
	uint16_t	CLBOUTPUTXBAR10_LATCH_CLR:1;			// 2
	uint16_t	CLBOUTPUTXBAR11_LATCH_CLR:1;			// 3
	uint16_t	CLBOUTPUTXBAR12_LATCH_CLR:1;			// 4
	uint16_t	CLBOUTPUTXBAR13_LATCH_CLR:1;			// 5
	uint16_t	CLBOUTPUTXBAR14_LATCH_CLR:1;			// 6
	uint16_t	CLBOUTPUTXBAR15_LATCH_CLR:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUT2LATCHCLR_REG {
	uint32_t 		 all;
	struct CLBOUTPUT2LATCHCLR_BITS 		 bit;
};


struct CLBOUTPUT2LATCHFRC_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR8_LATCH_FRC:1;			// 0
	uint16_t	CLBOUTPUTXBAR9_LATCH_FRC:1;			// 1
	uint16_t	CLBOUTPUTXBAR10_LATCH_FRC:1;			// 2
	uint16_t	CLBOUTPUTXBAR11_LATCH_FRC:1;			// 3
	uint16_t	CLBOUTPUTXBAR12_LATCH_FRC:1;			// 4
	uint16_t	CLBOUTPUTXBAR13_LATCH_FRC:1;			// 5
	uint16_t	CLBOUTPUTXBAR14_LATCH_FRC:1;			// 6
	uint16_t	CLBOUTPUTXBAR15_LATCH_FRC:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUT2LATCHFRC_REG {
	uint32_t 		 all;
	struct CLBOUTPUT2LATCHFRC_BITS 		 bit;
};


struct CLBOUTPUT2LATCHEN_BITS {			// bits   description
	uint16_t	CLBOUTPUTXBAR8_LATCH_EN:1;			// 0
	uint16_t	CLBOUTPUTXBAR9_LATCH_EN:1;			// 1
	uint16_t	CLBOUTPUTXBAR10_LATCH_EN:1;			// 2
	uint16_t	CLBOUTPUTXBAR11_LATCH_EN:1;			// 3
	uint16_t	CLBOUTPUTXBAR12_LATCH_EN:1;			// 4
	uint16_t	CLBOUTPUTXBAR13_LATCH_EN:1;			// 5
	uint16_t	CLBOUTPUTXBAR14_LATCH_EN:1;			// 6
	uint16_t	CLBOUTPUTXBAR15_LATCH_EN:1;			// 7
	uint16_t	rsvd1:8;						// 15:8
	uint16_t	rsvd2:16;  						// 31:16
};

union CLBOUTPUT2LATCHEN_REG {
	uint32_t 		 all;
	struct CLBOUTPUT2LATCHEN_BITS 		 bit;
};


struct CLBOUTPUT8MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union CLBOUTPUT8MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT8MUX0TO15CFG_BITS 		 bit;
};

struct CLBOUTPUT8MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union CLBOUTPUT8MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT8MUX16TO31CFG_BITS 		 bit;
};

struct CLBOUTPUT9MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union CLBOUTPUT9MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT9MUX0TO15CFG_BITS 		 bit;
};

struct CLBOUTPUT9MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union CLBOUTPUT9MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT9MUX16TO31CFG_BITS 		 bit;
};

struct CLBOUTPUT10MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union CLBOUTPUT10MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT10MUX0TO15CFG_BITS 		 bit;
};

struct CLBOUTPUT10MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union CLBOUTPUT10MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT10MUX16TO31CFG_BITS 		 bit;
};

struct CLBOUTPUT11MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union CLBOUTPUT11MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT11MUX0TO15CFG_BITS 		 bit;
};

struct CLBOUTPUT11MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union CLBOUTPUT11MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct CLBOUTPUT11MUX16TO31CFG_BITS 		 bit;
};

struct CLBOUTPUT8MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union CLBOUTPUT8MUXENABLE_REG {
	uint32_t 		 all;
	struct CLBOUTPUT8MUXENABLE_BITS 		 bit;
};

struct CLBOUTPUT9MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union CLBOUTPUT9MUXENABLE_REG {
	uint32_t 		 all;
	struct CLBOUTPUT9MUXENABLE_BITS 		 bit;
};

struct CLBOUTPUT10MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union CLBOUTPUT10MUXENABLE_REG {
	uint32_t 		 all;
	struct CLBOUTPUT10MUXENABLE_BITS 		 bit;
};

struct CLBOUTPUT11MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union CLBOUTPUT11MUXENABLE_REG {
	uint32_t 		 all;
	struct CLBOUTPUT11MUXENABLE_BITS 		 bit;
};

/**add mux32-mux64 base GS32F3xx*/
struct CLBOUTPUT0MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT0MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT0MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT0MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union CLBOUTPUT0MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT0MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT1MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT1MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT1MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT1MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union CLBOUTPUT1MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT1MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT2MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT2MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT2MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT2MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union CLBOUTPUT2MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT2MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT3MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT3MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT3MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT3MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                   
};

union CLBOUTPUT3MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT3MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT4MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT4MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT4MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT4MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union CLBOUTPUT4MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT4MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT5MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT5MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT5MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT5MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union CLBOUTPUT5MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT5MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT6MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                   
    uint32_t MUX33:2;                   
    uint32_t MUX34:2;                   
    uint32_t MUX35:2;                   
    uint32_t MUX36:2;                   
    uint32_t MUX37:2;                   
    uint32_t MUX38:2;                   
    uint32_t MUX39:2;                   
    uint32_t MUX40:2;                
    uint32_t MUX41:2;                
    uint32_t MUX42:2;                
    uint32_t MUX43:2;                
    uint32_t MUX44:2;                
    uint32_t MUX45:2;                
    uint32_t MUX46:2;                
    uint32_t MUX47:2;                
};

union CLBOUTPUT6MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT6MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT6MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                    
    uint32_t MUX49:2;                    
    uint32_t MUX50:2;                    
    uint32_t MUX51:2;                    
    uint32_t MUX52:2;                    
    uint32_t MUX53:2;                    
    uint32_t MUX54:2;                    
    uint32_t MUX55:2;                    
    uint32_t MUX56:2;                    
    uint32_t MUX57:2;                    
    uint32_t MUX58:2;                    
    uint32_t MUX59:2;                    
    uint32_t MUX60:2;                    
    uint32_t MUX61:2;                    
    uint32_t MUX62:2;                    
    uint32_t MUX63:2;                    
};

union CLBOUTPUT6MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT6MUX48TO63CFG_BITS  bit;
};

struct CLBOUTPUT7MUX32TO47CFG_BITS {
    uint32_t MUX32:2;                     
    uint32_t MUX33:2;                     
    uint32_t MUX34:2;                     
    uint32_t MUX35:2;                     
    uint32_t MUX36:2;                     
    uint32_t MUX37:2;                     
    uint32_t MUX38:2;                     
    uint32_t MUX39:2;                     
    uint32_t MUX40:2;                     
    uint32_t MUX41:2;                     
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union CLBOUTPUT7MUX32TO47CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT7MUX32TO47CFG_BITS  bit;
};

struct CLBOUTPUT7MUX48TO63CFG_BITS {
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union CLBOUTPUT7MUX48TO63CFG_REG {
    uint32_t  all;
    struct  CLBOUTPUT7MUX48TO63CFG_BITS  bit;
};

//MUX ENABLE
struct CLBOUTPUT0MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT0MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT0MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT1MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT1MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT1MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT2MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT2MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT2MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT3MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT3MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT3MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT4MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT4MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT4MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT5MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT5MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT5MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT6MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT6MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT6MUXENABLE32TO64_BITS  bit;
};

struct CLBOUTPUT7MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union CLBOUTPUT7MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  CLBOUTPUT7MUXENABLE32TO64_BITS  bit;
};


struct CLBOUTPUTOUTINV_BITS {              // bits description
    uint32_t OUT0:1;                      // 0 Selects polarity for CLBOUTPUT0 of CLB-XBAR
    uint32_t OUT1:1;                      // 1 Selects polarity for CLBOUTPUT1 of CLB-XBAR
    uint32_t OUT2:1;                      // 2 Selects polarity for CLBOUTPUT2 of CLB-XBAR
    uint32_t OUT3:1;                      // 3 Selects polarity for CLBOUTPUT3 of CLB-XBAR
    uint32_t OUT4:1;                      // 4 Selects polarity for CLBOUTPUT4 of CLB-XBAR
    uint32_t OUT5:1;                      // 5 Selects polarity for CLBOUTPUT5 of CLB-XBAR
    uint32_t OUT6:1;                      // 6 Selects polarity for CLBOUTPUT6 of CLB-XBAR
    uint32_t OUT7:1;                      // 7 Selects polarity for CLBOUTPUT7 of CLB-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union CLBOUTPUTOUTINV_REG {
    uint32_t  all;
    struct  CLBOUTPUTOUTINV_BITS  bit;
};

struct CLBOUTPUTLOCK_BITS {                // bits description
    uint32_t LOCK:1;                      // 0 Locks the configuration for CLB-XBAR
    uint32_t rsvd1:15;                    // 15:1 Reserved
    uint32_t KEY:16;                      // 31:16 Write Protection KEY
};

union CLBOUTPUTLOCK_REG {
    uint32_t  all;
    struct  CLBOUTPUTLOCK_BITS  bit;
};

struct CLB_OUTPUTXBAR_REGS {
    union  CLBOUTPUT0MUX0TO15CFG_REG			CLBOUTPUT0MUX0TO15CFG;
	union  CLBOUTPUT0MUX16TO31CFG_REG			CLBOUTPUT0MUX16TO31CFG;
	union  CLBOUTPUT1MUX0TO15CFG_REG			CLBOUTPUT1MUX0TO15CFG;
	union  CLBOUTPUT1MUX16TO31CFG_REG			CLBOUTPUT1MUX16TO31CFG;
	union  CLBOUTPUT2MUX0TO15CFG_REG			CLBOUTPUT2MUX0TO15CFG;
	union  CLBOUTPUT2MUX16TO31CFG_REG			CLBOUTPUT2MUX16TO31CFG;
	union  CLBOUTPUT3MUX0TO15CFG_REG			CLBOUTPUT3MUX0TO15CFG;
	union  CLBOUTPUT3MUX16TO31CFG_REG			CLBOUTPUT3MUX16TO31CFG;
	union  CLBOUTPUT4MUX0TO15CFG_REG			CLBOUTPUT4MUX0TO15CFG;
	union  CLBOUTPUT4MUX16TO31CFG_REG			CLBOUTPUT4MUX16TO31CFG;
	union  CLBOUTPUT5MUX0TO15CFG_REG			CLBOUTPUT5MUX0TO15CFG;
	union  CLBOUTPUT5MUX16TO31CFG_REG			CLBOUTPUT5MUX16TO31CFG;
	union  CLBOUTPUT6MUX0TO15CFG_REG			CLBOUTPUT6MUX0TO15CFG;
	union  CLBOUTPUT6MUX16TO31CFG_REG			CLBOUTPUT6MUX16TO31CFG;
	union  CLBOUTPUT7MUX0TO15CFG_REG			CLBOUTPUT7MUX0TO15CFG;
	union  CLBOUTPUT7MUX16TO31CFG_REG			CLBOUTPUT7MUX16TO31CFG;
	union  CLBOUTPUT0MUXENABLE_REG			    CLBOUTPUT0MUXENABLE;
	union  CLBOUTPUT1MUXENABLE_REG			    CLBOUTPUT1MUXENABLE;
	union  CLBOUTPUT2MUXENABLE_REG			    CLBOUTPUT2MUXENABLE;
	union  CLBOUTPUT3MUXENABLE_REG			    CLBOUTPUT3MUXENABLE;
	union  CLBOUTPUT4MUXENABLE_REG			    CLBOUTPUT4MUXENABLE;
	union  CLBOUTPUT5MUXENABLE_REG			    CLBOUTPUT5MUXENABLE;
	union  CLBOUTPUT6MUXENABLE_REG			    CLBOUTPUT6MUXENABLE;
	union  CLBOUTPUT7MUXENABLE_REG			    CLBOUTPUT7MUXENABLE;
	union  CLBOUTPUTLATCH_REG			        CLBOUTPUTLATCH;
	union  CLBOUTPUTLATCHCLR_REG           		CLBOUTPUTLATCHCLR;
	union  CLBOUTPUTLATCHFRC_REG				CLBOUTPUTLATCHFRC;
	union  CLBOUTPUTLATCHEN_REG 				CLBOUTPUTLATCHEN;
    union  CLBOUTPUTOUTINV_REG			        CLBOUTPUTOUTINV;
	uint32_t 						        	rsvd1[3]; 		 				// reserved
    union   CLBOUTPUT0MUX32TO47CFG_REG         CLBOUTPUT0MUX32TO47CFG;
    union   CLBOUTPUT0MUX48TO63CFG_REG         CLBOUTPUT0MUX48TO63CFG;
    union   CLBOUTPUT1MUX32TO47CFG_REG         CLBOUTPUT1MUX32TO47CFG;
    union   CLBOUTPUT1MUX48TO63CFG_REG         CLBOUTPUT1MUX48TO63CFG;
    union   CLBOUTPUT2MUX32TO47CFG_REG         CLBOUTPUT2MUX32TO47CFG;
    union   CLBOUTPUT2MUX48TO63CFG_REG         CLBOUTPUT2MUX48TO63CFG;
    union   CLBOUTPUT3MUX32TO47CFG_REG         CLBOUTPUT3MUX32TO47CFG;
    union   CLBOUTPUT3MUX48TO63CFG_REG         CLBOUTPUT3MUX48TO63CFG;
    union   CLBOUTPUT4MUX32TO47CFG_REG         CLBOUTPUT4MUX32TO47CFG;
    union   CLBOUTPUT4MUX48TO63CFG_REG         CLBOUTPUT4MUX48TO63CFG;
    union   CLBOUTPUT5MUX32TO47CFG_REG         CLBOUTPUT5MUX32TO47CFG;
    union   CLBOUTPUT5MUX48TO63CFG_REG         CLBOUTPUT5MUX48TO63CFG;
    union   CLBOUTPUT6MUX32TO47CFG_REG         CLBOUTPUT6MUX32TO47CFG;
    union   CLBOUTPUT6MUX48TO63CFG_REG         CLBOUTPUT6MUX48TO63CFG;
    union   CLBOUTPUT7MUX32TO47CFG_REG         CLBOUTPUT7MUX32TO47CFG;
    union   CLBOUTPUT7MUX48TO63CFG_REG         CLBOUTPUT7MUX48TO63CFG;
    union   CLBOUTPUT0MUXENABLE32TO64_REG      CLBOUTPUT0MUXENABLE32TO64;
    union   CLBOUTPUT1MUXENABLE32TO64_REG      CLBOUTPUT1MUXENABLE32TO64;
    union   CLBOUTPUT2MUXENABLE32TO64_REG      CLBOUTPUT2MUXENABLE32TO64;
    union   CLBOUTPUT3MUXENABLE32TO64_REG      CLBOUTPUT3MUXENABLE32TO64;
    union   CLBOUTPUT4MUXENABLE32TO64_REG      CLBOUTPUT4MUXENABLE32TO64;
    union   CLBOUTPUT5MUXENABLE32TO64_REG      CLBOUTPUT5MUXENABLE32TO64;
    union   CLBOUTPUT6MUXENABLE32TO64_REG      CLBOUTPUT6MUXENABLE32TO64;
    union   CLBOUTPUT7MUXENABLE32TO64_REG      CLBOUTPUT7MUXENABLE32TO64;
	uint32_t 						        rsvd2[7]; 		 // reserved
    union   CLBOUTPUTLOCK_REG                  CLBOUTPUTLOCK;                   // ClbXbar Configuration Lock register
    
};

//---------------------------------------------------------------------------
// CLBXBAR External References & Function Declarations:
//
extern volatile struct CLB_OUTPUTXBAR_REGS ClbOutputXbarRegs;
#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif

/*===========================================================================
 * End of file.
 *===========================================================================*/
