/*
 * regs_cmpss_035.h
 *
 *  Created on: 2025 Jun 17
 *      Author: Hpec
 */

#ifndef DRIVERLIB_REGS_REGS_CMPSS_035_H_
#define DRIVERLIB_REGS_REGS_CMPSS_035_H_


/**
 * Comparator Register Bit Definitions
 */

/**
 * Comparator Control Register
 */
struct COMPCTL_BITS {		/* bit 	 description 													*/
    uint32_t COMPDACEN:1;   /* 0   	 Comparator/DAC Enable 											*/
    uint32_t rsvd1:16;		/* 2:1   reserved 														*/
    uint32_t COMPSOURCE:1;	/* 17	 Source select for comparator inverting input 					*/
    uint32_t CMPINV:1;		/* 18	 Invert select for Comparator 									*/
    uint32_t QUALSEL:5;		/* 23:19 Qualification Period for synchronized output of the comparator */
    uint32_t SYNCSEL:1;		/* 24	 Synchronization select for output of the comparator 			*/
    uint32_t rsvd2:7;		/* 31:25 reserved 														*/
};

union COMPCTL_REG  {
    uint32_t all;
    struct COMPCTL_BITS bit;
};

/**
 * Comparator Output Status Register
 */
struct COMPSTS_BITS {		/* bit 	description 						*/
    uint16_t COMPSTS:1;   	/* 0 	Logical latched value of comparator */
    uint16_t rsvd1:15;    	/* 15:1 reserved							*/
};

union COMPSTS_REG  {
    uint16_t all;
    struct COMPSTS_BITS bit;
};

/**
 * Comparator Inner DAC Mode 2 Register
 */
struct COMPDACMODE_BITS {	/* bit 	 description 						*/
    uint16_t rsvd1:14;       /* 13:5  reserved							*/
    uint16_t FREE_SOFT:2;   /* 15:14 Debug Mode Bit						*/
};

union COMPDACMODE_REG  {
    uint16_t all;
    struct COMPDACMODE_BITS bit;
};

/**
 * Comparator Inner DAC Control Register
 */
struct COMPDACCTL_BITS {	/* bit 	 description 						*/
    uint16_t DACSOURCE:1;   /* 0	 DAC source control bits.			*/
    uint16_t RAMPSOURCE:4;  /* 4:1   Ramp generator source control bits */
    uint16_t rsvd1:11;       /* 13:5  reserved							*/
};

union COMPDACCTL_REG  {
    uint16_t all;
    struct COMPDACCTL_BITS bit;
};

/**
 *  Comparator Inner DAC Value Register
 */
struct DACVAL_BITS {		/* bit 	 description 	*/
    uint16_t DACVAL:10;     /* 9:0   DAC Value bit	*/
    uint16_t rsvd1:6;       /* 15:10 reserved		*/
};

union DACVAL_REG  {
    uint16_t all;
    struct DACVAL_BITS bit;
};

/**
/* Comparator Register Definitions
*/
struct CMPSS_REGS {
    union COMPCTL_REG		COMPCTL;			//0x0
    union COMPSTS_REG       COMPSTS;			//0x4
    uint16_t				rsvd1;				//0x6
    union COMPDACMODE_REG	DACMODE;			//0x8
    uint16_t                rsvd2[13]; 		 	//0xA
    union DACVAL_REG        DACVAL;				//0x24
    uint16_t                rsvd3[7];			//0x26
	uint32_t				CMPLOCK;			//0x34
    uint16_t                rsvd4[8];			//0x38
    union  COMPDACCTL_REG   COMPDACCTL;			//0x48
    uint16_t                rsvd5[3];			//0x4A
    uint16_t                RAMPMAXREF_ACTIVE;	//0x50
    uint16_t                rsvd6;				//0x52
    uint16_t                RAMPMAXREF_SHDW;	//0x54
    uint16_t                rsvd7;				//0x56
    uint16_t                RAMPDECVAL_ACTIVE;	//0x58
    uint16_t                rsvd8;				//0x5A
    uint16_t                RAMPDECVAL_SHDW;	//0x5C
    uint16_t                rsvd9;				//0x5E
    uint16_t                RAMPSTS;			//0x60
};

extern volatile struct CMPSS_REGS cmpssRegs;


#endif /* DRIVERLIB_REGS_REGS_CMPSS_035_H_ */
