/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_cputimer.h
*   @brief   
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_DUAL_TIMER_H
#define REGS_DUAL_TIMER_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// DUAL_TIMER Individual Register Bit Definitions:

struct TIMERLOAD_BITS {			// bits   description
	uint32_t	TIMERXLOAD:32;			// 31:0   The TIMERXLOAD Register contains the value from which the counter is to decrement. This 
};

union TIMERLOAD_REG {
	uint32_t 		 all;
	struct TIMERLOAD_BITS 		 bit;
};

struct TIMERVALUE_BITS {			// bits   description
	uint32_t	TIMERXVALUE:32;			// 31:0   The TIMERXVALUE Register provides the current value of the decrementing counter.
};

union TIMERVALUE_REG {
	uint32_t 		 all;
	struct TIMERVALUE_BITS 		 bit;
};

struct TIMERCONTROL_BITS {			// bits   description
	uint32_t	ONE_SHOT_COUNT:1;			// 0:0    Selects one-shot or wrapping counter mode:
	uint32_t	TIMERSIZE:1;			// 1:1   Selects 16-bit or 32- bit counter operation:
	uint32_t	TIMERPRE:2;			// 3:2   Prescale bits:
	uint32_t	rsvd1:1;			// 4:4   reserved
	uint32_t	INTERRUPT_ENABLE:1;			// 5:5    Interrupt Enable bit:
	uint32_t	TIMERMODE:1;			// 6:6   Mode bit:
	uint32_t	TIMERENABLE:1;			// 7:7   Enable bit:
	uint32_t	rsvd2:24;			// 31:8   reserved
};

union TIMERCONTROL_REG {
	uint32_t 		 all;
	struct TIMERCONTROL_BITS 		 bit;
};

struct TIMERINTCLR_BITS {			// bits   description
	uint32_t	TIMECLEARINTER:32;			// 31:0   r clears the interrupt output from the counter
};

union TIMERINTCLR_REG {
	uint32_t 		 all;
	struct TIMERINTCLR_BITS 		 bit;
};

struct TIMERRIS_BITS {			// bits   description
	uint32_t	RAW_TIMER_INTERRUPT:1;			// 0:0   Raw interrupt status from the counter
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union TIMERRIS_REG {
	uint32_t 		 all;
	struct TIMERRIS_BITS 		 bit;
};

struct TIMERMIS_BITS {			// bits   description
	uint32_t	TIMER_INTERRUPT:1;			// 0:0   Enabled interrupt status from the counter
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union TIMERMIS_REG {
	uint32_t 		 all;
	struct TIMERMIS_BITS 		 bit;
};

struct TIMERBGLOAD_BITS {			// bits   description
	uint32_t	RELOAD_COUNTER:32;			// 31:0   The TIMERXBGLOAD Register contains the value from which the counter is to decrement. 
};

union TIMERBGLOAD_REG {
	uint32_t 		 all;
	struct TIMERBGLOAD_BITS 		 bit;
};

struct TIMERITCR_BITS{              // bits   description
	uint32_t    INTEGRATION_TEST_MODE_ENABLE:1;     //0:0   Choose to enable or disable the integration test module
	uint32_t    rsvd1:31;               //31:1 reserved
};

union TIMERITCR_REG{
	uint32_t 		 all;
	struct TIMERITCR_BITS            bit;
};


struct TIMERITOP_BITS{                                   // bits   description
	uint32_t    INTEGRATION_TEST_TIMINT1_VALUE:1;           //0:0 Value output on TIMINT1 when in Integration Test Mode
	uint32_t    INTEGRATION_TEST_TIMINT2_VALUE:1;           //1:1 Value output on TIMINT2 when in Integration Test Mode
	uint32_t    rsvd1:30;                                //31:2 reserved
};

union TIMERITOP_REG{
	uint32_t 		 all;
	struct TIMERITOP_BITS            bit;
};

// dual_timer Register Definitions:

struct CPUTIMER_REGS {
	union  TIMERLOAD_REG			TIMERLOAD;
	union  TIMERVALUE_REG			TIMERVALUE;
	union  TIMERCONTROL_REG			TIMERCONTROL;
	union  TIMERINTCLR_REG			TIMERINTCLR;
	union  TIMERRIS_REG			TIMERRIS;
	union  TIMERMIS_REG			TIMERMIS;
	union  TIMERBGLOAD_REG			TIMERBGLOAD;
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// DUAL_TIMER External References & Function Declarations

extern volatile struct CPUTIMER_REGS CpuTimer0Regs;
extern volatile struct CPUTIMER_REGS CpuTimer1Regs;
extern volatile struct CPUTIMER_REGS CpuTimer2Regs;
extern volatile struct CPUTIMER_REGS CpuTimer3Regs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_DUAL_TIMER_H definition
