/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_ecap.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_ECAP_H
#define REGS_ECAP_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// ECAP Individual Register Bit Definitions:

//---------------------------------------------------------------------------
// ECAP Individual Register Bit Definitions:

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
struct ECCTL0_BITS {                    // bits description
	uint16_t INPUTSEL:9;                  // 8:0 INPUT source select
    uint16_t rsvd1:7;                     // 15:9 Reserved
    uint16_t rsvd2:16;                    // 31:16 Reserved
};

#elif IS_GS32F00xx(0x30)
struct ECCTL0_BITS {                      // bits description
	uint16_t INPUTSEL:9;                  // 7:0 INPUT source select
    uint16_t rsvd1:3;                     // 11:8 Reserved
    uint16_t QUALPRD:4;                   // 15:12 Qual period to filter out noise on input signals being monitored,
    uint16_t SOCEVTSEL:2;                 // 17:16 ADC SOC event select
    uint16_t rsvd2:2;                     // 19:18 Reserved
    uint16_t QUALPRD_EXT:4;               // 23:20 extra 4bits for QUALPRD configuration
    uint16_t rsvd3:8;                     // 31:24 Reserved
};
#endif

union ECCTL0_REG {
	uint32_t  all;
    struct  ECCTL0_BITS  bit;
};

struct ECCTL1_BITS {                    // bits description
	uint16_t CAP1POL:1;                   // 0 Capture Event 1 Polarity select
    uint16_t CTRRST1:1;                   // 1 Counter Reset on Capture Event 1
    uint16_t CAP2POL:1;                   // 2 Capture Event 2 Polarity select
    uint16_t CTRRST2:1;                   // 3 Counter Reset on Capture Event 2
    uint16_t CAP3POL:1;                   // 4 Capture Event 3 Polarity select
    uint16_t CTRRST3:1;                   // 5 Counter Reset on Capture Event 3
    uint16_t CAP4POL:1;                   // 6 Capture Event 4 Polarity select
    uint16_t CTRRST4:1;                   // 7 Counter Reset on Capture Event 4
    uint16_t CAPLDEN:1;                   // 8 Enable Loading CAP1-4 regs on a Cap Event
    uint16_t PRESCALE:5;                  // 13:9 Event Filter prescale select
    uint16_t FREE_SOFT:2;                 // 15:14 Emulation mode
};

union ECCTL1_REG {
	uint16_t  all;
    struct  ECCTL1_BITS  bit;
};

struct ECCTL2_BITS {                    // bits description
	uint16_t CONT_ONESHT:1;               // 0 Continuous or one-shot
    uint16_t STOP_WRAP:2;                 // 2:1 Stop value for one-shot, Wrap for continuous
    uint16_t REARM:1;                     // 3 One-shot re-arm
    uint16_t TSCTRSTOP:1;                 // 4 TSCNT counter stop
    uint16_t SYNCI_EN:1;                  // 5 Counter sync-in select
    uint16_t SYNCO_SEL:2;                 // 7:6 Sync-out mode
    uint16_t SWSYNC:1;                    // 8 SW forced counter sync
    uint16_t CAP_APWM:1;                  // 9 CAP/APWM operating mode select
    uint16_t APWMPOL:1;                   // 10  APWM output polarity select
    uint16_t CTRFILTRESET:1;              // 11 Reset event filter, modulus counter, and interrupt flags.
    uint16_t DMAEVTSEL:2;                 // 13:12 DMA event select
    uint16_t MODCNTRSTS:2;                // 15:14 modulo counter status
};

union ECCTL2_REG {
	uint16_t  all;
    struct  ECCTL2_BITS  bit;
};

struct ECEINT_BITS {                    // bits description
	uint16_t rsvd1:1;                     // 0 Reserved
    uint16_t CEVT1:1;                     // 1 Capture Event 1 Interrupt Enable
    uint16_t CEVT2:1;                     // 2 Capture Event 2 Interrupt Enable
    uint16_t CEVT3:1;                     // 3 Capture Event 3 Interrupt Enable
    uint16_t CEVT4:1;                     // 4 Capture Event 4 Interrupt Enable
    uint16_t CTROVF:1;                    // 5 Counter Overflow Interrupt Enable
    uint16_t CTR_EQ_PRD:1;                // 6 Period Equal Interrupt Enable
    uint16_t CTR_EQ_CMP:1;                // 7 Compare Equal Interrupt Enable
    uint16_t rsvd2:1;                     // 8 Reserved
    uint16_t MUNIT_1_ERROR_ENT1:1;        // 9 Monitoring unit 1 error event 1 interrupt enable
    uint16_t MUNIT_1_ERROR_ENT2:1;        // 10 Monitoring unit 1 error event 2 interrupt enable
    uint16_t MUNIT_2_ERROR_ENT1:1;        // 11 Monitoring unit 2 error event 1 interrupt enable
    uint16_t MUNIT_2_ERROR_ENT2:1;        // 12 Monitoring unit 2 error event 2 interrupt enable
    uint16_t rsvd3:3;                     // 15:13 Reserved
};

union ECEINT_REG {
	uint16_t  all;
    struct  ECEINT_BITS  bit;
};

struct ECFLG_BITS {                     // bits description
	uint16_t INT:1;                       // 0 Global Flag
    uint16_t CEVT1:1;                     // 1 Capture Event 1 Interrupt Flag
    uint16_t CEVT2:1;                     // 2 Capture Event 2 Interrupt Flag
    uint16_t CEVT3:1;                     // 3 Capture Event 3 Interrupt Flag
    uint16_t CEVT4:1;                     // 4 Capture Event 4 Interrupt Flag
    uint16_t CTROVF:1;                    // 5 Counter Overflow Interrupt Flag
    uint16_t CTR_PRD:1;                   // 6 Period Equal Interrupt Flag
    uint16_t CTR_CMP:1;                   // 7 Compare Equal Interrupt Flag
    uint16_t rsvd1:1;                     // 8 Reserved
    uint16_t MUNIT_1_ERROR_EVT1:1;        // 9 Error event 1 Interrupt Flag from monitoring unit 1
    uint16_t MUNIT_1_ERROR_EVT2:1;        // 10 Error event 2 Interrupt Flag from monitoring unit 1
    uint16_t MUNIT_2_ERROR_EVT1:1;        // 11 Error event 1 Interrupt Flag from monitoring unit 2
    uint16_t MUNIT_2_ERROR_EVT2:1;        // 12 Error event 2 Interrupt Flag from monitoring unit 2
    uint16_t rsvd2:3;                     // 15:13 Reserved
};

union ECFLG_REG {
	uint16_t  all;
    struct  ECFLG_BITS  bit;
};

struct ECCLR_BITS {                     // bits description
	uint16_t INT:1;                       // 0 ECAP Global Interrupt Status Clear
    uint16_t CEVT1:1;                     // 1 Capture Event 1 Status Clear
    uint16_t CEVT2:1;                     // 2 Capture Event 2 Status Clear
    uint16_t CEVT3:1;                     // 3 Capture Event 3 Status Clear
    uint16_t CEVT4:1;                     // 4 Capture Event 4 Status Clear
    uint16_t CTROVF:1;                    // 5 Counter Overflow Status Clear
    uint16_t CTR_PRD:1;                   // 6 Period Equal Status Clear
    uint16_t CTR_CMP:1;                   // 7 Compare Equal Status Clear
    uint16_t rsvd1:1;                     // 8 Reserved
    uint16_t MUNIT_1_ERROR_EVT1:1;        // 9 Writing '1' clears MUNIT_1_ERROR_EVT1 interrupt flag
    uint16_t MUNIT_1_ERROR_EVT2:1;        // 10 Writing '1' clears MUNIT_1_ERROR_EVT2 interrupt flag
    uint16_t MUNIT_2_ERROR_EVT1:1;        // 11 Writing '1' clears MUNIT_2_ERROR_EVT1 interrupt flag
    uint16_t MUNIT_2_ERROR_EVT2:1;        // 12 Writing '1' clears MUNIT_2_ERROR_EVT2 interrupt flag
    uint16_t rsvd2:3;                     // 15:13 Reserved
};

union ECCLR_REG {
	uint16_t  all;
    struct  ECCLR_BITS  bit;
};

struct ECFRC_BITS {                     // bits description
	uint16_t rsvd1:1;                     // 0 Reserved
    uint16_t CEVT1:1;                     // 1 Capture Event 1 Force Interrupt
    uint16_t CEVT2:1;                     // 2 Capture Event 2 Force Interrupt
    uint16_t CEVT3:1;                     // 3 Capture Event 3 Force Interrupt
    uint16_t CEVT4:1;                     // 4 Capture Event 4 Force Interrupt
    uint16_t CTROVF:1;                    // 5 Counter Overflow Force Interrupt
    uint16_t CTR_PRD:1;                   // 6 Period Equal Force Interrupt
    uint16_t CTR_CMP:1;                   // 7 Compare Equal Force Interrupt
    uint16_t rsvd2:1;                     // 8 Reserved
    uint16_t MUNIT_1_ERROR_EVT1:1;        // 9 Writing '1' sets MUNIT_1_ERROR_EVT1 interrupt flag
    uint16_t MUNIT_1_ERROR_EVT2:1;        // 10 Writing '1' sets MUNIT_1_ERROR_EVT2 interrupt flag
    uint16_t MUNIT_2_ERROR_EVT1:1;        // 11 Writing '1' sets MUNIT_2_ERROR_EVT1 interrupt flag
    uint16_t MUNIT_2_ERROR_EVT2:1;        // 12 Writing '1' sets MUNIT_2_ERROR_EVT2 interrupt flag
    uint16_t rsvd3:3;                     // 15:13 Reserved
};

union ECFRC_REG {
	uint16_t  all;
    struct  ECFRC_BITS  bit;
};

struct ECAPSYNCINSEL_BITS {               // bits description
	uint16_t ECAPSYNCINSEL:5;             // 4:0 SYNC_INPUT source select
    uint16_t rsvd1:11;                     // 15:5 Reserved
    uint16_t rsvd2:16;                    // 31:16 Reserved
};

union ECAPSYNCINSEL_REG {
	uint16_t  all;
    struct  ECAPSYNCINSEL_BITS  bit;
};

// eCAP Register Definitions:

struct ECAP_REGS {
	uint32_t			TSCTR;
	uint32_t			CTRPHS;
	uint32_t			CAP1;
	uint32_t			CAP2;
	uint32_t			CAP3;
	uint32_t			CAP4;
	uint32_t 								 rsvd1[3]; 		 // reserved
    union   ECCTL0_REG                       ECCTL0;                       // Capture Control Register 0
    union   ECCTL1_REG                       ECCTL1;                       // Capture Control Register 1
    union   ECCTL2_REG                       ECCTL2;                       // Capture Control Register 2
    union   ECEINT_REG                       ECEINT;                       // Capture Interrupt Enable Register
    union   ECFLG_REG                        ECFLG;                        // Capture Interrupt Flag Register
    union   ECCLR_REG                        ECCLR;                        // Capture Interrupt Clear Register
    union   ECFRC_REG                        ECFRC;                        // Capture Interrupt Force Register
    uint32_t 								 rsvd2[2]; 		 // reserved
    union   ECAPSYNCINSEL_REG                ECAPSYNCINSEL;                // SYNC source select register

};

struct HRCTL_BITS {                     // bits description
    Uint16 HRE:1;                       // 0 High Resolution Enable
    Uint16 HRCLKE:1;                    // 1 High Resolution Clock Enable
    Uint16 PRDSEL:1;                    // 2 Calibration Period Match
    Uint16 CALIBSTART:1;                // 3 Calibration start
    Uint16 CALIBSTS:1;                  // 4 Calibration status
    Uint16 CALIBCONT:1;                 // 5 Continuous mode Calibration Select
    Uint16 rsvd1:10;                    // 15:6 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union HRCTL_REG {
    Uint32  all;
    struct  HRCTL_BITS  bit;
};

struct HRINTEN_BITS {                   // bits description
    Uint16 rsvd1:1;                     // 0 Reserved
    Uint16 CALIBDONE:1;                 // 1 Calibration doe interrupt enable
    Uint16 CALPRDCHKSTS:1;              // 2 Calibration period check status enable
    Uint16 rsvd2:13;                    // 15:3 Reserved
    Uint16 rsvd3:16;                    // 31:16 Reserved
};

union HRINTEN_REG {
    Uint32  all;
    struct  HRINTEN_BITS  bit;
};

struct HRFLG_BITS {                     // bits description
    Uint16 CALIBINT:1;                  // 0 Global calibration Interrupt Status Flag
    Uint16 CALIBDONE:1;                 // 1 Calibration Done Interrupt Flag Bit
    Uint16 CALPRDCHKSTS:1;              // 2 Calibration period check status Flag Bi
    Uint16 rsvd1:13;                    // 15:3 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union HRFLG_REG {
    Uint32  all;
    struct  HRFLG_BITS  bit;
};

struct HRCLR_BITS {                     // bits description
    Uint16 CALIBINT:1;                  // 0 Clear Global calibration Interrupt Flag
    Uint16 CALIBDONE:1;                 // 1 Clear Calibration Done Interrupt Flag Bit
    Uint16 CALPRDCHKSTS:1;              // 2 Clear Calibration period check status Flag Bit
    Uint16 rsvd1:13;                    // 15:3 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union HRCLR_REG {
    Uint32  all;
    struct  HRCLR_BITS  bit;
};

struct HRFRC_BITS {                     // bits description
    Uint16 rsvd1:1;                     // 0 Reserved
    Uint16 CALIBDONE:1;                 // 1 Force Calibration Done Interrupt Flag Bit
    Uint16 CALPRDCHKSTS:1;              // 2 Force Calibration period check status Flag Bit
    Uint16 rsvd2:13;                    // 15:3 Reserved
    Uint16 rsvd3:16;                    // 31:16 Reserved
};

union HRFRC_REG {
    Uint32  all;
    struct  HRFRC_BITS  bit;
};

struct HRCAP_REGS {
    union   HRCTL_REG                        HRCTL;                        // High-Res Control Register
    Uint32                                   rsvd1[1];                     // Reserved
    union   HRINTEN_REG                      HRINTEN;                      // High-Res Calibration Interrupt Enable Register
    union   HRFLG_REG                        HRFLG;                        // High-Res Calibration Interrupt Flag Register
    union   HRCLR_REG                        HRCLR;                        // High-Res Calibration Interrupt Clear Register
    union   HRFRC_REG                        HRFRC;                        // High-Res Calibration Interrupt Force Register
    Uint32                                   HRCALPRD;                     // High-Res Calibration Period Register
    Uint32                                   HRSYSCLKCTR;                  // High-Res Calibration SYSCLK Counter Register
    Uint32                                   HRSYSCLKCAP;                  // High-Res Calibration SYSCLK Capture Register
    Uint32                                   HRCLKCTR;                     // High-Res Calibration HRCLK Counter Register
    Uint32                                   HRCLKCAP;                     // High-Res Calibration HRCLK Capture Register
};

struct MUNIT_COMMON_CTL_BITS {          // bits description
    Uint16 TRIPSEL:7;                   // 6:0 Trip signal select
    Uint16 rsvd1:1;                     // 7 Reserved
    Uint16 GLDSTRBSEL:7;                // 14:8 Global Load strobe select
    Uint16 rsvd2:1;                     // 15 Reserved
    Uint16 rsvd3:16;                    // 31:16 Reserved
};

union MUNIT_COMMON_CTL_REG {
    Uint32  all;
    struct  MUNIT_COMMON_CTL_BITS  bit;
};

struct MUNIT_1_CTL_BITS {               // bits description
    Uint16 EN:1;                        // 0 Enable bit
    Uint16 DEBUG_RANGE_EN:1;            // 1 Debug enable to aquire the range of check being done
    Uint16 DISABLE_EARLY_MAX_ERR:1;     // 2 Disable early max error check
    Uint16 rsvd1:5;                     // 7:3 Reserved
    Uint16 MON_SEL:4;                   // 11:8 Selects type of monitoring
    Uint16 rsvd2:4;                     // 15:12 Reserved
    Uint16 rsvd3:16;                    // 31:16 Reserved
};

union MUNIT_1_CTL_REG {
    Uint32  all;
    struct  MUNIT_1_CTL_BITS  bit;
};

struct MUNIT_1_SHADOW_CTL_BITS {        // bits description
    Uint16 SYNCI_EN:1;                  // 0 Enable for shadowing on Min and Max Registers
    Uint16 SWSYNC:1;                    // 1 SW sync to copy shadow to active Min and Max registers
    Uint16 LOADMODE:1;                  // 2 Load mode
    Uint16 rsvd1:13;                    // 15:3 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union MUNIT_1_SHADOW_CTL_REG {
    Uint32  all;
    struct  MUNIT_1_SHADOW_CTL_BITS  bit;
};

struct MUNIT_2_CTL_BITS {               // bits description
    Uint16 EN:1;                        // 0 Enable bit
    Uint16 DEBUG_RANGE_EN:1;            // 1 Debug enable to aquire the range of check being done
    Uint16 DISABLE_EARLY_MAX_ERR:1;     // 2 Disable early max error check
    Uint16 rsvd1:5;                     // 7:3 Reserved
    Uint16 MON_SEL:4;                   // 11:8 Selects type of monitoring
    Uint16 rsvd2:4;                     // 15:12 Reserved
    Uint16 rsvd3:16;                    // 31:16 Reserved
};

union MUNIT_2_CTL_REG {
    Uint32  all;
    struct  MUNIT_2_CTL_BITS  bit;
};

struct MUNIT_2_SHADOW_CTL_BITS {        // bits description
    Uint16 SYNCI_EN:1;                  // 0 Enable for shadowing on Min and Max Registers
    Uint16 SWSYNC:1;                    // 1 SW sync to copy shadow to active Min and Max registers
    Uint16 LOADMODE:1;                  // 2 Load mode
    Uint16 rsvd1:13;                    // 15:3 Reserved
    Uint16 rsvd2:16;                    // 31:16 Reserved
};

union MUNIT_2_SHADOW_CTL_REG {
    Uint32  all;
    struct  MUNIT_2_SHADOW_CTL_BITS  bit;
};

struct ECAP_SIGNAL_MONITORING {
    union   MUNIT_COMMON_CTL_REG             MUNIT_COMMON_CTL;             // Control registers for monitoring unit {#}
    Uint32                                   rsvd1[15];                    // Reserved
    union   MUNIT_1_CTL_REG                  MUNIT_1_CTL;                  // Control registers for monitoring unit 1
    union   MUNIT_1_SHADOW_CTL_REG           MUNIT_1_SHADOW_CTL;           // Shadow control registers for monitoring unit 1
    Uint32                                   rsvd2[2];                     // Reserved
    Uint32                                   MUNIT_1_MIN;                  // Min value for monitoring unit 1
    Uint32                                   MUNIT_1_MAX;                  // Max value for monitoring unit 1
    Uint32                                   MUNIT_1_MIN_SHADOW;           // Shadow register for Min value of monitoring unit 1
    Uint32                                   MUNIT_1_MAX_SHADOW;           // Shadow register for Max value of monitoring unit 1
    Uint32                                   MUNIT_1_DEBUG_RANGE_MIN;      // Observed Min value of check being enabled on minotoring unit 1
    Uint32                                   MUNIT_1_DEBUG_RANGE_MAX;      // Observed Max value of check being enabled on minotoring unit 1
    Uint32                                   rsvd3[6];                    // Reserved
    union   MUNIT_2_CTL_REG                  MUNIT_2_CTL;                  // Control registers for monitoring unit 2
    union   MUNIT_2_SHADOW_CTL_REG           MUNIT_2_SHADOW_CTL;           // Shadow control registers for monitoring unit 2
    Uint32                                   rsvd4[2];                     // Reserved
    Uint32                                   MUNIT_2_MIN;                  // Min value for monitoring unit 2
    Uint32                                   MUNIT_2_MAX;                  // Max value for monitoring unit 2
    Uint32                                   MUNIT_2_MIN_SHADOW;           // Shadow register for Min value of monitoring unit 2
    Uint32                                   MUNIT_2_MAX_SHADOW;           // Shadow register for Max value of monitoring unit 2
    Uint32                                   MUNIT_2_DEBUG_RANGE_MIN;      // Observed Min value of check being enabled on minotoring unit 2
    Uint32                                   MUNIT_2_DEBUG_RANGE_MAX;      // Observed Max value of check being enabled on minotoring unit 2
};
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// ECAP External References & Function Declarations

extern volatile struct ECAP_REGS ecapRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_ECAP_H definition
