/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
//###########################################################################
//
//  @file    hw_epg.h
//  @brief   Definitions for the EPG registers.
//
//###########################################################################
/* Commit History
 * 20240410,zhengyulong,Compatible with version 2.2.
 * 20250828,yangzhihao,Compatible with version 2.3.
 */

#ifndef REGS_EPG_H
#define REGS_EPG_H

#include "gs32_version.h"
#include "inc/hw_types.h"

#ifdef __cplusplus
extern "C" {
#endif

struct GCTL0_BITS {
	uint32_t	EN:1;			// 0:0
#if (IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30))
	uint32_t	rsvd1:7;			// 7:1	  reserved
#elif (IS_GS32F3xx(0x22) || IS_GS32F3xx(0x23))
	uint32_t	SIGGEN0_EN:1;		// 1:1
	uint32_t	SIGGEN1_EN:1;		// 2:2
	uint32_t	rsvd1:5;			// 7:3    reserved
#endif
	uint32_t	EPGOUT0SEL:1;		// 8:8
	uint32_t	EPGOUT1SEL:1;		// 9:9
	uint32_t	EPGOUT2SEL:1;		// 10:10
	uint32_t	EPGOUT3SEL:1;		// 11:11
	uint32_t	EPGOUT4SEL:1;		// 12:12
	uint32_t	EPGOUT5SEL:1;		// 13:13
	uint32_t	EPGOUT6SEL:1;		// 14:14
	uint32_t	EPGOUT7SEL:1;		// 15:15
	uint32_t	rsvd2:16;			// 31:16
};

union GCTL0_REG {
	uint32_t 		 all;
	struct GCTL0_BITS 		 bit;
};

struct GCTL1_BITS {
	uint32_t	SIGGEN0_CLKSEL:3;	// 2:0
	uint32_t	rsvd1:1;			// 3:3		reserved
	uint32_t	SIGGEN1_CLKSEL:3;	// 6:4
	uint32_t	rsvd2:1;			// 7:7		reserved
	uint32_t	rsvd3:24;			// 31:8		reserved
};

union GCTL1_REG {
	uint32_t 		 all;
	struct GCTL1_BITS 		 bit;
};

struct GCTL2_BITS {
	uint32_t	EPGOUT0_CLKOUTSEL:3;	// 2:0
	uint32_t	rsvd1:1;				// 3:3		reserved
	uint32_t	EPGOUT1_CLKOUTSEL:3;	// 6:4
	uint32_t	rsvd2:1;				// 7:7		reserved
	uint32_t	EPGOUT2_CLKOUTSEL:3;	// 10:8
	uint32_t	rsvd3:1;				// 11:11	reserved
	uint32_t	EPGOUT3_CLKOUTSEL:3;	// 14:12
	uint32_t	rsvd4:1;				// 15:15	reserved
	uint32_t	EPGOUT4_CLKOUTSEL:3;	// 18:16
	uint32_t	rsvd5:1;				// 19:19	reserved
	uint32_t	EPGOUT5_CLKOUTSEL:3;	// 22:20
	uint32_t	rsvd6:1;				// 23:23	reserved
	uint32_t	EPGOUT6_CLKOUTSEL:3;	// 26:24
	uint32_t	rsvd7:1;				// 27:27	reserved
	uint32_t	EPGOUT7_CLKOUTSEL:3;	// 30:28
	uint32_t	rsvd8:1;				// 31:31	reserved
};

union GCTL2_REG {
	uint32_t 		 all;
	struct GCTL2_BITS 		 bit;
};

struct GCTL3_BITS {
	uint32_t	EPGOUT0_SIGOUTSEL:4;	// 3:0
	uint32_t	EPGOUT1_SIGOUTSEL:4;	// 7:4
	uint32_t	EPGOUT2_SIGOUTSEL:4;	// 11:8
	uint32_t	EPGOUT3_SIGOUTSEL:4;	// 15:12
	uint32_t	EPGOUT4_SIGOUTSEL:4;	// 19:16
	uint32_t	EPGOUT5_SIGOUTSEL:4;	// 23:20
	uint32_t	EPGOUT6_SIGOUTSEL:4;	// 27:24
	uint32_t	EPGOUT7_SIGOUTSEL:4;	// 31:28
};

union GCTL3_REG {
	uint32_t 		 all;
	struct GCTL3_BITS 		 bit;
};

struct GINTSTS_BITS {
	uint32_t	INT:1;			// 0:0
	uint32_t	SIGGEN0_DONE:1;		// 1:1
	uint32_t	SIGGEN0_FILL:1;		// 2:2
	uint32_t	SIGGEN1_DONE:1;		// 3:3
	uint32_t	SIGGEN1_FILL:1;		// 4:4
	uint32_t	rsvd2:27;			// 31:5		reserved
};

union GINTSTS_REG {
	uint32_t 		 all;
	struct GINTSTS_BITS 		 bit;
};

struct GINTEN_BITS {
	uint32_t	rsvd1:1;			// 0:0		reserved
	uint32_t	SIGGEN0_DONE:1;		// 1:1
	uint32_t	SIGGEN0_FILL:1;		// 2:2
	uint32_t	SIGGEN1_DONE:1;		// 3:3
	uint32_t	SIGGEN1_FILL:1;		// 4:4
	uint32_t	rsvd2:27;			// 31:5		reserved
};

union GINTEN_REG {
	uint32_t 		 all;
	struct GINTEN_BITS 		 bit;
};

struct GINTCLR_BITS {
	uint32_t	INT:1;			// 0:0
	uint32_t	SIGGEN0_DONE:1;		// 1:1
	uint32_t	SIGGEN0_FILL:1;		// 2:2
	uint32_t	SIGGEN1_DONE:1;		// 3:3
	uint32_t	SIGGEN1_FILL:1;		// 4:4
	uint32_t	rsvd1:27;			// 31:5		reserved
};

union GINTCLR_REG {
	uint32_t 		 all;
	struct GINTCLR_BITS 		 bit;
};

struct GINTFRC_BITS {
	uint32_t	rsvd1:1;			// 0:0		reserved
	uint32_t	SIGGEN0_DONE:1;		// 1:1
	uint32_t	SIGGEN0_FILL:1;		// 2:2
	uint32_t	SIGGEN1_DONE:1;		// 3:3
	uint32_t	SIGGEN1_FILL:1;		// 4:4
	uint32_t	rsvd2:27;			// 31:5		reserved
};

union GINTFRC_REG {
	uint32_t 		 all;
	struct GINTFRC_BITS 		 bit;
};

struct CLKDIV0_CTL0_BITS {
	uint32_t	PRD:8;				// 7:0
	uint32_t	rsvd1:8;			// 15:8		reserved
	uint32_t	CLKSTOP:3;			// 18:16
	uint32_t	rsvd2:13;			// 31:19	reserved
};

union CLKDIV0_CTL0_REG {
	uint32_t 		 all;
	struct CLKDIV0_CTL0_BITS 	 bit;
};

struct CLKDIV0_CLKOFFSET_BITS {
	uint32_t	CLK0OFFSET:8;		// 7:0
	uint32_t	CLK1OFFSET:8;		// 15:8
	uint32_t	CLK2OFFSET:8;		// 23:16
	uint32_t	CLK3OFFSET:8;		// 31:24
};

union CLKDIV0_CLKOFFSET_REG {
	uint32_t 		 all;
	struct CLKDIV0_CLKOFFSET_BITS 	 bit;
};

struct CLKDIV1_CTL0_BITS {
	uint32_t	PRD:8;				// 7:0
	uint32_t	rsvd1:8;			// 15:8		reserved
	uint32_t	CLKSTOP:3;			// 18:16
	uint32_t	rsvd2:13;			// 31:19	reserved
};

union CLKDIV1_CTL0_REG {
	uint32_t 		 all;
	struct CLKDIV1_CTL0_BITS 	 bit;
};

struct CLKDIV1_CLKOFFSET_BITS {
	uint32_t	CLK0OFFSET:8;		// 7:0
	uint32_t	CLK1OFFSET:8;		// 15:8
	uint32_t	CLK2OFFSET:8;		// 23:16
	uint32_t	CLK3OFFSET:8;		// 31:24
};

union CLKDIV1_CLKOFFSET_REG {
	uint32_t 		 all;
	struct CLKDIV1_CLKOFFSET_BITS 	 bit;
};

struct SIGGEN0_CTL0_BITS {
	uint32_t	MODE:4;				// 3:0
	uint32_t	EN:1;				// 4:4
	uint32_t	BRIN:1;				// 5:5
	uint32_t	BROUT:1;			// 6:6
	uint32_t	rsvd1:9;			// 15:7		reserved
	uint32_t	BITLENGTH:8;	    // 23:16
	uint32_t	rsvd2:8;			// 31:24	reserved
};

union SIGGEN0_CTL0_REG {
	uint32_t 		 all;
	struct SIGGEN0_CTL0_BITS 	 bit;
};

struct SIGGEN0_CTL1_BITS {
	uint32_t	DATA0INSEL:4;		// 3:0
	uint32_t	rsvd1:24;			// 27:4		reserved
	uint32_t	DATA63INSEL:4;		// 31:28
};

union SIGGEN0_CTL1_REG {
	uint32_t 		 all;
	struct SIGGEN0_CTL1_BITS 	 bit;
};

struct SIGGEN0_DATA0_BITS {
	uint32_t	DATA0VAL:32;			// 31:0
};

union SIGGEN0_DATA0_REG {
	uint32_t		 all;
	struct SIGGEN0_DATA0_BITS	 bit;
};

struct SIGGEN0_DATA1_BITS {
	uint32_t	DATA0VAL:32;			// 31:0
};

union SIGGEN0_DATA1_REG {
	uint32_t		 all;
	struct SIGGEN0_DATA1_BITS	 bit;
};

struct SIGGEN0_DATA0_ACTIVE_BITS {
	uint32_t	DATA0ACT:32;			// 31:0
};

union SIGGEN0_DATA0_ACTIVE_REG {
	uint32_t		 all;
	struct SIGGEN0_DATA0_ACTIVE_BITS	 bit;
};

struct SIGGEN0_DATA1_ACTIVE_BITS {
	uint32_t	DATA0ACT:32;			// 31:0
};

union SIGGEN0_DATA1_ACTIVE_REG {
	uint32_t		 all;
	struct SIGGEN0_DATA1_ACTIVE_BITS	 bit;
};

struct SIGGEN1_CTL0_BITS {
	uint32_t	MODE:4;				// 3:0
	uint32_t	EN:1;				// 4:4
	uint32_t	BRIN:1;				// 5:5
	uint32_t	BROUT:1;			// 6:6
	uint32_t	rsvd1:9;			// 15:7		reserved
	uint32_t	BTLENGTH:8;			// 23:16
	uint32_t	rsvd2:8;			// 31:24	reserved
};

union SIGGEN1_CTL0_REG {
	uint32_t 		 all;
	struct SIGGEN1_CTL0_BITS 	 bit;
};

struct SIGGEN1_CTL1_BITS {
	uint32_t	DATA0INSEL:4;		// 3:0
	uint32_t	rsvd1:24;			// 27:4		reserved
	uint32_t	DATA63INSEL:4;		// 31:28
};

union SIGGEN1_CTL1_REG {
	uint32_t 		 all;
	struct SIGGEN1_CTL1_BITS 	 bit;
};

struct SIGGEN1_DATA0_BITS {
	uint32_t	DATA0VAL:32;		// 31:0
};

union SIGGEN1_DATA0_REG {
	uint32_t		 all;
	struct SIGGEN1_DATA0_BITS	 bit;
};

struct SIGGEN1_DATA1_BITS {
	uint32_t	DATA0VAL:32;		// 31:0
};

union SIGGEN1_DATA1_REG {
	uint32_t		 all;
	struct SIGGEN1_DATA1_BITS	 bit;
};

struct SIGGEN1_DATA0_ACTIVE_BITS {
	uint32_t	DATA0ACT:32;		// 31:0
};

union SIGGEN1_DATA0_ACTIVE_REG {
	uint32_t		 all;
	struct SIGGEN1_DATA0_ACTIVE_BITS	 bit;
};

struct SIGGEN1_DATA1_ACTIVE_BITS {
	uint32_t	DATA0ACT:32;		// 31:0
};

union SIGGEN1_DATA1_ACTIVE_REG {
	uint32_t		 all;
	struct SIGGEN1_DATA1_ACTIVE_BITS	 bit;
};

#if (IS_GS32F3xx(0x23) || IS_GS32F3xx(0x22))
struct EPGMXSEL0_BITS {
	uint32_t	SEL0:1;				// 0:0
	uint32_t	SEL1:1;				// 1:1
	uint32_t	SEL2:1;				// 2:2
	uint32_t	SEL3:1;				// 3:3
	uint32_t	SEL4:1;				// 4:4
	uint32_t	SEL5:1;				// 5:5
	uint32_t	SEL6:1;				// 6:6
	uint32_t	SEL7:1;				// 7:7
	uint32_t	SEL8:1;				// 8:8
	uint32_t	SEL9:1;				// 9:9
	uint32_t	SEL10:1;			// 10:10
	uint32_t	SEL11:1;			// 11:11
	uint32_t	SEL12:1;			// 12:12
	uint32_t	SEL13:1;			// 13:13
	uint32_t	SEL14:1;			// 14:14
	uint32_t	SEL15:1;			// 15:15
	uint32_t	SEL16:1;			// 16:16
	uint32_t	SEL17:1;			// 17:17
	uint32_t	SEL18:1;			// 18:18
	uint32_t	SEL19:1;			// 19:19
	uint32_t	SEL20:1;			// 20:20
	uint32_t	SEL21:1;			// 21:21
	uint32_t	SEL22:1;			// 22:22
	uint32_t	SEL23:1;			// 23:23
	uint32_t	SEL24:1;			// 24:24
	uint32_t	SEL25:1;			// 25:25
	uint32_t	SEL26:1;			// 26:26
	uint32_t	SEL27:1;			// 27:27
	uint32_t	SEL28:1;			// 28:28
	uint32_t	SEL29:1;			// 29:29
	uint32_t	SEL30:1;			// 30:30
	uint32_t	SEL31:1;			// 31:31
};

union EPGMXSEL0_REG {
	uint32_t		all;
	struct	EPGMXSEL0_BITS		bit;
};

struct EPGMXSEL1_BITS {
	uint32_t	SEL0:1;				// 0:0
	uint32_t	SEL1:1;				// 1:1
	uint32_t	SEL2:1;				// 2:2
	uint32_t	SEL3:1;				// 3:3
	uint32_t	SEL4:1;				// 4:4
	uint32_t	SEL5:1;				// 5:5
	uint32_t	SEL6:1;				// 6:6
	uint32_t	SEL7:1;				// 7:7
	uint32_t	SEL8:1;				// 8:8
	uint32_t	SEL9:1;				// 9:9
	uint32_t	SEL10:1;			// 10:10
	uint32_t	SEL11:1;			// 11:11
	uint32_t	SEL12:1;			// 12:12
	uint32_t	SEL13:1;			// 13:13
	uint32_t	SEL14:1;			// 14:14
	uint32_t	SEL15:1;			// 15:15
	uint32_t	SEL16:1;			// 16:16
	uint32_t	SEL17:1;			// 17:17
	uint32_t	SEL18:1;			// 18:18
	uint32_t	SEL19:1;			// 19:19
	uint32_t	SEL20:1;			// 20:20
	uint32_t	SEL21:1;			// 21:21
	uint32_t	SEL22:1;			// 22:22
	uint32_t	SEL23:1;			// 23:23
	uint32_t	SEL24:1;			// 24:24
	uint32_t	SEL25:1;			// 25:25
	uint32_t	SEL26:1;			// 26:26
	uint32_t	SEL27:1;			// 27:27
	uint32_t	SEL28:1;			// 28:28
	uint32_t	SEL29:1;			// 29:29
	uint32_t	SEL30:1;			// 30:30
	uint32_t	SEL31:1;			// 31:31
};

union EPGMXSEL1_REG {
	uint32_t		all;
	struct	EPGMXSEL1_BITS		bit;
};
#if IS_GS32F3xx(0x23)
struct EPGMXSEL2_BITS {
	uint32_t	SEL0:1;				// 0:0
	uint32_t	SEL1:1;				// 1:1
	uint32_t	SEL2:1;				// 2:2
	uint32_t	SEL3:1;				// 3:3
	uint32_t	SEL4:1;				// 4:4
	uint32_t	SEL5:1;				// 5:5
	uint32_t	SEL6:1;				// 6:6
	uint32_t	SEL7:1;				// 7:7
	uint32_t	SEL8:1;				// 8:8
	uint32_t	SEL9:1;				// 9:9
	uint32_t	SEL10:1;			// 10:10
	uint32_t	SEL11:1;			// 11:11
	uint32_t	SEL12:1;			// 12:12
	uint32_t	SEL13:1;			// 13:13
	uint32_t	SEL14:1;			// 14:14
	uint32_t	SEL15:1;			// 15:15
	uint32_t	SEL16:1;			// 16:16
	uint32_t	SEL17:1;			// 17:17
	uint32_t	SEL18:1;			// 18:18
	uint32_t	SEL19:1;			// 19:19
	uint32_t	SEL20:1;			// 20:20
	uint32_t	SEL21:1;			// 21:21
	uint32_t	SEL22:1;			// 22:22
	uint32_t	SEL23:1;			// 23:23
	uint32_t	SEL24:1;			// 24:24
	uint32_t	SEL25:1;			// 25:25
	uint32_t	SEL26:1;			// 26:26
	uint32_t	SEL27:1;			// 27:27
	uint32_t	SEL28:1;			// 28:28
	uint32_t	SEL29:1;			// 29:29
	uint32_t	SEL30:1;			// 30:30
	uint32_t	SEL31:1;			// 31:31
};

union EPGMXSEL2_REG {
	uint32_t		all;
	struct	EPGMXSEL2_BITS		bit;
};
#endif
#elif (IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30))
struct EPGMXSEL_BITS {
	uint32_t	SEL0:1;				// 0:0
	uint32_t	SEL1:1;				// 1:1
	uint32_t	SEL2:1;				// 2:2
	uint32_t	SEL3:1;				// 3:3
	uint32_t	SEL4:1;				// 4:4
	uint32_t	SEL5:1;				// 5:5
	uint32_t	SEL6:1;				// 6:6
	uint32_t	SEL7:1;				// 7:7
	uint32_t	SEL8:1;				// 8:8
	uint32_t	SEL9:1;				// 9:9
	uint32_t	SEL10:1;			// 10:10
	uint32_t	SEL11:1;			// 11:11
	uint32_t	SEL12:1;			// 12:12
	uint32_t	SEL13:1;			// 13:13
	uint32_t	SEL14:1;			// 14:14
	uint32_t	SEL15:1;			// 15:15
	uint32_t	SEL16:1;			// 16:16
	uint32_t	SEL17:1;			// 17:17
	uint32_t	SEL18:1;			// 18:18
	uint32_t	SEL19:1;			// 19:19
	uint32_t	SEL20:1;			// 20:20
	uint32_t	SEL21:1;			// 21:21
	uint32_t	SEL22:1;			// 22:22
	uint32_t	SEL23:1;			// 23:23
	uint32_t	SEL24:1;			// 24:24
	uint32_t	SEL25:1;			// 25:25
	uint32_t	SEL26:1;			// 26:26
	uint32_t	SEL27:1;			// 27:27
	uint32_t	SEL28:1;			// 28:28
	uint32_t	SEL29:1;			// 29:29
	uint32_t	SEL30:1;			// 30:30
	uint32_t	SEL31:1;			// 31:31
};

union EPGMXSEL_REG {
	uint32_t		all;
	struct	EPGMXSEL_BITS		bit;
};
#endif

/* EPG Register Definitions: */
#if (IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30))
struct EPG_REGS {
    union GCTL0_REG                 GCTL0;
    union GCTL1_REG                 GCTL1;
    union GCTL2_REG                 GCTL2;
    union GCTL3_REG                 GCTL3;
    uint32_t                        EPGLOCK;
    uint32_t                        rsvd1;
    union GINTSTS_REG               GINTSTS;
    union GINTEN_REG                GINTEN;
    union GINTCLR_REG               GINTCLR;
    union GINTFRC_REG               GINTFRC;
    uint32_t                        rsvd2;
    uint32_t                        rsvd3;
    union CLKDIV0_CTL0_REG          CLKDIV0_CTL0;
    uint32_t                        rsvd4;
    uint32_t                        rsvd5;
    union CLKDIV0_CLKOFFSET_REG     CLKDIV0_CLKOFFSET;
    uint32_t                        rsvd6;
    uint32_t                        rsvd7;
    union CLKDIV1_CTL0_REG          CLKDIV1_CTL0;
    uint32_t                        rsvd8;
    uint32_t                        rsvd9;
    union CLKDIV1_CLKOFFSET_REG     CLKDIV1_CLKOFFSET;
    uint32_t                        rsvd10;
    uint32_t                        rsvd11;
    union SIGGEN0_CTL0_REG          SIGGEN0_CTL0;
    union SIGGEN0_CTL1_REG          SIGGEN0_CTL1;
    uint32_t                        rsvd12;
    uint32_t                        rsvd13;
    union SIGGEN0_DATA0_REG         SIGGEN0_DATA0;
    union SIGGEN0_DATA1_REG         SIGGEN0_DATA1;
    union SIGGEN0_DATA0_ACTIVE_REG  SIGGEN0_DATA0_ACTIVE;
    union SIGGEN0_DATA1_ACTIVE_REG  SIGGEN0_DATA1_ACTIVE;
    uint32_t                        rsvd14;
    uint32_t                        rsvd15;
    union SIGGEN1_CTL0_REG          SIGGEN1_CTL0;
    union SIGGEN1_CTL1_REG          SIGGEN1_CTL1;
    uint32_t                        rsvd16;
    uint32_t                        rsvd17;
    union SIGGEN1_DATA0_REG         SIGGEN1_DATA0;
    union SIGGEN1_DATA1_REG         SIGGEN1_DATA1;
    union SIGGEN1_DATA0_ACTIVE_REG  SIGGEN1_DATA0_ACTIVE;
    union SIGGEN1_DATA1_ACTIVE_REG  SIGGEN1_DATA1_ACTIVE;
    uint32_t                        rsvd18;
    uint32_t                        rsvd19;
    uint32_t                        rsvd20;
    uint32_t                        rsvd21;
    uint32_t                        rsvd22;
    uint32_t                        rsvd23;
    uint32_t                        rsvd24;
    uint32_t                        rsvd25;
    uint32_t                        rsvd26;
    uint32_t                        rsvd27;
    union EPGMXSEL_REG              MXSEL0;
};
#elif IS_GS32F3xx(0x22)
struct EPG_REGS {
    union GCTL0_REG                 GCTL0;
    union GCTL1_REG                 GCTL1;
    union GCTL2_REG                 GCTL2;
    union GCTL3_REG                 GCTL3;
    uint32_t                        rsvd1;
    uint32_t                        rsvd2;
    union GINTSTS_REG               GINTSTS;
    union GINTEN_REG                GINTEN;
    union GINTCLR_REG               GINTCLR;
    union GINTFRC_REG               GINTFRC;
    uint32_t                        rsvd3;
    uint32_t                        rsvd4;
    union CLKDIV0_CTL0_REG          CLKDIV0_CTL0;
    uint32_t                        rsvd5;
    uint32_t                        rsvd6;
    union CLKDIV0_CLKOFFSET_REG     CLKDIV0_CLKOFFSET;
    uint32_t                        rsvd7;
    uint32_t                        rsvd8;
    union CLKDIV1_CTL0_REG          CLKDIV1_CTL0;
    uint32_t                        rsvd9;
    uint32_t                        rsvd10;
    union CLKDIV1_CLKOFFSET_REG     CLKDIV1_CLKOFFSET;
    uint32_t                        rsvd11;
    uint32_t                        rsvd12;
    union SIGGEN0_CTL0_REG          SIGGEN0_CTL0;
    union SIGGEN0_CTL1_REG          SIGGEN0_CTL1;
    uint32_t                        rsvd13;
    uint32_t                        rsvd14;
    union SIGGEN0_DATA0_REG         SIGGEN0_DATA0;
    union SIGGEN0_DATA1_REG         SIGGEN0_DATA1;
    union SIGGEN0_DATA0_ACTIVE_REG  SIGGEN0_DATA0_ACTIVE;
    union SIGGEN0_DATA1_ACTIVE_REG  SIGGEN0_DATA1_ACTIVE;
    union SIGGEN1_CTL0_REG          SIGGEN1_CTL0;
    union SIGGEN1_CTL1_REG          SIGGEN1_CTL1;
    uint32_t                        rsvd15;
    uint32_t                        rsvd16;
    union SIGGEN1_DATA0_REG         SIGGEN1_DATA0;
    union SIGGEN1_DATA1_REG         SIGGEN1_DATA1;
    union SIGGEN1_DATA0_ACTIVE_REG  SIGGEN1_DATA0_ACTIVE;
    union SIGGEN1_DATA1_ACTIVE_REG  SIGGEN1_DATA1_ACTIVE;
    uint32_t                        rsvd17;
    uint32_t                        rsvd18;
    uint32_t                        rsvd19;
    uint32_t                        rsvd20;
    uint32_t                        rsvd21;
    uint32_t                        rsvd22;
    uint32_t                        rsvd23;
    uint32_t                        rsvd24;
    uint32_t                        rsvd25;
    uint32_t                        rsvd26;
    uint32_t                        rsvd27;
    uint32_t                        rsvd28;
    union EPGMXSEL0_REG             MXSEL0;
    union EPGMXSEL1_REG             MXSEL1;
    uint32_t                        rsvd29;
    uint32_t                        rsvd30;
    uint32_t                        rsvd31;
    uint32_t                        rsvd32;
    uint32_t                        rsvd33;
    uint32_t                        rsvd34;
    uint32_t                        rsvd35;
    uint32_t                        rsvd36;
    uint32_t                        rsvd37;
    uint32_t                        EPGLOCK;
};
#elif IS_GS32F3xx(0x23)
struct EPG_REGS {
    union GCTL0_REG                 GCTL0;
    union GCTL1_REG                 GCTL1;
    union GCTL2_REG                 GCTL2;
    union GCTL3_REG                 GCTL3;
    uint32_t                        rsvd1;
    uint32_t                        rsvd2;
    union GINTSTS_REG               GINTSTS;
    union GINTEN_REG                GINTEN;
    union GINTCLR_REG               GINTCLR;
    union GINTFRC_REG               GINTFRC;
    uint32_t                        rsvd3;
    uint32_t                        rsvd4;
    union CLKDIV0_CTL0_REG          CLKDIV0_CTL0;
    uint32_t                        rsvd5;
    uint32_t                        rsvd6;
    union CLKDIV0_CLKOFFSET_REG     CLKDIV0_CLKOFFSET;
    uint32_t                        rsvd7;
    uint32_t                        rsvd8;
    union CLKDIV1_CTL0_REG          CLKDIV1_CTL0;
    uint32_t                        rsvd9;
    uint32_t                        rsvd10;
    union CLKDIV1_CLKOFFSET_REG     CLKDIV1_CLKOFFSET;
    uint32_t                        rsvd11;
    uint32_t                        rsvd12;
    union SIGGEN0_CTL0_REG          SIGGEN0_CTL0;
    union SIGGEN0_CTL1_REG          SIGGEN0_CTL1;
    uint32_t                        rsvd13;
    uint32_t                        rsvd14;
    union SIGGEN0_DATA0_REG         SIGGEN0_DATA0;
    union SIGGEN0_DATA1_REG         SIGGEN0_DATA1;
    union SIGGEN0_DATA0_ACTIVE_REG  SIGGEN0_DATA0_ACTIVE;
    union SIGGEN0_DATA1_ACTIVE_REG  SIGGEN0_DATA1_ACTIVE;
    union SIGGEN1_CTL0_REG          SIGGEN1_CTL0;
    union SIGGEN1_CTL1_REG          SIGGEN1_CTL1;
    uint32_t                        rsvd15;
    uint32_t                        rsvd16;
    union SIGGEN1_DATA0_REG         SIGGEN1_DATA0;
    union SIGGEN1_DATA1_REG         SIGGEN1_DATA1;
    union SIGGEN1_DATA0_ACTIVE_REG  SIGGEN1_DATA0_ACTIVE;
    union SIGGEN1_DATA1_ACTIVE_REG  SIGGEN1_DATA1_ACTIVE;
    uint32_t                        rsvd17;
    uint32_t                        rsvd18;
    uint32_t                        rsvd19;
    uint32_t                        rsvd20;
    uint32_t                        rsvd21;
    uint32_t                        rsvd22;
    uint32_t                        rsvd23;
    uint32_t                        rsvd24;
    uint32_t                        rsvd25;
    uint32_t                        rsvd26;
    uint32_t                        rsvd27;
    uint32_t                        rsvd28;
    union EPGMXSEL0_REG             MXSEL0;
    union EPGMXSEL1_REG             MXSEL1;
    union EPGMXSEL2_REG             MXSEL2;
    uint32_t                        rsvd29;
    uint32_t                        rsvd30;
    uint32_t                        rsvd31;
    uint32_t                        rsvd32;
    uint32_t                        rsvd33;
    uint32_t                        rsvd34;
    uint32_t                        rsvd35;
    uint32_t                        rsvd36;
    uint32_t                        EPGLOCK;
};
#endif

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// EPG External References & Function Declarations

extern volatile struct EPG_REGS EpgRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_EPG_H definition

