/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_gpio.h
*   @brief
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_GPIO_V22_H
#define REGS_GPIO_V22_H

#if IS_GS32F3xx(0x22)

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// GPIO Individual Register Bit Definitions:

struct DATA_BITS {			// bits   description
	uint32_t	DATA:16;			// 15:0   Data value [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union DATA_REG {
	uint32_t 		 all;
	struct DATA_BITS 		 bit;
};

struct DATAOUT_BITS {			// bits   description
	uint32_t	DATAOUT:16;			// 15:0   Data output Register value [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union DATAOUT_REG {
	uint32_t 		 all;
	struct DATAOUT_BITS 		 bit;
};

struct OUTENSET_BITS {			// bits   description
	uint32_t	OUTENSET:16;			// 15:0   Output enable set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union OUTENSET_REG {
	uint32_t 		 all;
	struct OUTENSET_BITS 		 bit;
};

struct OUTENCLR_BITS {			// bits   description
	uint32_t	OUTENCLR:16;			// 15:0   Output enable clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union OUTENCLR_REG {
	uint32_t 		 all;
	struct OUTENCLR_BITS 		 bit;
};

struct ALTFUNCSET_BITS {			// bits   description
	uint32_t	ALTFUNCSET:16;			// 15:0   Alternative function set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ALTFUNCSET_REG {
	uint32_t 		 all;
	struct ALTFUNCSET_BITS 		 bit;
};

struct ALTFUNCCLR_BITS {			// bits   description
	uint32_t	ALTFUNCCLR:16;			// 15:0   Alternative function clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union ALTFUNCCLR_REG {
	uint32_t 		 all;
	struct ALTFUNCCLR_BITS 		 bit;
};

struct INTENSET_BITS {			// bits   description
	uint32_t	INTENSET:16;			// 15:0   Interrupt enable set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTENSET_REG {
	uint32_t 		 all;
	struct INTENSET_BITS 		 bit;
};

struct INTENCLR_BITS {			// bits   description
	uint32_t	INTENCLR:16;			// 15:0   Interrupt enable clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTENCLR_REG {
	uint32_t 		 all;
	struct INTENCLR_BITS 		 bit;
};

struct INTTYPESET_BITS {			// bits   description
	uint32_t	INTTYPESET:16;			// 15:0   Interrupt type set [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTTYPESET_REG {
	uint32_t 		 all;
	struct INTTYPESET_BITS 		 bit;
};

struct INTTYPECLR_BITS {			// bits   description
	uint32_t	INTTYPECLR:16;			// 15:0   Interrupt type clear [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTTYPECLR_REG {
	uint32_t 		 all;
	struct INTTYPECLR_BITS 		 bit;
};

struct INTPOLSET_BITS {			// bits   description
	uint32_t	INTPOLSET:16;			// 15:0   Polarity-level, edge IRQ configuration [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTPOLSET_REG {
	uint32_t 		 all;
	struct INTPOLSET_BITS 		 bit;
};

struct INTPOLCLR_BITS {			// bits   description
	uint32_t	INTPOLCLR:16;			// 15:0   Polarity-level, edge IRQ configuration [15:0]
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTPOLCLR_REG {
	uint32_t 		 all;
	struct INTPOLCLR_BITS 		 bit;
};

struct INTSTATUS_CLEAR_BITS {			// bits   description
	uint32_t	INTSTATUS_CLEAR:16;			// 15:0   Write one to clear interrupt request
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union INTSTATUS_CLEAR_REG {
	uint32_t 		 all;
	struct INTSTATUS_CLEAR_BITS 		 bit;
};
//struct INTCLEAR_BITS {			// bits   description
//	uint32_t	INTCLEAR:16;			// 15:0   Write one to clear interrupt request
//	uint32_t	rsvd1:16;			// 31:16   reserved
//};
//
//union INTCLEAR_REG {
//	uint32_t 		 all;
//	struct INTCLEAR_BITS 		 bit;
//};

struct MASKLOWBYTE_BITS {			// bits   description
	uint32_t	MASKLOWBYTE:8;			// 7:0   Lower eight bits masked access.
	uint32_t	RAZ_WI:8;			// 15:8   Not used.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union MASKLOWBYTE_REG {
	uint32_t 		 all;
	struct MASKLOWBYTE_BITS 		 bit;
};

struct MASKHIGHBYTE_BITS {			// bits   description
	uint32_t	RAZ_WI:8;			// 7:0   Not used.
	uint32_t	MASKLOWBYTE:8;			// 15:8   Higher eight bits masked access.
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union MASKHIGHBYTE_REG {
	uint32_t 		 all;
	struct MASKHIGHBYTE_BITS 		 bit;
};


// GPIO Register Definitions:

struct GPIO_REGS {
	union  DATA_REG			DATA;
	union  DATAOUT_REG			DATAOUT;
	uint32_t 						rsvd1[2]; 		 // reserved
	union  OUTENSET_REG			OUTENSET;
	union  OUTENCLR_REG			OUTENCLR;
	union  ALTFUNCSET_REG			ALTFUNCSET;
	union  ALTFUNCCLR_REG			ALTFUNCCLR;
	union  INTENSET_REG			INTENSET;
	union  INTENCLR_REG			INTENCLR;
	union  INTTYPESET_REG			INTTYPESET;
	union  INTTYPECLR_REG			INTTYPECLR;
	union  INTPOLSET_REG			INTPOLSET;
	union  INTPOLCLR_REG			INTPOLCLR;
	union  INTSTATUS_CLEAR_REG		INTSTATUS_CLEAR;
	//union  INTCLEAR_REG			INTCLEAR;
	uint32_t 						rsvd2[241]; 		 // reserved
	union  MASKLOWBYTE_REG			MASKLOWBYTE[16];
	uint32_t 						rsvd3[240]; 		 // reserved
	union  MASKHIGHBYTE_REG			MASKHIGHBYTE[16];
};


/***********************************************************
 * Start definition of virtual GPIO Ctrl registers
 **************************************************************/
//---------------------------------------------------------------------------
// GPIO Individual Register Bit Definitions:

struct GPACTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO0 to GPIO7
    Uint32 QUALPRD0_H:4;                  // 8:4 Qualification sampling period for GPIO0 to GPIO7
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO8 to GPIO15
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO8 to GPIO15
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO16 to GPIO23
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO16 to GPIO23
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO24 to GPIO31
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO24 to GPIO31
};

union GPACTRL_REG {
    Uint32  all;
    struct  GPACTRL_BITS  bit;
};

struct GPAQSEL1_BITS {                  // bits description
    Uint32 GPIO0:2;                     // 1:0 Select input qualification type for GPIO0
    Uint32 GPIO1:2;                     // 3:2 Select input qualification type for GPIO1
    Uint32 GPIO2:2;                     // 5:4 Select input qualification type for GPIO2
    Uint32 GPIO3:2;                     // 7:6 Select input qualification type for GPIO3
    Uint32 GPIO4:2;                     // 9:8 Select input qualification type for GPIO4
    Uint32 GPIO5:2;                     // 11:10 Select input qualification type for GPIO5
    Uint32 GPIO6:2;                     // 13:12 Select input qualification type for GPIO6
    Uint32 GPIO7:2;                     // 15:14 Select input qualification type for GPIO7
    Uint32 GPIO8:2;                     // 17:16 Select input qualification type for GPIO8
    Uint32 GPIO9:2;                     // 19:18 Select input qualification type for GPIO9
    Uint32 GPIO10:2;                    // 21:20 Select input qualification type for GPIO10
    Uint32 GPIO11:2;                    // 23:22 Select input qualification type for GPIO11
    Uint32 GPIO12:2;                    // 25:24 Select input qualification type for GPIO12
    Uint32 GPIO13:2;                    // 27:26 Select input qualification type for GPIO13
    Uint32 GPIO14:2;                    // 29:28 Select input qualification type for GPIO14
    Uint32 GPIO15:2;                    // 31:30 Select input qualification type for GPIO15
};

union GPAQSEL1_REG {
    Uint32  all;
    struct  GPAQSEL1_BITS  bit;
};

struct GPAQSEL2_BITS {                  // bits description
    Uint32 GPIO16:2;                    // 1:0 Select input qualification type for GPIO16
    Uint32 GPIO17:2;                    // 3:2 Select input qualification type for GPIO17
    Uint32 GPIO18:2;                    // 5:4 Select input qualification type for GPIO18
    Uint32 GPIO19:2;                    // 7:6 Select input qualification type for GPIO19
    Uint32 GPIO20:2;                    // 9:8 Select input qualification type for GPIO20
    Uint32 GPIO21:2;                    // 11:10 Select input qualification type for GPIO21
    Uint32 GPIO22:2;                    // 13:12 Select input qualification type for GPIO22
    Uint32 GPIO23:2;                    // 15:14 Select input qualification type for GPIO23
    Uint32 GPIO24:2;                    // 17:16 Select input qualification type for GPIO24
    Uint32 GPIO25:2;                    // 19:18 Select input qualification type for GPIO25
    Uint32 GPIO26:2;                    // 21:20 Select input qualification type for GPIO26
    Uint32 GPIO27:2;                    // 23:22 Select input qualification type for GPIO27
    Uint32 GPIO28:2;                    // 25:24 Select input qualification type for GPIO28
    Uint32 GPIO29:2;                    // 27:26 Select input qualification type for GPIO29
    Uint32 GPIO30:2;                    // 29:28 Select input qualification type for GPIO30
    Uint32 GPIO31:2;                    // 31:30 Select input qualification type for GPIO31
};

union GPAQSEL2_REG {
    Uint32  all;
    struct  GPAQSEL2_BITS  bit;
};

struct GPAMUX1_BITS {                   // bits description
    Uint32 GPIO0:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint32 GPIO1:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint32 GPIO2:2;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint32 GPIO3:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint32 GPIO4:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint32 GPIO5:2;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint32 GPIO6:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint32 GPIO7:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint32 GPIO8:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint32 GPIO9:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint32 GPIO10:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint32 GPIO11:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint32 GPIO12:2;                    // 25:24 Defines pin-muxing selection for GPIO12
    Uint32 GPIO13:2;                    // 27:26 Defines pin-muxing selection for GPIO13
    Uint32 GPIO14:2;                    // 29:28 Defines pin-muxing selection for GPIO14
    Uint32 GPIO15:2;                    // 31:30 Defines pin-muxing selection for GPIO15
};

union GPAMUX1_REG {
    Uint32  all;
    struct  GPAMUX1_BITS  bit;
};

struct GPAMUX2_BITS {                   // bits description
    Uint32 GPIO16:2;                    // 1:0 Defines pin-muxing selection for GPIO16
    Uint32 GPIO17:2;                    // 3:2 Defines pin-muxing selection for GPIO17
    Uint32 GPIO18:2;                    // 5:4 Defines pin-muxing selection for GPIO18
    Uint32 GPIO19:2;                    // 7:6 Defines pin-muxing selection for GPIO19
    Uint32 GPIO20:2;                    // 9:8 Defines pin-muxing selection for GPIO20
    Uint32 GPIO21:2;                    // 11:10 Defines pin-muxing selection for GPIO21
    Uint32 GPIO22:2;                    // 13:12 Defines pin-muxing selection for GPIO22
    Uint32 GPIO23:2;                    // 15:14 Defines pin-muxing selection for GPIO23
    Uint32 GPIO24:2;                    // 17:16 Defines pin-muxing selection for GPIO24
    Uint32 GPIO25:2;                    // 19:18 Defines pin-muxing selection for GPIO25
    Uint32 GPIO26:2;                    // 21:20 Defines pin-muxing selection for GPIO26
    Uint32 GPIO27:2;                    // 23:22 Defines pin-muxing selection for GPIO27
    Uint32 GPIO28:2;                    // 25:24 Defines pin-muxing selection for GPIO28
    Uint32 GPIO29:2;                    // 27:26 Defines pin-muxing selection for GPIO29
    Uint32 GPIO30:2;                    // 29:28 Defines pin-muxing selection for GPIO30
    Uint32 GPIO31:2;                    // 31:30 Defines pin-muxing selection for GPIO31
};

union GPAMUX2_REG {
    Uint32  all;
    struct  GPAMUX2_BITS  bit;
};


struct GPAPUD_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 Pull-Up Disable control for this pin
    Uint32 GPIO1:1;                     // 1 Pull-Up Disable control for this pin
    Uint32 GPIO2:1;                     // 2 Pull-Up Disable control for this pin
    Uint32 GPIO3:1;                     // 3 Pull-Up Disable control for this pin
    Uint32 GPIO4:1;                     // 4 Pull-Up Disable control for this pin
    Uint32 GPIO5:1;                     // 5 Pull-Up Disable control for this pin
    Uint32 GPIO6:1;                     // 6 Pull-Up Disable control for this pin
    Uint32 GPIO7:1;                     // 7 Pull-Up Disable control for this pin
    Uint32 GPIO8:1;                     // 8 Pull-Up Disable control for this pin
    Uint32 GPIO9:1;                     // 9 Pull-Up Disable control for this pin
    Uint32 GPIO10:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO11:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO12:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO13:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO14:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO15:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO16:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO17:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO18:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO19:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO20:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO21:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO22:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO23:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO24:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO25:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO26:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO27:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO28:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO29:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO30:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO31:1;                    // 31 Pull-Up Disable control for this pin
};

union GPAPUD_REG {
    Uint32  all;
    struct  GPAPUD_BITS  bit;
};

struct GPAINV_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 Input inversion control for this pin
    Uint32 GPIO1:1;                     // 1 Input inversion control for this pin
    Uint32 GPIO2:1;                     // 2 Input inversion control for this pin
    Uint32 GPIO3:1;                     // 3 Input inversion control for this pin
    Uint32 GPIO4:1;                     // 4 Input inversion control for this pin
    Uint32 GPIO5:1;                     // 5 Input inversion control for this pin
    Uint32 GPIO6:1;                     // 6 Input inversion control for this pin
    Uint32 GPIO7:1;                     // 7 Input inversion control for this pin
    Uint32 GPIO8:1;                     // 8 Input inversion control for this pin
    Uint32 GPIO9:1;                     // 9 Input inversion control for this pin
    Uint32 GPIO10:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO11:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO12:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO13:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO14:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO15:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO16:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO17:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO18:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO19:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO20:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO21:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO22:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO23:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO24:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO25:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO26:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO27:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO28:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO29:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO30:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO31:1;                    // 31 Input inversion control for this pin
};

union GPAINV_REG {
    Uint32  all;
    struct  GPAINV_BITS  bit;
};



struct GPAGMUX1_BITS {                  // bits description
    Uint32 GPIO0:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint32 GPIO1:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint32 GPIO2:2;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint32 GPIO3:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint32 GPIO4:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint32 GPIO5:2;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint32 GPIO6:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint32 GPIO7:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint32 GPIO8:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint32 GPIO9:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint32 GPIO10:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint32 GPIO11:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint32 GPIO12:2;                    // 25:24 Defines pin-muxing selection for GPIO12
    Uint32 GPIO13:2;                    // 27:26 Defines pin-muxing selection for GPIO13
    Uint32 GPIO14:2;                    // 29:28 Defines pin-muxing selection for GPIO14
    Uint32 GPIO15:2;                    // 31:30 Defines pin-muxing selection for GPIO15
};

union GPAGMUX1_REG {
    Uint32  all;
    struct  GPAGMUX1_BITS  bit;
};

struct GPAGMUX2_BITS {                  // bits description
    Uint32 GPIO16:2;                    // 1:0 Defines pin-muxing selection for GPIO16
    Uint32 GPIO17:2;                    // 3:2 Defines pin-muxing selection for GPIO17
    Uint32 GPIO18:2;                    // 5:4 Defines pin-muxing selection for GPIO18
    Uint32 GPIO19:2;                    // 7:6 Defines pin-muxing selection for GPIO19
    Uint32 GPIO20:2;                    // 9:8 Defines pin-muxing selection for GPIO20
    Uint32 GPIO21:2;                    // 11:10 Defines pin-muxing selection for GPIO21
    Uint32 GPIO22:2;                    // 13:12 Defines pin-muxing selection for GPIO22
    Uint32 GPIO23:2;                    // 15:14 Defines pin-muxing selection for GPIO23
    Uint32 GPIO24:2;                    // 17:16 Defines pin-muxing selection for GPIO24
    Uint32 GPIO25:2;                    // 19:18 Defines pin-muxing selection for GPIO25
    Uint32 GPIO26:2;                    // 21:20 Defines pin-muxing selection for GPIO26
    Uint32 GPIO27:2;                    // 23:22 Defines pin-muxing selection for GPIO27
    Uint32 GPIO28:2;                    // 25:24 Defines pin-muxing selection for GPIO28
    Uint32 GPIO29:2;                    // 27:26 Defines pin-muxing selection for GPIO29
    Uint32 GPIO30:2;                    // 29:28 Defines pin-muxing selection for GPIO30
    Uint32 GPIO31:2;                    // 31:30 Defines pin-muxing selection for GPIO31
};

union GPAGMUX2_REG {
    Uint32  all;
    struct  GPAGMUX2_BITS  bit;
};



struct GPBCTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO32 to GPIO39
    Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO32 to GPIO39
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO40 to GPIO47
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO40 to GPIO47
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO48 to GPIO55
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO48 to GPIO55
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO56 to GPIO63
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO56 to GPIO63
};

union GPBCTRL_REG {
    Uint32  all;
    struct  GPBCTRL_BITS  bit;
};

struct GPBQSEL1_BITS {                  // bits description
    Uint32 GPIO32:2;                    // 1:0 Select input qualification type for GPIO32
    Uint32 GPIO33:2;                    // 3:2 Select input qualification type for GPIO33
    Uint32 GPIO34:2;                    // 5:4 Select input qualification type for GPIO34
    Uint32 GPIO35:2;                    // 7:6 Select input qualification type for GPIO35
    Uint32 GPIO36:2;                    // 9:8 Select input qualification type for GPIO36
    Uint32 GPIO37:2;                    // 11:10 Select input qualification type for GPIO37
    Uint32 GPIO38:2;                    // 13:12 Select input qualification type for GPIO38
    Uint32 GPIO39:2;                    // 15:14 Select input qualification type for GPIO39
    Uint32 GPIO40:2;                    // 17:16 Select input qualification type for GPIO40
    Uint32 GPIO41:2;                    // 19:18 Select input qualification type for GPIO41
    Uint32 GPIO42:2;                    // 21:20 Select input qualification type for GPIO42
    Uint32 GPIO43:2;                    // 23:22 Select input qualification type for GPIO43
    Uint32 GPIO44:2;                    // 25:24 Select input qualification type for GPIO44
    Uint32 GPIO45:2;                    // 27:26 Select input qualification type for GPIO45
    Uint32 GPIO46:2;                    // 29:28 Select input qualification type for GPIO46
    Uint32 GPIO47:2;                    // 31:30 Select input qualification type for GPIO47
};

union GPBQSEL1_REG {
    Uint32  all;
    struct  GPBQSEL1_BITS  bit;
};

struct GPBQSEL2_BITS {                  // bits description
    Uint32 GPIO48:2;                    // 1:0 Select input qualification type for GPIO48
    Uint32 GPIO49:2;                    // 3:2 Select input qualification type for GPIO49
    Uint32 GPIO50:2;                    // 5:4 Select input qualification type for GPIO50
    Uint32 GPIO51:2;                    // 7:6 Select input qualification type for GPIO51
    Uint32 GPIO52:2;                    // 9:8 Select input qualification type for GPIO52
    Uint32 GPIO53:2;                    // 11:10 Select input qualification type for GPIO53
    Uint32 GPIO54:2;                    // 13:12 Select input qualification type for GPIO54
    Uint32 GPIO55:2;                    // 15:14 Select input qualification type for GPIO55
    Uint32 GPIO56:2;                    // 17:16 Select input qualification type for GPIO56
    Uint32 GPIO57:2;                    // 19:18 Select input qualification type for GPIO57
    Uint32 GPIO58:2;                    // 21:20 Select input qualification type for GPIO58
    Uint32 GPIO59:2;                    // 23:22 Select input qualification type for GPIO59
    Uint32 GPIO60:2;                    // 25:24 Select input qualification type for GPIO60
    Uint32 GPIO61:2;                    // 27:26 Select input qualification type for GPIO61
    Uint32 GPIO62:2;                    // 29:28 Select input qualification type for GPIO62
    Uint32 GPIO63:2;                    // 31:30 Select input qualification type for GPIO63
};

union GPBQSEL2_REG {
    Uint32  all;
    struct  GPBQSEL2_BITS  bit;
};

struct GPBMUX1_BITS {                   // bits description
    Uint32 GPIO32:2;                    // 1:0 Defines pin-muxing selection for GPIO32
    Uint32 GPIO33:2;                    // 3:2 Defines pin-muxing selection for GPIO33
    Uint32 GPIO34:2;                    // 5:4 Defines pin-muxing selection for GPIO34
    Uint32 GPIO35:2;                    // 7:6 Defines pin-muxing selection for GPIO35
    Uint32 GPIO36:2;                    // 9:8 Defines pin-muxing selection for GPIO36
    Uint32 GPIO37:2;                    // 11:10 Defines pin-muxing selection for GPIO37
    Uint32 GPIO38:2;                    // 13:12 Defines pin-muxing selection for GPIO38
    Uint32 GPIO39:2;                    // 15:14 Defines pin-muxing selection for GPIO39
    Uint32 GPIO40:2;                    // 17:16 Defines pin-muxing selection for GPIO40
    Uint32 GPIO41:2;                    // 19:18 Defines pin-muxing selection for GPIO41
    Uint32 GPIO42:2;                    // 21:20 Defines pin-muxing selection for GPIO42
    Uint32 GPIO43:2;                    // 23:22 Defines pin-muxing selection for GPIO43
    Uint32 GPIO44:2;                    // 25:24 Defines pin-muxing selection for GPIO44
    Uint32 GPIO45:2;                    // 27:26 Defines pin-muxing selection for GPIO45
    Uint32 GPIO46:2;                    // 29:28 Defines pin-muxing selection for GPIO46
    Uint32 GPIO47:2;                    // 31:30 Defines pin-muxing selection for GPIO47
};

union GPBMUX1_REG {
    Uint32  all;
    struct  GPBMUX1_BITS  bit;
};

struct GPBMUX2_BITS {                   // bits description
    Uint32 GPIO48:2;                    // 1:0 Defines pin-muxing selection for GPIO48
    Uint32 GPIO49:2;                    // 3:2 Defines pin-muxing selection for GPIO49
    Uint32 GPIO50:2;                    // 5:4 Defines pin-muxing selection for GPIO50
    Uint32 GPIO51:2;                    // 7:6 Defines pin-muxing selection for GPIO51
    Uint32 GPIO52:2;                    // 9:8 Defines pin-muxing selection for GPIO52
    Uint32 GPIO53:2;                    // 11:10 Defines pin-muxing selection for GPIO53
    Uint32 GPIO54:2;                    // 13:12 Defines pin-muxing selection for GPIO54
    Uint32 GPIO55:2;                    // 15:14 Defines pin-muxing selection for GPIO55
    Uint32 GPIO56:2;                    // 17:16 Defines pin-muxing selection for GPIO56
    Uint32 GPIO57:2;                    // 19:18 Defines pin-muxing selection for GPIO57
    Uint32 GPIO58:2;                    // 21:20 Defines pin-muxing selection for GPIO58
    Uint32 GPIO59:2;                    // 23:22 Defines pin-muxing selection for GPIO59
    Uint32 GPIO60:2;                    // 25:24 Defines pin-muxing selection for GPIO60
    Uint32 GPIO61:2;                    // 27:26 Defines pin-muxing selection for GPIO61
    Uint32 GPIO62:2;                    // 29:28 Defines pin-muxing selection for GPIO62
    Uint32 GPIO63:2;                    // 31:30 Defines pin-muxing selection for GPIO63
};

union GPBMUX2_REG {
    Uint32  all;
    struct  GPBMUX2_BITS  bit;
};


struct GPBPUD_BITS {                    // bits description
    Uint32 GPIO32:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO33:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO34:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO35:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO36:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO37:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO38:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO39:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO40:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO41:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO42:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO43:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO44:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO45:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO46:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO47:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO48:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO49:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO50:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO51:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO52:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO53:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO54:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO55:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO56:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO57:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO58:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO59:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO60:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO61:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO62:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO63:1;                    // 31 Pull-Up Disable control for this pin
};

union GPBPUD_REG {
    Uint32  all;
    struct  GPBPUD_BITS  bit;
};

struct GPBINV_BITS {                    // bits description
    Uint32 GPIO32:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO33:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO34:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO35:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO36:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO37:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO38:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO39:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO40:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO41:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO42:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO43:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO44:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO45:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO46:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO47:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO48:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO49:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO50:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO51:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO52:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO53:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO54:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO55:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO56:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO57:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO58:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO59:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO60:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO61:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO62:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO63:1;                    // 31 Input inversion control for this pin
};

union GPBINV_REG {
    Uint32  all;
    struct  GPBINV_BITS  bit;
};

struct GPBAMSEL_BITS {                    // bits description

	Uint32 rsvd1:10;                    // 9:0 Reserved
    Uint32 GPIO42:1;                    // 10  Analog Mode Select for GPIO42
    Uint32 GPIO43:1;                    // 11  Analog Mode Select for GPIO43
    Uint32 rsvd2:20;                    // 31:12 Reserved
};

union GPBAMSEL_REG {
    Uint32  all;
    struct  GPBAMSEL_BITS  bit;
};


struct GPBGMUX1_BITS {                  // bits description
    Uint32 GPIO32:2;                    // 1:0 Defines pin-muxing selection for GPIO32
    Uint32 GPIO33:2;                    // 3:2 Defines pin-muxing selection for GPIO33
    Uint32 GPIO34:2;                    // 5:4 Defines pin-muxing selection for GPIO34
    Uint32 GPIO35:2;                    // 7:6 Defines pin-muxing selection for GPIO35
    Uint32 GPIO36:2;                    // 9:8 Defines pin-muxing selection for GPIO36
    Uint32 GPIO37:2;                    // 11:10 Defines pin-muxing selection for GPIO37
    Uint32 GPIO38:2;                    // 13:12 Defines pin-muxing selection for GPIO38
    Uint32 GPIO39:2;                    // 15:14 Defines pin-muxing selection for GPIO39
    Uint32 GPIO40:2;                    // 17:16 Defines pin-muxing selection for GPIO40
    Uint32 GPIO41:2;                    // 19:18 Defines pin-muxing selection for GPIO41
    Uint32 GPIO42:2;                    // 21:20 Defines pin-muxing selection for GPIO42
    Uint32 GPIO43:2;                    // 23:22 Defines pin-muxing selection for GPIO43
    Uint32 GPIO44:2;                    // 25:24 Defines pin-muxing selection for GPIO44
    Uint32 GPIO45:2;                    // 27:26 Defines pin-muxing selection for GPIO45
    Uint32 GPIO46:2;                    // 29:28 Defines pin-muxing selection for GPIO46
    Uint32 GPIO47:2;                    // 31:30 Defines pin-muxing selection for GPIO47
};

union GPBGMUX1_REG {
    Uint32  all;
    struct  GPBGMUX1_BITS  bit;
};

struct GPBGMUX2_BITS {                  // bits description
    Uint32 GPIO48:2;                    // 1:0 Defines pin-muxing selection for GPIO48
    Uint32 GPIO49:2;                    // 3:2 Defines pin-muxing selection for GPIO49
    Uint32 GPIO50:2;                    // 5:4 Defines pin-muxing selection for GPIO50
    Uint32 GPIO51:2;                    // 7:6 Defines pin-muxing selection for GPIO51
    Uint32 GPIO52:2;                    // 9:8 Defines pin-muxing selection for GPIO52
    Uint32 GPIO53:2;                    // 11:10 Defines pin-muxing selection for GPIO53
    Uint32 GPIO54:2;                    // 13:12 Defines pin-muxing selection for GPIO54
    Uint32 GPIO55:2;                    // 15:14 Defines pin-muxing selection for GPIO55
    Uint32 GPIO56:2;                    // 17:16 Defines pin-muxing selection for GPIO56
    Uint32 GPIO57:2;                    // 19:18 Defines pin-muxing selection for GPIO57
    Uint32 GPIO58:2;                    // 21:20 Defines pin-muxing selection for GPIO58
    Uint32 GPIO59:2;                    // 23:22 Defines pin-muxing selection for GPIO59
    Uint32 GPIO60:2;                    // 25:24 Defines pin-muxing selection for GPIO60
    Uint32 GPIO61:2;                    // 27:26 Defines pin-muxing selection for GPIO61
    Uint32 GPIO62:2;                    // 29:28 Defines pin-muxing selection for GPIO62
    Uint32 GPIO63:2;                    // 31:30 Defines pin-muxing selection for GPIO63
};

union GPBGMUX2_REG {
    Uint32  all;
    struct  GPBGMUX2_BITS  bit;
};










struct GPCCTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO0 to GPIO7
    Uint32 QUALPRD0_H:4;                  // 8:4 Qualification sampling period for GPIO0 to GPIO7
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO8 to GPIO79
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO8 to GPIO79
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO80 to GPIO87
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO80 to GPIO87
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO88 to GPIO95
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO88 to GPIO95
};

union GPCCTRL_REG {
    Uint32  all;
    struct  GPCCTRL_BITS  bit;
};

struct GPCQSEL1_BITS {                  // bits description
    Uint32 GPIO64:2;                     // 1:0 Select input qualification type for GPIO0
    Uint32 GPIO65:2;                     // 3:2 Select input qualification type for GPIO1
    Uint32 GPIO66:2;                     // 5:4 Select input qualification type for GPIO2
    Uint32 GPIO67:2;                     // 7:6 Select input qualification type for GPIO3
    Uint32 GPIO68:2;                     // 9:8 Select input qualification type for GPIO4
    Uint32 GPIO69:2;                     // 11:10 Select input qualification type for GPIO5
    Uint32 GPIO70:2;                     // 13:12 Select input qualification type for GPIO6
    Uint32 GPIO71:2;                     // 15:14 Select input qualification type for GPIO7
    Uint32 GPIO72:2;                     // 17:16 Select input qualification type for GPIO8
    Uint32 GPIO73:2;                     // 19:18 Select input qualification type for GPIO9
    Uint32 GPIO74:2;                    // 21:20 Select input qualification type for GPIO10
    Uint32 GPIO75:2;                    // 23:22 Select input qualification type for GPIO11
    Uint32 GPIO76:2;                    // 25:24 Select input qualification type for GPIO76
    Uint32 GPIO77:2;                    // 27:26 Select input qualification type for GPIO77
    Uint32 GPIO78:2;                    // 29:28 Select input qualification type for GPIO78
    Uint32 GPIO79:2;                    // 31:30 Select input qualification type for GPIO79
};

union GPCQSEL1_REG {
    Uint32  all;
    struct  GPCQSEL1_BITS  bit;
};

struct GPCQSEL2_BITS {                  // bits description
    Uint32 GPIO80:2;                    // 1:0 Select input qualification type for GPIO80
    Uint32 GPIO81:2;                    // 3:2 Select input qualification type for GPIO81
    Uint32 GPIO82:2;                    // 5:4 Select input qualification type for GPIO82
    Uint32 GPIO83:2;                    // 7:6 Select input qualification type for GPIO83
    Uint32 GPIO84:2;                    // 9:8 Select input qualification type for GPIO84
    Uint32 GPIO85:2;                    // 11:10 Select input qualification type for GPIO85
    Uint32 GPIO86:2;                    // 13:12 Select input qualification type for GPIO86
    Uint32 GPIO87:2;                    // 15:14 Select input qualification type for GPIO87
    Uint32 GPIO88:2;                    // 17:16 Select input qualification type for GPIO88
    Uint32 GPIO89:2;                    // 19:18 Select input qualification type for GPIO89
    Uint32 GPIO90:2;                    // 21:20 Select input qualification type for GPIO90
    Uint32 GPIO91:2;                    // 23:22 Select input qualification type for GPIO91
    Uint32 GPIO92:2;                    // 25:24 Select input qualification type for GPIO92
    Uint32 GPIO93:2;                    // 27:26 Select input qualification type for GPIO93
    Uint32 GPIO94:2;                    // 29:28 Select input qualification type for GPIO94
    Uint32 GPIO95:2;                    // 31:30 Select input qualification type for GPIO95
};

union GPCQSEL2_REG {
    Uint32  all;
    struct  GPCQSEL2_BITS  bit;
};

struct GPCMUX1_BITS {                   // bits description
    Uint32 GPIO64:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint32 GPIO65:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint32 GPIO66:2;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint32 GPIO67:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint32 GPIO68:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint32 GPIO69:2;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint32 GPIO70:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint32 GPIO71:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint32 GPIO72:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint32 GPIO73:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint32 GPIO74:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint32 GPIO75:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint32 GPIO76:2;                    // 25:24 Defines pin-muxing selection for GPIO76
    Uint32 GPIO77:2;                    // 27:26 Defines pin-muxing selection for GPIO77
    Uint32 GPIO78:2;                    // 29:28 Defines pin-muxing selection for GPIO78
    Uint32 GPIO79:2;                    // 31:30 Defines pin-muxing selection for GPIO79
};

union GPCMUX1_REG {
    Uint32  all;
    struct  GPCMUX1_BITS  bit;
};

struct GPCMUX2_BITS {                   // bits description
    Uint32 GPIO80:2;                    // 1:0 Defines pin-muxing selection for GPIO80
    Uint32 GPIO81:2;                    // 3:2 Defines pin-muxing selection for GPIO81
    Uint32 GPIO82:2;                    // 5:4 Defines pin-muxing selection for GPIO82
    Uint32 GPIO83:2;                    // 7:6 Defines pin-muxing selection for GPIO83
    Uint32 GPIO84:2;                    // 9:8 Defines pin-muxing selection for GPIO84
    Uint32 GPIO85:2;                    // 11:10 Defines pin-muxing selection for GPIO85
    Uint32 GPIO86:2;                    // 13:12 Defines pin-muxing selection for GPIO86
    Uint32 GPIO87:2;                    // 15:14 Defines pin-muxing selection for GPIO87
    Uint32 GPIO88:2;                    // 17:16 Defines pin-muxing selection for GPIO88
    Uint32 GPIO89:2;                    // 19:18 Defines pin-muxing selection for GPIO89
    Uint32 GPIO90:2;                    // 21:20 Defines pin-muxing selection for GPIO90
    Uint32 GPIO91:2;                    // 23:22 Defines pin-muxing selection for GPIO91
    Uint32 GPIO92:2;                    // 25:24 Defines pin-muxing selection for GPIO92
    Uint32 GPIO93:2;                    // 27:26 Defines pin-muxing selection for GPIO93
    Uint32 GPIO94:2;                    // 29:28 Defines pin-muxing selection for GPIO94
    Uint32 GPIO95:2;                    // 31:30 Defines pin-muxing selection for GPIO95
};

union GPCMUX2_REG {
    Uint32  all;
    struct  GPCMUX2_BITS  bit;
};


struct GPCPUD_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Pull-Up Disable control for this pin
    Uint32 GPIO65:1;                     // 1 Pull-Up Disable control for this pin
    Uint32 GPIO66:1;                     // 2 Pull-Up Disable control for this pin
    Uint32 GPIO67:1;                     // 3 Pull-Up Disable control for this pin
    Uint32 GPIO68:1;                     // 4 Pull-Up Disable control for this pin
    Uint32 GPIO69:1;                     // 5 Pull-Up Disable control for this pin
    Uint32 GPIO70:1;                     // 6 Pull-Up Disable control for this pin
    Uint32 GPIO71:1;                     // 7 Pull-Up Disable control for this pin
    Uint32 GPIO72:1;                     // 8 Pull-Up Disable control for this pin
    Uint32 GPIO73:1;                     // 9 Pull-Up Disable control for this pin
    Uint32 GPIO74:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO75:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO76:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO77:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO78:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO79:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO80:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO81:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO82:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO83:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO84:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO85:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO86:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO87:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO88:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO89:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO90:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO91:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO92:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO93:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO94:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO95:1;                    // 31 Pull-Up Disable control for this pin
};

union GPCPUD_REG {
    Uint32  all;
    struct  GPCPUD_BITS  bit;
};

struct GPCINV_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Input inversion control for this pin
    Uint32 GPIO65:1;                     // 1 Input inversion control for this pin
    Uint32 GPIO66:1;                     // 2 Input inversion control for this pin
    Uint32 GPIO67:1;                     // 3 Input inversion control for this pin
    Uint32 GPIO68:1;                     // 4 Input inversion control for this pin
    Uint32 GPIO69:1;                     // 5 Input inversion control for this pin
    Uint32 GPIO70:1;                     // 6 Input inversion control for this pin
    Uint32 GPIO71:1;                     // 7 Input inversion control for this pin
    Uint32 GPIO72:1;                     // 8 Input inversion control for this pin
    Uint32 GPIO73:1;                     // 9 Input inversion control for this pin
    Uint32 GPIO74:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO75:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO76:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO77:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO78:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO79:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO80:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO81:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO82:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO83:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO84:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO85:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO86:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO87:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO88:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO89:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO90:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO91:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO92:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO93:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO94:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO95:1;                    // 31 Input inversion control for this pin
};

union GPCINV_REG {
    Uint32  all;
    struct  GPCINV_BITS  bit;
};



struct GPCGMUX1_BITS {                  // bits description
    Uint32 GPIO64:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint32 GPIO65:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint32 GPIO66:2;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint32 GPIO67:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint32 GPIO68:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint32 GPIO69:2;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint32 GPIO70:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint32 GPIO71:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint32 GPIO72:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint32 GPIO73:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint32 GPIO74:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint32 GPIO75:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint32 GPIO76:2;                    // 25:24 Defines pin-muxing selection for GPIO76
    Uint32 GPIO77:2;                    // 27:26 Defines pin-muxing selection for GPIO77
    Uint32 GPIO78:2;                    // 29:28 Defines pin-muxing selection for GPIO78
    Uint32 GPIO79:2;                    // 31:30 Defines pin-muxing selection for GPIO79
};

union GPCGMUX1_REG {
    Uint32  all;
    struct  GPCGMUX1_BITS  bit;
};

struct GPCGMUX2_BITS {                  // bits description
    Uint32 GPIO80:2;                    // 1:0 Defines pin-muxing selection for GPIO80
    Uint32 GPIO81:2;                    // 3:2 Defines pin-muxing selection for GPIO81
    Uint32 GPIO82:2;                    // 5:4 Defines pin-muxing selection for GPIO82
    Uint32 GPIO83:2;                    // 7:6 Defines pin-muxing selection for GPIO83
    Uint32 GPIO84:2;                    // 9:8 Defines pin-muxing selection for GPIO84
    Uint32 GPIO85:2;                    // 11:10 Defines pin-muxing selection for GPIO85
    Uint32 GPIO86:2;                    // 13:12 Defines pin-muxing selection for GPIO86
    Uint32 GPIO87:2;                    // 15:14 Defines pin-muxing selection for GPIO87
    Uint32 GPIO88:2;                    // 17:16 Defines pin-muxing selection for GPIO88
    Uint32 GPIO89:2;                    // 19:18 Defines pin-muxing selection for GPIO89
    Uint32 GPIO90:2;                    // 21:20 Defines pin-muxing selection for GPIO90
    Uint32 GPIO91:2;                    // 23:22 Defines pin-muxing selection for GPIO91
    Uint32 GPIO92:2;                    // 25:24 Defines pin-muxing selection for GPIO92
    Uint32 GPIO93:2;                    // 27:26 Defines pin-muxing selection for GPIO93
    Uint32 GPIO94:2;                    // 29:28 Defines pin-muxing selection for GPIO94
    Uint32 GPIO95:2;                    // 31:30 Defines pin-muxing selection for GPIO95
};

union GPCGMUX2_REG {
    Uint32  all;
    struct  GPCGMUX2_BITS  bit;
};









struct GPDCTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO96 to GPIO103
    Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO96 to GPIO103
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO104 to GPIO111
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO104 to GPIO111
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO112 to GPIO119
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO112 to GPIO119
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO120 to GPIO127
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO120 to GPIO127
};

union GPDCTRL_REG {
    Uint32  all;
    struct  GPDCTRL_BITS  bit;
};

struct GPDQSEL1_BITS {                  // bits description
    Uint32 GPIO96:2;                    // 1:0 Select input qualification type for GPIO96
    Uint32 GPIO97:2;                    // 3:2 Select input qualification type for GPIO97
    Uint32 GPIO98:2;                    // 5:4 Select input qualification type for GPIO98
    Uint32 GPIO99:2;                    // 7:6 Select input qualification type for GPIO99
    Uint32 GPIO100:2;                    // 9:8 Select input qualification type for GPIO100
    Uint32 GPIO101:2;                    // 11:10 Select input qualification type for GPIO101
    Uint32 GPIO102:2;                    // 13:12 Select input qualification type for GPIO102
    Uint32 GPIO103:2;                    // 15:14 Select input qualification type for GPIO103
    Uint32 GPIO104:2;                    // 17:16 Select input qualification type for GPIO104
    Uint32 GPIO105:2;                    // 19:18 Select input qualification type for GPIO105
    Uint32 GPIO106:2;                    // 21:20 Select input qualification type for GPIO106
    Uint32 GPIO107:2;                    // 23:22 Select input qualification type for GPIO107
    Uint32 GPIO108:2;                    // 25:24 Select input qualification type for GPIO108
    Uint32 GPIO109:2;                    // 27:26 Select input qualification type for GPIO109
    Uint32 GPIO110:2;                    // 29:28 Select input qualification type for GPIO110
    Uint32 GPIO111:2;                    // 31:30 Select input qualification type for GPIO111
};

union GPDQSEL1_REG {
    Uint32  all;
    struct  GPDQSEL1_BITS  bit;
};

struct GPDQSEL2_BITS {                  // bits description
    Uint32 GPIO112:2;                    // 1:0 Select input qualification type for GPIO112
    Uint32 GPIO113:2;                    // 3:2 Select input qualification type for GPIO113
    Uint32 GPIO114:2;                    // 5:4 Select input qualification type for GPIO114
    Uint32 GPIO115:2;                    // 7:6 Select input qualification type for GPIO115
    Uint32 GPIO116:2;                    // 9:8 Select input qualification type for GPIO116
    Uint32 GPIO117:2;                    // 11:10 Select input qualification type for GPIO117
    Uint32 GPIO118:2;                    // 13:12 Select input qualification type for GPIO118
    Uint32 GPIO119:2;                    // 15:14 Select input qualification type for GPIO119
    Uint32 GPIO120:2;                    // 17:16 Select input qualification type for GPIO120
    Uint32 GPIO121:2;                    // 19:18 Select input qualification type for GPIO121
    Uint32 GPIO122:2;                    // 21:20 Select input qualification type for GPIO122
    Uint32 GPIO123:2;                    // 23:22 Select input qualification type for GPIO123
    Uint32 GPIO124:2;                    // 25:24 Select input qualification type for GPIO124
    Uint32 GPIO125:2;                    // 27:26 Select input qualification type for GPIO125
    Uint32 GPIO126:2;                    // 29:28 Select input qualification type for GPIO126
    Uint32 GPIO127:2;                    // 31:30 Select input qualification type for GPIO127
};

union GPDQSEL2_REG {
    Uint32  all;
    struct  GPDQSEL2_BITS  bit;
};

struct GPDMUX1_BITS {                   // bits description
    Uint32 GPIO96:2;                    // 1:0 Defines pin-muxing selection for GPIO96
    Uint32 GPIO97:2;                    // 3:2 Defines pin-muxing selection for GPIO97
    Uint32 GPIO98:2;                    // 5:4 Defines pin-muxing selection for GPIO98
    Uint32 GPIO99:2;                    // 7:6 Defines pin-muxing selection for GPIO99
    Uint32 GPIO100:2;                    // 9:8 Defines pin-muxing selection for GPIO100
    Uint32 GPIO101:2;                    // 11:10 Defines pin-muxing selection for GPIO101
    Uint32 GPIO102:2;                    // 13:12 Defines pin-muxing selection for GPIO102
    Uint32 GPIO103:2;                    // 15:14 Defines pin-muxing selection for GPIO103
    Uint32 GPIO104:2;                    // 17:16 Defines pin-muxing selection for GPIO104
    Uint32 GPIO105:2;                    // 19:18 Defines pin-muxing selection for GPIO105
    Uint32 GPIO106:2;                    // 21:20 Defines pin-muxing selection for GPIO106
    Uint32 GPIO107:2;                    // 23:22 Defines pin-muxing selection for GPIO107
    Uint32 GPIO108:2;                    // 25:24 Defines pin-muxing selection for GPIO108
    Uint32 GPIO109:2;                    // 27:26 Defines pin-muxing selection for GPIO109
    Uint32 GPIO110:2;                    // 29:28 Defines pin-muxing selection for GPIO110
    Uint32 GPIO111:2;                    // 31:30 Defines pin-muxing selection for GPIO111
};

union GPDMUX1_REG {
    Uint32  all;
    struct  GPDMUX1_BITS  bit;
};

struct GPDMUX2_BITS {                   // bits description
    Uint32 GPIO112:2;                    // 1:0 Defines pin-muxing selection for GPIO112
    Uint32 GPIO113:2;                    // 3:2 Defines pin-muxing selection for GPIO113
    Uint32 GPIO114:2;                    // 5:4 Defines pin-muxing selection for GPIO114
    Uint32 GPIO115:2;                    // 7:6 Defines pin-muxing selection for GPIO115
    Uint32 GPIO116:2;                    // 9:8 Defines pin-muxing selection for GPIO116
    Uint32 GPIO117:2;                    // 11:10 Defines pin-muxing selection for GPIO117
    Uint32 GPIO118:2;                    // 13:12 Defines pin-muxing selection for GPIO118
    Uint32 GPIO119:2;                    // 15:14 Defines pin-muxing selection for GPIO119
    Uint32 GPIO120:2;                    // 17:16 Defines pin-muxing selection for GPIO120
    Uint32 GPIO121:2;                    // 19:18 Defines pin-muxing selection for GPIO121
    Uint32 GPIO122:2;                    // 21:20 Defines pin-muxing selection for GPIO122
    Uint32 GPIO123:2;                    // 23:22 Defines pin-muxing selection for GPIO123
    Uint32 GPIO124:2;                    // 25:24 Defines pin-muxing selection for GPIO124
    Uint32 GPIO125:2;                    // 27:26 Defines pin-muxing selection for GPIO125
    Uint32 GPIO126:2;                    // 29:28 Defines pin-muxing selection for GPIO126
    Uint32 GPIO127:2;                    // 31:30 Defines pin-muxing selection for GPIO127
};

union GPDMUX2_REG {
    Uint32  all;
    struct  GPDMUX2_BITS  bit;
};


struct GPDPUD_BITS {                    // bits description
    Uint32 GPIO96:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO97:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO98:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO99:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO100:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO101:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO102:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO103:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO104:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO105:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO106:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO107:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO108:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO109:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO110:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO111:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO112:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO113:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO114:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO115:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO116:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO117:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO118:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO119:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO120:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO121:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO122:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO123:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO124:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO125:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO126:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO127:1;                    // 31 Pull-Up Disable control for this pin
};

union GPDPUD_REG {
    Uint32  all;
    struct  GPDPUD_BITS  bit;
};

struct GPDINV_BITS {                    // bits description
    Uint32 GPIO96:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO97:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO98:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO99:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO100:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO101:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO102:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO103:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO104:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO105:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO106:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO107:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO108:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO109:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO110:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO111:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO112:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO113:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO114:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO115:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO116:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO117:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO118:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO119:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO120:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO121:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO122:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO123:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO124:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO125:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO126:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO127:1;                    // 31 Input inversion control for this pin
};

union GPDINV_REG {
    Uint32  all;
    struct  GPDINV_BITS  bit;
};


struct GPDGMUX1_BITS {                  // bits description
    Uint32 GPIO96:2;                    // 1:0 Defines pin-muxing selection for GPIO96
    Uint32 GPIO97:2;                    // 3:2 Defines pin-muxing selection for GPIO97
    Uint32 GPIO98:2;                    // 5:4 Defines pin-muxing selection for GPIO98
    Uint32 GPIO99:2;                    // 7:6 Defines pin-muxing selection for GPIO99
    Uint32 GPIO100:2;                    // 9:8 Defines pin-muxing selection for GPIO100
    Uint32 GPIO101:2;                    // 11:10 Defines pin-muxing selection for GPIO101
    Uint32 GPIO102:2;                    // 13:12 Defines pin-muxing selection for GPIO102
    Uint32 GPIO103:2;                    // 15:14 Defines pin-muxing selection for GPIO103
    Uint32 GPIO104:2;                    // 17:16 Defines pin-muxing selection for GPIO104
    Uint32 GPIO105:2;                    // 19:18 Defines pin-muxing selection for GPIO105
    Uint32 GPIO106:2;                    // 21:20 Defines pin-muxing selection for GPIO106
    Uint32 GPIO107:2;                    // 23:22 Defines pin-muxing selection for GPIO107
    Uint32 GPIO108:2;                    // 25:24 Defines pin-muxing selection for GPIO108
    Uint32 GPIO109:2;                    // 27:26 Defines pin-muxing selection for GPIO109
    Uint32 GPIO110:2;                    // 29:28 Defines pin-muxing selection for GPIO110
    Uint32 GPIO111:2;                    // 31:30 Defines pin-muxing selection for GPIO111
};

union GPDGMUX1_REG {
    Uint32  all;
    struct  GPDGMUX1_BITS  bit;
};

struct GPDGMUX2_BITS {                  // bits description
    Uint32 GPIO112:2;                    // 1:0 Defines pin-muxing selection for GPIO112
    Uint32 GPIO113:2;                    // 3:2 Defines pin-muxing selection for GPIO113
    Uint32 GPIO114:2;                    // 5:4 Defines pin-muxing selection for GPIO114
    Uint32 GPIO115:2;                    // 7:6 Defines pin-muxing selection for GPIO115
    Uint32 GPIO116:2;                    // 9:8 Defines pin-muxing selection for GPIO116
    Uint32 GPIO117:2;                    // 11:10 Defines pin-muxing selection for GPIO117
    Uint32 GPIO118:2;                    // 13:12 Defines pin-muxing selection for GPIO118
    Uint32 GPIO119:2;                    // 15:14 Defines pin-muxing selection for GPIO119
    Uint32 GPIO120:2;                    // 17:16 Defines pin-muxing selection for GPIO120
    Uint32 GPIO121:2;                    // 19:18 Defines pin-muxing selection for GPIO121
    Uint32 GPIO122:2;                    // 21:20 Defines pin-muxing selection for GPIO122
    Uint32 GPIO123:2;                    // 23:22 Defines pin-muxing selection for GPIO123
    Uint32 GPIO124:2;                    // 25:24 Defines pin-muxing selection for GPIO124
    Uint32 GPIO125:2;                    // 27:26 Defines pin-muxing selection for GPIO125
    Uint32 GPIO126:2;                    // 29:28 Defines pin-muxing selection for GPIO126
    Uint32 GPIO127:2;                    // 31:30 Defines pin-muxing selection for GPIO127
};

union GPDGMUX2_REG {
    Uint32  all;
    struct  GPDGMUX2_BITS  bit;
};









struct GPECTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO128 to GPIO135
    Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO128 to GPIO135
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO136 to GPIO143
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO136 to GPIO143
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO144 to GPIO151
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO144 to GPIO151
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO152 to GPIO159
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO152 to GPIO159
};

union GPECTRL_REG {
    Uint32  all;
    struct  GPECTRL_BITS  bit;
};

struct GPEQSEL1_BITS {                  // bits description
    Uint32 GPIO128:2;                    // 1:0 Select input qualification type for GPIO128
    Uint32 GPIO129:2;                    // 3:2 Select input qualification type for GPIO129
    Uint32 GPIO130:2;                    // 5:4 Select input qualification type for GPIO130
    Uint32 GPIO131:2;                    // 7:6 Select input qualification type for GPIO131
    Uint32 GPIO132:2;                    // 9:8 Select input qualification type for GPIO132
    Uint32 GPIO133:2;                    // 11:10 Select input qualification type for GPIO133
    Uint32 GPIO134:2;                    // 13:12 Select input qualification type for GPIO134
    Uint32 GPIO135:2;                    // 15:14 Select input qualification type for GPIO135
    Uint32 GPIO136:2;                    // 17:16 Select input qualification type for GPIO136
    Uint32 GPIO137:2;                    // 19:18 Select input qualification type for GPIO137
    Uint32 GPIO138:2;                    // 21:20 Select input qualification type for GPIO138
    Uint32 GPIO139:2;                    // 23:22 Select input qualification type for GPIO139
    Uint32 GPIO140:2;                    // 25:24 Select input qualification type for GPIO140
    Uint32 GPIO141:2;                    // 27:26 Select input qualification type for GPIO141
    Uint32 GPIO142:2;                    // 29:28 Select input qualification type for GPIO142
    Uint32 GPIO143:2;                    // 31:30 Select input qualification type for GPIO143
};

union GPEQSEL1_REG {
    Uint32  all;
    struct  GPEQSEL1_BITS  bit;
};

struct GPEQSEL2_BITS {                  // bits description
    Uint32 GPIO144:2;                    // 1:0 Select input qualification type for GPIO144
    Uint32 GPIO145:2;                    // 3:2 Select input qualification type for GPIO145
    Uint32 GPIO146:2;                    // 5:4 Select input qualification type for GPIO146
    Uint32 GPIO147:2;                    // 7:6 Select input qualification type for GPIO147
    Uint32 GPIO148:2;                    // 9:8 Select input qualification type for GPIO148
    Uint32 GPIO149:2;                    // 11:10 Select input qualification type for GPIO149
    Uint32 GPIO150:2;                    // 13:12 Select input qualification type for GPIO150
    Uint32 GPIO151:2;                    // 15:14 Select input qualification type for GPIO151
    Uint32 GPIO152:2;                    // 17:16 Select input qualification type for GPIO152
    Uint32 GPIO153:2;                    // 19:18 Select input qualification type for GPIO153
    Uint32 GPIO154:2;                    // 21:20 Select input qualification type for GPIO154
    Uint32 GPIO155:2;                    // 23:22 Select input qualification type for GPIO155
    Uint32 GPIO156:2;                    // 25:24 Select input qualification type for GPIO156
    Uint32 GPIO157:2;                    // 27:26 Select input qualification type for GPIO157
    Uint32 GPIO158:2;                    // 29:28 Select input qualification type for GPIO158
    Uint32 GPIO159:2;                    // 31:30 Select input qualification type for GPIO159
};

union GPEQSEL2_REG {
    Uint32  all;
    struct  GPEQSEL2_BITS  bit;
};

struct GPEMUX1_BITS {                   // bits description
    Uint32 GPIO128:2;                    // 1:0 Defines pin-muxing selection for GPIO128
    Uint32 GPIO129:2;                    // 3:2 Defines pin-muxing selection for GPIO129
    Uint32 GPIO130:2;                    // 5:4 Defines pin-muxing selection for GPIO130
    Uint32 GPIO131:2;                    // 7:6 Defines pin-muxing selection for GPIO131
    Uint32 GPIO132:2;                    // 9:8 Defines pin-muxing selection for GPIO132
    Uint32 GPIO133:2;                    // 11:10 Defines pin-muxing selection for GPIO133
    Uint32 GPIO134:2;                    // 13:12 Defines pin-muxing selection for GPIO134
    Uint32 GPIO135:2;                    // 15:14 Defines pin-muxing selection for GPIO135
    Uint32 GPIO136:2;                    // 17:16 Defines pin-muxing selection for GPIO136
    Uint32 GPIO137:2;                    // 19:18 Defines pin-muxing selection for GPIO137
    Uint32 GPIO138:2;                    // 21:20 Defines pin-muxing selection for GPIO138
    Uint32 GPIO139:2;                    // 23:22 Defines pin-muxing selection for GPIO139
    Uint32 GPIO140:2;                    // 25:24 Defines pin-muxing selection for GPIO140
    Uint32 GPIO141:2;                    // 27:26 Defines pin-muxing selection for GPIO141
    Uint32 GPIO142:2;                    // 29:28 Defines pin-muxing selection for GPIO142
    Uint32 GPIO143:2;                    // 31:30 Defines pin-muxing selection for GPIO143
};

union GPEMUX1_REG {
    Uint32  all;
    struct  GPEMUX1_BITS  bit;
};

struct GPEMUX2_BITS {                   // bits description
    Uint32 GPIO144:2;                    // 1:0 Defines pin-muxing selection for GPIO144
    Uint32 GPIO145:2;                    // 3:2 Defines pin-muxing selection for GPIO145
    Uint32 GPIO146:2;                    // 5:4 Defines pin-muxing selection for GPIO146
    Uint32 GPIO147:2;                    // 7:6 Defines pin-muxing selection for GPIO147
    Uint32 GPIO148:2;                    // 9:8 Defines pin-muxing selection for GPIO148
    Uint32 GPIO149:2;                    // 11:10 Defines pin-muxing selection for GPIO149
    Uint32 GPIO150:2;                    // 13:12 Defines pin-muxing selection for GPIO150
    Uint32 GPIO151:2;                    // 15:14 Defines pin-muxing selection for GPIO151
    Uint32 GPIO152:2;                    // 17:16 Defines pin-muxing selection for GPIO152
    Uint32 GPIO153:2;                    // 19:18 Defines pin-muxing selection for GPIO153
    Uint32 GPIO154:2;                    // 21:20 Defines pin-muxing selection for GPIO154
    Uint32 GPIO155:2;                    // 23:22 Defines pin-muxing selection for GPIO155
    Uint32 GPIO156:2;                    // 25:24 Defines pin-muxing selection for GPIO156
    Uint32 GPIO157:2;                    // 27:26 Defines pin-muxing selection for GPIO157
    Uint32 GPIO158:2;                    // 29:28 Defines pin-muxing selection for GPIO158
    Uint32 GPIO159:2;                    // 31:30 Defines pin-muxing selection for GPIO159
};

union GPEMUX2_REG {
    Uint32  all;
    struct  GPEMUX2_BITS  bit;
};


struct GPEPUD_BITS {                    // bits description
    Uint32 GPIO128:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO129:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO130:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO131:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO132:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO133:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO134:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO135:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO136:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO137:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO138:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO139:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO140:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO141:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO142:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO143:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO144:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO145:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO146:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO147:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO148:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO149:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO150:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO151:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO152:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO153:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO154:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO155:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO156:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO157:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO158:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO159:1;                    // 31 Pull-Up Disable control for this pin
};

union GPEPUD_REG {
    Uint32  all;
    struct  GPEPUD_BITS  bit;
};

struct GPEINV_BITS {                    // bits description
    Uint32 GPIO128:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO129:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO130:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO131:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO132:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO133:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO134:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO135:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO136:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO137:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO138:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO139:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO140:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO141:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO142:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO143:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO144:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO145:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO146:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO147:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO148:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO149:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO150:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO151:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO152:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO153:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO154:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO155:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO156:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO157:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO158:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO159:1;                    // 31 Input inversion control for this pin
};

union GPEINV_REG {
    Uint32  all;
    struct  GPEINV_BITS  bit;
};


struct GPEGMUX1_BITS {                  // bits description
    Uint32 GPIO128:2;                    // 1:0 Defines pin-muxing selection for GPIO128
    Uint32 GPIO129:2;                    // 3:2 Defines pin-muxing selection for GPIO129
    Uint32 GPIO130:2;                    // 5:4 Defines pin-muxing selection for GPIO130
    Uint32 GPIO131:2;                    // 7:6 Defines pin-muxing selection for GPIO131
    Uint32 GPIO132:2;                    // 9:8 Defines pin-muxing selection for GPIO132
    Uint32 GPIO133:2;                    // 11:10 Defines pin-muxing selection for GPIO133
    Uint32 GPIO134:2;                    // 13:12 Defines pin-muxing selection for GPIO134
    Uint32 GPIO135:2;                    // 15:14 Defines pin-muxing selection for GPIO135
    Uint32 GPIO136:2;                    // 17:16 Defines pin-muxing selection for GPIO136
    Uint32 GPIO137:2;                    // 19:18 Defines pin-muxing selection for GPIO137
    Uint32 GPIO138:2;                    // 21:20 Defines pin-muxing selection for GPIO138
    Uint32 GPIO139:2;                    // 23:22 Defines pin-muxing selection for GPIO139
    Uint32 GPIO140:2;                    // 25:24 Defines pin-muxing selection for GPIO140
    Uint32 GPIO141:2;                    // 27:26 Defines pin-muxing selection for GPIO141
    Uint32 GPIO142:2;                    // 29:28 Defines pin-muxing selection for GPIO142
    Uint32 GPIO143:2;                    // 31:30 Defines pin-muxing selection for GPIO143
};

union GPEGMUX1_REG {
    Uint32  all;
    struct  GPEGMUX1_BITS  bit;
};

struct GPEGMUX2_BITS {                  // bits description
    Uint32 GPIO144:2;                    // 1:0 Defines pin-muxing selection for GPIO144
    Uint32 GPIO145:2;                    // 3:2 Defines pin-muxing selection for GPIO145
    Uint32 GPIO146:2;                    // 5:4 Defines pin-muxing selection for GPIO146
    Uint32 GPIO147:2;                    // 7:6 Defines pin-muxing selection for GPIO147
    Uint32 GPIO148:2;                    // 9:8 Defines pin-muxing selection for GPIO148
    Uint32 GPIO149:2;                    // 11:10 Defines pin-muxing selection for GPIO149
    Uint32 GPIO150:2;                    // 13:12 Defines pin-muxing selection for GPIO150
    Uint32 GPIO151:2;                    // 15:14 Defines pin-muxing selection for GPIO151
    Uint32 GPIO152:2;                    // 17:16 Defines pin-muxing selection for GPIO152
    Uint32 GPIO153:2;                    // 19:18 Defines pin-muxing selection for GPIO153
    Uint32 GPIO154:2;                    // 21:20 Defines pin-muxing selection for GPIO154
    Uint32 GPIO155:2;                    // 23:22 Defines pin-muxing selection for GPIO155
    Uint32 GPIO156:2;                    // 25:24 Defines pin-muxing selection for GPIO156
    Uint32 GPIO157:2;                    // 27:26 Defines pin-muxing selection for GPIO157
    Uint32 GPIO158:2;                    // 29:28 Defines pin-muxing selection for GPIO158
    Uint32 GPIO159:2;                    // 31:30 Defines pin-muxing selection for GPIO159
};

union GPEGMUX2_REG {
    Uint32  all;
    struct  GPEGMUX2_BITS  bit;
};











struct GPFCTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO160 to GPIO167
    Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO160 to GPIO167
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO168 to GPIO175
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO168 to GPIO175
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO176 to GPIO183
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO176 to GPIO183
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO184 to GPIO191
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO184 to GPIO191
};

union GPFCTRL_REG {
    Uint32  all;
    struct  GPFCTRL_BITS  bit;
};

struct GPFQSEL1_BITS {                  // bits description
    Uint32 GPIO160:2;                    // 1:0 Select input qualification type for GPIO160
    Uint32 GPIO161:2;                    // 3:2 Select input qualification type for GPIO161
    Uint32 GPIO162:2;                    // 5:4 Select input qualification type for GPIO162
    Uint32 GPIO163:2;                    // 7:6 Select input qualification type for GPIO163
    Uint32 GPIO164:2;                    // 9:8 Select input qualification type for GPIO164
    Uint32 GPIO165:2;                    // 11:10 Select input qualification type for GPIO165
    Uint32 GPIO166:2;                    // 13:12 Select input qualification type for GPIO166
    Uint32 GPIO167:2;                    // 15:14 Select input qualification type for GPIO167
    Uint32 GPIO168:2;                    // 17:16 Select input qualification type for GPIO168
    Uint32 GPIO169:2;                    // 19:18 Select input qualification type for GPIO169
    Uint32 GPIO170:2;                    // 21:20 Select input qualification type for GPIO170
    Uint32 GPIO171:2;                    // 23:22 Select input qualification type for GPIO171
    Uint32 GPIO172:2;                    // 25:24 Select input qualification type for GPIO172
    Uint32 GPIO173:2;                    // 27:26 Select input qualification type for GPIO173
    Uint32 GPIO174:2;                    // 29:28 Select input qualification type for GPIO174
    Uint32 GPIO175:2;                    // 31:30 Select input qualification type for GPIO175
};

union GPFQSEL1_REG {
    Uint32  all;
    struct  GPFQSEL1_BITS  bit;
};

struct GPFQSEL2_BITS {                  // bits description
    Uint32 GPIO176:2;                    // 1:0 Select input qualification type for GPIO176
    Uint32 GPIO177:2;                    // 3:2 Select input qualification type for GPIO177
    Uint32 GPIO178:2;                    // 5:4 Select input qualification type for GPIO178
    Uint32 GPIO179:2;                    // 7:6 Select input qualification type for GPIO179
    Uint32 GPIO180:2;                    // 9:8 Select input qualification type for GPIO180
    Uint32 GPIO181:2;                    // 11:10 Select input qualification type for GPIO181
    Uint32 GPIO182:2;                    // 13:12 Select input qualification type for GPIO182
    Uint32 GPIO183:2;                    // 15:14 Select input qualification type for GPIO183
    Uint32 GPIO184:2;                    // 17:16 Select input qualification type for GPIO184
    Uint32 GPIO185:2;                    // 19:18 Select input qualification type for GPIO185
    Uint32 GPIO186:2;                    // 21:20 Select input qualification type for GPIO186
    Uint32 GPIO187:2;                    // 23:22 Select input qualification type for GPIO187
    Uint32 GPIO188:2;                    // 25:24 Select input qualification type for GPIO188
    Uint32 GPIO189:2;                    // 27:26 Select input qualification type for GPIO189
    Uint32 GPIO190:2;                    // 29:28 Select input qualification type for GPIO190
    Uint32 GPIO191:2;                    // 31:30 Select input qualification type for GPIO191
};

union GPFQSEL2_REG {
    Uint32  all;
    struct  GPFQSEL2_BITS  bit;
};

struct GPFMUX1_BITS {                   // bits description
    Uint32 GPIO160:2;                    // 1:0 Defines pin-muxing selection for GPIO160
    Uint32 GPIO161:2;                    // 3:2 Defines pin-muxing selection for GPIO161
    Uint32 GPIO162:2;                    // 5:4 Defines pin-muxing selection for GPIO162
    Uint32 GPIO163:2;                    // 7:6 Defines pin-muxing selection for GPIO163
    Uint32 GPIO164:2;                    // 9:8 Defines pin-muxing selection for GPIO164
    Uint32 GPIO165:2;                    // 11:10 Defines pin-muxing selection for GPIO165
    Uint32 GPIO166:2;                    // 13:12 Defines pin-muxing selection for GPIO166
    Uint32 GPIO167:2;                    // 15:14 Defines pin-muxing selection for GPIO167
    Uint32 GPIO168:2;                    // 17:16 Defines pin-muxing selection for GPIO168
    Uint32 GPIO169:2;                    // 19:18 Defines pin-muxing selection for GPIO169
    Uint32 GPIO170:2;                    // 21:20 Defines pin-muxing selection for GPIO170
    Uint32 GPIO171:2;                    // 23:22 Defines pin-muxing selection for GPIO171
    Uint32 GPIO172:2;                    // 25:24 Defines pin-muxing selection for GPIO172
    Uint32 GPIO173:2;                    // 27:26 Defines pin-muxing selection for GPIO173
    Uint32 GPIO174:2;                    // 29:28 Defines pin-muxing selection for GPIO174
    Uint32 GPIO175:2;                    // 31:30 Defines pin-muxing selection for GPIO175
};

union GPFMUX1_REG {
    Uint32  all;
    struct  GPFMUX1_BITS  bit;
};

struct GPFMUX2_BITS {                   // bits description
    Uint32 GPIO176:2;                    // 1:0 Defines pin-muxing selection for GPIO176
    Uint32 GPIO177:2;                    // 3:2 Defines pin-muxing selection for GPIO177
    Uint32 GPIO178:2;                    // 5:4 Defines pin-muxing selection for GPIO178
    Uint32 GPIO179:2;                    // 7:6 Defines pin-muxing selection for GPIO179
    Uint32 GPIO180:2;                    // 9:8 Defines pin-muxing selection for GPIO180
    Uint32 GPIO181:2;                    // 11:10 Defines pin-muxing selection for GPIO181
    Uint32 GPIO182:2;                    // 13:12 Defines pin-muxing selection for GPIO182
    Uint32 GPIO183:2;                    // 15:14 Defines pin-muxing selection for GPIO183
    Uint32 GPIO184:2;                    // 17:16 Defines pin-muxing selection for GPIO184
    Uint32 GPIO185:2;                    // 19:18 Defines pin-muxing selection for GPIO185
    Uint32 GPIO186:2;                    // 21:20 Defines pin-muxing selection for GPIO186
    Uint32 GPIO187:2;                    // 23:22 Defines pin-muxing selection for GPIO187
    Uint32 GPIO188:2;                    // 25:24 Defines pin-muxing selection for GPIO188
    Uint32 GPIO189:2;                    // 27:26 Defines pin-muxing selection for GPIO189
    Uint32 GPIO190:2;                    // 29:28 Defines pin-muxing selection for GPIO190
    Uint32 GPIO191:2;                    // 31:30 Defines pin-muxing selection for GPIO191
};

union GPFMUX2_REG {
    Uint32  all;
    struct  GPFMUX2_BITS  bit;
};


struct GPFPUD_BITS {                    // bits description
    Uint32 GPIO160:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO161:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO162:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO163:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO164:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO165:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO166:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO167:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO168:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO169:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO170:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO171:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO172:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO173:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO174:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO175:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO176:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO177:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO178:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO179:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO180:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO181:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO182:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO183:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO184:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO185:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO186:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO187:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO188:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO189:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO190:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO191:1;                    // 31 Pull-Up Disable control for this pin
};

union GPFPUD_REG {
    Uint32  all;
    struct  GPFPUD_BITS  bit;
};

struct GPFINV_BITS {                    // bits description
    Uint32 GPIO160:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO161:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO162:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO163:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO164:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO165:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO166:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO167:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO168:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO169:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO170:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO171:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO172:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO173:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO174:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO175:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO176:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO177:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO178:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO179:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO180:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO181:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO182:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO183:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO184:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO185:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO186:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO187:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO188:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO189:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO190:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO191:1;                    // 31 Input inversion control for this pin
};

union GPFINV_REG {
    Uint32  all;
    struct  GPFINV_BITS  bit;
};


struct GPFGMUX1_BITS {                  // bits description
    Uint32 GPIO160:2;                    // 1:0 Defines pin-muxing selection for GPIO160
    Uint32 GPIO161:2;                    // 3:2 Defines pin-muxing selection for GPIO161
    Uint32 GPIO162:2;                    // 5:4 Defines pin-muxing selection for GPIO162
    Uint32 GPIO163:2;                    // 7:6 Defines pin-muxing selection for GPIO163
    Uint32 GPIO164:2;                    // 9:8 Defines pin-muxing selection for GPIO164
    Uint32 GPIO165:2;                    // 11:10 Defines pin-muxing selection for GPIO165
    Uint32 GPIO166:2;                    // 13:12 Defines pin-muxing selection for GPIO166
    Uint32 GPIO167:2;                    // 15:14 Defines pin-muxing selection for GPIO167
    Uint32 GPIO168:2;                    // 17:16 Defines pin-muxing selection for GPIO168
    Uint32 GPIO169:2;                    // 19:18 Defines pin-muxing selection for GPIO169
    Uint32 GPIO170:2;                    // 21:20 Defines pin-muxing selection for GPIO170
    Uint32 GPIO171:2;                    // 23:22 Defines pin-muxing selection for GPIO171
    Uint32 GPIO172:2;                    // 25:24 Defines pin-muxing selection for GPIO172
    Uint32 GPIO173:2;                    // 27:26 Defines pin-muxing selection for GPIO173
    Uint32 GPIO174:2;                    // 29:28 Defines pin-muxing selection for GPIO174
    Uint32 GPIO175:2;                    // 31:30 Defines pin-muxing selection for GPIO175
};

union GPFGMUX1_REG {
    Uint32  all;
    struct  GPFGMUX1_BITS  bit;
};

struct GPFGMUX2_BITS {                  // bits description
    Uint32 GPIO176:2;                    // 1:0 Defines pin-muxing selection for GPIO176
    Uint32 GPIO177:2;                    // 3:2 Defines pin-muxing selection for GPIO177
    Uint32 GPIO178:2;                    // 5:4 Defines pin-muxing selection for GPIO178
    Uint32 GPIO179:2;                    // 7:6 Defines pin-muxing selection for GPIO179
    Uint32 GPIO180:2;                    // 9:8 Defines pin-muxing selection for GPIO180
    Uint32 GPIO181:2;                    // 11:10 Defines pin-muxing selection for GPIO181
    Uint32 GPIO182:2;                    // 13:12 Defines pin-muxing selection for GPIO182
    Uint32 GPIO183:2;                    // 15:14 Defines pin-muxing selection for GPIO183
    Uint32 GPIO184:2;                    // 17:16 Defines pin-muxing selection for GPIO184
    Uint32 GPIO185:2;                    // 19:18 Defines pin-muxing selection for GPIO185
    Uint32 GPIO186:2;                    // 21:20 Defines pin-muxing selection for GPIO186
    Uint32 GPIO187:2;                    // 23:22 Defines pin-muxing selection for GPIO187
    Uint32 GPIO188:2;                    // 25:24 Defines pin-muxing selection for GPIO188
    Uint32 GPIO189:2;                    // 27:26 Defines pin-muxing selection for GPIO189
    Uint32 GPIO190:2;                    // 29:28 Defines pin-muxing selection for GPIO190
    Uint32 GPIO191:2;                    // 31:30 Defines pin-muxing selection for GPIO191
};

union GPFGMUX2_REG {
    Uint32  all;
    struct  GPFGMUX2_BITS  bit;
};










struct GPGCTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO192 to GPIO199
    Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO192 to GPIO199
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO200 to GPIO207
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO200 to GPIO207
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO208 to GPIO215
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO208 to GPIO215
    Uint32 QUALPRD3_L:4;                  // 27:24 Qualification sampling period for GPIO216 to GPIO223
    Uint32 QUALPRD3_H:4;                  // 31:28 Qualification sampling period for GPIO216 to GPIO223
};

union GPGCTRL_REG {
    Uint32  all;
    struct  GPGCTRL_BITS  bit;
};

struct GPGQSEL1_BITS {                  // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:2;                    // 13:12 Select input qualification type for GPIO198
    Uint32 GPIO199:2;                    // 15:14 Select input qualification type for GPIO199
    Uint32 GPIO200:2;                    // 17:16 Select input qualification type for GPIO200
    Uint32 GPIO201:2;                    // 19:18 Select input qualification type for GPIO201
    Uint32 GPIO202:2;                    // 21:20 Select input qualification type for GPIO202
    Uint32 GPIO203:2;                    // 23:22 Select input qualification type for GPIO203
    Uint32 GPIO204:2;                    // 25:24 Select input qualification type for GPIO204
    Uint32 GPIO205:2;                    // 27:26 Select input qualification type for GPIO205
    Uint32 GPIO206:2;                    // 29:28 Select input qualification type for GPIO206
    Uint32 GPIO207:2;                    // 31:30 Select input qualification type for GPIO207
};

union GPGQSEL1_REG {
    Uint32  all;
    struct  GPGQSEL1_BITS  bit;
};

struct GPGQSEL2_BITS {                  // bits description
    Uint32 GPIO208:2;                    // 1:0 Select input qualification type for GPIO208
    Uint32 GPIO209:2;                    // 3:2 Select input qualification type for GPIO209
    Uint32 GPIO210:2;                    // 5:4 Select input qualification type for GPIO210
    Uint32 GPIO211:2;                    // 7:6 Select input qualification type for GPIO211
    Uint32 GPIO212:2;                    // 9:8 Select input qualification type for GPIO212
    Uint32 GPIO213:2;                    // 11:10 Select input qualification type for GPIO213
    Uint32 GPIO214:2;                    // 13:12 Select input qualification type for GPIO214
    Uint32 GPIO215:2;                    // 15:14 Select input qualification type for GPIO215
    Uint32 GPIO216:2;                    // 17:16 Select input qualification type for GPIO216
    Uint32 GPIO217:2;                    // 19:18 Select input qualification type for GPIO217
    Uint32 GPIO218:2;                    // 21:20 Select input qualification type for GPIO218
    Uint32 GPIO219:2;                    // 23:22 Select input qualification type for GPIO219
    Uint32 GPIO220:2;                    // 25:24 Select input qualification type for GPIO220
    Uint32 GPIO221:2;                    // 27:26 Select input qualification type for GPIO221
    Uint32 GPIO222:2;                    // 29:28 Select input qualification type for GPIO222
    Uint32 GPIO223:2;                    // 31:30 Select input qualification type for GPIO223
};

union GPGQSEL2_REG {
    Uint32  all;
    struct  GPGQSEL2_BITS  bit;
};

struct GPGMUX1_BITS {                   // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:2;                    // 13:12 Defines pin-muxing selection for GPIO198
    Uint32 GPIO199:2;                    // 15:14 Defines pin-muxing selection for GPIO199
    Uint32 GPIO200:2;                    // 17:16 Defines pin-muxing selection for GPIO200
    Uint32 GPIO201:2;                    // 19:18 Defines pin-muxing selection for GPIO201
    Uint32 GPIO202:2;                    // 21:20 Defines pin-muxing selection for GPIO202
    Uint32 GPIO203:2;                    // 23:22 Defines pin-muxing selection for GPIO203
    Uint32 GPIO204:2;                    // 25:24 Defines pin-muxing selection for GPIO204
    Uint32 GPIO205:2;                    // 27:26 Defines pin-muxing selection for GPIO205
    Uint32 GPIO206:2;                    // 29:28 Defines pin-muxing selection for GPIO206
    Uint32 GPIO207:2;                    // 31:30 Defines pin-muxing selection for GPIO207
};

union GPGMUX1_REG {
    Uint32  all;
    struct  GPGMUX1_BITS  bit;
};

struct GPGMUX2_BITS {                   // bits description
    Uint32 GPIO208:2;                    // 1:0 Defines pin-muxing selection for GPIO208
    Uint32 GPIO209:2;                    // 3:2 Defines pin-muxing selection for GPIO209
    Uint32 GPIO210:2;                    // 5:4 Defines pin-muxing selection for GPIO210
    Uint32 GPIO211:2;                    // 7:6 Defines pin-muxing selection for GPIO211
    Uint32 GPIO212:2;                    // 9:8 Defines pin-muxing selection for GPIO212
    Uint32 GPIO213:2;                    // 11:10 Defines pin-muxing selection for GPIO213
    Uint32 GPIO214:2;                    // 13:12 Defines pin-muxing selection for GPIO214
    Uint32 GPIO215:2;                    // 15:14 Defines pin-muxing selection for GPIO215
    Uint32 GPIO216:2;                    // 17:16 Defines pin-muxing selection for GPIO216
    Uint32 GPIO217:2;                    // 19:18 Defines pin-muxing selection for GPIO217
    Uint32 GPIO218:2;                    // 21:20 Defines pin-muxing selection for GPIO218
    Uint32 GPIO219:2;                    // 23:22 Defines pin-muxing selection for GPIO219
    Uint32 GPIO220:2;                    // 25:24 Defines pin-muxing selection for GPIO220
    Uint32 GPIO221:2;                    // 27:26 Defines pin-muxing selection for GPIO221
    Uint32 GPIO222:2;                    // 29:28 Defines pin-muxing selection for GPIO222
    Uint32 GPIO223:2;                    // 31:30 Defines pin-muxing selection for GPIO223
};

union GPGMUX2_REG {
    Uint32  all;
    struct  GPGMUX2_BITS  bit;
};


struct GPGPUD_BITS {                    // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO199:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO200:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO201:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO202:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO203:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO204:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO205:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO206:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO207:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO208:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO209:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO210:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO211:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO212:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO213:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO214:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO215:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO216:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO217:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO218:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO219:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO220:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO221:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO222:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO223:1;                    // 31 Pull-Up Disable control for this pin
};

union GPGPUD_REG {
    Uint32  all;
    struct  GPGPUD_BITS  bit;
};

struct GPGINV_BITS {                    // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO199:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO200:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO201:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO202:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO203:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO204:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO205:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO206:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO207:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO208:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO209:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO210:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO211:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO212:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO213:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO214:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO215:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO216:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO217:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO218:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO219:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO220:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO221:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO222:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO223:1;                    // 31 Input inversion control for this pin
};

union GPGINV_REG {
    Uint32  all;
    struct  GPGINV_BITS  bit;
};


struct GPGAMSEL_BITS {                    // bits description

	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Analog Mode Select for this pin
    Uint32 GPIO199:1;                    // 7 Analog Mode Select for this pin
    Uint32 GPIO200:1;                    // 8 Analog Mode Select for this pin
    Uint32 GPIO201:1;                    // 9 Analog Mode Select for this pin
    Uint32 GPIO202:1;                    // 10 Analog Mode Select for this pin
    Uint32 GPIO203:1;                    // 11 Analog Mode Select for this pin
    Uint32 GPIO204:1;                    // 12 Analog Mode Select for this pin
    Uint32 GPIO205:1;                    // 13 Analog Mode Select for this pin
    Uint32 GPIO206:1;                    // 14 Analog Mode Select for this pin
    Uint32 GPIO207:1;                    // 15 Analog Mode Select for this pin
    Uint32 GPIO208:1;                    // 16 Analog Mode Select for this pin
    Uint32 GPIO209:1;                    // 17 Analog Mode Select for this pin
    Uint32 GPIO210:1;                    // 18 Analog Mode Select for this pin
    Uint32 GPIO211:1;                    // 19 Analog Mode Select for this pin
    Uint32 GPIO212:1;                    // 20 Analog Mode Select for this pin
    Uint32 GPIO213:1;                    // 21 Analog Mode Select for this pin
    Uint32 GPIO214:1;                    // 22 Analog Mode Select for this pin
    Uint32 GPIO215:1;                    // 23 Analog Mode Select for this pin
    Uint32 GPIO216:1;                    // 24 Analog Mode Select for this pin
    Uint32 GPIO217:1;                    // 25 Analog Mode Select for this pin
    Uint32 GPIO218:1;                    // 26 Analog Mode Select for this pin
    Uint32 GPIO219:1;                    // 27 Analog Mode Select for this pin
    Uint32 GPIO220:1;                    // 28 Analog Mode Select for this pin
    Uint32 GPIO221:1;                    // 29 Analog Mode Select for this pin
    Uint32 GPIO222:1;                    // 30 Analog Mode Select for this pin
    Uint32 GPIO223:1;                    // 31 Analog Mode Select for this pin
};

union GPGAMSEL_REG {
    Uint32  all;
    struct  GPGAMSEL_BITS  bit;
};

struct GPGGMUX1_BITS {                  // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:2;                    // 13:12 Defines pin-muxing selection for GPIO198
    Uint32 GPIO199:2;                    // 15:14 Defines pin-muxing selection for GPIO199
    Uint32 GPIO200:2;                    // 17:16 Defines pin-muxing selection for GPIO200
    Uint32 GPIO201:2;                    // 19:18 Defines pin-muxing selection for GPIO201
    Uint32 GPIO202:2;                    // 21:20 Defines pin-muxing selection for GPIO202
    Uint32 GPIO203:2;                    // 23:22 Defines pin-muxing selection for GPIO203
    Uint32 GPIO204:2;                    // 25:24 Defines pin-muxing selection for GPIO204
    Uint32 GPIO205:2;                    // 27:26 Defines pin-muxing selection for GPIO205
    Uint32 GPIO206:2;                    // 29:28 Defines pin-muxing selection for GPIO206
    Uint32 GPIO207:2;                    // 31:30 Defines pin-muxing selection for GPIO207
};

union GPGGMUX1_REG {
    Uint32  all;
    struct  GPGGMUX1_BITS  bit;
};

struct GPGGMUX2_BITS {                  // bits description
    Uint32 GPIO208:2;                    // 1:0 Defines pin-muxing selection for GPIO208
    Uint32 GPIO209:2;                    // 3:2 Defines pin-muxing selection for GPIO209
    Uint32 GPIO210:2;                    // 5:4 Defines pin-muxing selection for GPIO210
    Uint32 GPIO211:2;                    // 7:6 Defines pin-muxing selection for GPIO211
    Uint32 GPIO212:2;                    // 9:8 Defines pin-muxing selection for GPIO212
    Uint32 GPIO213:2;                    // 11:10 Defines pin-muxing selection for GPIO213
    Uint32 GPIO214:2;                    // 13:12 Defines pin-muxing selection for GPIO214
    Uint32 GPIO215:2;                    // 15:14 Defines pin-muxing selection for GPIO215
    Uint32 GPIO216:2;                    // 17:16 Defines pin-muxing selection for GPIO216
    Uint32 GPIO217:2;                    // 19:18 Defines pin-muxing selection for GPIO217
    Uint32 GPIO218:2;                    // 21:20 Defines pin-muxing selection for GPIO218
    Uint32 GPIO219:2;                    // 23:22 Defines pin-muxing selection for GPIO219
    Uint32 GPIO220:2;                    // 25:24 Defines pin-muxing selection for GPIO220
    Uint32 GPIO221:2;                    // 27:26 Defines pin-muxing selection for GPIO221
    Uint32 GPIO222:2;                    // 29:28 Defines pin-muxing selection for GPIO222
    Uint32 GPIO223:2;                    // 31:30 Defines pin-muxing selection for GPIO223
};

union GPGGMUX2_REG {
    Uint32  all;
    struct  GPGGMUX2_BITS  bit;
};







struct GPHCTRL_BITS {                   // bits description
    Uint32 QUALPRD0_L:4;                  // 3:0 Qualification sampling period for GPIO224 to GPIO231
    Uint32 QUALPRD0_H:4;                  // 7:4 Qualification sampling period for GPIO224 to GPIO231
    Uint32 QUALPRD1_L:4;                  // 11:8 Qualification sampling period for GPIO232 to GPIO239
    Uint32 QUALPRD1_H:4;                  // 15:12 Qualification sampling period for GPIO232 to GPIO239
    Uint32 QUALPRD2_L:4;                  // 19:16 Qualification sampling period for GPIO240 to GPIO247
    Uint32 QUALPRD2_H:4;                  // 23:20 Qualification sampling period for GPIO240 to GPIO247
    Uint32 rsvd1:8;                      // 5:0 Reserved
};

union GPHCTRL_REG {
    Uint32  all;
    struct  GPHCTRL_BITS  bit;
};

struct GPHQSEL1_BITS {                  // bits description
    Uint32 GPIO224:2;                    // 1:0 Select input qualification type for GPIO224
    Uint32 GPIO225:2;                    // 3:2 Select input qualification type for GPIO225
    Uint32 GPIO226:2;                    // 5:4 Select input qualification type for GPIO226
    Uint32 GPIO227:2;                    // 7:6 Select input qualification type for GPIO227
    Uint32 GPIO228:2;                    // 9:8 Select input qualification type for GPIO228
    Uint32 GPIO229:2;                    // 11:10 Select input qualification type for GPIO229
    Uint32 GPIO230:2;                    // 13:12 Select input qualification type for GPIO230
    Uint32 GPIO231:2;                    // 15:14 Select input qualification type for GPIO231
    Uint32 GPIO232:2;                    // 17:16 Select input qualification type for GPIO232
    Uint32 GPIO233:2;                    // 19:18 Select input qualification type for GPIO233
    Uint32 GPIO234:2;                    // 21:20 Select input qualification type for GPIO234
    Uint32 GPIO235:2;                    // 23:22 Select input qualification type for GPIO235
    Uint32 GPIO236:2;                    // 25:24 Select input qualification type for GPIO236
    Uint32 GPIO237:2;                    // 27:26 Select input qualification type for GPIO237
    Uint32 GPIO238:2;                    // 29:28 Select input qualification type for GPIO238
    Uint32 GPIO239:2;                    // 31:30 Select input qualification type for GPIO239
};

union GPHQSEL1_REG {
    Uint32  all;
    struct  GPHQSEL1_BITS  bit;
};

struct GPHQSEL2_BITS {                  // bits description
    Uint32 GPIO240:2;                    // 1:0 Select input qualification type for GPIO240
    Uint32 GPIO241:2;                    // 3:2 Select input qualification type for GPIO241
    Uint32 GPIO242:2;                    // 5:4 Select input qualification type for GPIO242
    Uint32 rsvd1:26;                     // 31:6 Reserved
};

union GPHQSEL2_REG {
    Uint32  all;
    struct  GPHQSEL2_BITS  bit;
};

struct GPHMUX1_BITS {                   // bits description
    Uint32 GPIO224:2;                    // 1:0 Defines pin-muxing selection for GPIO224
    Uint32 GPIO225:2;                    // 3:2 Defines pin-muxing selection for GPIO225
    Uint32 GPIO226:2;                    // 5:4 Defines pin-muxing selection for GPIO226
    Uint32 GPIO227:2;                    // 7:6 Defines pin-muxing selection for GPIO227
    Uint32 GPIO228:2;                    // 9:8 Defines pin-muxing selection for GPIO228
    Uint32 GPIO229:2;                    // 11:10 Defines pin-muxing selection for GPIO229
    Uint32 GPIO230:2;                    // 13:12 Defines pin-muxing selection for GPIO230
    Uint32 GPIO231:2;                    // 15:14 Defines pin-muxing selection for GPIO231
    Uint32 GPIO232:2;                    // 17:16 Defines pin-muxing selection for GPIO232
    Uint32 GPIO233:2;                    // 19:18 Defines pin-muxing selection for GPIO233
    Uint32 GPIO234:2;                    // 21:20 Defines pin-muxing selection for GPIO234
    Uint32 GPIO235:2;                    // 23:22 Defines pin-muxing selection for GPIO235
    Uint32 GPIO236:2;                    // 25:24 Defines pin-muxing selection for GPIO236
    Uint32 GPIO237:2;                    // 27:26 Defines pin-muxing selection for GPIO237
    Uint32 GPIO238:2;                    // 29:28 Defines pin-muxing selection for GPIO238
    Uint32 GPIO239:2;                    // 31:30 Defines pin-muxing selection for GPIO239
};

union GPHMUX1_REG {
    Uint32  all;
    struct  GPHMUX1_BITS  bit;
};

struct GPHMUX2_BITS {                   // bits description
    Uint32 GPIO240:2;                    // 1:0 Defines pin-muxing selection for GPIO240
    Uint32 GPIO241:2;                    // 3:2 Defines pin-muxing selection for GPIO241
    Uint32 GPIO242:2;                    // 5:4 Defines pin-muxing selection for GPIO242
    Uint32 rsvd1:26;                     // 31:6 Reserved
};

union GPHMUX2_REG {
    Uint32  all;
    struct  GPHMUX2_BITS  bit;
};

struct GPHPUD_BITS {                    // bits description
    Uint32 GPIO224:1;                    // 31 Pull-Up Disable control for this pin
    Uint32 rsvd1:31;                      // 31:1 Reserved
};

union GPHPUD_REG {
    Uint32  all;
    struct  GPHPUD_BITS  bit;
};

struct GPHINV_BITS {                    // bits description
    Uint32 GPIO224:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO225:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO226:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO227:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO228:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO229:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO230:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO231:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO232:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO233:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO234:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO235:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO236:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO237:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO238:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO239:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO240:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO241:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO242:1;                    // 18 Input inversion control for this pin
    Uint32 rsvd1:13;                     // 31:19 Reserved
};

union GPHINV_REG {
    Uint32  all;
    struct  GPHINV_BITS  bit;
};

struct GPHAMSEL_BITS {                    // bits description
    Uint32 GPIO224:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO225:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO226:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO227:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO228:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO229:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO230:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO231:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO232:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO233:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO234:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO235:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO236:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO237:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO238:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO239:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO240:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO241:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO242:1;                    // 18 Input inversion control for this pin
    Uint32 rsvd1:13;                      // 31:19 Reserved
};

union GPHAMSEL_REG {
    Uint32  all;
    struct  GPHAMSEL_BITS  bit;
};


struct GPHGMUX1_BITS {                  // bits description
    Uint32 GPIO224:2;                    // 1:0 Defines pin-muxing selection for GPIO224
    Uint32 GPIO225:2;                    // 3:2 Defines pin-muxing selection for GPIO225
    Uint32 GPIO226:2;                    // 5:4 Defines pin-muxing selection for GPIO226
    Uint32 GPIO227:2;                    // 7:6 Defines pin-muxing selection for GPIO227
    Uint32 GPIO228:2;                    // 9:8 Defines pin-muxing selection for GPIO228
    Uint32 GPIO229:2;                    // 11:10 Defines pin-muxing selection for GPIO229
    Uint32 GPIO230:2;                    // 13:12 Defines pin-muxing selection for GPIO230
    Uint32 GPIO231:2;                    // 15:14 Defines pin-muxing selection for GPIO231
    Uint32 GPIO232:2;                    // 17:16 Defines pin-muxing selection for GPIO232
    Uint32 GPIO233:2;                    // 19:18 Defines pin-muxing selection for GPIO233
    Uint32 GPIO234:2;                    // 21:20 Defines pin-muxing selection for GPIO234
    Uint32 GPIO235:2;                    // 23:22 Defines pin-muxing selection for GPIO235
    Uint32 GPIO236:2;                    // 25:24 Defines pin-muxing selection for GPIO236
    Uint32 GPIO237:2;                    // 27:26 Defines pin-muxing selection for GPIO237
    Uint32 GPIO238:2;                    // 29:28 Defines pin-muxing selection for GPIO238
    Uint32 GPIO239:2;                    // 31:30 Defines pin-muxing selection for GPIO239
};

union GPHGMUX1_REG {
    Uint32  all;
    struct  GPHGMUX1_BITS  bit;
};

struct GPHGMUX2_BITS {                  // bits description
    Uint32 GPIO240:2;                    // 1:0 Defines pin-muxing selection for GPIO240
    Uint32 GPIO241:2;                    // 3:2 Defines pin-muxing selection for GPIO241
    Uint32 GPIO242:2;                    // 5:4 Defines pin-muxing selection for GPIO242
    Uint32 rsvd1:26;                     // 31:6 Reserved
};

union GPHGMUX2_REG {
    Uint32  all;
    struct  GPHGMUX2_BITS  bit;
};




struct GPAPDD_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 Pull-Down Disable control for this pin
    Uint32 GPIO1:1;                     // 1 Pull-Down Disable control for this pin
    Uint32 GPIO2:1;                     // 2 Pull-Down Disable control for this pin
    Uint32 GPIO3:1;                     // 3 Pull-Down Disable control for this pin
    Uint32 GPIO4:1;                     // 4 Pull-Down Disable control for this pin
    Uint32 GPIO5:1;                     // 5 Pull-Down Disable control for this pin
    Uint32 GPIO6:1;                     // 6 Pull-Down Disable control for this pin
    Uint32 GPIO7:1;                     // 7 Pull-Down Disable control for this pin
    Uint32 GPIO8:1;                     // 8 Pull-Down Disable control for this pin
    Uint32 GPIO9:1;                     // 9 Pull-Down Disable control for this pin
    Uint32 GPIO10:1;                    // 10 Pull-Down Disable control for this pin
    Uint32 GPIO11:1;                    // 11 Pull-Down Disable control for this pin
    Uint32 GPIO12:1;                    // 12 Pull-Down Disable control for this pin
    Uint32 GPIO13:1;                    // 13 Pull-Down Disable control for this pin
    Uint32 GPIO14:1;                    // 14 Pull-Down Disable control for this pin
    Uint32 GPIO15:1;                    // 15 Pull-Down Disable control for this pin
    Uint32 GPIO16:1;                    // 16 Pull-Down Disable control for this pin
    Uint32 GPIO17:1;                    // 17 Pull-Down Disable control for this pin
    Uint32 GPIO18:1;                    // 18 Pull-Down Disable control for this pin
    Uint32 GPIO19:1;                    // 19 Pull-Down Disable control for this pin
    Uint32 GPIO20:1;                    // 20 Pull-Down Disable control for this pin
    Uint32 GPIO21:1;                    // 21 Pull-Down Disable control for this pin
    Uint32 GPIO22:1;                    // 22 Pull-Down Disable control for this pin
    Uint32 GPIO23:1;                    // 23 Pull-Down Disable control for this pin
    Uint32 GPIO24:1;                    // 24 Pull-Down Disable control for this pin
    Uint32 GPIO25:1;                    // 25 Pull-Down Disable control for this pin
    Uint32 GPIO26:1;                    // 26 Pull-Down Disable control for this pin
    Uint32 GPIO27:1;                    // 27 Pull-Down Disable control for this pin
    Uint32 GPIO28:1;                    // 28 Pull-Down Disable control for this pin
    Uint32 GPIO29:1;                    // 29 Pull-Down Disable control for this pin
    Uint32 GPIO30:1;                    // 30 Pull-Down Disable control for this pin
    Uint32 GPIO31:1;                    // 31 Pull-Down Disable control for this pin
};

union GPAPDD_REG {
    Uint32  all;
    struct  GPAPDD_BITS  bit;
};

struct GPADS1_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 Pull-Down Disable control for this pin
    Uint32 rsvd1:1;                     // 1 Reserved
    Uint32 GPIO1:1;                     // 2 Pull-Down Disable control for this pin
    Uint32 rsvd2:1;                     // 3 Reserved
    Uint32 GPIO2:1;                     // 4 Pull-Down Disable control for this pin
    Uint32 rsvd3:1;                     // 5 Reserved
    Uint32 GPIO3:1;                     // 6 Pull-Down Disable control for this pin
    Uint32 rsvd4:1;                     // 7 Reserved
    Uint32 GPIO4:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint32 GPIO5:2;                     // 11:10 Pull-Down Disable control for this pin
    Uint32 GPIO6:2;                     // 13:12 Pull-Down Disable control for this pin
    Uint32 GPIO7:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint32 GPIO8:2;                     // 16 Pull-Down Disable control for this pin
    Uint32 GPIO9:2;                     // 18 Pull-Down Disable control for this pin
    Uint32 GPIO10:2;                    // 20 Pull-Down Disable control for this pin
    Uint32 GPIO11:1;                    // 23:22 Pull-Down Disable control for this pin
    Uint32 rsvd5:1;                     // 31 Reserved
    Uint32 GPIO12:1;                    // 25:24 Pull-Down Disable control for this pin
    Uint32 rsvd6:1;                     // 31 Reserved
    Uint32 GPIO13:1;                    // 27:26 Pull-Down Disable control for this pin
    Uint32 rsvd7:1;                     // 31 Reserved
    Uint32 GPIO14:1;                    // 29:28 Pull-Down Disable control for this pin
    Uint32 rsvd8:1;                     // 31 Reserved
    Uint32 GPIO15:2;                    // 30 Pull-Down Disable control for this pin

};

union GPADS1_REG {
    Uint32  all;
    struct  GPADS1_BITS  bit;
};

struct GPADS2_BITS {                    // bits description
    Uint32 GPIO16:2;                     // 0 Pull-Down Disable control for this pin
    Uint32 GPIO17:2;                     // 2 Pull-Down Disable control for this pin
    Uint32 GPIO18:2;                     // 4 Pull-Down Disable control for this pin
    Uint32 GPIO19:2;                     // 6 Pull-Down Disable control for this pin
    Uint32 GPIO20:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint32 GPIO21:2;                     // 11:10 Pull-Down Disable control for this pin
    Uint32 GPIO22:2;                     // 13:12 Pull-Down Disable control for this pin
    Uint32 GPIO23:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint32 GPIO24:1;                     // 16 Pull-Down Disable control for this pin
    Uint32 rsvd1:1;                     // 17 Reserved
    Uint32 GPIO25:1;                     // 18 Pull-Down Disable control for this pin
    Uint32 rsvd2:1;                     // 19 Reserved
    Uint32 GPIO26:1;                    // 20 Pull-Down Disable control for this pin
    Uint32 rsvd3:1;                     // 21 Reserved
    Uint32 GPIO27:1;                    // 22 Pull-Down Disable control for this pin
    Uint32 rsvd4:1;                     // 23 Reserved
    Uint32 GPIO28:2;                    // 24 Pull-Down Disable control for this pin
    Uint32 GPIO29:2;                    // 26 Pull-Down Disable control for this pin
    Uint32 GPIO30:2;                    // 29:28 Pull-Down Disable control for this pin
    Uint32 GPIO31:1;                    // 31:30 Pull-Down Disable control for this pin
    Uint32 rsvd5:1;                     // 17 Reserved
};

union GPADS2_REG {
    Uint32  all;
    struct  GPADS2_BITS  bit;
};

struct GPAIS_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO1:1;                     // 1 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO2:1;                     // 2 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO3:1;                     // 3 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO4:1;                     // 4 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO5:1;                     // 5 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO6:1;                     // 6 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO7:1;                     // 7 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO8:1;                     // 8 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO9:1;                     // 9 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO10:1;                    // 10 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO11:1;                    // 11 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO12:1;                    // 12 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO13:1;                    // 13 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO14:1;                    // 14 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO15:1;                    // 15 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO16:1;                    // 16 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO17:1;                    // 17 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO18:1;                    // 18 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO19:1;                    // 19 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO20:1;                    // 20 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO21:1;                    // 21 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO22:1;                    // 22 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO23:1;                    // 23 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO24:1;                    // 24 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO25:1;                    // 25 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO26:1;                    // 26 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO27:1;                    // 27 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO28:1;                    // 28 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO29:1;                    // 29 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO30:1;                    // 30 GPIO A Schmitt Trigger  control for this pin
    Uint32 GPIO31:1;                    // 31 GPIO A Schmitt Trigger  control for this pin
};

union GPAIS_REG {
    Uint32  all;
    struct  GPAIS_BITS  bit;
};

struct GPAOUTINV_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO1:1;                     // 1 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO2:1;                     // 2 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO3:1;                     // 3 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO4:1;                     // 4 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO5:1;                     // 5 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO6:1;                     // 6 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO7:1;                     // 7 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO8:1;                     // 8 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO9:1;                     // 9 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO10:1;                    // 10 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO11:1;                    // 11 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO12:1;                    // 12 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO13:1;                    // 13 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO14:1;                    // 14 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO15:1;                    // 15 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO16:1;                    // 16 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO17:1;                    // 17 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO18:1;                    // 18 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO19:1;                    // 19 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO20:1;                    // 20 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO21:1;                    // 21 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO22:1;                    // 22 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO23:1;                    // 23 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO24:1;                    // 24 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO25:1;                    // 25 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO26:1;                    // 26 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO27:1;                    // 27 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO28:1;                    // 28 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO29:1;                    // 29 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO30:1;                    // 30 GPIO A output Polarity Invert control for this pin
    Uint32 GPIO31:1;                    // 31 GPIO A output Polarity Invert control for this pin
};

union GPAOUTINV_REG {
    Uint32  all;
    struct  GPAOUTINV_BITS  bit;
};

struct GPALOOPEN_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 GPIO A LOOP Enable control for this pin
    Uint32 GPIO1:1;                     // 1 GPIO A LOOP Enable control for this pin
    Uint32 GPIO2:1;                     // 2 GPIO A LOOP Enable control for this pin
    Uint32 GPIO3:1;                     // 3 GPIO A LOOP Enable control for this pin
    Uint32 GPIO4:1;                     // 4 GPIO A LOOP Enable control for this pin
    Uint32 GPIO5:1;                     // 5 GPIO A LOOP Enable control for this pin
    Uint32 GPIO6:1;                     // 6 GPIO A LOOP Enable control for this pin
    Uint32 GPIO7:1;                     // 7 GPIO A LOOP Enable control for this pin
    Uint32 GPIO8:1;                     // 8 GPIO A LOOP Enable control for this pin
    Uint32 GPIO9:1;                     // 9 GPIO A LOOP Enable control for this pin
    Uint32 GPIO10:1;                    // 10 GPIO A LOOP Enable control for this pin
    Uint32 GPIO11:1;                    // 11 GPIO A LOOP Enable control for this pin
    Uint32 GPIO12:1;                    // 12 GPIO A LOOP Enable control for this pin
    Uint32 GPIO13:1;                    // 13 GPIO A LOOP Enable control for this pin
    Uint32 GPIO14:1;                    // 14 GPIO A LOOP Enable control for this pin
    Uint32 GPIO15:1;                    // 15 GPIO A LOOP Enable control for this pin
    Uint32 GPIO16:1;                    // 16 GPIO A LOOP Enable control for this pin
    Uint32 GPIO17:1;                    // 17 GPIO A LOOP Enable control for this pin
    Uint32 GPIO18:1;                    // 18 GPIO A LOOP Enable control for this pin
    Uint32 GPIO19:1;                    // 19 GPIO A LOOP Enable control for this pin
    Uint32 GPIO20:1;                    // 20 GPIO A LOOP Enable control for this pin
    Uint32 GPIO21:1;                    // 21 GPIO A LOOP Enable control for this pin
    Uint32 GPIO22:1;                    // 22 GPIO A LOOP Enable control for this pin
    Uint32 GPIO23:1;                    // 23 GPIO A LOOP Enable control for this pin
    Uint32 GPIO24:1;                    // 24 GPIO A LOOP Enable control for this pin
    Uint32 GPIO25:1;                    // 25 GPIO A LOOP Enable control for this pin
    Uint32 GPIO26:1;                    // 26 GPIO A LOOP Enable control for this pin
    Uint32 GPIO27:1;                    // 27 GPIO A LOOP Enable control for this pin
    Uint32 GPIO28:1;                    // 28 GPIO A LOOP Enable control for this pin
    Uint32 GPIO29:1;                    // 29 GPIO A LOOP Enable control for this pin
    Uint32 GPIO30:1;                    // 30 GPIO A LOOP Enable control for this pin
    Uint32 GPIO31:1;                    // 31 GPIO A LOOP Enable control for this pin
};

union GPALOOPEN_REG {
    Uint32  all;
    struct  GPALOOPEN_BITS  bit;
};

struct GPAPI2C_MODE_BITS {                    // bits description
    Uint32 GPIO0:1;                     // 0 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO1:1;                     // 1 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO2:1;                     // 2 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO3:1;                     // 3 GPIO A  PI2C MODE control for this pin
    Uint32 rsvd1:7;                      //  Reserved
    Uint32 GPIO11:1;                    // 11 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO12:1;                    // 12 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO13:1;                    // 13 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO14:1;                    // 14 GPIO A  PI2C MODE control for this pin
    Uint32 rsvd2:9;                      //  Reserved
    Uint32 GPIO24:1;                    // 24 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO25:1;                    // 25 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO26:1;                    // 26 GPIO A  PI2C MODE control for this pin
    Uint32 GPIO27:1;                    // 27 GPIO A  PI2C MODE control for this pin
    Uint32 rsvd3:3;                     // 31:30 Reserved
    Uint32 GPIO31:1;                    // 27 GPIO A  PI2C MODE control for this pin
};

union GPAPI2C_MODE_REG {
    Uint32  all;
    struct  GPAPI2C_MODE_BITS  bit;
};




struct GPBPDD_BITS {                    // bits description
    Uint32 GPIO32:1;                     // 0 Pull-Down Disable control for this pin
    Uint32 GPIO33:1;                     // 1 Pull-Down Disable control for this pin
    Uint32 GPIO34:1;                     // 2 Pull-Down Disable control for this pin
    Uint32 GPIO35:1;                     // 3 Pull-Down Disable control for this pin
    Uint32 GPIO36:1;                     // 4 Pull-Down Disable control for this pin
    Uint32 GPIO37:1;                     // 5 Pull-Down Disable control for this pin
    Uint32 GPIO38:1;                     // 6 Pull-Down Disable control for this pin
    Uint32 GPIO39:1;                     // 7 Pull-Down Disable control for this pin
    Uint32 GPIO40:1;                     // 8 Pull-Down Disable control for this pin
    Uint32 GPIO41:1;                     // 9 Pull-Down Disable control for this pin
    Uint32 GPIO42:1;                    // 10 Pull-Down Disable control for this pin
    Uint32 GPIO43:1;                    // 11 Pull-Down Disable control for this pin
    Uint32 GPIO44:1;                    // 12 Pull-Down Disable control for this pin
    Uint32 GPIO45:1;                    // 13 Pull-Down Disable control for this pin
    Uint32 GPIO46:1;                    // 14 Pull-Down Disable control for this pin
    Uint32 GPIO47:1;                    // 15 Pull-Down Disable control for this pin
    Uint32 GPIO48:1;                    // 16 Pull-Down Disable control for this pin
    Uint32 GPIO49:1;                    // 17 Pull-Down Disable control for this pin
    Uint32 GPIO50:1;                    // 18 Pull-Down Disable control for this pin
    Uint32 GPIO51:1;                    // 19 Pull-Down Disable control for this pin
    Uint32 GPIO52:1;                    // 20 Pull-Down Disable control for this pin
    Uint32 GPIO53:1;                    // 21 Pull-Down Disable control for this pin
    Uint32 GPIO54:1;                    // 22 Pull-Down Disable control for this pin
    Uint32 GPIO55:1;                    // 23 Pull-Down Disable control for this pin
    Uint32 GPIO56:1;                    // 24 Pull-Down Disable control for this pin
    Uint32 GPIO57:1;                    // 25 Pull-Down Disable control for this pin
    Uint32 GPIO58:1;                    // 26 Pull-Down Disable control for this pin
    Uint32 GPIO59:1;                    // 27 Pull-Down Disable control for this pin
    Uint32 GPIO60:1;                    // 28 Pull-Down Disable control for this pin
    Uint32 GPIO61:1;                    // 29 Pull-Down Disable control for this pin
    Uint32 GPIO62:1;                    // 30 Pull-Down Disable control for this pin
    Uint32 GPIO63:1;                    // 31 Pull-Down Disable control for this pin
};

union GPBPDD_REG {
    Uint32  all;
    struct  GPBPDD_BITS  bit;
};

struct GPBDS1_BITS {                    // bits description
    Uint32 GPIO32:1;                     // 0 Pull-Down Disable control for this pin
    Uint32 rsvd1:1;                     // 1 Reserved
    Uint32 GPIO33:1;                     // 2 Pull-Down Disable control for this pin
    Uint32 rsvd2:1;                     // 3 Reserved
    Uint32 GPIO34:1;                     // 4 Pull-Down Disable control for this pin
    Uint32 rsvd3:1;                     // 5 Reserved
    Uint32 GPIO35:1;                     // 6 Pull-Down Disable control for this pin
    Uint32 rsvd4:1;                     // 9:7 Reserved
    Uint32 GPIO36:2;                     // 10 Pull-Down Disable control for this pin
    Uint32 GPIO37:2;                     // 10 Pull-Down Disable control for this pin
    Uint32 GPIO38:2;                     // 10 Pull-Down Disable control for this pin
    Uint32 GPIO39:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint32 GPIO40:1;                     // 16 Pull-Down Disable control for this pin
    Uint32 rsvd5:1;                     // 17 Reserved
    Uint32 GPIO41:1;                     // 18 Pull-Down Disable control for this pin
    Uint32 rsvd6:1;                     // 19 Reserved
    Uint32 GPIO42:1;                    // 20 Pull-Down Disable control for this pin
    Uint32 rsvd7:1;                     // 21 Reserved
    Uint32 GPIO43:1;                    // 22 Pull-Down Disable control for this pin
    Uint32 rsvd8:1;                     // 23 Reserved
    Uint32 GPIO44:2;                    // 24 Pull-Down Disable control for this pin
    Uint32 GPIO45:2;                    // 27:26 Pull-Down Disable control for this pin
    Uint32 GPIO46:2;                    // 28 Pull-Down Disable control for this pin
    Uint32 GPIO47:2;                    // 30 Pull-Down Disable control for this pin
};

union GPBDS1_REG {
    Uint32  all;
    struct  GPBDS1_BITS  bit;
};

struct GPBDS2_BITS {                    // bits description
    Uint32 GPIO48:2;                     // 0 Pull-Down Disable control for this pin
    Uint32 GPIO49:2;                     // 3:2 Pull-Down Disable control for this pin
    Uint32 GPIO50:2;                     // 4 Pull-Down Disable control for this pin
    Uint32 GPIO51:2;                     // 6 Pull-Down Disable control for this pin
    Uint32 GPIO52:2;                     // 9:8 Pull-Down Disable control for this pin
    Uint32 GPIO53:2;                     // 11:10 Pull-Down Disable control for this pin
    Uint32 GPIO54:2;                     // 13:12 Pull-Down Disable control for this pin
    Uint32 GPIO55:2;                     // 15:14 Pull-Down Disable control for this pin
    Uint32 GPIO56:1;                     // 16 Pull-Down Disable control for this pin
    Uint32 rsvd1:1;                     // 17 Reserved
    Uint32 GPIO57:1;                    // 18 Pull-Down Disable control for this pin
    Uint32 rsvd2:1;                     // 19 Reserved
    Uint32 GPIO58:2;                    // 21:20 Pull-Down Disable control for this pin
    Uint32 GPIO59:2;                    // 23:22 Pull-Down Disable control for this pin
    Uint32 GPIO60:2;                    // 25:24 Pull-Down Disable control for this pin
    Uint32 GPIO61:2;                    // 27:26:26 Pull-Down Disable control for this pin
    Uint32 GPIO62:2;                    // 29:28 Pull-Down Disable control for this pin
    Uint32 GPIO63:2;                    // 31:30 Pull-Down Disable control for this pin
};

union GPBDS2_REG {
    Uint32  all;
    struct  GPBDS2_BITS  bit;
};

struct GPBIS_BITS {                    // bits description
    Uint32 GPIO32:1;                     // 0 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO33:1;                     // 1 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO34:1;                     // 2 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO35:1;                     // 3 GPIO B Schmitt Trigger  control for this pin
    Uint32 rsvd1:1;					     // 4 Reserved
    Uint32 GPIO37:1;                     // 5 GPIO B Schmitt Trigger  control for this pin
    Uint32 rsvd2:1;					     // 6 Reserved
    Uint32 GPIO39:1;                     // 7 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO40:1;                     // 8 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO41:1;                     // 9 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO42:1;                    // 10 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO43:1;                    // 11 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO44:1;                    // 12 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO45:1;                    // 13 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO46:1;                    // 14 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO47:1;                    // 15 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO48:1;                    // 16 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO49:1;                    // 17 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO50:1;                    // 18 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO51:1;                    // 19 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO52:1;                    // 20 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO53:1;                    // 21 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO54:1;                    // 22 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO55:1;                    // 23 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO56:1;                    // 24 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO57:1;                    // 25 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO58:1;                    // 26 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO59:1;                    // 27 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO60:1;                    // 28 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO61:1;                    // 29 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO62:1;                    // 30 GPIO B Schmitt Trigger  control for this pin
    Uint32 GPIO63:1;                    // 31 GPIO B Schmitt Trigger  control for this pin
};

union GPBIS_REG {
    Uint32  all;
    struct  GPBIS_BITS  bit;
};

struct GPBOUTINV_BITS {                    // bits description
    Uint32 GPIO32:1;                     // 0 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO33:1;                     // 1 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO34:1;                     // 2 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO35:1;                     // 3 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO36:1;                     // 4 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO37:1;                     // 5 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO38:1;                     // 6 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO39:1;                     // 7 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO40:1;                     // 8 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO41:1;                     // 9 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO42:1;                    // 10 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO43:1;                    // 11 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO44:1;                    // 12 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO45:1;                    // 13 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO46:1;                    // 14 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO47:1;                    // 15 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO48:1;                    // 16 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO49:1;                    // 17 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO50:1;                    // 18 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO51:1;                    // 19 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO52:1;                    // 20 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO53:1;                    // 21 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO54:1;                    // 22 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO55:1;                    // 23 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO56:1;                    // 24 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO57:1;                    // 25 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO58:1;                    // 26 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO59:1;                    // 27 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO60:1;                    // 28 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO61:1;                    // 29 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO62:1;                    // 30 GPIO B output Polarity Invert control for this pin
    Uint32 GPIO63:1;                    // 31 GPIO B output Polarity Invert control for this pin
};

union GPBOUTINV_REG {
    Uint32  all;
    struct  GPBOUTINV_BITS  bit;
};

struct GPBLOOPEN_BITS {                    // bits description
    Uint32 GPIO32:1;                     // 0 GPIO B LOOP Enable control for this pin
    Uint32 GPIO33:1;                     // 1 GPIO B LOOP Enable control for this pin
    Uint32 GPIO34:1;                     // 2 GPIO B LOOP Enable control for this pin
    Uint32 GPIO35:1;                     // 3 GPIO B LOOP Enable control for this pin
    Uint32 GPIO36:1;                     // 4 GPIO B LOOP Enable control for this pin
    Uint32 GPIO37:1;                     // 5 GPIO B LOOP Enable control for this pin
    Uint32 GPIO38:1;                     // 6 GPIO B LOOP Enable control for this pin
    Uint32 GPIO39:1;                     // 7 GPIO B LOOP Enable control for this pin
    Uint32 GPIO40:1;                     // 8 GPIO B LOOP Enable control for this pin
    Uint32 GPIO41:1;                     // 9 GPIO B LOOP Enable control for this pin
    Uint32 GPIO42:1;                    // 10 GPIO B LOOP Enable control for this pin
    Uint32 GPIO43:1;                    // 11 GPIO B LOOP Enable control for this pin
    Uint32 GPIO44:1;                    // 12 GPIO B LOOP Enable control for this pin
    Uint32 GPIO45:1;                    // 13 GPIO B LOOP Enable control for this pin
    Uint32 GPIO46:1;                    // 14 GPIO B LOOP Enable control for this pin
    Uint32 GPIO47:1;                    // 15 GPIO B LOOP Enable control for this pin
    Uint32 GPIO48:1;                    // 16 GPIO B LOOP Enable control for this pin
    Uint32 GPIO49:1;                    // 17 GPIO B LOOP Enable control for this pin
    Uint32 GPIO50:1;                    // 18 GPIO B LOOP Enable control for this pin
    Uint32 GPIO51:1;                    // 19 GPIO B LOOP Enable control for this pin
    Uint32 GPIO52:1;                    // 20 GPIO B LOOP Enable control for this pin
    Uint32 GPIO53:1;                    // 21 GPIO B LOOP Enable control for this pin
    Uint32 GPIO54:1;                    // 22 GPIO B LOOP Enable control for this pin
    Uint32 GPIO55:1;                    // 23 GPIO B LOOP Enable control for this pin
    Uint32 GPIO56:1;                    // 24 GPIO B LOOP Enable control for this pin
    Uint32 GPIO57:1;                    // 25 GPIO B LOOP Enable control for this pin
    Uint32 GPIO58:1;                    // 26 GPIO B LOOP Enable control for this pin
    Uint32 GPIO59:1;                    // 27 GPIO B LOOP Enable control for this pin
    Uint32 GPIO60:1;                    // 28 GPIO B LOOP Enable control for this pin
    Uint32 GPIO61:1;                    // 29 GPIO B LOOP Enable control for this pin
    Uint32 GPIO62:1;                    // 30 GPIO B LOOP Enable control for this pin
    Uint32 GPIO63:1;                    // 31 GPIO B LOOP Enable control for this pin
};

union GPBLOOPEN_REG {
    Uint32  all;
    struct  GPBLOOPEN_BITS  bit;
};

struct GPBPI2C_MODE_BITS {                    // bits description
    Uint32 GPIO32:1;                     // 0 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO33:1;                     // 1 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO34:1;                     // 2 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO35:1;                     // 3 GPIO B  PI2C MODE control for this pin
    Uint32 rsvd1:4;                      //  Reserved
    Uint32 GPIO40:1;                     // 8 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO41:1;                     // 9 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO42:1;                    // 10 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO43:1;                    // 11 GPIO B  PI2C MODE control for this pin
    Uint32 rsvd2:12;                      //  Reserved
    Uint32 GPIO56:1;                    // 24 GPIO B  PI2C MODE control for this pin
    Uint32 GPIO57:1;                    // 25 GPIO B  PI2C MODE control for this pin
    Uint32 rsvd3:6;                     // 31:30 Reserved
};

union GPBPI2C_MODE_REG {
    Uint32  all;
    struct  GPBPI2C_MODE_BITS  bit;
};





struct GPCPDD_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Pull Down Disable control for this pin
    Uint32 GPIO65:1;                     // 1 Pull Down Disable control for this pin
    Uint32 GPIO66:1;                     // 2 Pull Down Disable control for this pin
    Uint32 GPIO67:1;                     // 3 Pull Down Disable control for this pin
    Uint32 GPIO68:1;                     // 4 Pull Down Disable control for this pin
    Uint32 GPIO69:1;                     // 5 Pull Down Disable control for this pin
    Uint32 GPIO70:1;                     // 6 Pull Down Disable control for this pin
    Uint32 GPIO71:1;                     // 7 Pull Down Disable control for this pin
    Uint32 GPIO72:1;                     // 8 Pull Down Disable control for this pin
    Uint32 GPIO73:1;                     // 9 Pull Down Disable control for this pin
    Uint32 GPIO74:1;                    // 10 Pull Down Disable control for this pin
    Uint32 GPIO75:1;                    // 11 Pull Down Disable control for this pin
    Uint32 GPIO76:1;                    // 12 Pull Down Disable control for this pin
    Uint32 GPIO77:1;                    // 13 Pull Down Disable control for this pin
    Uint32 GPIO78:1;                    // 14 Pull Down Disable control for this pin
    Uint32 GPIO79:1;                    // 15 Pull Down Disable control for this pin
    Uint32 GPIO80:1;                    // 16 Pull Down Disable control for this pin
    Uint32 GPIO81:1;                    // 17 Pull Down Disable control for this pin
    Uint32 GPIO82:1;                    // 18 Pull Down Disable control for this pin
    Uint32 GPIO83:1;                    // 19 Pull Down Disable control for this pin
    Uint32 GPIO84:1;                    // 20 Pull Down Disable control for this pin
    Uint32 GPIO85:1;                    // 21 Pull Down Disable control for this pin
    Uint32 GPIO86:1;                    // 22 Pull Down Disable control for this pin
    Uint32 GPIO87:1;                    // 23 Pull Down Disable control for this pin
    Uint32 GPIO88:1;                    // 24 Pull Down Disable control for this pin
    Uint32 GPIO89:1;                    // 25 Pull Down Disable control for this pin
    Uint32 GPIO90:1;                    // 26 Pull Down Disable control for this pin
    Uint32 GPIO91:1;                    // 27 Pull Down Disable control for this pin
    Uint32 GPIO92:1;                    // 28 Pull Down Disable control for this pin
    Uint32 GPIO93:1;                    // 29 Pull Down Disable control for this pin
    Uint32 GPIO94:1;                    // 30 Pull Down Disable control for this pin
    Uint32 GPIO95:1;                    // 31 Pull Down Disable control for this pin
};

union GPCPDD_REG {
    Uint32  all;
    struct  GPCPDD_BITS  bit;
};

struct GPCDS1_BITS {                  // bits description
    Uint32 GPIO64:2;                     // 1:0 Defines pin-muxing selection for GPIO0
    Uint32 GPIO65:2;                     // 3:2 Defines pin-muxing selection for GPIO1
    Uint32 GPIO66:1;                     // 5:4 Defines pin-muxing selection for GPIO2
    Uint32 rsvd1:1;                     // Reserved
    Uint32 GPIO67:2;                     // 7:6 Defines pin-muxing selection for GPIO3
    Uint32 GPIO68:2;                     // 9:8 Defines pin-muxing selection for GPIO4
    Uint32 GPIO69:1;                     // 11:10 Defines pin-muxing selection for GPIO5
    Uint32 rsvd2:1;                     // Reserved
    Uint32 GPIO70:2;                     // 13:12 Defines pin-muxing selection for GPIO6
    Uint32 GPIO71:2;                     // 15:14 Defines pin-muxing selection for GPIO7
    Uint32 GPIO72:2;                     // 17:16 Defines pin-muxing selection for GPIO8
    Uint32 GPIO73:2;                     // 19:18 Defines pin-muxing selection for GPIO9
    Uint32 GPIO74:2;                    // 21:20 Defines pin-muxing selection for GPIO10
    Uint32 GPIO75:2;                    // 23:22 Defines pin-muxing selection for GPIO11
    Uint32 GPIO76:2;                    // 25:24 Defines pin-muxing selection for GPIO76
    Uint32 GPIO77:2;                    // 27:26 Defines pin-muxing selection for GPIO77
    Uint32 GPIO78:2;                    // 29:28 Defines pin-muxing selection for GPIO78
    Uint32 GPIO79:2;                    // 31:30 Defines pin-muxing selection for GPIO79
};

union GPCDS1_REG {
    Uint32  all;
    struct  GPCDS1_BITS  bit;
};

struct GPCDS2_BITS {                  // bits description
    Uint32 GPIO80:2;                    // 1:0 Defines pin-muxing selection for GPIO80
    Uint32 GPIO81:2;                    // 3:2 Defines pin-muxing selection for GPIO81
    Uint32 GPIO82:2;                    // 5:4 Defines pin-muxing selection for GPIO82
    Uint32 GPIO83:2;                    // 7:6 Defines pin-muxing selection for GPIO83
    Uint32 GPIO84:2;                    // 9:8 Defines pin-muxing selection for GPIO84
    Uint32 GPIO85:2;                    // 11:10 Defines pin-muxing selection for GPIO85
    Uint32 GPIO86:2;                    // 13:12 Defines pin-muxing selection for GPIO86
    Uint32 GPIO87:2;                    // 15:14 Defines pin-muxing selection for GPIO87
    Uint32 GPIO88:2;                    // 17:16 Defines pin-muxing selection for GPIO88
    Uint32 GPIO89:2;                    // 19:18 Defines pin-muxing selection for GPIO89
    Uint32 GPIO90:2;                    // 21:20 Defines pin-muxing selection for GPIO90
    Uint32 GPIO91:1;                    // 23:22 Defines pin-muxing selection for GPIO91
    Uint32 rsvd1:1;                     // Reserved
    Uint32 GPIO92:1;                    // 25:24 Defines pin-muxing selection for GPIO92
    Uint32 rsvd2:1;                     // Reserved
    Uint32 GPIO93:1;                    // 27:26 Defines pin-muxing selection for GPIO93
    Uint32 rsvd3:1;                     // Reserved
    Uint32 GPIO94:1;                    // 29:28 Defines pin-muxing selection for GPIO94
    Uint32 rsvd4:1;                     // Reserved
    Uint32 GPIO95:2;                    // 31:30 Defines pin-muxing selection for GPIO95
};

union GPCDS2_REG {
    Uint32  all;
    struct  GPCDS2_BITS  bit;
};

struct GPCIS_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Input inversion control for this pin
    Uint32 GPIO65:1;                     // 1 Input inversion control for this pin
    Uint32 GPIO66:1;                     // 2 Input inversion control for this pin
    Uint32 GPIO67:1;                     // 3 Input inversion control for this pin
    Uint32 GPIO68:1;                     // 4 Input inversion control for this pin
    Uint32 GPIO69:1;                     // 5 Input inversion control for this pin
    Uint32 GPIO70:1;                     // 6 Input inversion control for this pin
    Uint32 GPIO71:1;                     // 7 Input inversion control for this pin
    Uint32 GPIO72:1;                     // 8 Input inversion control for this pin
    Uint32 GPIO73:1;                     // 9 Input inversion control for this pin
    Uint32 GPIO74:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO75:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO76:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO77:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO78:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO79:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO80:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO81:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO82:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO83:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO84:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO85:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO86:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO87:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO88:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO89:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO90:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO91:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO92:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO93:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO94:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO95:1;                    // 31 Input inversion control for this pin
};

union GPCIS_REG {
    Uint32  all;
    struct  GPCIS_BITS  bit;
};


struct GPCOUTINV_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Input inversion control for this pin
    Uint32 GPIO65:1;                     // 1 Input inversion control for this pin
    Uint32 GPIO66:1;                     // 2 Input inversion control for this pin
    Uint32 GPIO67:1;                     // 3 Input inversion control for this pin
    Uint32 GPIO68:1;                     // 4 Input inversion control for this pin
    Uint32 GPIO69:1;                     // 5 Input inversion control for this pin
    Uint32 GPIO70:1;                     // 6 Input inversion control for this pin
    Uint32 GPIO71:1;                     // 7 Input inversion control for this pin
    Uint32 GPIO72:1;                     // 8 Input inversion control for this pin
    Uint32 GPIO73:1;                     // 9 Input inversion control for this pin
    Uint32 GPIO74:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO75:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO76:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO77:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO78:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO79:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO80:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO81:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO82:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO83:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO84:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO85:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO86:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO87:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO88:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO89:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO90:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO91:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO92:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO93:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO94:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO95:1;                    // 31 Input inversion control for this pin
};

union GPCOUTINV_REG {
    Uint32  all;
    struct  GPCOUTINV_BITS  bit;
};


struct GPCLOOPEN_BITS {                    // bits description
    Uint32 GPIO64:1;                     // 0 Input inversion control for this pin
    Uint32 GPIO65:1;                     // 1 Input inversion control for this pin
    Uint32 GPIO66:1;                     // 2 Input inversion control for this pin
    Uint32 GPIO67:1;                     // 3 Input inversion control for this pin
    Uint32 GPIO68:1;                     // 4 Input inversion control for this pin
    Uint32 GPIO69:1;                     // 5 Input inversion control for this pin
    Uint32 GPIO70:1;                     // 6 Input inversion control for this pin
    Uint32 GPIO71:1;                     // 7 Input inversion control for this pin
    Uint32 GPIO72:1;                     // 8 Input inversion control for this pin
    Uint32 GPIO73:1;                     // 9 Input inversion control for this pin
    Uint32 GPIO74:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO75:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO76:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO77:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO78:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO79:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO80:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO81:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO82:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO83:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO84:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO85:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO86:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO87:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO88:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO89:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO90:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO91:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO92:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO93:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO94:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO95:1;                    // 31 Input inversion control for this pin
};

union GPCLOOPEN_REG {
    Uint32  all;
    struct  GPCLOOPEN_BITS  bit;
};


struct GPCPI2C_MODE_BITS {                    // bits description
    Uint32 rsvd1:2;                      //  Reserved
    Uint32 GPIO66:1;                     // 2 Input inversion control for this pin
    Uint32 rsvd2:2;                      //  Reserved
    Uint32 GPIO69:1;                     // 5 Input inversion control for this pin
    Uint32 rsvd3:21;                      //  Reserved
    Uint32 GPIO91:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO92:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO93:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO94:1;                    // 30 Input inversion control for this pin
    Uint32 rsvd4:1;                      //  Reserved
};

union GPCPI2C_MODE_REG {
    Uint32  all;
    struct  GPCPI2C_MODE_BITS  bit;
};








struct GPDPDD_BITS {                    // bits description
    Uint32 GPIO96:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO97:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO98:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO99:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO100:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO101:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO102:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO103:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO104:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO105:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO106:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO107:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO108:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO109:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO110:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO111:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO112:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO113:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO114:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO115:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO116:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO117:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO118:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO119:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO120:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO121:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO122:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO123:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO124:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO125:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO126:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO127:1;                    // 31 Pull-Up Disable control for this pin
};

union GPDPDD_REG {
    Uint32  all;
    struct  GPDPDD_BITS  bit;
};


struct GPDDS1_BITS {                  // bits description
    Uint32 GPIO96:2;                    // 1:0 Defines pin-muxing selection for GPIO96
    Uint32 GPIO97:2;                    // 3:2 Defines pin-muxing selection for GPIO97
    Uint32 GPIO98:2;                    // 5:4 Defines pin-muxing selection for GPIO98
    Uint32 GPIO99:2;                    // 7:6 Defines pin-muxing selection for GPIO99
    Uint32 GPIO100:2;                    // 9:8 Defines pin-muxing selection for GPIO100
    Uint32 GPIO101:2;                    // 11:10 Defines pin-muxing selection for GPIO101
    Uint32 GPIO102:2;                    // 13:12 Defines pin-muxing selection for GPIO102
    Uint32 GPIO103:2;                    // 15:14 Defines pin-muxing selection for GPIO103
    Uint32 GPIO104:1;                    // 17:16 Defines pin-muxing selection for GPIO104
    Uint32 rsvd1:1;                     // Reserved
    Uint32 GPIO105:1;                    // 19:18 Defines pin-muxing selection for GPIO105
    Uint32 rsvd2:1;                     // Reserved
    Uint32 GPIO106:2;                    // 21:20 Defines pin-muxing selection for GPIO106
    Uint32 GPIO107:2;                    // 23:22 Defines pin-muxing selection for GPIO107
    Uint32 GPIO108:2;                    // 25:24 Defines pin-muxing selection for GPIO108
    Uint32 GPIO109:2;                    // 27:26 Defines pin-muxing selection for GPIO109
    Uint32 GPIO110:2;                    // 29:28 Defines pin-muxing selection for GPIO110
    Uint32 GPIO111:2;                    // 31:30 Defines pin-muxing selection for GPIO111
};

union GPDDS1_REG {
    Uint32  all;
    struct  GPDDS1_BITS  bit;
};

struct GPDDS2_BITS {                  // bits description
    Uint32 GPIO112:2;                    // 1:0 Defines pin-muxing selection for GPIO112
    Uint32 GPIO113:2;                    // 3:2 Defines pin-muxing selection for GPIO113
    Uint32 GPIO114:2;                    // 5:4 Defines pin-muxing selection for GPIO114
    Uint32 GPIO115:2;                    // 7:6 Defines pin-muxing selection for GPIO115
    Uint32 GPIO116:2;                    // 9:8 Defines pin-muxing selection for GPIO116
    Uint32 GPIO117:2;                    // 11:10 Defines pin-muxing selection for GPIO117
    Uint32 GPIO118:2;                    // 13:12 Defines pin-muxing selection for GPIO118
    Uint32 GPIO119:2;                    // 15:14 Defines pin-muxing selection for GPIO119
    Uint32 GPIO120:2;                    // 17:16 Defines pin-muxing selection for GPIO120
    Uint32 GPIO121:2;                    // 19:18 Defines pin-muxing selection for GPIO121
    Uint32 GPIO122:2;                    // 21:20 Defines pin-muxing selection for GPIO122
    Uint32 GPIO123:2;                    // 23:22 Defines pin-muxing selection for GPIO123
    Uint32 GPIO124:2;                    // 25:24 Defines pin-muxing selection for GPIO124
    Uint32 GPIO125:2;                    // 27:26 Defines pin-muxing selection for GPIO125
    Uint32 GPIO126:2;                    // 29:28 Defines pin-muxing selection for GPIO126
    Uint32 GPIO127:2;                    // 31:30 Defines pin-muxing selection for GPIO127
};

union GPDDS2_REG {
    Uint32  all;
    struct  GPDDS2_BITS  bit;
};


struct GPDIS_BITS {                    // bits description
    Uint32 GPIO96:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO97:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO98:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO99:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO100:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO101:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO102:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO103:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO104:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO105:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO106:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO107:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO108:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO109:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO110:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO111:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO112:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO113:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO114:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO115:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO116:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO117:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO118:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO119:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO120:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO121:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO122:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO123:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO124:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO125:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO126:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO127:1;                    // 31 Input inversion control for this pin
};

union GPDIS_REG {
    Uint32  all;
    struct  GPDIS_BITS  bit;
};


struct GPDOUTINV_BITS {                    // bits description
    Uint32 GPIO96:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO97:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO98:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO99:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO100:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO101:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO102:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO103:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO104:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO105:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO106:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO107:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO108:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO109:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO110:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO111:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO112:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO113:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO114:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO115:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO116:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO117:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO118:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO119:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO120:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO121:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO122:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO123:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO124:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO125:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO126:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO127:1;                    // 31 Input inversion control for this pin
};

union GPDOUTINV_REG {
    Uint32  all;
    struct  GPDOUTINV_BITS  bit;
};

struct GPDLOOPEN_BITS {                    // bits description
    Uint32 GPIO96:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO97:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO98:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO99:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO100:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO101:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO102:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO103:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO104:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO105:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO106:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO107:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO108:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO109:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO110:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO111:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO112:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO113:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO114:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO115:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO116:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO117:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO118:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO119:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO120:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO121:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO122:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO123:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO124:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO125:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO126:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO127:1;                    // 31 Input inversion control for this pin
};

union GPDLOOPEN_REG {
    Uint32  all;
    struct  GPDLOOPEN_BITS  bit;
};

struct GPDPI2C_MODE_BITS {                    // bits description
    Uint32 rsvd1:8;                      //  Reserved
    Uint32 GPIO104:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO105:1;                    // 9 Input inversion control for this pin
    Uint32 rsvd2:22;                      //  Reserved
};

union GPDPI2C_MODE_REG {
    Uint32  all;
    struct  GPDPI2C_MODE_BITS  bit;
};








struct GPEPDD_BITS {                    // bits description
    Uint32 GPIO128:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO129:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO130:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO131:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO132:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO133:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO134:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO135:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO136:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO137:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO138:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO139:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO140:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO141:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO142:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO143:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO144:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO145:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO146:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO147:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO148:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO149:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO150:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO151:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO152:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO153:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO154:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO155:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO156:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO157:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO158:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO159:1;                    // 31 Pull-Up Disable control for this pin
};

union GPEPDD_REG {
    Uint32  all;
    struct  GPEPDD_BITS  bit;
};


struct GPEDS1_BITS {                  // bits description
    Uint32 GPIO128:2;                    // 1:0 Defines pin-muxing selection for GPIO128
    Uint32 GPIO129:2;                    // 3:2 Defines pin-muxing selection for GPIO129
    Uint32 GPIO130:2;                    // 5:4 Defines pin-muxing selection for GPIO130
    Uint32 GPIO131:2;                    // 7:6 Defines pin-muxing selection for GPIO131
    Uint32 GPIO132:2;                    // 9:8 Defines pin-muxing selection for GPIO132
    Uint32 GPIO133:2;                    // 11:10 Defines pin-muxing selection for GPIO133
    Uint32 GPIO134:2;                    // 13:12 Defines pin-muxing selection for GPIO134
    Uint32 GPIO135:2;                    // 15:14 Defines pin-muxing selection for GPIO135
    Uint32 GPIO136:2;                    // 17:16 Defines pin-muxing selection for GPIO136
    Uint32 GPIO137:2;                    // 19:18 Defines pin-muxing selection for GPIO137
    Uint32 GPIO138:2;                    // 21:20 Defines pin-muxing selection for GPIO138
    Uint32 GPIO139:2;                    // 23:22 Defines pin-muxing selection for GPIO139
    Uint32 GPIO140:2;                    // 25:24 Defines pin-muxing selection for GPIO140
    Uint32 GPIO141:2;                    // 27:26 Defines pin-muxing selection for GPIO141
    Uint32 GPIO142:2;                    // 29:28 Defines pin-muxing selection for GPIO142
    Uint32 GPIO143:2;                    // 31:30 Defines pin-muxing selection for GPIO143
};

union GPEDS1_REG {
    Uint32  all;
    struct  GPEDS1_BITS  bit;
};

struct GPEDS2_BITS {                  // bits description
    Uint32 GPIO144:2;                    // 1:0 Defines pin-muxing selection for GPIO144
    Uint32 GPIO145:2;                    // 3:2 Defines pin-muxing selection for GPIO145
    Uint32 GPIO146:2;                    // 5:4 Defines pin-muxing selection for GPIO146
    Uint32 GPIO147:2;                    // 7:6 Defines pin-muxing selection for GPIO147
    Uint32 GPIO148:2;                    // 9:8 Defines pin-muxing selection for GPIO148
    Uint32 GPIO149:2;                    // 11:10 Defines pin-muxing selection for GPIO149
    Uint32 GPIO150:2;                    // 13:12 Defines pin-muxing selection for GPIO150
    Uint32 GPIO151:1;                    // 15:14 Defines pin-muxing selection for GPIO151
    Uint32 rsvd1:1;                     // Reserved
    Uint32 GPIO152:1;                    // 17:16 Defines pin-muxing selection for GPIO152
    Uint32 rsvd2:1;                     // Reserved
    Uint32 GPIO153:1;                    // 19:18 Defines pin-muxing selection for GPIO153
    Uint32 rsvd3:1;                     // Reserved
    Uint32 GPIO154:1;                    // 21:20 Defines pin-muxing selection for GPIO154
    Uint32 rsvd4:1;                     // Reserved
    Uint32 GPIO155:2;                    // 23:22 Defines pin-muxing selection for GPIO155
    Uint32 GPIO156:2;                    // 25:24 Defines pin-muxing selection for GPIO156
    Uint32 GPIO157:2;                    // 27:26 Defines pin-muxing selection for GPIO157
    Uint32 GPIO158:2;                    // 29:28 Defines pin-muxing selection for GPIO158
    Uint32 GPIO159:2;                    // 31:30 Defines pin-muxing selection for GPIO159
};

union GPEDS2_REG {
    Uint32  all;
    struct  GPEDS2_BITS  bit;
};



struct GPEIS_BITS {                    // bits description
    Uint32 GPIO128:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO129:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO130:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO131:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO132:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO133:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO134:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO135:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO136:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO137:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO138:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO139:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO140:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO141:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO142:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO143:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO144:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO145:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO146:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO147:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO148:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO149:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO150:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO151:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO152:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO153:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO154:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO155:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO156:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO157:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO158:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO159:1;                    // 31 Input inversion control for this pin
};

union GPEIS_REG {
    Uint32  all;
    struct  GPEIS_BITS  bit;
};




struct GPEOUTINV_BITS {                    // bits description
    Uint32 GPIO128:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO129:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO130:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO131:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO132:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO133:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO134:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO135:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO136:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO137:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO138:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO139:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO140:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO141:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO142:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO143:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO144:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO145:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO146:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO147:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO148:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO149:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO150:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO151:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO152:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO153:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO154:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO155:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO156:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO157:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO158:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO159:1;                    // 31 Input inversion control for this pin
};

union GPEOUTINV_REG {
    Uint32  all;
    struct  GPEOUTINV_BITS  bit;
};
struct GPELOOPEN_BITS {                    // bits description
    Uint32 GPIO128:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO129:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO130:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO131:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO132:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO133:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO134:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO135:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO136:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO137:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO138:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO139:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO140:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO141:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO142:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO143:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO144:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO145:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO146:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO147:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO148:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO149:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO150:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO151:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO152:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO153:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO154:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO155:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO156:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO157:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO158:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO159:1;                    // 31 Input inversion control for this pin
};

union GPELOOPEN_REG {
    Uint32  all;
    struct  GPELOOPEN_BITS  bit;
};
struct GPEPI2C_MODE_BITS {                    // bits description
    Uint32 rsvd1:23;                      //  Reserved
    Uint32 GPIO151:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO152:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO153:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO154:1;                    // 26 Input inversion control for this pin
    Uint32 rsvd2:5;                      //  Reserved
};

union GPEPI2C_MODE_REG {
    Uint32  all;
    struct  GPEPI2C_MODE_BITS  bit;
};







struct GPFPDD_BITS {                    // bits description
    Uint32 GPIO160:1;                    // 0 Pull-Up Disable control for this pin
    Uint32 GPIO161:1;                    // 1 Pull-Up Disable control for this pin
    Uint32 GPIO162:1;                    // 2 Pull-Up Disable control for this pin
    Uint32 GPIO163:1;                    // 3 Pull-Up Disable control for this pin
    Uint32 GPIO164:1;                    // 4 Pull-Up Disable control for this pin
    Uint32 GPIO165:1;                    // 5 Pull-Up Disable control for this pin
    Uint32 GPIO166:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO167:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO168:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 rsvd1:23;                     // Reserved
};

union GPFPDD_REG {
    Uint32  all;
    struct  GPFPDD_BITS  bit;
};


struct GPFDS1_BITS {                  // bits description
    Uint32 GPIO160:2;                    // 1:0 Defines pin-muxing selection for GPIO160
    Uint32 GPIO161:2;                    // 3:2 Defines pin-muxing selection for GPIO161
    Uint32 GPIO162:2;                    // 5:4 Defines pin-muxing selection for GPIO162
    Uint32 GPIO163:2;                    // 7:6 Defines pin-muxing selection for GPIO163
    Uint32 GPIO164:2;                    // 9:8 Defines pin-muxing selection for GPIO164
    Uint32 GPIO165:2;                    // 11:10 Defines pin-muxing selection for GPIO165
    Uint32 GPIO166:2;                    // 13:12 Defines pin-muxing selection for GPIO166
    Uint32 GPIO167:2;                    // 15:14 Defines pin-muxing selection for GPIO167
    Uint32 GPIO168:2;                    // 17:16 Defines pin-muxing selection for GPIO168
    Uint32 rsvd1:14;                     // Reserved
};

union GPFDS1_REG {
    Uint32  all;
    struct  GPFDS1_BITS  bit;
};


struct GPFIS_BITS {                    // bits description
    Uint32 GPIO160:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO161:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO162:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO163:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO164:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO165:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO166:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO167:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO168:1;                    // 8 Input inversion control for this pin
    Uint32 rsvd1:23;                     // Reserved
};

union GPFIS_REG {
    Uint32  all;
    struct  GPFIS_BITS  bit;
};



struct GPFOUTINV_BITS {                    // bits description
    Uint32 GPIO160:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO161:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO162:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO163:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO164:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO165:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO166:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO167:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO168:1;                    // 8 Input inversion control for this pin
    Uint32 rsvd1:23;                     // Reserved
};

union GPFOUTINV_REG {
    Uint32  all;
    struct  GPFOUTINV_BITS  bit;
};

struct GPFLOOPEN_BITS {                    // bits description
    Uint32 GPIO160:1;                    // 0 Input inversion control for this pin
    Uint32 GPIO161:1;                    // 1 Input inversion control for this pin
    Uint32 GPIO162:1;                    // 2 Input inversion control for this pin
    Uint32 GPIO163:1;                    // 3 Input inversion control for this pin
    Uint32 GPIO164:1;                    // 4 Input inversion control for this pin
    Uint32 GPIO165:1;                    // 5 Input inversion control for this pin
    Uint32 GPIO166:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO167:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO168:1;                    // 8 Input inversion control for this pin
    Uint32 rsvd1:23;                     // Reserved
};

union GPFLOOPEN_REG {
    Uint32  all;
    struct  GPFLOOPEN_BITS  bit;
};






struct GPGPDD_BITS {                    // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Pull-Up Disable control for this pin
    Uint32 GPIO199:1;                    // 7 Pull-Up Disable control for this pin
    Uint32 GPIO200:1;                    // 8 Pull-Up Disable control for this pin
    Uint32 GPIO201:1;                    // 9 Pull-Up Disable control for this pin
    Uint32 GPIO202:1;                    // 10 Pull-Up Disable control for this pin
    Uint32 GPIO203:1;                    // 11 Pull-Up Disable control for this pin
    Uint32 GPIO204:1;                    // 12 Pull-Up Disable control for this pin
    Uint32 GPIO205:1;                    // 13 Pull-Up Disable control for this pin
    Uint32 GPIO206:1;                    // 14 Pull-Up Disable control for this pin
    Uint32 GPIO207:1;                    // 15 Pull-Up Disable control for this pin
    Uint32 GPIO208:1;                    // 16 Pull-Up Disable control for this pin
    Uint32 GPIO209:1;                    // 17 Pull-Up Disable control for this pin
    Uint32 GPIO210:1;                    // 18 Pull-Up Disable control for this pin
    Uint32 GPIO211:1;                    // 19 Pull-Up Disable control for this pin
    Uint32 GPIO212:1;                    // 20 Pull-Up Disable control for this pin
    Uint32 GPIO213:1;                    // 21 Pull-Up Disable control for this pin
    Uint32 GPIO214:1;                    // 22 Pull-Up Disable control for this pin
    Uint32 GPIO215:1;                    // 23 Pull-Up Disable control for this pin
    Uint32 GPIO216:1;                    // 24 Pull-Up Disable control for this pin
    Uint32 GPIO217:1;                    // 25 Pull-Up Disable control for this pin
    Uint32 GPIO218:1;                    // 26 Pull-Up Disable control for this pin
    Uint32 GPIO219:1;                    // 27 Pull-Up Disable control for this pin
    Uint32 GPIO220:1;                    // 28 Pull-Up Disable control for this pin
    Uint32 GPIO221:1;                    // 29 Pull-Up Disable control for this pin
    Uint32 GPIO222:1;                    // 30 Pull-Up Disable control for this pin
    Uint32 GPIO223:1;                    // 31 Pull-Up Disable control for this pin
};

union GPGPDD_REG {
    Uint32  all;
    struct  GPGPDD_BITS  bit;
};



struct GPGDS1_BITS {                  // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:2;                    // 13:12 Defines pin-muxing selection for GPIO198
    Uint32 GPIO199:2;                    // 15:14 Defines pin-muxing selection for GPIO199
    Uint32 GPIO200:2;                    // 17:16 Defines pin-muxing selection for GPIO200
    Uint32 GPIO201:1;                    // 19:18 Defines pin-muxing selection for GPIO201
    Uint32 rsvd2:1;                     // Reserved
    Uint32 GPIO202:1;                    // 21:20 Defines pin-muxing selection for GPIO202
    Uint32 rsvd3:1;                     // Reserved
    Uint32 GPIO203:1;                    // 23:22 Defines pin-muxing selection for GPIO203
    Uint32 rsvd4:1;                     // Reserved
    Uint32 GPIO204:1;                    // 25:24 Defines pin-muxing selection for GPIO204
    Uint32 rsvd5:1;                     // Reserved
    Uint32 GPIO205:1;                    // 27:26 Defines pin-muxing selection for GPIO205
    Uint32 rsvd6:1;                     // Reserved
    Uint32 GPIO206:1;                    // 29:28 Defines pin-muxing selection for GPIO206
    Uint32 rsvd7:1;                     // Reserved
    Uint32 GPIO207:1;                    // 31:30 Defines pin-muxing selection for GPIO207
    Uint32 rsvd8:1;                     // Reserved
};

union GPGDS1_REG {
    Uint32  all;
    struct  GPGDS1_BITS  bit;
};

struct GPGDS2_BITS {                  // bits description
    Uint32 GPIO208:1;                    // 1:0 Defines pin-muxing selection for GPIO208
    Uint32 rsvd1:1;                     // Reserved
    Uint32 GPIO209:1;                    // 3:2 Defines pin-muxing selection for GPIO209
    Uint32 rsvd2:1;                     // Reserved
    Uint32 GPIO210:1;                    // 5:4 Defines pin-muxing selection for GPIO210
    Uint32 rsvd3:1;                     // Reserved
    Uint32 GPIO211:2;                    // 7:6 Defines pin-muxing selection for GPIO211
    Uint32 GPIO212:2;                    // 9:8 Defines pin-muxing selection for GPIO212
    Uint32 GPIO213:2;                    // 11:10 Defines pin-muxing selection for GPIO213
    Uint32 GPIO214:2;                    // 13:12 Defines pin-muxing selection for GPIO214
    Uint32 GPIO215:1;                    // 15:14 Defines pin-muxing selection for GPIO215
    Uint32 rsvd4:1;                     // Reserved
    Uint32 GPIO216:2;                    // 17:16 Defines pin-muxing selection for GPIO216
    Uint32 GPIO217:1;                    // 19:18 Defines pin-muxing selection for GPIO217
    Uint32 rsvd5:1;                     // Reserved
    Uint32 GPIO218:1;                    // 21:20 Defines pin-muxing selection for GPIO218
    Uint32 rsvd6:1;                     // Reserved
    Uint32 GPIO219:2;                    // 23:22 Defines pin-muxing selection for GPIO219
    Uint32 GPIO220:1;                    // 25:24 Defines pin-muxing selection for GPIO220
    Uint32 rsvd7:1;                     // Reserved
    Uint32 GPIO221:1;                    // 27:26 Defines pin-muxing selection for GPIO221
    Uint32 rsvd8:1;                     // Reserved
    Uint32 GPIO222:1;                    // 29:28 Defines pin-muxing selection for GPIO222
    Uint32 rsvd9:1;                     // Reserved
    Uint32 GPIO223:1;                    // 31:30 Defines pin-muxing selection for GPIO223
    Uint32 rsvd10:1;                     // Reserved
};

union GPGDS2_REG {
    Uint32  all;
    struct  GPGDS2_BITS  bit;
};


struct GPGIS_BITS {                    // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO199:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO200:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO201:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO202:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO203:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO204:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO205:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO206:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO207:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO208:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO209:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO210:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO211:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO212:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO213:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO214:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO215:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO216:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO217:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO218:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO219:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO220:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO221:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO222:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO223:1;                    // 31 Input inversion control for this pin
};

union GPGIS_REG {
    Uint32  all;
    struct  GPGIS_BITS  bit;
};



struct GPGOUTINV_BITS {                    // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO199:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO200:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO201:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO202:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO203:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO204:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO205:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO206:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO207:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO208:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO209:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO210:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO211:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO212:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO213:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO214:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO215:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO216:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO217:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO218:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO219:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO220:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO221:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO222:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO223:1;                    // 31 Input inversion control for this pin
};

union GPGOUTINV_REG {
    Uint32  all;
    struct  GPGOUTINV_BITS  bit;
};

struct GPGLOOPEN_BITS {                    // bits description
	Uint32 rsvd1:6;                      // 5:0 Reserved
    Uint32 GPIO198:1;                    // 6 Input inversion control for this pin
    Uint32 GPIO199:1;                    // 7 Input inversion control for this pin
    Uint32 GPIO200:1;                    // 8 Input inversion control for this pin
    Uint32 GPIO201:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO202:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO203:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO204:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO205:1;                    // 13 Input inversion control for this pin
    Uint32 GPIO206:1;                    // 14 Input inversion control for this pin
    Uint32 GPIO207:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO208:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO209:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO210:1;                    // 18 Input inversion control for this pin
    Uint32 GPIO211:1;                    // 19 Input inversion control for this pin
    Uint32 GPIO212:1;                    // 20 Input inversion control for this pin
    Uint32 GPIO213:1;                    // 21 Input inversion control for this pin
    Uint32 GPIO214:1;                    // 22 Input inversion control for this pin
    Uint32 GPIO215:1;                    // 23 Input inversion control for this pin
    Uint32 GPIO216:1;                    // 24 Input inversion control for this pin
    Uint32 GPIO217:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO218:1;                    // 26 Input inversion control for this pin
    Uint32 GPIO219:1;                    // 27 Input inversion control for this pin
    Uint32 GPIO220:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO221:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO222:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO223:1;                    // 31 Input inversion control for this pin
};

union GPGLOOPEN_REG {
    Uint32  all;
    struct  GPGLOOPEN_BITS  bit;
};

struct GPGPI2C_MODE_BITS {                    // bits description
	Uint32 rsvd1:9;                      // 8:0 Reserved
    Uint32 GPIO201:1;                    // 9 Input inversion control for this pin
    Uint32 GPIO202:1;                    // 10 Input inversion control for this pin
    Uint32 GPIO203:1;                    // 11 Input inversion control for this pin
    Uint32 GPIO204:1;                    // 12 Input inversion control for this pin
    Uint32 GPIO205:1;                    // 13 Input inversion control for this pin
    Uint32 rsvd2:1;                      // Reserved
    Uint32 GPIO207:1;                    // 15 Input inversion control for this pin
    Uint32 GPIO208:1;                    // 16 Input inversion control for this pin
    Uint32 GPIO209:1;                    // 17 Input inversion control for this pin
    Uint32 GPIO210:1;                    // 18 Input inversion control for this pin
    Uint32 rsvd3:4;                      //  Reserved
    Uint32 GPIO215:1;                    // 23 Input inversion control for this pin
    Uint32 rsvd4:1;                      //  Reserved
    Uint32 GPIO217:1;                    // 25 Input inversion control for this pin
    Uint32 GPIO218:1;                    // 26 Input inversion control for this pin
    Uint32 rsvd5:1;                      //  Reserved
    Uint32 GPIO220:1;                    // 28 Input inversion control for this pin
    Uint32 GPIO221:1;                    // 29 Input inversion control for this pin
    Uint32 GPIO222:1;                    // 30 Input inversion control for this pin
    Uint32 GPIO223:1;                    // 31 Input inversion control for this pin
};

union GPGPI2C_MODE_REG {
    Uint32  all;
    struct  GPGPI2C_MODE_BITS  bit;
};





struct GPHPDD_BITS {                    // bits description
    Uint32 GPIO224:1;                    // 31 Pull-Up Disable control for this pin
    Uint32 rsvd1:31;                      // 31:1 Reserved
};

union GPHPDD_REG {
    Uint32  all;
    struct  GPHPUD_BITS  bit;
};



struct GPHIS_BITS {                    // bits description
    Uint32 GPIO224:1;                    // 0 Schmitt Trigger control for this pin
    Uint32 GPIO225:1;                    // 1 Schmitt Trigger control for this pin
    Uint32 GPIO226:1;                    // 2 Schmitt Trigger control for this pin
    Uint32 GPIO227:1;                    // 3 Schmitt Trigger control for this pin
    Uint32 GPIO228:1;                    // 4 Schmitt Trigger control for this pin
    Uint32 GPIO229:1;                    // 5 Schmitt Trigger control for this pin
    Uint32 GPIO230:1;                    // 6 Schmitt Trigger control for this pin
    Uint32 GPIO231:1;                    // 7 Schmitt Trigger control for this pin
    Uint32 GPIO232:1;                    // 8 Schmitt Trigger control for this pin
    Uint32 GPIO233:1;                    // 9 Schmitt Trigger control for this pin
    Uint32 GPIO234:1;                    // 10 Schmitt Trigger control for this pin
    Uint32 GPIO235:1;                    // 11 Schmitt Trigger control for this pin
    Uint32 GPIO236:1;                    // 12 Schmitt Trigger control for this pin
    Uint32 GPIO237:1;                    // 13 Schmitt Trigger control for this pin
    Uint32 GPIO238:1;                    // 14 Schmitt Trigger control for this pin
    Uint32 GPIO239:1;                    // 15 Schmitt Trigger control for this pin
    Uint32 GPIO240:1;                    // 16 Schmitt Trigger control for this pin
    Uint32 GPIO241:1;                    // 17 Schmitt Trigger control for this pin
    Uint32 GPIO242:1;                    // 18 Schmitt Trigger control for this pin
    Uint32 rsvd1:13;					 //31:19 Reserved
};

union GPHIS_REG {
    Uint32  all;
    struct  GPHIS_BITS  bit;
};

struct GPHOUTINV_BITS {                    // bits description
    Uint32 GPIO224:1;                     // 0 output Polarity Invert control for this pin
    Uint32 rsvd1:31;                      // 31:1 Reserved
};

union GPHOUTINV_REG {
    Uint32  all;
    struct  GPHOUTINV_BITS  bit;
};

struct GPHLOOPEN_BITS {                    // bits description
    Uint32 GPIO224:1;                     // 0 LOOP Enable control for this pin
    Uint32 rsvd1:31;                      // 31:1 Reserved
};

union GPHLOOPEN_REG {
    Uint32  all;
    struct  GPHLOOPEN_BITS  bit;
};

struct GPHIE_BITS {                    // bits description
    Uint32 GPIO224:1;                    // 0 input Enable control for this pin
    Uint32 GPIO225:1;                    // 1 input Enable control for this pin
    Uint32 GPIO226:1;                    // 2 input Enable control for this pin
    Uint32 GPIO227:1;                    // 3 input Enable control for this pin
    Uint32 GPIO228:1;                    // 4 input Enable control for this pin
    Uint32 GPIO229:1;                    // 5 input Enable control for this pin
    Uint32 GPIO230:1;                    // 6 input Enable control for this pin
    Uint32 GPIO231:1;                    // 7 input Enable control for this pin
    Uint32 GPIO232:1;                    // 8 input Enable control for this pin
    Uint32 GPIO233:1;                    // 9 input Enable control for this pin
    Uint32 GPIO234:1;                    // 10 input Enable control for this pin
    Uint32 GPIO235:1;                    // 11 input Enable control for this pin
    Uint32 GPIO236:1;                    // 12 input Enable control for this pin
    Uint32 GPIO237:1;                    // 13 input Enable control for this pin
    Uint32 GPIO238:1;                    // 14 input Enable control for this pin
    Uint32 GPIO239:1;                    // 15 input Enable control for this pin
    Uint32 GPIO240:1;                    // 16 input Enable control for this pin
    Uint32 GPIO241:1;                    // 17 input Enable control for this pin
    Uint32 GPIO242:1;                    // 18 input Enable control for this pin
    Uint32 rsvd1:13;					 //31:19 Reserved
};

union GPHIE_REG {
    Uint32  all;
    struct  GPHIE_BITS  bit;
};

//
//struct CLK_REF_PIN_CTRL_BITS {                   // bits description
//    Uint32 CLK_REF_PIN_CTRL:5;                  // 4:0
//    Uint32 rsvd1:27;					     //31:5 Reserved
//};
//
//union CLK_REF_PIN_CTRL_REG {
//    Uint32  all;
//    struct  CLK_REF_PIN_CTRL_BITS  bit;
//};
//
//struct IO_IE_MODE_BITS {                   // bits description
//    Uint32 IO_IE_MODE:1;                  // 0
//    Uint32 rsvd1:31;					     //31:1 Reserved
//};
//
//union IO_IE_MODE_REG {
//    Uint32  all;
//    struct  IO_IE_MODE_BITS  bit;
//};
//






struct GPIO_CTRL_REGS {
    union   GPACTRL_REG                      GPACTRL;                      // GPIO A Qualification Sampling Period Control (GPIO0 to 31)
    union   GPAQSEL1_REG                     GPAQSEL1;                     // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
    union   GPAQSEL2_REG                     GPAQSEL2;                     // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
    union   GPAMUX1_REG                      GPAMUX1;                      // GPIO A Mux 1 Register (GPIO0 to 15)
    union   GPAMUX2_REG                      GPAMUX2;                      // GPIO A Mux 2 Register (GPIO16 to 31)
    Uint16                                   rsvd1[2];					   // Reserved
    union   GPAPUD_REG                       GPAPUD;                       // GPIO A Pull Up Disable Register (GPIO0 to 31)
    Uint16                                   rsvd2[2];                     // Reserved
    union   GPAINV_REG                       GPAINV;                       // GPIO A Input Polarity Invert Registers (GPIO0 to 31)
    Uint16                                   rsvd3[14];					   // Reserved
    union   GPAGMUX1_REG                     GPAGMUX1;                     // GPIO A Peripheral Group Mux (GPIO0 to 15)
    union   GPAGMUX2_REG                     GPAGMUX2;                     // GPIO A Peripheral Group Mux (GPIO16 to 31)
    Uint16                                   rsvd4[28];                    // Reserved

    union   GPBCTRL_REG                      GPBCTRL;                      // GPIO B Qualification Sampling Period Control (GPIO32 to 63)
    union   GPBQSEL1_REG                     GPBQSEL1;                     // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
    union   GPBQSEL2_REG                     GPBQSEL2;                     // GPIO B Qualifier Select 2 Register (GPIO48 to 63)
    union   GPBMUX1_REG                      GPBMUX1;                      // GPIO B Mux 1 Register (GPIO32 to 47)
    union   GPBMUX2_REG                      GPBMUX2;                      // GPIO B Mux 2 Register (GPIO48 to 63)
    Uint16                                   rsvd5[2];					   // Reserved
    union   GPBPUD_REG                       GPBPUD;                       // GPIO B Pull Up Disable Register (GPIO32 to 63)
    Uint16                                   rsvd6[2];                     // Reserved
    union   GPBINV_REG                       GPBINV;                       // GPIO B Input Polarity Invert Registers (GPIO32 to 63)
    Uint16                                   rsvd7[2];                     // Reserved
    union   GPBAMSEL_REG                     GPBAMSEL;					   // GPIO B Analog Mode Select register (GPIO0 to GPIO31)
    Uint16                                   rsvd8[10];                    // Reserved
    union   GPBGMUX1_REG                     GPBGMUX1;                     // GPIO B Peripheral Group Mux (GPIO32 to 47)
    union   GPBGMUX2_REG                     GPBGMUX2;                     // GPIO B Peripheral Group Mux (GPIO48 to 63)
    Uint16                                   rsvd9[28];                    // Reserved

    union   GPCCTRL_REG                      GPCCTRL;                      // GPIO C Qualification Sampling Period Control (GPIO64 to 95)
    union   GPCQSEL1_REG                     GPCQSEL1;                     // GPIO C Qualifier Select 1 Register (GPIO64 to 79)
    union   GPCQSEL2_REG                     GPCQSEL2;                     // GPIO C Qualifier Select 2 Register (GPIO80 to 95)
    union   GPCMUX1_REG                      GPCMUX1;                      // GPIO C Mux 1 Register (GPIO64 to 79)
    union   GPCMUX2_REG                      GPCMUX2;                      // GPIO C Mux 2 Register (GPIO80 to 95)
    Uint16                                   rsvd10[2];					   // Reserved
    union   GPCPUD_REG                       GPCPUD;                       // GPIO C Pull Up Disable Register (GPIO64 to 95)
    Uint16                                   rsvd11[2];                     // Reserved
    union   GPCINV_REG                       GPCINV;                       // GPIO C Input Polarity Invert Registers (GPIO64 to 95)
    Uint16                                   rsvd12[14];                    // Reserved
    union   GPCGMUX1_REG                     GPCGMUX1;                     // GPIO C Peripheral Group Mux (GPIO64 to 79)
    union   GPCGMUX2_REG                     GPCGMUX2;                     // GPIO C Peripheral Group Mux (GPIO80 to 95)
    Uint16                                   rsvd13[28];                    // Reserved

    union   GPDCTRL_REG                      GPDCTRL;                      // GPIO D Qualification Sampling Period Control (GPIO64 to 95)
    union   GPDQSEL1_REG                     GPDQSEL1;                     // GPIO D Qualifier Select 1 Register (GPIO64 to 79)
    union   GPDQSEL2_REG                     GPDQSEL2;                     // GPIO D Qualifier Select 2 Register (GPIO80 to 95)
    union   GPDMUX1_REG                      GPDMUX1;                      // GPIO D Mux 1 Register (GPIO64 to 79)
    union   GPDMUX2_REG                      GPDMUX2;                      // GPIO D Mux 2 Register (GPIO80 to 95)
    Uint16                                   rsvd14[2];					   // Reserved
    union   GPDPUD_REG                       GPDPUD;                       // GPIO D Pull Up Disable Register (GPIO64 to 95)
    Uint16                                   rsvd15[2];                     // Reserved
    union   GPDINV_REG                       GPDINV;                       // GPIO D Input Polarity Invert Registers (GPIO64 to 95)
    Uint16                                   rsvd16[14];                    // Reserved
    union   GPDGMUX1_REG                     GPDGMUX1;                     // GPIO D Peripheral Group Mux (GPIO64 to 79)
    union   GPDGMUX2_REG                     GPDGMUX2;                     // GPIO D Peripheral Group Mux (GPIO80 to 95)
    Uint16                                   rsvd17[28];                    // Reserved


    union   GPECTRL_REG                      GPECTRL;                      // GPIO E Qualification Sampling Period Control (GPIO64 to 95)
    union   GPEQSEL1_REG                     GPEQSEL1;                     // GPIO E Qualifier Select 1 Register (GPIO64 to 79)
    union   GPEQSEL2_REG                     GPEQSEL2;                     // GPIO E Qualifier Select 2 Register (GPIO80 to 95)
    union   GPEMUX1_REG                      GPEMUX1;                      // GPIO E Mux 1 Register (GPIO64 to 79)
    union   GPEMUX2_REG                      GPEMUX2;                      // GPIO E Mux 2 Register (GPIO80 to 95)
    Uint16                                   rsvd18[2];					   // Reserved
    union   GPEPUD_REG                       GPEPUD;                       // GPIO E Pull Up Disable Register (GPIO64 to 95)
    Uint16                                   rsvd19[2];                     // Reserved
    union   GPEINV_REG                       GPEINV;                       // GPIO E Input Polarity Invert Registers (GPIO64 to 95)
    Uint16                                   rsvd20[14];                    // Reserved
    union   GPEGMUX1_REG                     GPEGMUX1;                     // GPIO E Peripheral Group Mux (GPIO64 to 79)
    union   GPEGMUX2_REG                     GPEGMUX2;                     // GPIO E Peripheral Group Mux (GPIO80 to 95)
    Uint16                                   rsvd21[28];                    // Reserved

    union   GPFCTRL_REG                      GPFCTRL;                      // GPIO F Qualification Sampling Period Control (GPIO64 to 95)
    union   GPFQSEL1_REG                     GPFQSEL1;                     // GPIO F Qualifier Select 1 Register (GPIO64 to 79)
    union   GPFQSEL2_REG                     GPFQSEL2;                     // GPIO F Qualifier Select 2 Register (GPIO80 to 95)
    union   GPFMUX1_REG                      GPFMUX1;                      // GPIO F Mux 1 Register (GPIO64 to 79)
    union   GPFMUX2_REG                      GPFMUX2;                      // GPIO F Mux 2 Register (GPIO80 to 95)
    Uint16                                   rsvd22[2];					   // Reserved
    union   GPFPUD_REG                       GPFPUD;                       // GPIO F Pull Up Disable Register (GPIO64 to 95)
    Uint16                                   rsvd23[2];                     // Reserved
    union   GPFINV_REG                       GPFINV;                       // GPIO F Input Polarity Invert Registers (GPIO64 to 95)
    Uint16                                   rsvd24[14];                    // Reserved
    union   GPFGMUX1_REG                     GPFGMUX1;                     // GPIO F Peripheral Group Mux (GPIO64 to 79)
    union   GPFGMUX2_REG                     GPFGMUX2;                     // GPIO F Peripheral Group Mux (GPIO80 to 95)
    Uint16                                   rsvd25[28];                    // Reserved

    union   GPGCTRL_REG                      GPGCTRL;                      // GPIO G Qualification Sampling Period Control (GPIO64 to 95)
    union   GPGQSEL1_REG                     GPGQSEL1;                     // GPIO G Qualifier Select 1 Register (GPIO64 to 79)
    union   GPGQSEL2_REG                     GPGQSEL2;                     // GPIO G Qualifier Select 2 Register (GPIO80 to 95)
    union   GPGMUX1_REG                      GPGMUX1;                      // GPIO G Mux 1 Register (GPIO64 to 79)
    union   GPGMUX2_REG                      GPGMUX2;                      // GPIO G Mux 2 Register (GPIO80 to 95)
    Uint16                                   rsvd26[2];					   // Reserved
    union   GPGPUD_REG                       GPGPUD;                       // GPIO G Pull Up Disable Register (GPIO64 to 95)
    Uint16                                   rsvd27[2];                     // Reserved
    union   GPGINV_REG                       GPGINV;                       // GPIO G Input Polarity Invert Registers (GPIO64 to 95)
    Uint16                                   rsvd28[2];                    // Reserved
    union   GPGAMSEL_REG                     GPGAMSEL;					   // GPIO G Analog Mode Select register (GPIO0 to GPIO31)
    Uint16                                   rsvd29[10];                    // Reserved
    union   GPGGMUX1_REG                     GPGGMUX1;                     // GPIO G Peripheral Group Mux (GPIO64 to 79)
    union   GPGGMUX2_REG                     GPGGMUX2;                     // GPIO G Peripheral Group Mux (GPIO80 to 95)
    Uint16                                   rsvd30[28];                    // Reserved


    union   GPHCTRL_REG                      GPHCTRL;                      // GPIO H Qualification Sampling Period Control (GPIO64 to 95)
    union   GPHQSEL1_REG                     GPHQSEL1;                     // GPIO H Qualifier Select 1 Register (GPIO64 to 79)
    union   GPHQSEL2_REG                     GPHQSEL2;                     // GPIO H Qualifier Select 2 Register (GPIO80 to 95)
    union   GPHMUX1_REG                      GPHMUX1;                      // GPIO H Mux 1 Register (GPIO64 to 79)
    union   GPHMUX2_REG                      GPHMUX2;                      // GPIO H Mux 2 Register (GPIO80 to 95)
    Uint16                                   rsvd31[2];					   // Reserved
    union   GPHPUD_REG                       GPHPUD;                       // GPIO H Pull Up Disable Register (GPIO64 to 95)
    Uint16                                   rsvd32[2];                     // Reserved
    union   GPHINV_REG                       GPHINV;                       // GPIO H Input Polarity Invert Registers (GPIO64 to 95)
    Uint16                                   rsvd33[2];                    // Reserved
    union   GPHAMSEL_REG                     GPHAMSEL;					   // GPIO H Analog Mode Select register (GPIO0 to GPIO31)
    Uint16                                   rsvd34[10];                    // Reserved
    union   GPHGMUX1_REG                     GPHGMUX1;                     // GPIO H Peripheral Group Mux (GPIO64 to 79)
    union   GPHGMUX2_REG                     GPHGMUX2;                     // GPIO H Peripheral Group Mux (GPIO80 to 95)
    Uint16                                   rsvd35[28];                    // Reserved


    union   GPAPDD_REG                       GPAPDD;                       //GPIO A Pull Down Disable Register (GPIO0 to 31)
    union   GPADS1_REG                       GPADS1;                       //GPIO A Drive Strength 1 Register1 (GPIO0 to 15)
    union   GPADS2_REG                       GPADS2;                       //GPIO A Drive Strength Register2 (GPIO16 to 31)
    union   GPAIS_REG                        GPAIS;                        //GPIO A Schmitt Trigger Register (GPIO0 to 31)
    union   GPAOUTINV_REG                    GPAOUTINV;                    //GPIO A output Polarity Invert Registers (GPIO0 to 31)
    union   GPALOOPEN_REG                    GPALOOPEN;                    //GPIO A LOOP Enable Registers (GPIO0 to 31)
    union   GPAPI2C_MODE_REG                 GPAPI2C_MODE;                 //GPIO A PI2C MODE Registers (GPIO0 to 31)
    Uint32                                   GPA_POUT_RPT;                 //GPIO A Port output report (GPIO0 to 31)

    union   GPBPDD_REG                       GPBPDD;                       //GPIO B Pull Down Disable Register (GPIO64 to 79)
    union   GPBDS1_REG                       GPBDS1;                       //GPIO B Drive Strength 1 Register1 (GPIO32 to 47)
    union   GPBDS2_REG                       GPBDS2;                       //GPIO B Drive Strength Register2 (GPIO48 to 63)
    union   GPBIS_REG                        GPBIS;                        //GPIO B Schmitt Trigger Register (GPIO32 to 63)
    union   GPBOUTINV_REG                    GPBOUTINV;                    //GPIO B output Polarity Invert Registers (GPIO32 to 63)
    union   GPBLOOPEN_REG                    GPBLOOPEN;                    //GPIO B LOOP Enable Registers (GPIO32 to 63)
    union   GPBPI2C_MODE_REG                 GPBPI2C_MODE;                 //GPIO B PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPB_POUT_RPT;                 //GPIO B Port output report (GPIO32 to 63)

    union   GPCPDD_REG                       GPCPDD;                       //GPIO C Pull Down Disable Register (GPIO64 to 79)
    union   GPCDS1_REG                       GPCDS1;                       //GPIO C Drive Strength 1 Register1 (GPIO32 to 47)
    union   GPCDS2_REG                       GPCDS2;                       //GPIO C Drive Strength Register2 (GPIO48 to 63)
    union   GPCIS_REG                        GPCIS;                        //GPIO C Schmitt Trigger Register (GPIO32 to 63)
    union   GPCOUTINV_REG                    GPCOUTINV;                    //GPIO C output Polarity Invert Registers (GPIO32 to 63)
    union   GPCLOOPEN_REG                    GPCLOOPEN;                    //GPIO C LOOP Enable Registers (GPIO32 to 63)
    union   GPCPI2C_MODE_REG                 GPCPI2C_MODE;                 //GPIO C PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPC_POUT_RPT;                 //GPIO C Port output report (GPIO32 to 63)


    union   GPDPDD_REG                       GPDPDD;                       //GPIO D Pull Down Disable Register (GPIO64 to 79)
    union   GPDDS1_REG                       GPDDS1;                       //GPIO D Drive Strength 1 Register1 (GPIO32 to 47)
    union   GPDDS2_REG                       GPDDS2;                       //GPIO D Drive Strength Register2 (GPIO48 to 63)
    union   GPDIS_REG                        GPDIS;                        //GPIO D Schmitt Trigger Register (GPIO32 to 63)
    union   GPDOUTINV_REG                    GPDOUTINV;                    //GPIO D output Polarity Invert Registers (GPIO32 to 63)
    union   GPDLOOPEN_REG                    GPDLOOPEN;                    //GPIO D LOOP Enable Registers (GPIO32 to 63)
    union   GPDPI2C_MODE_REG                 GPDPI2C_MODE;                 //GPIO D PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPD_POUT_RPT;                 //GPIO D Port output report (GPIO32 to 63)

    union   GPEPDD_REG                       GPEPDD;                       //GPIO E Pull Down Disable Register (GPIO64 to 79)
    union   GPEDS1_REG                       GPEDS1;                       //GPIO E Drive Strength 1 Register1 (GPIO32 to 47)
    union   GPEDS2_REG                       GPEDS2;                       //GPIO E Drive Strength Register2 (GPIO48 to 63)
    union   GPEIS_REG                        GPEIS;                        //GPIO E Schmitt Trigger Register (GPIO32 to 63)
    union   GPEOUTINV_REG                    GPEOUTINV;                    //GPIO E output Polarity Invert Registers (GPIO32 to 63)
    union   GPELOOPEN_REG                    GPELOOPEN;                    //GPIO E LOOP Enable Registers (GPIO32 to 63)
    union   GPEPI2C_MODE_REG                 GPEPI2C_MODE;                 //GPIO E PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPE_POUT_RPT;                 //GPIO E Port output report (GPIO32 to 63)

    union   GPFPDD_REG                       GPFPDD;                       //GPIO F Pull Down Disable Register (GPIO64 to 79)
    union   GPFDS1_REG                       GPFDS1;                       //GPIO F Drive Strength 1 Register1 (GPIO32 to 47)
    Uint32     				                 GPFDS2;                       //GPIO F Drive Strength Register2 (GPIO48 to 63)
    union   GPFIS_REG                        GPFIS;                        //GPIO F Schmitt Trigger Register (GPIO32 to 63)
    union   GPFOUTINV_REG                    GPFOUTINV;                    //GPIO F output Polarity Invert Registers (GPIO32 to 63)
    union   GPFLOOPEN_REG                    GPFLOOPEN;                    //GPIO F LOOP Enable Registers (GPIO32 to 63)
    Uint32					                 GPFPI2C_MODE;                 //GPIO F PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPF_POUT_RPT;                 //GPIO F Port output report (GPIO32 to 63)

    union   GPGPDD_REG                       GPGPDD;                       //GPIO G Pull Down Disable Register (GPIO64 to 79)
    union   GPGDS1_REG                       GPGDS1;                       //GPIO G Drive Strength 1 Register1 (GPIO32 to 47)
    union   GPGDS2_REG                       GPGDS2;                       //GPIO G Drive Strength Register2 (GPIO48 to 63)
    union   GPGIS_REG                        GPGIS;                        //GPIO G Schmitt Trigger Register (GPIO32 to 63)
    union   GPGOUTINV_REG                    GPGOUTINV;                    //GPIO G output Polarity Invert Registers (GPIO32 to 63)
    union   GPGLOOPEN_REG                    GPGLOOPEN;                    //GPIO G LOOP Enable Registers (GPIO32 to 63)
    union   GPGPI2C_MODE_REG                 GPGPI2C_MODE;                 //GPIO G PI2C MODE Registers (GPIO32 to 63)
    Uint32                                   GPG_POUT_RPT;                 //GPIO G Port output report (GPIO32 to 63)

    union   GPHPDD_REG                       GPHPDD;                       //GPIO H Pull Down Disable Register (GPIO64 to 79)
    Uint16                                   rsvd36[4];                    // Reserved
    union   GPHIS_REG                        GPHIS;                        //GPIO H Schmitt Trigger Register (GPIO224 to 255)
    union   GPHOUTINV_REG                    GPHOUTINV;                    //GPIO H output Polarity Invert Registers (GPIO32 to 63)
    union   GPHLOOPEN_REG                    GPHLOOPEN;                    //GPIO H LOOP Enable Registers (GPIO32 to 63)
    union   GPHIE_REG                        GPHIE;                        //GPIO H  input Enable Registers (GPIO224 to 255)
    Uint32                                   GPH_POUT_RPT;                 //GPIO H Port output report (GPIO32 to 63)

};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// GPIO External References & Function Declarations

extern volatile struct GPIO_REGS gpioRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif  /* IS_GS32F3xx(0x22) */

#endif  // end of REGS_GPIO_H definition
