/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __REGS_I2C_V30_H_
#define __REGS_I2C_V30_H_

#ifdef __cplusplus
extern "C" {
#endif

#if IS_GS32F00xx(0x30)

struct I2COAR_BITS{ 		// bits   description
	uint16_t OAR:10;		// 0:9	This bit provide the slave address of the I2C module.
	uint16_t rsvd1:6;		// 10:15 	reserved
};

union I2COAR_REG{
	uint16_t		all;
	struct I2COAR_BITS		bit;
};

struct I2CIER_BITS{		// bits   	description
	uint16_t ARBL:1;	// 0:0		Arbitration-lost interrupt enable
	uint16_t NACK:1;	// 1:1		No-acknowledgment interrupt enable
	uint16_t ARDY:1;	// 2:2		Register-access-ready interrupt enable
	uint16_t RRDY:1;	// 3:3		Receive-data-ready interrupt enable
	uint16_t XRDY:1;	// 4:4		Transmit-data-ready interrupt enable
	uint16_t SCD:1;		// 5:5		Stop condition detected interrupt enable
	uint16_t AAS:1;		// 6:6		Addressed as slave interrupt enable
	uint16_t rsvd1:9;	// 7:15		reserved
};

union I2CIER_REG{
	uint16_t		all;
	struct I2CIER_BITS		bit;
};

struct I2CSTR_BITS{			// bits   	description
	uint16_t ARBL:1;		//0:0		Arbitration-lost interrupt flag bit
	uint16_t NACK:1; 		//1:1		No-acknowledgment interrupt flag bit.
	uint16_t ARDY:1;		//2:2		Register-access-ready interrupt flag bit
	uint16_t RRDY:1;		//3:3		Receive-data-ready interrupt flag bit.
	uint16_t XRDY:1;		//4:4		Transmit-data-ready interrupt flag bit.
	uint16_t SCD:1;			//5:5		Stop condition detected bit.
	uint16_t BYTESENT:1;	//6:6		Byte transmit over indication
	uint16_t rsvd1:1;		//7:7		reserved
	uint16_t AD0:1;			//8:8		Address 0 bits
	uint16_t AAS:1;			//9:9		Addressed-as-slave bit
	uint16_t XSMT:1;		//10:10		Transmit shift register empty bit.
	uint16_t RSFULL:1;		//11:11		Receive shift register full bit.
	uint16_t BB:1;			//12:12		Bus busy bit.
	uint16_t NACKSNT:1;		//13:13		NACK sent bit.
	uint16_t SDIR:1;		//14:14		Slave direction bit
	uint16_t rsvd2:1;		//15:15		reserved
};

union I2CSTR_REG{
	uint16_t		all;
	struct I2CSTR_BITS		bit;
};

struct I2CCLKL_BITS{		// bits   	description
	uint16_t I2CCLKL:16;		// 0:15		I2C Clock low-time divider
};

union I2CCLKL_REG{
	uint16_t		all;
	struct I2CCLKL_BITS		bit;
};

struct I2CCLKH_BITS{		// bits   	description
	uint16_t I2CCLKH:16;	// 0:15		I2C Clock high-time divider
};

union I2CCLKH_REG{
	uint16_t		all;
	struct I2CCLKH_BITS		bit;
};

struct I2CCNT_BITS{			// bits   	description
	uint16_t I2CCNT:16;		// 0:15		I2C Data count
};

union I2CCNT_REG{
	uint16_t		all;
	struct I2CCNT_BITS		bit;
};

struct I2CDRR_BITS{			// bits   	description
	uint16_t DATA:8;			// 0:7		Data receive
	uint16_t rsvd1:8;		// 8:15		reserved
};

union I2CDRR_REG{
	uint16_t		all;
	struct I2CDRR_BITS		bit;
};

struct I2CSAR_BITS{			// bits   	description
	uint16_t SAR:10;		// 0:9		I2C Slave address
	uint16_t rsvd1:6;		// 9:15		reserved
};

union I2CSAR_REG{
	uint16_t		all;
	struct I2CSAR_BITS		bit;
};

struct I2CDXR_BITS{			// bits   	description
	uint16_t DATA:8;		// 0:7		Data Transmit
	uint16_t rsvd1:8;		// 8:15		reserved
};

union I2CDXR_REG{
	uint16_t		all;
	struct I2CDXR_BITS		bit;
};

struct I2CMDR_BITS{			// bits   	description
	uint16_t BC:3;			// 0:2		Bit count bits.
	uint16_t FDF:1;			// 3:3		Free Data Format
	uint16_t STB:1;			// 4:4		START Byte Mode
	uint16_t IRS:1;			// 5:5		I2C Module Reset
	uint16_t DLB:1;			// 6:6		Digital Loopback Mode
	uint16_t RM:1;			// 7:7		Repeat Mode
	uint16_t XA:1;			// 8:8		Expanded Address Mode
	uint16_t TRX:1;			// 9:9		Transmitter Mode
	uint16_t MST:1;			// 10:10	Master Mode
	uint16_t STP:1;			// 11:11	STOP Condition
	uint16_t rsvd1:1;		// 12:12	reserved
	uint16_t STT:1;			// 13:13	START condition bit
	uint16_t FREE:1;		// 14:14	Debug Action
	uint16_t NACKMOD:1;		// 15:15	NACK mode bit
};

union I2CMDR_REG{
	uint16_t		all;
	struct I2CMDR_BITS		bit;
};

struct I2CISRC_BITS{		// bits   	description
	uint16_t INTCODE:3;		// 0:2		Interrupt code bits.
	uint16_t rsvd1:5;		// 3:7		reserved
	uint16_t WRITE_ZEROS:4;	// 8:11		Always write all 0s to this field
	uint16_t rsvd2:4;		// 12:15	reserved
};

union I2CISRC_REG{
	uint16_t		all;
	struct I2CISRC_BITS		bit;
};

struct I2CEMDR_BITS{		// bits   	description
	uint16_t BC:1;			// 0:0		Backwards compatibility mode
	uint16_t FCM:1;			// 1:1		Forward Compatibility for Tx behav in Type1
	uint16_t rsvd1:14;		// 2:15		reserved
};

union I2CEMDR_REG{
	uint16_t		all;
	struct I2CEMDR_BITS		bit;
};

struct I2CIPSC_BITS{		// bits   	description
	uint16_t IPSC:8;		// 0:7		I2C Prescaler Divide Down
	uint16_t rsvd1:8;		// 8:15		reserved
};

union I2CPSC_REG{
	uint16_t		all;
	struct I2CIPSC_BITS		bit;
};

struct I2CFFTX_BITS{		// bits   	description
	uint16_t TXFFIL:5;		// 0:4		Transmit FIFO Interrupt Level
	uint16_t TXFFIENA:1;	// 5:5		Transmit FIFO Interrupt Enable
	uint16_t TXFFINTCLR:1;	// 6:6		Transmit FIFO Interrupt Flag Clear
	uint16_t TXFFINT:1;		// 7:7		Transmit FIFO Interrupt Flag
	uint16_t TXFFST:5;		// 8:12		Transmit FIFO Status
	uint16_t TXFFRST:1;		// 13:13	Transmit FIFO Reset
	uint16_t I2CFFEN:1;		// 14:14	FIFO Enable
	uint16_t rsvd1:1;		// 15:15	reserved
};

union I2CFFTX_REG{
	uint16_t		all;
	struct I2CFFTX_BITS		bit;
};

struct I2CFFRX_BITS{		// bits   	description
	uint16_t RXFFIL:5;		// 0:4		Receive FIFO Interrupt Level
	uint16_t RXFFIENA:1;	// 5:5		Receive FIFO Interrupt Enable
	uint16_t RXFFINTCLR:1;	// 6:6		Receive FIFO Interrupt Flag Clear
	uint16_t RXFFINT:1;		// 7:7		Receive FIFO Interrupt Flag
	uint16_t RXFFST:5;		// 8:12		Receive FIFO Status
	uint16_t RXFFRST:1;		// 13:13	Receive FIFO Reset
	uint16_t rsvd1:2;		// 14:15	reserved
};

union I2CFFRX_REG{
	uint16_t		all;
	struct I2CFFRX_BITS		bit;
};

struct I2C_REGS{
	union I2COAR_REG	I2COAR;
	union I2CIER_REG	I2CIER;
	union I2CSTR_REG	I2CSTR;
	uint16_t			I2CCLKL;
	uint16_t			I2CCLKH;
	union I2CCNT_REG	I2CCNT;
	uint16_t			I2CDRR;
	union I2CSAR_REG	I2CSAR;
	uint16_t			I2CDXR;
	union I2CMDR_REG	I2CMDR;
	union I2CISRC_REG	I2CISRC;
	union I2CEMDR_REG	I2CEMDR;
	uint16_t			I2CPSC;
	uint16_t rsvd1[19];
	union I2CFFTX_REG	I2CFFTX;
	union I2CFFRX_REG	I2CFFRX;
};

extern volatile struct I2C_REGS I2caRegs;
extern volatile struct I2C_REGS I2cbRegs;

#endif

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif
