/* ========================================================================== */
/**
 *   @file    regs_io_cfg_pa.h
 *   @brief
 *   [note: This file is automatically generated and does not need to be
 *   manually edited. If you want to modify it, use the script to generate]
 *
 */
/* ========================================================================== */
/**
 *  Copyright (C) GeJian Semiconductors 2023
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of HPEC Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/* ========================================================================== */

#ifndef REGS_IO_CFG_PA_H
#define REGS_IO_CFG_PA_H

#if IS_GS32F00xx(0x30)

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

// IO_CFG_PA Individual Register Bit Definitions:

#if !(GS32_PART_NUM == 0x035 || GS32_PART_NUM == 0x027)
//
// GPIO A Qualification Sampling Period Control
//
struct GPACTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for GPIO0 to GPIO7:
    uint32_t QUALPRD1 : 8; // 15:8   Qualification sampling period for GPIO8 to GPIO15:

    uint32_t QUALPRD2 : 8; // 23:16   Qualification sampling period for GPIO16 to GPIO23:

    uint32_t QUALPRD3 : 8; // 31:24   Qualification sampling period for GPIO24 to GPIO31:
};

union GPACTRL_REG {
    uint32_t            all;
    // struct GPACTRL_BITS bit;
};

//
// GPIO A Qualifier Select 1 Register (GPIO0 to 15)
//
struct GPAQSEL1_BITS {  // bits   description
    uint32_t GPIO0 : 2; // 1:0   Select input qualification type for GPIO0:

    uint32_t GPIO1 : 2; // 3:2   Select input qualification type for GPIO1:

    uint32_t GPIO2 : 2; // 5:4   Select input qualification type for GPIO2:

    uint32_t GPIO3 : 2; // 7:6   Select input qualification type for GPIO3:

    uint32_t GPIO4 : 2; // 9:8   Select input qualification type for GPIO4:

    uint32_t GPIO5 : 2; // 11:10   Select input qualification type for GPIO5:

    uint32_t GPIO6 : 2; // 13:12   Select input qualification type for GPIO6:

    uint32_t GPIO7 : 2; // 15:14   Select input qualification type for GPIO7:

    uint32_t GPIO8 : 2; // 17:16   Select input qualification type for GPIO8:

    uint32_t GPIO9 : 2; // 19:18   Select input qualification type for GPIO9:

    uint32_t GPIO10 : 2; // 21:20   Select input qualification type for GPIO10:

    uint32_t GPIO11 : 2; // 23:22   Select input qualification type for GPIO11:

    uint32_t GPIO12 : 2; // 25:24   Select input qualification type for GPIO12:

    uint32_t GPIO13 : 2; // 27:26   Select input qualification type for GPIO13:

    uint32_t GPIO14 : 2; // 29:28   Select input qualification type for GPIO14:

    uint32_t GPIO15 : 2; // 31:30   Select input qualification type for GPIO15:
};

union GPAQSEL1_REG {
    uint32_t             all;
    struct GPAQSEL1_BITS bit;
};

//
// GPIO A Qualifier Select 2 Register (GPIO16 to 31)
//
struct GPAQSEL2_BITS {   // bits   description
    uint32_t GPIO16 : 2; // 1:0   Select input qualification type for GPIO16:

    uint32_t GPIO17 : 2; // 3:2   Select input qualification type for GPIO17:

    uint32_t GPIO18 : 2; // 5:4   Select input qualification type for GPIO18:

    uint32_t GPIO19 : 2; // 7:6   Select input qualification type for GPIO19:

    uint32_t GPIO20 : 2; // 9:8   Select input qualification type for GPIO20:

    uint32_t GPIO21 : 2; // 11:10   Select input qualification type for GPIO21:

    uint32_t GPIO22 : 2; // 13:12   Select input qualification type for GPIO22:

    uint32_t GPIO23 : 2; // 15:14   Select input qualification type for GPIO23:

    uint32_t GPIO24 : 2; // 17:16   Select input qualification type for GPIO24:

    uint32_t GPIO25 : 2; // 19:18   Select input qualification type for GPIO25:

    uint32_t GPIO26 : 2; // 21:20   Select input qualification type for GPIO26:

    uint32_t GPIO27 : 2; // 23:22   Select input qualification type for GPIO27:

    uint32_t GPIO28 : 2; // 25:24   Select input qualification type for GPIO28:

    uint32_t GPIO29 : 2; // 27:26   Select input qualification type for GPIO29:

    uint32_t GPIO30 : 2; // 29:28   Select input qualification type for GPIO30:

    uint32_t GPIO31 : 2; // 31:30   Select input qualification type for GPIO31:
};

union GPAQSEL2_REG {
    uint32_t             all;
    struct GPAQSEL2_BITS bit;
};

//
// GPIO A Mux 1 Register (GPIO0 to 15)
//
struct GPAMUX1_BITS {    // bits   description
    uint32_t GPIO0 : 2;  // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO1 : 2;  // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO2 : 2;  // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO3 : 2;  // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO4 : 2;  // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO5 : 2;  // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO6 : 2;  // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO7 : 2;  // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO8 : 2;  // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO9 : 2;  // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO10 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO11 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO12 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO13 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO14 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO15 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPAMUX1_REG {
    uint32_t            all;
    struct GPAMUX1_BITS bit;
};

//
// GPIO A Mux 2 Register (GPIO16 to 31)
//
struct GPAMUX2_BITS {    // bits   description
    uint32_t GPIO16 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO17 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO18 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO19 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO20 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO21 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO22 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO23 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO24 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO25 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO26 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO27 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO28 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO29 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO30 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO31 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPAMUX2_REG {
    uint32_t            all;
    struct GPAMUX2_BITS bit;
};

//
// GPIO A Direction Register (GPIO0 to 31)
//
struct GPADIR_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO1 : 1;  // 1:1   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO2 : 1;  // 2:2   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO3 : 1;  // 3:3   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO4 : 1;  // 4:4   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO5 : 1;  // 5:5   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO6 : 1;  // 6:6   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO7 : 1;  // 7:7   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO8 : 1;  // 8:8   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO9 : 1;  // 9:9   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO10 : 1; // 10:10   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO11 : 1; // 11:11   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO12 : 1; // 12:12   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO13 : 1; // 13:13   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO14 : 1; // 14:14   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO15 : 1; // 15:15   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO16 : 1; // 16:16   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO17 : 1; // 17:17   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO18 : 1; // 18:18   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO19 : 1; // 19:19   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO20 : 1; // 20:20   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO21 : 1; // 21:21   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO22 : 1; // 22:22   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO23 : 1; // 23:23   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO24 : 1; // 24:24   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO25 : 1; // 25:25   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO26 : 1; // 26:26   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO27 : 1; // 27:27   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO28 : 1; // 28:28   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO29 : 1; // 29:29   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO30 : 1; // 30:30   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO31 : 1; // 31:31   Defines pin-muxing selection for GPIO
};

union GPADIR_REG {
    uint32_t           all;
    struct GPADIR_BITS bit;
};

//
// GPIO A Pull Up Disable Register (GPIO0 to 31)
//
struct GPAPUD_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   Pull-Up Disable control for this pin
    uint32_t GPIO1 : 1;  // 1:1   Pull-Up Disable control for this pin
    uint32_t GPIO2 : 1;  // 2:2   Pull-Up Disable control for this pin
    uint32_t GPIO3 : 1;  // 3:3   Pull-Up Disable control for this pin
    uint32_t GPIO4 : 1;  // 4:4   Pull-Up Disable control for this pin
    uint32_t GPIO5 : 1;  // 5:5   Pull-Up Disable control for this pin
    uint32_t GPIO6 : 1;  // 6:6   Pull-Up Disable control for this pin
    uint32_t GPIO7 : 1;  // 7:7   Pull-Up Disable control for this pin
    uint32_t GPIO8 : 1;  // 8:8   Pull-Up Disable control for this pin
    uint32_t GPIO9 : 1;  // 9:9   Pull-Up Disable control for this pin
    uint32_t GPIO10 : 1; // 10:10   Pull-Up Disable control for this pin
    uint32_t GPIO11 : 1; // 11:11   Pull-Up Disable control for this pin
    uint32_t GPIO12 : 1; // 12:12   Pull-Up Disable control for this pin
    uint32_t GPIO13 : 1; // 13:13   Pull-Up Disable control for this pin
    uint32_t GPIO14 : 1; // 14:14   Pull-Up Disable control for this pin
    uint32_t GPIO15 : 1; // 15:15   Pull-Up Disable control for this pin
    uint32_t GPIO16 : 1; // 16:16   Pull-Up Disable control for this pin
    uint32_t GPIO17 : 1; // 17:17   Pull-Up Disable control for this pin
    uint32_t GPIO18 : 1; // 18:18   Pull-Up Disable control for this pin
    uint32_t GPIO19 : 1; // 19:19   Pull-Up Disable control for this pin
    uint32_t GPIO20 : 1; // 20:20   Pull-Up Disable control for this pin
    uint32_t GPIO21 : 1; // 21:21   Pull-Up Disable control for this pin
    uint32_t GPIO22 : 1; // 22:22   Pull-Up Disable control for this pin
    uint32_t GPIO23 : 1; // 23:23   Pull-Up Disable control for this pin
    uint32_t GPIO24 : 1; // 24:24   Pull-Up Disable control for this pin
    uint32_t GPIO25 : 1; // 25:25   Pull-Up Disable control for this pin
    uint32_t GPIO26 : 1; // 26:26   Pull-Up Disable control for this pin
    uint32_t GPIO27 : 1; // 27:27   Pull-Up Disable control for this pin
    uint32_t GPIO28 : 1; // 28:28   Pull-Up Disable control for this pin
    uint32_t GPIO29 : 1; // 29:29   Pull-Up Disable control for this pin
    uint32_t GPIO30 : 1; // 30:30   Pull-Up Disable control for this pin
    uint32_t GPIO31 : 1; // 31:31   Pull-Up Disable control for this pin
};

union GPAPUD_REG {
    uint32_t           all;
    struct GPAPUD_BITS bit;
};

//
// GPIO A Input Polarity Invert Registers (GPIO0 to 31)
//
struct GPAINV_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   Input inversion control for this pin
    uint32_t GPIO1 : 1;  // 1:1   Input inversion control for this pin
    uint32_t GPIO2 : 1;  // 2:2   Input inversion control for this pin
    uint32_t GPIO3 : 1;  // 3:3   Input inversion control for this pin
    uint32_t GPIO4 : 1;  // 4:4   Input inversion control for this pin
    uint32_t GPIO5 : 1;  // 5:5   Input inversion control for this pin
    uint32_t GPIO6 : 1;  // 6:6   Input inversion control for this pin
    uint32_t GPIO7 : 1;  // 7:7   Input inversion control for this pin
    uint32_t GPIO8 : 1;  // 8:8   Input inversion control for this pin
    uint32_t GPIO9 : 1;  // 9:9   Input inversion control for this pin
    uint32_t GPIO10 : 1; // 10:10   Input inversion control for this pin
    uint32_t GPIO11 : 1; // 11:11   Input inversion control for this pin
    uint32_t GPIO12 : 1; // 12:12   Input inversion control for this pin
    uint32_t GPIO13 : 1; // 13:13   Input inversion control for this pin
    uint32_t GPIO14 : 1; // 14:14   Input inversion control for this pin
    uint32_t GPIO15 : 1; // 15:15   Input inversion control for this pin
    uint32_t GPIO16 : 1; // 16:16   Input inversion control for this pin
    uint32_t GPIO17 : 1; // 17:17   Input inversion control for this pin
    uint32_t GPIO18 : 1; // 18:18   Input inversion control for this pin
    uint32_t GPIO19 : 1; // 19:19   Input inversion control for this pin
    uint32_t GPIO20 : 1; // 20:20   Input inversion control for this pin
    uint32_t GPIO21 : 1; // 21:21   Input inversion control for this pin
    uint32_t GPIO22 : 1; // 22:22   Input inversion control for this pin
    uint32_t GPIO23 : 1; // 23:23   Input inversion control for this pin
    uint32_t GPIO24 : 1; // 24:24   Input inversion control for this pin
    uint32_t GPIO25 : 1; // 25:25   Input inversion control for this pin
    uint32_t GPIO26 : 1; // 26:26   Input inversion control for this pin
    uint32_t GPIO27 : 1; // 27:27   Input inversion control for this pin
    uint32_t GPIO28 : 1; // 28:28   Input inversion control for this pin
    uint32_t GPIO29 : 1; // 29:29   Input inversion control for this pin
    uint32_t GPIO30 : 1; // 30:30   Input inversion control for this pin
    uint32_t GPIO31 : 1; // 31:31   Input inversion control for this pin
};

union GPAINV_REG {
    uint32_t           all;
    struct GPAINV_BITS bit;
};

//
// GPIO A Analog Mode Select register (GPIO32 to GPIO63)
//
struct GPAAMSEL_BITS {   // bits   description
    uint32_t rsvd1 : 11; // 10:0   Reserved
    uint32_t GPIO11 : 1; // 11:11   Analog Mode select for this pin

    uint32_t GPIO12 : 1; // 12:12   Analog Mode select for this pin

    uint32_t GPIO13 : 1; // 13:13   Analog Mode select for this pin

    uint32_t rsvd2 : 2;  // 15:14   Reserved
    uint32_t GPIO16 : 1; // 16:16   Analog Mode select for this pin

    uint32_t GPIO17 : 1; // 17:17   Analog Mode select for this pin

    uint32_t rsvd3 : 2;  // 19:18   Reserved
    uint32_t GPIO20 : 1; // 20:20   Analog Mode select for this pin

    uint32_t GPIO21 : 1; // 21:21   Analog Mode select for this pin

    uint32_t rsvd4 : 2;  // 23:22   Reserved
    uint32_t GPIO24 : 1; // 24:24   Analog Mode select for this pin

    uint32_t rsvd5 : 3;  // 27:25   Reserved
    uint32_t GPIO28 : 1; // 28:28   Analog Mode select for this pin
    uint32_t rsvd6 : 3;  // 31:29   Reserved
};

union GPAAMSEL_REG {
    uint32_t             all;
    struct GPAAMSEL_BITS bit;
};

//
// GPIO A Peripheral Group Mux (GPIO0 to 15)
//
struct GPAGMUX1_BITS {   // bits   description
    uint32_t GPIO0 : 2;  // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO1 : 2;  // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO2 : 2;  // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO3 : 2;  // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO4 : 2;  // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO5 : 2;  // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO6 : 2;  // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO7 : 2;  // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO8 : 2;  // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO9 : 2;  // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO10 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO11 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO12 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO13 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO14 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO15 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPAGMUX1_REG {
    uint32_t             all;
    struct GPAGMUX1_BITS bit;
};

//
// GPIO A Peripheral Group Mux (GPIO16 to 31)
//
struct GPAGMUX2_BITS {   // bits   description
    uint32_t GPIO16 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO17 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO18 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO19 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO20 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO21 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO22 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO23 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO24 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO25 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO26 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO27 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO28 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO29 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO30 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO31 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPAGMUX2_REG {
    uint32_t             all;
    struct GPAGMUX2_BITS bit;
};

//
// GPIO B Qualification Sampling Period Control (GPIO32 to 63)
//
struct GPBCTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for GPIO32 to GPIO39:

    uint32_t QUALPRD1 : 8; // 15:8   Qualification sampling period for GPIO40 to GPIO47:

    uint32_t QUALPRD2 : 8; // 23:16   Qualification sampling period for GPIO48 to GPIO55:
    uint32_t QUALPRD3 : 8; // 31:24   Qualification sampling period for GPIO56 to GPIO63:
};

union GPBCTRL_REG {
    uint32_t            all;
    // struct GPBCTRL_BITS bit;
};

//
// GPIO B Qualifier Select 1 Register (GPIO32 to 47)
//
struct GPBQSEL1_BITS {   // bits   description
    uint32_t GPIO32 : 2; // 1:0   Select input qualification type for GPIO32:

    uint32_t GPIO33 : 2; // 3:2   Select input qualification type for GPIO

    uint32_t GPIO34 : 2; // 5:4   Select input qualification type for GPIO

    uint32_t GPIO35 : 2; // 7:6   Select input qualification type for GPIO

    uint32_t rsvd1 : 2;  // 9:8   Reserved
    uint32_t GPIO37 : 2; // 11:10   Select input qualification type for GPIO

    uint32_t rsvd2 : 2;  // 13:12   Reserved
    uint32_t GPIO39 : 2; // 15:14   Select input qualification type for GPIO

    uint32_t GPIO40 : 2; // 17:16   Select input qualification type for GPIO

    uint32_t GPIO41 : 2; // 19:18   Select input qualification type for GPIO

    uint32_t GPIO42 : 2; // 21:20   Select input qualification type for GPIO

    uint32_t GPIO43 : 2; // 23:22   Select input qualification type for GPIO

    uint32_t GPIO44 : 2; // 25:24   Select input qualification type for GPIO

    uint32_t GPIO45 : 2; // 27:26   Select input qualification type for GPIO

    uint32_t GPIO46 : 2; // 29:28   Select input qualification type for GPIO46:
    uint32_t rsvd3 : 2;  // 31:30   Reserved
};

union GPBQSEL1_REG {
    uint32_t             all;
    struct GPBQSEL1_BITS bit;
};

//
// GPIO B Qualifier Select 2 Register (GPIO48 to 63)
//
struct GPBQSEL2_BITS {   // bits   description
    uint32_t GPIO48 : 2; // 1:0   Select input qualification type for GPIO

    uint32_t GPIO49 : 2; // 3:2   Select input qualification type for GPIO

    uint32_t rsvd1 : 6;  // 9:4   Reserved
    uint32_t GPIO53 : 2; // 11:10   Select input qualification type for GPIO

    uint32_t GPIO54 : 2; // 13:12   Select input qualification type for GPIO

    uint32_t GPIO55 : 2; // 15:14   Select input qualification type for GPIO

    uint32_t GPIO56 : 2; // 17:16   Select input qualification type for GPIO

    uint32_t GPIO57 : 2; // 19:18   Select input qualification type for GPIO

    uint32_t GPIO58 : 2; // 21:20   Select input qualification type for GPIO

    uint32_t GPIO59 : 2; // 23:22   Select input qualification type for GPIO

    uint32_t GPIO60 : 2; // 25:24   Select input qualification type for GPIO

    uint32_t GPIO61 : 2; // 27:26   Select input qualification type for GPIO

    uint32_t GPIO62 : 2; // 29:28   Select input qualification type for GPIO

    uint32_t GPIO63 : 2; // 31:30   Select input qualification type for GPIO63:
};

union GPBQSEL2_REG {
    uint32_t             all;
    struct GPBQSEL2_BITS bit;
};

//
// GPIO B Mux 1 Register (GPIO32 to 47)
//
struct GPBMUX1_BITS {    // bits   description
    uint32_t GPIO32 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO33 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO34 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO35 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 2;  // 9:8   Reserved
    uint32_t GPIO37 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t rsvd2 : 2;  // 13:12   Reserved
    uint32_t GPIO39 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO40 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO41 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO42 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO43 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO44 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO45 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO46 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t rsvd3 : 2;  // 31:30   Reserved
};

union GPBMUX1_REG {
    uint32_t            all;
    struct GPBMUX1_BITS bit;
};

//
// GPIO B Mux 2 Register (GPIO48 to 63)
//
struct GPBMUX2_BITS {    // bits   description
    uint32_t GPIO48 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO49 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 6;  // 9:4   Reserved
    uint32_t GPIO53 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO54 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO55 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO56 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO57 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO58 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO59 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO60 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO61 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO62 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO63 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPBMUX2_REG {
    uint32_t            all;
    struct GPBMUX2_BITS bit;
};

//
// GPIO B Direction Register (GPIO32 to 63)
//
struct GPBDIR_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO33 : 1; // 1:1   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO34 : 1; // 2:2   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO35 : 1; // 3:3   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO40 : 1; // 8:8   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO41 : 1; // 9:9   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO42 : 1; // 10:10   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO43 : 1; // 11:11   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO44 : 1; // 12:12   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO45 : 1; // 13:13   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO46 : 1; // 14:14   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO49 : 1; // 17:17   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO54 : 1; // 22:22   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO55 : 1; // 23:23   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO56 : 1; // 24:24   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO57 : 1; // 25:25   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO58 : 1; // 26:26   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO59 : 1; // 27:27   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO60 : 1; // 28:28   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO61 : 1; // 29:29   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO62 : 1; // 30:30   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO63 : 1; // 31:31   Defines pin-muxing selection for GPIO
};

union GPBDIR_REG {
    uint32_t           all;
    struct GPBDIR_BITS bit;
};

//
// GPIO B Pull Up Disable Register (GPIO32 to 63)
//
struct GPBPUD_BITS {     // bits   description
	uint32_t GPIO32 : 1; // 0:0   Pull-Up Disable control for this pin
    uint32_t GPIO33 : 1; // 1:1   Pull-Up Disable control for this pin
    uint32_t GPIO34 : 1; // 2:2   Pull-Up Disable control for this pin
    uint32_t GPIO35 : 1; // 3:3   Pull-Up Disable control for this pin
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   Pull-Up Disable control for this pin
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   Pull-Up Disable control for this pin
    uint32_t GPIO40 : 1; // 8:8   Pull-Up Disable control for this pin
    uint32_t GPIO41 : 1; // 9:9   Pull-Up Disable control for this pin
    uint32_t GPIO42 : 1; // 10:10   Pull-Up Disable control for this pin
    uint32_t GPIO43 : 1; // 11:11   Pull-Up Disable control for this pin
    uint32_t GPIO44 : 1; // 12:12   Pull-Up Disable control for this pin
    uint32_t GPIO45 : 1; // 13:13   Pull-Up Disable control for this pin
    uint32_t GPIO46 : 1; // 14:14   Pull-Up Disable control for this pin
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   Pull-Up Disable control for this pin
    uint32_t GPIO49 : 1; // 17:17   Pull-Up Disable control for this pin
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   Pull-Up Disable control for this pin
    uint32_t GPIO54 : 1; // 22:22   Pull-Up Disable control for this pin
    uint32_t GPIO55 : 1; // 23:23   Pull-Up Disable control for this pin
    uint32_t GPIO56 : 1; // 24:24   Pull-Up Disable control for this pin
    uint32_t GPIO57 : 1; // 25:25   Pull-Up Disable control for this pin
    uint32_t GPIO58 : 1; // 26:26   Pull-Up Disable control for this pin
    uint32_t GPIO59 : 1; // 27:27   Pull-Up Disable control for this pin
    uint32_t GPIO60 : 1; // 28:28   Pull-Up Disable control for this pin
    uint32_t GPIO61 : 1; // 29:29   Pull-Up Disable control for this pin
    uint32_t GPIO62 : 1; // 30:30   Pull-Up Disable control for this pin
    uint32_t GPIO63 : 1; // 31:31   Pull-Up Disable control for this pin
};

union GPBPUD_REG {
    uint32_t           all;
    struct GPBPUD_BITS bit;
};

//
// GPIO B Input Polarity Invert Registers (GPIO32 to 63)
//
struct GPBINV_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   Input inversion control for this pin
    uint32_t GPIO33 : 1; // 1:1   Input inversion control for this pin
    uint32_t GPIO34 : 1; // 2:2   Input inversion control for this pin
    uint32_t GPIO35 : 1; // 3:3   Input inversion control for this pin
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   Input inversion control for this pin
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   Input inversion control for this pin
    uint32_t GPIO40 : 1; // 8:8   Input inversion control for this pin
    uint32_t GPIO41 : 1; // 9:9   Input inversion control for this pin
    uint32_t GPIO42 : 1; // 10:10   Input inversion control for this pin
    uint32_t GPIO43 : 1; // 11:11   Input inversion control for this pin
    uint32_t GPIO44 : 1; // 12:12   Input inversion control for this pin
    uint32_t GPIO45 : 1; // 13:13   Input inversion control for this pin
    uint32_t GPIO46 : 1; // 14:14   Input inversion control for this pin
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   Input inversion control for this pin
    uint32_t GPIO49 : 1; // 17:17   Input inversion control for this pin
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   Input inversion control for this pin
    uint32_t GPIO54 : 1; // 22:22   Input inversion control for this pin
    uint32_t GPIO55 : 1; // 23:23   Input inversion control for this pin
    uint32_t GPIO56 : 1; // 24:24   Input inversion control for this pin
    uint32_t GPIO57 : 1; // 25:25   Input inversion control for this pin
    uint32_t GPIO58 : 1; // 26:26   Input inversion control for this pin
    uint32_t GPIO59 : 1; // 27:27   Input inversion control for this pin
    uint32_t GPIO60 : 1; // 28:28   Input inversion control for this pin
    uint32_t GPIO61 : 1; // 29:29   Input inversion control for this pin
    uint32_t GPIO62 : 1; // 30:30   Input inversion control for this pin
    uint32_t GPIO63 : 1; // 31:31   Input inversion control for this pin
};

union GPBINV_REG {
    uint32_t           all;
    struct GPBINV_BITS bit;
};

//
// GPIO B Analog Mode Select register (GPIO32 to GPIO63)
//
struct GPBAMSEL_BITS {   // bits   description
    uint32_t rsvd1 : 1;  // 0:0   Reserved
    uint32_t GPIO33 : 1; // 1:1   Analog Mode select for this pin
    uint32_t rsvd2 : 30; // 31:2   Reserved
};

union GPBAMSEL_REG {
    uint32_t             all;
    struct GPBAMSEL_BITS bit;
};

//
// GPIO B Peripheral Group Mux (GPIO32 to 47)
//
struct GPBGMUX1_BITS {   // bits   description
    uint32_t GPIO32 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO33 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO34 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO35 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 2;  // 9:8   Reserved
    uint32_t GPIO37 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t rsvd2 : 2;  // 13:12   Reserved
    uint32_t GPIO39 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO40 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO41 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO42 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO43 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO44 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO45 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO46 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t rsvd3 : 2;  // 31:30   Reserved
};

union GPBGMUX1_REG {
    uint32_t             all;
    struct GPBGMUX1_BITS bit;
};

//
// GPIO B Peripheral Group Mux (GPIO48 to 63)
//
struct GPBGMUX2_BITS {   // bits   description
    uint32_t GPIO48 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO49 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 6;  // 9:4   Reserved
    uint32_t GPIO53 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO54 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO55 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO56 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO57 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO58 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO59 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO60 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO61 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO62 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO63 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPBGMUX2_REG {
    uint32_t             all;
    struct GPBGMUX2_BITS bit;
};

//
// GPIO G Qualification Sampling Period Control (GPIO200 )
//
struct GPGCTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for GPIO200:
    uint32_t rsvd1 : 24;   // 31:8   Reserved
};

union GPGCTRL_REG {
    uint32_t            all;
    // struct GPGCTRL_BITS bit;
};

//
// GPIO G Qualifier Select 1 Register (GPIO200)
//
struct GPGQSEL1_BITS {    // bits   description
    uint32_t GPIO200 : 2; // 1:0   Select input qualification type for GPIO200:
    uint32_t rsvd1 : 30;  // 31:2   Reserved
};

union GPGQSEL1_REG {
    uint32_t             all;
    struct GPGQSEL1_BITS bit;
};

//
// GPIO G Mux 1 Register (GPIO200)
//
struct GPGMUX1_BITS {     // bits   description
    uint32_t GPIO200 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 30;  // 31:2   Reserved
};

union GPGMUX1_REG {
    uint32_t            all;
    struct GPGMUX1_BITS bit;
};

//
// GPIO G Direction Register (GPIO200)
//
struct GPGDIR_BITS {      // bits   description
    uint32_t GPIO200 : 1; // 0:0   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGDIR_REG {
    uint32_t           all;
    struct GPGDIR_BITS bit;
};

//
// GPIO G Pull Up Disable Register (GPIO200)
//
struct GPGPUD_BITS {      // bits   description
    uint32_t GPIO200 : 1; // 0:0   Pull-Up Disable control for this pin
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGPUD_REG {
    uint32_t           all;
    struct GPGPUD_BITS bit;
};

//
// GPIO G Input Polarity Invert Registers (GPIO200)
//
struct GPGINV_BITS {      // bits   description
    uint32_t GPIO200 : 1; // 0:0   Input inversion control for this pin
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGINV_REG {
    uint32_t           all;
    struct GPGINV_BITS bit;
};

//
// GPIO G Analog Mode Select register (GPIO200)
//
struct GPGAMSEL_BITS {    // bits   description
    uint32_t GPIO200 : 1; // 0:0   Analog Mode select for this pin
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGAMSEL_REG {
    uint32_t             all;
    struct GPGAMSEL_BITS bit;
};

//
// GPIO G Peripheral Group Mux (GPIO200)
//
struct GPGGMUX1_BITS {    // bits   description
    uint32_t GPIO200 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 30;  // 31:2   Reserved
};

union GPGGMUX1_REG {
    uint32_t             all;
    struct GPGGMUX1_BITS bit;
};

//
// GPIO H Qualification Sampling Period Control (GPIO224 to 255)
//
struct GPHCTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for GPIO224 to GPIO231:

    uint32_t QUALPRD1 : 8; // 15:8   Qualification sampling period for GPIO232 to GPIO239:

    uint32_t QUALPRD2 : 8; // 23:16   Qualification sampling period for GPIO240 to GPIO247:

    uint32_t QUALPRD3 : 8; // 31:24   Qualification sampling period for GPIO248 :
};

union GPHCTRL_REG {
    uint32_t            all;
    // struct GPHCTRL_BITS bit;
};

//
// GPIO H Qualifier Select 1 Register (GPIO224 to 239)
//
struct GPHQSEL1_BITS {    // bits   description
    uint32_t GPIO224 : 2; // 1:0   Select input qualification type for GPIO224:

    uint32_t GPIO225 : 2; // 3:2   Select input qualification type for GPIO225:

    uint32_t GPIO226 : 2; // 5:4   Select input qualification type for GPIO226:

    uint32_t GPIO227 : 2; // 7:6   Select input qualification type for GPIO227:

    uint32_t GPIO228 : 2; // 9:8   Select input qualification type for GPIO228:

    uint32_t rsvd1 : 2;   // 11:10   Reserved
    uint32_t GPIO230 : 2; // 13:12   Select input qualification type for GPIO230:

    uint32_t GPIO231 : 2; // 15:14   Select input qualification type for GPIO231:

    uint32_t GPIO232 : 2; // 17:16   Select input qualification type for GPIO232:

    uint32_t GPIO233 : 2; // 19:18   Select input qualification type for GPIO233:

    uint32_t GPIO234 : 2; // 21:20   Select input qualification type for GPIO234:

    uint32_t GPIO235 : 2; // 23:22   Select input qualification type for GPIO235:

    uint32_t GPIO236 : 2; // 25:24   Select input qualification type for GPIO236:

    uint32_t GPIO237 : 2; // 27:26   Select input qualification type for GPIO237:

    uint32_t GPIO238 : 2; // 29:28   Select input qualification type for GPIO238:

    uint32_t GPIO239 : 2; // 31:30   Select input qualification type for GPIO239:
};

union GPHQSEL1_REG {
    uint32_t             all;
    struct GPHQSEL1_BITS bit;
};

//
// GPIO H Qualifier Select 2 Register (GPIO240 to 255)
//
struct GPHQSEL2_BITS {    // bits   description
    uint32_t rsvd1 : 2;   // 1:0   Reserved
    uint32_t GPIO241 : 2; // 3:2   Select input qualification type for GPIO241:

    uint32_t GPIO242 : 2; // 5:4   Select input qualification type for GPIO242:

    uint32_t rsvd2 : 2;   // 7:6   Reserved
    uint32_t GPIO244 : 2; // 9:8   Select input qualification type for GPIO244:

    uint32_t GPIO245 : 2; // 11:10   Select input qualification type for GPIO245:

    uint32_t rsvd3 : 4;   // 15:12   Reserved
    uint32_t GPIO248 : 2; // 17:16   Select input qualification type for GPIO248:

    uint32_t rsvd4 : 14; // 31:18   Reserved
};

union GPHQSEL2_REG {
    uint32_t             all;
    struct GPHQSEL2_BITS bit;
};

//
// GPIO H Mux 1 Register (GPIO224 to 239)
//
struct GPHMUX1_BITS {     // bits   description
    uint32_t GPIO224 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO225 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO226 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO227 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO228 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 2;   // 11:10   Reserved
    uint32_t GPIO230 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO231 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO232 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO233 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO234 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO235 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO236 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO237 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO238 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO239 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPHMUX1_REG {
    uint32_t            all;
    struct GPHMUX1_BITS bit;
};

//
// GPIO H Mux 2 Register (GPIO240 to 255)
//
struct GPHMUX2_BITS {     // bits   description
    uint32_t rsvd1 : 2;   // 1:0   Reserved
    uint32_t GPIO241 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO242 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t rsvd2 : 2;   // 7:6   Reserved
    uint32_t GPIO244 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO245 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t rsvd3 : 20;  // 31:12   Reserved
};

union GPHMUX2_REG {
    uint32_t            all;
    struct GPHMUX2_BITS bit;
};

//
// GPH Direction register(GPIO224 to 255)
//
struct GPHDIR_BITS {      // bits   description
    uint32_t GPIO224 : 1; // 0:0   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO225 : 1; // 1:1   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO226 : 1; // 2:2   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO227 : 1; // 3:3   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO228 : 1; // 4:4   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd2 : 2;   // 8:7   Reserved
    uint32_t GPIO233 : 1; // 9:9   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd3 : 2;   // 11:10   Reserved
    uint32_t GPIO236 : 1; // 12:12   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO237 : 1; // 13:13   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd4 : 4;   // 17:14   Reserved
    uint32_t GPIO242 : 1; // 18:18   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd5 : 2;   // 20:19   Reserved
    uint32_t GPIO245 : 1; // 21:21   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd6 : 10;  // 31:22   Reserved
};

union GPHDIR_REG {
    uint32_t           all;
    struct GPHDIR_BITS bit;
};

//
// GPIO H Pull Up Disable Register (GPIO224~255)
//
struct GPHPUD_BITS {      // bits   description
    uint32_t GPIO224 : 1; // 0:0   Pull-Up Disable control for this pin
    uint32_t GPIO225 : 1; // 1:1   Pull-Up Disable control for this pin
    uint32_t GPIO226 : 1; // 2:2   Pull-Up Disable control for this pin
    uint32_t GPIO227 : 1; // 3:3   Pull-Up Disable control for this pin
    uint32_t GPIO228 : 1; // 4:4   Pull-Up Disable control for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   Pull-Up Disable control for this pin
    uint32_t GPIO231 : 1; // 7:7   Pull-Up Disable control for this pin
    uint32_t GPIO232 : 1; // 8:8   Pull-Up Disable control for this pin
    uint32_t GPIO233 : 1; // 9:9   Pull-Up Disable control for this pin
    uint32_t GPIO234 : 1; // 10:10   Pull-Up Disable control for this pin
    uint32_t GPIO235 : 1; // 11:11   Pull-Up Disable control for this pin
    uint32_t GPIO236 : 1; // 12:12   Pull-Up Disable control for this pin
    uint32_t GPIO237 : 1; // 13:13   Pull-Up Disable control for this pin
    uint32_t GPIO238 : 1; // 14:14   Pull-Up Disable control for this pin
    uint32_t GPIO239 : 1; // 15:15   Pull-Up Disable control for this pin
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   Pull-Up Disable control for this pin
    uint32_t GPIO242 : 1; // 18:18   Pull-Up Disable control for this pin
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   Pull-Up Disable control for this pin
    uint32_t GPIO245 : 1; // 21:21   Pull-Up Disable control for this pin
    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   Pull-Up Disable control for this pin
    uint32_t rsvd6 : 7;   // 31:25   Reserved
};

union GPHPUD_REG {
    uint32_t           all;
    struct GPHPUD_BITS bit;
};

//
// GPIO H Input Polarity Invert Registers (GPIO224 to 255)
//
struct GPHINV_BITS {      // bits   description
    uint32_t GPIO224 : 1; // 0:0   Input inversion control for this pin
    uint32_t GPIO225 : 1; // 1:1   Input inversion control for this pin
    uint32_t GPIO226 : 1; // 2:2   Input inversion control for this pin
    uint32_t GPIO227 : 1; // 3:3   Input inversion control for this pin
    uint32_t GPIO228 : 1; // 4:4   Input inversion control for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   Input inversion control for this pin
    uint32_t GPIO231 : 1; // 7:7   Input inversion control for this pin
    uint32_t GPIO232 : 1; // 8:8   Input inversion control for this pin
    uint32_t GPIO233 : 1; // 9:9   Input inversion control for this pin
    uint32_t GPIO234 : 1; // 10:10   Input inversion control for this pin
    uint32_t GPIO235 : 1; // 11:11   Input inversion control for this pin
    uint32_t GPIO236 : 1; // 12:12   Input inversion control for this pin
    uint32_t GPIO237 : 1; // 13:13   Input inversion control for this pin
    uint32_t GPIO238 : 1; // 14:14   Input inversion control for this pin
    uint32_t GPIO239 : 1; // 15:15   Input inversion control for this pin
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   Input inversion control for this pin
    uint32_t GPIO242 : 1; // 18:18   Input inversion control for this pin
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   Input inversion control for this pin
    uint32_t GPIO245 : 1; // 21:21   Input inversion control for this pin
    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   Input inversion control for this pin
    uint32_t rsvd6 : 7;   // 31:25   Reserved
};

union GPHINV_REG {
    uint32_t           all;
    struct GPHINV_BITS bit;
};

//
// GPIO H Analog Mode Select register (GPIO224 to GPIO255)
//
struct GPHAMSEL_BITS {    // bits   description
    uint32_t GPIO224 : 1; // 0:0   0: The analog function of the pin is disabled and the pin is capable
    uint32_t GPIO225 : 1; // 1:1   Analog Mode select for this pin
    uint32_t GPIO226 : 1; // 2:2   Analog Mode select for this pin
    uint32_t GPIO227 : 1; // 3:3   Analog Mode select for this pin
    uint32_t GPIO228 : 1; // 4:4   Analog Mode select for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   Analog Mode select for this pin
    uint32_t GPIO231 : 1; // 7:7   Analog Mode select for this pin
    uint32_t GPIO232 : 1; // 8:8   Analog Mode select for this pin
    uint32_t GPIO233 : 1; // 9:9   Analog Mode select for this pin
    uint32_t GPIO234 : 1; // 10:10   Analog Mode select for this pin
    uint32_t GPIO235 : 1; // 11:11   Analog Mode select for this pin
    uint32_t GPIO236 : 1; // 12:12   Analog Mode select for this pin
    uint32_t GPIO237 : 1; // 13:13   Analog Mode select for this pin
    uint32_t GPIO238 : 1; // 14:14   Analog Mode select for this pin
    uint32_t GPIO239 : 1; // 15:15   Analog Mode select for this pin
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   Analog Mode select for this pin
    uint32_t GPIO242 : 1; // 18:18   Analog Mode select for this pin
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   Analog Mode select for this pin
    uint32_t GPIO245 : 1; // 21:21   Analog Mode select for this pin
    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   Analog Mode select for this pin
    uint32_t rsvd6 : 7;   // 31:25   Reserved
};

union GPHAMSEL_REG {
    uint32_t             all;
    struct GPHAMSEL_BITS bit;
};

//
// GPIO H Peripheral Group Mux (GPIO224 to 239)
//
struct GPHGMUX1_BITS {    // bits   description
    uint32_t GPIO224 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO225 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO226 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO227 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO228 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 2;   // 11:10   Reserved
    uint32_t GPIO230 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO231 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO232 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO233 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO234 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO235 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO236 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO237 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO238 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO239 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPHGMUX1_REG {
    uint32_t             all;
    struct GPHGMUX1_BITS bit;
};

//
// GPIO H Peripheral Group Mux (GPIO240 to 255)
//
struct GPHGMUX2_BITS {    // bits   description
    uint32_t rsvd1 : 2;   // 1:0   Reserved
    uint32_t GPIO241 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO242 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t rsvd2 : 2;   // 7:6   Reserved
    uint32_t GPIO244 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO245 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t rsvd3 : 20;  // 31:12   Reserved
};

union GPHGMUX2_REG {
    uint32_t             all;
    struct GPHGMUX2_BITS bit;
};

//
// GPIO A Pull Down Disable Register (GPIO0 to 31)
//
struct GPAPDD_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   Pull-Down Disable control for this pin
    uint32_t GPIO1 : 1;  // 1:1   Pull-Down Disable control for this pin
    uint32_t GPIO2 : 1;  // 2:2   Pull-Down Disable control for this pin
    uint32_t GPIO3 : 1;  // 3:3   Pull-Down Disable control for this pin
    uint32_t GPIO4 : 1;  // 4:4   Pull-Down Disable control for this pin
    uint32_t GPIO5 : 1;  // 5:5   Pull-Down Disable control for this pin
    uint32_t GPIO6 : 1;  // 6:6   Pull-Down Disable control for this pin
    uint32_t GPIO7 : 1;  // 7:7   Pull-Down Disable control for this pin
    uint32_t GPIO8 : 1;  // 8:8   Pull-Down Disable control for this pin
    uint32_t GPIO9 : 1;  // 9:9   Pull-Down Disable control for this pin
    uint32_t GPIO10 : 1; // 10:10   Pull-Down Disable control for this pin
    uint32_t GPIO11 : 1; // 11:11   Pull-Down Disable control for this pin
    uint32_t GPIO12 : 1; // 12:12   Pull-Down Disable control for this pin
    uint32_t GPIO13 : 1; // 13:13   Pull-Down Disable control for this pin
    uint32_t GPIO14 : 1; // 14:14   Pull-Down Disable control for this pin
    uint32_t GPIO15 : 1; // 15:15   Pull-Down Disable control for this pin
    uint32_t GPIO16 : 1; // 16:16   Pull-Down Disable control for this pin
    uint32_t GPIO17 : 1; // 17:17   Pull-Down Disable control for this pin
    uint32_t GPIO18 : 1; // 18:18   Pull-Down Disable control for this pin
    uint32_t GPIO19 : 1; // 19:19   Pull-Down Disable control for this pin
    uint32_t GPIO20 : 1; // 20:20   Pull-Down Disable control for this pin
    uint32_t GPIO21 : 1; // 21:21   Pull-Down Disable control for this pin
    uint32_t GPIO22 : 1; // 22:22   Pull-Down Disable control for this pin
    uint32_t GPIO23 : 1; // 23:23   Pull-Down Disable control for this pin
    uint32_t GPIO24 : 1; // 24:24   Pull-Down Disable control for this pin
    uint32_t GPIO25 : 1; // 25:25   Pull-Down Disable control for this pin
    uint32_t GPIO26 : 1; // 26:26   Pull-Down Disable control for this pin
    uint32_t GPIO27 : 1; // 27:27   Pull-Down Disable control for this pin
    uint32_t GPIO28 : 1; // 28:28   Pull-Down Disable control for this pin
    uint32_t GPIO29 : 1; // 29:29   Pull-Down Disable control for this pin
    uint32_t GPIO30 : 1; // 30:30   Pull-Down Disable control for this pin
    uint32_t GPIO31 : 1; // 31:31   Pull-Down Disable control for this pin
};

union GPAPDD_REG {
    uint32_t           all;
    struct GPAPDD_BITS bit;
};

//
// GPIO A Drive Strength 1 Register1 (GPIO0 to 15)
//
struct GPADS1_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   Defines drive strength for PI2C GPIO
    uint32_t rsvd1 : 1;  // 1:1   Reserved
    uint32_t GPIO1 : 2;  // 3:2   Defines drive strength for GPIO
    uint32_t GPIO2 : 2;  // 5:4   Defines drive strength for GPIO
    uint32_t GPIO3 : 1;  // 6:6   Defines drive strength for PI2C GPIO
    uint32_t rsvd2 : 1;  // 7:7   Reserved
    uint32_t GPIO4 : 1;  // 8:8   Defines drive strength for PI2C GPIO
    uint32_t rsvd3 : 1;  // 9:9   Reserved
    uint32_t GPIO5 : 1;  // 10:10   Defines drive strength for PI2C GPIO
    uint32_t rsvd4 : 1;  // 11:11   Reserved
    uint32_t GPIO6 : 2;  // 13:12   Defines drive strength for GPIO
    uint32_t GPIO7 : 2;  // 15:14   Defines drive strength for GPIO
    uint32_t GPIO8 : 1;  // 16:16   Defines drive strength for PI2C GPIO
    uint32_t rsvd5 : 1;  // 17:17   Reserved
    uint32_t GPIO9 : 1;  // 18:18   Defines drive strength for PI2C GPIO
    uint32_t rsvd6 : 1;  // 19:19   Reserved
    uint32_t GPIO10 : 2; // 21:20   Defines drive strength for GPIO
    uint32_t GPIO11 : 2; // 23:22   Defines drive strength for GPIO
    uint32_t GPIO12 : 2; // 25:24   Defines drive strength for GPIO
    uint32_t GPIO13 : 1; // 26:26   Defines drive strength for PI2C GPIO
    uint32_t rsvd7 : 1;  // 27:27   Reserved
    uint32_t GPIO14 : 1; // 28:28   Defines drive strength for PI2C GPIO
    uint32_t rsvd8 : 1;  // 29:29   Reserved
    uint32_t GPIO15 : 1; // 30:30   Defines drive strength for PI2C GPIO
    uint32_t rsvd9 : 1;  // 31:31   Reserved
};

union GPADS1_REG {
    uint32_t           all;
    struct GPADS1_BITS bit;
};

//
// GPIO A Drive Strength Register2 (GPIO16 to 31)
//
struct GPADS2_BITS {     // bits   description
    uint32_t GPIO16 : 1; // 0:0   Defines drive strength for PI2C GPIO
    uint32_t rsvd1 : 1;  // 1:1   Reserved
    uint32_t GPIO17 : 1; // 2:2   Defines drive strength for PI2C GPIO
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t GPIO18 : 1; // 4:4   Defines drive strength for PI2C GPIO
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t GPIO19 : 1; // 6:6   Defines drive strength for PI2C GPIO
    uint32_t rsvd4 : 1;  // 7:7   Reserved
    uint32_t GPIO20 : 1; // 8:8   Defines drive strength for PI2C GPIO
    uint32_t rsvd5 : 1;  // 9:9   Reserved
    uint32_t GPIO21 : 1; // 10:10   Defines drive strength for PI2C GPIO
    uint32_t rsvd6 : 1;  // 11:11   Reserved
    uint32_t GPIO22 : 2; // 13:12   Defines drive strength for GPIO
    uint32_t GPIO23 : 2; // 15:14   Defines drive strength for GPIO
    uint32_t GPIO24 : 2; // 17:16   Defines drive strength for GPIO
    uint32_t GPIO25 : 1; // 18:18   Defines drive strength for PI2C GPIO
    uint32_t rsvd7 : 1;  // 19:19   Reserved
    uint32_t GPIO26 : 2; // 21:20   Defines drive strength for GPIO
    uint32_t GPIO27 : 1; // 22:22   Defines drive strength for PI2C GPIO
    uint32_t rsvd8 : 1;  // 23:23   Reserved
    uint32_t GPIO28 : 1; // 24:24   Defines drive strength for GPIO
    uint32_t rsvd9 : 1;  // 25:25   Reserved
    uint32_t GPIO29 : 1; // 26:26   Defines drive strength for GPIO
    uint32_t rsvd10 : 1; // 27:27   Reserved
    uint32_t GPIO30 : 2; // 29:28   Defines drive strength for GPIO
    uint32_t GPIO31 : 2; // 31:30   Defines drive strength for GPIO
};

union GPADS2_REG {
    uint32_t           all;
    struct GPADS2_BITS bit;
};

//
// GPIO A Schmitt Trigger Register (GPIO0 to 31)
//
struct GPAIS_BITS {      // bits   description
    uint32_t GPIO0 : 1;  // 0:0   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO1 : 1;  // 1:1   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO2 : 1;  // 2:2   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO3 : 1;  // 3:3   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO4 : 1;  // 4:4   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO5 : 1;  // 5:5   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO6 : 1;  // 6:6   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO7 : 1;  // 7:7   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO8 : 1;  // 8:8   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO9 : 1;  // 9:9   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO10 : 1; // 10:10   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO11 : 1; // 11:11   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO12 : 1; // 12:12   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO13 : 1; // 13:13   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO14 : 1; // 14:14   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO15 : 1; // 15:15   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO16 : 1; // 16:16   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO17 : 1; // 17:17   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO18 : 1; // 18:18   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO19 : 1; // 19:19   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO20 : 1; // 20:20   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO21 : 1; // 21:21   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO22 : 1; // 22:22   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO23 : 1; // 23:23   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO24 : 1; // 24:24   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO25 : 1; // 25:25   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO26 : 1; // 26:26   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO27 : 1; // 27:27   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO28 : 1; // 28:28   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO29 : 1; // 29:29   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO30 : 1; // 30:30   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO31 : 1; // 31:31   Defines  Schmitt trigger for this pin in GPIO mode
};

union GPAIS_REG {
    uint32_t          all;
    struct GPAIS_BITS bit;
};

//
// GPIO A output Polarity Invert Registers (GPIO0 to 31)
//
struct GPAOUTINV_BITS {  // bits   description
    uint32_t GPIO0 : 1;  // 0:0   output inversion control for this pin
    uint32_t GPIO1 : 1;  // 1:1   output inversion control for this pin
    uint32_t GPIO2 : 1;  // 2:2   output inversion control for this pin
    uint32_t GPIO3 : 1;  // 3:3   output inversion control for this pin
    uint32_t GPIO4 : 1;  // 4:4   output inversion control for this pin
    uint32_t GPIO5 : 1;  // 5:5   output inversion control for this pin
    uint32_t GPIO6 : 1;  // 6:6   output inversion control for this pin
    uint32_t GPIO7 : 1;  // 7:7   output inversion control for this pin
    uint32_t GPIO8 : 1;  // 8:8   output inversion control for this pin
    uint32_t GPIO9 : 1;  // 9:9   output inversion control for this pin
    uint32_t GPIO10 : 1; // 10:10   output inversion control for this pin
    uint32_t GPIO11 : 1; // 11:11   output inversion control for this pin
    uint32_t GPIO12 : 1; // 12:12   output inversion control for this pin
    uint32_t GPIO13 : 1; // 13:13   output inversion control for this pin
    uint32_t GPIO14 : 1; // 14:14   output inversion control for this pin
    uint32_t GPIO15 : 1; // 15:15   output inversion control for this pin
    uint32_t GPIO16 : 1; // 16:16   output inversion control for this pin
    uint32_t GPIO17 : 1; // 17:17   output inversion control for this pin
    uint32_t GPIO18 : 1; // 18:18   output inversion control for this pin
    uint32_t GPIO19 : 1; // 19:19   output inversion control for this pin
    uint32_t GPIO20 : 1; // 20:20   output inversion control for this pin
    uint32_t GPIO21 : 1; // 21:21   output inversion control for this pin
    uint32_t GPIO22 : 1; // 22:22   output inversion control for this pin
    uint32_t GPIO23 : 1; // 23:23   output inversion control for this pin
    uint32_t GPIO24 : 1; // 24:24   output inversion control for this pin
    uint32_t GPIO25 : 1; // 25:25   output inversion control for this pin
    uint32_t GPIO26 : 1; // 26:26   output inversion control for this pin
    uint32_t GPIO27 : 1; // 27:27   output inversion control for this pin
    uint32_t GPIO28 : 1; // 28:28   output inversion control for this pin
    uint32_t GPIO29 : 1; // 29:29   output inversion control for this pin
    uint32_t GPIO30 : 1; // 30:30   output inversion control for this pin
    uint32_t GPIO31 : 1; // 31:31   output inversion control for this pin
};

union GPAOUTINV_REG {
    uint32_t              all;
    struct GPAOUTINV_BITS bit;
};

//
// GPIO A LOOP Enable Registers (GPIO0 to 31)
//
struct GPALOOPEN_BITS {  // bits   description
    uint32_t GPIO0 : 1;  // 0:0   loopback enable for this pin
    uint32_t GPIO1 : 1;  // 1:1   loopback enable for this pin
    uint32_t GPIO2 : 1;  // 2:2   loopback enable for this pin
    uint32_t GPIO3 : 1;  // 3:3   loopback enable for this pin
    uint32_t GPIO4 : 1;  // 4:4   loopback enable for this pin
    uint32_t GPIO5 : 1;  // 5:5   loopback enable for this pin
    uint32_t GPIO6 : 1;  // 6:6   loopback enable for this pin
    uint32_t GPIO7 : 1;  // 7:7   loopback enable for this pin
    uint32_t GPIO8 : 1;  // 8:8   loopback enable for this pin
    uint32_t GPIO9 : 1;  // 9:9   loopback enable for this pin
    uint32_t GPIO10 : 1; // 10:10   loopback enable for this pin
    uint32_t GPIO11 : 1; // 11:11   loopback enable for this pin
    uint32_t GPIO12 : 1; // 12:12   loopback enable for this pin
    uint32_t GPIO13 : 1; // 13:13   loopback enable for this pin
    uint32_t GPIO14 : 1; // 14:14   loopback enable for this pin
    uint32_t GPIO15 : 1; // 15:15   loopback enable for this pin
    uint32_t GPIO16 : 1; // 16:16   loopback enable for this pin
    uint32_t GPIO17 : 1; // 17:17   loopback enable for this pin
    uint32_t GPIO18 : 1; // 18:18   loopback enable for this pin
    uint32_t GPIO19 : 1; // 19:19   loopback enable for this pin
    uint32_t GPIO20 : 1; // 20:20   loopback enable for this pin
    uint32_t GPIO21 : 1; // 21:21   loopback enable for this pin
    uint32_t GPIO22 : 1; // 22:22   loopback enable for this pin
    uint32_t GPIO23 : 1; // 23:23   loopback enable for this pin
    uint32_t GPIO24 : 1; // 24:24   loopback enable for this pin
    uint32_t GPIO25 : 1; // 25:25   loopback enable for this pin
    uint32_t GPIO26 : 1; // 26:26   loopback enable for this pin
    uint32_t GPIO27 : 1; // 27:27   loopback enable for this pin
    uint32_t GPIO28 : 1; // 28:28   loopback enable for this pin
    uint32_t GPIO29 : 1; // 29:29   loopback enable for this pin
    uint32_t GPIO30 : 1; // 30:30   loopback enable for this pin
    uint32_t GPIO31 : 1; // 31:31   loopback enable for this pin
};

union GPALOOPEN_REG {
    uint32_t              all;
    struct GPALOOPEN_BITS bit;
};

//
// GPIO A PI2C MODE Registers (GPIO0 to 31)
//
struct GPAPI2C_MODE_BITS { // bits   description
    uint32_t GPIO0 : 1;    // 0:0   I2C Mode Select for this pin
    uint32_t GPIO1 : 1;    // 1:1   I2C Mode Select for this pin
    uint32_t GPIO2 : 1;    // 2:2   I2C Mode Select for this pin
    uint32_t GPIO3 : 1;    // 3:3   I2C Mode Select for this pin
    uint32_t GPIO4 : 1;    // 4:4   I2C Mode Select for this pin
    uint32_t GPIO5 : 1;    // 5:5   I2C Mode Select for this pin
    uint32_t rsvd1 : 2;    // 7:6   Reserved
    uint32_t GPIO8 : 1;    // 8:8   I2C Mode Select for this pin
    uint32_t GPIO9 : 1;    // 9:9   I2C Mode Select for this pin
    uint32_t GPIO10 : 1;   // 10:10   I2C Mode Select for this pin
    uint32_t rsvd2 : 1;    // 11:11   Reserved
    uint32_t GPIO12 : 1;   // 12:12   I2C Mode Select for this pin
    uint32_t GPIO13 : 1;   // 13:13   I2C Mode Select for this pin
    uint32_t GPIO14 : 1;   // 14:14   I2C Mode Select for this pin
    uint32_t GPIO15 : 1;   // 15:15   I2C Mode Select for this pin
    uint32_t GPIO16 : 1;   // 16:16   I2C Mode Select for this pin
    uint32_t GPIO17 : 1;   // 17:17   I2C Mode Select for this pin
    uint32_t GPIO18 : 1;   // 18:18   I2C Mode Select for this pin
    uint32_t GPIO19 : 1;   // 19:19   I2C Mode Select for this pin
    uint32_t GPIO20 : 1;   // 20:20   I2C Mode Select for this pin
    uint32_t GPIO21 : 1;   // 21:21   I2C Mode Select for this pin
    uint32_t rsvd3 : 2;    // 23:22   Reserved
    uint32_t GPIO24 : 1;   // 24:24   I2C Mode Select for this pin
    uint32_t GPIO25 : 1;   // 25:25   I2C Mode Select for this pin
    uint32_t GPIO26 : 1;   // 26:26   I2C Mode Select for this pin
    uint32_t GPIO27 : 1;   // 27:27   I2C Mode Select for this pin
    uint32_t GPIO28 : 1;   // 28:28   I2C Mode Select for this pin
    uint32_t GPIO29 : 1;   // 29:29   I2C Mode Select for this pin
    uint32_t GPIO30 : 1;   // 30:30   I2C Mode Select for this pin (Meaningful at 035.)
    uint32_t rsvd4 : 1;    // 31:31   Reserved
};

union GPAPI2C_MODE_REG {
    uint32_t                 all;
    struct GPAPI2C_MODE_BITS bit;
};

//
// GPIO B Pull Down Disable Register (GPIO32 to 63)
//
struct GPBPDD_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   Pull-Down Disable control for this pin
    uint32_t GPIO33 : 1; // 1:1   Pull-Down Disable control for this pin
    uint32_t GPIO34 : 1; // 2:2   Pull-Down Disable control for this pin
    uint32_t GPIO35 : 1; // 3:3   Pull-Down Disable control for this pin
    uint32_t GPIO36 : 1; // 4:4   Pull-Down Disable control for this pin
    uint32_t GPIO37 : 1; // 5:5   Pull-Down Disable control for this pin
    uint32_t GPIO38 : 1; // 6:6   Pull-Down Disable control for this pin
    uint32_t GPIO39 : 1; // 7:7   Pull-Down Disable control for this pin
    uint32_t GPIO40 : 1; // 8:8   Pull-Down Disable control for this pin
    uint32_t GPIO41 : 1; // 9:9   Pull-Down Disable control for this pin
    uint32_t GPIO42 : 1; // 10:10   Pull-Down Disable control for this pin
    uint32_t GPIO43 : 1; // 11:11   Pull-Down Disable control for this pin
    uint32_t GPIO44 : 1; // 12:12   Pull-Down Disable control for this pin
    uint32_t GPIO45 : 1; // 13:13   Pull-Down Disable control for this pin
    uint32_t GPIO46 : 1; // 14:14   Pull-Down Disable control for this pin
    uint32_t rsvd1 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   Pull-Down Disable control for this pin
    uint32_t GPIO49 : 1; // 17:17   Pull-Down Disable control for this pin
    uint32_t rsvd2 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   Pull-Down Disable control for this pin
    uint32_t GPIO54 : 1; // 22:22   Pull-Down Disable control for this pin
    uint32_t GPIO55 : 1; // 23:23   Pull-Down Disable control for this pin
    uint32_t GPIO56 : 1; // 24:24   Pull-Down Disable control for this pin
    uint32_t GPIO57 : 1; // 25:25   Pull-Down Disable control for this pin
    uint32_t GPIO58 : 1; // 26:26   Pull-Down Disable control for this pin
    uint32_t GPIO59 : 1; // 27:27   Pull-Down Disable control for this pin
    uint32_t GPIO60 : 1; // 28:28   Pull-Down Disable control for this pin
    uint32_t GPIO61 : 1; // 29:29   Pull-Down Disable control for this pin
    uint32_t GPIO62 : 1; // 30:30   Pull-Down Disable control for this pin
    uint32_t GPIO63 : 1; // 31:31   Pull-Down Disable control for this pin
};

union GPBPDD_REG {
    uint32_t           all;
    struct GPBPDD_BITS bit;
};

//
// GPIO B Drive Strength 1 Register1 (GPIO32 to 47)
//
struct GPBDS1_BITS {     // bits   description
    uint32_t GPIO32 : 2; // 1:0   Defines drive strength for GPIO
    uint32_t GPIO33 : 1; // 2:2   Defines drive strength for PI2C GPIO
    uint32_t rsvd1 : 1;  // 3:3   Reserved
    uint32_t GPIO34 : 1; // 4:4   Defines drive strength for PI2C GPIO
    uint32_t rsvd2 : 1;  // 5:5   Reserved
    uint32_t GPIO35 : 1; // 6:6   Defines drive strength for PI2C GPIO
    uint32_t rsvd3 : 1;  // 7:7   Reserved
    uint32_t GPIO36 : 1; // 8:8   Defines drive strength for PI2C GPIO (The default is tms, with the maximum driving capability.)
    uint32_t rsvd4 : 1;  // 9:9   Reserved
    uint32_t GPIO37 : 1; // 10:10   Defines drive strength for PI2C GPIO
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t GPIO38 : 1; // 12:12   Defines drive strength for PI2C GPIO
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t GPIO39 : 2; // 15:14   Defines drive strength for GPIO
    uint32_t GPIO40 : 1; // 16:16   Defines drive strength for PI2C GPIO
    uint32_t rsvd7 : 1;  // 17:17   Reserved
    uint32_t GPIO41 : 1; // 18:18   Defines drive strength for PI2C GPIO
    uint32_t rsvd8 : 1;  // 19:19   Reserved
    uint32_t GPIO42 : 2; // 21:20   Defines drive strength for GPIO
    uint32_t GPIO43 : 1; // 22:22   Defines drive strength for PI2C GPIO
    uint32_t rsvd9 : 1;  // 23:23   Reserved
    uint32_t GPIO44 : 2; // 25:24   Defines drive strength for GPIO
    uint32_t GPIO45 : 1; // 26:26   Defines drive strength for PI2C GPIO
    uint32_t rsvd10 : 1; // 27:27   Reserved
    uint32_t GPIO46 : 1; // 28:28   Defines drive strength for PI2C GPIO
    uint32_t rsvd11 : 1; // 29:29   Reserved
    uint32_t rsvd12 : 2; // 31:30   Reserved
};

union GPBDS1_REG {
    uint32_t           all;
    struct GPBDS1_BITS bit;
};

//
// GPIO B Drive Strength Register2 (GPIO48 to 63)
//
struct GPBDS2_BITS {     // bits   description
    uint32_t GPIO48 : 1; // 0:0   Defines drive strength for PI2C GPIO
    uint32_t rsvd1 : 1;  // 1:1   Reserved
    uint32_t GPIO49 : 2; // 3:2   Defines drive strength for GPIO
    uint32_t rsvd2 : 6;  // 9:4   Reserved
    uint32_t GPIO53 : 2; // 11:10   Defines drive strength for GPIO
    uint32_t GPIO54 : 2; // 13:12   Defines drive strength for GPIO
    uint32_t GPIO55 : 2; // 15:14   Defines drive strength for GPIO
    uint32_t GPIO56 : 1; // 16:16   Defines drive strength for PI2C GPIO
    uint32_t rsvd3 : 1;  // 17:17   Reserved
    uint32_t GPIO57 : 1; // 18:18   Defines drive strength for PI2C GPIO
    uint32_t rsvd4 : 1;  // 19:19   Reserved
    uint32_t GPIO58 : 2; // 21:20   Defines drive strength for GPIO
    uint32_t GPIO59 : 2; // 23:22   Defines drive strength for GPIO
    uint32_t GPIO60 : 2; // 25:24   Defines drive strength for GPIO
    uint32_t GPIO61 : 2; // 27:26   Defines drive strength for GPIO
    uint32_t GPIO62 : 1; // 28:28   Defines drive strength for PI2C GPIO
    uint32_t rsvd5 : 1;  // 29:29   Reserved
    uint32_t GPIO63 : 2; // 31:30   Defines drive strength for GPIO
};

union GPBDS2_REG {
    uint32_t           all;
    struct GPBDS2_BITS bit;
};

//
// GPIO B Schmitt Trigger Register (GPIO32 to 63)
//
struct GPBIS_BITS {      // bits   description
    uint32_t GPIO32 : 1; // 0:0   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO33 : 1; // 1:1   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO34 : 1; // 2:2   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO35 : 1; // 3:3   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO36 : 1; // 4:4   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO37 : 1; // 5:5   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO38 : 1; // 6:6   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO39 : 1; // 7:7   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO40 : 1; // 8:8   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO41 : 1; // 9:9   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO42 : 1; // 10:10   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO43 : 1; // 11:11   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO44 : 1; // 12:12   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO45 : 1; // 13:13   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO46 : 1; // 14:14   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd1 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO49 : 1; // 17:17   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd2 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO54 : 1; // 22:22   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO55 : 1; // 23:23   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO56 : 1; // 24:24   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO57 : 1; // 25:25   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO58 : 1; // 26:26   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO59 : 1; // 27:27   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO60 : 1; // 28:28   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO61 : 1; // 29:29   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO62 : 1; // 30:30   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO63 : 1; // 31:31   Defines  Schmitt trigger for this pin in GPIO mode
};

union GPBIS_REG {
    uint32_t          all;
    struct GPBIS_BITS bit;
};

//
// GPIO B output Polarity Invert Registers (GPIO32 to 63)
//
struct GPBOUTINV_BITS {  // bits   description
    uint32_t GPIO32 : 1; // 0:0   output inversion control for this pin
    uint32_t GPIO33 : 1; // 1:1   output inversion control for this pin
    uint32_t GPIO34 : 1; // 2:2   output inversion control for this pin
    uint32_t GPIO35 : 1; // 3:3   output inversion control for this pin
    uint32_t GPIO36 : 1; // 4:4   output inversion control for this pin
    uint32_t GPIO37 : 1; // 5:5   output inversion control for this pin
    uint32_t GPIO38 : 1; // 6:6   output inversion control for this pin
    uint32_t GPIO39 : 1; // 7:7   output inversion control for this pin
    uint32_t GPIO40 : 1; // 8:8   output inversion control for this pin
    uint32_t GPIO41 : 1; // 9:9   output inversion control for this pin
    uint32_t GPIO42 : 1; // 10:10   output inversion control for this pin
    uint32_t GPIO43 : 1; // 11:11   output inversion control for this pin
    uint32_t GPIO44 : 1; // 12:12   output inversion control for this pin
    uint32_t GPIO45 : 1; // 13:13   output inversion control for this pin
    uint32_t GPIO46 : 1; // 14:14   output inversion control for this pin
    uint32_t rsvd1 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   output inversion control for this pin
    uint32_t GPIO49 : 1; // 17:17   output inversion control for this pin
    uint32_t rsvd2 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   output inversion control for this pin
    uint32_t GPIO54 : 1; // 22:22   output inversion control for this pin
    uint32_t GPIO55 : 1; // 23:23   output inversion control for this pin
    uint32_t GPIO56 : 1; // 24:24   output inversion control for this pin
    uint32_t GPIO57 : 1; // 25:25   output inversion control for this pin
    uint32_t GPIO58 : 1; // 26:26   output inversion control for this pin
    uint32_t GPIO59 : 1; // 27:27   output inversion control for this pin
    uint32_t GPIO60 : 1; // 28:28   output inversion control for this pin
    uint32_t GPIO61 : 1; // 29:29   output inversion control for this pin
    uint32_t GPIO62 : 1; // 30:30   output inversion control for this pin
    uint32_t GPIO63 : 1; // 31:31   output inversion control for this pin
};

union GPBOUTINV_REG {
    uint32_t              all;
    struct GPBOUTINV_BITS bit;
};

//
// GPIO B LOOP Enable Registers (GPIO32 to 63)
//
struct GPBLOOPEN_BITS {  // bits   description
    uint32_t GPIO32 : 1; // 0:0   loopback enable for this pin
    uint32_t GPIO33 : 1; // 1:1   loopback enable for this pin
    uint32_t GPIO34 : 1; // 2:2   loopback enable for this pin
    uint32_t GPIO35 : 1; // 3:3   loopback enable for this pin
    uint32_t GPIO36 : 1; // 4:4   loopback enable for this pin
    uint32_t GPIO37 : 1; // 5:5   loopback enable for this pin
    uint32_t GPIO38 : 1; // 6:6   loopback enable for this pin
    uint32_t GPIO39 : 1; // 7:7   loopback enable for this pin
    uint32_t GPIO40 : 1; // 8:8   loopback enable for this pin
    uint32_t GPIO41 : 1; // 9:9   loopback enable for this pin
    uint32_t GPIO42 : 1; // 10:10   loopback enable for this pin
    uint32_t GPIO43 : 1; // 11:11   loopback enable for this pin
    uint32_t GPIO44 : 1; // 12:12   loopback enable for this pin
    uint32_t GPIO45 : 1; // 13:13   loopback enable for this pin
    uint32_t GPIO46 : 1; // 14:14   loopback enable for this pin
    uint32_t rsvd1 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   loopback enable for this pin
    uint32_t GPIO49 : 1; // 17:17   loopback enable for this pin
    uint32_t rsvd2 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   loopback enable for this pin
    uint32_t GPIO54 : 1; // 22:22   loopback enable for this pin
    uint32_t GPIO55 : 1; // 23:23   loopback enable for this pin
    uint32_t GPIO56 : 1; // 24:24   loopback enable for this pin
    uint32_t GPIO57 : 1; // 25:25   loopback enable for this pin
    uint32_t GPIO58 : 1; // 26:26   loopback enable for this pin
    uint32_t GPIO59 : 1; // 27:27   loopback enable for this pin
    uint32_t GPIO60 : 1; // 28:28   loopback enable for this pin
    uint32_t GPIO61 : 1; // 29:29   loopback enable for this pin
    uint32_t GPIO62 : 1; // 30:30   loopback enable for this pin
    uint32_t GPIO63 : 1; // 31:31   loopback enable for this pin
};

union GPBLOOPEN_REG {
    uint32_t              all;
    struct GPBLOOPEN_BITS bit;
};

//
// GPIO B PI2C MODE Registers (GPIO32 to 63)
//
struct GPBPI2C_MODE_BITS { // bits   description
    uint32_t GPIO32 : 1;   // 0:0   I2C Mode Select for this pin
    uint32_t GPIO33 : 1;   // 1:1   I2C Mode Select for this pin
    uint32_t GPIO34 : 1;   // 2:2   I2C Mode Select for this pin
    uint32_t GPIO35 : 1;   // 3:3   I2C Mode Select for this pin
    uint32_t rsvd1 : 1;    // 4:4   Reserved
    uint32_t GPIO37 : 1;   // 5:5   I2C Mode Select for this pin
    uint32_t rsvd2 : 2;    // 7:6   Reserved
    uint32_t GPIO40 : 1;   // 8:8   I2C Mode Select for this pin
    uint32_t GPIO41 : 1;   // 9:9   I2C Mode Select for this pin
    uint32_t GPIO42 : 1;   // 10:10   I2C Mode Select for this pin
    uint32_t GPIO43 : 1;   // 11:11   I2C Mode Select for this pin
    uint32_t GPIO44 : 1;   // 12:12   I2C Mode Select for this pin
    uint32_t GPIO45 : 1;   // 13:13   I2C Mode Select for this pin
    uint32_t GPIO46 : 1;   // 14:14   I2C Mode Select for this pin
    uint32_t rsvd3 : 1;    // 15:15   Reserved
    uint32_t GPIO48 : 1;   // 16:16   I2C Mode Select for this pin
    uint32_t rsvd4 : 7;    // 23:17   Reserved
    uint32_t GPIO56 : 1;   // 24:24   I2C Mode Select for this pin
    uint32_t GPIO57 : 1;   // 25:25   I2C Mode Select for this pin
    uint32_t rsvd5 : 4;    // 29:26   Reserved
    uint32_t GPIO62 : 1;   // 30:30   I2C Mode Select for this pin
    uint32_t rsvd6 : 1;    // 31:31   Reserved
};

union GPBPI2C_MODE_REG {
    uint32_t                 all;
    struct GPBPI2C_MODE_BITS bit;
};

//
// GPIO G Pull Down Disable Register (GPIO200)
//
struct GPGPDD_BITS {      // bits   description
    uint32_t GPIO200 : 1; // 0:0   Pull-Down Disable control for this pin
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGPDD_REG {
    uint32_t           all;
    struct GPGPDD_BITS bit;
};

//
// GPIO G Drive Strength 1 Register1 (GPIO200)
//
struct GPGDS1_BITS {      // bits   description
    uint32_t GPIO200 : 2; // 1:0   Defines drive strength for GPIO
    uint32_t rsvd1 : 30;  // 31:2   Reserved
};

union GPGDS1_REG {
    uint32_t           all;
    struct GPGDS1_BITS bit;
};

//
// GPIO G Schmitt Trigger Register (GPIO200)
//
struct GPGIS_BITS {       // bits   description
    uint32_t GPIO200 : 1; // 0:0   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGIS_REG {
    uint32_t          all;
    struct GPGIS_BITS bit;
};

//
// GPIO G output Polarity Invert Registers (GPIO200)
//
struct GPGOUTINV_BITS {   // bits   description
    uint32_t GPIO200 : 1; // 0:0   output inversion control for this pin
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGOUTINV_REG {
    uint32_t              all;
    struct GPGOUTINV_BITS bit;
};

//
// GPIO G LOOP Enable Registers (GPIO200)
//
struct GPGLOOPEN_BITS {   // bits   description
    uint32_t GPIO200 : 1; // 0:0   loopback enable for this pin
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGLOOPEN_REG {
    uint32_t              all;
    struct GPGLOOPEN_BITS bit;
};

//
// GPIO H Pull Down Disable Register (GPIO224)
//
struct GPHPDD_BITS {      // bits   description
    uint32_t GPIO224 : 1; // 0:0   Pull-Down Disable control for this pin
    uint32_t GPIO225 : 1; // 1:1   Pull-Down Disable control for this pin
    uint32_t GPIO226 : 1; // 2:2   Pull-Down Disable control for this pin
    uint32_t GPIO227 : 1; // 3:3   Pull-Down Disable control for this pin
    uint32_t GPIO228 : 1; // 4:4   Pull-Down Disable control for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   Pull-Down Disable control for this pin
    uint32_t GPIO231 : 1; // 7:7   Pull-Down Disable control for this pin
    uint32_t GPIO232 : 1; // 8:8   Pull-Down Disable control for this pin
    uint32_t GPIO233 : 1; // 9:9   Pull-Down Disable control for this pin
    uint32_t GPIO234 : 1; // 10:10   Pull-Down Disable control for this pin
    uint32_t GPIO235 : 1; // 11:11   Pull-Down Disable control for this pin
    uint32_t GPIO236 : 1; // 12:12   Pull-Down Disable control for this pin
    uint32_t GPIO237 : 1; // 13:13   Pull-Down Disable control for this pin
    uint32_t GPIO238 : 1; // 14:14   Pull-Down Disable control for this pin
    uint32_t GPIO239 : 1; // 15:15   Pull-Down Disable control for this pin
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   Pull-Down Disable control for this pin
    uint32_t GPIO242 : 1; // 18:18   Pull-Down Disable control for this pin
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   Pull-Down Disable control for this pin
    uint32_t GPIO245 : 1; // 21:21   Pull-Down Disable control for this pin
    uint32_t rsvd4 : 2;   // 23:22   Reserved
    uint32_t GPIO248 : 1; // 24:24   Pull-Down Disable control for this pin
    uint32_t rsvd5 : 7;   // 31:25   Reserved
};

union GPHPDD_REG {
    uint32_t           all;
    struct GPHPDD_BITS bit;
};

//
// GPIO H Drive Strength 1 Register1 (GPIO224 to 239)
//
struct GPHDS1_BITS {      // bits   description
    uint32_t GPIO224 : 2; // 1:0   Defines drive strength for GPIO
    uint32_t GPIO225 : 2; // 3:2   Defines drive strength for GPIO
    uint32_t GPIO226 : 2; // 5:4   Defines drive strength for GPIO
    uint32_t GPIO227 : 1; // 6:6   Defines drive strength for PI2C GPIO
    uint32_t rsvd1 : 1;   // 7:7   Reserved
    uint32_t GPIO228 : 2; // 9:8   Defines drive strength for GPIO
    uint32_t rsvd2 : 2;   // 11:10   Reserved
    uint32_t GPIO230 : 1; // 12:12   Defines drive strength for PI2C GPIO
    uint32_t rsvd3 : 5;   // 17:13   Reserved
    uint32_t GPIO233 : 2; // 19:18   Defines drive strength for GPIO
    uint32_t rsvd4 : 4;   // 23:20   Reserved
    uint32_t GPIO236 : 1; // 24:24   Defines drive strength for PI2C GPIO
    uint32_t rsvd5 : 1;   // 25:25   Reserved
    uint32_t GPIO237 : 2; // 27:26   Defines drive strength for GPIO
    uint32_t rsvd6 : 4;   // 31:28   Reserved
};

union GPHDS1_REG {
    uint32_t           all;
    struct GPHDS1_BITS bit;
};

//
// GPIO H Drive Strength 2 Register2 (GPIO240to 255)
//
struct GPHDS2_BITS {      // bits   description
    uint32_t rsvd1 : 4;   // 3:0   Reserved
    uint32_t GPIO242 : 2; // 5:4   Defines drive strength for GPIO
    uint32_t rsvd2 : 4;   // 9:6   Reserved
    uint32_t GPIO245 : 2; // 11:10   Defines drive strength for GPIO
    uint32_t rsvd3 : 20;  // 31:12   Reserved
};

union GPHDS2_REG {
    uint32_t           all;
    struct GPHDS2_BITS bit;
};

//
// GPIO G Schmitt Trigger Register (GPIO224 to 248)
//
struct GPHIS_BITS {       // bits   description
    uint32_t GPIO224 : 1; // 0:0   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO225 : 1; // 1:1   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO226 : 1; // 2:2   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO227 : 1; // 3:3   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO228 : 1; // 4:4   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO231 : 1; // 7:7   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO232 : 1; // 8:8   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO233 : 1; // 9:9   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO234 : 1; // 10:10   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO235 : 1; // 11:11   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO236 : 1; // 12:12   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO237 : 1; // 13:13   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO238 : 1; // 14:14   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO239 : 1; // 15:15   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO242 : 1; // 18:18   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t GPIO245 : 1; // 21:21   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd4 : 2;   // 23:22   Reserved
    uint32_t GPIO248 : 1; // 24:24   Defines  Schmitt trigger for this pin in GPIO mode
    uint32_t rsvd5 : 7;   // 31:25   Reserved
};

union GPHIS_REG {
    uint32_t          all;
    struct GPHIS_BITS bit;
};

//
// GPIO H output Polarity Invert Registers (GPIO224~255)
//
struct GPHOUTINV_BITS {   // bits   description
    uint32_t GPIO224 : 1; // 0:0   output inversion control for this pin
    uint32_t GPIO225 : 1; // 1:1   output inversion control for this pin
    uint32_t GPIO226 : 1; // 2:2   output inversion control for this pin
    uint32_t GPIO227 : 1; // 3:3   output inversion control for this pin
    uint32_t GPIO228 : 1; // 4:4   output inversion control for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   output inversion control for this pin
    uint32_t rsvd2 : 2;   // 8:7   Reserved
    uint32_t GPIO233 : 1; // 9:9   output inversion control for this pin
    uint32_t rsvd3 : 2;   // 11:10   Reserved
    uint32_t GPIO236 : 1; // 12:12   output inversion control for this pin
    uint32_t GPIO237 : 1; // 13:13   output inversion control for this pin
    uint32_t rsvd4 : 4;   // 17:14   Reserved
    uint32_t GPIO242 : 1; // 18:18   output inversion control for this pin
    uint32_t rsvd5 : 2;   // 20:19   Reserved
    uint32_t GPIO245 : 1; // 21:21   output inversion control for this pin
    uint32_t rsvd6 : 10;  // 31:22   Reserved
};

union GPHOUTINV_REG {
    uint32_t              all;
    struct GPHOUTINV_BITS bit;
};

//
// GPIO G LOOP Enable Registers (GPIO224)
//
struct GPHLOOPEN_BITS {   // bits   description
    uint32_t GPIO224 : 1; // 0:0   loopback enable for this pin
    uint32_t GPIO225 : 1; // 1:1   loopback enable for this pin
    uint32_t GPIO226 : 1; // 2:2   loopback enable for this pin
    uint32_t GPIO227 : 1; // 3:3   loopback enable for this pin
    uint32_t GPIO228 : 1; // 4:4   loopback enable for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   loopback enable for this pin
    uint32_t rsvd2 : 2;   // 8:7   Reserved
    uint32_t GPIO233 : 1; // 9:9   loopback enable for this pin
    uint32_t rsvd3 : 2;   // 11:10   Reserved
    uint32_t GPIO236 : 1; // 12:12   loopback enable for this pin
    uint32_t GPIO237 : 1; // 13:13   loopback enable for this pin
    uint32_t rsvd4 : 4;   // 17:14   Reserved
    uint32_t GPIO242 : 1; // 18:18   loopback enable for this pin
    uint32_t rsvd5 : 2;   // 20:19   Reserved
    uint32_t GPIO245 : 1; // 21:21   loopback enable for this pin
    uint32_t rsvd6 : 10;  // 31:22   Reserved
};

union GPHLOOPEN_REG {
    uint32_t              all;
    struct GPHLOOPEN_BITS bit;
};

//
// GPIO H  input Enable Registers (GPIO224 to 255)
//
struct GPHIE_BITS {       // bits   description
    uint32_t GPIO224 : 1; // 0:0   input enable for this pin
    uint32_t GPIO225 : 1; // 1:1   input enable for this pin
    uint32_t GPIO226 : 1; // 2:2   input enable for this pin
    uint32_t GPIO227 : 1; // 3:3   input enable for this pin
    uint32_t GPIO228 : 1; // 4:4   input enable for this pin
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   input enable for this pin
    uint32_t GPIO231 : 1; // 7:7   input enable for this pin
    uint32_t GPIO232 : 1; // 8:8   input enable for this pin
    uint32_t GPIO233 : 1; // 9:9   input enable for this pin
    uint32_t GPIO234 : 1; // 10:10   input enable for this pin
    uint32_t GPIO235 : 1; // 11:11   input enable for this pin
    uint32_t GPIO236 : 1; // 12:12   input enable for this pin
    uint32_t GPIO237 : 1; // 13:13   input enable for this pin
    uint32_t GPIO238 : 1; // 14:14   input enable for this pin
    uint32_t GPIO239 : 1; // 15:15   input enable for this pin
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   input enable for this pin
    uint32_t GPIO242 : 1; // 18:18   input enable for this pin
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   input enable for this pin
    uint32_t GPIO245 : 1; // 21:21   input enable for this pin
    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   input enable for this pin
    uint32_t rsvd6 : 7;   // 31:25   Reserved
};

union GPHIE_REG {
    uint32_t          all;
    struct GPHIE_BITS bit;
};

//
// GPIO H PI2C MODE Registers (GPIO224 to 255)
//
struct GPHPI2C_MODE_BITS { // bits   description
    uint32_t rsvd1 : 3;    // 2:0   Reserved
    uint32_t GPIO227 : 1;  // 3:3   I2C Mode Select for this pin
    uint32_t rsvd2 : 2;    // 5:4   Reserved
    uint32_t GPIO230 : 1;  // 6:6   I2C Mode Select for this pin
    uint32_t rsvd3 : 25;   // 31:7   Reserved
};

union GPHPI2C_MODE_REG {
    uint32_t                 all;
    struct GPHPI2C_MODE_BITS bit;
};

//
// GPIO A Data Register (GPIO0 to 31)
//
struct GPADAT_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO1 : 1;  // 1:1   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO2 : 1;  // 2:2   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO3 : 1;  // 3:3   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO4 : 1;  // 4:4   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO5 : 1;  // 5:5   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO6 : 1;  // 6:6   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO7 : 1;  // 7:7   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO8 : 1;  // 8:8   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO9 : 1;  // 9:9   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO10 : 1; // 10:10   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO11 : 1; // 11:11   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO12 : 1; // 12:12   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO13 : 1; // 13:13   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO14 : 1; // 14:14   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO15 : 1; // 15:15   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO16 : 1; // 16:16   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO17 : 1; // 17:17   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO18 : 1; // 18:18   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO19 : 1; // 19:19   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO20 : 1; // 20:20   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO21 : 1; // 21:21   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO22 : 1; // 22:22   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO23 : 1; // 23:23   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO24 : 1; // 24:24   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO25 : 1; // 25:25   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO26 : 1; // 26:26   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO27 : 1; // 27:27   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO28 : 1; // 28:28   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO29 : 1; // 29:29   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO30 : 1; // 30:30   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO31 : 1; // 31:31   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
};

union GPADAT_REG {
    uint32_t           all;
    struct GPADAT_BITS bit;
};

//
// GPIO A  Data Set Register (GPIO0 to 31)
//
struct GPASET_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO1 : 1;  // 1:1   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO2 : 1;  // 2:2   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO3 : 1;  // 3:3   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO4 : 1;  // 4:4   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO5 : 1;  // 5:5   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO6 : 1;  // 6:6   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO7 : 1;  // 7:7   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO8 : 1;  // 8:8   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO9 : 1;  // 9:9   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO10 : 1; // 10:10   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO11 : 1; // 11:11   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO12 : 1; // 12:12   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO13 : 1; // 13:13   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO14 : 1; // 14:14   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO15 : 1; // 15:15   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO16 : 1; // 16:16   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO17 : 1; // 17:17   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO18 : 1; // 18:18   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO19 : 1; // 19:19   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO20 : 1; // 20:20   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO21 : 1; // 21:21   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO22 : 1; // 22:22   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO23 : 1; // 23:23   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO24 : 1; // 24:24   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO25 : 1; // 25:25   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO26 : 1; // 26:26   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO27 : 1; // 27:27   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO28 : 1; // 28:28   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO29 : 1; // 29:29   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO30 : 1; // 30:30   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO31 : 1; // 31:31   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
};

union GPASET_REG {
    uint32_t           all;
    struct GPASET_BITS bit;
};

//
// GPIO A  Data Clear Register (GPIO0 to 31)
//
struct GPACLEAR_BITS {   // bits   description
    uint32_t GPIO0 : 1;  // 0:0   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO1 : 1;  // 1:1   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO2 : 1;  // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO3 : 1;  // 3:3   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO4 : 1;  // 4:4   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO5 : 1;  // 5:5   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO6 : 1;  // 6:6   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO7 : 1;  // 7:7   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO8 : 1;  // 8:8   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO9 : 1;  // 9:9   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO10 : 1; // 10:10   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO11 : 1; // 11:11   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO12 : 1; // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO13 : 1; // 13:13   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO14 : 1; // 14:14   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO15 : 1; // 15:15   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO16 : 1; // 16:16   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO17 : 1; // 17:17   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO18 : 1; // 18:18   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO19 : 1; // 19:19   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO20 : 1; // 20:20   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO21 : 1; // 21:21   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO22 : 1; // 22:22   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO23 : 1; // 23:23   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO24 : 1; // 24:24   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO25 : 1; // 25:25   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO26 : 1; // 26:26   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO27 : 1; // 27:27   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO28 : 1; // 28:28   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO29 : 1; // 29:29   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO30 : 1; // 30:30   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO31 : 1; // 31:31   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
};

union GPACLEAR_REG {
    uint32_t             all;
    struct GPACLEAR_BITS bit;
};

//
// GPIO A  Data Toggle Register (GPIO0 to 31)
//
struct GPATOGGLE_BITS {  // bits   description
    uint32_t GPIO0 : 1;  // 0:0   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO1 : 1;  // 1:1   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO2 : 1;  // 2:2   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO3 : 1;  // 3:3   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO4 : 1;  // 4:4   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO5 : 1;  // 5:5   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO6 : 1;  // 6:6   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO7 : 1;  // 7:7   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO8 : 1;  // 8:8   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO9 : 1;  // 9:9   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO10 : 1; // 10:10   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO11 : 1; // 11:11   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO12 : 1; // 12:12   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO13 : 1; // 13:13   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO14 : 1; // 14:14   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO15 : 1; // 15:15   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO16 : 1; // 16:16   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO17 : 1; // 17:17   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO18 : 1; // 18:18   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO19 : 1; // 19:19   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO20 : 1; // 20:20   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO21 : 1; // 21:21   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO22 : 1; // 22:22   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO23 : 1; // 23:23   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO24 : 1; // 24:24   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO25 : 1; // 25:25   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO26 : 1; // 26:26   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO27 : 1; // 27:27   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO28 : 1; // 28:28   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO29 : 1; // 29:29   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO30 : 1; // 30:30   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO31 : 1; // 31:31   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
};

union GPATOGGLE_REG {
    uint32_t              all;
    struct GPATOGGLE_BITS bit;
};

//
// GPIO B Data Register (GPIO32 to 63)
//
struct GPBDAT_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO33 : 1; // 1:1   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO34 : 1; // 2:2   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO35 : 1; // 3:3   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO40 : 1; // 8:8   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO41 : 1; // 9:9   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO42 : 1; // 10:10   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO43 : 1; // 11:11   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO44 : 1; // 12:12   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO45 : 1; // 13:13   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO46 : 1; // 14:14   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO49 : 1; // 17:17   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO54 : 1; // 22:22   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO55 : 1; // 23:23   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO56 : 1; // 24:24   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO57 : 1; // 25:25   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO58 : 1; // 26:26   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO59 : 1; // 27:27   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO60 : 1; // 28:28   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO61 : 1; // 29:29   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO62 : 1; // 30:30   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO63 : 1; // 31:31   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
};

union GPBDAT_REG {
    uint32_t           all;
    struct GPBDAT_BITS bit;
};

//
// GPIO B Data Set Register (GPIO32 to 63)
//
struct GPBSET_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO33 : 1; // 1:1   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO34 : 1; // 2:2   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO35 : 1; // 3:3   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO40 : 1; // 8:8   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO41 : 1; // 9:9   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO42 : 1; // 10:10   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO43 : 1; // 11:11   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO44 : 1; // 12:12   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO45 : 1; // 13:13   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO46 : 1; // 14:14   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO49 : 1; // 17:17   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO54 : 1; // 22:22   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO55 : 1; // 23:23   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO56 : 1; // 24:24   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO57 : 1; // 25:25   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO58 : 1; // 26:26   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO59 : 1; // 27:27   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO60 : 1; // 28:28   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO61 : 1; // 29:29   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO62 : 1; // 30:30   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO63 : 1; // 31:31   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
};

union GPBSET_REG {
    uint32_t           all;
    struct GPBSET_BITS bit;
};

//
// GPIO B Data Clear Register (GPIO32 to 63)
//
struct GPBCLEAR_BITS {   // bits   description
    uint32_t GPIO32 : 1; // 0:0   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO33 : 1; // 1:1   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO34 : 1; // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO35 : 1; // 3:3   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO40 : 1; // 8:8   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO41 : 1; // 9:9   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO42 : 1; // 10:10   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO43 : 1; // 11:11   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO44 : 1; // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO45 : 1; // 13:13   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO46 : 1; // 14:14   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO49 : 1; // 17:17   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO54 : 1; // 22:22   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO55 : 1; // 23:23   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO56 : 1; // 24:24   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO57 : 1; // 25:25   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO58 : 1; // 26:26   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO59 : 1; // 27:27   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO60 : 1; // 28:28   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO61 : 1; // 29:29   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO62 : 1; // 30:30   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO63 : 1; // 31:31   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
};

union GPBCLEAR_REG {
    uint32_t             all;
    struct GPBCLEAR_BITS bit;
};

//
// GPIO B  Data Toggle Register (GPIO0 to 31)
//
struct GPBTOGGLE_BITS {  // bits   description
    uint32_t GPIO32 : 1; // 0:0   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO33 : 1; // 1:1   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO34 : 1; // 2:2   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO35 : 1; // 3:3   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO40 : 1; // 8:8   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO41 : 1; // 9:9   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO42 : 1; // 10:10   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO43 : 1; // 11:11   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO44 : 1; // 12:12   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO45 : 1; // 13:13   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO46 : 1; // 14:14   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO49 : 1; // 17:17   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 3;  // 20:18   Reserved
    uint32_t GPIO53 : 1; // 21:21   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO54 : 1; // 22:22   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO55 : 1; // 23:23   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO56 : 1; // 24:24   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO57 : 1; // 25:25   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO58 : 1; // 26:26   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO59 : 1; // 27:27   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO60 : 1; // 28:28   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO61 : 1; // 29:29   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO62 : 1; // 30:30   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO63 : 1; // 31:31   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
};

union GPBTOGGLE_REG {
    uint32_t              all;
    struct GPBTOGGLE_BITS bit;
};

//
// GPG Data register (GPIO200)
//
struct GPGDAT_BITS {      // bits   description
    uint32_t GPIO200 : 1; // 0:0   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGDAT_REG {
    uint32_t           all;
    struct GPGDAT_BITS bit;
};

//
// GPG Data  Set register(GPIO200)
//
struct GPGSET_BITS {      // bits   description
    uint32_t GPIO200 : 1; // 0:0   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGSET_REG {
    uint32_t           all;
    struct GPGSET_BITS bit;
};

//
// GPG Data  Clear register(GPIO200)
//
struct GPGCLEAR_BITS {    // bits   description
    uint32_t GPIO200 : 1; // 0:0   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGCLEAR_REG {
    uint32_t             all;
    struct GPGCLEAR_BITS bit;
};

//
// GPG Data  Toggle register(GPIO200)
//
struct GPGTOGGLE_BITS {   // bits   description
    uint32_t GPIO200 : 1; // 0:0   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 31;  // 31:1   Reserved
};

union GPGTOGGLE_REG {
    uint32_t              all;
    struct GPGTOGGLE_BITS bit;
};

//
// GPH Data register (GPIO224 to 255)
//
struct GPHDAT_BITS {      // bits   description
    uint32_t GPIO224 : 1; // 0:0   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO225 : 1; // 1:1   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO226 : 1; // 2:2   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO227 : 1; // 3:3   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO228 : 1; // 4:4   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO231 : 1; // 7:7   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO232 : 1; // 8:8   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO233 : 1; // 9:9   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO234 : 1; // 10:10   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO235 : 1; // 11:11   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO236 : 1; // 12:12   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO237 : 1; // 13:13   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO238 : 1; // 14:14   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO239 : 1; // 15:15   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO242 : 1; // 18:18   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO245 : 1; // 21:21   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd4 : 2;   // 23:22   Reserved
    uint32_t GPIO248 : 1; // 24:24   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd5 : 7;   // 31:25   Reserved
};

union GPHDAT_REG {
    uint32_t           all;
    struct GPHDAT_BITS bit;
};

//
// GPH Data  Set register(GPIO224 to 255)
//
struct GPHSET_BITS {      // bits   description
    uint32_t GPIO224 : 1; // 0:0   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO225 : 1; // 1:1   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO226 : 1; // 2:2   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO227 : 1; // 3:3   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO228 : 1; // 4:4   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 2;   // 8:7   Reserved
    uint32_t GPIO233 : 1; // 9:9   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 2;   // 11:10   Reserved
    uint32_t GPIO236 : 1; // 12:12   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO237 : 1; // 13:13   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 4;   // 17:14   Reserved
    uint32_t GPIO242 : 1; // 18:18   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd5 : 2;   // 20:19   Reserved
    uint32_t GPIO245 : 1; // 21:21   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd6 : 10;  // 31:22   Reserved
};

union GPHSET_REG {
    uint32_t           all;
    struct GPHSET_BITS bit;
};

//
// GPH Data  Clear register(GPIO224 to 255)
//
struct GPHCLEAR_BITS {    // bits   description
    uint32_t GPIO224 : 1; // 0:0   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO225 : 1; // 1:1   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO226 : 1; // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO227 : 1; // 3:3   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO228 : 1; // 4:4   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 2;   // 8:7   Reserved
    uint32_t GPIO233 : 1; // 9:9   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 2;   // 11:10   Reserved
    uint32_t GPIO236 : 1; // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO237 : 1; // 13:13   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 4;   // 17:14   Reserved
    uint32_t GPIO242 : 1; // 18:18   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd5 : 2;   // 20:19   Reserved
    uint32_t GPIO245 : 1; // 21:21   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd6 : 10;  // 31:22   Reserved
};

union GPHCLEAR_REG {
    uint32_t             all;
    struct GPHCLEAR_BITS bit;
};

//
// GPH Data  Toggle register(GPIO224 to 255)
//
struct GPHTOGGLE_BITS {   // bits   description
    uint32_t GPIO224 : 1; // 0:0   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO225 : 1; // 1:1   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO226 : 1; // 2:2   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO227 : 1; // 3:3   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO228 : 1; // 4:4   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 2;   // 8:7   Reserved
    uint32_t GPIO233 : 1; // 9:9   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 2;   // 11:10   Reserved
    uint32_t GPIO236 : 1; // 12:12   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO237 : 1; // 13:13   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 4;   // 17:14   Reserved
    uint32_t GPIO242 : 1; // 18:18   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd5 : 2;   // 20:19   Reserved
    uint32_t GPIO245 : 1; // 21:21   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd6 : 10;  // 31:22   Reserved
};

union GPHTOGGLE_REG {
    uint32_t              all;
    struct GPHTOGGLE_BITS bit;
};

//
// GPG Data Read Register
//
struct GPGDAT_R_BITS {     // bits   description
    uint32_t GPGDAT_R : 1; // 0:0   returns the contents of GPADAT register on a read ; write means nothing
    uint32_t rsvd1 : 31;   // 31:1   Reserved
};

union GPGDAT_R_REG {
    uint32_t             all;
    struct GPGDAT_R_BITS bit;
};

//
// GPIO A  Interrrupt type (GPIO0 to 31)
//
struct GPA_INTTYPE_BITS { // bits   description
    uint32_t GPIO0 : 1;   // 0:0   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO1 : 1; // 1:1   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO2 : 1; // 2:2   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO3 : 1; // 3:3   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO4 : 1; // 4:4   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO5 : 1; // 5:5   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO6 : 1; // 6:6   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO7 : 1; // 7:7   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO8 : 1; // 8:8   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO9 : 1; // 9:9   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO10 : 1; // 10:10   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO11 : 1; // 11:11   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO12 : 1; // 12:12   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO13 : 1; // 13:13   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO14 : 1; // 14:14   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO15 : 1; // 15:15   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO16 : 1; // 16:16   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO17 : 1; // 17:17   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO18 : 1; // 18:18   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO19 : 1; // 19:19   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO20 : 1; // 20:20   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO21 : 1; // 21:21   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO22 : 1; // 22:22   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO23 : 1; // 23:23   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO24 : 1; // 24:24   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO25 : 1; // 25:25   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO26 : 1; // 26:26   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO27 : 1; // 27:27   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO28 : 1; // 28:28   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO29 : 1; // 29:29   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO30 : 1; // 30:30   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO31 : 1; // 31:31   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)
};

union GPA_INTTYPE_REG {
    uint32_t                all;
    struct GPA_INTTYPE_BITS bit;
};

//
// GPIO A  Interrrupt polarity (GPIO0 to 31)
//
struct GPA_INTPOL_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO1 : 1; // 1:1   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO2 : 1; // 2:2   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO3 : 1; // 3:3   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO4 : 1; // 4:4   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO5 : 1; // 5:5   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO6 : 1; // 6:6   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO7 : 1; // 7:7   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO8 : 1; // 8:8   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO9 : 1; // 9:9   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO10 : 1; // 10:10   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO11 : 1; // 11:11   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO12 : 1; // 12:12   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO13 : 1; // 13:13   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO14 : 1; // 14:14   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO15 : 1; // 15:15   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO16 : 1; // 16:16   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO17 : 1; // 17:17   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO18 : 1; // 18:18   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO19 : 1; // 19:19   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO20 : 1; // 20:20   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO21 : 1; // 21:21   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO22 : 1; // 22:22   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO23 : 1; // 23:23   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO24 : 1; // 24:24   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO25 : 1; // 25:25   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO26 : 1; // 26:26   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO27 : 1; // 27:27   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO28 : 1; // 28:28   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO29 : 1; // 29:29   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO30 : 1; // 30:30   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO31 : 1; // 31:31   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge
};

union GPA_INTPOL_REG {
    uint32_t               all;
    struct GPA_INTPOL_BITS bit;
};

//
// GPIO A  Interrrupt mask (GPIO0 to 31)
//
struct GPA_INTMASK_BITS { // bits   description
    uint32_t GPIO0 : 1;   // 0:0   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO1 : 1; // 1:1   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO2 : 1; // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO3 : 1; // 3:3   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO4 : 1; // 4:4   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO5 : 1; // 5:5   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO6 : 1; // 6:6   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO7 : 1; // 7:7   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO8 : 1; // 8:8   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO9 : 1; // 9:9   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO10 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO11 : 1; // 11:11   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO12 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO13 : 1; // 13:13   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO14 : 1; // 14:14   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO15 : 1; // 15:15   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO16 : 1; // 16:16   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO17 : 1; // 17:17   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO18 : 1; // 18:18   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO19 : 1; // 19:19   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO20 : 1; // 20:20   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO21 : 1; // 21:21   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO22 : 1; // 22:22   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO23 : 1; // 23:23   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO24 : 1; // 24:24   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO25 : 1; // 25:25   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO26 : 1; // 26:26   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO27 : 1; // 27:27   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO28 : 1; // 28:28   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO29 : 1; // 29:29   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO30 : 1; // 30:30   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO31 : 1; // 31:31   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int
};

union GPA_INTMASK_REG {
    uint32_t                all;
    struct GPA_INTMASK_BITS bit;
};

//
// GPIO A  Interrrupt clear (GPIO0 to 31)
//
struct GPA_INTCLR_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO1 : 1;  // 1:1   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO2 : 1;  // 2:2   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO3 : 1;  // 3:3   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO4 : 1;  // 4:4   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO5 : 1;  // 5:5   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO6 : 1;  // 6:6   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO7 : 1;  // 7:7   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO8 : 1;  // 8:8   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO9 : 1;  // 9:9   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO10 : 1; // 10:10   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO11 : 1; // 11:11   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO12 : 1; // 12:12   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO13 : 1; // 13:13   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO14 : 1; // 14:14   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO15 : 1; // 15:15   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO16 : 1; // 16:16   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO17 : 1; // 17:17   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO18 : 1; // 18:18   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO19 : 1; // 19:19   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO20 : 1; // 20:20   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO21 : 1; // 21:21   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO22 : 1; // 22:22   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO23 : 1; // 23:23   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO24 : 1; // 24:24   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO25 : 1; // 25:25   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO26 : 1; // 26:26   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO27 : 1; // 27:27   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO28 : 1; // 28:28   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO29 : 1; // 29:29   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO30 : 1; // 30:30   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO31 : 1; // 31:31   clear  interrupt of gpio  ;    1 : clear the int
};

union GPA_INTCLR_REG {
    uint32_t               all;
    struct GPA_INTCLR_BITS bit;
};

//
// GPIO A  raw Interrrupt  (GPIO0 to 31)
//
struct GPA_INTRAW_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO1 : 1;  // 1:1   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO2 : 1;  // 2:2   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO3 : 1;  // 3:3   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO4 : 1;  // 4:4   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO5 : 1;  // 5:5   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO6 : 1;  // 6:6   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO7 : 1;  // 7:7   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO8 : 1;  // 8:8   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO9 : 1;  // 9:9   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO10 : 1; // 10:10   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO11 : 1; // 11:11   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO12 : 1; // 12:12   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO13 : 1; // 13:13   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO14 : 1; // 14:14   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO15 : 1; // 15:15   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO16 : 1; // 16:16   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO17 : 1; // 17:17   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO18 : 1; // 18:18   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO19 : 1; // 19:19   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO20 : 1; // 20:20   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO21 : 1; // 21:21   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO22 : 1; // 22:22   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO23 : 1; // 23:23   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO24 : 1; // 24:24   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO25 : 1; // 25:25   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO26 : 1; // 26:26   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO27 : 1; // 27:27   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO28 : 1; // 28:28   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO29 : 1; // 29:29   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO30 : 1; // 30:30   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO31 : 1; // 31:31   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
};

union GPA_INTRAW_REG {
    uint32_t               all;
    struct GPA_INTRAW_BITS bit;
};

//
// GPIO A  Interrrupt states  (GPIO0 to 31)
//
struct GPA_INTSTATUS_BITS { // bits   description
    uint32_t GPIO0 : 1;     // 0:0   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO1 : 1;     // 1:1   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO2 : 1;     // 2:2   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO3 : 1;     // 3:3   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO4 : 1;     // 4:4   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO5 : 1;     // 5:5   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO6 : 1;     // 6:6   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO7 : 1;     // 7:7   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO8 : 1;     // 8:8   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO9 : 1;     // 9:9   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO10 : 1;    // 10:10   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO11 : 1;    // 11:11   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO12 : 1;    // 12:12   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO13 : 1;    // 13:13   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO14 : 1;    // 14:14   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO15 : 1;    // 15:15   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO16 : 1;    // 16:16   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO17 : 1;    // 17:17   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO18 : 1;    // 18:18   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO19 : 1;    // 19:19   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO20 : 1;    // 20:20   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO21 : 1;    // 21:21   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO22 : 1;    // 22:22   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO23 : 1;    // 23:23   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO24 : 1;    // 24:24   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO25 : 1;    // 25:25   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO26 : 1;    // 26:26   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO27 : 1;    // 27:27   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO28 : 1;    // 28:28   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO29 : 1;    // 29:29   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO30 : 1;    // 30:30   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO31 : 1;    // 31:31   status  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
};

union GPA_INTSTATUS_REG {
    uint32_t                  all;
    struct GPA_INTSTATUS_BITS bit;
};

//
// GPIO B  Interrrupt type (GPIO32 to 63)
//
struct GPB_INTTYPE_BITS { // bits   description
    uint32_t GPIO32 : 1;  // 0:0   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO33 : 1; // 1:1   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO34 : 1; // 2:2   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO35 : 1; // 3:3   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO40 : 1; // 8:8   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO41 : 1; // 9:9   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO42 : 1; // 10:10   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO43 : 1; // 11:11   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO44 : 1; // 12:12   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO45 : 1; // 13:13   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO46 : 1; // 14:14   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO49 : 1; // 17:17   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd4 : 1;  // 18:18   Reserved
    uint32_t rsvd5 : 1;  // 19:19   Reserved
    uint32_t rsvd6 : 1;  // 20:20   Reserved
    uint32_t GPIO53 : 1; // 21:21   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO54 : 1; // 22:22   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO55 : 1; // 23:23   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO56 : 1; // 24:24   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO57 : 1; // 25:25   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO58 : 1; // 26:26   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO59 : 1; // 27:27   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO60 : 1; // 28:28   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO61 : 1; // 29:29   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO62 : 1; // 30:30   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO63 : 1; // 31:31   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)
};

union GPB_INTTYPE_REG {
    uint32_t                all;
    struct GPB_INTTYPE_BITS bit;
};

//
// GPIO B  Interrrupt polarity (GPIO32 to 63)
//
struct GPB_INTPOL_BITS { // bits   description
    uint32_t GPIO32 : 1; // 0:0   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO33 : 1; // 1:1   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO34 : 1; // 2:2   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO35 : 1; // 3:3   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO40 : 1; // 8:8   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO41 : 1; // 9:9   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO42 : 1; // 10:10   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO43 : 1; // 11:11   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO44 : 1; // 12:12   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO45 : 1; // 13:13   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO46 : 1; // 14:14   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO49 : 1; // 17:17   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd4 : 1;  // 18:18   Reserved
    uint32_t rsvd5 : 1;  // 19:19   Reserved
    uint32_t rsvd6 : 1;  // 20:20   Reserved
    uint32_t GPIO53 : 1; // 21:21   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO54 : 1; // 22:22   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO55 : 1; // 23:23   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO56 : 1; // 24:24   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO57 : 1; // 25:25   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO58 : 1; // 26:26   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO59 : 1; // 27:27   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO60 : 1; // 28:28   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO61 : 1; // 29:29   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO62 : 1; // 30:30   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO63 : 1; // 31:31   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge
};

union GPB_INTPOL_REG {
    uint32_t               all;
    struct GPB_INTPOL_BITS bit;
};

//
// GPIO B  Interrrupt mask (GPIO32 to 63)
//
struct GPB_INTMASK_BITS { // bits   description
    uint32_t GPIO32 : 1;  // 0:0   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO33 : 1; // 1:1   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO34 : 1; // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO35 : 1; // 3:3   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO40 : 1; // 8:8   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO41 : 1; // 9:9   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO42 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO43 : 1; // 11:11   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO44 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO45 : 1; // 13:13   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO46 : 1; // 14:14   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO49 : 1; // 17:17   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd4 : 1;  // 18:18   Reserved
    uint32_t rsvd5 : 1;  // 19:19   Reserved
    uint32_t rsvd6 : 1;  // 20:20   Reserved
    uint32_t GPIO53 : 1; // 21:21   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO54 : 1; // 22:22   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO55 : 1; // 23:23   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO56 : 1; // 24:24   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO57 : 1; // 25:25   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO58 : 1; // 26:26   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO59 : 1; // 27:27   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO60 : 1; // 28:28   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO61 : 1; // 29:29   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO62 : 1; // 30:30   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO63 : 1; // 31:31   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int
};

union GPB_INTMASK_REG {
    uint32_t                all;
    struct GPB_INTMASK_BITS bit;
};

//
// GPIO B  Interrrupt clear (GPIO32 to 63)
//
struct GPB_INTCLR_BITS { // bits   description
    uint32_t GPIO32 : 1; // 0:0   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO33 : 1; // 1:1   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO34 : 1; // 2:2   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO35 : 1; // 3:3   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO40 : 1; // 8:8   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO41 : 1; // 9:9   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO42 : 1; // 10:10   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO43 : 1; // 11:11   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO44 : 1; // 12:12   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO45 : 1; // 13:13   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO46 : 1; // 14:14   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO49 : 1; // 17:17   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd4 : 1;  // 18:18   Reserved
    uint32_t rsvd5 : 1;  // 19:19   Reserved
    uint32_t rsvd6 : 1;  // 20:20   Reserved
    uint32_t GPIO53 : 1; // 21:21   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO54 : 1; // 22:22   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO55 : 1; // 23:23   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO56 : 1; // 24:24   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO57 : 1; // 25:25   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO58 : 1; // 26:26   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO59 : 1; // 27:27   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO60 : 1; // 28:28   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO61 : 1; // 29:29   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO62 : 1; // 30:30   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO63 : 1; // 31:31   clear  interrupt of gpio  ;    1 : clear the int
};

union GPB_INTCLR_REG {
    uint32_t               all;
    struct GPB_INTCLR_BITS bit;
};

//
// GPIO B  raw Interrrupt  (GPIO32 to 63)
//
struct GPB_INTRAW_BITS { // bits   description
    uint32_t GPIO32 : 1; // 0:0   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO33 : 1; // 1:1   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO34 : 1; // 2:2   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO35 : 1; // 3:3   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd1 : 1;  // 4:4   Reserved
    uint32_t GPIO37 : 1; // 5:5   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd2 : 1;  // 6:6   Reserved
    uint32_t GPIO39 : 1; // 7:7   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO40 : 1; // 8:8   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO41 : 1; // 9:9   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO42 : 1; // 10:10   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO43 : 1; // 11:11   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO44 : 1; // 12:12   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO45 : 1; // 13:13   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO46 : 1; // 14:14   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd3 : 1;  // 15:15   Reserved
    uint32_t GPIO48 : 1; // 16:16   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO49 : 1; // 17:17   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd4 : 1;  // 18:18   Reserved
    uint32_t rsvd5 : 1;  // 19:19   Reserved
    uint32_t rsvd6 : 1;  // 20:20   Reserved
    uint32_t GPIO53 : 1; // 21:21   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO54 : 1; // 22:22   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO55 : 1; // 23:23   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO56 : 1; // 24:24   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO57 : 1; // 25:25   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO58 : 1; // 26:26   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO59 : 1; // 27:27   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO60 : 1; // 28:28   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO61 : 1; // 29:29   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO62 : 1; // 30:30   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO63 : 1; // 31:31   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
};

union GPB_INTRAW_REG {
    uint32_t               all;
    struct GPB_INTRAW_BITS bit;
};

//
// GPIO B  Interrrupt states  (GPIO32 to 63)
//
struct GPB_INTSTATUS_BITS { // bits   description
    uint32_t GPIO32 : 1;    // 0:0   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO33 : 1;    // 1:1   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO34 : 1;    // 2:2   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO35 : 1;    // 3:3   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd1 : 1;     // 4:4   Reserved
    uint32_t GPIO37 : 1;    // 5:5   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd2 : 1;     // 6:6   Reserved
    uint32_t GPIO39 : 1;    // 7:7   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO40 : 1;    // 8:8   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO41 : 1;    // 9:9   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO42 : 1;    // 10:10   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO43 : 1;    // 11:11   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO44 : 1;    // 12:12   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO45 : 1;    // 13:13   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO46 : 1;    // 14:14   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd3 : 1;     // 15:15   Reserved
    uint32_t GPIO48 : 1;    // 16:16   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO49 : 1;    // 17:17   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd4 : 1;     // 18:18   Reserved
    uint32_t rsvd5 : 1;     // 19:19   Reserved
    uint32_t rsvd6 : 1;     // 20:20   Reserved
    uint32_t GPIO53 : 1;    // 21:21   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO54 : 1;    // 22:22   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO55 : 1;    // 23:23   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO56 : 1;    // 24:24   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO57 : 1;    // 25:25   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO58 : 1;    // 26:26   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO59 : 1;    // 27:27   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO60 : 1;    // 28:28   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO61 : 1;    // 29:29   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO62 : 1;    // 30:30   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO63 : 1;    // 31:31   status  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
};

union GPB_INTSTATUS_REG {
    uint32_t                  all;
    struct GPB_INTSTATUS_BITS bit;
};

//
// GPIO G  Interrrupt type (AGPIOx200)
//
struct GPG_INTTYPE_BITS {  // bits   description
    uint32_t AGPIO200 : 1; // 0:0   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd1 : 31; // 31:1   Reserved
};

union GPG_INTTYPE_REG {
    uint32_t                all;
    struct GPG_INTTYPE_BITS bit;
};

//
// GPIO G  Interrrupt polarity (AGPIO200)
//
struct GPG_INTPOL_BITS {   // bits   description
    uint32_t AGPIO200 : 1; // 0:0   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd1 : 31; // 31:1   Reserved
};

union GPG_INTPOL_REG {
    uint32_t               all;
    struct GPG_INTPOL_BITS bit;
};

//
// GPIO G  Interrrupt mask (AGPIO200)
//
struct GPG_INTMASK_BITS {  // bits   description
    uint32_t AGPIO200 : 1; // 0:0   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd1 : 31; // 31:1   Reserved
};

union GPG_INTMASK_REG {
    uint32_t                all;
    struct GPG_INTMASK_BITS bit;
};

//
// GPIO G  Interrrupt clear (AGPIO200)
//
struct GPG_INTCLR_BITS {   // bits   description
    uint32_t AGPIO200 : 1; // 0:0   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd1 : 31;   // 31:1   Reserved
};

union GPG_INTCLR_REG {
    uint32_t               all;
    struct GPG_INTCLR_BITS bit;
};

//
// GPIO G  raw Interrrupt  (AGPIO200)
//
struct GPG_INTRAW_BITS {   // bits   description
    uint32_t AGPIO200 : 1; // 0:0   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd1 : 31;   // 31:1   Reserved
};

union GPG_INTRAW_REG {
    uint32_t               all;
    struct GPG_INTRAW_BITS bit;
};

//
// GPIO G  Interrrupt states  (AGPIO200)
//
struct GPG_INTSTATUS_BITS { // bits   description
    uint32_t AGPIO200 : 1;  // 0:0   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd1 : 31;    // 31:1   Reserved
};

union GPG_INTSTATUS_REG {
    uint32_t                  all;
    struct GPG_INTSTATUS_BITS bit;
};

//
// GPIO H  Interrrupt type (AGPIO224 to 255)
//
struct GPH_INTTYPE_BITS { // bits   description
    uint32_t GPIO224 : 1; // 0:0   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO225 : 1; // 1:1   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO226 : 1; // 2:2   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO227 : 1; // 3:3   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO228 : 1; // 4:4   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO231 : 1; // 7:7   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO232 : 1; // 8:8   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO233 : 1; // 9:9   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO234 : 1; // 10:10   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO235 : 1; // 11:11   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO236 : 1; // 12:12   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO237 : 1; // 13:13   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO238 : 1; // 14:14   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO239 : 1; // 15:15   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO242 : 1; // 18:18   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO245 : 1; // 21:21   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd6 : 1;  // 25:25   Reserved
    uint32_t rsvd7 : 1;  // 26:26   Reserved
    uint32_t rsvd8 : 1;  // 27:27   Reserved
    uint32_t rsvd9 : 1;  // 28:28   Reserved
    uint32_t rsvd10 : 1; // 29:29   Reserved
    uint32_t rsvd11 : 1; // 30:30   Reserved
    uint32_t rsvd12 : 1; // 31:31   Reserved
};

union GPH_INTTYPE_REG {
    uint32_t                all;
    struct GPH_INTTYPE_BITS bit;
};

//
// GPIO H  Interrrupt polarity  (AGPIO224 to 255)
//
struct GPH_INTPOL_BITS {  // bits   description
    uint32_t GPIO224 : 1; // 0:0   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO225 : 1; // 1:1   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO226 : 1; // 2:2   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO227 : 1; // 3:3   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO228 : 1; // 4:4   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO231 : 1; // 7:7   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO232 : 1; // 8:8   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO233 : 1; // 9:9   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO234 : 1; // 10:10   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO235 : 1; // 11:11   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO236 : 1; // 12:12   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO237 : 1; // 13:13   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO238 : 1; // 14:14   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO239 : 1; // 15:15   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO242 : 1; // 18:18   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO245 : 1; // 21:21   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd6 : 1;  // 25:25   Reserved
    uint32_t rsvd7 : 1;  // 26:26   Reserved
    uint32_t rsvd8 : 1;  // 27:27   Reserved
    uint32_t rsvd9 : 1;  // 28:28   Reserved
    uint32_t rsvd10 : 1; // 29:29   Reserved
    uint32_t rsvd11 : 1; // 30:30   Reserved
    uint32_t rsvd12 : 1; // 31:31   Reserved
};

union GPH_INTPOL_REG {
    uint32_t               all;
    struct GPH_INTPOL_BITS bit;
};

//
// GPIO H  Interrrupt mask (AGPIO224 to 255)
//
struct GPH_INTMASK_BITS { // bits   description
    uint32_t GPIO224 : 1; // 0:0   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO225 : 1; // 1:1   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO226 : 1; // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO227 : 1; // 3:3   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO228 : 1; // 4:4   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO231 : 1; // 7:7   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO232 : 1; // 8:8   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO233 : 1; // 9:9   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO234 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO235 : 1; // 11:11   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO236 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO237 : 1; // 13:13   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO238 : 1; // 14:14   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO239 : 1; // 15:15   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO242 : 1; // 18:18   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO245 : 1; // 21:21   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd6 : 1;  // 25:25   Reserved
    uint32_t rsvd7 : 1;  // 26:26   Reserved
    uint32_t rsvd8 : 1;  // 27:27   Reserved
    uint32_t rsvd9 : 1;  // 28:28   Reserved
    uint32_t rsvd10 : 1; // 29:29   Reserved
    uint32_t rsvd11 : 1; // 30:30   Reserved
    uint32_t rsvd12 : 1; // 31:31   Reserved
};

union GPH_INTMASK_REG {
    uint32_t                all;
    struct GPH_INTMASK_BITS bit;
};

//
// GPIO H  Interrrupt clear (AGPIO224 to 255)
//
struct GPH_INTCLR_BITS {  // bits   description
    uint32_t GPIO224 : 1; // 0:0   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO225 : 1; // 1:1   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO226 : 1; // 2:2   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO227 : 1; // 3:3   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO228 : 1; // 4:4   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO231 : 1; // 7:7   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO232 : 1; // 8:8   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO233 : 1; // 9:9   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO234 : 1; // 10:10   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO235 : 1; // 11:11   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO236 : 1; // 12:12   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO237 : 1; // 13:13   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO238 : 1; // 14:14   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO239 : 1; // 15:15   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO242 : 1; // 18:18   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO245 : 1; // 21:21   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd6 : 1;   // 25:25   Reserved
    uint32_t rsvd7 : 1;   // 26:26   Reserved
    uint32_t rsvd8 : 1;   // 27:27   Reserved
    uint32_t rsvd9 : 1;   // 28:28   Reserved
    uint32_t rsvd10 : 1;  // 29:29   Reserved
    uint32_t rsvd11 : 1;  // 30:30   Reserved
    uint32_t rsvd12 : 1;  // 31:31   Reserved
};

union GPH_INTCLR_REG {
    uint32_t               all;
    struct GPH_INTCLR_BITS bit;
};

//
// GPIO H  raw Interrrupt  (AGPIO224 to 255)
//
struct GPH_INTRAW_BITS {  // bits   description
    uint32_t GPIO224 : 1; // 0:0   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO225 : 1; // 1:1   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO226 : 1; // 2:2   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO227 : 1; // 3:3   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO228 : 1; // 4:4   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd1 : 1;   // 5:5   Reserved
    uint32_t GPIO230 : 1; // 6:6   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO231 : 1; // 7:7   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO232 : 1; // 8:8   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO233 : 1; // 9:9   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO234 : 1; // 10:10   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO235 : 1; // 11:11   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO236 : 1; // 12:12   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO237 : 1; // 13:13   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO238 : 1; // 14:14   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO239 : 1; // 15:15   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd2 : 1;   // 16:16   Reserved
    uint32_t GPIO241 : 1; // 17:17   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO242 : 1; // 18:18   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd3 : 1;   // 19:19   Reserved
    uint32_t GPIO244 : 1; // 20:20   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO245 : 1; // 21:21   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd4 : 1;   // 22:22   Reserved
    uint32_t rsvd5 : 1;   // 23:23   Reserved
    uint32_t GPIO248 : 1; // 24:24   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd6 : 1;   // 25:25   Reserved
    uint32_t rsvd7 : 1;   // 26:26   Reserved
    uint32_t rsvd8 : 1;   // 27:27   Reserved
    uint32_t rsvd9 : 1;   // 28:28   Reserved
    uint32_t rsvd10 : 1;  // 29:29   Reserved
    uint32_t rsvd11 : 1;  // 30:30   Reserved
    uint32_t rsvd12 : 1;  // 31:31   Reserved
};

union GPH_INTRAW_REG {
    uint32_t               all;
    struct GPH_INTRAW_BITS bit;
};

//
// GPIO H  Interrrupt states  (AGPIO224 to 255)
//
struct GPH_INTSTATUS_BITS { // bits   description
    uint32_t GPIO224 : 1;   // 0:0   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO225 : 1;   // 1:1   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO226 : 1;   // 2:2   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO227 : 1;   // 3:3   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO228 : 1;   // 4:4   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd1 : 1;     // 5:5   Reserved
    uint32_t GPIO230 : 1;   // 6:6   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO231 : 1;   // 7:7   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO232 : 1;   // 8:8   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO233 : 1;   // 9:9   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO234 : 1;   // 10:10   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO235 : 1;   // 11:11   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO236 : 1;   // 12:12   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO237 : 1;   // 13:13   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO238 : 1;   // 14:14   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO239 : 1;   // 15:15   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd2 : 1;     // 16:16   Reserved
    uint32_t GPIO241 : 1;   // 17:17   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO242 : 1;   // 18:18   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd3 : 1;     // 19:19   Reserved
    uint32_t GPIO244 : 1;   // 20:20   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO245 : 1;   // 21:21   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd4 : 1;     // 22:22   Reserved
    uint32_t rsvd5 : 1;     // 23:23   Reserved
    uint32_t GPIO248 : 1;   // 24:24   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd6 : 1;     // 25:25   Reserved
    uint32_t rsvd7 : 1;     // 26:26   Reserved
    uint32_t rsvd8 : 1;     // 27:27   Reserved
    uint32_t rsvd9 : 1;     // 28:28   Reserved
    uint32_t rsvd10 : 1;    // 29:29   Reserved
    uint32_t rsvd11 : 1;    // 30:30   Reserved
    uint32_t rsvd12 : 1;    // 31:31   Reserved
};

union GPH_INTSTATUS_REG {
    uint32_t                  all;
    struct GPH_INTSTATUS_BITS bit;
};

//
// Reference clock mode configuration
// 4:0 POSCP_33_33_NT_DR Selection of reference clock
//
struct CLK_REF_PIN_CTRL_BITS { // bits   description
    uint32_t E0 : 1;           // Crystal enable pin.lt enables feedbback amplifier
    uint32_t TE : 1;           // test enable pin . it enables buffer for testing purpose
    uint32_t SF0 : 1;          // select frequency pin
    uint32_t SF1 : 1;          // select frequency pin
    uint32_t R_sel : 1;        // 0:500k starting resistance; 1: 100k starting resistance
    uint32_t rsvd1 : 27;       // 31:5   Reserved
};

union CLK_REF_PIN_CTRL_REG {
    uint32_t                     all;
    struct CLK_REF_PIN_CTRL_BITS bit;
};

//
// IO quantization register (GPIO_WAKE_UP)
//
struct LPMCR_QUALSTDBY_BITS { // bits   description
    uint32_t rsvd1 : 2;       // 1:0   Reserved
    uint32_t QUALSTDBY : 6;   // 7:2   select number of OSCCLK clock cycles to qualify the selected inputs  when waking the from STANDBY mode
    uint32_t rsvd2 : 24;      // 31:8   Reserved
};

union LPMCR_QUALSTDBY_REG {
    uint32_t                    all;
    struct LPMCR_QUALSTDBY_BITS bit;
};

//
// CLB - epwm exchange enable
//
struct CLB_HRPWM_EX_EN_BITS { // bits   description
    uint32_t EPWM1_A : 1;     // 0:0   epwm1_a /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM1_B : 1;     // 1:1   epwm1_b /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM2_A : 1;     // 2:2   epwm2_a /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM2_B : 1;     // 3:3   epwm2_b /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM3_A : 1;     // 4:4   epwm3_a /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM3_B : 1;     // 5:5   epwm3_b /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM4_A : 1;     // 6:6   epwm4_a /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t EPWM4_B : 1;     // 7:7   epwm4_b /clb exchannge :  0 : normol mode ; 1: exchange mode
    uint32_t rsvd1 : 24;      // 31:8   Reserved
};

union CLB_HRPWM_EX_EN_REG {
    uint32_t                    all;
    struct CLB_HRPWM_EX_EN_BITS bit;
};

// IO_CFG_PA Register Definitions:

struct IO_CFG_PARA_REGS {
    union GPACTRL_REG          GPACTRL;
    union GPAQSEL1_REG         GPAQSEL1;
    union GPAQSEL2_REG         GPAQSEL2;
    union GPAMUX1_REG          GPAMUX1;
    union GPAMUX2_REG          GPAMUX2;
    union GPADIR_REG           GPADIR;
    union GPAPUD_REG           GPAPUD;
    uint32_t                   rsvd1; // Reserved
    union GPAINV_REG           GPAINV;
    uint32_t                   rsvd2; // Reserved
    union GPAAMSEL_REG         GPAAMSEL;
    uint32_t                   rsvd3[5]; // Reserved
    union GPAGMUX1_REG         GPAGMUX1;
    union GPAGMUX2_REG         GPAGMUX2;
    uint32_t                   rsvd4[14]; // Reserved
    union GPBCTRL_REG          GPBCTRL;
    union GPBQSEL1_REG         GPBQSEL1;
    union GPBQSEL2_REG         GPBQSEL2;
    union GPBMUX1_REG          GPBMUX1;
    union GPBMUX2_REG          GPBMUX2;
    union GPBDIR_REG           GPBDIR;
    union GPBPUD_REG           GPBPUD;
    uint32_t                   rsvd5; // Reserved
    union GPBINV_REG           GPBINV;
    uint32_t                   rsvd6; // Reserved
    union GPBAMSEL_REG         GPBAMSEL;
    uint32_t                   rsvd7[5]; // Reserved
    union GPBGMUX1_REG         GPBGMUX1;
    union GPBGMUX2_REG         GPBGMUX2;
    uint32_t                   rsvd8[110]; // Reserved
    union GPGCTRL_REG          GPGCTRL;
    union GPGQSEL1_REG         GPGQSEL1;
    uint32_t                   rsvd9; // Reserved
    union GPGMUX1_REG          GPGMUX1;
    union GPGDIR_REG           GPGDIR;
    union GPGPUD_REG           GPGPUD;
    union GPGINV_REG           GPGINV;
    union GPGAMSEL_REG         GPGAMSEL;
    union GPGGMUX1_REG         GPGGMUX1;
    uint32_t                   rsvd10[55]; // Reserved
    union GPHCTRL_REG          GPHCTRL;
    union GPHQSEL1_REG         GPHQSEL1;
    union GPHQSEL2_REG         GPHQSEL2;
    union GPHMUX1_REG          GPHMUX1;
    union GPHMUX2_REG          GPHMUX2;
    union GPHDIR_REG           GPHDIR;
    union GPHPUD_REG           GPHPUD;
    uint32_t                   rsvd11; // Reserved
    union GPHINV_REG           GPHINV;
    uint32_t                   rsvd12; // Reserved
    union GPHAMSEL_REG         GPHAMSEL;
    uint32_t                   rsvd13[5]; // Reserved
    union GPHGMUX1_REG         GPHGMUX1;
    union GPHGMUX2_REG         GPHGMUX2;
    uint32_t                   rsvd14[14]; // Reserved
    union GPAPDD_REG           GPAPDD;
    union GPADS1_REG           GPADS1;
    union GPADS2_REG           GPADS2;
    union GPAIS_REG            GPAIS;
    union GPAOUTINV_REG        GPAOUTINV;
    union GPALOOPEN_REG        GPALOOPEN;
    union GPAPI2C_MODE_REG     GPAPI2C_MODE;
    uint32_t                   GPA_POUT_RPT;
    union GPBPDD_REG           GPBPDD;
    union GPBDS1_REG           GPBDS1;
    union GPBDS2_REG           GPBDS2;
    union GPBIS_REG            GPBIS;
    union GPBOUTINV_REG        GPBOUTINV;
    union GPBLOOPEN_REG        GPBLOOPEN;
    union GPBPI2C_MODE_REG     GPBPI2C_MODE;
    uint32_t                   GPB_POUT_RPT;
    uint32_t                   rsvd15[32]; // Reserved
    union GPGPDD_REG           GPGPDD;
    union GPGDS1_REG           GPGDS1;
    union GPGIS_REG            GPGIS;
    union GPGOUTINV_REG        GPGOUTINV;
    union GPGLOOPEN_REG        GPGLOOPEN;
    uint32_t                   GPG_POUT_RPT;
    uint32_t                   rsvd16[2]; // Reserved
    union GPHPDD_REG           GPHPDD;
    union GPHDS1_REG           GPHDS1;
    union GPHDS2_REG           GPHDS2;
    union GPHIS_REG            GPHIS;
    union GPHOUTINV_REG        GPHOUTINV;
    union GPHLOOPEN_REG        GPHLOOPEN;
    union GPHIE_REG            GPHIE;
    union GPHPI2C_MODE_REG     GPHPI2C_MODE;
    uint32_t                   GPH_POUT_RPT;
    uint32_t                   rsvd17[63]; // Reserved
    union GPADAT_REG           GPADAT;
    union GPASET_REG           GPASET;
    union GPACLEAR_REG         GPACLEAR;
    union GPATOGGLE_REG        GPATOGGLE;
    union GPBDAT_REG           GPBDAT;
    union GPBSET_REG           GPBSET;
    union GPBCLEAR_REG         GPBCLEAR;
    union GPBTOGGLE_REG        GPBTOGGLE;
    uint32_t                   rsvd18[16]; // Reserved
    union GPGDAT_REG           GPGDAT;
    union GPGSET_REG           GPGSET;
    union GPGCLEAR_REG         GPGCLEAR;
    union GPGTOGGLE_REG        GPGTOGGLE;
    union GPHDAT_REG           GPHDAT;
    union GPHSET_REG           GPHSET;
    union GPHCLEAR_REG         GPHCLEAR;
    union GPHTOGGLE_REG        GPHTOGGLE;
    uint32_t                   rsvd19[32]; // Reserved
    uint32_t                   GPADAT_R;
    uint32_t                   GPBDAT_R;
    uint32_t                   rsvd20[4]; // Reserved
    union GPGDAT_R_REG         GPGDAT_R;
    uint32_t                   GPHDAT_R;
    uint32_t                   rsvd21[120]; // Reserved
    union GPA_INTTYPE_REG      GPA_INTTYPE;
    union GPA_INTPOL_REG       GPA_INTPOL;
    union GPA_INTMASK_REG      GPA_INTMASK;
    union GPA_INTCLR_REG       GPA_INTCLR;
    union GPA_INTRAW_REG       GPA_INTRAW;
    union GPA_INTSTATUS_REG    GPA_INTSTATUS;
    union GPB_INTTYPE_REG      GPB_INTTYPE;
    union GPB_INTPOL_REG       GPB_INTPOL;
    union GPB_INTMASK_REG      GPB_INTMASK;
    union GPB_INTCLR_REG       GPB_INTCLR;
    union GPB_INTRAW_REG       GPB_INTRAW;
    union GPB_INTSTATUS_REG    GPB_INTSTATUS;
    uint32_t                   rsvd22[24]; // Reserved
    union GPG_INTTYPE_REG      GPG_INTTYPE;
    union GPG_INTPOL_REG       GPG_INTPOL;
    union GPG_INTMASK_REG      GPG_INTMASK;
    union GPG_INTCLR_REG       GPG_INTCLR;
    union GPG_INTRAW_REG       GPG_INTRAW;
    union GPG_INTSTATUS_REG    GPG_INTSTATUS;
    union GPH_INTTYPE_REG      GPH_INTTYPE;
    union GPH_INTPOL_REG       GPH_INTPOL;
    union GPH_INTMASK_REG      GPH_INTMASK;
    union GPH_INTCLR_REG       GPH_INTCLR;
    union GPH_INTRAW_REG       GPH_INTRAW;
    union GPH_INTSTATUS_REG    GPH_INTSTATUS;
    uint32_t                   rsvd23[336]; // Reserved
    union CLK_REF_PIN_CTRL_REG CLK_REF_PIN_CTRL;
    uint32_t                   rsvd24[19]; // Reserved
    union LPMCR_QUALSTDBY_REG  LPMCR_QUALSTDBY;
    uint32_t                   IO_SET_STBY;
    uint32_t                   GPIOLPMSEL0;
    uint32_t                   GPIOLPMSEL1;
    union CLB_HRPWM_EX_EN_REG  CLB_HRPWM_EX_EN;
    uint32_t                   rsvd25[38]; // Reserved
    uint32_t                   IO_CFG_LOCK;
};


struct GPIO_CTRL_REGS {
    union GPACTRL_REG          GPACTRL;
    union GPAQSEL1_REG         GPAQSEL1;
    union GPAQSEL2_REG         GPAQSEL2;
    union GPAMUX1_REG          GPAMUX1;
    union GPAMUX2_REG          GPAMUX2;
    union GPADIR_REG           GPADIR;
    union GPAPUD_REG           GPAPUD;
    uint32_t                   rsvd1; // Reserved
    union GPAINV_REG           GPAINV;
    uint32_t                   rsvd2; // Reserved
    union GPAAMSEL_REG         GPAAMSEL;
    uint32_t                   rsvd3[5]; // Reserved
    union GPAGMUX1_REG         GPAGMUX1;
    union GPAGMUX2_REG         GPAGMUX2;
    uint32_t                   rsvd4[14]; // Reserved
    union GPBCTRL_REG          GPBCTRL;
    union GPBQSEL1_REG         GPBQSEL1;
    union GPBQSEL2_REG         GPBQSEL2;
    union GPBMUX1_REG          GPBMUX1;
    union GPBMUX2_REG          GPBMUX2;
    union GPBDIR_REG           GPBDIR;
    union GPBPUD_REG           GPBPUD;
    uint32_t                   rsvd5; // Reserved
    union GPBINV_REG           GPBINV;
    uint32_t                   rsvd6; // Reserved
    union GPBAMSEL_REG         GPBAMSEL;
    uint32_t                   rsvd7[5]; // Reserved
    union GPBGMUX1_REG         GPBGMUX1;
    union GPBGMUX2_REG         GPBGMUX2;
    uint32_t                   rsvd8[110]; // Reserved
    union GPGCTRL_REG          GPGCTRL;
    union GPGQSEL1_REG         GPGQSEL1;
    uint32_t                   rsvd9; // Reserved
    union GPGMUX1_REG          GPGMUX1;
    union GPGDIR_REG           GPGDIR;
    union GPGPUD_REG           GPGPUD;
    union GPGINV_REG           GPGINV;
    union GPGAMSEL_REG         GPGAMSEL;
    union GPGGMUX1_REG         GPGGMUX1;
    uint32_t                   rsvd10[55]; // Reserved
    union GPHCTRL_REG          GPHCTRL;
    union GPHQSEL1_REG         GPHQSEL1;
    union GPHQSEL2_REG         GPHQSEL2;
    union GPHMUX1_REG          GPHMUX1;
    union GPHMUX2_REG          GPHMUX2;
    union GPHDIR_REG           GPHDIR;
    union GPHPUD_REG           GPHPUD;
    uint32_t                   rsvd11; // Reserved
    union GPHINV_REG           GPHINV;
    uint32_t                   rsvd12; // Reserved
    union GPHAMSEL_REG         GPHAMSEL;
    uint32_t                   rsvd13[5]; // Reserved
    union GPHGMUX1_REG         GPHGMUX1;
    union GPHGMUX2_REG         GPHGMUX2;
    uint32_t                   rsvd14[14]; // Reserved
    union GPAPDD_REG           GPAPDD;
    union GPADS1_REG           GPADS1;
    union GPADS2_REG           GPADS2;
    union GPAIS_REG            GPAIS;
    union GPAOUTINV_REG        GPAOUTINV;
    union GPALOOPEN_REG        GPALOOPEN;
    union GPAPI2C_MODE_REG     GPAPI2C_MODE;
    uint32_t                   GPA_POUT_RPT;
    union GPBPDD_REG           GPBPDD;
    union GPBDS1_REG           GPBDS1;
    union GPBDS2_REG           GPBDS2;
    union GPBIS_REG            GPBIS;
    union GPBOUTINV_REG        GPBOUTINV;
    union GPBLOOPEN_REG        GPBLOOPEN;
    union GPBPI2C_MODE_REG     GPBPI2C_MODE;
    uint32_t                   GPB_POUT_RPT;
    uint32_t                   rsvd15[32]; // Reserved
    union GPGPDD_REG           GPGPDD;
    union GPGDS1_REG           GPGDS1;
    union GPGIS_REG            GPGIS;
    union GPGOUTINV_REG        GPGOUTINV;
    union GPGLOOPEN_REG        GPGLOOPEN;
    uint32_t                   GPG_POUT_RPT;
    uint32_t                   rsvd16[2]; // Reserved
    union GPHPDD_REG           GPHPDD;
    union GPHDS1_REG           GPHDS1;
    union GPHDS2_REG           GPHDS2;
    union GPHIS_REG            GPHIS;
    union GPHOUTINV_REG        GPHOUTINV;
    union GPHLOOPEN_REG        GPHLOOPEN;
    union GPHIE_REG            GPHIE;
    union GPHPI2C_MODE_REG     GPHPI2C_MODE;
    uint32_t                   GPH_POUT_RPT;
    
    uint32_t                   rsvd17[639]; // Reserved
    union CLK_REF_PIN_CTRL_REG CLK_REF_PIN_CTRL;
    uint32_t                   rsvd18[19]; // Reserved
    union LPMCR_QUALSTDBY_REG  LPMCR_QUALSTDBY;
    uint32_t                   IO_SET_STBY;
    uint32_t                   GPIOLPMSEL0;
    uint32_t                   GPIOLPMSEL1;
    union CLB_HRPWM_EX_EN_REG  CLB_HRPWM_EX_EN;
    uint32_t                   rsvd19[38]; // Reserved
    uint32_t                   IO_CFG_LOCK;
};

struct GPIO_DATA_REGS {
    union GPADAT_REG           GPADAT;
    union GPASET_REG           GPASET;
    union GPACLEAR_REG         GPACLEAR;
    union GPATOGGLE_REG        GPATOGGLE;
    union GPBDAT_REG           GPBDAT;
    union GPBSET_REG           GPBSET;
    union GPBCLEAR_REG         GPBCLEAR;
    union GPBTOGGLE_REG        GPBTOGGLE;
    uint32_t                   rsvd20[16]; // Reserved
    union GPGDAT_REG           GPGDAT;
    union GPGSET_REG           GPGSET;
    union GPGCLEAR_REG         GPGCLEAR;
    union GPGTOGGLE_REG        GPGTOGGLE;
    union GPHDAT_REG           GPHDAT;
    union GPHSET_REG           GPHSET;
    union GPHCLEAR_REG         GPHCLEAR;
    union GPHTOGGLE_REG        GPHTOGGLE;
};

struct GPIO_DATA_READ_REGS {
    uint32_t                   GPADAT_R;
    uint32_t                   GPBDAT_R;
    uint32_t                   rsvd21[4]; // Reserved
    union GPGDAT_R_REG         GPGDAT_R;
    uint32_t                   GPHDAT_R;
};


struct GPIO_INT_REGS {
    union GPA_INTTYPE_REG      GPA_INTTYPE;
    union GPA_INTPOL_REG       GPA_INTPOL;
    union GPA_INTMASK_REG      GPA_INTMASK;
    union GPA_INTCLR_REG       GPA_INTCLR;
    union GPA_INTRAW_REG       GPA_INTRAW;
    union GPA_INTSTATUS_REG    GPA_INTSTATUS;
    union GPB_INTTYPE_REG      GPB_INTTYPE;
    union GPB_INTPOL_REG       GPB_INTPOL;
    union GPB_INTMASK_REG      GPB_INTMASK;
    union GPB_INTCLR_REG       GPB_INTCLR;
    union GPB_INTRAW_REG       GPB_INTRAW;
    union GPB_INTSTATUS_REG    GPB_INTSTATUS;
    uint32_t                   rsvd22[24]; // Reserved
    union GPG_INTTYPE_REG      GPG_INTTYPE;
    union GPG_INTPOL_REG       GPG_INTPOL;
    union GPG_INTMASK_REG      GPG_INTMASK;
    union GPG_INTCLR_REG       GPG_INTCLR;
    union GPG_INTRAW_REG       GPG_INTRAW;
    union GPG_INTSTATUS_REG    GPG_INTSTATUS;
    union GPH_INTTYPE_REG      GPH_INTTYPE;
    union GPH_INTPOL_REG       GPH_INTPOL;
    union GPH_INTMASK_REG      GPH_INTMASK;
    union GPH_INTCLR_REG       GPH_INTCLR;
    union GPH_INTRAW_REG       GPH_INTRAW;
    union GPH_INTSTATUS_REG    GPH_INTSTATUS;

};

#else

//
// GPIO A Qualification Sampling Period Control
//
struct GPACTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for GPIO0 to GPIO7:

    uint32_t QUALPRD1 : 8; // 15:8   Qualification sampling period for GPIO8 to GPIO15:

    uint32_t QUALPRD2 : 8; // 23:16   Qualification sampling period for GPIO16 to GPIO23:

    uint32_t QUALPRD3 : 8; // 31:24   Qualification sampling period for GPIO24 to GPIO31:
};

union GPACTRL_REG {
    Uint32              all;
    // struct GPACTRL_BITS bit;
};

//
// GPIO A Qualifier Select 1 Register (GPIO0 to 15)
//
struct GPAQSEL1_BITS {  // bits   description
    uint32_t GPIO0 : 2; // 1:0   Select input qualification type for GPIO0:

    uint32_t GPIO1 : 2; // 3:2   Select input qualification type for GPIO1:

    uint32_t GPIO2 : 2; // 5:4   Select input qualification type for GPIO2:

    uint32_t GPIO3 : 2; // 7:6   Select input qualification type for GPIO3:

    uint32_t GPIO4 : 2; // 9:8   Select input qualification type for GPIO4:

    uint32_t GPIO5 : 2; // 11:10   Select input qualification type for GPIO5:

    uint32_t GPIO6 : 2; // 13:12   Select input qualification type for GPIO6:

    uint32_t GPIO7 : 2; // 15:14   Select input qualification type for GPIO7:

    uint32_t GPIO8 : 2; // 17:16   Select input qualification type for GPIO8:

    uint32_t GPIO9 : 2; // 19:18   Select input qualification type for GPIO9:

    uint32_t GPIO10 : 2; // 21:20   Select input qualification type for GPIO10:

    uint32_t GPIO11 : 2; // 23:22   Select input qualification type for GPIO11:

    uint32_t GPIO12 : 2; // 25:24   Select input qualification type for GPIO12:

    uint32_t GPIO13 : 2; // 27:26   Select input qualification type for GPIO13:

    uint32_t GPIO14 : 2; // 29:28   Select input qualification type for GPIO14:

    uint32_t GPIO15 : 2; // 31:30   Select input qualification type for GPIO15:
};

union GPAQSEL1_REG {
    uint32_t             all;
    struct GPAQSEL1_BITS bit;
};

//
// GPIO A Qualifier Select 2 Register (GPIO16 to 31)
//
struct GPAQSEL2_BITS {   // bits   description
    uint32_t GPIO16 : 2; // 1:0   Select input qualification type for GPIO16:

    uint32_t GPIO17 : 2; // 3:2   Select input qualification type for GPIO17:

    uint32_t GPIO18 : 2; // 5:4   Select input qualification type for GPIO18:

    uint32_t GPIO19 : 2; // 7:6   Select input qualification type for GPIO19:

    uint32_t GPIO20 : 2; // 9:8   Select input qualification type for GPIO20:

    uint32_t GPIO21 : 2; // 11:10   Select input qualification type for GPIO21:

    uint32_t GPIO22 : 2; // 13:12   Select input qualification type for GPIO22:

    uint32_t GPIO23 : 2; // 15:14   Select input qualification type for GPIO23:

    uint32_t GPIO24 : 2; // 17:16   Select input qualification type for GPIO24:

    uint32_t GPIO25 : 2; // 19:18   Select input qualification type for GPIO25:

    uint32_t GPIO26 : 2; // 21:20   Select input qualification type for GPIO26:

    uint32_t GPIO27 : 2; // 23:22   Select input qualification type for GPIO27:

    uint32_t GPIO28 : 2; // 25:24   Select input qualification type for GPIO28:

    uint32_t GPIO29 : 2; // 27:26   Select input qualification type for GPIO29:

    uint32_t GPIO30 : 2; // 29:28   Select input qualification type for GPIO30:

    uint32_t GPIO31 : 2; // 31:30   Select input qualification type for GPIO31:
};

union GPAQSEL2_REG {
    uint32_t             all;
    struct GPAQSEL2_BITS bit;
};

//
// GPIO A Mux 1 Register (GPIO0 to 15)
//
struct GPAMUX1_BITS {    // bits   description
    uint32_t GPIO0 : 2;  // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO1 : 2;  // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO2 : 2;  // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO3 : 2;  // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO4 : 2;  // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO5 : 2;  // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO6 : 2;  // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO7 : 2;  // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO8 : 2;  // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO9 : 2;  // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO10 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO11 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO12 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO13 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO14 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO15 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPAMUX1_REG {
    uint32_t            all;
    struct GPAMUX1_BITS bit;
};

//
// GPIO A Mux 2 Register (GPIO16 to 31)
//
struct GPAMUX2_BITS {    // bits   description
    uint32_t GPIO16 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO17 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO18 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO19 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO20 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO21 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO22 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO23 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO24 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO25 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO26 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO27 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO28 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO29 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t GPIO30 : 2; // 29:28   Defines pin-muxing selection for GPIO
    uint32_t GPIO31 : 2; // 31:30   Defines pin-muxing selection for GPIO
};

union GPAMUX2_REG {
    uint32_t            all;
    struct GPAMUX2_BITS bit;
};

//
// GPIO A Direction Register (GPIO0 to 31)
//
struct GPADIR_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO1 : 1;  // 1:1   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO2 : 1;  // 2:2   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO3 : 1;  // 3:3   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO4 : 1;  // 4:4   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO5 : 1;  // 5:5   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO6 : 1;  // 6:6   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO7 : 1;  // 7:7   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO8 : 1;  // 8:8   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO9 : 1;  // 9:9   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO10 : 1; // 10:10   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO11 : 1; // 11:11   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO12 : 1; // 12:12   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO13 : 1; // 13:13   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO14 : 1; // 14:14   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO15 : 1; // 15:15   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO16 : 1; // 16:16   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO17 : 1; // 17:17   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO18 : 1; // 18:18   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO19 : 1; // 19:19   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO20 : 1; // 20:20   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO21 : 1; // 21:21   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO22 : 1; // 22:22   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO23 : 1; // 23:23   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO24 : 1; // 24:24   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO25 : 1; // 25:25   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO26 : 1; // 26:26   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO27 : 1; // 27:27   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO28 : 1; // 28:28   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO29 : 1; // 29:29   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO30 : 1; // 30:30   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO31 : 1; // 31:31   Defines pin-muxing selection for GPIO
};

union GPADIR_REG {
    uint32_t           all;
    struct GPADIR_BITS bit;
};

//
// GPIO A Pull Up Disable Register (GPIO0 to 31)
//
struct GPAPUD_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   Pull-Up Disable control for this pin
    uint32_t GPIO1 : 1;  // 1:1   Pull-Up Disable control for this pin
    uint32_t GPIO2 : 1;  // 2:2   Pull-Up Disable control for this pin
    uint32_t GPIO3 : 1;  // 3:3   Pull-Up Disable control for this pin
    uint32_t GPIO4 : 1;  // 4:4   Pull-Up Disable control for this pin
    uint32_t GPIO5 : 1;  // 5:5   Pull-Up Disable control for this pin
    uint32_t GPIO6 : 1;  // 6:6   Pull-Up Disable control for this pin
    uint32_t GPIO7 : 1;  // 7:7   Pull-Up Disable control for this pin
    uint32_t GPIO8 : 1;  // 8:8   Pull-Up Disable control for this pin
    uint32_t GPIO9 : 1;  // 9:9   Pull-Up Disable control for this pin
    uint32_t GPIO10 : 1; // 10:10   Pull-Up Disable control for this pin
    uint32_t GPIO11 : 1; // 11:11   Pull-Up Disable control for this pin
    uint32_t GPIO12 : 1; // 12:12   Pull-Up Disable control for this pin
    uint32_t GPIO13 : 1; // 13:13   Pull-Up Disable control for this pin
    uint32_t GPIO14 : 1; // 14:14   Pull-Up Disable control for this pin
    uint32_t GPIO15 : 1; // 15:15   Pull-Up Disable control for this pin
    uint32_t GPIO16 : 1; // 16:16   Pull-Up Disable control for this pin
    uint32_t GPIO17 : 1; // 17:17   Pull-Up Disable control for this pin
    uint32_t GPIO18 : 1; // 18:18   Pull-Up Disable control for this pin
    uint32_t GPIO19 : 1; // 19:19   Pull-Up Disable control for this pin
    uint32_t GPIO20 : 1; // 20:20   Pull-Up Disable control for this pin
    uint32_t GPIO21 : 1; // 21:21   Pull-Up Disable control for this pin
    uint32_t GPIO22 : 1; // 22:22   Pull-Up Disable control for this pin
    uint32_t GPIO23 : 1; // 23:23   Pull-Up Disable control for this pin
    uint32_t GPIO24 : 1; // 24:24   Pull-Up Disable control for this pin
    uint32_t GPIO25 : 1; // 25:25   Pull-Up Disable control for this pin
    uint32_t GPIO26 : 1; // 26:26   Pull-Up Disable control for this pin
    uint32_t GPIO27 : 1; // 27:27   Pull-Up Disable control for this pin
    uint32_t GPIO28 : 1; // 28:28   Pull-Up Disable control for this pin
    uint32_t GPIO29 : 1; // 29:29   Pull-Up Disable control for this pin
    uint32_t GPIO30 : 1; // 30:30   Pull-Up Disable control for this pin
    uint32_t GPIO31 : 1; // 31:31   Pull-Up Disable control for this pin
};

union GPAPUD_REG {
    uint32_t           all;
    struct GPAPUD_BITS bit;
};

//
// GPIO B Qualification Sampling Period Control (GPIO32 to 63)
//
struct GPBCTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for GPIO32 to GPIO39:
    uint32_t QUALPRD1 : 8; // 15:8   Qualification sampling period for GPIO40 to GPIO47:
    uint32_t rsvd1 : 16;   // 31:16   Reserved
};

union GPBCTRL_REG {
    uint32_t            all;
    // struct GPBCTRL_BITS bit;
};

//
// GPIO B Qualifier Select 1 Register (GPIO32 to 47)
//
struct GPBQSEL1_BITS {   // bits   description
    uint32_t GPIO32 : 2; // 1:0   Select input qualification type for GPIO32:

    uint32_t GPIO33 : 2; // 3:2   Select input qualification type for GPIO33:

    uint32_t GPIO34 : 2; // 5:4   Select input qualification type for GPIO34:

    uint32_t GPIO35 : 2; // 7:6   Select input qualification type for GPIO35:

    uint32_t GPIO36 : 2; // 9:8   Select input qualification type for GPIO36:

    uint32_t GPIO37 : 2; // 11:10   Select input qualification type for GPIO37:

    uint32_t GPIO38 : 2; // 13:12   Select input qualification type for GPIO38:

    uint32_t GPIO39 : 2; // 15:14   Select input qualification type for GPIO39:

    uint32_t GPIO40 : 2; // 17:16   Select input qualification type for GPIO40:

    uint32_t GPIO41 : 2; // 19:18   Select input qualification type for GPIO41:

    uint32_t GPIO42 : 2; // 21:20   Select input qualification type for GPIO42:

    uint32_t GPIO43 : 2; // 23:22   Select input qualification type for GPIO43:

    uint32_t GPIO44 : 2; // 25:24   Select input qualification type for GPIO44:
    uint32_t GPIO45 : 2; // 27:26   Select input qualification type for GPIO45:
    uint32_t rsvd1 : 4;  // 31:28   Reserved
};

union GPBQSEL1_REG {
    uint32_t             all;
    struct GPBQSEL1_BITS bit;
};

//
// GPIO B Mux 1 Register (GPIO32 to 47)
//
struct GPBMUX1_BITS {    // bits   description
    uint32_t GPIO32 : 2; // 1:0   Defines pin-muxing selection for GPIO
    uint32_t GPIO33 : 2; // 3:2   Defines pin-muxing selection for GPIO
    uint32_t GPIO34 : 2; // 5:4   Defines pin-muxing selection for GPIO
    uint32_t GPIO35 : 2; // 7:6   Defines pin-muxing selection for GPIO
    uint32_t GPIO36 : 2; // 9:8   Defines pin-muxing selection for GPIO
    uint32_t GPIO37 : 2; // 11:10   Defines pin-muxing selection for GPIO
    uint32_t GPIO38 : 2; // 13:12   Defines pin-muxing selection for GPIO
    uint32_t GPIO39 : 2; // 15:14   Defines pin-muxing selection for GPIO
    uint32_t GPIO40 : 2; // 17:16   Defines pin-muxing selection for GPIO
    uint32_t GPIO41 : 2; // 19:18   Defines pin-muxing selection for GPIO
    uint32_t GPIO42 : 2; // 21:20   Defines pin-muxing selection for GPIO
    uint32_t GPIO43 : 2; // 23:22   Defines pin-muxing selection for GPIO
    uint32_t GPIO44 : 2; // 25:24   Defines pin-muxing selection for GPIO
    uint32_t GPIO45 : 2; // 27:26   Defines pin-muxing selection for GPIO
    uint32_t rsvd1 : 4;  // 31:28   Reserved
};

union GPBMUX1_REG {
    uint32_t            all;
    struct GPBMUX1_BITS bit;
};

//
// GPIO B Direction Register (GPIO32 to 63)
//
struct GPBDIR_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO33 : 1; // 1:1   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO34 : 1; // 2:2   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO35 : 1; // 3:3   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO36 : 1; // 4:4   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO37 : 1; // 5:5   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO38 : 1; // 6:6   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO39 : 1; // 7:7   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO40 : 1; // 8:8   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO41 : 1; // 9:9   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO42 : 1; // 10:10   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO43 : 1; // 11:11   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO44 : 1; // 12:12   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t GPIO45 : 1; // 13:13   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd1 : 18; // 31:14   Reserved
};

union GPBDIR_REG {
    uint32_t           all;
    struct GPBDIR_BITS bit;
};

//
// GPIO B Pull Up Disable Register (GPIO32 to 63)
//
struct GPBPUD_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   Pull-Up Disable control for this pin
    uint32_t GPIO33 : 1; // 1:1   Pull-Up Disable control for this pin
    uint32_t GPIO34 : 1; // 2:2   Pull-Up Disable control for this pin
    uint32_t GPIO35 : 1; // 3:3   Pull-Up Disable control for this pin
    uint32_t GPIO36 : 1; // 4:4   reserved
    uint32_t GPIO37 : 1; // 5:5   Pull-Up Disable control for this pin
    uint32_t GPIO38 : 1; // 6:6   reserved
    uint32_t GPIO39 : 1; // 7:7   Pull-Up Disable control for this pin
    uint32_t GPIO40 : 1; // 8:8   Pull-Up Disable control for this pin
    uint32_t GPIO41 : 1; // 9:9   Pull-Up Disable control for this pin
    uint32_t GPIO42 : 1; // 10:10   Pull-Up Disable control for this pin
    uint32_t GPIO43 : 1; // 11:11   Pull-Up Disable control for this pin
    uint32_t GPIO44 : 1; // 12:12   Pull-Up Disable control for this pin
    uint32_t GPIO45 : 1; // 13:13   Pull-Up Disable control for this pin
    uint32_t rsvd1 : 18; // 31:14   Reserved
};

union GPBPUD_REG {
    uint32_t           all;
    struct GPBPUD_BITS bit;
};

//
// AIO Qualification Sampling Period Control (AIO2 to14)
//
struct AIOCTRL_BITS {      // bits   description
    uint32_t QUALPRD0 : 8; // 7:0   Qualification sampling period for aio2/4/6:
    uint32_t QUALPRD1 : 8; // 15:8   Qualification sampling period for aio10/12/14:
    uint32_t rsvd1 : 16;   // 31:16   Reserved
};

union AIOCTRL_REG {
    uint32_t            all;
    // struct AIOCTRL_BITS bit;
};

//
// AIO Qualifier Select 1 Register (AI2 to 14)
//
struct AIOQSEL1_BITS {  // bits   description
    uint32_t rsvd1 : 4; // 3:0   Reserved
    uint32_t AIO2 : 2;  // 5:4   Select input qualification type for aio2:
    uint32_t rsvd2 : 2; // 7:6   Reserved
    uint32_t AIO4 : 2;  // 9:8   Select input qualification type for aio4:
    uint32_t rsvd3 : 2; // 11:10   Reserved
    uint32_t AIO6 : 2;  // 13:12   Select input qualification type for aio6:
    uint32_t rsvd4 : 6; // 19:14   Reserved
    uint32_t AIO10 : 2; // 21:20   Select input qualification type for aio10:
    uint32_t rsvd5 : 2; // 23:22   Reserved
    uint32_t AIO12 : 2; // 25:24   Select input qualification type for aio12:
    uint32_t rsvd6 : 2; // 27:26   Reserved
    uint32_t AIO14 : 2; // 29:28   Select input qualification type for aio14:
    uint32_t rsvd7 : 2; // 31:30   Reserved
};

union AIOQSEL1_REG {
    uint32_t             all;
    struct AIOQSEL1_BITS bit;
};

//
// AIO Mux 1 Register (AIO0 to 14)
//
struct AIOMUX1_BITS {   // bits   description
    uint32_t rsvd1 : 4; // 3:0   Reserved
    uint32_t AIO2 : 2;  // 5:4   enable signal for this gpio : 00 or 01 : gpio enabled  ;   10 or 11 : gpio disabled
    uint32_t rsvd2 : 2; // 7:6   Reserved
    uint32_t AIO4 : 2;  // 9:8   enable signal for this gpio : 00 or 01 : gpio enabled  ;   10 or 11 : gpio disabled
    uint32_t rsvd3 : 2; // 11:10   Reserved
    uint32_t AIO6 : 2;  // 13:12   enable signal for this gpio : 00 or 01 : gpio enabled  ;   10 or 11 : gpio disabled
    uint32_t rsvd4 : 6; // 19:14   Reserved
    uint32_t AIO10 : 2; // 21:20   enable signal for this gpio : 00 or 01 : gpio enabled  ;   10 or 11 : gpio disabled
    uint32_t rsvd5 : 2; // 23:22   Reserved
    uint32_t AIO12 : 2; // 25:24   enable signal for this gpio : 00 or 01 : gpio enabled  ;   10 or 11 : gpio disabled
    uint32_t rsvd6 : 2; // 27:26   Reserved
    uint32_t AIO14 : 2; // 29:28   enable signal for this gpio : 00 or 01 : gpio enabled  ;   10 or 11 : gpio disabled
    uint32_t rsvd7 : 2; // 31:30   Reserved
};

union AIOMUX1_REG {
    uint32_t            all;
    struct AIOMUX1_BITS bit;
};

//
// AIO Drive Strength 1 Register1 (AIO2 to 14)
//
struct AIODS1_BITS {    // bits   description
    uint32_t rsvd1 : 4; // 3:0   Reserved
    uint32_t AIO2 : 2;  // 5:4   Defines drive strength for GPIO
    uint32_t rsvd2 : 2; // 7:6   Reserved
    uint32_t AIO4 : 2;  // 9:8   Defines drive strength for GPIO
    uint32_t rsvd3 : 2; // 11:10   Reserved
    uint32_t AIO6 : 2;  // 13:12   Defines drive strength for GPIO
    uint32_t rsvd4 : 6; // 19:14   Reserved
    uint32_t AIO10 : 2; // 21:20   Defines drive strength for GPIO
    uint32_t rsvd5 : 2; // 23:22   Reserved
    uint32_t AIO12 : 2; // 25:24   Defines drive strength for GPIO
    uint32_t rsvd6 : 2; // 27:26   Reserved
    uint32_t AIO14 : 1; // 28:28   Defines drive strength for PI2C GPIO
    uint32_t rsvd7 : 3; // 31:29   Reserved
};

union AIODS1_REG {
    uint32_t           all;
    struct AIODS1_BITS bit;
};

//
// AIO Direction Register (AIO0 to 14)
//
struct AIODIR_BITS {     // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   defines direction for this pin in gpio mode (0: input ; 5:output)
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   defines direction for this pin in gpio mode (0: input ; 4:output)
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   defines direction for this pin in gpio mode (0: input ; 3:output)
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   defines direction for this pin in gpio mode (0: input ; 2:output)
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   defines direction for this pin in gpio mode (0: input ; 1:output)
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIODIR_REG {
    uint32_t           all;
    struct AIODIR_BITS bit;
};

//
// AIO Mux 2 Register (AIO0 to 14)
//
struct AIOMUX2_BITS {   // bits   description
    uint32_t rsvd1 : 4; // 3:0   Reserved
    uint32_t AIO2 : 2;  // 5:4   Defines pin-muxing selection for aio 2
    uint32_t rsvd2 : 2; // 7:6   Reserved
    uint32_t AIO4 : 2;  // 9:8   Defines pin-muxing selection for aio 4
    uint32_t rsvd3 : 2; // 11:10   Reserved
    uint32_t AIO6 : 2;  // 13:12   Defines pin-muxing selection for aio 6
    uint32_t rsvd4 : 6; // 19:14   Reserved
    uint32_t AIO10 : 2; // 21:20   Defines pin-muxing selection for aio 10
    uint32_t rsvd5 : 2; // 23:22   Reserved
    uint32_t AIO12 : 2; // 25:24   Defines pin-muxing selection for aio 12
    uint32_t rsvd6 : 2; // 27:26   Reserved
    uint32_t AIO14 : 2; // 29:28   Defines pin-muxing selection for aio 14
    uint32_t rsvd7 : 2; // 31:30   Reserved
};

union AIOMUX2_REG {
    uint32_t            all;
    struct AIOMUX2_BITS bit;
};

//
// AIO loop Register (AIO0 to 14)
//
struct AIOLOOPEN_BITS {  // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   defines aio loopen or not : 1 --> input_en = output_en ; 0: input_en = ~output_en
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   defines aio loopen or not : 1 --> input_en = output_en ; 0: input_en = ~output_en
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   defines aio loopen or not : 1 --> input_en = output_en ; 0: input_en = ~output_en
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   defines aio loopen or not : 1 --> input_en = output_en ; 0: input_en = ~output_en
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   defines aio loopen or not : 1 --> input_en = output_en ; 0: input_en = ~output_en
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   defines aio loopen or not : 1 --> input_en = output_en ; 0: input_en = ~output_en
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIOLOOPEN_REG {
    uint32_t              all;
    struct AIOLOOPEN_BITS bit;
};

//
// GPIO A Data Register  Write value (GPIO0 to 31)
//
struct GPADAT_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO1 : 1;  // 1:1   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO2 : 1;  // 2:2   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO3 : 1;  // 3:3   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO4 : 1;  // 4:4   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO5 : 1;  // 5:5   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO6 : 1;  // 6:6   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO7 : 1;  // 7:7   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO8 : 1;  // 8:8   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO9 : 1;  // 9:9   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO10 : 1; // 10:10   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO11 : 1; // 11:11   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO12 : 1; // 12:12   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO13 : 1; // 13:13   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO14 : 1; // 14:14   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO15 : 1; // 15:15   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO16 : 1; // 16:16   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO17 : 1; // 17:17   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO18 : 1; // 18:18   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO19 : 1; // 19:19   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO20 : 1; // 20:20   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO21 : 1; // 21:21   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO22 : 1; // 22:22   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO23 : 1; // 23:23   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO24 : 1; // 24:24   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO25 : 1; // 25:25   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO26 : 1; // 26:26   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO27 : 1; // 27:27   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO28 : 1; // 28:28   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO29 : 1; // 29:29   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO30 : 1; // 30:30   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO31 : 1; // 31:31   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
};

union GPADAT_REG {
    uint32_t           all;
    struct GPADAT_BITS bit;
};

//
// GPIO A  Data Set Register (GPIO0 to 31)
//
struct GPASET_BITS {     // bits   description
    uint32_t GPIO0 : 1;  // 0:0   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO1 : 1;  // 1:1   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO2 : 1;  // 2:2   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO3 : 1;  // 3:3   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO4 : 1;  // 4:4   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO5 : 1;  // 5:5   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO6 : 1;  // 6:6   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO7 : 1;  // 7:7   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO8 : 1;  // 8:8   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO9 : 1;  // 9:9   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO10 : 1; // 10:10   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO11 : 1; // 11:11   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO12 : 1; // 12:12   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO13 : 1; // 13:13   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO14 : 1; // 14:14   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO15 : 1; // 15:15   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO16 : 1; // 16:16   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO17 : 1; // 17:17   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO18 : 1; // 18:18   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO19 : 1; // 19:19   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO20 : 1; // 20:20   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO21 : 1; // 21:21   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO22 : 1; // 22:22   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO23 : 1; // 23:23   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO24 : 1; // 24:24   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO25 : 1; // 25:25   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO26 : 1; // 26:26   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO27 : 1; // 27:27   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO28 : 1; // 28:28   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO29 : 1; // 29:29   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO30 : 1; // 30:30   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO31 : 1; // 31:31   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
};

union GPASET_REG {
    uint32_t           all;
    struct GPASET_BITS bit;
};

//
// GPIO A  Data Clear Register (GPIO0 to 31)
//
struct GPACLEAR_BITS {   // bits   description
    uint32_t GPIO0 : 1;  // 0:0   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO1 : 1;  // 1:1   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO2 : 1;  // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO3 : 1;  // 3:3   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO4 : 1;  // 4:4   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO5 : 1;  // 5:5   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO6 : 1;  // 6:6   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO7 : 1;  // 7:7   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO8 : 1;  // 8:8   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO9 : 1;  // 9:9   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO10 : 1; // 10:10   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO11 : 1; // 11:11   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO12 : 1; // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO13 : 1; // 13:13   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO14 : 1; // 14:14   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO15 : 1; // 15:15   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO16 : 1; // 16:16   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO17 : 1; // 17:17   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO18 : 1; // 18:18   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO19 : 1; // 19:19   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO20 : 1; // 20:20   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO21 : 1; // 21:21   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO22 : 1; // 22:22   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO23 : 1; // 23:23   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO24 : 1; // 24:24   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO25 : 1; // 25:25   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO26 : 1; // 26:26   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO27 : 1; // 27:27   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO28 : 1; // 28:28   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO29 : 1; // 29:29   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO30 : 1; // 30:30   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO31 : 1; // 31:31   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
};

union GPACLEAR_REG {
    uint32_t             all;
    struct GPACLEAR_BITS bit;
};

//
// GPIO A  Data Toggle Register (GPIO0 to 31)
//
struct GPATOGGLE_BITS {  // bits   description
    uint32_t GPIO0 : 1;  // 0:0   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO1 : 1;  // 1:1   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO2 : 1;  // 2:2   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO3 : 1;  // 3:3   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO4 : 1;  // 4:4   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO5 : 1;  // 5:5   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO6 : 1;  // 6:6   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO7 : 1;  // 7:7   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO8 : 1;  // 8:8   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO9 : 1;  // 9:9   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO10 : 1; // 10:10   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO11 : 1; // 11:11   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO12 : 1; // 12:12   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO13 : 1; // 13:13   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO14 : 1; // 14:14   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO15 : 1; // 15:15   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO16 : 1; // 16:16   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO17 : 1; // 17:17   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO18 : 1; // 18:18   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO19 : 1; // 19:19   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO20 : 1; // 20:20   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO21 : 1; // 21:21   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO22 : 1; // 22:22   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO23 : 1; // 23:23   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO24 : 1; // 24:24   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO25 : 1; // 25:25   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO26 : 1; // 26:26   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO27 : 1; // 27:27   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO28 : 1; // 28:28   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO29 : 1; // 29:29   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO30 : 1; // 30:30   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO31 : 1; // 31:31   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
};

union GPATOGGLE_REG {
    uint32_t              all;
    struct GPATOGGLE_BITS bit;
};

//
// GPIO B Data Register Write Vlaue (GPIO32 to 63)
//
struct GPBDAT_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO33 : 1; // 1:1   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO34 : 1; // 2:2   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO35 : 1; // 3:3   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO36 : 1; // 4:4   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO37 : 1; // 5:5   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO38 : 1; // 6:6   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO39 : 1; // 7:7   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO40 : 1; // 8:8   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO41 : 1; // 9:9   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO42 : 1; // 10:10   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO43 : 1; // 11:11   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO44 : 1; // 12:12   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t GPIO45 : 1; // 13:13   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd1 : 18; // 31:14   Reserved
};

union GPBDAT_REG {
    uint32_t           all;
    struct GPBDAT_BITS bit;
};

//
// GPIO B Data Set Register (GPIO32 to 63)
//
struct GPBSET_BITS {     // bits   description
    uint32_t GPIO32 : 1; // 0:0   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO33 : 1; // 1:1   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO34 : 1; // 2:2   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO35 : 1; // 3:3   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO36 : 1; // 4:4   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO37 : 1; // 5:5   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO38 : 1; // 6:6   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO39 : 1; // 7:7   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO40 : 1; // 8:8   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO41 : 1; // 9:9   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO42 : 1; // 10:10   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO43 : 1; // 11:11   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO44 : 1; // 12:12   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO45 : 1; // 13:13   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 18; // 31:14   Reserved
};

union GPBSET_REG {
    uint32_t           all;
    struct GPBSET_BITS bit;
};

//
// GPIO B Data Clear Register (GPIO32 to 63)
//
struct GPBCLEAR_BITS {   // bits   description
    uint32_t GPIO32 : 1; // 0:0   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO33 : 1; // 1:1   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO34 : 1; // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO35 : 1; // 3:3   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO36 : 1; // 4:4   reserved
    uint32_t GPIO37 : 1; // 5:5   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO38 : 1; // 6:6   reserved
    uint32_t GPIO39 : 1; // 7:7   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO40 : 1; // 8:8   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO41 : 1; // 9:9   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO42 : 1; // 10:10   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO43 : 1; // 11:11   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO44 : 1; // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t GPIO45 : 1; // 13:13   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 18; // 31:14   Reserved
};

union GPBCLEAR_REG {
    uint32_t             all;
    struct GPBCLEAR_BITS bit;
};

//
// GPIO B  Data Toggle Register (GPIO0 to 31)
//
struct GPBTOGGLE_BITS {  // bits   description
    uint32_t GPIO32 : 1; // 0:0   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO33 : 1; // 1:1   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO34 : 1; // 2:2   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO35 : 1; // 3:3   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO36 : 1; // 4:4   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO37 : 1; // 5:5   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO38 : 1; // 6:6   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO39 : 1; // 7:7   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO40 : 1; // 8:8   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO41 : 1; // 9:9   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO42 : 1; // 10:10   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO43 : 1; // 11:11   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO44 : 1; // 12:12   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t GPIO45 : 1; // 13:13   write a 1 will force gpio output data latch reverse(0->1 , 1->0) ; write 0 ingnored ; reads back a 0
    uint32_t rsvd1 : 18; // 31:14   Reserved
};

union GPBTOGGLE_REG {
    uint32_t              all;
    struct GPBTOGGLE_BITS bit;
};

//
// AIO Data Register (AIO0 to 14)
//
struct AIODAT_BITS {     // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   read : sample the state of pin ;  write : write value to output latch (output mode : output to pin ;
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIODAT_REG {
    uint32_t           all;
    struct AIODAT_BITS bit;
};

//
// AIO  Data Set Register (AIO0 to 14)
//
struct AIOSET_BITS {     // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   write a 1 will force gpio output data latch to 1 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIOSET_REG {
    uint32_t           all;
    struct AIOSET_BITS bit;
};

//
// AIO Data Clear Register (AIO0 to 14)
//
struct AIOCLEAR_BITS {   // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIOCLEAR_REG {
    uint32_t             all;
    struct AIOCLEAR_BITS bit;
};

//
// AIO Data Toggle Register (AIO0 to 14)
//
struct AIOTOGGLE_BITS {  // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   write a 1 will force gpio output data latch to 0 ; write 0 ingnored ; reads back a 0
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIOTOGGLE_REG {
    uint32_t              all;
    struct AIOTOGGLE_BITS bit;
};
//
// XINT1 source select register(gpio0-gpio31)
//
struct GPIOXINT1SEL_BITS { // bits   description
    uint16_t GPIOSEL : 5;  // 4:0   select the gpio pin as XINT1 interrupt source (default 0);0000 -> gpio0 , 0001 ->gpio1 ,...,1111 ->gpio31
    uint16_t rsvd1 : 11;   // 15:5   Reserved
};

union GPIOXINT1SEL_REG {
    uint16_t                 all;
    struct GPIOXINT1SEL_BITS bit;
};

//
// XINT2 source select register(gpio0-gpio31)
//
struct GPIOXINT2SEL_BITS { // bits   description
    uint16_t GPIOSEL : 5;  // 4:0   select the gpio pin as XINT1 interrupt source (default 0);0000 -> gpio0 , 0001 ->gpio1 ,...,1111 ->gpio31
    uint16_t rsvd1 : 11;   // 15:5   Reserved
};

union GPIOXINT2SEL_REG {
    uint16_t                 all;
    struct GPIOXINT2SEL_BITS bit;
};

//
// XINT3 source select register(gpio0-gpio31)
//
struct GPIOXINT3SEL_BITS { // bits   description
    uint16_t GPIOSEL : 5;  // 4:0   select the gpio pin as XINT1 interrupt source (default 0);0000 -> gpio0 , 0001 ->gpio1 ,...,1111 ->gpio31
    uint16_t rsvd1 : 11;   // 15:5   Reserved
};

union GPIOXINT3SEL_REG {
    uint16_t                 all;
    struct GPIOXINT3SEL_BITS bit;
};

struct GPIOLPMSEL_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0
    uint32_t GPIO1 : 1;  // 1:1
    uint32_t GPIO2 : 1;  // 2:2
    uint32_t GPIO3 : 1;  // 3:3
    uint32_t GPIO4 : 1;  // 4:4
    uint32_t GPIO5 : 1;  // 5:5
    uint32_t GPIO6 : 1;  // 6:6
    uint32_t GPIO7 : 1;  // 7:7
    uint32_t GPIO8 : 1;  // 8:8
    uint32_t GPIO9 : 1;  // 9:9
    uint32_t GPIO10 : 1; // 10:10
    uint32_t GPIO11 : 1; // 11:11
    uint32_t GPIO12 : 1; // 12:12
    uint32_t GPIO13 : 1; // 13:13
    uint32_t GPIO14 : 1; // 14:14
    uint32_t GPIO15 : 1; // 15:15
    uint32_t GPIO16 : 1; // 16:16
    uint32_t GPIO17 : 1; // 17:17
    uint32_t GPIO18 : 1; // 18:18
    uint32_t GPIO19 : 1; // 19:19
    uint32_t GPIO20 : 1; // 20:20
    uint32_t GPIO21 : 1; // 21:21
    uint32_t GPIO22 : 1; // 22:22
    uint32_t GPIO23 : 1; // 23:23
    uint32_t GPIO24 : 1; // 24:24
    uint32_t GPIO25 : 1; // 25:25
    uint32_t GPIO26 : 1; // 26:26
    uint32_t GPIO27 : 1; // 27:27
    uint32_t GPIO28 : 1; // 28:28
    uint32_t GPIO29 : 1; // 29:29
    uint32_t GPIO30 : 1; // 30:30
    uint32_t GPIO31 : 1; // 31:31
};

union GPIOLPMSEL_REG {
    uint16_t               all;
    struct GPIOLPMSEL_BITS bit;
};

//
// GPIO A  Interrrupt type (GPIO0 to 31)
//
struct GPA_INTTYPE_BITS { // bits   description
    uint32_t GPIO0 : 1;   // 0:0   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO1 : 1; // 1:1   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO2 : 1; // 2:2   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO3 : 1; // 3:3   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO4 : 1; // 4:4   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO5 : 1; // 5:5   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO6 : 1; // 6:6   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO7 : 1; // 7:7   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO8 : 1; // 8:8   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO9 : 1; // 9:9   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO10 : 1; // 10:10   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO11 : 1; // 11:11   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO12 : 1; // 12:12   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO13 : 1; // 13:13   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO14 : 1; // 14:14   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO15 : 1; // 15:15   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO16 : 1; // 16:16   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO17 : 1; // 17:17   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO18 : 1; // 18:18   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO19 : 1; // 19:19   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO20 : 1; // 20:20   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO21 : 1; // 21:21   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO22 : 1; // 22:22   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO23 : 1; // 23:23   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO24 : 1; // 24:24   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO25 : 1; // 25:25   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO26 : 1; // 26:26   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO27 : 1; // 27:27   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO28 : 1; // 28:28   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO29 : 1; // 29:29   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO30 : 1; // 30:30   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO31 : 1; // 31:31   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)
};

union GPA_INTTYPE_REG {
    uint32_t                all;
    struct GPA_INTTYPE_BITS bit;
};

//
// GPIO A  Interrrupt polarity (GPIO0 to 31)
//
struct GPA_INTPOL_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO1 : 1; // 1:1   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO2 : 1; // 2:2   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO3 : 1; // 3:3   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO4 : 1; // 4:4   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO5 : 1; // 5:5   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO6 : 1; // 6:6   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO7 : 1; // 7:7   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO8 : 1; // 8:8   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO9 : 1; // 9:9   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO10 : 1; // 10:10   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO11 : 1; // 11:11   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO12 : 1; // 12:12   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO13 : 1; // 13:13   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO14 : 1; // 14:14   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO15 : 1; // 15:15   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO16 : 1; // 16:16   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO17 : 1; // 17:17   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO18 : 1; // 18:18   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO19 : 1; // 19:19   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO20 : 1; // 20:20   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO21 : 1; // 21:21   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO22 : 1; // 22:22   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO23 : 1; // 23:23   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO24 : 1; // 24:24   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO25 : 1; // 25:25   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO26 : 1; // 26:26   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO27 : 1; // 27:27   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO28 : 1; // 28:28   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO29 : 1; // 29:29   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO30 : 1; // 30:30   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO31 : 1; // 31:31   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge
};

union GPA_INTPOL_REG {
    uint32_t               all;
    struct GPA_INTPOL_BITS bit;
};

//
// GPIO A  Interrrupt mask (GPIO0 to 31)
//
struct GPA_INTMASK_BITS { // bits   description
    uint32_t GPIO0 : 1;   // 0:0   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO1 : 1; // 1:1   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO2 : 1; // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO3 : 1; // 3:3   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO4 : 1; // 4:4   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO5 : 1; // 5:5   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO6 : 1; // 6:6   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO7 : 1; // 7:7   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO8 : 1; // 8:8   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO9 : 1; // 9:9   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO10 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO11 : 1; // 11:11   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO12 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO13 : 1; // 13:13   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO14 : 1; // 14:14   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO15 : 1; // 15:15   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO16 : 1; // 16:16   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO17 : 1; // 17:17   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO18 : 1; // 18:18   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO19 : 1; // 19:19   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO20 : 1; // 20:20   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO21 : 1; // 21:21   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO22 : 1; // 22:22   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO23 : 1; // 23:23   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO24 : 1; // 24:24   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO25 : 1; // 25:25   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO26 : 1; // 26:26   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO27 : 1; // 27:27   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO28 : 1; // 28:28   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO29 : 1; // 29:29   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO30 : 1; // 30:30   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO31 : 1; // 31:31   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int
};

union GPA_INTMASK_REG {
    uint32_t                all;
    struct GPA_INTMASK_BITS bit;
};

//
// GPIO A  Interrrupt clear (GPIO0 to 31)
//
struct GPA_INTCLR_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO1 : 1;  // 1:1   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO2 : 1;  // 2:2   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO3 : 1;  // 3:3   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO4 : 1;  // 4:4   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO5 : 1;  // 5:5   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO6 : 1;  // 6:6   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO7 : 1;  // 7:7   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO8 : 1;  // 8:8   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO9 : 1;  // 9:9   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO10 : 1; // 10:10   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO11 : 1; // 11:11   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO12 : 1; // 12:12   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO13 : 1; // 13:13   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO14 : 1; // 14:14   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO15 : 1; // 15:15   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO16 : 1; // 16:16   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO17 : 1; // 17:17   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO18 : 1; // 18:18   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO19 : 1; // 19:19   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO20 : 1; // 20:20   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO21 : 1; // 21:21   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO22 : 1; // 22:22   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO23 : 1; // 23:23   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO24 : 1; // 24:24   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO25 : 1; // 25:25   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO26 : 1; // 26:26   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO27 : 1; // 27:27   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO28 : 1; // 28:28   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO29 : 1; // 29:29   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO30 : 1; // 30:30   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO31 : 1; // 31:31   clear  interrupt of gpio  ;    1 : clear the int
};

union GPA_INTCLR_REG {
    uint32_t               all;
    struct GPA_INTCLR_BITS bit;
};

//
// GPIO A  raw Interrrupt  (GPIO0 to 31)
//
struct GPA_INTRAW_BITS { // bits   description
    uint32_t GPIO0 : 1;  // 0:0   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO1 : 1;  // 1:1   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO2 : 1;  // 2:2   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO3 : 1;  // 3:3   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO4 : 1;  // 4:4   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO5 : 1;  // 5:5   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO6 : 1;  // 6:6   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO7 : 1;  // 7:7   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO8 : 1;  // 8:8   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO9 : 1;  // 9:9   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO10 : 1; // 10:10   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO11 : 1; // 11:11   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO12 : 1; // 12:12   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO13 : 1; // 13:13   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO14 : 1; // 14:14   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO15 : 1; // 15:15   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO16 : 1; // 16:16   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO17 : 1; // 17:17   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO18 : 1; // 18:18   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO19 : 1; // 19:19   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO20 : 1; // 20:20   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO21 : 1; // 21:21   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO22 : 1; // 22:22   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO23 : 1; // 23:23   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO24 : 1; // 24:24   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO25 : 1; // 25:25   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO26 : 1; // 26:26   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO27 : 1; // 27:27   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO28 : 1; // 28:28   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO29 : 1; // 29:29   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO30 : 1; // 30:30   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO31 : 1; // 31:31   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
};

union GPA_INTRAW_REG {
    uint32_t               all;
    struct GPA_INTRAW_BITS bit;
};

//
// GPIO A  Interrrupt states  (GPIO0 to 31)
//
struct GPA_INTSTATUS_BITS { // bits   description
    uint32_t GPIO0 : 1;     // 0:0   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO1 : 1;     // 1:1   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO2 : 1;     // 2:2   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO3 : 1;     // 3:3   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO4 : 1;     // 4:4   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO5 : 1;     // 5:5   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO6 : 1;     // 6:6   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO7 : 1;     // 7:7   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO8 : 1;     // 8:8   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO9 : 1;     // 9:9   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO10 : 1;    // 10:10   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO11 : 1;    // 11:11   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO12 : 1;    // 12:12   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO13 : 1;    // 13:13   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO14 : 1;    // 14:14   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO15 : 1;    // 15:15   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO16 : 1;    // 16:16   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO17 : 1;    // 17:17   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO18 : 1;    // 18:18   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO19 : 1;    // 19:19   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO20 : 1;    // 20:20   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO21 : 1;    // 21:21   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO22 : 1;    // 22:22   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO23 : 1;    // 23:23   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO24 : 1;    // 24:24   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO25 : 1;    // 25:25   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO26 : 1;    // 26:26   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO27 : 1;    // 27:27   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO28 : 1;    // 28:28   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO29 : 1;    // 29:29   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO30 : 1;    // 30:30   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO31 : 1;    // 31:31   status  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
};

union GPA_INTSTATUS_REG {
    uint32_t                  all;
    struct GPA_INTSTATUS_BITS bit;
};

//
// GPIO B  Interrrupt type (GPIO32 to 63)
//
struct GPB_INTTYPE_BITS { // bits   description
    uint32_t GPIO32 : 1;  // 0:0   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO33 : 1; // 1:1   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO34 : 1; // 2:2   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO35 : 1; // 3:3   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO36 : 1; // 4:4   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO37 : 1; // 5:5   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO38 : 1; // 6:6   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO39 : 1; // 7:7   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO40 : 1; // 8:8   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO41 : 1; // 9:9   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO42 : 1; // 10:10   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO43 : 1; // 11:11   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO44 : 1; // 12:12   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t GPIO45 : 1; // 13:13   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd1 : 1;  // 14:14   Reserved
    uint32_t rsvd2 : 1;  // 15:15   Reserved
    uint32_t rsvd3 : 1;  // 16:16   Reserved
    uint32_t rsvd4 : 1;  // 17:17   Reserved
    uint32_t rsvd5 : 1;  // 18:18   Reserved
    uint32_t rsvd6 : 1;  // 19:19   Reserved
    uint32_t rsvd7 : 1;  // 20:20   Reserved
    uint32_t rsvd8 : 1;  // 21:21   Reserved
    uint32_t rsvd9 : 1;  // 22:22   Reserved
    uint32_t rsvd10 : 1; // 23:23   Reserved
    uint32_t rsvd11 : 1; // 24:24   Reserved
    uint32_t rsvd12 : 1; // 25:25   Reserved
    uint32_t rsvd13 : 1; // 26:26   Reserved
    uint32_t rsvd14 : 1; // 27:27   Reserved
    uint32_t rsvd15 : 1; // 28:28   Reserved
    uint32_t rsvd16 : 1; // 29:29   Reserved
    uint32_t rsvd17 : 1; // 30:30   Reserved
    uint32_t rsvd18 : 1; // 31:31   Reserved
};

union GPB_INTTYPE_REG {
    uint32_t                all;
    struct GPB_INTTYPE_BITS bit;
};

//
// GPIO B  Interrrupt polarity (GPIO32 to 63)
//
struct GPB_INTPOL_BITS { // bits   description
    uint32_t GPIO32 : 1; // 0:0   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO33 : 1; // 1:1   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO34 : 1; // 2:2   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO35 : 1; // 3:3   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO36 : 1; // 4:4   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO37 : 1; // 5:5   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO38 : 1; // 6:6   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO39 : 1; // 7:7   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO40 : 1; // 8:8   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO41 : 1; // 9:9   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO42 : 1; // 10:10   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO43 : 1; // 11:11   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO44 : 1; // 12:12   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t GPIO45 : 1; // 13:13   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd1 : 1;  // 14:14   Reserved
    uint32_t rsvd2 : 1;  // 15:15   Reserved
    uint32_t rsvd3 : 1;  // 16:16   Reserved
    uint32_t rsvd4 : 1;  // 17:17   Reserved
    uint32_t rsvd5 : 1;  // 18:18   Reserved
    uint32_t rsvd6 : 1;  // 19:19   Reserved
    uint32_t rsvd7 : 1;  // 20:20   Reserved
    uint32_t rsvd8 : 1;  // 21:21   Reserved
    uint32_t rsvd9 : 1;  // 22:22   Reserved
    uint32_t rsvd10 : 1; // 23:23   Reserved
    uint32_t rsvd11 : 1; // 24:24   Reserved
    uint32_t rsvd12 : 1; // 25:25   Reserved
    uint32_t rsvd13 : 1; // 26:26   Reserved
    uint32_t rsvd14 : 1; // 27:27   Reserved
    uint32_t rsvd15 : 1; // 28:28   Reserved
    uint32_t rsvd16 : 1; // 29:29   Reserved
    uint32_t rsvd17 : 1; // 30:30   Reserved
    uint32_t rsvd18 : 1; // 31:31   Reserved
};

union GPB_INTPOL_REG {
    uint32_t               all;
    struct GPB_INTPOL_BITS bit;
};

//
// GPIO B  Interrrupt mask (GPIO32 to 63)
//
struct GPB_INTMASK_BITS { // bits   description
    uint32_t GPIO32 : 1;  // 0:0   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO33 : 1; // 1:1   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO34 : 1; // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO35 : 1; // 3:3   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO36 : 1; // 4:4   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO37 : 1; // 5:5   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO38 : 1; // 6:6   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO39 : 1; // 7:7   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO40 : 1; // 8:8   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO41 : 1; // 9:9   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO42 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO43 : 1; // 11:11   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO44 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t GPIO45 : 1; // 13:13   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd1 : 1;  // 14:14   Reserved
    uint32_t rsvd2 : 1;  // 15:15   Reserved
    uint32_t rsvd3 : 1;  // 16:16   Reserved
    uint32_t rsvd4 : 1;  // 17:17   Reserved
    uint32_t rsvd5 : 1;  // 18:18   Reserved
    uint32_t rsvd6 : 1;  // 19:19   Reserved
    uint32_t rsvd7 : 1;  // 20:20   Reserved
    uint32_t rsvd8 : 1;  // 21:21   Reserved
    uint32_t rsvd9 : 1;  // 22:22   Reserved
    uint32_t rsvd10 : 1; // 23:23   Reserved
    uint32_t rsvd11 : 1; // 24:24   Reserved
    uint32_t rsvd12 : 1; // 25:25   Reserved
    uint32_t rsvd13 : 1; // 26:26   Reserved
    uint32_t rsvd14 : 1; // 27:27   Reserved
    uint32_t rsvd15 : 1; // 28:28   Reserved
    uint32_t rsvd16 : 1; // 29:29   Reserved
    uint32_t rsvd17 : 1; // 30:30   Reserved
    uint32_t rsvd18 : 1; // 31:31   Reserved
};

union GPB_INTMASK_REG {
    uint32_t                all;
    struct GPB_INTMASK_BITS bit;
};

//
// GPIO B  Interrrupt clear (GPIO32 to 63)
//
struct GPB_INTCLR_BITS { // bits   description
    uint32_t GPIO32 : 1; // 0:0   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO33 : 1; // 1:1   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO34 : 1; // 2:2   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO35 : 1; // 3:3   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO36 : 1; // 4:4   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO37 : 1; // 5:5   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO38 : 1; // 6:6   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO39 : 1; // 7:7   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO40 : 1; // 8:8   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO41 : 1; // 9:9   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO42 : 1; // 10:10   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO43 : 1; // 11:11   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO44 : 1; // 12:12   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t GPIO45 : 1; // 13:13   clear  interrupt of gpio  ;    1 : clear the int
    uint32_t rsvd1 : 1;  // 14:14   Reserved
    uint32_t rsvd2 : 1;  // 15:15   Reserved
    uint32_t rsvd3 : 1;  // 16:16   Reserved
    uint32_t rsvd4 : 1;  // 17:17   Reserved
    uint32_t rsvd5 : 1;  // 18:18   Reserved
    uint32_t rsvd6 : 1;  // 19:19   Reserved
    uint32_t rsvd7 : 1;  // 20:20   Reserved
    uint32_t rsvd8 : 1;  // 21:21   Reserved
    uint32_t rsvd9 : 1;  // 22:22   Reserved
    uint32_t rsvd10 : 1; // 23:23   Reserved
    uint32_t rsvd11 : 1; // 24:24   Reserved
    uint32_t rsvd12 : 1; // 25:25   Reserved
    uint32_t rsvd13 : 1; // 26:26   Reserved
    uint32_t rsvd14 : 1; // 27:27   Reserved
    uint32_t rsvd15 : 1; // 28:28   Reserved
    uint32_t rsvd16 : 1; // 29:29   Reserved
    uint32_t rsvd17 : 1; // 30:30   Reserved
    uint32_t rsvd18 : 1; // 31:31   Reserved
};

union GPB_INTCLR_REG {
    uint32_t               all;
    struct GPB_INTCLR_BITS bit;
};

//
// GPIO B  raw Interrrupt  (GPIO32 to 63)
//
struct GPB_INTRAW_BITS { // bits   description
    uint32_t GPIO32 : 1; // 0:0   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO33 : 1; // 1:1   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO34 : 1; // 2:2   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO35 : 1; // 3:3   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO36 : 1; // 4:4   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO37 : 1; // 5:5   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO38 : 1; // 6:6   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO39 : 1; // 7:7   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO40 : 1; // 8:8   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO41 : 1; // 9:9   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO42 : 1; // 10:10   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO43 : 1; // 11:11   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO44 : 1; // 12:12   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t GPIO45 : 1; // 13:13   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd1 : 1;  // 14:14   Reserved
    uint32_t rsvd2 : 1;  // 15:15   Reserved
    uint32_t rsvd3 : 1;  // 16:16   Reserved
    uint32_t rsvd4 : 1;  // 17:17   Reserved
    uint32_t rsvd5 : 1;  // 18:18   Reserved
    uint32_t rsvd6 : 1;  // 19:19   Reserved
    uint32_t rsvd7 : 1;  // 20:20   Reserved
    uint32_t rsvd8 : 1;  // 21:21   Reserved
    uint32_t rsvd9 : 1;  // 22:22   Reserved
    uint32_t rsvd10 : 1; // 23:23   Reserved
    uint32_t rsvd11 : 1; // 24:24   Reserved
    uint32_t rsvd12 : 1; // 25:25   Reserved
    uint32_t rsvd13 : 1; // 26:26   Reserved
    uint32_t rsvd14 : 1; // 27:27   Reserved
    uint32_t rsvd15 : 1; // 28:28   Reserved
    uint32_t rsvd16 : 1; // 29:29   Reserved
    uint32_t rsvd17 : 1; // 30:30   Reserved
    uint32_t rsvd18 : 1; // 31:31   Reserved
};

union GPB_INTRAW_REG {
    uint32_t               all;
    struct GPB_INTRAW_BITS bit;
};

//
// GPIO B  Interrrupt states  (GPIO32 to 63)
//
struct GPB_INTSTATUS_BITS { // bits   description
    uint32_t GPIO32 : 1;    // 0:0   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO33 : 1;    // 1:1   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO34 : 1;    // 2:2   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO35 : 1;    // 3:3   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO36 : 1;    // 4:4   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO37 : 1;    // 5:5   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO38 : 1;    // 6:6   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO39 : 1;    // 7:7   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO40 : 1;    // 8:8   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO41 : 1;    // 9:9   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO42 : 1;    // 10:10   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO43 : 1;    // 11:11   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO44 : 1;    // 12:12   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t GPIO45 : 1;    // 13:13   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd1 : 1;     // 14:14   Reserved
    uint32_t rsvd2 : 1;     // 15:15   Reserved
    uint32_t rsvd3 : 1;     // 16:16   Reserved
    uint32_t rsvd4 : 1;     // 17:17   Reserved
    uint32_t rsvd5 : 1;     // 18:18   Reserved
    uint32_t rsvd6 : 1;     // 19:19   Reserved
    uint32_t rsvd7 : 1;     // 20:20   Reserved
    uint32_t rsvd8 : 1;     // 21:21   Reserved
    uint32_t rsvd9 : 1;     // 22:22   Reserved
    uint32_t rsvd10 : 1;    // 23:23   Reserved
    uint32_t rsvd11 : 1;    // 24:24   Reserved
    uint32_t rsvd12 : 1;    // 25:25   Reserved
    uint32_t rsvd13 : 1;    // 26:26   Reserved
    uint32_t rsvd14 : 1;    // 27:27   Reserved
    uint32_t rsvd15 : 1;    // 28:28   Reserved
    uint32_t rsvd16 : 1;    // 29:29   Reserved
    uint32_t rsvd17 : 1;    // 30:30   Reserved
    uint32_t rsvd18 : 1;    // 31:31   Reserved
};

union GPB_INTSTATUS_REG {
    uint32_t                  all;
    struct GPB_INTSTATUS_BITS bit;
};

//
// AIO  Interrrupt type (AIO2 to 14)
//
struct AIO_INTTYPE_BITS { // bits   description
    uint32_t rsvd1 : 2;   // 1:0   Reserved
    uint32_t AIO2 : 1;    // 2:2   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd2 : 1; // 3:3   Reserved
    uint32_t AIO4 : 1;  // 4:4   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd3 : 1; // 5:5   Reserved
    uint32_t AIO6 : 1;  // 6:6   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd4 : 3; // 9:7   Reserved
    uint32_t AIO10 : 1; // 10:10   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd5 : 1; // 11:11   Reserved
    uint32_t AIO12 : 1; // 12:12   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd6 : 1; // 13:13   Reserved
    uint32_t AIO14 : 1; // 14:14   type of interrupt for gpio  ;  0 : level (high or low)  ;  1 : edge (rise or fall)

    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIO_INTTYPE_REG {
    uint32_t                all;
    struct AIO_INTTYPE_BITS bit;
};

//
// AIO  Interrrupt polarity (AIO2 to 14)
//
struct AIO_INTPOL_BITS { // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd2 : 1; // 3:3   Reserved
    uint32_t AIO4 : 1;  // 4:4   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd3 : 1; // 5:5   Reserved
    uint32_t AIO6 : 1;  // 6:6   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd4 : 3; // 9:7   Reserved
    uint32_t AIO10 : 1; // 10:10   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd5 : 1; // 11:11   Reserved
    uint32_t AIO12 : 1; // 12:12   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd6 : 1; // 13:13   Reserved
    uint32_t AIO14 : 1; // 14:14   polarity of interrupt for gpio  ;  0 : low level or fall edge  ;  1 : high level or rise edge

    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIO_INTPOL_REG {
    uint32_t               all;
    struct AIO_INTPOL_BITS bit;
};

//
// AIO  Interrrupt mask (AIO2 to 14)
//
struct AIO_INTMASK_BITS { // bits   description
    uint32_t rsvd1 : 2;   // 1:0   Reserved
    uint32_t AIO2 : 1;    // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd2 : 1; // 3:3   Reserved
    uint32_t AIO4 : 1;  // 4:4   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd3 : 1; // 5:5   Reserved
    uint32_t AIO6 : 1;  // 6:6   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd4 : 3; // 9:7   Reserved
    uint32_t AIO10 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd5 : 1; // 11:11   Reserved
    uint32_t AIO12 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd6 : 1; // 13:13   Reserved
    uint32_t AIO14 : 1; // 14:14   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIO_INTMASK_REG {
    uint32_t                all;
    struct AIO_INTMASK_BITS bit;
};

//
// AIO  Interrrupt clear (AIO2 to 14)
//
struct AIO_INTCLR_BITS { // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd2 : 1; // 3:3   Reserved
    uint32_t AIO4 : 1;  // 4:4   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd3 : 1; // 5:5   Reserved
    uint32_t AIO6 : 1;  // 6:6   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd4 : 3; // 9:7   Reserved
    uint32_t AIO10 : 1; // 10:10   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd5 : 1; // 11:11   Reserved
    uint32_t AIO12 : 1; // 12:12   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd6 : 1; // 13:13   Reserved
    uint32_t AIO14 : 1; // 14:14   mask of interrupt for gpio  ;  0 : mask the int ;  1 : unmask the int

    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIO_INTCLR_REG {
    uint32_t               all;
    struct AIO_INTCLR_BITS bit;
};

//
// AIO  Interrrupt status (AIO2 to 14)
//
struct AIO_INTSTATUS_BITS { // bits   description
    uint32_t rsvd1 : 2;     // 1:0   Reserved
    uint32_t AIO2 : 1;      // 2:2   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd2 : 1;     // 3:3   Reserved
    uint32_t AIO4 : 1;      // 4:4   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd3 : 1;     // 5:5   Reserved
    uint32_t AIO6 : 1;      // 6:6   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd4 : 3;     // 9:7   Reserved
    uint32_t AIO10 : 1;     // 10:10   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd5 : 1;     // 11:11   Reserved
    uint32_t AIO12 : 1;     // 12:12   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd6 : 1;     // 13:13   Reserved
    uint32_t AIO14 : 1;     // 14:14   status interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;
    uint32_t rsvd7 : 17;    // 31:15   Reserved
};

union AIO_INTSTATUS_REG {
    uint32_t                  all;
    struct AIO_INTSTATUS_BITS bit;
};

//
// auxclkin selection
//
struct AUXCLKIN_SEL_BITS {     // bits   description
    uint32_t AUXCLKIN_SEL : 1; // 0:0   auxclkin Signal source selection (meaningful when the model is 28035/28027; otherwise, the signal source is gpio29)
    uint32_t rsvd1 : 31;       // 31:1   Reserved
};

union AUXCLKIN_SEL_REG {
    uint32_t                 all;
    struct AUXCLKIN_SEL_BITS bit;
};

//
// auxclkin enable
//
struct AUXCLKIN_EN_BITS {     // bits   description
    uint32_t AUXCLKIN_EN : 1; // 0:0   auxclkin enable (meaningful when the model is 28035/28027; otherwise, the signal source is gpio29)
    uint32_t rsvd1 : 31;      // 31:1   Reserved
};

union AUXCLKIN_EN_REG {
    uint32_t                all;
    struct AUXCLKIN_EN_BITS bit;
};

//
// AIO  Interrrupt raw (AIO2 to 14)
//
struct AIO_INTRAW_BITS { // bits   description
    uint32_t rsvd1 : 2;  // 1:0   Reserved
    uint32_t AIO2 : 1;   // 2:2   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd2 : 1;  // 3:3   Reserved
    uint32_t AIO4 : 1;   // 4:4   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd3 : 1;  // 5:5   Reserved
    uint32_t AIO6 : 1;   // 6:6   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd4 : 3;  // 9:7   Reserved
    uint32_t AIO10 : 1;  // 10:10   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd5 : 1;  // 11:11   Reserved
    uint32_t AIO12 : 1;  // 12:12   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd6 : 1;  // 13:13   Reserved
    uint32_t AIO14 : 1;  // 14:14   raw  interrupt of gpio  ; read-->   0 : interrupt is not generated ; 1 :  interrupt is generated ;  level
    uint32_t rsvd7 : 17; // 31:15   Reserved
};

union AIO_INTRAW_REG {
    uint32_t               all;
    struct AIO_INTRAW_BITS bit;
};

struct GPIO_CTRL_REGS {
    union GPACTRL_REG   GPACTRL;
    union GPAQSEL1_REG  GPAQSEL1;
    union GPAQSEL2_REG  GPAQSEL2;
    union GPAMUX1_REG   GPAMUX1; // GPIO A Mux 1 Register (GPIO0 to 15)
    union GPAMUX2_REG   GPAMUX2; // GPIO A Mux 2 Register (GPIO16 to 31)
    union GPADIR_REG    GPADIR;  // GPIO A Direction Register (GPIO0 to 31)
    union GPAPUD_REG    GPAPUD;
    uint32_t            rsvd1;  // Reserved
    union GPBCTRL_REG   GPBCTRL; // GPIO B Control Register (GPIO32 to 44)
    union GPBQSEL1_REG  GPBQSEL1;
    uint32_t            rsvd2;  // Reserved
    union GPBMUX1_REG   GPBMUX1; // GPIO B Mux 1 Register (GPIO32 to 44)
    uint32_t            rsvd3;  // Reserved
    union GPBDIR_REG    GPBDIR;  // GPIO B Direction Register (GPIO32 to 44)
    union GPBPUD_REG    GPBPUD;
    uint32_t            rsvd4[9]; // Reserved
    union AIOCTRL_REG   AIOCTRL;
    union AIOQSEL1_REG  AIOQSEL1;
    uint32_t            rsvd5;  // Reserved
    union AIOMUX1_REG   AIOMUX1; // Analog IO Mux 1 Register (AIO0 to 15)
    union AIODS1_REG    AIODS1;
    union AIODIR_REG    AIODIR;  // Analog IO Direction Register (AIO0 to 15)
    union AIOMUX2_REG   AIOMUX2; // Analog IO Mux 2 Register (AIO0 to 15)
    union AIOLOOPEN_REG AIOLOOPEN;
};

struct GPIO_DATA_REGS {
    union GPADAT_REG    GPADAT;
    union GPASET_REG    GPASET;
    union GPACLEAR_REG  GPACLEAR;
    union GPATOGGLE_REG GPATOGGLE;

    union GPBDAT_REG    GPBDAT;
    union GPBSET_REG    GPBSET;
    union GPBCLEAR_REG  GPBCLEAR;
    union GPBTOGGLE_REG GPBTOGGLE;
    uint32_t            rsvd6[4]; // Reserved
    union AIODAT_REG    AIODAT;
    union AIOSET_REG    AIOSET;
    union AIOCLEAR_REG  AIOCLEAR;
    union AIOTOGGLE_REG AIOTOGGLE;
};

struct GPIO_INT_REGS {
    union GPIOXINT1SEL_REG GPIOXINT1SEL;
    union GPIOXINT2SEL_REG GPIOXINT2SEL;
    union GPIOXINT3SEL_REG GPIOXINT3SEL;
    uint16_t               rsvd7[5]; // Reserved
    union GPIOLPMSEL_REG   GPIOLPMSEL;
    uint32_t               rsvd8[75]; // Reserved
    union GPA_INTTYPE_REG      GPA_INTTYPE;
    union GPA_INTPOL_REG       GPA_INTPOL;
    union GPA_INTMASK_REG      GPA_INTMASK;
    union GPA_INTCLR_REG       GPA_INTCLR;
    union GPA_INTRAW_REG       GPA_INTRAW;
    union GPA_INTSTATUS_REG    GPA_INTSTATUS;

    union GPB_INTTYPE_REG      GPB_INTTYPE;
    union GPB_INTPOL_REG       GPB_INTPOL;
    union GPB_INTMASK_REG      GPB_INTMASK;
    union GPB_INTCLR_REG       GPB_INTCLR;
    union GPB_INTRAW_REG       GPB_INTRAW;
    union GPB_INTSTATUS_REG    GPB_INTSTATUS;
    uint32_t               rsvd9[12]; // Reserved
    union AIO_INTTYPE_REG      AIO_INTTYPE;
    union AIO_INTPOL_REG       AIO_INTPOL;
    union AIO_INTMASK_REG      AIO_INTMASK;
    union AIO_INTCLR_REG       AIO_INTCLR;
    union AIO_INTRAW_REG       AIO_INTSTATUS;
    union AIO_INTSTATUS_REG    AIO_INTRAW;

};


#endif

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/**
 * \brief   "add brief description of this function"
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif	//IS_GS32F00xx(0x30)

#endif // end of REGS_IO_CFG_PA_H definition

/* ========================================================================== */
/*                                  End of file                               */
/* ========================================================================== */
