/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
 *  @file    regs_outputxbar.h
 *  @brief
 *  Commit History
 *  20240416, Jason, add support for 1.1ES
*/

#ifndef REGS_OUTPUT_XBAR_H
#define REGS_OUTPUT_XBAR_H

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif


//---------------------------------------------------------------------------
// OUTPUT_XBAR Individual Register Bit Definitions:

struct OUTPUT1MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT1 of OUTPUT-XBAR
};

union OUTPUT1MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT1MUX0TO15CFG_BITS  bit;
};

struct OUTPUT1MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT1 of OUTPUT-XBAR
};

union OUTPUT1MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT1MUX16TO31CFG_BITS  bit;
};

struct OUTPUT2MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT2 of OUTPUT-XBAR
};

union OUTPUT2MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT2MUX0TO15CFG_BITS  bit;
};

struct OUTPUT2MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT2 of OUTPUT-XBAR
};

union OUTPUT2MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT2MUX16TO31CFG_BITS  bit;
};

struct OUTPUT3MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT3 of OUTPUT-XBAR
};

union OUTPUT3MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT3MUX0TO15CFG_BITS  bit;
};

struct OUTPUT3MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT3 of OUTPUT-XBAR
};

union OUTPUT3MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT3MUX16TO31CFG_BITS  bit;
};

struct OUTPUT4MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT4 of OUTPUT-XBAR
};

union OUTPUT4MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT4MUX0TO15CFG_BITS  bit;
};

struct OUTPUT4MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT4 of OUTPUT-XBAR
};

union OUTPUT4MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT4MUX16TO31CFG_BITS  bit;
};

struct OUTPUT5MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT5 of OUTPUT-XBAR
};

union OUTPUT5MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT5MUX0TO15CFG_BITS  bit;
};

struct OUTPUT5MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT5 of OUTPUT-XBAR
};

union OUTPUT5MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT5MUX16TO31CFG_BITS  bit;
};

struct OUTPUT6MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT6 of OUTPUT-XBAR
};

union OUTPUT6MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT6MUX0TO15CFG_BITS  bit;
};

struct OUTPUT6MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT6 of OUTPUT-XBAR
};

union OUTPUT6MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT6MUX16TO31CFG_BITS  bit;
};

struct OUTPUT7MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT7 of OUTPUT-XBAR
};

union OUTPUT7MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT7MUX0TO15CFG_BITS  bit;
};

struct OUTPUT7MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT7 of OUTPUT-XBAR
};

union OUTPUT7MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT7MUX16TO31CFG_BITS  bit;
};

struct OUTPUT8MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 Mux0 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX1:2;                      // 3:2 Mux1 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX2:2;                      // 5:4 Mux2 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX3:2;                      // 7:6 Mux3 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX4:2;                      // 9:8 Mux4 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX5:2;                      // 11:10 Mux5 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX6:2;                      // 13:12 Mux6 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX7:2;                      // 15:14 Mux7 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX8:2;                      // 17:16 Mux8 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX9:2;                      // 19:18 Mux9 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX10:2;                     // 21:20 Mux10 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX11:2;                     // 23:22 Mux11 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX12:2;                     // 25:24 Mux12 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX13:2;                     // 27:26 Mux13 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX14:2;                     // 29:28 Mux14 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX15:2;                     // 31:30 Mux15 Configuration for OUTPUT8 of OUTPUT-XBAR
};

union OUTPUT8MUX0TO15CFG_REG {
    uint32_t  all;
    struct  OUTPUT8MUX0TO15CFG_BITS  bit;
};

struct OUTPUT8MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 Mux16 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX17:2;                     // 3:2 Mux17 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX18:2;                     // 5:4 Mux18 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX19:2;                     // 7:6 Mux19 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX20:2;                     // 9:8 Mux20 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX21:2;                     // 11:10 Mux21 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX22:2;                     // 13:12 Mux22 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX23:2;                     // 15:14 Mux23 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX24:2;                     // 17:16 Mux24 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX25:2;                     // 19:18 Mux25 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX26:2;                     // 21:20 Mux26 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX27:2;                     // 23:22 Mux27 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX28:2;                     // 25:24 Mux28 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX29:2;                     // 27:26 Mux29 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX30:2;                     // 29:28 Mux30 Configuration for OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX31:2;                     // 31:30 Mux31 Configuration for OUTPUT8 of OUTPUT-XBAR
};

union OUTPUT8MUX16TO31CFG_REG {
    uint32_t  all;
    struct  OUTPUT8MUX16TO31CFG_BITS  bit;
};

struct OUTPUT1MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT1 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT1 of OUTPUT-XBAR
};

union OUTPUT1MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT1MUXENABLE_BITS  bit;
};

struct OUTPUT2MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT2 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT2 of OUTPUT-XBAR
};

union OUTPUT2MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT2MUXENABLE_BITS  bit;
};

struct OUTPUT3MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT3 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT3 of OUTPUT-XBAR
};

union OUTPUT3MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT3MUXENABLE_BITS  bit;
};

struct OUTPUT4MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT4 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT4 of OUTPUT-XBAR
};

union OUTPUT4MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT4MUXENABLE_BITS  bit;
};

struct OUTPUT5MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT5 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT5 of OUTPUT-XBAR
};

union OUTPUT5MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT5MUXENABLE_BITS  bit;
};

struct OUTPUT6MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT6 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT6 of OUTPUT-XBAR
};

union OUTPUT6MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT6MUXENABLE_BITS  bit;
};

struct OUTPUT7MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT7 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT7 of OUTPUT-XBAR
};

union OUTPUT7MUXENABLE_REG {
    uint16_t  all;
    struct  OUTPUT7MUXENABLE_BITS  bit;
};

struct OUTPUT8MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 Mux0 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX1:1;                      // 1 Mux1 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX2:1;                      // 2 Mux2 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX3:1;                      // 3 Mux3 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX4:1;                      // 4 Mux4 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX5:1;                      // 5 Mux5 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX6:1;                      // 6 Mux6 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX7:1;                      // 7 Mux7 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX8:1;                      // 8 Mux8 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX9:1;                      // 9 Mux9 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX10:1;                     // 10 Mux10 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX11:1;                     // 11 Mux11 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX12:1;                     // 12 Mux12 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX13:1;                     // 13 Mux13 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX14:1;                     // 14 Mux14 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX15:1;                     // 15 Mux15 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX16:1;                     // 16 Mux16 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX17:1;                     // 17 Mux17 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX18:1;                     // 18 Mux18 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX19:1;                     // 19 Mux19 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX20:1;                     // 20 Mux20 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX21:1;                     // 21 Mux21 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX22:1;                     // 22 Mux22 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX23:1;                     // 23 Mux23 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX24:1;                     // 24 Mux24 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX25:1;                     // 25 Mux25 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX26:1;                     // 26 Mux26 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX27:1;                     // 27 Mux27 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX28:1;                     // 28 Mux28 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX29:1;                     // 29 Mux29 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX30:1;                     // 30 Mux30 to drive OUTPUT8 of OUTPUT-XBAR
    uint32_t MUX31:1;                     // 31 Mux31 to drive OUTPUT8 of OUTPUT-XBAR
};

union OUTPUT8MUXENABLE_REG {
    uint32_t  all;
    struct  OUTPUT8MUXENABLE_BITS  bit;
};

/**add mux32-mux64 base GS32F3xx*/
struct OUTPUT1MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT1MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT1MUX32TO47CFG_BITS  bit;
};

struct OUTPUT1MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT1MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT1MUX48TO63CFG_BITS  bit;
};

struct OUTPUT2MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT2MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT2MUX32TO47CFG_BITS  bit;
};

struct OUTPUT2MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT2MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT2MUX48TO63CFG_BITS  bit;
};

struct OUTPUT3MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT3MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT3MUX32TO47CFG_BITS  bit;
};

struct OUTPUT3MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT3MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT3MUX48TO63CFG_BITS  bit;
};

struct OUTPUT4MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT4MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT4MUX32TO47CFG_BITS  bit;
};

struct OUTPUT4MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT4MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT4MUX48TO63CFG_BITS  bit;
};

struct OUTPUT5MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT5MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT5MUX32TO47CFG_BITS  bit;
};

struct OUTPUT5MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT5MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT5MUX48TO63CFG_BITS  bit;
};

struct OUTPUT6MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT6MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT6MUX32TO47CFG_BITS  bit;
};

struct OUTPUT6MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT6MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT6MUX48TO63CFG_BITS  bit;
};

struct OUTPUT7MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT7MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT7MUX32TO47CFG_BITS  bit;
};

struct OUTPUT7MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT7MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT7MUX48TO63CFG_BITS  bit;
};

struct OUTPUT8MUX32TO47CFG_BITS {
    uint32_t MUX32:2;
    uint32_t MUX33:2;
    uint32_t MUX34:2;
    uint32_t MUX35:2;
    uint32_t MUX36:2;
    uint32_t MUX37:2;
    uint32_t MUX38:2;
    uint32_t MUX39:2;
    uint32_t MUX40:2;
    uint32_t MUX41:2;
    uint32_t MUX42:2;
    uint32_t MUX43:2;
    uint32_t MUX44:2;
    uint32_t MUX45:2;
    uint32_t MUX46:2;
    uint32_t MUX47:2;
};

union OUTPUT8MUX32TO47CFG_REG {
    uint32_t  all;
    struct  OUTPUT8MUX32TO47CFG_BITS  bit;
};

struct OUTPUT8MUX48TO63CFG_BITS {
    uint32_t MUX48:2;
    uint32_t MUX49:2;
    uint32_t MUX50:2;
    uint32_t MUX51:2;
    uint32_t MUX52:2;
    uint32_t MUX53:2;
    uint32_t MUX54:2;
    uint32_t MUX55:2;
    uint32_t MUX56:2;
    uint32_t MUX57:2;
    uint32_t MUX58:2;
    uint32_t MUX59:2;
    uint32_t MUX60:2;
    uint32_t MUX61:2;
    uint32_t MUX62:2;
    uint32_t MUX63:2;
};

union OUTPUT8MUX48TO63CFG_REG {
    uint32_t  all;
    struct  OUTPUT8MUX48TO63CFG_BITS  bit;
};

//MUX ENABLE
struct OUTPUT1MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT1MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT1MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT2MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT2MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT2MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT3MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT3MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT3MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT4MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT4MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT4MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT5MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT5MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT5MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT6MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT6MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT6MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT7MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT7MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT7MUXENABLE32TO64_BITS  bit;
};

struct OUTPUT8MUXENABLE32TO64_BITS {
    uint32_t MUX32:1;
    uint32_t MUX33:1;
    uint32_t MUX34:1;
    uint32_t MUX35:1;
    uint32_t MUX36:1;
    uint32_t MUX37:1;
    uint32_t MUX38:1;
    uint32_t MUX39:1;
    uint32_t MUX40:1;
    uint32_t MUX41:1;
    uint32_t MUX42:1;
    uint32_t MUX43:1;
    uint32_t MUX44:1;
    uint32_t MUX45:1;
    uint32_t MUX46:1;
    uint32_t MUX47:1;
    uint32_t MUX48:1;
    uint32_t MUX49:1;
    uint32_t MUX50:1;
    uint32_t MUX51:1;
    uint32_t MUX52:1;
    uint32_t MUX53:1;
    uint32_t MUX54:1;
    uint32_t MUX55:1;
    uint32_t MUX56:1;
    uint32_t MUX57:1;
    uint32_t MUX58:1;
    uint32_t MUX59:1;
    uint32_t MUX60:1;
    uint32_t MUX61:1;
    uint32_t MUX62:1;
    uint32_t MUX63:1;
};

union OUTPUT8MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  OUTPUT8MUXENABLE32TO64_BITS  bit;
};

struct OUTPUTLATCH_BITS {               // bits description
    uint32_t OUTPUT1:1;                   // 0 Records the OUTPUT1 of OUTPUT-XBAR
    uint32_t OUTPUT2:1;                   // 1 Records the OUTPUT2 of OUTPUT-XBAR
    uint32_t OUTPUT3:1;                   // 2 Records the OUTPUT3 of OUTPUT-XBAR
    uint32_t OUTPUT4:1;                   // 3 Records the OUTPUT4 of OUTPUT-XBAR
    uint32_t OUTPUT5:1;                   // 4 Records the OUTPUT5 of OUTPUT-XBAR
    uint32_t OUTPUT6:1;                   // 5 Records the OUTPUT6 of OUTPUT-XBAR
    uint32_t OUTPUT7:1;                   // 6 Records the OUTPUT7 of OUTPUT-XBAR
    uint32_t OUTPUT8:1;                   // 7 Records the OUTPUT8 of OUTPUT-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union OUTPUTLATCH_REG {
    uint32_t  all;
    struct  OUTPUTLATCH_BITS  bit;
};

struct OUTPUTLATCHCLR_BITS {            // bits description
    uint32_t OUTPUT1:1;                   // 0 Clears the Output-Latch for OUTPUT1 of OUTPUT-XBAR
    uint32_t OUTPUT2:1;                   // 1 Clears the Output-Latch for OUTPUT2 of OUTPUT-XBAR
    uint32_t OUTPUT3:1;                   // 2 Clears the Output-Latch for OUTPUT3 of OUTPUT-XBAR
    uint32_t OUTPUT4:1;                   // 3 Clears the Output-Latch for OUTPUT4 of OUTPUT-XBAR
    uint32_t OUTPUT5:1;                   // 4 Clears the Output-Latch for OUTPUT5 of OUTPUT-XBAR
    uint32_t OUTPUT6:1;                   // 5 Clears the Output-Latch for OUTPUT6 of OUTPUT-XBAR
    uint32_t OUTPUT7:1;                   // 6 Clears the Output-Latch for OUTPUT7 of OUTPUT-XBAR
    uint32_t OUTPUT8:1;                   // 7 Clears the Output-Latch for OUTPUT8 of OUTPUT-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union OUTPUTLATCHCLR_REG {
    uint32_t  all;
    struct  OUTPUTLATCHCLR_BITS  bit;
};

struct OUTPUTLATCHFRC_BITS {            // bits description
    uint32_t OUTPUT1:1;                   // 0 Sets the Output-Latch for OUTPUT1 of OUTPUT-XBAR
    uint32_t OUTPUT2:1;                   // 1 Sets the Output-Latch for OUTPUT2 of OUTPUT-XBAR
    uint32_t OUTPUT3:1;                   // 2 Sets the Output-Latch for OUTPUT3 of OUTPUT-XBAR
    uint32_t OUTPUT4:1;                   // 3 Sets the Output-Latch for OUTPUT4 of OUTPUT-XBAR
    uint32_t OUTPUT5:1;                   // 4 Sets the Output-Latch for OUTPUT5 of OUTPUT-XBAR
    uint32_t OUTPUT6:1;                   // 5 Sets the Output-Latch for OUTPUT6 of OUTPUT-XBAR
    uint32_t OUTPUT7:1;                   // 6 Sets the Output-Latch for OUTPUT7 of OUTPUT-XBAR
    uint32_t OUTPUT8:1;                   // 7 Sets the Output-Latch for OUTPUT8 of OUTPUT-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union OUTPUTLATCHFRC_REG {
    uint32_t  all;
    struct  OUTPUTLATCHFRC_BITS  bit;
};

struct OUTPUTLATCHENABLE_BITS {         // bits description
    uint32_t OUTPUT1:1;                   // 0 Selects the output latch to drive OUTPUT1 for OUTPUT-XBAR
    uint32_t OUTPUT2:1;                   // 1 Selects the output latch to drive OUTPUT2 for OUTPUT-XBAR
    uint32_t OUTPUT3:1;                   // 2 Selects the output latch to drive OUTPUT3 for OUTPUT-XBAR
    uint32_t OUTPUT4:1;                   // 3 Selects the output latch to drive OUTPUT4 for OUTPUT-XBAR
    uint32_t OUTPUT5:1;                   // 4 Selects the output latch to drive OUTPUT5 for OUTPUT-XBAR
    uint32_t OUTPUT6:1;                   // 5 Selects the output latch to drive OUTPUT6 for OUTPUT-XBAR
    uint32_t OUTPUT7:1;                   // 6 Selects the output latch to drive OUTPUT7 for OUTPUT-XBAR
    uint32_t OUTPUT8:1;                   // 7 Selects the output latch to drive OUTPUT8 for OUTPUT-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union OUTPUTLATCHENABLE_REG {
    uint32_t  all;
    struct  OUTPUTLATCHENABLE_BITS  bit;
};

struct OUTPUTINV_BITS {                 // bits description
    uint32_t OUTPUT1:1;                   // 0 Selects polarity for OUTPUT1 of OUTPUT-XBAR
    uint32_t OUTPUT2:1;                   // 1 Selects polarity for OUTPUT2 of OUTPUT-XBAR
    uint32_t OUTPUT3:1;                   // 2 Selects polarity for OUTPUT3 of OUTPUT-XBAR
    uint32_t OUTPUT4:1;                   // 3 Selects polarity for OUTPUT4 of OUTPUT-XBAR
    uint32_t OUTPUT5:1;                   // 4 Selects polarity for OUTPUT5 of OUTPUT-XBAR
    uint32_t OUTPUT6:1;                   // 5 Selects polarity for OUTPUT6 of OUTPUT-XBAR
    uint32_t OUTPUT7:1;                   // 6 Selects polarity for OUTPUT7 of OUTPUT-XBAR
    uint32_t OUTPUT8:1;                   // 7 Selects polarity for OUTPUT8 of OUTPUT-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union OUTPUTINV_REG {
    uint32_t  all;
    struct  OUTPUTINV_BITS  bit;
};

struct OUTPUTLOCK_BITS {                // bits description
    uint32_t LOCK:1;                      // 0 Locks the configuration for OUTPUT-XBAR
    uint32_t rsvd1:15;                    // 15:1 Reserved
    uint32_t KEY:16;                      // 31:16 Write Protection KEY
};

union OUTPUTLOCK_REG {
    uint32_t  all;
    struct  OUTPUTLOCK_BITS  bit;
};

struct OUTPUT_XBAR_REGS {
    union   OUTPUT1MUX0TO15CFG_REG           OUTPUT1MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 1
    union   OUTPUT1MUX16TO31CFG_REG          OUTPUT1MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 1
    union   OUTPUT2MUX0TO15CFG_REG           OUTPUT2MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 2
    union   OUTPUT2MUX16TO31CFG_REG          OUTPUT2MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 2
    union   OUTPUT3MUX0TO15CFG_REG           OUTPUT3MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 3
    union   OUTPUT3MUX16TO31CFG_REG          OUTPUT3MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 3
    union   OUTPUT4MUX0TO15CFG_REG           OUTPUT4MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 4
    union   OUTPUT4MUX16TO31CFG_REG          OUTPUT4MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 4
    union   OUTPUT5MUX0TO15CFG_REG           OUTPUT5MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 5
    union   OUTPUT5MUX16TO31CFG_REG          OUTPUT5MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 5
    union   OUTPUT6MUX0TO15CFG_REG           OUTPUT6MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 6
    union   OUTPUT6MUX16TO31CFG_REG          OUTPUT6MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 6
    union   OUTPUT7MUX0TO15CFG_REG           OUTPUT7MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 7
    union   OUTPUT7MUX16TO31CFG_REG          OUTPUT7MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 7
    union   OUTPUT8MUX0TO15CFG_REG           OUTPUT8MUX0TO15CFG;           // Output X-BAR Mux Configuration for Output 8
    union   OUTPUT8MUX16TO31CFG_REG          OUTPUT8MUX16TO31CFG;          // Output X-BAR Mux Configuration for Output 8
    union   OUTPUT1MUXENABLE_REG             OUTPUT1MUXENABLE;             // Output X-BAR Mux Enable  for Output 1
    union   OUTPUT2MUXENABLE_REG             OUTPUT2MUXENABLE;             // Output X-BAR Mux Enable  for Output 2
    union   OUTPUT3MUXENABLE_REG             OUTPUT3MUXENABLE;             // Output X-BAR Mux Enable  for Output 3
    union   OUTPUT4MUXENABLE_REG             OUTPUT4MUXENABLE;             // Output X-BAR Mux Enable  for Output 4
    union   OUTPUT5MUXENABLE_REG             OUTPUT5MUXENABLE;             // Output X-BAR Mux Enable  for Output 5
    union   OUTPUT6MUXENABLE_REG             OUTPUT6MUXENABLE;             // Output X-BAR Mux Enable  for Output 6
    union   OUTPUT7MUXENABLE_REG             OUTPUT7MUXENABLE;             // Output X-BAR Mux Enable  for Output 7
    union   OUTPUT8MUXENABLE_REG             OUTPUT8MUXENABLE;             // Output X-BAR Mux Enable  for Output 8
    union   OUTPUTLATCH_REG                  OUTPUTLATCH;                  // Output X-BAR Output Latch
    union   OUTPUTLATCHCLR_REG               OUTPUTLATCHCLR;               // Output X-BAR Output Latch Clear
    union   OUTPUTLATCHFRC_REG               OUTPUTLATCHFRC;               // Output X-BAR Output Latch Clear
    union   OUTPUTLATCHENABLE_REG            OUTPUTLATCHENABLE;            // Output X-BAR Output Latch Enable
    union   OUTPUTINV_REG                    OUTPUTINV;                    // Output X-BAR Output Inversion

    uint32_t                                   rsvd1[3];

    union   OUTPUT1MUX32TO47CFG_REG          OUTPUT1MUX32TO47CFG;
    union   OUTPUT1MUX48TO63CFG_REG          OUTPUT1MUX48TO63CFG;
    union   OUTPUT2MUX32TO47CFG_REG          OUTPUT2MUX32TO47CFG;
    union   OUTPUT2MUX48TO63CFG_REG          OUTPUT2MUX48TO63CFG;
    union   OUTPUT3MUX32TO47CFG_REG          OUTPUT3MUX32TO47CFG;
    union   OUTPUT3MUX48TO63CFG_REG          OUTPUT3MUX48TO63CFG;
    union   OUTPUT4MUX32TO47CFG_REG          OUTPUT4MUX32TO47CFG;
    union   OUTPUT4MUX48TO63CFG_REG          OUTPUT4MUX48TO63CFG;
    union   OUTPUT5MUX32TO47CFG_REG          OUTPUT5MUX32TO47CFG;
    union   OUTPUT5MUX48TO63CFG_REG          OUTPUT5MUX48TO63CFG;
    union   OUTPUT6MUX32TO47CFG_REG          OUTPUT6MUX32TO47CFG;
    union   OUTPUT6MUX48TO63CFG_REG          OUTPUT6MUX48TO63CFG;
    union   OUTPUT7MUX32TO47CFG_REG          OUTPUT7MUX32TO47CFG;
    union   OUTPUT7MUX48TO63CFG_REG          OUTPUT7MUX48TO63CFG;
    union   OUTPUT8MUX32TO47CFG_REG          OUTPUT8MUX32TO47CFG;
    union   OUTPUT8MUX48TO63CFG_REG          OUTPUT8MUX48TO63CFG;
    union   OUTPUT1MUXENABLE32TO64_REG       OUTPUT1MUXENABLE32TO64;
    union   OUTPUT2MUXENABLE32TO64_REG       OUTPUT2MUXENABLE32TO64;
    union   OUTPUT3MUXENABLE32TO64_REG       OUTPUT3MUXENABLE32TO64;
    union   OUTPUT4MUXENABLE32TO64_REG       OUTPUT4MUXENABLE32TO64;
    union   OUTPUT5MUXENABLE32TO64_REG       OUTPUT5MUXENABLE32TO64;
    union   OUTPUT6MUXENABLE32TO64_REG       OUTPUT6MUXENABLE32TO64;
    union   OUTPUT7MUXENABLE32TO64_REG       OUTPUT7MUXENABLE32TO64;
    union   OUTPUT8MUXENABLE32TO64_REG       OUTPUT8MUXENABLE32TO64;

    uint32_t                                   rsvd2[7];                     // Reserved
    union   OUTPUTLOCK_REG                   OUTPUTLOCK;                   // Output X-BAR Configuration Lock register


};

//---------------------------------------------------------------------------
// OUTPUT_XBAR External References & Function Declarations:
//
extern volatile struct OUTPUT_XBAR_REGS OutputXbarRegs;
extern volatile struct OUTPUT_XBAR_REGS PluOutputXbarRegs;
#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif

//===========================================================================
// End of file.
//===========================================================================
