/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_ptr.c
*   @brief   
*   @details
*
*   commit history
*   2024/03/12, Zhao Lei, Modify peripheral instances control
*
*/

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#if IS_GS32F00xx()
#include "device_gs32f00xx/gs32f00xx.h"
#endif
#if IS_GS32F3xx()
#include "device_gs32f3xx/gs32f3xx.h"
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/****************************************************************************
 *  Define pointer to Peripheral module registers structure
 ****************************************************************************/
/* ADC */
volatile struct ADC_REGS * const AdcaRegsPtr = ((volatile struct ADC_REGS *) ADCA_BASE);
volatile struct ADC_RESULT_REGS * const AdcaResultRegsPtr = ((volatile struct ADC_RESULT_REGS *) ADCARESULT_BASE);

#ifdef ADCD_BASE
volatile struct ADC_REGS * const AdcbRegsPtr = ((volatile struct ADC_REGS *) ADCB_BASE);
volatile struct ADC_RESULT_REGS * const AdcbResultRegsPtr = ((volatile struct ADC_RESULT_REGS *) ADCBRESULT_BASE);
#endif

volatile struct ADC_REGS * const AdccRegsPtr = ((volatile struct ADC_REGS *) ADCC_BASE);
volatile struct ADC_RESULT_REGS * const AdccResultRegsPtr = ((volatile struct ADC_RESULT_REGS *) ADCCRESULT_BASE);

#ifdef ADCD_BASE
volatile struct ADC_REGS * const AdcdRegsPtr = ((volatile struct ADC_REGS *) ADCD_BASE);
volatile struct ADC_RESULT_REGS * const AdcdResultRegsPtr = ((volatile struct ADC_RESULT_REGS *) ADCDRESULT_BASE);
#endif

/* ePWM */
volatile struct EPWM_REGS * const EPwm1RegsPtr = ((volatile struct EPWM_REGS *) EPWM1_BASE);
volatile struct EPWM_REGS * const EPwm2RegsPtr = ((volatile struct EPWM_REGS *) EPWM2_BASE);
volatile struct EPWM_REGS * const EPwm3RegsPtr = ((volatile struct EPWM_REGS *) EPWM3_BASE);
volatile struct EPWM_REGS * const EPwm4RegsPtr = ((volatile struct EPWM_REGS *) EPWM4_BASE);
volatile struct EPWM_REGS * const EPwm5RegsPtr = ((volatile struct EPWM_REGS *) EPWM5_BASE);
volatile struct EPWM_REGS * const EPwm6RegsPtr = ((volatile struct EPWM_REGS *) EPWM6_BASE);
volatile struct EPWM_REGS * const EPwm7RegsPtr = ((volatile struct EPWM_REGS *) EPWM7_BASE);
volatile struct EPWM_REGS * const EPwm8RegsPtr = ((volatile struct EPWM_REGS *) EPWM8_BASE);

#ifdef EPWM9_BASE
volatile struct EPWM_REGS * const EPwm9RegsPtr = ((volatile struct EPWM_REGS *) EPWM9_BASE);
#endif

#ifdef EPWM10_BASE
volatile struct EPWM_REGS * const EPwm10RegsPtr = ((volatile struct EPWM_REGS *) EPWM10_BASE);
#endif

#ifdef EPWM11_BASE
volatile struct EPWM_REGS * const EPwm11RegsPtr = ((volatile struct EPWM_REGS *) EPWM11_BASE);
#endif

#ifdef EPWM12_BASE
volatile struct EPWM_REGS * const EPwm12RegsPtr = ((volatile struct EPWM_REGS *) EPWM12_BASE);
#endif

#if 0
#define CMPSS1RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS1_BASE)
#define CMPSS2RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS2_BASE)
#define CMPSS3RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS3_BASE)
#define CMPSS4RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS4_BASE)
#define CMPSS5RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS5_BASE)
#define CMPSS6RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS6_BASE)
#define CMPSS7RegsPtr       ((volatile struct CMPSS_REGS *) CMPSS7_BASE)

#define EPwm1RegsPtr        ((volatile struct EPWM_REGS *) EPWM1_BASE)
#define EPwm2RegsPtr        ((volatile struct EPWM_REGS *) EPWM2_BASE)
#define EPwm3RegsPtr        ((volatile struct EPWM_REGS *) EPWM3_BASE)
#define EPwm4RegsPtr        ((volatile struct EPWM_REGS *) EPWM4_BASE)
#define EPwm5RegsPtr        ((volatile struct EPWM_REGS *) EPWM5_BASE)
#define EPwm6RegsPtr        ((volatile struct EPWM_REGS *) EPWM6_BASE)
#define EPwm7RegsPtr        ((volatile struct EPWM_REGS *) EPWM7_BASE)
#define EPwm8RegsPtr        ((volatile struct EPWM_REGS *) EPWM8_BASE)

#define EQep1RegsPtr        ((volatile struct EQEP_REGS *) EQEP1_BASE)
#define EQep2RegsPtr        ((volatile struct EQEP_REGS *) EQEP2_BASE)

#define ECap1RegsPtr        ((volatile struct ECAP_REGS *) ECAP1_BASE)
#define ECap2RegsPtr        ((volatile struct ECAP_REGS *) ECAP2_BASE)
#define ECap3RegsPtr        ((volatile struct ECAP_REGS *) ECAP3_BASE)
#define ECap4RegsPtr        ((volatile struct ECAP_REGS *) ECAP4_BASE)
#define ECap5RegsPtr        ((volatile struct ECAP_REGS *) ECAP5_BASE)
#define ECap6RegsPtr        ((volatile struct ECAP_REGS *) ECAP6_BASE)
#define ECap7RegsPtr        ((volatile struct ECAP_REGS *) ECAP7_BASE)
#endif

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         External Function Prototypes                       */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


#ifdef __cplusplus
}
#endif

