/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_xdma.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

/*
 * commit history
 * 20240308, LYF, verify for chip 2.0 and provide IP version.
 * 20240319, LYF, Organize XDMA and DMAMUX driver version management 
 * 20240322, LYF, translate source files to C source, ASCII text.
 * 20240513, LYF, code error in XDMA_clearInterrupt
 */


#ifndef REGS_XDMA_H
#define REGS_XDMA_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* none */

/* ========================================================================== */
/*                          Version defs                                      */
/* ========================================================================== */

//*****************************************************************************
//
//! The following are defines for the AXI DMAC VERSION.
//
//*****************************************************************************


#ifdef XDMAC_VERSION
#undef XDMAC_VERSION
#endif 

#include "gs32_version.h"

#if IS_GS32F3xx(0x22, 0x23)
#define XDMAC_VERSION            (0x22)
#else
#define XDMAC_VERSION            (0xFF)  // Not support.
#endif

#if (XDMAC_VERSION == 0x20 || XDMAC_VERSION == 0x22)

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// DMA Individual Register Bit Definitions:

struct XCOMID_L_BITS {           // bits   description
    uint32_t    ID:32;         // 31:0   DMAC ID Number.
};

union XCOMID_L_REG {
    uint32_t            all;
    struct XCOMID_L_BITS             bit;
};

struct XCOMID_H_BITS {            // bits   description
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XCOMID_H_REG {
    uint32_t            all;
    struct XCOMID_H_BITS          bit;
};

struct XVER_L_BITS {            // bits   description
    uint32_t    COMPVER:32;            // 31:0   DMAC Component Version Number.
};

union XVER_L_REG {
    uint32_t          all;
    struct XVER_L_BITS          bit;
};

struct XVER_H_BITS {            // bits   description
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XVER_H_REG {
    uint32_t          all;
    struct XVER_H_BITS          bit;
};

struct XCOMCFG_L_BITS {      
    // Enable the DW_axi_dmac controller
    // This bit is used to enable the DW_axi_dmac.
    // 1: (ENABLED): DW_axi_dmac is enabled
    // 0: (DISABLED): DW_axi_dmac is disabled
    uint32_t    EN:1;                               // 0
    
    // Enable the interrupt generation
    // This bit is used to globally enable the interrupt generation.    
    // 1: (ENABLED): DW_axi_dmac Interrupts are enabled
    // 0: (DISABLED): DW_axi_dmac Interrupts are disabled    
    uint32_t    INT_EN:1;                           // 1 
    uint32_t    rsvd1:30;                           // 31:2   reserved
};

union XCOMCFG_L_REG {
    uint32_t          all;
    struct XCOMCFG_L_BITS          bit;
};

struct XCOMCFG_H_BITS {            // bits   description
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XCOMCFG_H_REG {
    uint32_t          all;
    struct XCOMCFG_H_BITS          bit;
};

struct XCHNEN_L_SPLIT_BITS {        
    // Enable the DW_axi_dmac Channel-0.
    // 1: (ENABLE_CH0): DW_axi_dmac: Channel-0 is enabled
    // 0: (DISABLE_CH0): DW_axi_dmac: Channel-0 is disabled
    uint32_t    CHN0_EN:1;              // 0  
    
    // Enable the DW_axi_dmac Channel-1.
    // 1: (ENABLE_CH1): DW_axi_dmac: Channel-1 is enabled
    // 0: (DISABLE_CH1): DW_axi_dmac: Channel-1 is disabled
    uint32_t    CHN1_EN:1;              // 1  

    // Enable the DW_axi_dmac Channel-2.
    // 1: (ENABLE_CH2): DW_axi_dmac: Channel-2 is enabled
    // 0: (DISABLE_CH2): DW_axi_dmac: Channel-2 is disabled
    uint32_t    CHN2_EN:1;              // 2  

    // Enable the DW_axi_dmac Channel-3.
    // 1: (ENABLE_CH3): DW_axi_dmac: Channel-3 is enabled
    // 0: (DISABLE_CH3): DW_axi_dmac: Channel-3 is disabled
    uint32_t    CHN3_EN:1;              // 3  

    // Enable the DW_axi_dmac Channel-4.
    // 1: (ENABLE_CH4): DW_axi_dmac: Channel-4 is enabled
    // 0: (DISABLE_CH4): DW_axi_dmac: Channel-4 is disabled
    uint32_t    CHN4_EN:1;              // 4  

    // Enable the DW_axi_dmac Channel-5.
    // 1: (ENABLE_CH5): DW_axi_dmac: Channel-5 is enabled
    // 0: (DISABLE_CH5): DW_axi_dmac: Channel-5 is disabled
    uint32_t    CHN5_EN:1;              // 5  

    // Enable the DW_axi_dmac Channel-6.
    // 1: (ENABLE_CH6): DW_axi_dmac: Channel-6 is enabled
    // 0: (DISABLE_CH6): DW_axi_dmac: Channel-6 is disabled
    uint32_t    CHN6_EN:1;              // 6  

    // Enable the DW_axi_dmac Channel-7.
    // 1: (ENABLE_CH7): DW_axi_dmac: Channel-7 is enabled
    // 0: (DISABLE_CH7): DW_axi_dmac: Channel-7 is disabled
    uint32_t    CHN7_EN:1;              // 7  

    //  Channel-0 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 1: (ENABLE_WR_CH0_EN): Enable Write to CH0_EN bit      
    // 0: (DISABLE_WR_CH0_EN): Disable Write to respective CH0_EN bit
    uint32_t    CHN0_EN_WE:1;            // 8  

    //  Channel-1 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 0: (DISABLE_WR_CHx_EN): Disable Write to respective CHx_EN bit
    // 1: (ENABLE_WR_CHx_EN): Enable Write to CHx_EN bit   
    uint32_t    CHN1_EN_WE:1;            // 9  

    //  Channel-2 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 1: (ENABLE_WR_CH2_EN): Enable Write to CH2_EN bit
    // 0: (DISABLE_WR_CH2_EN): Disable Write to respective CH2_EN bit
    uint32_t    CHN2_EN_WE:1;            // 10  

    //  Channel-3 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 1: (ENABLE_WR_CH3_EN): Enable Write to CH3_EN bit  
    // 0: (DISABLE_WR_CH3_EN): Disable Write to respective CH3_EN bit
    uint32_t    CHN3_EN_WE:1;            // 11  

    // Channel-4 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 1: (ENABLE_WR_CH4_EN): Enable Write to CH4_EN bit   
    // 0: (DISABLE_WR_CH4_EN): Disable Write to respective CH4_EN bit
    uint32_t    CHN4_EN_WE:1;            // 12  

    // Channel-5 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 1: (ENABLE_WR_CH5_EN): Enable Write to CH5_EN bit  
    // 0: (DISABLE_WR_CH5_EN): Disable Write to respective CH5_EN bit
    uint32_t    CHN5_EN_WE:1;            // 13  

    // Channel-6 Enable Write Enable bit. 
    // 1: (ENABLE_WR_CH6_EN): Enable Write to CH6_EN bit   
    // Read back value of this register bit is always '0'.
    // 0: (DISABLE_WR_CH6_EN): Disable Write to respective CH6_EN bit
    uint32_t    CHN6_EN_WE:1;            // 14  

    // Channel-7 Enable Write Enable bit. 
    // Read back value of this register bit is always '0'.
    // 1: (ENABLE_WR_CH7_EN): Enable Write to CH7_EN bit   
    // 0: (DISABLE_WR_CH7_EN): Disable Write to respective CH7_EN bit
    uint32_t    CHN7_EN_WE:1;            // 15  

    // Channel-0 Suspend Request.
    // 1: (ENABLE_CH0_SUSP): Request to Suspended Channel-0
    // 0: (DISABLE_CH0_SUSP): No Channel Suspend Request    
    uint32_t    CHN0_SUSP:1;             // 16  

    // Channel-1 Suspend Request.
    // 1: (ENABLE_CHx_SUSP): Request to Suspended Channel-1
    // 0: (DISABLE_CHx_SUSP): No Channel Suspend Request    
    uint32_t    CHN1_SUSP:1;             // 17  

    // Channel-2 Suspend Request.
    // 1: (ENABLE_CH2_SUSP): Request to Suspended Channel-2
    // 0: (DISABLE_CH2_SUSP): No Channel Suspend Request    
    uint32_t    CHN2_SUSP:1;             // 18  

    // Channel-3 Suspend Request.
    // 1: (ENABLE_CH3_SUSP): Request to Suspended Channel-3
    // 0: (DISABLE_CH3_SUSP): No Channel Suspend Request   
    uint32_t    CHN3_SUSP:1;             // 19  
    
    // Channel-4 Suspend Request.
    // 1: (ENABLE_CH4_SUSP): Request to Suspended Channel-4
    // 0: (DISABLE_CH4_SUSP): No Channel Suspend Request   
    uint32_t    CHN4_SUSP:1;             // 20  

    // Channel-5 Suspend Request.
    // 1: (ENABLE_CH5_SUSP): Request to Suspended Channel-5
    // 0: (DISABLE_CH5_SUSP): No Channel Suspend Request   
    uint32_t    CHN5_SUSP:1;             // 21  

    // Channel-6 Suspend Request.
    // 1: (ENABLE_CH6_SUSP): Request to Suspended Channel-6
    // 0: (DISABLE_CH6_SUSP): No Channel Suspend Request    
    uint32_t    CHN6_SUSP:1;             // 22  

    // Channel-7 Suspend Request.
    // 1: (ENABLE_CH7_SUSP): Request to Suspended Channel-7
    // 0: (DISABLE_CH7_SUSP): No Channel Suspend Request       
    uint32_t    CHN7_SUSP:1;             // 23  

    // Channel-0 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH0_SUSP): Enable Write to respective CH0_SUSP bit
    // 0: (DISABLE_WR_CH0_SUSP): Disable Write to CH0_-SUSP bit
    uint32_t    CHN0_SUSP_WE:1;             // 24  

    // Channel-1 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CHx_SUSP): Enable Write to respective CHx_SUSP bit
    // 0: (DISABLE_WR_CHx_SUSP): Disable Write to CHx_-SUSP bit
    uint32_t    CHN1_SUSP_WE:1;             // 25  

    // Channel-2 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH2_SUSP): Enable Write to respective CH2_SUSP bit
    // 0: (DISABLE_WR_CH2_SUSP): Disable Write to CH2_-SUSP bit
    uint32_t    CHN2_SUSP_WE:1;             // 26  

    // Channel-3 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH3_SUSP): Enable Write to respective CH3_SUSP bit
    // 0: (DISABLE_WR_CH3_SUSP): Disable Write to CH3_-SUSP bit
    uint32_t    CHN3_SUSP_WE:1;             // 27  

    // Channel-4 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH4_SUSP): Enable Write to respective CH4_SUSP bit
    // 0: (DISABLE_WR_CH4_SUSP): Disable Write to CH4_-SUSP bit
    uint32_t    CHN4_SUSP_WE:1;             // 28  

    // Channel-5 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH5_SUSP): Enable Write to respective CH5_SUSP bit
    // 0: (DISABLE_WR_CH5_SUSP): Disable Write to CH5_-SUSP bit
    uint32_t    CHN5_SUSP_WE:1;             // 29  

    // Channel-6 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH6_SUSP): Enable Write to respective CH6_SUSP bit
    // 0: (DISABLE_WR_CH6_SUSP): Disable Write to CH6_-SUSP bit
    uint32_t    CHN6_SUSP_WE:1;             // 30  

    // Channel-7 Suspend Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH7_SUSP): Enable Write to respective CH7_SUSP bit
    // 0: (DISABLE_WR_CH7_SUSP): Disable Write to CH7_-SUSP bit
    uint32_t    CHN7_SUSP_WE:1;             // 31  
};

struct XCHNEN_L_BITS {        
    // Enable the DW_axi_dmac Channel-x.(x from 0 to 7)
    // For each bit from bit0 to bit7, value defined is below:
    // 1: (ENABLE_CHx): DW_axi_dmac: Channel-x is enabled
    // 0: (DISABLE_CHx): DW_axi_dmac: Channel-x is disabled
    // Channel-x Enable Write Enable bit. (x from 0 to 7) 
    // Read back value of this register bit is always '0'.
    // For each bit from bit8 tobit15, value defined is below:
    // 1: (ENABLE_WR_CHx_EN): Enable Write to CHx_EN bit      
    // 0: (DISABLE_WR_CHx_EN): Disable Write to respective CHx_EN bit
    uint32_t    CHN_EN:16;              // 15:0     


    // Channel-x Suspend Request. (x from 0 to 7)
    // For each bit from bit16 to bit23, value defined is below:
    // 1: (ENABLE_CHx_SUSP): Request to Suspended Channel-x
    // 0: (DISABLE_CHx_SUSP): No Channel Suspend Request    
    // Channel-x Suspend Enable Write Enable bit. (x from 0 to 7) 
    // The read back value of this register bit is always 0.
    // For each bit from bit24 to bit31, value defined is below:    
    // 1: (ENABLE_WR_CHx_SUSP): Enable Write to respective CHx_SUSP bit
    // 0: (DISABLE_WR_CHx_SUSP): Disable Write to CHx_-SUSP bit
    uint32_t    CHN_SUSP:16;             // 31:16  
};


union XCHNEN_L_REG {
    uint32_t          all;
    struct XCHNEN_L_SPLIT_BITS    spltBit;
    struct XCHNEN_L_BITS          bit;
};

struct XCHNEN_H_SPLIT_BITS {        
    // Channel-0 Terminate Request.
    // 0: (DISABLE_CH0_ABORT): No Request for Channel-0 Terminate
    // 1: (ENABLE_CH0_ABORT): Request for Channel-0 Terminate
    uint32_t    CHN0_ABORT:1;               // 0

    // Channel-1 Terminate Request.
    // 0: (DISABLE_CH1_ABORT): No Request for Channel-1 Terminate
    // 1: (ENABLE_CH1_ABORT): Request for Channel-1 Terminate
    uint32_t    CHN1_ABORT:1;               // 1

    // Channel-2 Terminate Request.
    // 0: (DISABLE_CH2_ABORT): No Request for Channel-2 Terminate
    // 1: (ENABLE_CH2_ABORT): Request for Channel-2 Terminate
    uint32_t    CHN2_ABORT:1;               // 2

    // Channel-3 Terminate Request.
    // 0: (DISABLE_CH3_ABORT): No Request for Channel-3 Terminate
    // 1: (ENABLE_CH3_ABORT): Request for Channel-3 Terminate
    uint32_t    CHN3_ABORT:1;               // 3

    // Channel-4 Terminate Request.
    // 0: (DISABLE_CH4_ABORT): No Request for Channel-4 Terminate
    // 1: (ENABLE_CH4_ABORT): Request for Channel-4 Terminate
    uint32_t    CHN4_ABORT:1;               // 4

    // Channel-5 Terminate Request.
    // 0: (DISABLE_CH5_ABORT): No Request for Channel-5 Terminate
    // 1: (ENABLE_CH5_ABORT): Request for Channel-5 Terminate
    uint32_t    CHN5_ABORT:1;               // 5

    // Channel-6 Terminate Request.
    // 0: (DISABLE_CH6_ABORT): No Request for Channel-6 Terminate
    // 1: (ENABLE_CH6_ABORT): Request for Channel-6 Terminate
    uint32_t    CHN6_ABORT:1;               // 6

    // Channel-7 Terminate Request.
    // 0: (DISABLE_CH7_ABORT): No Request for Channel-7 Terminate
    // 1: (ENABLE_CH7_ABORT): Request for Channel-7 Terminate
    uint32_t    CHN7_ABORT:1;               // 7

    // Channel-0 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH0_ABORT): Enable Write to CH0_ABORT bit
    // 0: (DISABLE_WR_CH0_ABORT): Disable Write to CH0_ABORT bit
    uint32_t    CHN0_ABORT_WE:1;               // 8

    // Channel-1 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH1_ABORT): Enable Write to CH1_ABORT bit
    // 0: (DISABLE_WR_CH1_ABORT): Disable Write to CH1_ABORT bit
    uint32_t    CHN1_ABORT_WE:1;               // 9

    // Channel-2 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH2_ABORT): Enable Write to CH2_ABORT bit
    // 0: (DISABLE_WR_CH2_ABORT): Disable Write to CH2_ABORT bit
    uint32_t    CHN2_ABORT_WE:1;               // 10

    // Channel-3 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH3_ABORT): Enable Write to CH3_ABORT bit
    // 0: (DISABLE_WR_CH3_ABORT): Disable Write to CH3_ABORT bit
    uint32_t    CHN3_ABORT_WE:1;               // 11

    // Channel-4 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH4_ABORT): Enable Write to CH4_ABORT bit
    // 0: (DISABLE_WR_CH4_ABORT): Disable Write to CH4_ABORT bit
    uint32_t    CHN4_ABORT_WE:1;               // 12

    // Channel-5 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH5_ABORT): Enable Write to CH5_ABORT bit
    // 0: (DISABLE_WR_CH5_ABORT): Disable Write to CH5_ABORT bit
    uint32_t    CHN5_ABORT_WE:1;               // 13

    // Channel-6 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH6_ABORT): Enable Write to CH6_ABORT bit
    // 0: (DISABLE_WR_CH6_ABORT): Disable Write to CH6_ABORT bit
    uint32_t    CHN6_ABORT_WE:1;               // 14

    // Channel-7 Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always 0.
    // 1: (ENABLE_WR_CH7_ABORT): Enable Write to CH7_ABORT bit
    // 0: (DISABLE_WR_CH7_ABORT): Disable Write to CH7_ABORT bit
    uint32_t    CHN7_ABORT_WE:1;               // 15    
    uint32_t    rsvd1:16;                      // 31:16   Reserved field - read-only
};

struct XCHNEN_H_BITS {        
    // Channel-x Terminate Request. (x from 0 to 7)
    // For each bit from bit0 to bit7, value defined is below:
    // 0: (DISABLE_CHx_ABORT): No Request for Channel-x Terminate
    // 1: (ENABLE_CHx_ABORT): Request for Channel-x Terminate
    // Channel-x Terminate Enable Write Enable bit. 
    // The read back value of this register bit is always x.
    // For each bit from bit8 to bit15, value defined is below:
    // 1: (ENABLE_WR_CHx_ABORT): Enable Write to CHx_ABORT bit
    // 0: (DISABLE_WR_CHx_ABORT): Disable Write to CHx_ABORT bit

    uint32_t    CHN_ABORT:16;                  // 15:0    
    uint32_t    rsvd1:16;                      // 31:16   Reserved field - read-only
};

union XCHNEN_H_REG {
    uint32_t          all;
    struct XCHNEN_H_SPLIT_BITS    spltBit;
    struct XCHNEN_H_BITS          bit;
};

struct XCHNINTS_L_SPLIT_BITS {      
    // Channel 0 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 0 Interrupt is Active
    // 0: (INACTIVE): Channel 0 Interrupt is Inactive
    uint32_t    CH0_INTS:1;               // 0

    // Channel 1 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 1 Interrupt is Active
    // 0: (INACTIVE): Channel 1 Interrupt is Inactive
    uint32_t    CH1_INTS:1;               // 1

    // Channel 2 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 2 Interrupt is Active
    // 0: (INACTIVE): Channel 2 Interrupt is Inactive
    uint32_t    CH2_INTS:1;                  // 2
    
    // Channel 3 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 3 Interrupt is Active
    // 0: (INACTIVE): Channel 3 Interrupt is Inactive
    uint32_t    CH3_INTS:1;                  // 3

    // Channel 4 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 4 Interrupt is Active
    // 0: (INACTIVE): Channel 4 Interrupt is Inactive
    uint32_t    CH4_INTS:1;                  // 4

    // Channel 5 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 5 Interrupt is Active
    // 0: (INACTIVE): Channel 5 Interrupt is Inactive
    uint32_t    CH5_INTS:1;                  // 5

    // Channel 6 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 6 Interrupt is Active
    // 0: (INACTIVE): Channel 6 Interrupt is Inactive
    uint32_t    CH6_INTS:1;                  // 6

    // Channel 7 Interrupt Status Bit.
    // 1: (ACTIVE): Channel 7 Interrupt is Active
    // 0: (INACTIVE): Channel 7 Interrupt is Inactive
    uint32_t    CH7_INTS:1;                  // 7
    uint32_t    rsvd2:8;                        // 15:8   reserved

    // Common Register Interrupt Status Bit.
    // 1: (ACTIVE): Common Register Interrupt is Active
    // 0: (INACTIVE): Common Register Interrupt is Inactive
    uint32_t    COMMONREG_INT_STATUS:1;            // 16
    uint32_t    rsvd1:15;                       // 31:17   reserved
};

struct XCHNINTS_L_BITS {      
    // Channel x Interrupt Status Bit. (x from 0 to 7)
    // For each bit, value defined is below:
    // 1: (ACTIVE): Channel x Interrupt is Active
    // 0: (INACTIVE): Channel x Interrupt is Inactive
    uint32_t    CHN_INTS:8;                     // 7:0
    uint32_t    rsvd2:8;                        // 15:8   reserved

    // Common Register Interrupt Status Bit.
    // 1: (ACTIVE): Common Register Interrupt is Active
    // 0: (INACTIVE): Common Register Interrupt is Inactive
    uint32_t    COMMONREG_INT_STATUS:1;         // 16
    uint32_t    rsvd1:15;                       // 31:17   reserved
};


union XCHNINTS_L_REG {
    uint32_t          all;
    struct XCHNINTS_L_SPLIT_BITS    spltBit;
    struct XCHNINTS_L_BITS          bit;
};

struct XCHNINTS_H_BITS {            // bits   description
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XCHNINTS_H_REG {
    uint32_t          all;
    struct XCHNINTS_H_BITS          bit;
};

struct XCLRCOMINTS_L_BITS {

    // Register Bus Interface Common Register Decode Error Interrupt clear Bit.
    // This bit is used to clear the corresponding channel interrupt status 
    // bit (SLVIF_CommonReg_DEC_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (CLEAR_SLVIF_CommonReg_DEC_ERR): Clear the SLVIF_CommonReg_DEC_ERR 
    //    interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_CommonReg_DEC_ERR_CLR:1;                  // 0

    // Register Bus Interface Common Register Write to Read only Error 
    // Interrupt clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (SLVIF_CommonReg_WR2RO_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (CLEAR_SLVIF_CommonReg_WR2RO_ERR): Clear the SLVIF_CommonReg_WR2RO_ERR
    //    interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_CommonReg_WR2RO_ERR_CLR:1;                // 1

    // Register Bus Interface Common Register Read to Write only Error 
    // Interrupt clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (SLVIF_CommonReg_RD2WO_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (CLEAR_SLVIF_CommonReg_RD2WO_ERR): Clear the SLVIF_CommonReg_RD2WO_ERR
    //    interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t   SLVIF_CommonReg_RD2WO_ERR_CLR:1;                 // 2

    // Register Bus Interface Common Register Write On Hold Error Interrupt
    // clear Bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (SLVIF_CommonReg_WrOnHold_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (CLEAR_SLVIF_CommonReg_WrOnHold_ERR): Clear the SLVIF_CommonReg_WrOnHold
    //    _ERR interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_CommonReg_WrOnHold_ERR_CLR:1;             // 3
    uint32_t    rsvd2:2;                                        // 5:4

    // Register Bus Interface Common Register Address Parity Error Interrupt
    // clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (SLVIF_CommonReg_ADDRPARITY_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1 (CLEAR_SLVIF_CommonReg_ADDRPARITY_ERR): Clear the SLVIF_CommonReg_ADDRPARITY
    //   _ERR interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_CommonReg_ADDRPARITY_ERR_CLR:1;           // 6

    // Register Bus Interface Common Register Write Parity Error Interrupt
    // clear Bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (SLVIF_CommonReg_WRPARITY_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (CLEAR_SLVIF_CommonReg_WRPARITY_ERR): Clear the SLVIF_CommonReg_WRPARITY
    //    _ERR interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_CommonReg_WRPARITY_ERR_CLR:1;             // 7

    // Register Bus Interface Undefined register Decode Error Interrupt
    // clear Bit.
    // This bit is used to clear the corresponding channel interrupt status 
    // bit (SLVIF_UndefinedReg_DEC_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (CLEAR_SLVIF_UndefinedReg_DEC_ERR): Clear the SLVIF_UndefinedReg_DEC
    //    _ERR interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_UndefinedReg_DEC_ERR_CLR:1;               // 8

    // AXI Manager Interface 1 Read Channel (Data) ECC Protection related 
    // Correctable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (MXIF1_RCH0_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_RCH0_PROT_CorrERR): Clear the MXIF1_RCH0_PROT_CorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_RCH0_PROT_CorrERR_CLR:1;                  // 9

    // AXI Manager Interface 1 Read Channel (Data) Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (MXIF1_RCH0_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_RCH0_PROT_UnCorrERR): Clear the MXIF1_RCH0_PROT_UnCorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_RCH0_PROT_UnCorrERR_CLR:1;                // 10

    // AXI Manager Interface 1 Read Channel (Other Control signals) ECC 
    // Protection related Correctable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (MXIF1_RCH1_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_RCH1_PROT_CorrERR): Clear the MXIF1_RCH1_PROT_CorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_RCH1_PROT_CorrERR_CLR:1;                  // 11

    // AXI Manager Interface 1 Read Channel (Other Control signals) Parity/
    // ECC Protection related Uncorrectable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status 
    // bit (MXIF1_RCH1_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_RCH1_PROT_UnCorrERR): Clear the MXIF1_RCH1_PROT_UnCorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_RCH1_PROT_UnCorrERR_CLR:1;                // 12

    // AXI Manager Interface 1 Write Response Channel ECC Protection related
    // Correctable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status 
    // bit (MXIF1_BCH_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_BCH_PROT_CorrERR): Clear the MXIF1_BCH_PROT_CorrERR_IntStat
    //    interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_BCH_PROT_CorrERR_CLR:1;                  // 13

    // AXI Manager Interface 1 Write Response Channel Parity/ECC Protection
    // related Uncorrectable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status 
    // bit (MXIF1_BCH_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_BCH_PROT_UnCorrERR): Clear the MXIF1_BCH_PROT_UnCorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_BCH_PROT_UnCorrERR_CLR:1;             // 14

    // AXI Manager Interface 2 Read Channel (Data) ECC Protection related 
    // Correctable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (MXIF2_RCH0_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_RCH0_PROT_CorrERR): Clear the MXIF2_RCH0_PROT_CorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF2_RCH0_PROT_CorrERR_CLR:1;              // 15

    // AXI Manager Interface 2 Read Channel (Data) Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (MXIF2_RCH0_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_RCH0_PROT_UnCorrERR): Clear the MXIF2_RCH0_PROT_UnCorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF2_RCH0_PROT_UnCorrERR_CLR:1;            // 16

    // AXI Manager Interface 2 Read Channel (Other Control signals) ECC 
    // Protection related Correctable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status
    // bit (MXIF2_RCH1_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_RCH1_PROT_CorrERR): Clear the MXIF2_RCH1_PROT_CorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF2_RCH1_PROT_CorrERR_CLR:1;             // 17

    // AXI Manager Interface 2 Read Channel (Other Control signals) Parity/
    // ECC Protection related Uncorrectable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (MXIF2_RCH1_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_RCH1_PROT_UnCorrERR): Clear the MXIF2_RCH1_PROT_UnCorrERR
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF2_RCH1_PROT_UnCorrERR_CLR:1;            // 18

    // AXI Manager Interface 2 Write Response Channel ECC Protection related
    // Correctable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status 
    // bit (MXIF2_BCH_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_BCH_PROT_CorrERR): Clear the MXIF2_BCH_PROT_CorrERR_IntStat
    //    interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF2_BCH_PROT_CorrERR_CLR:1;               // 19

    // AXI Manager Interface 2 Write Response Channel Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF2_BCH_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_BCH_PROT_UnCorrERR): Clear the MXIF2_BCH_PROT_UnCorrERR_IntStat
    //    interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF2_BCH_PROT_UnCorrERR_CLR:1;             // 20

    // AXI Manager Interface 1 Read Address Channel ARREADY Parity Protection 
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_ARCH_PROT_ARREADY_ParErr): Clear the MXIF1_ARCH_PROT_ARREADY_
    //    ParErr_IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_ARCH_PROT_ARREADY_ParErr_CLR:1;       // 21

    // AXI Manager Interface 1 Write Address Channel AWREADY Parity Protection 
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_AWCH_PROT_AWREADY_ParErr): Clear the MXIF1_AWCH_PROT_AWREADY_
    //    ParErr_IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_AWCH_PROT_AWREADY_ParErr_CLR:1;       // 22

    // AXI Manager Interface 1 Write Data Channel WREADY Parity Protection 
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF1_WCH_PROT_WREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_WCH_PROT_WREADY_ParErr): Clear the MXIF1_WCH_PROT_WREADY_ParErr
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF1_WCH_PROT_WREADY_ParErr_CLR:1;         // 23

    // AXI Manager Interface 1 Read Data Channel RVALID Parity Protection related
    // Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF1_RCH_PROT_RVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_RCH_PROT_RVALID_ParErr): Clear the MXIF1_RCH_PROT_RVALID_ParErr
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF1_RCH_PROT_RVALID_ParErr_CLR:1;         // 24

    // AXI Manager Interface 1 Write Response Channel BVALID Parity Protection
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (MXIF1_BCH_PROT_BVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF1_BCH_PROT_BVALID_ParErr): Clear the MXIF1_BCH_PROT_BVALID_ParErr
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF1_BCH_PROT_BVALID_ParErr_CLR:1;         // 25

    // AXI Manager Interface 2 Read Address Channel ARREADY Parity Protection
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_ARCH_PROT_ARREADY_ParErr): Clear the MXIF2_ARCH_PROT_
    //    ARREADY_ParErr_IntStat interrupt in the interrupt register DMAC_
    //    CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF2_ARCH_PROT_ARREADY_ParErr_CLR:1;       // 26

    // AXI Manager Interface 2 Write Address Channel AWREADY Parity Protection
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_AWCH_PROT_AWREADY_ParErr): Clear the MXIF2_AWCH_PROT_AWREADY
    //    _ParErr_IntStat interrupt in the interrupt register DMAC_CommonReg_
    //    IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF2_AWCH_PROT_AWREADY_ParErr_CLR:1;       // 27

    // AXI Manager Interface 2 Write Data Channel WREADY Parity Protection related 
    // Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF2_WCH_PROT_WREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_WCH_PROT_WREADY_ParErr): Clear the MXIF2_WCH_PROT_WREADY_ParErr
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF2_WCH_PROT_WREADY_ParErr_CLR:1;         // 28

    // AXI Manager Interface 2 Read Data Channel RVALID Parity Protection related 
    // Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // (MXIF2_RCH_PROT_RVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_RCH_PROT_RVALID_ParErr): Clear the MXIF2_RCH_PROT_RVALID_ParErr
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.
    uint32_t    MXIF2_RCH_PROT_RVALID_ParErr_CLR:1;         // 29

    // AXI Manager Interface 2 Write Response Channel BVALID Parity Protection 
    // related Error Interrupt Clear bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // (MXIF2_BCH_PROT_BVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (CLEAR_MXIF2_BCH_PROT_BVALID_ParErr): Clear the MXIF2_BCH_PROT_BVALID_ParErr
    //    _IntStat interrupt in the interrupt register DMAC_CommonReg_IntStatusReg
    // 0: (No_ACTION): Inactive signal. No action taken.    
    uint32_t    MXIF2_BCH_PROT_BVALID_ParErr_CLR:1;             // 30
    uint32_t    rsvd1:1;                                        // 31 reserved
};

union XCLRCOMINTS_L_REG {
    uint32_t          all;
    struct XCLRCOMINTS_L_BITS          bit;
};

struct XCLRCOMINTS_H_BITS {     
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XCLRCOMINTS_H_REG {
    uint32_t          all;
    struct XCLRCOMINTS_H_BITS          bit;
};

struct XENCOMINTS_L_BITS {
    // Register Bus Interface Common Register Decode Error Interrupt Status 
    // Enable Bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (SLVIF_CommonReg_DEC_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_CommonReg_DEC_ERR): SLVIF_CommonReg_DEC_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_CommonReg_DEC_ERR): SLVIF_CommonReg_DEC_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    SLVIF_CommonReg_DEC_ERR_EN:1;                   // 0

    // Register Bus Interface Common Register Write to Read only Error 
    // Interrupt Status Enable Bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (SLVIF_CommonReg_WR2RO_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_CommonReg_WR2RO_ERR): SLVIF_CommonReg_WR2RO_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_CommonReg_WR2RO_ERR): SLVIF_CommonReg_WR2RO_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    SLVIF_CommonReg_WR2RO_ERR_EN:1;                 // 1

    // Register Bus Interface Common Register Read to Write only Error Interrupt 
    // Status Enable Bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (SLVIF_CommonReg_RD2WO_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_CommonReg_RD2WO_ERR): SLVIF_CommonReg_RD2WO_ERR_IntStat 
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_CommonReg_RD2WO_ERR): SLVIF_CommonReg_RD2WO_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    SLVIF_CommonReg_RD2WO_ERR_EN:1;                 // 2

    // Register Bus Interface Common Register Write On Hold Error Interrupt Status
    // Enable Bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (SLVIF_CommonReg_WrOnHold_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_CommonReg_WrOnHold_ERR): SLVIF_CommonReg_WrOnHold_ERR_IntStat 
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_CommonReg_WrOnHold_ERR): SLVIF_CommonReg_WrOnHold_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    SLVIF_CommonReg_WrOnHold_ERR_EN:1;              // 3
    uint32_t    rsvd2:2;                                        // 5:4

    // Register Bus Interface Common Register Address Parity Error Interrupt
    // Status Enable Bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (SLVIF_CommonReg_ADDRPARITY_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_CommonReg_ADDRPARITY_ERR): SLVIF_CommonReg_ADDRPARITY_ERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_CommonReg_ADDRPARITY_ERR): SLVIF_CommonReg_ADDRPARITY_ERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    SLVIF_CommonReg_ADDRPARITY_ERR_EN:1;            // 6

    // Register Bus Interface Common Register Write Parity Error Interrupt
    // Status Enable Bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (SLVIF_CommonReg_WRPARITY_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_CommonReg_WRPARITY_ERR): SLVIF_CommonReg_WRPARITY_ERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_CommonReg_WRPARITY_ERR): SLVIF_CommonReg_WRPARITY_ERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    SLVIF_CommonReg_WRPARITY_ERR_EN:1;              // 7

    // Register Bus Interface Undefined register Decode Error Interrupt
    // Status enable Bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (SLVIF_UndefinedReg_DEC_ERR_IntStat in DMAC_CommonReg_IntStatusReg.
    // 1: (ENABLE_SLVIF_UndefinedReg_DEC_ERR): SLVIF_UndefinedReg_DEC_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_SLVIF_UndefinedReg_DEC_ERR): SLVIF_UndefinedReg_DEC_ERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t SLVIF_UndefinedReg_DEC_ERR_EN:1;                   // 8

    // AXI Manager Interface 1 Read Channel (Data) ECC Protection related 
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (MXIF1_RCH0_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_RCH0_PROT_CorrERR_IntStat): MXIF1_RCH0_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_RCH0_PROT_CorrERR_IntStat): MXIF1_RCH0_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_RCH0_PROT_CorrERR_EN:1;                   // 9

    // AXI Manager Interface 1 Read Channel (Data) Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_RCH0_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_RCH0_PROT_UnCorrERR_IntStat): MXIF1_RCH0_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_RCH0_PROT_UnCorrERR_IntStat): MXIF1_RCH0_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_RCH0_PROT_UnCorrERR_EN:1;                 // 10

    // AXI Manager Interface 1 Read Channel (Other Control signals) ECC 
    // Protection related Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_RCH1_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_RCH1_PROT_CorrERR_IntStat): MXIF1_RCH1_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_RCH1_PROT_CorrERR_IntStat): MXIF1_RCH1_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_RCH1_PROT_CorrERR_EN:1;                   // 11

    // AXI Manager Interface 1 Read Channel (Other Control signals) Parity/ECC
    // Protection related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_RCH1_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_RCH1_PROT_UnCorrERR_IntStat): MXIF1_RCH1_PROT_UnCorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_RCH1_PROT_UnCorrERR_IntStat): MXIF1_RCH1_PROT_UnCorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_RCH1_PROT_UnCorrERR_EN:1;                 // 12

    // AXI Manager Interface 1 Write Response Channel ECC Protection related
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_BCH_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_BCH_PROT_CorrERR_IntStat): MXIF1_BCH_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_BCH_PROT_CorrERR_IntStat): MXIF1_BCH_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_BCH_PROT_CorrERR_EN:1;                    // 13

    // AXI Manager Interface 1 Write Response Channel Parity/ECC Protection
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_BCH_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_BCH_PROT_UnCorrERR_IntStat): MXIF1_BCH_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_BCH_PROT_UnCorrERR_IntStat): MXIF1_BCH_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_BCH_PROT_UnCorrERR_EN:1;                  // 14

    // AXI Manager Interface 2 Read Channel (Data) ECC Protection related 
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF2_RCH0_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_RCH0_PROT_CorrERR_IntStat): MXIF2_RCH0_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_RCH0_PROT_CorrERR_IntStat): MXIF2_RCH0_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF2_RCH0_PROT_CorrERR_EN:1;                   // 15

    // AXI Manager Interface 2 Read Channel (Data) Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF2_RCH0_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_RCH0_PROT_UnCorrERR_IntStat): MXIF2_RCH0_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_RCH0_PROT_UnCorrERR_IntStat): MXIF2_RCH0_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF2_RCH0_PROT_UnCorrERR_EN:1;                 // 16

    // AXI Manager Interface 2 Read Channel (Other Control signals) ECC 
    // Protection related Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF2_RCH1_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_RCH1_PROT_CorrERR_IntStat): MXIF2_RCH1_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_RCH1_PROT_CorrERR_IntStat): MXIF2_RCH1_PROT_CorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF2_RCH1_PROT_CorrERR_EN:1;                   // 17

    // AXI Manager Interface 2 Read Channel (Other Control signals) Parity/ECC 
    // Protection related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF2_RCH1_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_RCH1_PROT_UnCorrERR_IntStat): MXIF2_RCH1_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_RCH1_PROT_UnCorrERR_IntStat): MXIF2_RCH1_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled
    uint32_t    MXIF2_RCH1_PROT_UnCorrERR_EN:1;                 // 18

    // AXI Manager Interface 2 Write Response Channel ECC Protection related
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (MXIF2_BCH_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_BCH_PROT_CorrERR_IntStat): MXIF2_BCH_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_BCH_PROT_CorrERR_IntStat): MXIF2_BCH_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF2_BCH_PROT_CorrERR_EN:1;                    // 19

    // AXI Manager Interface 2 Write Response Channel Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF2_BCH_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_BCH_PROT_UnCorrERR_IntStat): MXIF2_BCH_PROT_UnCorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_BCH_PROT_UnCorrERR_IntStat): MXIF2_BCH_PROT_UnCorrERR_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF2_BCH_PROT_UnCorrERR_EN:1;                  // 20

    // AXI Manager Interface 1 Read Address Channel ARREADY Parity Protection
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF1_ARCH_PROT_ARREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF1_ARCH_PROT_ARREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_ARCH_PROT_ARREADY_ParErr_EN:1;            // 21

    // AXI Manager Interface 1 Write Address Channel AWREADY Parity Protection
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF1_AWCH_PROT_AWREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF1_AWCH_PROT_AWREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_AWCH_PROT_AWREADY_ParErr_EN:1;            // 22

    // AXI Manager Interface 1 Write Data Channel WREADY Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_WCH_PROT_WREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_WCH_PROT_WREADY_ParErr_IntStat): MXIF1_WCH_PROT_WREADY_
    //    ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_WCH_PROT_WREADY_ParErr_IntStat): MXIF1_WCH_PROT_WREADY_
    //    ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_WCH_PROT_WREADY_ParErr_EN:1;              // 23    

    // AXI Manager Interface 1 Read Data Channel RVALID Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_RCH_PROT_RVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_RCH_PROT_RVALID_ParErr_IntStat): MXIF1_RCH_PROT_RVALID_
    //    ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_RCH_PROT_RVALID_ParErr_IntStat): MXIF1_RCH_PROT_RVALID
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_RCH_PROT_RVALID_ParErr_EN:1;              // 24

    // AXI Manager Interface 1 Write Response Channel BVALID Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_BCH_PROT_BVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF1_BCH_PROT_BVALID_ParErr_IntStat): MXIF1_BCH_PROT_BVALID
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF1_BCH_PROT_BVALID_ParErr_IntStat): MXIF1_BCH_PROT_BVALID
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF1_BCH_PROT_BVALID_ParErr_EN:1;              // 25

    // AXI Manager Interface 2 Read Address Channel ARREADY Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF2_ARCH_PROT_ARREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF2_ARCH_PROT_ARREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    _MXIF2_ARCH_PROT_ARREADY_ParErr_EN:1;           // 26

    // AXI Manager Interface 2 Write Address Channel AWREADY Parity Protection 
    // related Error Interrupt Status bit. 
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF2_AWCH_PROT_AWREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF2_AWCH_PROT_AWREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled    
    uint32_t    MXIF2_AWCH_PROT_AWREADY_ParErr_EN:1;            // 27

    // AXI Manager Interface 2 Write Data Channel WREADY Parity Protection related
    // Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_WCH_PROT_WREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_WCH_PROT_WREADY_ParErr_IntStat): MXIF2_WCH_PROT_WREADY_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_WCH_PROT_WREADY_ParErr_IntStat): MXIF2_WCH_PROT_WREADY_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled
    uint32_t    MXIF2_WCH_PROT_WREADY_ParErr_EN:1;              // 28

    // AXI Manager Interface 2 Read Data Channel RVALID Parity Protection related 
    // Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_RCH_PROT_RVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_RCH_PROT_RVALID_ParErr_IntStat): MXIF2_RCH_PROT_RVALID_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_RCH_PROT_RVALID_ParErr_IntStat): MXIF2_RCH_PROT_RVALID_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled
    uint32_t    MXIF2_RCH_PROT_RVALID_ParErr_EN:1;              // 29

    // AXI Manager Interface 2 Write Response Channel BVALID Parity Protection related
    // Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_BCH_PROT_BVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg).
    // 1: (ENABLE_MXIF2_BCH_PROT_BVALID_ParErr_IntStat): MXIF2_BCH_PROT_BVALID_ParErr_
    //    IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled
    // 0: (DISABLE_MXIF2_BCH_PROT_BVALID_ParErr_IntStat): MXIF2_BCH_PROT_BVALID_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Disabled
    uint32_t    MXIF2_BCH_PROT_BVALID_ParErr_EN:1;              // 30
    uint32_t    rsvd1:1;                                        // 31 reserved
};

union XENCOMINTS_L_REG {
    uint32_t          all;
    struct XENCOMINTS_L_BITS          bit;
};

struct XENCOMINTS_H_BITS {      
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XENCOMINTS_H_REG {
    uint32_t          all;
    struct XENCOMINTS_H_BITS          bit;
};

struct XENCOMINTSIGL_L_BITS { 
    // Register Bus Interface Common Register Decode Error Interrupt Signal
    // Enable Bit.
    // This bit is used to enable the propagation of corresponding channel interrupt
    // status bit (SLVIF_CommonReg_DEC_ERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_CommonReg_DEC_ERR_IntSignal): SLVIF_CommonReg_DEC_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_CommonReg_DEC_ERR_IntSignal): SLVIF_CommonReg_DEC_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    SLVIF_CommonReg_DEC_ERR_SIGL_EN:1;              // 0

    // Register Bus Interface Common Register Write to Read only Error Interrupt
    // Signal Enable Bit.
    // This bit is used to enable the propagation of corresponding channel interrupt
    // status bit (SLVIF_CommonReg_WR2RO_ERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_CommonReg_WR2RO_ERR_IntSignal): SLVIF_CommonReg_WR2RO_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_CommonReg_WR2RO_ERR_IntSignal): SLVIF_CommonReg_WR2RO_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    SLVIF_CommonReg_WR2RO_ERR_SIGL_EN:1;            // 1

    // Register Bus Interface Common Register Read to Write only Error Interrupt
    // Signal Enable Bit.
    // This bit is used to enable the propagation of corresponding channel interrupt
    // status bit (SLVIF_CommonReg_RD2WO_ERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_CommonReg_RD2WO_ERR_IntSignal): SLVIF_CommonReg_RD2WO_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_CommonReg_RD2WO_ERR_IntSignal): SLVIF_CommonReg_RD2WO_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    SLVIF_CommonReg_RD2WO_ERR_SIGL_EN:1;            // 2

    // Register Bus Interface Common Register Write On Hold Error Interrupt Signal
    // Enable Bit.
    // This bit is used to enable the propagation of corresponding channel interrupt 
    // status bit (SLVIF_CommonReg_WrOnHold_ERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_CommonReg_WrOnHold_ERR_IntSignal): SLVIF_CommonReg_WrOnHold
    //    _ERR_IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_CommonReg_WrOnHold_ERR_IntSignal): SLVIF_CommonReg_WrOnHold
    //   _ERR_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    SLVIF_CommonReg_WrOnHold_ERR_SIGL_EN:1;         // 3
    uint32_t    rsvd2:2;                                        // 5:4

    // Register Bus Interface Address Parity Error Interrupt Signal Enable Bit.
    // This bit is used to enable the propagation of corresponding channel 
    // interrupt status bit (SLVIF_CommonReg_ADDRPARITY_ERR_IntStat in 
    // DMAC_CommonReg_IntStatusReg) to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_CommonReg_ADDRPARITY_ERR_IntSignal): SLVIF_CommonReg_ADDRPARITY
    //    _ERR_IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_CommonReg_ADDRPARITY_ERR_IntSignal): SLVIF_CommonReg_ADDRPARITY
    //    _ERR_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t   SLVIF_CommonReg_ADDRPARITY_ERR_SIGL_EN:1;        // 6

    // Register Bus Interface Write Parity Error Interrupt Signal Enable Bit.
    // This bit is used to enable the propagation of corresponding channel 
    // interrupt status bit (SLVIF_CommonReg_WRPARITY_ERR_IntStat in 
    // DMAC_CommonReg_IntStatusReg) to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_CommonReg_WRPARITY_ERR_IntSignal): SLVIF_CommonReg_WRPARITY
    //    _ERR_IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_CommonReg_WRPARITY_ERR_IntSignal): SLVIF_CommonReg_WRPARITY
    //    _ERR_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    SLVIF_CommonReg_WRPARITY_ERR_SIGL_EN:1;         // 7

    // Register Bus Interface Undefined register Decode Error Interrupt 
    // Signal Enable Bit.
    // This bit is used to enable the propagation of corresponding channel
    // interrupt status bit (SLVIF_UndefinedReg_DEC_ERR_IntStat in 
    // DMAC_CommonReg_IntStatusReg) to generate a port level interrupt.
    // 1: (ENABLE_SLVIF_UndefinedReg_DEC_ERR_IntSignal): SLVIF_UndefinedReg_DEC_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_SLVIF_UndefinedReg_DEC_ERR_IntSignal): SLVIF_UndefinedReg_DEC_ERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level
    uint32_t    SLVIF_UndefinedReg_DEC_ERR_SIGL_EN:1;           // 8

    // AXI Manager Interface 1 Read Channel (Data) ECC Protection related
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_RCH0_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_RCH0_PROT_CorrERR_IntStat): MXIF1_RCH0_PROT_CorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_RCH0_PROT_CorrERR_IntStat): MXIF1_RCH0_PROT_CorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_RCH0_PROT_CorrERR_SIGL_EN:1;              // 9

    // AXI Manager Interface 1 Read Channel (Data) Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_RCH0_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_RCH0_PROT_UnCorrERR_IntStat): MXIF1_RCH0_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_RCH0_PROT_UnCorrERR_IntStat): MXIF1_RCH0_PROT_UnCorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level
    uint32_t    MXIF1_RCH0_PROT_UnCorrERR_SIGL_EN:1;            // 10

    // AXI Manager Interface 1 Read Channel (Other Control signals) ECC 
    // Protection related Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_RCH1_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_RCH1_PROT_CorrERR_IntStat): MXIF1_RCH1_PROT_CorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_RCH1_PROT_CorrERR_IntStat): MXIF1_RCH1_PROT_CorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_RCH1_PROT_CorrERR_SIGL_EN:1;              // 11

    // AXI Manager Interface 1 Read Channel (Other Control signals) Parity/
    // ECC Protection related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_RCH1_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_RCH1_PROT_UnCorrERR_IntStat): MXIF1_RCH1_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_RCH1_PROT_UnCorrERR_IntStat): MXIF1_RCH1_PROT_UnCorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_RCH1_PROT_UnCorrERR_SIGL_EN:1;            // 12

    // AXI Manager Interface 1 Write Response Channel ECC Protection related
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_BCH_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_BCH_PROT_CorrERR_IntStat): MXIF1_BCH_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_BCH_PROT_CorrERR_IntStat): MXIF1_BCH_PROT_CorrERR_IntStat
    //    signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_BCH_PROT_CorrERR_SIGL_EN:1;               // 13

    // AXI Manager Interface 1 Write Response Channel Parity/ECC Protection
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_BCH_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_BCH_PROT_UnCorrERR_IntStat): MXIF1_BCH_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_BCH_PROT_UnCorrERR_IntStat): MXIF1_BCH_PROT_UnCorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level
    uint32_t    MXIF1_BCH_PROT_UnCorrERR_SIGL_EN:1;             // 14

    // AXI Manager Interface 2 Read Channel (Data) ECC Protection related 
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF2_RCH0_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_RCH0_PROT_CorrERR_IntStat): MXIF2_RCH0_PROT_CorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_RCH0_PROT_CorrERR_IntStat): MXIF2_RCH0_PROT_CorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level
    uint32_t    MXIF2_RCH0_PROT_CorrERR_SIGL_EN:1;              // 15

    // AXI Manager Interface 2 Read Channel (Data) Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF2_RCH0_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_RCH0_PROT_UnCorrERR_IntStat): MXIF2_RCH0_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_RCH0_PROT_UnCorrERR_IntStat): MXIF2_RCH0_PROT_UnCorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t   MXIF2_RCH0_PROT_UnCorrERR_SIGL_EN:1;             // 16

    // AXI Manager Interface 2 Read Channel (Other Control signals) ECC Protection 
    // related Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF2_RCHPROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg) to generate
    // a port level interrupt.
    // 1: (ENABLE_MXIF2_RCH1_PROT_CorrERR_IntStat): MXIF2_RCH1_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_RCH1_PROT_CorrERR_IntStat): MXIF2_RCH1_PROT_CorrERR_IntStat
    //    signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF2_RCH1_PROT_CorrERR_SIGL_EN:1;              // 17

    // AXI Manager Interface 2 Read Channel (Other Control signals) Parity/
    // ECC Protection related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF2_RCH1_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_RCH1_PROT_UnCorrERR_IntStat): MXIF2_RCH1_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_RCH1_PROT_UnCorrERR_IntStat): MXIF2_RCH1_PROT_UnCorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    _MXIF2_RCH1_PROT_UnCorrERR_SIGL_EN:1;           // 18

    // AXI Manager Interface 2 Write Response Channel ECC Protection related 
    // Correctable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (MXIF2_BCH_PROT_CorrERR_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_BCH_PROT_CorrERR_IntStat): MXIF2_BCH_PROT_CorrERR_IntStat
    //    bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_BCH_PROT_CorrERR_IntStat): MXIF2_BCH_PROT_CorrERR_IntStat
    //    signal in DMAC_CommonReg_IntStatusReg is Disabled at port level

    uint32_t    MXIF2_BCH_PROT_CorrERR_SIGL_EN:1;               // 19

    // AXI Manager Interface 2 Write Response Channel Parity/ECC Protection 
    // related Uncorrectable Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (MXIF2_BCH_PROT_UnCorrERR_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_BCH_PROT_UnCorrERR_IntStat): MXIF2_BCH_PROT_UnCorrERR
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_BCH_PROT_UnCorrERR_IntStat): MXIF2_BCH_PROT_UnCorrERR
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    Enable_MXIF2_BCH_PROT_UnCorrERR_SIGL_EN:1;      // 20

    // AXI Manager Interface 1 Read Address Channel ARREADY Parity Protection
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF1_ARCH_PROT_ARREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF1_ARCH_PROT_ARREADY_
    //    ParErr_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_ARCH_PROT_ARREADY_ParErr_SIGL_EN:1;       // 21

    // AXI Manager Interface 1 Write Address Channel AWREADY Parity Protection
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF1_AWCH_PROT_AWREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF1_AWCH_PROT_AWREADY
    //    _ParErr_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_AWCH_PROT_AWREADY_ParErr_SIGL_EN:1;       // 22

    // AXI Manager Interface 1 Write Data Channel WREADY Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status
    // bit (MXIF1_WCH_PROT_WREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF1_WCH_PROT_WREADY_ParErr_IntStat): MXIF1_WCH_PROT_WREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_WCH_PROT_WREADY_ParErr_IntStat): MXIF1_WCH_PROT_WREADY_ParErr
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_WCH_PROT_WREADY_ParErr_SIGL_EN:1;         // 23

    // AXI Manager Interface 1 Read Data Channel RVALID Parity Protection related
    // Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF1_RCH_PROT_RVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) to 
    // generate a port level interrupt.
    // 1: (ENABLE_MXIF1_RCH_PROT_RVALID_ParErr_IntStat): MXIF1_RCH_PROT_RVALID_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_RCH_PROT_RVALID_ParErr_IntStat): MXIF1_RCH_PROT_RVALID_ParErr
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t MXIF1_RCH_PROT_RVALID_ParErr_SIGL_EN:1;            // 24

    // AXI Manager Interface 1 Write Response Channel BVALID Parity Protection
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF1_BCH_PROT_BVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) to 
    // generate a port level interrupt.
    // 1: (ENABLE_MXIF1_BCH_PROT_BVALID_ParErr_IntStat): MXIF1_BCH_PROT_BVALID
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF1_BCH_PROT_BVALID_ParErr_IntStat): MXIF1_BCH_PROT_BVALID_ParErr
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF1_BCH_PROT_BVALID_ParErr_SIGL_EN:1;         // 25

    // AXI Manager Interface 2 Read Address Channel ARREADY Parity Protection
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) to 
    // generate a port level interrupt.
    // 1: (ENABLE_MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF2_ARCH_PROT_ARREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_ARCH_PROT_ARREADY_ParErr_IntStat): MXIF2_ARCH_PROT_ARREADY
    //    _ParErr_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF2_ARCH_PROT_ARREADY_ParErr_SIGL_EN:1;       // 26

    // AXI Manager Interface 2 Write Address Channel AWREADY Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit
    // (MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) 
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF2_AWCH_PROT_AWREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_AWCH_PROT_AWREADY_ParErr_IntStat): MXIF2_AWCH_PROT_AWREADY
    //    _ParErr_IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level
    uint32_t    MXIF2_AWCH_PROT_AWREADY_ParErr_SIGL_EN:1;       // 27

    // AXI Manager Interface 2 Write Data Channel WREADY Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status 
    // bit (MXIF2_WCH_PROT_WREADY_ParErr_IntStat in DMAC_CommonReg_IntStatusReg)
    // to generate a port level interrupt.
    // 1: (ENABLE_MXIF2_WCH_PROT_WREADY_ParErr_IntStat): MXIF2_WCH_PROT_WREADY
    //    _ParErr_IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_WCH_PROT_WREADY_ParErr_IntStat): MXIF2_WCH_PROT_WREADY_ParErr
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF2_WCH_PROT_WREADY_ParErr_SIGL_EN:1;         // 28

    // AXI Manager Interface 2 Read Data Channel RVALID Parity Protection related
    // Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_RCH_PROT_RVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) to 
    // generate a port level interrupt.
    // 1: (ENABLE_MXIF2_RCH_PROT_RVALID_ParErr_IntStat): MXIF2_RCH_PROT_RVALID_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_RCH_PROT_RVALID_ParErr_IntStat): MXIF2_RCH_PROT_RVALID_ParErr
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF2_RCH_PROT_RVALID_ParErr_SIGL_EN:1;         // 29

    // AXI Manager Interface 2 Write Response Channel BVALID Parity Protection 
    // related Error Interrupt Status bit.
    // This bit is used to enable the corresponding channel interrupt status bit 
    // (MXIF2_BCH_PROT_BVALID_ParErr_IntStat in DMAC_CommonReg_IntStatusReg) to 
    // generate a port level interrupt.
    // 1: (ENABLE_MXIF2_BCH_PROT_BVALID_ParErr_IntStat): MXIF2_BCH_PROT_BVALID_ParErr
    //    _IntStat bit in DMAC_CommonReg_IntStatusReg is Enabled at port level
    // 0: (DISABLE_MXIF2_BCH_PROT_BVALID_ParErr_IntStat): MXIF2_BCH_PROT_BVALID_ParErr
    //    _IntStat signal in DMAC_CommonReg_IntStatusReg is Disabled at port level    
    uint32_t    MXIF2_BCH_PROT_BVALID_ParErr_SIGL_EN:1;         // 30
    uint32_t    rsvd1:1;                                        // 31 reserved
};

union XENCOMINTSIGL_L_REG {
    uint32_t          all;
    struct XENCOMINTSIGL_L_BITS          bit;
};

struct XENCOMINTSIGL_H_BITS {            // bits   description
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XENCOMINTSIGL_H_REG {
    uint32_t          all;
    struct XENCOMINTSIGL_H_BITS          bit;
};

struct XCOMMINTS_L_BITS { 
    // Register Bus Interface Common Register Decode Error Interrupt Status Bit.
    // Decode Error generated by DW_axi_dmac during register access. This error
    // occurs if the register access is to an invalid address in the common 
    // register space (0x000 to 0x0FF) resulting in error response by DW_axi_dmac
    // register bus interface.
    // 1: (Active_CommonReg_DEC_ERR): Register Bus Interface Decode Error detected
    // 0: (Inactive_CommonReg_DEC_ERR): No Register Bus Interface Decode Errors
    uint32_t     SLVIF_CommonReg_DEC_ERR_STATUS:1;                // 0

    // Register Bus Interface Common Register Write to Read Only Error Interrupt
    // Status bit.
    // This error occurs if write operation is performed to a Read Only register
    // in the common register space (0x000 to 0x0FF).
    // 1: (Active_CommonReg_WR2RO_ERR): No Register Bus Interface Write to Read
    //    Only Errors
    // 0: (Inactive_CommonReg_WR2RO_ERR): Register Bus Interface Write to Read
    //    Only Error detected
    uint32_t     SLVIF_CommonReg_WR2RO_ERR_STATUS:1;              // 1

    // Register Bus Interface Common Register Read to Write only Error 
    // Interrupt Status bit.
    // This error occurs if Read operation is performed to a Write Only register
    // in the common register space (0x000 to 0x0FF).
    // 1: (Active_CommonReg_RD2WO_ERR): Register Bus Interface Read to Write 
    //    Only Error detected
    // 0: (Inactive_CommonReg_RD2WO_ERR): No Register Bus Interface Read to 
    //    Write Only Errors
    uint32_t     SLVIF_CommonReg_RD2WO_ERR_STATUS:1;              // 2

    // Register Bus Interface Common Register Write On Hold Error Interrupt 
    // Status Bit.
    // This error occurs if an illegal write operation is performed on a common register;
    // this happens if a write operation is performed on a common register except 
    // DMAC_RESETREG with DMAC_RST field set to 1 when DW_axi_dmac is in Hold mode.
    // 1: (Active_CommonReg_WrOnHold_ERR): Register Bus Interface Common Register 
    //    Write On Hold Error detected
    // 0: (Inactive_CommonReg_WrOnHold_ERR): No Register Bus Interface Common 
    //    Register Write On Hold Errors
    uint32_t    SLVIF_CommonReg_WrOnHold_ERR_STATUS:1;            // 3
    uint32_t    rsvd2:2;                                        // 5:4

    // Register Bus Interface Common Register Address Parity Error Interrupt 
    // Status Bit.
    // This error occurs if address is used to do write/read operation to a register
    // in the common register space, but the locally computed parity bits not 
    // matching the received parity bits.
    // 1: (Active_CommonReg_ADDRPARITY_ERR): Register Bus Interface Common Register
    //    Address Parity Error detected
    // 0: (Inactive_CommonReg_ADDRPARITY_ERR): No Register Bus Interface Common 
    //    Register Address Parity Errors
    uint32_t     SLVIF_CommonReg_ADDRPARITY_ERR_STATUS:1;         // 6

    // Register Bus Interface Common Register Write Parity Error Interrupt Status Bit.
    // This error occurs if write operation with data and parity is performed to a 
    // register in the common register space, but the locally computed parity bits
    // not matching the received parity bits
    // 1: (Active_CommonReg_WRPARITY_ERR): Register Bus Interface Common Register
    //    Write Parity Error detected
    // 0: (Inactive_CommonReg_WRPARITY_ERR): No Register Bus Interface Common Register
    //    Write Parity Errors
    uint32_t    SLVIF_CommonReg_WRPARITY_ERR_STATUS:1;            // 7

    // Register Bus Interface Undefined register Decode Error Interrupt Signal 
    // Enable Bit.    
    // Decode Error generated by DW_axi_dmac during register access. This error
    // occurs if the register access is to undefined address range (>0x8FF if 8 
    // channels are configured, >0x4FF if 4 channels are configured etc.) 
    // resulting in error response by DW_axi_dmac register bus interface.
    // 1: (Active_UndefinedReg_DEC_ERR): Register Bus Interface Decode Error detected
    // 0: (Inactive_UndefinedReg_DEC_ERR): No Register Bus Interface Decode Errors    
    uint32_t    SLVIF_UndefinedReg_DEC_ERR_STATUS:1;                   // 8

    // AXI Manager Interface 1 Read Channel (Data) ECC Protection Correctable
    // Error Interrupt Status bit.
    // This error occurs if ECC Correctable error is detected on the AXI Channel
    // Read Data payload. 
    // 1: (Active_PROT_CorrERR): AXI Manager 1 Read Channel (Data) Correctable 
    //    Error detected
    // 0: (Inactive_PROT_CorrERR): AXI Manager 1 Read Channel (Data) Correctable
    //    Error not detected
    uint32_t     MXIF1_RCH0_PROT_CorrERR_STATUS:1;                // 9

    // AXI Manager Interface 1 Read Channel (Data) Parity/ECC Protection 
    // Uncorrectable Error Interrupt Status bit.
    // This error occurs if Parity/ECC Uncorrectable error is detected on the AXI
    // Channel Read Data payload.
    // 1: (Active_PROT_UnCorrERR): AXI Manager 1 Read Channel (Data) Uncorrectable
    //    Error detected
    // 0: (Inactive_PROT_UnCorrERR): AXI Manager 1 Read Channel (Data) Uncorrectable
    //    Error not detected
    uint32_t     MXIF1_RCH0_PROT_UnCorrERR_STATUS:1;              // 10

    // AXI Manager Interface 1 Read Channel (Other Control signals) ECC Protection 
    // Correctable Error Interrupt Status bit.
    // This error occurs if ECC Correctable error is detected on the AXI Channel 
    // Read Control payload.
    // 1: (Active_PROT_CorrERR): AXI Manager 1 Read Channel (Other Control signals)
    //    Correctable Error detected
    // 0: (Inactive_PROT_CorrERR): AXI Manager 1 Read Channel (Other Control signals)
    //    Correctable Error not detected
    uint32_t     MXIF1_RCH1_PROT_CorrERR_STATUS:1;                // 11

    // AXI Manager Interface 1 Read Channel (Other Control signals) Parity/ECC 
    // Protection Uncorrectable Error Interrupt Status bit.
    // This error occurs if Parity/ECC Uncorrectable error is detected on the AXI
    // Channel Read Control payload.
    // 1: (Active_PROT_UnCorrERR): AXI Manager 1 Read Channel (Other Control signals)
    //    Uncorrectable Error detected
    // 0: (Inactive_PROT_UnCorrERR): AXI Manager 1 Read Channel (Other Control signals)
    //    Uncorrectable Error not detected
    uint32_t    MXIF1_RCH1_PROT_UnCorrERR_STATUS:1;               // 12

    // AXI Manager Interface 1 Write Response Channel ECC Protection Correctable
    // Error Interrupt Status bit.
    // This error occurs if ECC Correctable error is detected on the AXI Channel 
    // Write Response payload.
    // 1: (Active_PROT_CorrERR): AXI Manager 1 Write Response Channel Correctable
    //    Error detected
    // 0: (Inactive_PROT_CorrERR): AXI Manager 1 Write Response Channel Correctable
    //    Error not detected
    uint32_t     MXIF1_BCH_PROT_CorrERR_STATUS:1;                 // 13

    // AXI Manager Interface 1 Write Response Channel Parity/ECC Protection 
    // Uncorrectable Error Interrupt Status bit.
    // This error occurs if Parity/ECC Uncorrectable error is detected on the AXI
    // Channel Write Response payload.
    // 1: (Active_PROT_UnCorrERR): AXI Manager 1 Write Response Channel Uncorrectable
    //    Error detected
    // 0: (Inactive_PROT_UnCorrERR): AXI Manager 1 Write Response Channel Uncorrectable
    //    Error not detected    
    uint32_t     MXIF1_BCH_PROT_UnCorrERR_STAT:1;               // 14

    // AXI Manager Interface 2 Read Channel (Data) ECC Protection Correctable Error
    // Interrupt Status bit.
    // This error occurs if ECC Correctable error is detected on the AXI Channel 
    // Read Data payload.
    // 1: (Active_PROT_CorrERR): AXI Manager 2 Read Channel (Data) Correctable 
    //    Error detected
    // 0: (Inactive_PROT_CorrERR): AXI Manager 2 Read Channel (Data) Correctable 
    //    Error not detected
    uint32_t    MXIF2_RCH0_PROT_CorrERR_STATUS:1;                 // 15

    // AXI Manager Interface 2 Read Channel (Data) Parity/ECC Protection 
    // Uncorrectable Error Interrupt Status bit.
    // This error occurs if Parity/ECC Uncorrectable error is detected on the AXI
    // Channel Read Data payload.
    // 1: (Active_PROT_UnCorrERR): AXI Manager 2 Read Channel (Data) Uncorrectable 
    //    Error detected
    // 0: (Inactive_PROT_UnCorrERR): AXI Manager 2 Read Channel (Data) Uncorrectable
    //    Error not detected
    uint32_t    MXIF2_RCH0_PROT_UnCorrERR_STATUS:1;               // 16

    // AXI Manager Interface 2 Read Channel (Other Control signals) ECC Protection
    // Correctable Error Interrupt Status bit.
    // This error occurs if ECC Correctable error is detected on the AXI Channel Read
    // Control payload.
    // 1: (Active_PROT_CorrERR): AXI Manager 2 Read Channel (Other Control signals)
    //    Correctable Error detected
    // 0: (Inactive_PROT_CorrERR): AXI Manager 2 Read Channel (Other Control signals)
    //    Correctable Error not detected
    uint32_t    MXIF2_RCH1_PROT_CorrERR_STATUS:1;                 // 17

    // AXI Manager Interface 1 Read Channel (Other Control signals) Parity/ECC 
    // Protection Uncorrectable Error Interrupt Status bit.
    // This error occurs if Parity/ECC Uncorrectable error is detected on the AXI 
    // Channel Read Control payload.
    // 1: (Active_PROT_UnCorrERR): AXI Manager 2 Read Channel (Other Control signals)
    //    Uncorrectable Error detected
    // 0: (Inactive_PROT_UnCorrERR): AXI Manager 2 Read Channel (Other Control signals)
    //    Uncorrectable Error not detected
    uint32_t    MXIF2_RCH1_PROT_UnCorrERR_STATUS:1;               // 18

    // AXI Manager Interface 2 Write Response Channel ECC Protection Correctable 
    // Error Interrupt Status bit.
    // This error occurs if ECC Correctable error is detected on the AXI Channel 
    // Write Response payload.
    // 1: (Active_PROT_CorrERR): AXI Manager 2 Write Response Channel Correctable 
    //    Error detected
    // 0: (Inactive_PROT_CorrERR): AXI Manager 2 Write Response Channel Correctable
    //    Error not detected.
    uint32_t    MXIF2_BCH_PROT_CorrERR_STATUS:1;                  // 19

    // AXI Manager Interface 2 Write Response Channel Parity/ECC Protection Uncorrectable
    // Error Interrupt Status bit.
    // This error occurs if Parity/ECC Uncorrectable error is detected on the AXI Channel
    // Write Response payload.  
    // 1: (Active_PROT_UnCorrERR): AXI Manager 2 Write Response Channel Uncorrectable 
    //    Error detected
    // 0: (Inactive_PROT_UnCorrERR): AXI Manager 2 Write Response Channel Uncorrectable
    //    Error not detected
    uint32_t    MXIF2_BCH_PROT_UnCorrERR_STATUS:1;                // 20

    // AXI Manager Interface 1 Read Address Channel ARREADY Parity Protection Error 
    // Interrupt Status bit.
    // This error occurs if ARREADY Parity error is detected on the Read Address AXI Channel. 
    // 1: (Active_PROT_ARREADY_ParErr): AXI Manager 1 Read Address Channel ARREADY Parity
    //    Error detected
    // 0: (Inactive_PROT_ARREADY_ParErr): AXI Manager 1 Read Address Channel ARREADY Parity
    //    Error not detected    
    uint32_t    MXIF1_ARCH_PROT_ARREADY_ParErr_STATUS:1;          // 21

    // AXI Manager Interface 1 Write Address Channel AWREADY Parity Protection Error 
    // Interrupt Status bit.
    // This error occurs if AWREADY Parity error is detected on the Write Address AXI Channel.
    // 1: (Active_PROT_AWREADY_ParErr): AXI Manager 1 Write Address Channel AWREADY Parity 
    //    Error detected
    // 0: (Inactive_PROT_AWREADY_ParErr): AXI Manager 1 Write Address Channel AWREADY Parity 
    //    Error not detected
    uint32_t     MXIF1_AWCH_PROT_AWREADY_ParErr_STATUS:1;         // 22

    // AXI Manager Interface 1 Write Data Channel WREADY Parity Protection Error 
    // Interrupt Status bit.
    // This error occurs if WREADY Parity error is detected on the Write Data AXI Channel.
    // 1: (Active_PROT_WREADY_ParErr): AXI Manager 1 Write Data Channel WREADY Parity
    //    Error detected
    // 0: (Inactive_PROT_WREADY_ParErr): AXI Manager 1 Write Data Channel WREADY Parity
    //    Error not detected
    uint32_t     MXIF1_WCH_PROT_WREADY_ParErr_STATUS:1;           // 23

    // AXI Manager Interface 1 Read Data Channel RVALID Parity Protection Error Interrupt
    // Status bit.
    // This error occurs if RVALID Parity error is detected on the Read Data AXI Channel.
    // 1: (Active_PROT_RVALID_ParErr): AXI Manager 1 Read Data Channel RVALID Parity 
    //    Error detected
    // 0: (Inactive_PROT_RVALID_ParErr): AXI Manager 1 Read Data Channel RVALID Parity 
    //    Error not detected
    uint32_t    MXIF1_RCH_PROT_RVALID_ParErr_STATUS:1;            // 24

    // AXI Manager Interface 1 Write Response Channel BVALID Parity Protection Error
    // Interrupt Status bit.
    // This error occurs if BVALID Parity error is detected on the Write Response AXI Channel.    
    // 1: (Active_PROT_BVALID_ParErr): AXI Manager 1 Write Response Channel BVALID Parity
    //    Error detected
    // 0: (Inactive_PROT_BVALID_ParErr): AXI Manager 1 Write Response Channel BVALID Parity
    //    Error not detected    
    uint32_t     MXIF1_BCH_PROT_BVALID_ParErr_STATUS:1;           // 25

    // AXI Manager Interface 2 Read Address Channel ARREADY Parity Protection Error 
    // Interrupt Status bit.
    // This error occurs if ARREADY Parity error is detected on the Read Address AXI Channel.
    // 1: (Active_PROT_ARREADY_ParErr): AXI Manager 2 Read Address Channel ARREADY Parity 
    //    Error detected
    // 0: (Inactive_PROT_ARREADY_ParErr): AXI Manager 2 Read Address Channel ARREADY Parity 
    //    Error not detected
    uint32_t     MXIF2_ARCH_PROT_ARREADY_ParErr_STATUS:1;         // 26

    // AXI Manager Interface 2 Write Address Channel AWREADY Parity Protection Error
    // Interrupt Status bit.
    // This error occurs if AWREADY Parity error is detected on the Write Address AXI Channel.
    // 1: (Active_PROT_AWREADY_ParErr): AXI Manager 2 Write Address Channel AWREADY Parity 
    //    Error detected
    // 0: (Inactive_PROT_AWREADY_ParErr): AXI Manager 2 Write Address Channel AWREADY Parity
    //    Error not detected
    uint32_t    MXIF2_AWCH_PROT_AWREADY_ParErr_STATUS:1;          // 27

    // AXI Manager Interface 2 Write Data Channel WREADY Parity Protection Error 
    // Interrupt Status bit.
    // This error occurs if WREADY Parity error is detected on the Write Data AXI Channel.
    // 1: (Active_PROT_WREADY_ParErr): AXI Manager 2 Write Data Channel WREADY Parity Error 
    //    detected
    // 0: (Inactive_PROT_WREADY_ParErr): AXI Manager 2 Write Data Channel WREADY Parity Error 
    //    not detected
    uint32_t    MXIF2_WCH_PROT_WREADY_ParErr_STATUS:1;            // 28

    // AXI Manager Interface 2 Read Data Channel RVALID Parity Protection Error 
    // Interrupt Status bit.
    // This error occurs if RVALID Parity error is detected on the Read Data AXI Channel.
    // 1: (Active_PROT_RVALID_ParErr): AXI Manager 2 Read Data Channel RVALID Parity Error
    //    detected
    // 0: (Inactive_PROT_RVALID_ParErr): AXI Manager 2 Read Data Channel RVALID Parity Error
    //    not detected
    uint32_t    MXIF2_RCH_PROT_RVALID_ParErr_STATUS:1;            // 29

    // AXI Manager Interface 2 Write Response Channel BVALID Parity Protection Error
    // Interrupt Status bit.
    // This error occurs if BVALID Parity error is detected on the Write Response AXI Channel.
    // 1: (Active_PROT_BVALID_ParErr): AXI Manager 2 Write Response Channel BVALID Parity
    //    Error detected
    // 0: (Inactive_PROT_BVALID_ParErr): AXI Manager 2 Write Response Channel BVALID Parity
    //    Error not detected   
    uint32_t    MXIF2_BCH_PROT_BVALID_ParErr_STATUS:1;            // 30
    uint32_t    rsvd1:1;                                        // 31   reserved
};

union XCOMINTS_L_REG {
    uint32_t          all;
    struct XCOMMINTS_L_BITS          bit;
};

struct XCOMINTS_H_BITS {   
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XCOMINTS_H_REG {
    uint32_t          all;
    struct XCOMINTS_H_BITS          bit;
};

struct XRESET_L_BITS {      
    uint32_t    rsvd1:31;                                   // 31:1   reserved
    // DMAC Reset Request bit
    // Software writes 1 to this bit to reset the DW_axi_dmac and polls this bit to see 
    // it as 0. DW_axi_dmac resets all the modules except the register bus interface 
    // module and clears this bit to 0.
    // Note: Software is not allowed to write 0 to this bit.
    uint32_t    RST:1;                                      // 31
};

union XRESET_L_REG {
    uint32_t          all;
    struct XRESET_L_BITS          bit;
};

struct XRESET_H_BITS {   
    uint32_t    RSVD:32;                                    // 31:0   Reserved field - read-only
};

union XRESET_H_REG {
    uint32_t          all;
    struct XRESET_H_BITS          bit;
};

struct XCFGLOWP_L_BITS {            
    // Global Context Sensitive Low Power feature enable.
    // 0: (GBL_CSLP_DISABLE): Global Context Sensitive Low Power feature is disabled
    // 1: (GBL_CSLP_ENABLE): Global Context Sensitive Low Power feature is enabled
    uint32_t    GBL_CSLP_EN:1;              // 0 

    // DMA Channel Context Sensitive Low Power feature enable.
    // 1: (CHNL_CSLP_ENABLE): DMA Channel Context Sensitive Low Power feature is enabled
    // 0: (CHNL_CSLP_DISABLE): DMA Channel Context Sensitive Low Power feature is disabled
    uint32_t    CHNL_CSLP_EN:1;             // 1

    // SBIU Context Sensitive Low Power feature enable.
    // 1: (SBIU_CSLP_ENABLE): SBIU Context Sensitive Low Power feature is enabled
    // 0: (SBIU_CSLP_DISABLE): SBIU Context Sensitive Low Power feature is disabled
    uint32_t    SBIU_CSLP_EN:1;             // 2
    
    // AXI Manager Interface Context Sensitive Low Power feature enable.
    // 1: (MXIF_CSLP_ENABLE): AXI Manager Interface Context Sensitive Low Power 
    //    feature is enabled      
    // 0: (MXIF_CSLP_DISABLE): AXI Manager Interface Context Sensitive Low Power 
    //    feature is disabled 
    uint32_t    MXIF_CSLP_EN:1;             // 3
    uint32_t    rsvd1:28;                   // 31:4   reserved
};

union XCFGLOWP_L_REG {
    uint32_t          all;
    struct XCFGLOWP_L_BITS          bit;
};

struct XCFGLOWP_H_BITS { 
    // Defines the load value to be programmed into the Global and DMA Channel low power
    // delay counter. 
    // The programmed value must be greater than or equal to 0x4. If value programmed is
    // less than 0x4, then the register value is reset to DMAX_GLCH_LPDLY. The maximum 
    // value programmed into this register field is limited to (2**DMAX_GLCH_LPDLY_WIDTH)-1,
    // otherwise the upper bits (8-DMAX_GLCH_LPDLY_WIDTH) of this field is reset to 0x0.    
    uint32_t     GLCH_LPDLY:8;              // 7:0

    // Defines the load value to be programmed into the SBIU low power delay counter.
    // The programmed value must be greater than or equal to 0x4. If value programmed 
    // is less than 0x4, then the register value is reset to DMAX_SBIU_LPDLY. The maximum
    // value programmed into this register field is limited to (2**DMAX_SBIU_LPDLY_WIDTH)-1,
    // otherwise the upper bits (8-DMAX_SBIU_LPDLY_WIDTH) of this field is reset to 0x0.
    uint32_t    SBIU_LPDLY:8;               // 15:8
    
    // Defines the load value to be programmed into the AXI Manager Interface low 
    // power delay counter. 
    // The programmed value must be greater than or equal to 0x4. If value programmed is 
    // less than 0x4, then the register value is reset to DMAX_MXIF_LPDLY. The maximum 
    // value programmed into this register field is limited to (2**DMAX_MXIF_LPDLY_WIDTH)-1,
    // otherwise the upper bits (8-DMAX_MXIF_LPDLY_WIDTH) of this field is reset to 0x0.
    uint32_t    MXIF_LPDLY:8;               // 23:16 
    uint32_t    rsvd1:8;                    // 31:24 Reserved field- read-only
};

union XCFGLOWP_H_REG {
    uint32_t          all;
    struct XCFGLOWP_H_BITS          bit;
};

struct XCOMPAR_L_BITS {    
    // This field is used to enable/disable the Parity Protection feature.
    // 1: (Enable_PARITY): The Parity check for registers in the common/channel register
    //    space is Enabled
    // 0: (Disable_PARITY): The Parity check for registers in the common/channel register
    //    space is Disabled
    uint32_t     PARITY_EN:1;               // 0

    // Parity Mode, selects the even or odd parity scheme for the Parity Protection feature.
    // 1: (Odd_PARITY_MODE): The Odd Parity check is used for registers in the 
    //    Common/Channel Specific space      
    // 0: (Even_PARITY_MODE): The Even Parity check is used for registers in the 
    //    Common/Channel Specific space 
    uint32_t    PARITY_MODE:1;              // 1
    uint32_t    rsvd1:30;                   // 31:2   Reserved field - read-only
};

union XCOMPAR_L_REG {
    uint32_t          all;
    struct XCOMPAR_L_BITS          bit;
};

struct XCOMPAR_H_BITS {
    uint32_t    RSVD:32;            // 31:0   reserved
};

union XCOMPAR_H_REG {
    uint32_t          all;
    struct XCOMPAR_H_BITS          bit;
};

struct XCOMECC_L_BITS {            // bits   description
    uint32_t    rsvd3:4;                        // 3:0  reserved

    // ECC Error Count Reset
    // This bit is used to reset the ECC Protection Correctable and Uncorrectable 
    // Counters. This bit is automatically cleared after all internal ECC Error 
    // counters are cleared.
    // 0: (ECC_COUNT_NORST): Do not Reset the ECC error Counters
    // 1: (ECC_COUNT_RST): Reset the ECC error Counters 
    uint32_t    ECC_ERR_COUNT_RST:1;            // 4

    // ECC Protected Interace Type
    // This is used to select the required interface that is protected through the 
    // ECC. This field is used to multiplex the correctable, uncorrectable error 
    // counters for the interfaces types like FIFO Memory Interface, AXI Memory Interface. 
    // If the reserved value is programmed, then counter will return all zeroes.
    // 0: (ECC_CH_MEMIF): Channel FIFO Memory Interface
    // 1: (ECC_UID_MEMIF): Channel UID Memory Interface
    // 2: (ECC_AXI_MXIF): AXI Manager Interface
    // 3: (RSV_ECC_INTFC): Reserved
    uint32_t     ECC_INTFC_TYPE:2;              // 6:5

    // ECC Protected Interface Number
    // This is used to provide the interface number of specific interface type to
    // multiplex the correctable and uncorrectable error counters. 
    // The encoding of this field is as follows:
    // When ECC_INTFC_TYPE = 0x0 or 0x1 
    //      This field value can vary from 1 to DMAX_NUM_CHANNELS. If illegal value
    //      is programmed to this field i.e. value beyond the configured number of 
    //      channels, then counter will return all zeroes.
    // When ECC_INTFC_TYPE = 0x2
    //      Then this field values can change as mentioned below:
    //        ECC_INTFC_NO[11:10] = 2'b00
    //        ECC_INTFC_NO[9] = DMAX_NUM_MASTER_IF-1.
    //          AXI Manager Interface Number can vary from 0 to DMAX_NUM_MASTER_IF-1. 
    //          If illegal value is programmed to this field i.e. value beyond the 
    //          configured number AXI Manager interfaces, then counter will return all
    //          zeroes.
    //        ECC_INTFC_NO[8:7] = This field is used to select the specific channel of
    //          a AXI Manager Interface. 2'b00: AXI Read Data Channel - RCH0 (ECC counter
    //          of Read data), 2'b01: AXI Read Data Channel - RCH1 (ECC counter of Read 
    //          Data Channel other signals), 2'b10: AXI Write Response Channel - BCH
    // If illegal value is programmed to this field, then counter will return all zeroes.
    uint32_t    ECC_INTFC_NO:5;                 // 11:7  
    uint32_t    rsvd2:4;                        // 15:12 reserved
    
    // ECC Correctable Error count
    // This field provides the number of correctable error detected since the ECC
    // Error count reset or soft reset or dmac_resetn.
    uint32_t    ECC_CORR_ERR_COUNT:10;          // 25:16
    uint32_t    rsvd1:6;                        // 31:26 reserved
};

union XCOMECC_L_REG {
    uint32_t          all;
    struct XCOMECC_L_BITS          bit;
};

struct XCOMECC_H_BITS {      
    // ECC Uncorrectable Error count
    // This field provides the number of uncorrectable error detected since the ECC
    // Error count reset or soft reset or dmac_resetn.    
    uint32_t    ECC_UNCORR_ERR_COUNT:10;        // 9:0
    uint32_t    rsvd1:22;                       // 31:10   Reserved field - read-only
};

union XCOMECC_H_REG {
    uint32_t          all;
    struct XCOMECC_H_BITS          bit;
};

struct XCOMERRINJSFTY_L_BITS { 
    // This bit enables error injection on FIFO or UID memory interface. The error 
    // injection type is specified using the field ECC_EI_TYPE.
    // 1: (EI_ENABLE): Enable data path Error Injection.
    // 0: (EI_DISABLE): Disable data path Error Injection.
    uint32_t     SFTY_EI_EN:1;                  // 0
    
    // These bits select the target memory interface to introduce the ECC error.
    // 1: (EI_UID_MEM): Select UID memory interface for error Injection.
    // 0: (EI_FIFO_MEM): Select FIFO memory interface for error Injection.
    uint32_t     SFTY_EI_FEATURE:4;             // 4:1

    // These bits select the channel number to inject the ECC error. 
    // Where channel number varies from 0 to 7 for FIFO/UID memory interfaces
    uint32_t    SFTY_EI_CH:3;                   // 7:5
    uint32_t    rsvd2:2;                        // 9:8
    

    // Single or double-bit error 
    // This bit selects the single or double-bit error injection. This field is active 
    // when ECC_EI_EN is 1. The bit position for error insertion is selected using 
    // ECC_BIT_SEL field in the same register. The error injection point is specified
    // by ECC_EI_POINTS field.
    // 1: (EI_DOUBLE_BIT): Insert double bit error.
    // 0: (EI_SINGLE_BIT): Insert single bit error.    
    uint32_t    ECC_EI_TYPE:1;                  // 10  

    // This bit field selects the address, data, or ECC checkbits for ECC error injection.
    // 0: (EI_ADDRESS): Address Error Injection.
    // 1: (EI_DATA): Data Error Injection.
    // 2: (EI_ECC_CHECKBITS): ECC Checkbits Error Injection
    uint32_t    ECC_EI_POINTS:3;                // 13:11 
    
    // These bits are programmed to select the bit position to introduce a data 
    // path ECC error. 
    // Note: All the bit locations may not be used for data and ECC Checkbits error
    // injection. 
    // The valid values for this field are:
    //     Address: 0 to (LOG2_DMAX_CHx_y_DEPTH-1) 
    //     Data: 0 to (DMAX_CHx_FIFO_WIDTH-1)
    //     ECC Checkbits: 0 to (DMAX_CHx_y_ECC_WIDTH-1)    
    uint32_t    SFTY_BIT_SEL:9;                 // 22:14
    
    uint32_t    rsvd1:9;                        // 31:23   reserved
};

union XCOMERRINJSFTY_L_REG {
    uint32_t          all;
    struct XCOMERRINJSFTY_L_BITS          bit;
};

struct XCOMERRINJSFTY_H_BITS {  
    uint32_t    RSVD:32;            // 31:0 Reserved field - read-only
};

union XCOMERRINJSFTY_H_REG {
    uint32_t          all;
    struct XCOMERRINJSFTY_H_BITS          bit;
};




struct XSAR_L_BITS {  
    // Current Source Address of DMA transfer.
    // Updated after each source transfer. The SINC fields in the CHx_CTL register
    // determines whether the address increments or is left unchanged on every 
    // source transfer throughout the block transfer.    
    uint32_t    SAR:32;                         // 31:0 
};

union XSAR_L_REG {
    uint32_t          all;
    struct XSAR_L_BITS          bit;
};

struct XSAR_H_BITS { 
    // Current Source Address of DMA transfer.
    // Updated after each source transfer. The SINC fields in the CHx_CTL register
    // determines whether the address increments or is left unchanged on every 
    // source transfer throughout the block transfer.       
    uint32_t    SAR:32;                         // 31:0   
};

union XSAR_H_REG {
    uint32_t          all;
    struct XSAR_H_BITS          bit;
};

struct XDAR_L_BITS {    
    // Current Destination Address of DMA transfer.
    // Updated after each destination transfer. The DINC fields in the CHx_CTL 
    // register determines whether the address increments or is left unchanged
    // on every destination transfer throughout the block transfer.
    uint32_t    DAR:32;                         // 31:0   
};

union XDAR_L_REG {
    uint32_t          all;
    struct XDAR_L_BITS          bit;
};

struct XDAR_H_BITS {
    // Current Destination Address of DMA transfer.
    // Updated after each destination transfer. The DINC fields in the CHx_CTL 
    // register determines whether the address increments or is left unchanged
    // on every destination transfer throughout the block transfer.    
    uint32_t    DAR:32;                         // 31:0 
};

union XDAR_H_REG {
    uint32_t          all;
    struct XDAR_H_BITS          bit;
};

struct XBLOCK_L_BITS {   
    // Block Transfer Size.
    // The number programmed into BLOCK_TS field indicates the total number of 
    // data of width CHx_CTL.SRC_TR_WIDTH to be transferred in a DMA block transfer.
    // Block Transfer Size = BLOCK_TS+1 
    uint32_t    BLOCK_TS:22;                    // 21:0    
    uint32_t    rsvd1:10;                       // 31:22 Reserved field - read-only
};

union XBLOCK_L_REG {
    uint32_t          all;
    struct XBLOCK_L_BITS          bit;
};

struct XBLOCK_H_BITS {            // bits   description
    uint32_t    RSVD:32;            // 31:0   Reserved field - read-only
};

union XBLOCK_H_REG {
    uint32_t          all;
    struct XBLOCK_H_BITS          bit;
};

struct XCTL_L_BITS { 
    // Source Manager Select.
    // Identifies the Manager Interface layer from which the source device 
    // (peripheral or memory) is accessed.
    // 1: (MASTER2_INTF): Source device on Manager-2 interface layer
    // 0: (MASTER1_INTF): Source device on Manager-1 interface layer
    uint32_t    SMS:1;                          // 0
    uint32_t    rsvd5:1;                        // 1

    // Destination Manager Select.
    // Identifies the Manager Interface layer from which the destination device 
    // (peripheral or memory) is accessed.
    // 1: (MASTER2_INTF): Destination device on Manager-2 interface layer
    // 0: (MASTER1_INTF): Destination device on Manager-1 interface layer
    uint32_t    DMS:1;                          // 2
    uint32_t    rsvd4:1;                        // 3 reserved

    // Source Address Increment.
    // Indicates whether to increment the source address on every source transfer.
    // If the device is fetching data from a source peripheral FIFO with a fixed 
    // address, then set this field to 'No change'.
    // 0: (INCREMENTAL): Source address incremented on every source transfer
    // 1: (FIXED): Source address is fixed
    uint32_t    SINC:1;                         // 4
    uint32_t    rsvd3:1;                        // 5 reserved

    // Destination Address Increment.
    // Indicates whether to increment the destination address on every destination
    // transfer. If the device is writing data from a source peripheral FIFO with 
    // a fixed address, then set this field to 'No change'. 
    // 0: (INCREMENTAL): Destination address incremented on every source transfer
    // 1: (FIXED): Destination address is fixed    
    uint32_t    DINC:1;                         // 6
    uint32_t    rsvd2:1;                        // 7 reserved
    
    // Source Transfer Width.
    // Mapped to AXI bus arsize, this value must be less than or equal to 
    // DMAX_M_DATA_WIDTH.
    // 0: (BITS_8): Source Transfer Width is 8 bits
    // 1: (BITS_16): Source Transfer Width is 16 bits
    // 2: (BITS_32): Source Transfer Width is 32 bits
    // 3: (BITS_64): Source Transfer Width is 64 bits
    // 4: (BITS_128): Source Transfer Width is 128 bits
    // 5: (BITS_256): Source Transfer Width is 256 bits
    // 6: (BITS_512): Source Transfer Width is 512 bits
    // 7: (BITS_1024): Source Transfer Width is 1024 bits
    uint32_t    SRC_TR_WIDTH:3;                 // 10:8

    // Destination Transfer Width.
    // Mapped to AXI bus awsize, this value must be less than or equal to 
    // DMAX_M_DATA_WIDTH.
    // 0: (BITS_8): Destination Transfer Width is 8 bits
    // 1: (BITS_16): Destination Transfer Width is 16 bits
    // 2: (BITS_32): Destination Transfer Width is 32 bits
    // 3: (BITS_64): Destination Transfer Width is 64 bits
    // 4: (BITS_128): Destination Transfer Width is 128 bits
    // 5: (BITS_256): Destination Transfer Width is 256 bits
    // 6: (BITS_512): Destination Transfer Width is 512 bits
    // 7: (BITS_1024): Destination Transfer Width is 1024 bits
    uint32_t    DST_TR_WIDTH:3;                 // 13: 11

    // Source Burst Transaction Length.
    // Number of data items, each of width CHx_CTL.SRC_TR_WIDTH, to be read from
    // the source every time a source burst transaction request is made from the 
    // corresponding hardware or software handshaking interface. 
    // The maximum value of DST_MSIZE is limited by DMAX_CHx_MAX_MSIZE.
    // 0: (DATA_ITEM_1): 1 Data Item read from Source in the burst transaction
    // 1: (DATA_ITEMS_4): 4 Data Item read from Source in the burst transaction
    // 2: (DATA_ITEMS_8): 8 Data Item read from Source in the burst transaction
    // 3: (DATA_ITEMS_16): 16 Data Item read from Source in the burst transaction
    // 4: (DATA_ITEMS_32): 32 Data Item read from Source in the burst transaction
    // 5: (DATA_ITEMS_64): 64 Data Item read from Source in the burst transaction
    // 6: (DATA_ITEMS_128): 128 Data Item read from Source in the burst transaction
    // 7: (DATA_ITEMS_256): 256 Data Item read from Source in the burst transaction
    // 8: (DATA_ITEMS_512): 512 Data Item read from Source in the burst transaction
    // 9: (DATA_ITEMS_1024): 1024 Data Item read from Source in the burst transaction
    uint32_t    SRC_MSIZE:4;                    // 17:14

    // Destination Burst Transaction Length.
    // Number of data items, each of width CHx_CTL.DST_TR_WIDTH, to be written
    // to the destination every time a destination burst transaction request is
    // made from the corresponding hardware or software handshaking interface.
    // 0: (DATA_ITEM_1): 1 Data Item write to Destination in the burst transaction
    // 1: (DATA_ITEMS_4): 4 Data Item write to Destination in the burst transaction
    // 2: (DATA_ITEMS_8): 8 Data Item write to Destination in the burst transaction
    // 3: (DATA_ITEMS_16): 16 Data Item write to Destination in the burst transaction
    // 4: (DATA_ITEMS_32): 32 Data Item write to Destination in the burst transaction
    // 5: (DATA_ITEMS_64): 64 Data Item write to Destination in the burst transaction
    // 6: (DATA_ITEMS_128): 128 Data Item write to Destination in the burst transaction
    // 7: (DATA_ITEMS_256): 256 Data Item write to Destination in the burst transaction
    // 8: (DATA_ITEMS_512): 512 Data Item write to Destination in the burst transaction
    // 9: (DATA_ITEMS_1024): 1024 Data Item write to Destination in the burst transaction
    uint32_t    DST_MSIZE:4;                    // 21:18

    // AXI 'ar_cache' signal
    uint32_t    AR_CACHE:4;                     // 25:22

    // AXI 'aw_cache' signal
    uint32_t    AW_CACHE:4;                     // 29:26

    // Non Posted Last Write Enable
    // This bit decides whether posted writes can be used throughout the block
    // transfer.
    // 1 (Enable): Last write in the block must be non-posted
    // 0 (Disable): Posted writes may be used throughout the block transfer
    uint32_t    NonPosted_LastWrite_En:1;       // 30
    uint32_t    rsvd1:1;                        // 31   reserved
};

union XCTL_L_REG {
    uint32_t          all;
    struct XCTL_L_BITS          bit;
};

struct XCTL_H_BITS { 
    // AXI 'ar_prot' signal
    uint32_t    AR_PROT:3;                      // 2:0

    // AXI 'aw_prot' signal
    uint32_t    AW_PROT:3;                      // 5:3

    // Source Burst Length Enable
    // If this bit is set to 1, DW_axi_dmac uses the value of CHx_CTL.ARLEN 
    // as AXI Burst length for source data transfer till the extent possible; 
    // remaining transfers use maximum possible burst length.
    // If this bit is set to 0, DW_axi_dmac uses any possible value that is 
    // less than or equal to DMAX_CHx_MAX_AMBA_BURST_LENGTH as AXI Burst 
    // length for source data transfer.
    // 1: (Enable): AXI Burst Length is CHx_CTL.ARLEN (till the extent possible)
    //    for Source data transfers
    // 0: (Disable): AXI Burst Length is any possible value <= DMAX_CHx_MAX_AMBA
    //    _BURST_LENGTH for Source data transfers
    uint32_t    ARLEN_EN:1;                     // 6

    // Source Burst Length
    // AXI Burst length used for source data transfer. The specified burst length
    // is used for source data transfer till the extent possible; remaining 
    // transfers use maximum possible value that is less than or equal to 
    // DMAX_CHx_MAX_AMBA_BURST_LENGTH. The maximum value of ARLEN is limited by 
    // DMAX_CHx_MAX_AMBA_BURST_LENGTH
    uint32_t    ARLEN:8;                        // 14:7

    // Destination Burst Length Enable
    // If this bit is set to 1, DW_axi_dmac uses the value of CHx_CTL.AWLEN as 
    // AXI Burst length for destination data transfer till the extent possible;
    // remaining transfers use maximum possible burst length.
    // 1: (Enable): AXI Burst Length is CH1_CTL.AWLEN (till the extent possible)
    //    for Destination data transfers
    // 0: (Disable): AXI Burst Length is any possible value <= DMAX_CH1_MAX_AMBA
    //    _BURST_LENGTH for Destination data transfers
    uint32_t    AWLEN_EN:1;                     // 15

    // Destination Burst Length
    // AXI Burst length used for destination data transfer. The specified burst
    // length is used for destination data transfer till the extent possible; 
    // remaining transfers use maximum possible value that is less than or equal
    // to DMAX_CHx_MAX_AMBA_BURST_LENGTH.
    // The maximum value of AWLEN is limited by DMAX_CHx_MAX_AMBA_BURST_LENGTH.    
    uint32_t    AWLEN:8;                        // 23:16

    // Source Status Enable
    // Enable the logic to fetch status from source peripheral of channel x 
    // pointed to by the content of CHx_SSTATAR register and stores it in 
    // CHx_SSTAT register. This value is written back to the CHx_SSTAT 
    // location of linked list at end of each block transfer if DMAX_CHx
    // _LLI_WB_EN is set to 1 and if linked list based multi-block transfer 
    // is used by either source or destination peripheral.
    // 1: (Enable_STAT_FETCH): Enables status fetch for Source and store the 
    //    value in CH1_SSTAT register
    // 0: (NO_STAT_FETCH): No status fetch for Source device    
    uint32_t    SRC_STAT_EN:1;                  // 24

    // Destination Status Enable
    // Enable the logic to fetch status from destination peripheral of channel x
    // pointed to by the content of CHx_DSTATAR register and stores it in 
    // CHx_DSTAT register. This value is written back to the CHx_DSTAT location
    // of linked list at end of each block transfer if DMAX_CHx_LLI_WB_EN is set
    // to 1 and if linked list based multi-block transfer is used by either source 
    // or destination peripheral.
    // 1: (Enable_STAT_FETCH): Enables status fetch for Destination and store 
    //    the value in CH1_DSTAT register
    // 0: (NO_STAT_FETCH): No status fetch for Destination device    
    uint32_t    DST_STAT_EN:1;                  // 25
    
    // Interrupt On completion of Block Transfer
    // This bit is used to control the block transfer completion interrupt 
    // generation on a block by block basis for shadow register or linked list
    // based multi-block transfers. Writing 1 to this register field enables
    // 1: (Enable_BLKTFR_INTR): Enables CHx_IntStatusReg.BLOCK_TFR_DONE_IntStat field
    // 0: (DISABLE_BLKTFR_INTR): Disables CHx_IntStatusReg.BLOCK_TFR_DONE_IntStat field    
    uint32_t    IOC_BlkTfr:1;                   // 26
    uint32_t    rsvd1:3;                        // 29:27 reserved

    // Last Shadow Register/Linked List Item.
    // Indicates whether shadow register content or the linked list item fetched
    // from the memory is the last one or not.
    // 1: (LAST_ITEM): Indicates shadowreg/LLI content is the last one
    // 0: (NOT_LAST_ITEM): Indicates shadowreg/LLI content is not the last one    
    uint32_t    SHADOWREG_OR_LLI_LAST:1;       // 30.

    // Shadow Register content/Linked List Item valid.
    // Indicates whether the content of shadow register or the linked list item
    // fetched from the memory is valid.
    // 1: (VALID): Indicates shadowreg/LLI content is Valid
    // 0: (INVALID): Indicates shadowreg/LLI content is Invalid
    uint32_t    SHADOWREG_OR_LLI_VALID:1;       // 31
};

union XCTL_H_REG {
    uint32_t          all;
    struct XCTL_H_BITS          bit;
};

struct XCFG_L_BITS {
    // Source Multi Block Transfer Type.
    // These bits define the type of multi-block transfer used for source 
    // peripheral.    
    // 0: (CONTINGUOUS): Contiguous Multiblock Type used for Source Transfer
    // 1: (RELOAD): Reload Multiblock Type used for Source Transfer
    // 2: (SHADOW_REGISTER): Shadow Register based Multiblock Type used for
    //    Source Transfer
    // 3: (LINKED_LIST): Linked List based Multiblock Type used for Source Transfer    
    uint32_t    SRC_MULTBLK_TYPE:2;             // 1:0

    // Destination Multi Block Transfer Type.
    // These bits define the type of multi-block transfer used for destination
    // peripheral.
    // 0: (CONTINGUOUS): Contiguous Multiblock Type used for Destination Transfer
    // 1: (RELOAD): Reload Multiblock Type used for Destination Transfer
    // 2: (SHADOW_REGISTER): Shadow Register based Multiblock Type used for 
    //    Destination Transfer
    // 3: (LINKED_LIST): Linked List based Multiblock Type used for Destination 
    //    Transfer
    uint32_t    DST_MULTBLK_TYPE:2;             // 3:2
    uint32_t    rsvd3:14;                       // 17:4

    // Defines the number of AXI Unique ID's supported for the AXI Read Channel.
    // The value programmed must be less than or equal to DMAX_CH(x)_RD_UID. 
    // Otherwise, it is limited by the value DMAX_CH(x)_RD_UID.
    uint32_t    RD_UID:4;                       // 21:18
    uint32_t    rsvd2:3;                        // 24:22    reserved

    // Defines the number of AXI Unique ID's supported for the AXI Write Channel.
    // The value programmed must be less than or equal to DMAX_CH(x)_WR_UID. 
    // Otherwise, it is limited by the value DMAX_CH(x)_WR_UID.    
    uint32_t    WR_UID:4;                       // 28:25
    uint32_t    rsvd1:3;                        // 31:29    reserved
};

union XCFG_L_REG {
    uint32_t          all;
    struct XCFG_L_BITS          bit;
};

struct XCFG_H_BITS { 
    // Transfer Type and Flow Control.
    // The following transfer types are supported.
    //    Memory to Memory 
    //    Memory to Peripheral 
    //    Peripheral to Memory 
    //    Peripheral to Peripheral 
    // Flow Control can be assigned to the DW_axi_dmac, the source peripheral, 
    // or the destination peripheral.
    // 0: (MEM_TO_MEM_DMAC): Transfer Type is memory to memory and Flow 
    //    Controller is DW_axi_dmac
    // 1: (MEM_TO_PER_DMAC): Transfer Type is memory to peripheral and Flow 
    //    Controller is DW_axi_dmac
    // 2: (PER_TO_MEM_DMAC): Transfer Type is peripheral to memory and Flow
    //    Controller is DW_axi_dmac
    // 3: (PER_TO_PER_DMAC): Transfer Type is peripheral to peripheral and Flow
    //    Controller is DW_axi_dmac
    // 4: (PER_TO_MEM_SRC): Transfer Type is peripheral to Memory and Flow 
    //    Controller is Source peripheral
    // 5: (PER_TO_PER_SRC): Transfer Type is peripheral to peripheral and Flow
    //    Controller is Source peripheral
    // 6: (MEM_TO_PER_DST): Transfer Type is memory to peripheral and Flow 
    //    Controller is Destination peripheral
    // 7: (PER_TO_PER_DST): Transfer Type is peripheral to peripheral and Flow
    //    Controller is Destination peripheral    
    uint32_t    TT_FC:3;                        // 2:0

    // Source Software or Hardware Handshaking Select.
    // This register selects which of the handshaking interfaces (hardware or
    // software) is active for source requests on this channel. 
    // 0: (HARDWARE_HS): Hardware Handshaking Interface is used for the Source
    //    peripheral
    // 1: (SOFTWARE_HS): Software Handshaking Interface is used for the Source 
    //    peripheral    
    uint32_t    HS_SEL_SRC:1;                   // 3

    // Destination Software or Hardware Handshaking Select.
    // This register selects which of the handshaking interfaces (hardware or
    // software) is active for destination requests on this channel.
    // 0: (HARDWARE_HS): Hardware Handshaking Interface is used for the 
    //    Destination peripheral
    // 1: (SOFTWARE_HS): Software Handshaking Interface is used for the 
    //    Destination peripheral
    uint32_t     HS_SEL_DST:1;                  // 4

    //  Source Hardware Handshaking Interface Polarity.
    // 0: (ACTIVE_HIGH): Polarity of the Handshaking Interface used for the
    //    Source peripheral is Active High
    // 1: (ACTIVE_LOW): Polarity of the Handshaking Interface used for the 
    //    Source peripheral is Active Low
    uint32_t    SRC_HWHS_POL:1;                 // 5

    // Destination Hardware Handshaking Interface Polarity.
    // 0: (ACTIVE_HIGH): Polarity of the Handshaking Interface used for the
    //    Destination peripheral is Active High
    // 1: (ACTIVE_LOW): Polarity of the Handshaking Interface used for the 
    //    Destination peripheral is Active Low
    uint32_t    DST_HWHS_POL:1;                 // 6

    // Assigns a hardware handshaking interface (0 - DMAX_NUM_HS_IF-1) to the 
    // source of Channelx if the CHx_CFG.HS_SEL_SRC field is 0; otherwise, 
    // this field is ignored. The channel can then communicate with the source 
    // peripheral connected to that interface through the assigned hardware 
    // handshaking interface.
    uint32_t    SRC_PER:4;                      // 10:7
    uint32_t    rsvd3:1;                        // 11   reserved

    // Assigns a hardware handshaking interface (0 - DMAX_NUM_HS_IF-1) to the
    // destination of Channelx if the CHx_CFG.HS_SEL_DST field is 0; otherwise,
    // this field is ignored. The channel can then communicate with the destination
    // peripheral connected to that interface through the assigned hardware 
    // handshaking interface.    
    uint32_t    DST_PER:4;                      // 15:12
    uint32_t    rsvd2:1;                        // 16   reserved

    // Channel Priority
    // This field must be programmed within the following range: from 0 to 
    // DMAX_NUM_CHANNELS-1. A programmed value outside this range will cause 
    // erroneous behavior
    // The highest priority: DMAX_NUM_CHANNELS-1 
    // The lowest priority: 0 
    uint32_t    CH_PRIOR:3;                     // 19:17

    // Channel Lock bit
    // When the channel is granted control of the manager bus interface and if
    // the CHx_CFG.LOCK_CH bit is asserted, then no other channels are granted 
    // control of the manager bus interface for the duration specified in CHx_CFG.
    // LOCK_CH_L. Indicates to the manager bus interface arbiter that this channel 
    // wants exclusive access to the manager bus interface for the duration 
    // specified in CHx_CFG.LOCK_CH_L. This field does not exist if the configuration
    // parameter DMAX_CHx_LOCK_EN is set to False; in this case, the read-back value
    // is always 0. Locking the channel locks AXI Read Address, Write Address and 
    // Write Data channels on the corresponding manager interface.    
    // 0: (NO_CHANNEL_LOCK): Channel is not locked during the transfers
    // 1: (CHANNEL_LOCK): Channel is locked and granted exclusive access to the 
    //    Manager Bus Interface
    uint32_t    LOCK_CH:1;                      // 20
    
    // Channel Lock Level
    // This bit indicates the duration over which CHx_CFG.LOCK_CH bit applies.
    // 1: (BLOCK_TRANFER_CH_LOCK): Duration of the Channel locking is for the 
    //    current block transfer
    // 0: (DMA_transfer_CH_LOCK): Duration of the Channel locking is for the 
    //    entire DMA transfer
    uint32_t    LOCK_CH_L:2;                    // 22:21

    // Source Outstanding Request Limit
    // Maximum outstanding request supported is 16.
    // Source Outstanding Request Limit = SRC_OSR_LMT + 1    
    uint32_t    SRC_OSR_LMT:4;                  // 26:23
    
    // Destination Outstanding Request Limit
    // Maximum outstanding request supported is 16.
    // Destination Outstanding Request Limit = DST_OSR_LMT + 1
    uint32_t    DST_OSR_LMT:4;                  // 30:27
    uint32_t    rsvd1:1;                        // 31   reserved
};

union XCFG_H_REG {
    uint32_t          all;
    struct XCFG_H_BITS          bit;
};

struct XLLP_L_BITS {            // bits   description
    // LLI manager Select
    // This bit identifies the AXI layer/interface where the memory device that
    // stores the next linked list item resides.
    // 0: (MANAGER1_INTF): next Linked List item resides on AXI Manager1 interface
    // 1: (MANAGER2_INTF): next Linked List item resides on AXI Manager2 interface    
    uint32_t    LMS:1;                          // 0
    uint32_t    rsvd1:5;                        // 5:1  reserved

    // Starting Address Memory of LLI block
    // Starting Address In Memory of next LLI if block chaining is enabled. The
    // six LSBs of the starting address are not stored because the address is 
    // assumed to be aligned to a 64-byte boundary.
    // LLI access always uses the burst size (arsize/awsize) that is same as 
    // the data bus width and cannot be changed or programmed to anything 
    // other than this. Burst length (awlen/arlen) is chosen based on the data 
    // bus width so that the access does not cross one complete LLI structure 
    // of 64 bytes. DW_axi_dmac will fetch the entire LLI (40 bytes) in one AXI
    // burst if the burst length is not limited by other settings.
    uint32_t    LOC:26;                         // 31:6
};

union XLLP_L_REG {
    uint32_t          all;
    struct XLLP_L_BITS          bit;
};

struct XLLP_H_BITS { 
    // Starting Address Memory of LLI block
    // Starting Address In Memory of next LLI if block chaining is enabled. The
    // six LSBs of the starting address are not stored because the address is 
    // assumed to be aligned to a 64-byte boundary.
    // LLI access always uses the burst size (arsize/awsize) that is same as 
    // the data bus width and cannot be changed or programmed to anything 
    // other than this. Burst length (awlen/arlen) is chosen based on the data 
    // bus width so that the access does not cross one complete LLI structure 
    // of 64 bytes. DW_axi_dmac will fetch the entire LLI (40 bytes) in one AXI
    // burst if the burst length is not limited by other settings.
    uint32_t    LOC:32;                         // 31:0
};

union XLLP_H_REG {
    uint32_t          all;
    struct XLLP_H_BITS          bit;
};

struct XSTATUS_L_BITS {   
    // Completed Block Transfer Size.
    // The Completed Block Transfer Size status indicates the total number of
    // data items transferred from the Source 
    // memory/peripheral to the Destination memory/peripheral at any point in
    // the DMA block transfer.
    // The completed block transfer size or data items is defined as follows:
    // When DMA or Source is a Flow controller, this field is defined in terms
    //   of the CHx_CTL.SRC_TR_WIDTH.
    // When Destination is a Flow Controller, this field is defined in terms 
    //   of the CHx_CTL.DST_TR_WIDTH.
    uint32_t    CMPLTD_BLK_TFR_SIZE:22;         // 21:0
    uint32_t    rsvd1:10;                       // 31:22    Reserved
};

union XSTATUS_L_REG {
    uint32_t          all;
    struct XSTATUS_L_BITS          bit;
};

struct XSTATUS_H_BITS {

    // Data Left in FIFO.
    // The data left in the FIFO status indicates the total number of data left
    // in the channel FIFO after completing the current DMA block transfer or 
    // DMA block abnormal termination due to the following reasons: 
    //    AXI Transfer Error response (SLVERR or DECERR) reception
    //    Channel Terminate
    // The width of the data in channel FIFO is defined in terms of CHx_CTL.SRC_
    // TR_WIDTH. For more information, see "DMA Status Register - CHx_STATUSREG"
    // section of the databook.
    uint32_t    DATA_LEFT_IN_FIFO:15;           // 14:0
    uint32_t    rsvd1:17;                       // 31:15   Reserved
};

union XSTATUS_H_REG {
    uint32_t          all;
    struct XSTATUS_H_BITS          bit;
};

struct XSWHSSRC_L_BITS {
    // Software Handshake Request for Channel Source.
    // This bit is used to request dma source data transfer if software handshaking
    // method is selected for the source of the corresponding channel.
    // 1: (ACTIVE_SWHS_REQ_SRC): Source peripheral request for a dma transfer
    // 0: (INACTIVE_SWHS_REQ_SRC): Source peripheral is not requesting for a burst
    //    transfer
    uint32_t    SWHS_REQ_SRC:1;                 // 0

    // Write Enable bit for Software Handshake Request for Channel Source.
    // 1: (ENABLE_SWHS_REQ_SRC): Enables write to the SWHS_REQ_SRC bit
    // 0: (DISABLE_SWHS_REQ_SRC): Disables write to the SWHS_REQ_SRC bit
    uint32_t    SWHS_REQ_SRC_WE:1;              // 1

    // Software Handshake Single Request for Channel Source.
    // This bit is used to request SINGLE (AXI burst length = 1) dma source data 
    // transfer if software handshaking method is selected for the source of the
    // corresponding channel. This bit is ignored if software handshaking is not
    // enabled for the source of the Channelx. The functionality of this field 
    // depends on whether the peripheral is the flow controller. Software can only
    // set this bit to 1; it is not allowed to clear this bit to 0; only 
    // DW_axi_dmac can clear this bit.
    // 1: (ACTIVE_SWHS_SGLREQ_SRC): Source peripheral request for a single dma transfer
    // 0: (INACTIVE_SWHS_SGLREQ_SRC): Source peripheral is not requesting for a 
    //    single transfer    
    uint32_t    SWHS_SGLREQ_SRC:1;             // 2

    // Write Enable bit for Software Handshake Single Request for Channel Source.
    // 1: (ENABLE_SWHS_SGLREQ_SRC): Enables write to the SWHS_SGLREQ_SRC bit
    // 0: (DISABLE_SWHS_SGLREQ_SRC): Disables write to the SWHS_SGLREQ_SRC bit
    uint32_t   	SWHS_SGLREQ_SRC_WE:1;           // 3
    
    // Software Handshake Last Request for Channel Source.
    // This bit is used to request LAST dma source data transfer if software 
    // handshaking method is selected for the source of the corresponding channel.
    // 1: (ACTIVE_SWHS_LAST_SRC): Source peripheral indication to DMAC that the 
    //    current transfer is the last transfer
    // 0: (INACTIVE_SWHS_LAST_SRC): Source peripheral indication that the current
    //    transfer is not the last transfer    
    uint32_t    SWHS_LST_SRC:1;                 // 4

    // Write Enable bit for Software Handshake Last Request for Channel Source.
    // 1: (ENABLE_SWHS_LAST_SRC): Enables write to the SWHS_LAST_SRC bit
    // 0: (DISABLE_SWHS_LAST_SRC): Disables write to the SWHS_LAST_SRC bit
    uint32_t    SWHS_LST_SRC_WE:1;              // 5
    uint32_t    rsvd1:26;                       // 31:6    Reserved.
};

union XSWHSSRC_L_REG {
    uint32_t            all;
    struct XSWHSSRC_L_BITS          bit;
};

struct XSWHSSRC_H_BITS {    
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XSWHSSRC_H_REG {
    uint32_t            all;
    struct XSWHSSRC_H_BITS          bit;
};

struct XSWHSDST_L_BITS {
    // Software Handshake Request for Channel Destination.
    // This bit is used to request dma destination data transfer if software handshaking
    // method is selected for the destination of the corresponding channel.
    // 1: (ACTIVE_SWHS_REQ_DST): Destination peripheral request for a dma transfer
    // 0: (INACTIVE_SWHS_REQ_DST): Destination peripheral is not requesting for 
    //    a burst transfer
    uint32_t    SWHS_REQ_DST:1;

    // Write Enable bit for Software Handshake Request for Channel Destination.
    // 1: (ENABLE_SWHS_REQ_DST): Enables write to the SWHS_REQ_DST bit
    // 0: (DISABLE_SWHS_REQ_DST): Disables write to the SWHS_REQ_DST bit
    uint32_t    SWHS_REQ_DST_WE:1;              // 1

    // Software Handshake Single Request for Channel Destination.
    // This bit is used to request SINGLE (AXI burst length = 1) dma destination
    // data transfer if software handshaking method is selected for the destination
    // of the corresponding channel.
    // This bit is ignored if software handshaking is not enabled for the destination
    // of the Channelx. The functionality of this field depends on whether the 
    // peripheral is the flow controller. Software can only set this bit to 1; it is
    // not allowed to clear this bit to 0; only DW_axi_dmac can clear this bit.
    // 1: (ACTIVE_SWHS_SGLREQ_DST): Destination peripheral request for a single dma
    //    transfer
    // 0: (INACTIVE_SWHS_SGLREQ_DST): Destination peripheral is not requesting for 
    //    a single transfer  
    uint32_t    SWHS_SGLREQ_DST:1;             // 2

    // Write Enable bit for Software Handshake Single Request for Channel Destination.
    // 1: (ENABLE_SWHS_SGLREQ_DST): Enables write to the SWHS_SGLREQ_DST bit
    // 0: (DISABLE_SWHS_SGLREQ_DST): Disables write to the SWHS_SGLREQ_DST bit
    uint32_t    SWHS_SGLREQ_DST_WE:1;           // 3
    
    // Software Handshake Last Request for Channel Destination.
    // This bit is used to request LAST dma destination data transfer if software 
    // handshaking method is selected for the destination of the corresponding channel.
    // 1: (ACTIVE_SWHS_LAST_DST): Destination peripheral indication to DMAC that 
    //    the current transfer is the last transfer
    // 0: (INACTIVE_SWHS_LAST_DST): Destination peripheral indication that the 
    //    current transfer is not the last transfer  
    uint32_t    SWHS_LST_DST:1;                 // 4

    // Write Enable bit for Software Handshake Last Request for Channel Destination.
    // 1: (ENABLE_SWHS_LAST_DST): Enables write to the SWHS_LAST_DST bit
    // 0: (DISABLE_SWHS_LAST_DST): Disables write to the SWHS_LAST_DST bit
    uint32_t    SWHS_LST_DST_WE:1;              // 5
    uint32_t    rsvd1:26;                       // 31:6    Reserved.
};

union XSWHSDST_L_REG {
    uint32_t            all;
    struct XSWHSDST_L_BITS          bit;
};

struct XSWHSDST_H_BITS {    
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XSWHSDST_H_REG {
    uint32_t            all;
    struct XSWHSDST_H_BITS          bit;
};

struct XBTFRREQ_L_BITS {
    // Block Transfer Resume Request during Linked-List or Shadow-Register-based
    // multi-block transfer. 
    // 1: (ACTIVE_BLK_TFR_RESUMEREQ): Request for resuming the block transfer
    // 0: (INACTIVE_BLK_TFR_RESUMEREQ): No request to resume the block transfer
    uint32_t    BLK_TFR_RESUMEREQ:1;            // 0
    uint32_t    rsvd1:31;                       // 31:1    Reserved.
};

union XBTFRREQ_L_REG {
    uint32_t            all;
    struct XBTFRREQ_L_BITS          bit;
};

struct XBTFRREQ_H_BITS {    
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XBTFRREQ_H_REG {
    uint32_t            all;
    struct XBTFRREQ_H_BITS          bit;
};

struct XID_L_BITS {
    // AXI Read ID Suffix
    // These bits form part of the ARID output of AXI3/AXI4 manager interface.
    // IDW = DMAX_M_ID_WIDTH
    // L2NC = log2(DMAX_NUM_CHANNELS)    
    // The upper L2NC+1 bits of awidN is derived from the channel number which
    // is currently accessing the manager interface. This varies for LLI fetch
    // and source data transfer.
    // For source data transfer, awidN for channel1 4'b0000, awidN for channel8 
    // 4'b0111 and so on.
    // For LLI fetch access, awidN for channel1 4'b1000, awidN for channel8 
    // 4'b1111 and so on.
    uint32_t    AXI_READ_ID_SUFFIX:4;           // 3:0
    uint32_t    rsvd2:12;                       // 15:4

    // AXI Write ID Suffix.
    // These bits form part of the AWID output of AXI3/AXI4 manager interface.
    // IDW = DMAX_M_ID_WIDTH
    // L2NC = log2(DMAX_NUM_CHANNELS)
    // The upper L2NC+1 bits of aridN is derived from the channel number which
    // is currently accessing the manager interface. This varies for LLI fetch
    // and source data transfer. 
    // For source data transfer, aridN for channel1 4'b0000, aridN for channel8
    // 4'b0111 and so on.
    // For LLI fetch access, aridN for channel1 4'b1000, aridN for channel8 
    // 4'b1111 and so on. Lower bits are same as the value    
    uint32_t    AXI_WRITE_ID_SUFFIX:4;          // 19:16
    uint32_t    rsvd1:12;                       // 31:20    Reserved.
};

union XID_L_REG {
    uint32_t            all;
    struct XID_L_BITS          bit;
};

struct XID_H_BITS {    
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XID_H_REG {
    uint32_t            all;
    struct XID_H_BITS          bit;
};

struct XQOS_L_BITS {
    // AXI AWQOS.
    // These bits form the awqos output of AXI4 manager interface.
    uint32_t    AXI_AWQOS:4;                    // 3:0

    // AXI ARQOS.
    // These bits form the arqos output of AXI4 manager interface.  
    uint32_t    AXI_ARQOS:4;                   // 7:4
    uint32_t    rsvd1:24;                       // 31:8    Reserved.
};

union XQOS_L_REG {
    uint32_t            all;
    struct XQOS_L_BITS          bit;
};

struct XQOS_H_BITS {    
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XQOS_H_REG {
    uint32_t            all;
    struct XQOS_H_BITS          bit;
};

struct XSSTAT_L_BITS {
    // Source Status
    // Source status information retrieved by hardware from the address pointed 
    // to by the contents of the CHx_SSTATAR register.
    // Source peripheral should update the source status information, if any, 
    // at the location pointed to by CHx_SSTATAR to utilize this feature.This 
    // status is not related to any internal status of DW_axi_dmac. This status
    // is not related to any internal status of DW_axi_dmac.      
    uint32_t    SSTAT:32;                       // 31:0
};

union XSSTAT_L_REG {
    uint32_t            all;
    struct XSSTAT_L_BITS          bit;
};

struct XSSTAT_H_BITS {      
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XSSTAT_H_REG {
    uint32_t            all;
    struct XSSTAT_H_BITS          bit;
};

struct XDSTAT_L_BITS {
    // Destination Status
    // Destination status information retrieved by hardware from the address 
    // pointed to by the contents of the CHx_DSTATAR register.
    // Destination peripheral should update the destination status information,
    // if any, at the location pointed to by CHx_DSTATAR to utilize this feature.
    // This status is not related to any internal status of DW_axi_dmac.
    uint32_t    DSTAT:32;                       // 31:0
};

union XDSTAT_L_REG {
    uint32_t            all;
    struct XDSTAT_L_BITS          bit;
};

struct XDSTAT_H_BITS {      
    uint32_t    RSVD:32;                        // 31:0    Reserved.
};

union XDSTAT_H_REG {
    uint32_t            all;
    struct XDSTAT_H_BITS          bit;
};

struct XSSTATAR_L_BITS {
    // Source Status Fetch Address
    // Pointer from where hardware can fetch the source status information, which
    // is registered in the CHx_SSTAT register and written out to the CHx_SSTAT 
    // register location of the LLI before the start of the next block if DMAX_CHx
    // _LLI_WB_EN = 1 and linked list based multi-block transfer is enabled for either 
    // source or destination peripheral of the channel. 
    // Source peripheral should update the source status 
    // information, if any, at the location pointed to by CHx_SSTATAR to utilize 
    // this feature.This status is not related to any internal status of DW_axi_dmac.
    uint32_t    SSTATAR:32;                     // 31:0
};

union XSSTATAR_L_REG {
    uint32_t            all;
    struct XSSTATAR_L_BITS          bit;
};

struct XSSTATAR_H_BITS {      
    // Source Status Fetch Address
    // Pointer from where hardware can fetch the source status information, which
    // is registered in the CHx_SSTAT register and written out to the CHx_SSTAT 
    // register location of the LLI before the start of the next block if DMAX_CHx
    // _LLI_WB_EN = 1 and linked list based multi-block transfer is enabled for either 
    // source or destination peripheral of the channel. 
    // Source peripheral should update the source status 
    // information, if any, at the location pointed to by CHx_SSTATAR to utilize 
    // this feature.This status is not related to any internal status of DW_axi_dmac.    
    uint32_t    SSTATAR:32;                      // 31:0   
};

union XSSTATAR_H_REG {
    uint32_t            all;
    struct XSSTATAR_H_BITS          bit;
};

struct XDSTATAR_L_BITS {
    // Destination Status Fetch Address
    // Pointer from where hardware can fetch the Destination status information, 
    // which is registered in the CHx_DSTAT register and written out to the 
    // CHx_DSTAT register location of the LLI before the start of the next block
    // if DMAX_CHx_LLI_WB_EN = 1 and linked list based multi-block transfer is 
    // enabled for either source or destination peripheral of the channel.
    // Destination peripheral should update the destination status 
    // information, if any, at the location pointed to by CHx_DSTATAR to utilize 
    // this feature. This status is not related to any internal status of DW_axi_dmac.
    uint32_t    DSTATAR:32;                     // 31:0
};

union XDSTATAR_L_REG {
    uint32_t            all;
    struct XDSTATAR_L_BITS          bit;
};

struct XDSTATAR_H_BITS {      
    // Destination Status Fetch Address
    // Pointer from where hardware can fetch the Destination status information, 
    // which is registered in the CHx_DSTAT register and written out to the 
    // CHx_DSTAT register location of the LLI before the start of the next block
    // if DMAX_CHx_LLI_WB_EN = 1 and linked list based multi-block transfer is 
    // enabled for either source or destination peripheral of the channel.
    // Destination peripheral should update the destination status 
    // information, if any, at the location pointed to by CHx_DSTATAR to utilize 
    // this feature. This status is not related to any internal status of DW_axi_dmac.    
    uint32_t    DSTATAR:32;                      // 31:0   
};

union XDSTATAR_H_REG {
    uint32_t            all;
    struct XDSTATAR_H_BITS          bit;
};

struct XENINTS_L_BITS {
    // Block Transfer Done Interrupt Status Enable.
    // 1: (ENABLE_BLOCK_TFR_DONE): Enable the generation of Block Transfer Done
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_BLOCK_TFR_DONE): Disable the generation of Block Transfer Done
    //    Interrupt in CHx_INTSTATUSREG
    uint32_t    BLOCK_TFR_DONE_EN:1;                    // 0

    // DMA Transfer Done Interrupt Status Enable.
    // 1: (ENABLE_DMA_TFR_DONE): Enable the generation of DMA Transfer Done 
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_DMA_TFR_DONE): Disable the generation of DMA Transfer Done
    //    Interrupt in CHx_INTSTATUSREG  
    // DMA Transfer Done Interrupt Status Enable.
    uint32_t    DMA_TFR_DONE_EN:1;                      // 1
    uint32_t    rsvd4:1;                                // 2    Reserved

    // Source Transaction Completed Status Enable.
    // 1: (ENABLE_SRC_TRANSCOMP): Enable the generation of Source Transaction
    //    Complete Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SRC_TRANSCOMP): Disable the generation of Source Transaction
    //    Complete Interrupt in CHx_INTSTATUSREG
    uint32_t    SRC_TRANSCOMP_EN:1;                    // 3

    // Destination Transaction Completed Status Enable.
    // 1: (ENABLE_DST_TRANSCOMP): Enable the generation of Destination 
    //    Transaction complete Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_DST_TRANSCOMP): Disable the generation of Destination 
    //    Transaction complete Interrupt in CHx_INTSTATUSREG
    uint32_t    DST_TRANSCOMP_EN:1;                     // 4

    // Source Decode Error Status Enable.
    // 1: (ENABLE_SRC_DEC_ERR): Enable the generation of Source Decode Error 
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SRC_DEC_ERR): Disable the generation of Source Decode Error
    //    Interrupt in CHx_INTSTATUSREG
    uint32_t    SRC_DEC_ERR_EN:1;                       // 5

    // Destination Decode Error Status Enable.
    // 1: (ENABLE_DST_DEC_ERR): Enable the generation of Destination Decode Error
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_DST_DEC_ERR): Disable the generation of Destination Decode Error
    //    Interrupt in CHx_INTSTATUSREG
    uint32_t    DST_DEC_ERR_EN:1;                      // 6

    // Source Subordinate Error Status Enable.
    // 1: (ENABLE_SRC_SLV_ERR): Enable the generation of Source Subordinate Error
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SRC_SLV_ERR): Disable the generation of Source Subordinate Error
    //    Interrupt in CHx_INTSTATUSREG
    uint32_t    SRC_SLV_ERR:1;                          // 7

    // Destination Subordinate Error Status Enable.
    // 1: (ENABLE_DST_SLV_ERR): Enable the generation of Destination Subordinate
    //    Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_DST_SLV_ERR): Disable the generation of Destination Subordinate
    //    Error Interrupt in CHx_INTSTATUSREG
    uint32_t    DST_SLV_ERR_EN:1;                       // 8

    // LLI Read Decode Error Status Enable.
    // 1: (ENABLE_LLI_RD_DEC_ERR): Enable the generation of LLI Read Decode 
    //    Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_LLI_RD_DEC_ERR): Disable the generation of LLI Read Decode
    //    Error Interrupt in CHx_INTSTATUSREG
    uint32_t    e_LLI_RD_DEC_ERR:1;                     // 9

    // LLI WRITE Decode Error Status Enable.
    // 1: (ENABLE_LLI_WR_DEC_ERR): Enable the generation of LLI WRITE Decode Error
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_LLI_WR_DEC_ERR): Disable the generation of LLI WRITE Decode 
    //    Error Interrupt in CHx_INTSTATUSREG
    uint32_t    _LLI_WR_DEC_ERR_EN:1;                   // 10

    // LLI Read Subordinate Error Status Enable.
    // 1: (ENABLE_LLI_RD_SLV_ERR): Enable the generation of LLI Read Subordinate 
    //    Error Interrupt in CH1_INTSTATUSREG
    // 0: (DISABLE_LLI_RD_SLV_ERR): Disable the generation of LLI Read Subordinate
    //    Error Interrupt in CH1_INTSTATUSREG
    uint32_t    LLI_RD_SLV_ERR_EN:1;                    // 11

    // LLI WRITE Subordinate Error Status Enable.
    // 1: (ENABLE_LLI_WR_SLV_ERR): Enable the generation of LLI WRITE Subordinate
    //    Error Interrupt in CH1_INTSTATUSREG
    // 0: (DISABLE_LLI_WR_SLV_ERR): Disable the generation of LLI WRITE Subordinate
    //    Error Interrupt in CH1_INTSTATUSREG
    uint32_t    _LLI_WR_SLV_ERR_EN:1;                   // 12

    // Shadow register or LLI Invalid Error Status Enable.
    // 1: (ENABLE_SHADOWREG_OR_LLI_INVALID_ERR): Enable the generation of Shadow 
    //    Register or LLI Invalid Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SHADOWREG_OR_LLI_INVALID_ERR): Disable the generation of Shadow
    //    Register or LLI Invalid Error Interrupt in CHx_INTSTATUSREG        
    uint32_t    SHADOWREG_OR_LLI_INVALID_ERR_EN:1;      // 13

    // Register Bus Interface Multi Block type Error Status Enable.
    // 1: (ENABLE_SLVIF_MULTIBLKTYPE_ERR): Enable the generation of Register Bus
    //    Interface Multi Block type Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SLVIF_MULTIBLKTYPE_ERR): Disable the generation of Register Bus
    //    Interface Multi Block type Error Interrupt in CHx_INTSTATUSREG    
    uint32_t    SLVIF_MULTIBLKTYPE_ERR_EN:1;            // 14
    uint32_t    rsvd3:1;                                // 15   Reserved

    // Register Bus Interface Decode Error Status Enable.
    // 1: (ENABLE_SLVIF_DEC_ERR): Enable the generation of Register Bus Interface
    //    Decode Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SLVIF_DEC_ERR): Disable the generation of Register Bus Interface
    //    Decode Error Interrupt in CHx_INTSTATUSREG
    uint32_t    SLVIF_DEC_ERR_EN:1;                     // 16

    // Register Bus Interface Write to Read Only Error Status Enable.
    // 1: (ENABLE_SLVIF_WR2RO_ERR): Enable the generation of Register Bus Interface
    //    Write to Read Only Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SLVIF_WR2RO_ERR): Disable the generation of Register Bus Interface
    //    Write to Read only Error Interrupt in CHx_INTSTATUSREG
    uint32_t    SLVIF_WR2RO_ERR_EN:1;                   // 17

    // Register Bus Interface Read to write Only Error Status Enable.
    // 1: (ENABLE_SLVIF_RD2RWO_ERR): Enable the generation of Register Bus Interface
    //    Read to Write Only Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SLVIF_RD2RWO_ERR): Disable the generation of Register Bus 
    //    Interface Read to Write only Error Interrupt in CHx_INTSTATUSREG
    uint32_t    SLVIF_RD2RWO_ERR_EN:1;                  // 18

    // Register Bus Interface Write On Channel Enabled Error Status Enable.
    // 1: (ENABLE_SLVIF_WRONCHEN_ERR): Enable the generation of Register Bus 
    //    Interface Write On Channel enabled Error Interrupt in CH1_INTSTATUSREG
    // 0: (DISABLE_SLVIF_WRONCHEN_ERR): Disable the generation of Register 
    //    Bus Interface Write On Channel enabled Error Interrupt in CH1_INTSTATUSREG
    uint32_t    SLVIF_WRONCHEN_ERR_EN:1;               // 19

    // Shadow Register Write On Valid Error Status Enable.
    // 1: (ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR): Enable the generation of Shadow
    //    register Write On Valid Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SLVIF_SHADOWREG_WRON_VALID_ERR): Disable the generation of Shadow 
    //    Register Write On Valid Error Interrupt in CHx_INTSTATUSREG
    uint32_t    SLVIF_SHADOWREG_WRON_VALID_ERR_EN:1;    // 20

    // Register Bus Interface Write On Hold Error Status Enable.
    // 1: (ENABLE_SLVIF_WRONHOLD_ERR): Enable the generation of Register Bus 
    //    Interface Write On Hold Error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_SLVIF_WRONHOLD_ERR): Disable the generation of Register Bus
    //    Interface Write On Hold Error Interrupt in CHx_INTSTATUSREG
    uint32_t    SLVIF_WRONHOLD_ERR_EN:1;                // 21
    uint32_t    rsvd2:2;                                // 23:22    Reserved

    // Register Bus Interface Address Parity Error Enable.
    // 1: (Enable_SLVIF_ADDRPARITY_ERR): Enable the generation of Register Bus
    //    Interface Address Parity Error in CHx_INTSTATUSREG
    // 0: (Disable_SLVIF_ADDRPARITY_ERR): Disable the generation of Register Bus
    //    Interface Address Parity Error in CHx_INTSTATUSREG
    uint32_t    SLVIF_ADDRPARITY_ERR_EN:1;              // 24

    // Register Bus Interface Write Parity Error Enable.
    // 1: (Enable_SLVIF_WRPARITY_ERR): Enable the generation of Register Bus 
    //    Interface Write Parity Error in CHx_INTSTATUSREG
    // 0: (Disable_SLVIF_WRPARITY_ERR): Disable the generation of Register Bus
    //    Interface Write Parity Error in CHx_INTSTATUSREG
    uint32_t    SLVIF_WRPARITY_ERR_EN:1;                // 25
    uint32_t    rsvd1:1;                                // 26   Reserved

    // Channel Lock Cleared Status Enable.
    // 1: (ENABLE_CH_LOCK_CLEARED): Enable the generation of Channel LOCK 
    //    CLEARED Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_CH_LOCK_CLEARED): Disable the generation of Channel LOCK
    //    CLEARED Interrupt in CHx_INTSTATUSREG        
    uint32_t    CH_LOCK_CLEARED_EN:1;                   // 27

    // Channel Source Suspended Status Enable.
    // 1: (ENABLE_CH_SRC_SUSPENDED): Enable the generation of Channel Source
    //    Suspended Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_CH_SRC_SUSPENDED): Disable the generation of Channel Source
    //    Suspended Interrupt in CHx_INTSTATUSREG
    uint32_t    CH_SRC_SUSPENDED_EN:1;                  // 28

    // Channel Suspended Status Enable.
    // 1: (ENABLE_CH_SUSPENDED): Enable the generation of Channel Suspended 
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_CH_SUSPENDED): Disable the generation of Channel Suspended
    //    Interrupt in CHx_INTSTATUSREG
    uint32_t    CH_SUSPENDED_EN:1;                      // 29

    // Channel Disabled Status Enable.    
    // 1: (ENABLE_CH_DISABLED): Enable the generation of Channel Disabled 
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_CH_DISABLED): Disable the generation of Channel Disabled
    //    Interrupt in CHx_INTSTATUSREG    
    uint32_t    CH_DISABLED_EN:1;                       // 30

    // Channel Terminated Status Enable.
    // 1: (ENABLE_CH_ABORTED): Enable the generation of Channel Terminated 
    //    Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_CH_ABORTED): Disable the generation of Channel Terminated
    //    Interrupt in CHx_INTSTATUSREG    
    uint32_t    CH_ABORTED_EN:1;                        // 31
};

union XENINTS_L_REG {
    uint32_t            all;
    struct XENINTS_L_BITS          bit;
};

struct XENINTS_H_BITS {     
    // Channel x Channel Memory Interface ECC Protection Correctable Error 
    // Interrupt enable. 
    // 1: (ENABLE_ECC_CHMEM_CORRERR): Enable the propagation of Channel Memory
    //    ECC Correctable error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_ECC_CHMEM_CORRERR): Disable the propagation of Channel 
    //    Memory ECC Correctable error Interrupt in CHx_INTSTATUSREG    
    uint32_t    ECC_PROT_CHMem_CorrERR:1;               // 0

    // Channel x Channel Memory Interface ECC Protection Uncorrectable Error
    // Interrupt enable.
    // 1: (ENABLE_ECC_CHMEM_UNCORRERR): Enable the propagation of Channel 
    //    Memory ECC Uncorrectable error Interrupt in CHx_INTSTATUSREG
    // 0: (DISABLE_ECC_CHMEM_UNCORRERR): Disable the propagation of Channel 
    //    Memory ECC Uncorrectable error Interrupt in CHx_INTSTATUSREG
    uint32_t    ECC_PROT_CHMem_UnCorrERR:1;             // 1

    // Channel x Unique ID Memory Interface ECC Protection Correctable Error 
    // Interrupt enable.
    // 1: (ENABLE_ECC_UIDMEM_CORRERR): Enable the propagation of UID Memory 
    //    ECC Correctable error interrupt in CH1_INTSTATUSREG
    // 0: (DISABLE_ECC_UIDMEM_CORRERR): Disable the propagation of UID Memory
    //    ECC Correctable error interrupt in CH1_INTSTATUSREG
    uint32_t    ECC_PROT_UIDMem_CorrERR:1;              // 2

    // Channel x Unique ID Memory Interface ECC Protection Uncorrectable Error
    // Interrupt enable.   
    // 1: (ENABLE_ECC_UIDMEM_UNCORRERR): Enable the propagation of UID Memory 
    //    ECC Uncorrectable error Interrupt in CH1_INTSTATUSREG
    // 0: (DISABLE_ECC_UIDMEM_UNCORRERR): Disable the propagation of UID Memory
    //    ECC Uncorrectable error Interrupt in CH1_INTSTATUSREG
    uint32_t    ECC_PROT_UIDMem_UnCorrERR_EN:1;         // 3
    uint32_t    rsvd1:28;                               // 31:4   
};

union XENINTS_H_REG {
    uint32_t            all;
    struct XENINTS_H_BITS          bit;
};

struct XINTS_L_BITS {
    // Block Transfer Done.
    // This indicates to the software that the DW_axi_dmac has completed the 
    // requested block transfer.
    // The DW_axi_dmac sets this bit to 1 when the transfer is successfully completed.
    // 1 (BLOCK_TFR_COMPLETED): Block Transfer completed
    // 0 (BLOCK_TFR_NOT_COMPLETE): Block Transfer not complete    
    uint32_t    BLOCK_TFR_DONE:1;                       // 0
    
    // DMA Transfer Done.
    // This indicates to the software that the DW_axi_dmac has completed the 
    // requested DMA transfer.
    // The DW_axi_dmac sets this bit to 1 along with setting CHx_INTSTATUS.
    // BLOCK_TFR_DONE bit to 1 when the last block transfer is completed.
    // 1: (DMA_TFR_COMPLETED): DMA Transfer completed
    // 0: (DMA_TFR_NOT_COMPLETE): DMA Transfer not complete.
    uint32_t    DMA_TFR_DONE:1;                         // 1
    uint32_t    rsvd4:1;                                // 2

    // Source Transaction Completed.
    // This bit is cleared to 0 on writing 1 to the corresponding channel interrupt
    // clear bit in CHx_IntClearReg register or on enabling the channel (needed when
    // interrupt is not enabled.    
    // 1: (ACTIVE_SRC_TRANSCOMP): Source transaction is complete
    // 0: (INACTIVE_SRC_TRANSCOMP): Source transaction is not complete    
    uint32_t    SRC_TRANSCOMP:1;                        // 3

    // Destination Transaction Completed.
    // This bit is cleared to 0 on writing 1 to the corresponding channel interrupt
    // clear bit in CHx_IntClearReg register or on enabling the channel (needed 
    // when interrupt is not enabled.
    // 1: (ACTIVE_DST_TRANSCOMP): Destination transaction is complete
    // 0: (INACTIVE_DST_TRANSCOMP): Destination transaction is not complete
    uint32_t    DST_TRANSCOMP:1;                        // 4

    // Source Decode Error.
    // Decode Error detected by Manager Interface during source data transfer. 
    // This error occurs if the access is to invalid address and a Decode Error
    // is returned from interconnect/subordinate. This error condition causes the 
    // DW_axi_dmac to disable the corresponding channel gracefully; the DMAC_ChEnReg
    // .CH_EN bit corresponding to the channel which received the error is set to 0.
    // 1: (ACTIVE_SRC_DEC_ERR): Source Decode Error detected
    // 0: (INACTIVE_SRC_DEC_ERR): No Source Decode Errors    
    uint32_t    SRC_DEC_ERR:1;                          // 5

    // Destination Decode Error.
    // Decode Error detected by Manager Interface during destination data transfer. 
    // This error occurs if the access is to invalid address and a Decode Error
    // is returned from interconnect/subordinate. This error condition causes the 
    // DW_axi_dmac to disable the corresponding channel gracefully; the DMAC_ChEnReg
    // .CH_EN bit corresponding to the channel which received the error is set to 0.
    // 1: (ACTIVE_DST_DEC_ERR): Destination Decode Error Detected
    // 0: (INACTIVE_DST_DEC_ERR): No destination Decode Errors.
    uint32_t    DST_DEC_ERR:1;                          // 6
    

    // Source Subordinate Error.
    // Subordinate Error detected by Manager Interface during source data transfer.
    // This error occurs if the register bus interface from which the data is read
    // issues a Subordinate Error. This error condition causes the DW_axi_dmac to 
    // disable the corresponding channel gracefully; the DMAC_ChEnReg.CH_EN bit 
    // corresponding to the channel which received the error is set to 0.
    // 1: (ACTIVE_SRC_SLV_ERR): Source Subordinate Error Detected
    // 0: (INACTIVE_SRC_SLV_ERR): No Source Subordinate Errors    
    uint32_t    SRC_SLV_ERR:1;                         // 7

    // Destination Subordinate Error.
    // Subordinate Error detected by Manager Interface during destination data
    // transfer. This error occurs if the register bus interface to which the 
    // data is written issues a Subordinate Error. This error condition causes
    // the DW_axi_dmac to disable the corresponding channel gracefully; the 
    // DMAC_ChEnReg.CH_EN bit corresponding to the channel which received the 
    // error is set to 0.
    // 1: (ACTIVE_DST_SLV_ERR): Destination Subordinate Errors Detected
    // 0: (INACTIVE_DST_SLV_ERR): No Destination Subordinate Errors
    uint32_t     DST_SLV_ERR:1;                         // 8

    // LLI Read Decode Error.
    // Decode Error detected by Manager Interface during LLI read operation. 
    // This error occurs if the access is to invalid address and a Decode Error
    // is returned from interconnect/subordinate. This error condition causes 
    // the DW_axi_dmac to disable the corresponding channel gracefully; the 
    // DMAC_ChEnReg.CH_EN1 bit which received the error is set to 0.
    // 1: (ACTIVE_LLI_RD_DEC_ERR): LLI Read Decode Error detected
    // 0: (INACTIVE_LLI_RD_DEC_ERR): NO LLI Read Decode Errors
    uint32_t     LLI_RD_DEC_ERR:1;                      // 9

    // LLI WRITE Decode Error.
    // Decode Error detected by Manager Interface during LLI write-back operation.
    // This error occurs if the access is to invalid address and a Decode Error 
    // is returned from interconnect/subordinate. This error condition causes the
    // DW_axi_dmac to disable the corresponding channel gracefully; the 
    // DMAC_ChEnReg.CH_EN1 bit which received the error is set to 0.
    // 1: (ACTIVE_LLI_WR_DEC_ERR): LLI write Decode Error detected
    // 0: (INACTIVE_LLI_WR_DEC_ERR): NO LLI Write Decode Errors    
    uint32_t    LLI_WR_DEC_ERR:1;                       // 10
    
    // LLI Read Subordinate Error.
    // Subordinate Error detected by Manager Interface during LLI read operation.
    // This error occurs if the register bus interface on which LLI resides 
    // issues a Subordinate Error. This error condition causes the DW_axi_dmac
    // to disable the corresponding channel gracefully; the DMAC_ChEnReg.CH_EN1 
    // bit which received the error is set to 0.
    // 1: (ACTIVE_LLI_RD_SLV_ERR): LLI read Subordinate Error detected
    // 0: (INACTIVE_LLI_RD_SLV_ERR): No LLI Read Subordinate Errors
    uint32_t    LLI_RD_SLV_ERR:1;                       // 11

    // LLI WRITE Subordinate Error.
    // Subordinate Error detected by Manager Interface during LLI write-back 
    // operation. This error occurs if the register bus interface on which LLI
    // resides issues a Subordinate Error. This error condition causes the 
    // DW_axi_dmac to disable the corresponding channel gracefully; the 
    // DMAC_ChEnReg.CH_EN1 bit which received the error is set to 0.
    // 1: (ACTIVE_LLI_WR_SLV): LLI Write SUBORDINATE Error detected
    // 0: (INACTIVE_LLI_WR_SLV): No LLI write Subordinate Errors  
    uint32_t    LLI_WR_SLV_ERR:1;                      // 12

    // Shadow register or LLI Invalid Error.
    // This error occurs if CHx_CTL.ShadowReg_Or_LLI_Valid bit is seen to be 0
    // during DW_axi_dmac Shadow Register / LLI fetch phase. This error condition
    // causes the DW_axi_dmac to halt the corresponding channel gracefully; 
    // Error Interrupt is generated if the corresponding channel error interrupt
    // mask bit is set to 0 and the channel waits till software writes (any value) 
    // to CHx_BLK_TFR_ResumeReqReg to indicate valid Shadow Register availability.
    // 1: (ACTIVE_SHADOWREG_OR_LLI_INVALID_ERR): Shadow Register / LLI Invalid
    //    error detected
    // 0: (INACTIVE_SHADOWREG_OR_LLI_INVALID_ERR): No Shadow Register / LLI 
    //    Invalid errors
    uint32_t    SHADOWREG_OR_LLI_INVALID_ERR:1;         // 13

    // Register Bus Interface Multi Block type Error.
    // This error occurs if multi-block transfer type programmed in CHx_CFG register
    // (SRC_MLTBLK_TYPE and DST_MLTBLK_TYPE) is invalid. This error condition causes 
    // the DW_axi_dmac to halt the corresponding channel 
    // 1: (ACTIVE_SLVIF_MULTIBLKTYPE_ERR): Multi-block transfer type Error detected
    // 0: (INACTIVE_SLVIF_MULTIBLKTYPE_ERR): No Multi-block transfer type Errors

    uint32_t    SLVIF_MULTIBLKTYPE_ERR:1;               // 14
    uint32_t    rsvd3:1;                                // 15   Reserved

    // Register Bus Interface Decode Error.
    // Decode Error generated by DW_axi_dmac during register access. This error 
    // occurs if the register access is to invalid address in Channelx register
    // space resulting in error response by DW_axi_dmac register bus interface.

    // 1: (ACTIVE_SLVIF_DEC_ERR): Register Bus Interface Decode Error detected
    // 0: (INACTIVE_SLVIF_DEC_ERR): No Register Bus Interface Decode errors
    uint32_t    SLVIF_DEC_ERR:1;                        // 16

    // Register Bus Interface Write to Read Only Error.
    // This error occurs if write operation is performed to a Read Only register.
    // 1: (ACTIVE_SLVIF_WR2RO_ERR): Register Bus Interface Write to Read Only 
    //    Error detected
    // 0 (INACTIVE_SLVIF_WR2RO_ERR): No Register Bus Interface Write to Read Only
    //    Errors
    uint32_t    SLVIF_WR2RO_ERR:1;                      // 17

    // Register Bus Interface Read to write Only Error.
    // This error occurs if read operation is performed to a Write Only register.    
    // 1: (ACTIVE_SLVIF_RD2RWO_ERR): Register Bus Interface Read to Write Only 
    //    Error detected
    // 0: (INACTIVE_SLVIF_RD2RWO_ERR): No Register Bus Interface Read to Write 
    //    Only Errors    
    uint32_t    SLVIF_RD2RWO_ERR:1;                    // 18

    // Register Bus Interface Write On Channel Enabled Error.
    // This error occurs if an illegal write operation is performed on a register;
    // this happens if a write operation is performed on a register when the 
    // channel is enabled and if it is not allowed for the corresponding register
    // as per the DW_axi_dmac specification. 
    // 1: (ACTIVE_SLVIF_WRONCHEN_ERR): Register Bus Interface Write On Channel 
    //    Enabled Error detected
    // 0: (INACTIVE_SLVIF_WRONCHEN_ERR): No Register Bus Interface Write On Channel
    //    Enabled Errors    
    uint32_t    SLVIF_WRONCHEN_ERR:1;                  // 19

    // Shadow Register Write On Valid Error.
    // This error occurs if shadow register based multi-block transfer is enabled
    // and software tries to write to the shadow register when CHx_CTL.ShadowReg_
    // Or_LLI_Valid bit is 1.
    // 1: (ACTIVE_SLVIF_SHADOWREG_WRON_VALID_ERR): Register Bus Interface Shadow
    //    Register Write On Valid Error detected
    // 0: (INACTIVE_SLVIF_SHADOWREG_WRON_VALID_ERR): No Register Bus Interface 
    //    Shadow Register Write On Valid Errors
    uint32_t    SLVIF_SHADOWREG_WRON_VALID_ERR:1;      // 20

    // Register Bus Interface Write On Hold Error.
    // This error occurs if an illegal write operation is performed on a register;
    // this happens if a write operation is performed on a channel register when 
    // DW_axi_dmac is in Hold mode.
    // 1: (ACTIVE_SLVIF_WRONHOLD_ERR): Register Bus Interface Write On Hold Error detected
    // 0: (INACTIVE_SLVIF_WRONHOLD_ERR): No Register Bus Interface Write On Hold Errors
    uint32_t    SLVIF_WRONHOLD_ERR:1;                  // 21
    uint32_t    rsvd2:2;                                // 23:22    Reserved.

    // Register Bus Interface Address Parity Error.
    // This error occurs if address is used to do write/read operation on a channel
    //  register; But the Address fails the even/odd parity check.

    // 1: (ACTIVE_SLVIF_ADDRPARITY_ERR): Register Bus Interface Address Parity 
    //    Error detected
    // 0: (INACTIVE_SLVIF_ADDRPARITY_ERR): No Register Bus Interface Address Parity
    //    Errors
    uint32_t    SLVIF_ADDRPARITY_ERR:1;                 // 24

    // Register Bus Interface Write Parity Error.
    // This error occurs if a Write operation is performed on a channel register;
    // But the Write data fails the even/odd parity check.
    uint32_t    SLVIF_WRPARITY_ERR:1;                   // 25
    uint32_t    rsvd1:1;                                // 26   Reserved.

    // Channel Lock Cleared.
    // This indicates to the software that the locking of the corresponding 
    // channel in DW_axi_dmac is cleared.
    // 1: (ACTIVE_CH_LOCK_CLEARED): Channel Locking is cleared
    // 0: (INACTIVE_CH_LOCK_CLEARED): Channel locking is not cleared, if present.
    uint32_t    CH_LOCK_CLEARED:1;                      // 27

    // Channel Source Suspended.
    // This indicates to the software that the corresponding channel source data
    // transfer in DW_axi_dmac is suspended.
    // 1: (ACTIVE_CH_SRC_SUSPENDED): Channel Source is suspended
    // 0: (INACTIVE_CH_SRC_SUSPENDED): Channel Source is not suspended
    uint32_t    CH_SRC_SUSPENDED:1;                     // 28

    // Channel Suspended.
    // This indicates to the software that the corresponding channel in DW_axi_dmac
    // is suspended. 
    // 1: (ACTIVE_CH_SUSPENDED): Channel is suspended
    // 0: (INACTIVE_CH_SUSPENDED): Channel is not suspended
    uint32_t    CH_SUSPENDED:1;                         // 29

    // Channel Disabled.
    // This indicates to the software that the corresponding channel in DW_axi_dmac
    // is disabled.
    // 1: (ACTIVE_CH_DISABLED): Channel is disabled
    // 0: (INACTIVE_CH_DISABLED): Channel is not disabled
    uint32_t     CH_DISABLED:1;                         // 30

    // Channel Terminated.
    // This indicates to the software that the corresponding channel in DW_axi_dmac
    // is terminated.
    // 1: (ACTIVE_CH_ABORTED): Channel is terminated
    // 0: (INACTIVE_CH_ABORTED): Channel is not terminated
    uint32_t    CH_ABORTED:1;                           // 31
};

union XINTS_L_REG {
    uint32_t            all;
    struct XINTS_L_BITS          bit;
};

struct XINTS_H_BITS {  
    // Channel x FIFO Memory Interface ECC Protection related Correctable Error 
    // Interrupt Status bit.
    // This error occurs if ECC correctable error is detected on the FIFO Memory 
    // Interface data.    
    // 1: (ACTIVE_EccPROT_CHMem_CorrERR): Channel x FIFO Memory Interface 
    //    correctable Error detected
    // 0: (INACTIVE_EccPROT_CHMem_CorrERR): Channel x FIFO Memory Interface
    //    correctable Error not detected
    uint32_t    ECC_PROT_CHMem_CorrERR:1;               // 0

    // Channel x FIFO Memory Interface ECC Protection related Uncorrectable Error
    // Interrupt Status bit. 
    // This error occurs if ECC Uncorrectable error is detected on the FIFO Memory 
    // Interface data.
    // 1: (ACTIVE_EccPROT_CHMem_UnCorrERR): Channel  x FIFO Memory Interface 
    //    Uncorrectable Error detected
    // 0: (INACTIVE_EccPROT_CHMem_UnCorrERR):  Channel x FIFO Memory Interface 
    //    Uncorrectable Error not detected
    uint32_t    ECC_PROT_CHMem_UnCorrERR:1;             // 1

    // Channel x UID Memory Interface ECC Protection related Correctable Error
    // Interrupt Status bit. 
    // This error occurs if ECC correctable error is detected on the UID Memory 
    // Interface data.
    // 1: (ACTIVE_EccPROT_UIDMem_CorrERR): Channel x UID Memory Interface correctable
    //    Error detected
    // 0: (INACTIVE_EccPROT_UIDMem_CorrERR): Channel x UID Memory Interface 
    //    correctable Error not detected
    uint32_t     ECC_PROT_UIDMem_CorrERR:1;             // 2

    // Channel x UID Memory Interface ECC Protection related Uncorrectable Error
    // Interrupt Status bit. 
    // This error occurs if ECC Uncorrectable error is detected on the UID Memory
    // Interface data.
    // 1: (ACTIVE_EccPROT_UIDMem_UnCorrERR): Channel x UID Memory Interface 
    //    Uncorrectable Error detected
    // 0: (INACTIVE_EccPROT_UIDMem_UnCorrERR): Channel x UID Memory Interface 
    //    Uncorrectable Error not detected
    uint32_t     ECC_PROT_UIDMem_UnCorrERR:1;           // 3
    uint32_t    rsvd1:28;                               // 31:4    Reserved.
};

union XINTS_H_REG {
    uint32_t            all;
    struct XINTS_H_BITS          bit;
};

struct XENINTSIGL_L_BITS {
    // Block Transfer Done Interrupt Signal Enable.
    // 1: (ENABLE_BLOCK_TFR_DONE_IntSignal): Enable the propagation of 
    //    Block Transfer Done Interrupt to generate a port level interrupt
    // 0: (DISABLE_BLOCK_TFR_DONE_IntSignal): Disable the propagation of 
    //    Block Transfer Done Interrupt to generate a port level interrupt
    uint32_t    BLOCK_TFR_DONE_SIGL_EN:1;               // 0

    // DMA Transfer Done Interrupt Signal Enable.
    // 1: (ENABLE_DMA_TFR_DONE_IntSignal): Enable the propagation of DMA 
    //    Transfer Done Interrupt to generate a port level interrupt
    // 0: (DISABLE_DMA_TFR_DONE_IntSignal): Disable the propagation of DMA
    //    Transfer Done Interrupt to generate a port level interrupt
    uint32_t    DMA_TFR_DONE_SIGL_EN:1;                 // 1
    uint32_t    rsvd4:1;                                // 2

    // Source Transaction Completed Signal Enable.
    // 1: (ENABLE_SRC_TRANSCOMP_IntSignal): Enable the propagation of Source 
    //    Transaction Complete Interrupt to generate a port level interrupt
    // 0: (DISABLE_SRC_TRANSCOMP_IntSignal): Disable the propagation of Source
    //    Transaction Complete Interrupt to generate a port level interrupt    
    uint32_t    SRC_TRANSCOMP_SIGL_EN:1;                // 3
    
    // Destination Transaction Completed Signal Enable.
    // 1: (ENABLE_DST_TRANSCOMP_IntSignal): Enable the propagation of Destination
    //    Transaction complete Interrupt to generate a port level interrupt
    // 0: (DISABLE_DST_TRANSCOMP_IntSignal): Disable the propagation of Destination
    //    Transaction complete interrupt to generate a port level interrupt
    uint32_t    DST_TRANSCOMP_SIGL_EN:1;                // 4

    //  Source Decode Error Signal Enable.
    // 1: (ENABLE_SRC_DEC_ERR_IntSignal): Enable the propagation of Source Decode
    //    Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_SRC_DEC_ERR_IntSignal): Disable the propagation of Source Decode
    //    Error Interrupt to generate a port level interrupt
    uint32_t    SRC_DEC_ERR_SIGL_EN:1;                  // 5

    // Destination Decode Error Signal Enable.
    // 1: (ENABLE_DST_DEC_ERR_IntSignal): Enable the propagation of Destination
    //    Decode Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_DST_DEC_ERR_IntSignal): Disable the propagation of Destination
    //    Decode Error Interrupt to generate a port level interrupt
    uint32_t    DST_DEC_ERR_SIGL_EN:1;                  // 6

    // Source Subordinate Error Signal Enable.
    // 1: (ENABLE_SRC_SLV_ERR_IntSignal): Enable the propagation of Source 
    //    Subordinate Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_SRC_SLV_ERR_IntSignal): Disable the propagation of Source 
    //    Subordinate Error Interrupt to generate a port level interrupt
    uint32_t    SRC_SLV_ERR_SIGL_EN:1;                  // 7

    // Destination Subordinate Error Signal Enable.
    // 1: (ENABLE_DST_SLV_ERR_IntSignal): Enable the propagation of Destination
    //    Subordinate Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_DST_SLV_ERR_IntSignal): Disable the propagation of Destination
    //    Subordinate Error Interrupt to generate a port level interrupt
    uint32_t    DST_SLV_ERR_SIGL_EN:1;                  // 8

    // LLI Read Decode Error Signal Enable.
    // 1: (ENABLE_LLI_RD_DEC_ERR_IntSignal): Enable the propagation of LLI Read
    //    Decode Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_LLI_RD_DEC_ERR_IntSignal): Disable the propagation of LLI 
    //    Read Decode Error Interrupt to generate a port level interrupt
    uint32_t    LLI_RD_DEC_ERR_SIGL_EN:1;               // 9

    // LLI WRITE Decode Error Signal Enable.
    // 1: (ENABLE_LLI_WR_DEC_ERR_IntSignal): Enable the propagation of LLI WRITE
    //    Decode Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_LLI_WR_DEC_ERR_IntSignal): Disable the propagation of LLI WRITE
    //    Decode Error Interrupt to generate a port level interrupt
    uint32_t    LLI_WR_DEC_ERR_SIGL_EN:1;               // 10

    // LLI Read Subordinate Error Signal Enable.
    // 1: (ENABLE_LLI_RD_SLV_ERR_IntSignal): Enable the propagation of LLI Read
    //    Subordinate Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_LLI_RD_SLV_ERR_IntSignal): Disable the propagation of LLI 
    //    Read Subordinate Error Interrupt to generate a port level interrupt
    uint32_t    LLI_RD_SLV_ERR_SIGL_EN:1;              // 11

    // LLI WRITE Subordinate Error Signal Enable.
    // 1: (ENABLE_LLI_WR_SLV_ERR_IntSignal): Enable the propagation of LLI WRITE
    //    Subordinate Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_LLI_WR_SLV_ERR_IntSignal): Disable the propagation of LLI 
    //    WRITE Subordinate Error Interrupt to generate a port level interrupt
    uint32_t    LLI_WR_SLV_ERR_SIGL_EN:1;              // 12

    // Shadow register or LLI Invalid Error Signal Enable.
    // 1: (ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_IntSignal): Enable the 
    //    propagation of Shadow Register or LLI Invalid Error Interrupt to 
    //    generate a port level interrupt
    // 0: (DISABLE_SHADOWREG_OR_LLI_INVALID_ERR_IntSignal): Disable the 
    //    propagation of Shadow Register or LLI Invalid Error Interrupt to 
    //    generate a port level interrupt
    uint32_t    SHADOWREG_OR_LLI_INVALID_ERR_SIGL_EN:1; // 13

    // Register Bus Interface Multi Block type Error Signal Enable.
    // 1: (ENABLE_SLVIF_MULTIBLKTYPE_ERR_IntSignal): Enable the propagation of 
    //    Register Bus Interface Multi Block type Error Interrupt to generate a
    //    port level interrupt
    // 0: (DISABLE_SLVIF_MULTIBLKTYPE_ERR_IntSignal): Disable the propagation of
    //    Register Bus Interface Multi Block type Error Interrupt to generate a
    //    port level interrupt
    uint32_t    SLVIF_MULTIBLKTYPE_ERR_SIGL_EN:1;       // 14
    uint32_t    rsvd3:1;                                // 15

    // Register Bus Interface Decode Error Signal Enable.
    // 1: (ENABLE_SLVIF_DEC_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Decode Error interrupt to generate a port level interrupt
    // 0: (DISABLE_SLVIF_DEC_ERR_IntSignal): Disable the propagation of Register
    //    Bus Interface Decode Error interrupt to generate a port level interrupt
    uint32_t    SLVIF_DEC_ERR_SIGL_EN:1;                // 16

    // Register Bus Interface Write to Read Only Error Signal Enable.
    // 1: (ENABLE_SLVIF_WR2RO_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Write to Read Only Error Interrupt to generate a port
    //    level interrupt
    // 0: (DISABLE_SLVIF_WR2RO_ERR_IntSignal): Disable the propagation of Register
    //    Bus Interface Write to Read only Error Interrupt to generate a port 
    //    level interrupt    
    uint32_t    SLVIF_WR2RO_ERR_SIGL_EN:1;              // 17

    // Register Bus Interface Read to write Only Error Signal Enable.
    // 1: (ENABLE_SLVIF_RD2RWO_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Read to Write Only Error Interrupt to generate a port 
    //    level interrupt
    // 0: (DISABLE_SLVIF_RD2RWO_ERR_IntSignal): Disable the propagation of Register
    //    Bus Interface Read to Write only Error Interrupt to generate a port 
    //    level interrupt    
    uint32_t    SLVIF_RD2RWO_ERR_SIGL_EN:1;             // 18

    // Register Bus Interface Write On Channel Enabled Error Signal Enable.
    // 1: (ENABLE_SLVIF_WRONCHEN_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Write On Channel enabled Error Interrupt to generate a 
    //    port level interrupt
    // 0: (DISABLE_SLVIF_WRONCHEN_ERR_IntSignal): Disable the propagation of Register
    //    Bus Interface Write On Channel enabled Error Interrupt to generate a 
    //    port level interrupt
    uint32_t    SLVIF_WRONCHEN_ERR_SIGL_EN:1;             // 19

    // Shadow Register Write On Valid Error Signal Enable.
    // 1: (ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_IntSignal): Enable the propagation
    //    of Shadow register Write On Valid Error Interrupt to generate a port level 
    //    interrupt
    // 0: (DISABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_IntSignal): Disable the propagation
    //    of Shadow Register Write On Valid Error Interrupt to generate a port level 
    //    interrupt
    uint32_t    SLVIF_SHADOWREG_WRON_VALID_ERR_SIGL_EN:1;// 20

    // Register Bus Interface Write On Hold Error Signal Enable.
    // 1: (ENABLE_SLVIF_WRONHOLD_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Write On Hold Error Interrupt to generate a port level interrupt
    // 0: (DISABLE_SLVIF_WRONHOLD_ERR_IntSignal): Disable the propagation of Register
    //    Bus Interface Write On Hold Error Interrupt to generate a port level interrupt
    uint32_t    SLVIF_WRONHOLD_ERR_SIGL_EN:1;           // 21
    uint32_t    rsvd2:2;                                // 23:22    Reserved.

    // Register Bus Interface Address Parity Error Signal Enable.
    // 1: (Enable_SLVIF_ADDRPARITY_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Address Parity Error Interrupt to generate a port level interrupt
    // 0: (Disable_SLVIF_ADDRPARITY_ERR_IntSignal): Disable the propagation of Register 
    //    Bus Interface Address Parity Error Interrupt to generate a port level interrupt
    uint32_t    SLVIF_ADDRPARITY_ERR_SIGL_EN:1;         // 24

    //  Register Bus Interface Write Parity Error Signal Enable.
    // 1: (Enable_SLVIF_WRPARITY_ERR_IntSignal): Enable the propagation of Register
    //    Bus Interface Write Parity Error Interrupt to generate a port level interrupt
    // 0: (Disable_SLVIF_WRPARITY_ERR_IntSignal): Disable the propagation of Register
    //    Bus Interface Write Parity Error Interrupt to generate a port level interrupt
    uint32_t    SLVIF_WRPARITY_ERR_SIGL_EN:1;           // 25
    uint32_t    rsvd1:1;                                // 26   Reserved.

    // Channel Lock Cleared Signal Enable.
    // 1: (ENABLE_CH_LOCK_CLEARED_IntSignal): Enable the propagation of Channel
    //    Lock Cleared Interrupt to generate a port level interrupt
    // 0: (DISABLE_CH_LOCK_CLEARED_IntSignal): Disable the propagation of Channel
    //    Lock Cleared Interrupt to generate a port level interrupt
    uint32_t    CH_LOCK_CLEARED_SIGL_EN:1;              // 27

    // Channel Source Suspended Signal Enable.
    // 1: (ENABLE_CH_SRC_SUSPENDED_IntSignal): Enable the propagation of Channel
    //    Source Suspended Interrupt to generate a port level interrupt
    // 0: (DISABLE_CH_SRC_SUSPENDED_IntSignal): Disable the propagation of Channel
    //    Source Suspended Interrupt to generate a port level interrupt
    uint32_t    CH_SRC_SUSPENDED_SIGL_EN:1;             // 28

    // Channel Suspended Signal Enable.
    // 1: (ENABLE_CH_SUSPENDED_IntSignal): Enable the propagation of Channel
    //    Suspended Interrupt to generate a port level interrupt
    // 0: (DISABLE_CH_SUSPENDED_IntSignal): Disable the propagation of Channel
    //    Suspended Interrupt to generate a port level interrupt    
    uint32_t    CH_SUSPENDED_SIGL_EN:1;                 // 29

    // Channel Disabled Signal Enable.
    // 1: (ENABLE_CH_DISABLED_IntSignal): Enable the propagation of Channel 
    //    Disabled Interrupt to generate a port level interrupt
    // 0: (DISABLE_CH_DISABLED_IntSignal): Disable the propagation of Channel
    //    Disabled Interrupt to generate a port level interrupt
    uint32_t    CH_DISABLED_SIGL_EN:1;                  // 30

    // Channel Terminated Signal Enable.
    // 1: (ENABLE_CH_ABORTED_IntSignal): Enable the propagation of Channel 
    //    Terminated Interrupt to generate a port level interrupt
    // 0: (DISABLE_CH_ABORTED_IntSignal): Disable the propagation of Channel 
    //    Terminated Interrupt to generate a port level interrupt
    uint32_t    CH_ABORTED_SIGL_EN:1;                   // 31
};

union XENINTSIGL_L_REG {
    uint32_t            all;
    struct XENINTSIGL_L_BITS          bit;
};

struct XENINTSIGL_H_BITS {  

    // Channel x Channel Memory Interface ECC Protection Correctable Error 
    // Interrupt Signal enable.
    // 1: (ENABLE_ECC_CHMEM_CORRERR): Enable the propagation of Channel Memory
    //    ECC Correctable error Interrupt to port level interrupt
    // 0: (DISABLE_ECC_CHMEM_CORRERR): Disable the propagation of Channel Memory
    //    ECC Correctable error Interrupt to port level interrupt
    uint32_t    ECC_PROT_CHMem_CorrERR_SIGL_EN:1;       // 0

    // Channel x Channel Memory Interface ECC Protection Uncorrectable Error 
    // Interrupt Signal enable.
    // 1: (ENABLE_ECC_CHMEM_UNCORRERR): Enable the propagation of Channel Memory
    //    ECC Uncorrectable error Interrupt to port level interrupt
    // 0: (DISABLE_ECC_CHMEM_UNCORRERR): Disable the propagation of Channel 
    //    Memory ECC Uncorrectable error Interrupt to port level interrupt
    uint32_t    ECC_PROT_CHMem_UnCorrERR_SIGL_EN:1;     // 1

    // Channel x Unique ID Memory Interface ECC Protection Correctable Error 
    // Interrupt Signal enable.
    // 1: (ENABLE_ECC_UIDMEM_CORRERR): Enable the propagation of UID Memory ECC 
    //    Correctable error interrupt to port level interrupt
    // 0: (DISABLE_ECC_UIDMEM_CORRERR): Disable the propagation of UID Memory ECC
    //    Correctable error interrupt to port level interrupt
    uint32_t    ECC_PROT_UIDMem_CorrERR_SIGL_EN:1;      //2

    // Channel x Unique ID Memory Interface ECC Protection Uncorrectable Error
    // Interrupt Signal enable.
    // 1: (ENABLE_ECC_UIDMEM_UNCORRERR): Enable the propagation of UID Memory ECC
    //    Uncorrectable error Interrupt to port level interrupt
    // 0: (DISABLE_ECC_UIDMEM_UNCORRERR): Disable the propagation of UID Memory 
    //    ECC Uncorrectable error Interrupt to port level interrupt
    uint32_t    ECC_PROT_UIDMem_UnCorrERR_SIGL_EN:1;    // 3
    uint32_t    rsvd1:28;                               // 31:4    Reserved.
};

union XENINTSIGL_H_REG {
    uint32_t            all;
    struct XENINTSIGL_H_BITS          bit;
};

struct XCLRINTS_L_BITS {  
    // Block Transfer Done Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG
    // 1: (CLEAR_BLOCK_TFR_DONE): Clear the interrupt in the Interrupt Status 
    //    Register(CHx_IntStatusReg). Writing a 1 to this register field clears
    //    the corresponding bit in the CHx_IntStatusReg register.
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    BLOCK_TFR_DONE_CLR:1;                       //0

    // DMA Transfer Done Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_DMA_TFR_DONE): Clear the DMA_TFR_-DONE interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    DMA_TFR_DONE_CLR:1;
    uint32_t    rsvd4:1;                                // 2

    // Source Transaction Completed Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SRC_TRANSCOMP): Clear the SRC_TRANSCOMP interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    SRC_TRANSCOMP_CLR:1;                    // 3

    // Destination Transaction Completed Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_DST_TRANSCOMP): Clear the DST_TRANSCOMP interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken
    uint32_t    DST_TRANSCOMP_CLR:1;                     // 4

    // Source Decode Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SRC_DEC_ERR): Clear the SRC_-DEC_ERR interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken
    uint32_t    SRC_DEC_ERR_CLR:1;                      // 5
    
    // Destination Decode Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_DST_DEC_ERR): Clear the DST_-DEC_ERR interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    DST_DEC_ERR_CLR:1;                      // 6

    // Source Subordinate Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SRC_SLV_ERR): Clear the SRC_SLV_ERR interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    SRC_SLV_ERR_CLR:1;                      // 7

    // Destination Subordinate Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_DST_SLV_ERR): Clear the DST_SLV_ERR interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.   
    uint32_t    DST_SLV_ERR_CLR:1;                      // 8

    // LLI Read Decode Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_LLI_RD_DEC_ERR): Clear the LLI_RD_-DEC_ERR interrupt in the 
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    LLI_RD_DEC_ERR_CLR:1;                   // 9

    // LLI WRITE Decode Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_LLI_WR_DEC_ERR): Clear the LLI_WR_-DEC_ERR interrupt in the 
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    LLI_WR_DEC_ERR_CLR:1;                       // 10

    // LLI Read Subordinate Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_LLI_RD_SLV_ERR): Clear the LLI_RD_SLV_ERR interrupt in the 
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    LLI_RD_SLV_ERR_CLR:1;                   // 11

    // LLI WRITE Subordinate Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_LLI_WR_SLV_ERR): Clear the LLI_WR_SLV_ERR interrupt in the 
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    LLI_WR_SLV_ERR_CLR:1;                   // 12

    // Shadow register or LLI Invalid Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SHADOWREG_OR_LLI_INVALID_ERR): Clear the SHADOWREG_OR_LLI_INVALID_ERR
    //    interrupt in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    SHADOWREG_OR_LLI_INVALID_ERR_CLR:1;     // 13

    // Register Bus Interface Multi Block type Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_MULTIBLKTYPE_ERR): Clear the SLVIF_MULTIBLKTYPE_ERR interrupt
    //    in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_MULTIBLKTYPE_ERR_CLR:1;           // 14
    uint32_t    rsvd3:1;                                // 15
    
    // Register Bus Interface Decode Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_DEC_ERR): Clear the SLVIF_-DEC_ERR interrupt in the 
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_DEC_ERR_CLR:1;                    // 16

    // Register Bus Interface Write to Read Only Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.  
    // 1: (CLEAR_SLVIF_WR2RO_ERR): Clear the SLVIF_WR2RO_ERR interrupt in the
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_WR2RO_ERR_CLR:1;                  // 17

    // Register Bus Interface Read to write Only Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_RD2RWO_ERR): Clear the SLVIF_RD2RWO_ERR interrupt in the
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_RD2RWO_ERR_CLR:1;                 // 18

    // Register Bus Interface Write On Channel Enabled Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_WRONCHEN_ERR): Clear the SLVIF_WRONCHEN_ERR interrupt in
    //    the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_WRONCHEN_ERR_CLR:1;               // 19

    // Shadow Register Write On Valid Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR): Clear the SLVIF_SHADOWREG_WRON
    //    _VALID_ERR interrupt in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_SHADOWREG_WRON_VALID_ERR_CLR:1;   // 20

    // Register Bus Interface Write On Hold Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_WRONHOLD_ERR): Clear the SLVIF_WRONHOLD_ERR interrupt in
    //    the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    SLVIF_WRONHOLD_ERR_CLR:1;               // 21
    uint32_t    rsvd2:2;                                // 23:22

    // Register Bus Interface Address Parity Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_SLVIF_ADDRPARITY_ERR): Clear the SLVIF_ADDRPARITY_ERR interrupt 
    //    in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.        
    uint32_t    SLVIF_ADDRPARITY_ERR_CLR:1;             // 24

    // Register Bus Interface Write Parity Error Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.  
    // 1: (CLEAR_SLVIF_WRPARITY_ERR): Clear the SLVIF_WRPARITY_ERR interrupt 
    // in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    SLVIF_WRPARITY_ERR_CLR:1;               // 25
    uint32_t    rsvd1:1;                                // 26

    // Channel Lock Cleared Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.   
    // 1: (CLEAR_CH_LOCK_CLEARED): Clear the CH_LOCK_CLEARED interrupt in the 
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    CH_LOCK_CLEARED_CLR:1;                  // 27

    // Channel Source Suspended Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.    
    // 1: (CLEAR_CH_SRC_SUSPENDED): Clear the CH_SRC_SUSPENDED interrupt in the
    //    Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    CH_SRC_SUSPENDED_CLR:1;                 // 28

    // Channel Suspended Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.    
    // 1: (CLEAR_CH_SUSPENDED): Clear the CH_SUSPENDED interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    CH_SUSPENDED_CLR:1;                     // 29

    // Channel Disabled Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_CH_DISABLED): Clear the CH_DISABLED interrupt in the Interrupt
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    CH_DISABLED_CLR:1;                      // 30

    // Channel Terminated Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.   
    // 1: (CLEAR_CH_ABORTED): Clear the CH_ABORTED interrupt in the Interrupt 
    //    Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    CH_ABORTED_CLR:1;                       // 31   
};

union XCLRINTS_L_REG {
    uint32_t          all;
    struct XCLRINTS_L_BITS          bit;
};

struct XCLRINTS_H_BITS {
    // ECC Protection Correctable Channel Memory Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit 
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_ECC_CHMEM_CORRERR_IntStat): Clear the ECC_PROT_CHMem_CorrERR 
    //    interrupt in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    ECC_PROT_CHMem_CorrERR_CLR:1;           // 0

    // ECC Protection Uncorrectable Channel Memory Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.    
    // 1: (CLEAR_ECC_CHMEM_CORRERR_IntStat): Clear the ECC_PROT_CHMem_UnCorrERR
    //    interrupt in the Interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    ECC_PROT_CHMem_UnCorrERR_CLR:1;         // 1

    // ECC Protection Correctable UID Memory Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.
    // 1: (CLEAR_ECC_UIDMEM_CORRERR_IntStat): Clear the ECC_PROT_UIDMem_CorrERR
    //    interrupt in the interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.
    uint32_t    ECC_PROT_UIDMem_CorrERR_CLR:1;          // 2

    // ECC Protection Uncorrectable UID Memory Interrupt Clear Bit.
    // This bit is used to clear the corresponding channel interrupt status bit
    // in CHx_INTSTATUSREG.    
    // 1: (Clear_ECC_UIDMEM_CORRERR_IntStat): Clear the ECC_PROT_UIDMem_UnCorrERR
    //    interrupt in the interrupt Status Register(CH1_IntStatusReg).
    // 0: (NO_ACTION): Inactive signal. No action taken.    
    uint32_t    ECC_PROT_UIDMem_UnCorrERR_CLR:1;        // 3
    uint32_t    rsvd1:28;                               // 31:4    Reserved.
};

union XCLRINTS_H_REG {
    uint32_t          all;
    struct XCLRINTS_H_BITS          bit;
};

struct XCFGEXTD_L_BITS {
    // LLI Fetch and LLI Writeback AXI AxPROT.
    // These bits form the arprot/awprot output of AXI manager interface.
    uint32_t     LLI_AXPROT:3;                          // 2:0
    
    // LLI Fetch and LLI Writeback AXI AxCACHE.
    // These bits form the arcache/awcache output of AXI manager interface.
    uint32_t     LLI_AXCACHE:4;                         
    uint32_t    rsvd1:25;                               // 31:7
};

union XCFGEXTD_L_REG {
    uint32_t            all;
    struct XCFGEXTD_L_BITS          bit;
};

struct XCFGEXTD_H_BITS {       
    uint32_t    RSVD:32;                                // 31:0   Reserved.
};

union XCFGEXTD_H_REG {
    uint32_t            all;
    struct XCFGEXTD_H_BITS          bit;
};


// DMA Register Definitions:
typedef struct {
    __IO union XCOMID_L_REG         COMID_L;        // 0x00
    __IO union XCOMID_H_REG         COMID_H;        // 0x04
    __IO union XVER_L_REG           VER_L;          // 0x08
    __IO union XVER_H_REG           VER_H;          // 0x0C
    __IO union XCOMCFG_L_REG        COMCFG_L;       // 0x10
    __IO union XCOMCFG_H_REG        COMCFG_H;       // 0x14
    __IO union XCHNEN_L_REG         CHNEN_L;        // 0x18
    __IO union XCHNEN_H_REG         CHNEN_H;        // 0x1C
    uint32_t                        RESERVED1[4];   // 0x20
    __IO union XCHNINTS_L_REG       CHNINTS_L;      // 0x30
    __IO union XCHNINTS_H_REG       CHNINTS_H;      // 0x34
    __IO union XCLRCOMINTS_L_REG    CLRCOMINTS_L;   // 0x38    
    __IO union XCLRCOMINTS_H_REG    CLRCOMINTS_H;   // 0x3C
    __IO union XENCOMINTS_L_REG     ENCOMINTS_L;    // 0x40
    __IO union XENCOMINTS_H_REG     ENCOMINTS_H;    // 0x44
    __IO union XENCOMINTSIGL_L_REG  ENCOMINTSIGL_L; // 0x48
    __IO union XENCOMINTSIGL_H_REG  ENCOMINTSIGL_H; // 0x4C
    __IO union XCOMINTS_L_REG       COMINTS_L;      // 0x50
    __IO union XCOMINTS_H_REG       COMINTS_H;      // 0x54
    __IO union XRESET_L_REG         RESET_L;        // 0x58
    __IO union XRESET_H_REG         RESET_H;        // 0x5C
    __IO union XCFGLOWP_L_REG       CFGLOWP_L;      // 0x60
    __IO union XCFGLOWP_H_REG       CFGLOWP_H;      // 0x64
    uint32_t                        RESERVED2[2];   // 0x68  
    __IO union XCOMPAR_L_REG        COMPAR_L;       // 0x70
    __IO union XCOMPAR_H_REG        COMPAR_H;       // 0x74
    __IO union XCOMECC_L_REG        COMECC_L;       // 0x78
    __IO union XCOMECC_H_REG        COMECC_H;       // 0x7C
    __IO union XCOMERRINJSFTY_L_REG  COMERRINJSFTY_L;    //0x80
    __IO union XCOMERRINJSFTY_H_REG  COMERRINJSFTY_H;    //0x84  
}XDMA_CtlSta_TypeDef;

typedef struct {
    __IO union XSAR_L_REG           SAR_L;          // 0x100 + X*0x100
    __IO union XSAR_H_REG           SAR_H;          // 0x104 + X*0x100
    __IO union XDAR_L_REG           DAR_L;          // 0x108 + X*0x100
    __IO union XDAR_H_REG           DAR_H;          // 0x10C + X*0x100
    __IO union XBLOCK_L_REG         BLOCK_L;        // 0x110 + x*0x100
    __IO union XBLOCK_H_REG         BLOCK_H;        // 0x114 + x*0x100
    __IO union XCTL_L_REG           CTL_L;          // 0x118 + x*0x100
    __IO union XCTL_H_REG           CTL_H;          // 0x11C + x*0x100
    __IO union XCFG_L_REG           CFG_L;          // 0x120 + x*0x100
    __IO union XCFG_H_REG           CFG_H;          // 0x124 + x*0x100
    __IO union XLLP_L_REG           LLP_L;          // 0x128 + x*0x100
    __IO union XLLP_H_REG           LLP_H;          // 0x12C + x*0x100
    __IO union XSTATUS_L_REG        STATUS_L;       // 0x130 + x*0x100
    __IO union XSTATUS_H_REG        STATUS_H;       // 0x134 + x*0x100
    __IO union XSWHSSRC_L_REG       SWHSSRC_L;      // 0x138 + x*0x100
    __IO union XSWHSSRC_H_REG       SWHSSRC_H;      // 0x13C + x*0x100
    __IO union XSWHSDST_L_REG       SWHSDST_L;      // 0x140 + x*0x100
    __IO union XSWHSDST_H_REG       SWHSDST_H;      // 0x144 + x*0x100
    __IO union XBTFRREQ_L_REG       XBTFRREQ_L;     // 0x148 + x*0x100
    __IO union XBTFRREQ_H_REG       XBTFRREQ_H;     // 0x14C + x*0x100    
    __IO union XID_L_REG            ID_L;           // 0x150 + x*0x100
    __IO union XID_H_REG            ID_H;           // 0x154 + x*0x100
    __IO union XQOS_L_REG           QOS_L;          // 0x158 + x*0x100
    __IO union XQOS_H_REG           QOS_H;          // 0x15C + x*0x100
    __IO union XSSTAT_L_REG         SSTAT_L;        // 0x160 + x*0x100
    __IO union XSSTAT_H_REG         SSTAT_H;        // 0x164 + x*0x100
    __IO union XDSTAT_L_REG         DSTAT_L;        // 0x168 + x*0x100
    __IO union XDSTAT_H_REG         DSTAT_H;        // 0x16C + x*0x100
    __IO union XSSTATAR_L_REG       SSTATAR_L;      // 0x170 + x*0x100
    __IO union XSSTATAR_H_REG       SSTATAR_H;      // 0x174 + x*0x100    
    __IO union XDSTATAR_L_REG       DSTATAR_L;      // 0x178 + x*0x100
    __IO union XDSTATAR_H_REG       DSTATAR_H;      // 0x17C + x*0x100
    __IO union XENINTS_L_REG        ENINTS_L;       // 0x180 + x*0x100
    __IO union XENINTS_H_REG        ENINTS_H;       // 0x184 + x*0x100
    __IO union XINTS_L_REG          INTS_L;         // 0x188 + x*0x100
    __IO union XINTS_H_REG          INTS_H;         // 0x18C + x*0x100    
    __IO union XENINTSIGL_L_REG     ENINTSIGL_L;    // 0x190 + x*0x100
    __IO union XENINTSIGL_H_REG     ENINTSIGL_H;    // 0x194 + x*0x100    
    __IO union XCLRINTS_L_REG       CLRINTS_L;      // 0x198 + x*0x100
    __IO union XCLRINTS_H_REG       CLRINTS_H;      // 0x19C + x*0x100
    __IO union XCFGEXTD_L_REG       CFGEXTD_L;      // 0x1A0 + x*0x100
    __IO union XCFGEXTD_H_REG       CFGEXTD_H;      // 0x1A4 + x*0x100
    //uint32_t                        RESERVED[22]    // 0x1A8 + x*0x100  total 22 nums
}XDMA_Channel_TypeDef;

//typedef struct {
//    XDMA_CtlSta_TypeDef     Dmac;                // offset is 0x000
//    XDMA_Channel_TypeDef    Dmac_Channel[8];    / /offset is 0x100, max 8 channel
//} XDMA_Type;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */
// DMA External References & Function Declarations

//extern volatile struct DMA_CTL_STA_REGS DMACTLSTARegs;
//extern volatile struct DMA_CH_REGS DMACHRegs;

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#endif /*#if (XDMAC_VERSION == 0x20 || XDMAC_VERSION == 0x22) */

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_XDMA_H definition
