#ifndef __LOAD_IMG__
#define __LOAD_IMG__

#ifdef __cplusplus
extern "C"{
#endif

#define IMG_HEADER_MAGIC    0xAA55AA55

#define MAX_SECTIONS        20

typedef  struct img_section {
    uint32_t length;
    uint32_t load_addr;
    uint8_t name[12];
    uint32_t crc;
}__attribute__((packed)) img_section_t;

typedef struct _img_header {
    uint32_t magic;
    uint32_t length;
    uint32_t entry_point;
    uint32_t vect_table;
    uint8_t sections;
    uint8_t reserved1[7];
    img_section_t section[MAX_SECTIONS];
    uint8_t reserved2[4];
    uint32_t crc;
}__attribute__((packed)) img_header_t;

typedef struct _memmap {
    char *name;
    uint32_t len;
    uint32_t base_addr;
    uint32_t remap_addr;
}memmap_t;

extern void bringup_cpu2(void);
extern void bringup_smp_cpu2(void);

#ifdef __cplusplus
}
#endif

#endif

