/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    adc_ex05_soc_continuous_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/*
 * Include Files
 */
#include "adc_ex05_board.h"

/*
 * @brief Board Configurations
 *
 * Initializes the rest of the modules.
 * Call this function in your application if you wish to do all module
 * initialization.
 * If you wish to not use some of the initializations, instead of the
 * Board_init use the individual Module_inits.
 */
void Board_init()
{
	myADC0_init();
}

void myADC0_init()
{
	/*
	 * @brief ADC Initialization:
	 * 		  Write ADC configurations and power up the ADC.
	 */
	/* Select ADC Reference mode and Reference voltage */
	ADC_setVREF(myADC0_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	/* Set trim */
	ADC_setINLTrim(myADC0_BASE);

	/* Configures the analog-to-digital converter module prescaler. */
	ADC_setPrescaler(myADC0_BASE, ADC_CLK_DIV_4_0);

	/* Sets the timing of the end-of-conversion pulse */
	ADC_setInterruptPulseMode(myADC0_BASE, ADC_PULSE_END_OF_CONV);

	/* Powers up the ADCA core. */
	ADC_enableConverter(myADC0_BASE);

	/* Delay for 1ms to allow ADCA time to power up */
	DEVICE_DELAY_US(5000);

	/*
	 * @brief SOC Configuration:
	 * 		  Setup ADC EPWM channel and trigger settings.
	 */
	/* Disables SOC burst mode. */
	ADC_disableBurstMode(myADC0_BASE);

	/* Sets the priority mode of the SOCs. */
	ADC_setSOCPriority(myADC0_BASE, ADC_PRI_ALL_ROUND_ROBIN);

	/*
	 * @brief Start of Conversion 0 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 0
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 1
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 2 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 2
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER2, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER2, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 3 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 3
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER3, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER3, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 4 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 4
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER4, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER4, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 5 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 5
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER5, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER5, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 6 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 6
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER6, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER6, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 7 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 7
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER7, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER7, ADC_INT_SOC_TRIGGER_ADCINT2);

	/*
	 * @brief Start of Conversion 8 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 8
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT2
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER8, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER8, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 9 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 9
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER9, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER9, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 10 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 10
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER10, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER10, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 11 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 11
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER11, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER11, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 12 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 12
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER12, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER12, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 13 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 13
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER13, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER13, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 14 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 14
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER14, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER14, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief Start of Conversion 15 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		 : 15
	 * 			Trigger			 : ADC_TRIGGER_SW_ONLY
	 * 			Channel			 : ADC_CH_ADCIN0
	 * 			Sample Window	 : 36 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	 */
	ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER15, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 36U);
	ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER15, ADC_INT_SOC_TRIGGER_ADCINT1);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 1 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC6
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER1, ADC_INT_TRIGGER_EOC6);
	ADC_disableInterrupt(myADC0_BASE, ADC_INT_NUMBER1);
	ADC_enableContinuousMode(myADC0_BASE, ADC_INT_NUMBER1);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 2 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC14
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER2, ADC_INT_TRIGGER_EOC14);
	ADC_disableInterrupt(myADC0_BASE, ADC_INT_NUMBER2);
	ADC_enableContinuousMode(myADC0_BASE, ADC_INT_NUMBER2);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 3 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC7
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER3, ADC_INT_TRIGGER_EOC7);
	ADC_disableInterrupt(myADC0_BASE, ADC_INT_NUMBER3);
	ADC_enableContinuousMode(myADC0_BASE, ADC_INT_NUMBER3);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 4 Configuration
	 * 		SOC/EOC number	: ADC_INT_TRIGGER_EOC15
	 * 		Interrupt Source: disabled
	 * 		Continuous Mode	: enabled
	 */
	ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER4, ADC_INT_TRIGGER_EOC15);
	ADC_disableInterrupt(myADC0_BASE, ADC_INT_NUMBER4);
	ADC_enableContinuousMode(myADC0_BASE, ADC_INT_NUMBER4);
}

#ifdef __cplusplus

#endif

