/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    adc_ex06_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "adc_ex06_board.h"
#include "cpu.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	myADC0_init();
	myADC1_init();
}

void myADC0_init(){

	//Set ADC AnaSysctrl
	ADC_setVREF(myADC0_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
	AdcaRegs.ADCINLTRIM1 = ADC_TRIM_VALUE;
	//
	// Configures the analog-to-digital converter module prescaler.
	//
	AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
	//
	// Sets the timing of the end-of-conversion pulse
	//
	AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
	//
	// Powers up the analog-to-digital converter core.
	//
	AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
	//
	// Delay for 5ms to allow ADC time to power up
	//
	DEVICE_DELAY_US(5000);
	//
	// SOC Configuration: Setup ADC EPWM channel and trigger settings
	//
	// Disables SOC burst mode.
	//
	AdcaRegs.ADCBURSTCTL.bit.BURST_EN = 0;
	//
	// Sets the priority mode of the SOCs.
	//
	AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;
	//
	// Start of Conversion 0 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 0
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 7;
	AdcaRegs.ADCSOC0CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC0CTL.bit.ACQPS = 50U;
//	AdcaRegs.ADCINTSOCSEL1.bit.SOC0 = 0;
	//
	// Start of Conversion 1 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 1
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
//	AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC1CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC1CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC1 = 1;
	//
	// Start of Conversion 2 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 2
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC2CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC2CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC2 = 1;
	//
	// Start of Conversion 3 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 3
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC3CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC3CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC3 = 1;
	//
	// Start of Conversion 4 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 4
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC4CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC4CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC4 = 1;
	//
	// Start of Conversion 5 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 5
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC5CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC5CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC5CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC5 = 1;
	//
	// Start of Conversion 6 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 6
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC6CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC6CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC6CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC6 = 1;
	//
	// Start of Conversion 7 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 7
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC7CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC7CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC7CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC7 = 1;
	//
	// Start of Conversion 8 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 8
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC8CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC8CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC8CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC8 = 1;
	//
	// Start of Conversion 9 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 9
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC9CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC9CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC9CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC9 = 1;
	//
	// Start of Conversion 10 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 10
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC10CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC10CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC10CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC10 = 1;
	//
	// Start of Conversion 11 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 11
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC11CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC11CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC11CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC11 = 1;
	//
	// Start of Conversion 12 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 12
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC12CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC12CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC12CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC12 = 1;
	//
	// Start of Conversion 13 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 13
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC13CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC13CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC13CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC13 = 1;
	//
	// Start of Conversion 14 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 14
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC14CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC14CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC14CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC14 = 1;
	//
	// Start of Conversion 15 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 15
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
//	AdcaRegs.ADCSOC15CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC15CTL.bit.CHSEL = 1;
	AdcaRegs.ADCSOC15CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC15 = 1;
	//
	// ADC Interrupt 1 Configuration
	// 		SOC/EOC number	: 0
	// 		Interrupt Source: enabled
	//		Continuous Mode	: enabled
	//
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;
	AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
	AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 1;
	//
	// ADC Interrupt 2 Configuration
	// 		SOC/EOC number	: 15
	// 		Interrupt Source: enabled
	//		Continuous Mode	: enabled
	//
	AdcaRegs.ADCINTSEL1N2.bit.INT2SEL = 15;
	AdcaRegs.ADCINTSEL1N2.bit.INT2E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT2 = 1;
	AdcaRegs.ADCINTSEL1N2.bit.INT2CONT = 1;
	//
	// ADC Interrupt 3 Configuration
	// 		SOC/EOC number	: 0
	// 		Interrupt Source: disabled
	// 		Continuous Mode	: disabled
	//
	AdcaRegs.ADCINTSEL3N4.bit.INT3SEL = 0;
	AdcaRegs.ADCINTSEL3N4.bit.INT3E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT3 = 1;
//	AdcaRegs.ADCINTSEL3N4.bit.INT3CONT = 0;
	//
	// ADC Interrupt 4 Configuration
	// 		SOC/EOC number	: 0
	// 		Interrupt Source: disabled
	// 		Continuous Mode	: disabled
	//
	AdcaRegs.ADCINTSEL3N4.bit.INT4SEL = 0;
	AdcaRegs.ADCINTSEL3N4.bit.INT4E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT4 = 1;
//	AdcaRegs.ADCINTSEL3N4.bit.INT4CONT = 0;
}

void myADC1_init(){
	//Set ADC AnaSysctrl
	ADC_setVREF(myADC1_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
	AdccRegs.ADCINLTRIM1 = ADC_TRIM_VALUE;
	//
	// Configures the analog-to-digital converter module prescaler.
	//
	AdccRegs.ADCCTL2.bit.PRESCALE = 6;
	//
	// Sets the timing of the end-of-conversion pulse
	//
	AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;
	//
	// Powers up the analog-to-digital converter core.
	//
	AdccRegs.ADCCTL1.bit.ADCPWDNZ = 1;
	//
	// Delay for 5ms to allow ADC time to power up
	//
	DEVICE_DELAY_US(5000);
	//
	// SOC Configuration: Setup ADC EPWM channel and trigger settings
	//
	// Disables SOC burst mode.
	//
//	AdccRegs.ADCBURSTCTL.bit.BURST_EN = 0;
	//
	// Sets the priority mode of the SOCs.
	//
//	AdccRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;
	//
	// Start of Conversion 0 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 0
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdccRegs.ADCSOC0CTL.bit.TRIGSEL = 7;
	AdccRegs.ADCSOC0CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC0CTL.bit.ACQPS = 50U;
//	AdccRegs.ADCINTSOCSEL1.bit.SOC0 = 0;
	//
	// Start of Conversion 1 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 1
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdccRegs.ADCSOC1CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC1CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC1CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC1 = 1;
	//
	// Start of Conversion 2 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 2
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC2CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC2CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC2CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC2 = 1;
	//
	// Start of Conversion 3 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 3
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 50 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC3CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC3CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC3CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC3 = 1;
	//
	// Start of Conversion 4 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 4
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC4CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC4CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC4CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC4 = 1;
	//
	// Start of Conversion 5 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 5
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC5CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC5CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC5CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC5 = 1;
	//
	// Start of Conversion 6 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 6
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC6CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC6CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC6CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC6 = 1;
	//
	// Start of Conversion 7 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 7
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC7CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC7CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC7CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL1.bit.SOC7 = 1;
	//
	// Start of Conversion 8 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 8
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC8CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC8CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC8CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC8 = 1;
	//
	// Start of Conversion 9 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 9
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC9CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC9CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC9CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC9 = 1;
	//
	// Start of Conversion 10 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 10
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC10CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC10CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC10CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC10 = 1;
	//
	// Start of Conversion 11 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 11
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC11CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC11CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC11CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC11 = 1;
	//
	// Start of Conversion 12 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 12
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC12CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC12CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC12CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC12 = 1;
	//
	// Start of Conversion 13 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 13
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC13CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC13CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC13CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC13 = 1;
	//
	// Start of Conversion 14 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 14
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC14CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC14CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC14CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC14 = 1;
	//
	// Start of Conversion 15 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 15
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN3
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_ADCINT1
	//
	AdccRegs.ADCSOC15CTL.bit.TRIGSEL = 0;
	AdccRegs.ADCSOC15CTL.bit.CHSEL = 2;
	AdccRegs.ADCSOC15CTL.bit.ACQPS = 50U;
	AdccRegs.ADCINTSOCSEL2.bit.SOC15 = 1;
	//
	// ADC Interrupt 1 Configuration
	// 		SOC/EOC number	: 0
	// 		Interrupt Source: enabled
	//		Continuous Mode	: enabled
	//
	AdccRegs.ADCINTSEL1N2.bit.INT1SEL = 0;
	AdccRegs.ADCINTSEL1N2.bit.INT1E = 1;
	AdccRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
	AdccRegs.ADCINTSEL1N2.bit.INT1CONT = 1;
	//
	// ADC Interrupt 2 Configuration
	// 		SOC/EOC number	: 15
	// 		Interrupt Source: enabled
	//		Continuous Mode	: enabled
	//
	AdccRegs.ADCINTSEL1N2.bit.INT2SEL = 15;
	AdccRegs.ADCINTSEL1N2.bit.INT2E = 1;
	AdccRegs.ADCINTFLGCLR.bit.ADCINT2 = 1;
	AdccRegs.ADCINTSEL1N2.bit.INT2CONT = 1;
	//
	// ADC Interrupt 3 Configuration
	// 		SOC/EOC number	: 0
	// 		Interrupt Source: disabled
	// 		Continuous Mode	: disabled
	//
	AdccRegs.ADCINTSEL3N4.bit.INT3SEL = 0;
	AdccRegs.ADCINTSEL3N4.bit.INT3E = 1;
	AdccRegs.ADCINTFLGCLR.bit.ADCINT3 = 1;
	AdccRegs.ADCINTSEL3N4.bit.INT3CONT = 0;
	//
	// ADC Interrupt 4 Configuration
	// 		SOC/EOC number	: 0
	// 		Interrupt Source: disabled
	// 		Continuous Mode	: disabled
	//
	AdccRegs.ADCINTSEL3N4.bit.INT4SEL = 0;
	AdccRegs.ADCINTSEL3N4.bit.INT4E = 1;
	AdccRegs.ADCINTFLGCLR.bit.ADCINT4 = 1;
	AdccRegs.ADCINTSEL3N4.bit.INT4CONT = 0;
}


#ifdef __cplusplus

#endif

