/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    adc_ex08_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "adc_ex08_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{

	ADC_init();
	INTERRUPT_init();

}


//*****************************************************************************
//
// ADC Configurations
//
//*****************************************************************************
void ADC_init(){
	myADC0_init();
}

void myADC0_init(){
	//Set ADC AnaSysctrl
	ADC_setVREF(myADC0_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
	AdcaRegs.ADCINLTRIM1 = ADC_TRIM_VALUE;
	//
	// Configures the analog-to-digital converter module prescaler.
	//
	AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
	//
	// Sets the timing of the end-of-conversion pulse
	//
	AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
	//
	// Powers up the analog-to-digital converter core.
	//
	AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
	//
	// Delay for 5ms to allow ADC time to power up
	//
	DEVICE_DELAY_US(5000);
	//
	// SOC Configuration: Setup ADC EPWM channel and trigger settings
	//
	// Disables SOC burst mode.
	//
//	AdcaRegs.ADCBURSTCTL.bit.BURST_EN = 0;
	//
	// Sets the priority mode of the SOCs.
	//
//	AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;
	//
	// Start of Conversion 0 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 0
	//	  	Trigger			: ADC_TRIGGER_EPWM1_SOCA
	//	  	Channel			: ADC_CH_ADCIN0
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 5;
	AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;
	AdcaRegs.ADCSOC0CTL.bit.ACQPS = 50U;
	//
	// ADC Interrupt 1 Configuration
	// 		Source	: ADC_SOC_NUMBER0
	// 		Interrupt Source: enabled
	// 		Continuous Mode	: disabled
	//
	//
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;
	AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;

	//
	// PPB Configuration: Configure high and low limits detection for ADCPPB
	//
	// Post Processing Block 1 Configuration
	// 		Configures a post-processing block (PPB) in the ADC.
	// 		PPB Number				: 1
	// 		SOC/EOC number			: 0
	// 		Interrupt Sources Enabled: ADC_EVT_TRIPHI,ADC_EVT_TRIPLO
	// 		Calibration Offset		: 0
	// 		Reference Offset		: 0
	// 		Two's Complement		: Disabled
	// 		Trip High Limit			: 3000
	// 		Trip Low Limit			: 1000
	// 		Clear PPB Event Flags	: Disabled
	//
	AdcaRegs.ADCPPB1CONFIG.bit.CONFIG = 0;
//	AdcaRegs.ADCEVTSEL.bit.PPB1TRIPHI = 0;
//	AdcaRegs.ADCEVTSEL.bit.PPB1TRIPLO = 0;
//	AdcaRegs.ADCEVTSEL.bit.PPB1ZERO = 0;
	AdcaRegs.ADCEVTINTSEL.bit.PPB1TRIPHI = 1;
	AdcaRegs.ADCEVTINTSEL.bit.PPB1TRIPLO = 1;
//	AdcaRegs.ADCEVTINTSEL.bit.PPB1ZERO = 0;
//	AdcaRegs.ADCPPB1OFFCAL.bit.OFFCAL = 0;
//	AdcaRegs.ADCPPB1OFFREF = 0;
//	AdcaRegs.ADCPPB1CONFIG.bit.TWOSCOMPEN = 0;
	AdcaRegs.ADCPPB1TRIPHI = 3000;
	AdcaRegs.ADCPPB1TRIPLO.bit.LIMITLO = 1000;
//	AdcaRegs.ADCPPB1CONFIG.bit.CBCEN = 0;
}


//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************
void INTERRUPT_init(){


	Interrupt_register(INT_ADCA_EVT, adcAEvtISR);
	Interrupt_enable(INT_ADCA_EVT);
}

#ifdef __cplusplus

#endif

