/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    adc_ex12_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "adc_ex12_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


///*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{


	ADC_init();
	EPWM_init();
	INTERRUPT_init();

}

//*****************************************************************************
//
// ADC Configurations
//
//*****************************************************************************
void ADC_init(){
	myADC0_init();
}

void myADC0_init(){
	//Set ADC AnaSysctrl
	ADC_setVREF(myADC0_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
	AdcaRegs.ADCINLTRIM1 = ADC_TRIM_VALUE;
	//
	// Configures the analog-to-digital converter module prescaler.
	//
	AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
	//
	// Sets the timing of the end-of-conversion pulse
	//
	AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
	//
	// Powers up the analog-to-digital converter core.
	//
	AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
	//
	// Delay for 5ms to allow ADC time to power up
	//
	DEVICE_DELAY_US(5000);
	//
	// SOC Configuration: Setup ADC EPWM channel and trigger settings
	//
	// Enables SOC burst mode.
	//
	AdcaRegs.ADCBURSTCTL.bit.BURST_EN = 1;
	//
	// Set SOC burst mode.
	//
	AdcaRegs.ADCBURSTCTL.bit.TRIGSEL = 5;
	AdcaRegs.ADCBURSTCTL.bit.BURSTSIZE = 1;
	//
	// Sets the priority mode of the SOCs.
	//

	AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;
	//
	// Start of Conversion 0 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 0
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC0CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC0CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC0 = 0;
	//
	// Start of Conversion 1 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 1
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC1CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC1CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC1CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC1 = 0;
	//
	// Start of Conversion 2 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 2
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC2CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC2CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC2CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC2 = 0;
	//
	// Start of Conversion 3 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 3
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC3CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC3CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC3CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC3 = 0;
	//
	// Start of Conversion 4 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 4
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC4CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC4CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC4CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC0 = 0;
	//
	// Start of Conversion 5 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 5
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC5CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC5CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC5CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC5 = 0;
	//
	// Start of Conversion 6 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 6
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC6CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC6CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC6CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC6 = 0;
	//
	// Start of Conversion 7 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 7
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC7CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC7CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC7CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL1.bit.SOC7 = 0;
	//
	// Start of Conversion 8 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 8
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC8CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC8CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC8CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC8 = 0;
	//
	// Start of Conversion 9 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 9
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC9CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC9CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC9CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC9 = 0;
	//
	// Start of Conversion 10 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 10
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC10CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC10CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC10CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC10 = 0;
	//
	// Start of Conversion 11 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 11
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC11CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC11CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC11CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC11 = 0;
	//
	// Start of Conversion 12 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 12
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC12CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC12CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC12CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC12 = 0;
	//
	// Start of Conversion 13 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 13
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC13CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC13CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC13CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC13 = 0;
	//
	// Start of Conversion 14 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 14
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC14CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC14CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC14CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC14 = 0;
	//
	// Start of Conversion 15 Configuration
	//
	//
	// Configures a start-of-conversion (SOC) in the ADC and its interrupt SOC trigger.
	// 	  	SOC number		: 15
	//	  	Trigger			: ADC_TRIGGER_SW_ONLY
	//	  	Channel			: ADC_CH_ADCIN2
	//	 	Sample Window	: 9 SYSCLK cycles
	//		Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	//
	//
	AdcaRegs.ADCSOC15CTL.bit.TRIGSEL = 0;
	AdcaRegs.ADCSOC15CTL.bit.CHSEL = 2;
	AdcaRegs.ADCSOC15CTL.bit.ACQPS = 50U;
	AdcaRegs.ADCINTSOCSEL2.bit.SOC15 = 0;
	//
	// ADC Interrupt 1 Configuration
	// 		Source	: ADC_SOC_NUMBER15
	// 		Interrupt Source: enabled
	// 		Continuous Mode	: disabled
	//
	//
	AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 15;
	AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
	AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
	AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0;
}


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(){
    EPWM_setClockPrescaler(myEPWM0_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
    EPWM_setTimeBasePeriod(myEPWM0_BASE, 910);
    //EPWM_setTimeBaseCounter(myEPWM0_BASE, 0);
    EPWM_setTimeBaseCounterMode(myEPWM0_BASE, EPWM_COUNTER_MODE_UP);
    //EPWM_disablePhaseShiftLoad(myEPWM0_BASE);
    //EPWM_setPhaseShift(myEPWM0_BASE, 0);
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_A, 909);
    //EPWM_setCounterCompareShadowLoadMode(myEPWM0_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_B, 0);
    //EPWM_setCounterCompareShadowLoadMode(myEPWM0_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //EPWM_setRisingEdgeDelayCountShadowLoadMode(myEPWM0_BASE, EPWM_RED_LOAD_ON_CNTR_ZERO);
    //EPWM_disableRisingEdgeDelayCountShadowLoadMode(myEPWM0_BASE);
    //EPWM_setFallingEdgeDelayCountShadowLoadMode(myEPWM0_BASE, EPWM_FED_LOAD_ON_CNTR_ZERO);
    //EPWM_disableFallingEdgeDelayCountShadowLoadMode(myEPWM0_BASE);
    EPWM_enableADCTrigger(myEPWM0_BASE, EPWM_SOC_A);
    EPWM_setADCTriggerSource(myEPWM0_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_U_CMPA);
    EPWM_setADCTriggerEventPrescale(myEPWM0_BASE, EPWM_SOC_A, 1);
}

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************
void INTERRUPT_init(){

    Interrupt_register(INT_ADCA1,INT_myADC0_1_ISR);
    Interrupt_enable(INT_ADCA1);
}
