
////#############################################################################
//  @File AutoAccmuAvgOversampling.c
//  @KeyWords Oversampling, reduce interrupt
//
//		This routine demonstrates how to perform oversampling to avoid frequent interrupts.
//		In traditional oversampling, you might read the conversion result in each SOC's ISR and then accumulate it.
//		Now, by using PPB for automatic oversampling accumulation and averaging, the interrupt frequency is reduced.
//
//
//		Every 10ms, the timer initiates a SOC, but after the SOC conversion is complete, it does not generate an interrupt.
//		Instead, the PPB automatically accumulates the results, and an interrupt is generated for the user to read only after 32 accumulations.
//
//  @hardware_requirements
//           GS32F0039YHPZ
//
//  @software_requirements
//           TODO
// 	   TODO FTDI
//  @ExternalConnection
//   - A0  should be connected to signals to convert.
//  @Watch Variables
//   -  myADC0Result - Digital representation of the voltage on pin A0
//   -  myPPB0Result - Digital representation of the voltage of the undersample pulse on pin A0
////#############################################################################

/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "stdio.h"
#include "adc_ex17_board.h"
#include "printf.h"
#include "device.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define RESULTS_BUFFER_SIZE     256

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */


uint32_t myADC0OverSampleResult;



/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
int main(void)
{
	Device_init();

	UartPrint_init(LOG_SCI_BASE, 115200);
	//	printf("SCI print OK.\r\n");

	printf("SCI print OK.\r\n");

	Board_init();


    EINT;

    //
    // Take conversions indefinitely in loop
    //
    do
    {

    }
    while(1);

}


void ADCA_1INT_IRQHandler()
{

	// Store the results for A0

	myADC0OverSampleResult = ADC_readPPBSum(ADCARESULT_BASE, ADC_PPB_NUMBER1);
	printf("%d\r\n",myADC0OverSampleResult);

	//
	//
	// Clear the interrupt flag
	//
	ADC_clearInterruptStatus(myADC0_BASE, ADC_INT_NUMBER1);

	//
	// Check if overflow has occurred
	//
	if(true == ADC_getInterruptOverflowStatus(myADC0_BASE, ADC_INT_NUMBER1))
	{
		ADC_clearInterruptOverflowStatus(myADC0_BASE, ADC_INT_NUMBER1);
		ADC_clearInterruptStatus(myADC0_BASE, ADC_INT_NUMBER1);
	}
}

#ifdef __cplusplus
}
#endif

