/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "aes.h"


uint32_t key[4] = {0xae781dad,0x18efd7f1,0x4acc012a,0x75dbeb33};

__attribute__((aligned(8))) uint32_t sources[112]= {
		0x5a1d5d1a,
		0x36a86380,
		0xdb7905a5,
		0xb26afacc,
		0xd344e776,
		0x25a4a61e,
		0x364fcb9e,
		0xbc84448c,
		0xffdc0131,
		0xfc8a2482,
		0x2387211f,
		0xf711b71f,
		0x4b73c7cf,
		0xbac08314,
		0x846a6a27,
		0x7507ec62,
		0x58805177,
		0xf17d30dd,
		0x836597bb,
		0x2a581716,
		0x93d9e013,
		0x104df4a8,
		0x81ff3449,
		0xcf56b96f,
		0x68f0b03e,
		0x146b0016,
		0x6d4cabd2,
		0xe0db503a,
		0x9af107c7,
		0xc18ba69d,
		0x3db3c625,
		0xf36f451d,
		0x5977387e,
		0xc34574d3,
		0x2b57eccc,
		0x74a4dc34,
		0xda1f851b,
		0x64e6756f,
		0xbf03aae3,
		0x281f3a5d,
		0x0c8f4b5b,
		0xa3d22bec,
		0xb06373f2,
		0x5eb780a1,
		0x55bf4612,
		0xbe37e306,
		0xd49d3fce,
		0x52e2d6d1,
		0x19aa6e38,
		0xc7d95d78,
		0x7a45a93b,
		0x9d73349b,
		0xbb02f977,
		0x36fbd177,
		0xe731ef0e,
		0xaa39d5ac,
		0x2a5a7677,
		0x2e80d663,
		0x93de4898,
		0xb8e97f73,
		0x7c1b933b,
		0x902aea50,
		0x9bcf5d0d,
		0xa211c947,
		0xf46ee88a,
		0x435d7f66,
		0xe045f500,
		0xfe957d12,
		0x30c03f20,
		0xdd5013ae,
		0x59c469f3,
		0xe0544fab,
		0x22b30727,
		0xebf8d6b1,
		0xfec3accd,
		0xd8fd35d9,
		0xc1997253,
		0x73f40095,
		0x4e689397,
		0x5bdf2f25,
		0x198b8c64,
		0x7be38513,
		0x9bb5c2df,
		0x6627cc13,
		0xab34fa2d,
		0x24d8c75c,
		0x58b01907,
		0xb7df0068,
		0xb776c657,
		0xd697d32c,
		0x6f6c8b82,
		0x726104cc,
		0x5d47fbf6,
		0x460be89f,
		0x56c9d614,
		0x372c02b8,
		0x1d19febe,
		0x7871b15a,
		0xe42a4835,
		0xdf40fe6c,
		0x3694656a,
		0x60f6d434,
		0xc4605c86,
		0x2d19d3af,
		0xfc355411,
		0x8fedd0fc,
		0xfaf1c3aa,
		0x943d1c71,
		0x354a8a56,
		0x8af0c4f0,
		0xa632c114,
		0xc8091cfb
};

__attribute__((aligned(8))) uint32_t sources2[112]= {	// sourcesֵAESܺ
		0x4979068d,
		0x457debba,
		0x484fda1f,
		0x7ae08161,
		0x26a2df7e,
		0xac3fb3ec,
		0xdd929688,
		0x2d93cfe7,
		0x228b93a5,
		0x5460b1df,
		0xd9f8c6f4,
		0x281ea4c3,
		0xb4b06dca,
		0x7699e5a9,
		0xb1f276e0,
		0x815a734f,
		0xff8d9916,
		0xb25a491b,
		0x4378086e,
		0x19307e14,
		0x7c6b86a6,
		0x913f3ea8,
		0xf94dd221,
		0xe2ee8efa,
		0xceb3ba8c,
		0xfccfedc7,
		0xffd1ea9d,
		0x01915f42,
		0x88a96347,
		0x528137d3,
		0xdcc5137d,
		0x813445af,
		0x991e8158,
		0xa9ab4135,
		0x909eb4d2,
		0x8f72b85c,
		0xacad618b,
		0x203888bf,
		0x098402eb,
		0xc0cf8029,
		0x8ccb0db0,
		0x28c464ac,
		0x8993c9c2,
		0x2dde5819,
		0xa1c32d61,
		0x2a6f9882,
		0xf53a1202,
		0x8e2c52ce,
		0x63c2fa26,
		0x2892f0cd,
		0xc460fabd,
		0x9b776035,
		0x360d0819,
		0x92a0d412,
		0x4b37951a,
		0xf755e4b4,
		0xa7634da4,
		0x6bf9fed8,
		0xf67ebf63,
		0xbab0c5a0,
		0xfdaa690a,
		0xfb691593,
		0x8b61189b,
		0xc06f1a57,
		0x9c1e5309,
		0x9109a358,
		0x3169760f,
		0x8cedebbc,
		0x8cb526b6,
		0x92a5db3b,
		0x351f0570,
		0xd1a86d58,
		0xe844b32d,
		0x0e5351f5,
		0x8567ea12,
		0x2c6851e8,
		0xabbe4ce8,
		0x65bbf281,
		0xa7bd1a4b,
		0xcf04727a,
		0xa88735bd,
		0xcbf98a0d,
		0xdf407857,
		0x622f9f36,
		0xda9d73f6,
		0x4f337f3e,
		0x76d1f71c,
		0xec65b9fb,
		0x0418aec3,
		0x415d5f72,
		0x1266afcb,
		0xc1a73089,
		0x157f5d06,
		0x6bc06c25,
		0x1f655739,
		0xfa644808,
		0x5a9b5e91,
		0x8e2b611c,
		0x05d85063,
		0x38ce6ab2,
		0x9c880eb0,
		0x417f5d84,
		0x4710c2a6,
		0x6856a1ab,
		0x9907c5b7,
		0xcd74c0f4,
		0x56fb40ea,
		0x09011a09,
		0x60bd92fe,
		0x59118a85,
		0xd0047bf2,
		0xe7e928d2
};


uint8_t charArr[]={"I LOVE Gejian!"};

uint32_t charArr2[4]=
{
		0x21c0772a,
		0x342b762a,
		0xc20fe7d0,
		0x7598cbac
};


uint32_t destinations[112] = {0};
uint32_t destinations2[112] = {0};
uint32_t charDestinations[4] = {0};


//*****************************************************************************
//
//! Converts decrypted hexadecimal numbers to characters.
//!
//! \param hexArr is the decrypted data address.
//! \param arrLength is data length.
//! \param charOut is the array used to store characters
//!
//! This function converts a four-byte hexadecimal number to a one-byte character.
//!
//! \return Returns the array used to store characters.
//
//*****************************************************************************

void hex2char(uint32_t* hexArr, uint8_t arrLength, uint8_t* charOut)
{
	for(uint8_t i = 0;i<arrLength;i++)
	{
		for(uint8_t j = 0;j<4;j++)
		{
			charOut[4*i+j]=(hexArr[i] >> (8*j));
			if (charOut[4*i+j] == '\0') return;
		}
	}
}



int main(void){

    Device_init();

    UartPrint_init(LOG_SCI_BASE, 110000);
	log_set_level(LOG_DEBUG);
	log_info("Hello DSP!\r\n");
	log_info("Core running @ %d MHz.\r\n", DEVICE_SYSCLK_FREQ / 1000000);


/*****************************************************************************
 * 12ַֽ
******************************************************************************/
	AES_ConfigParams charConfig;								// AESýṹ
	charConfig.direction = AES_DIRECTION_ENCRYPT;				// ѡģʽ
	charConfig.srcAddr = (uint32_t *)charArr;								// ַַ
	charConfig.destAddr = charDestinations;						// üܺݴŵַ
	charConfig.packetLength = ((sizeof(charArr)/0x10)+1)*0x10;	// ĲΪ16ֽĳС =ĳ/16+1* 16 Byte
	charConfig.destLength = ((sizeof(charArr)/0x10)+1)*0x10;	// ĳͬ
	charConfig.keyAddr = key;									// Կַ
	charConfig.keySize = AES_CIPH_KEY_SIZE_128BIT;				// ѡԿСΪ128λ
	charConfig.cipherMode = AES_CIPH_MODE_ECB;					// ѡECBģʽ
	charConfig.cipherAlgorithm = AES_CIPH_ALG_AES;				// ѡAES㷨
	charConfig.hashAlgorithm = AES_HASH_ALG_NULL;				// ѡhash㷨Ϊ
	charConfig.hashMode = AES_HASH_MODE_NULL;					// ѡϣģʽΪ

	AES_configMode(AES_BASE, &charConfig);

	while(AES_IS_BUSY(AES_BASE));	// Ƿڼ


	log_info("The ciphertext of charArr is:\r\n");
	for(int i = 0;i<4;i++){
		printf("0x%.8x,\r\n",charDestinations[i]);
	}

/*****************************************************************************
 * 16ֽ
******************************************************************************/
	AES_ConfigParams charConfig2;
	charConfig2.direction = AES_DIRECTION_DECRYPT;
	charConfig2.srcAddr = charArr2;
	charConfig2.destAddr = charDestinations;
	charConfig2.packetLength = 0x10;		// 0x10
	charConfig2.destLength	= 0x10;
	charConfig2.keyAddr = key;
	charConfig2.keySize = AES_CIPH_KEY_SIZE_128BIT;
	charConfig2.cipherMode = AES_CIPH_MODE_ECB;
	charConfig2.cipherAlgorithm = AES_CIPH_ALG_AES;
	charConfig2.hashAlgorithm = AES_HASH_ALG_NULL;
	charConfig2.hashMode = AES_HASH_MODE_NULL;

	AES_configMode(AES_BASE, &charConfig2);

	while(AES_IS_BUSY(AES_BASE));	// Ƿڼ

	log_info("The data after decrypting charArr is:\r\n");

	for(int i = 0;i<4;i++){
		printf("0x%.8x,\r\n",charDestinations[i]);
	}

	log_info("Converting this data to a string is:\r\n");

	uint8_t charOut[20] = {0};
	hex2char(charDestinations,sizeof(charDestinations)/sizeof(charDestinations[0]),charOut);
	printf("%s\r\n",charOut);

/*****************************************************************************
 * 448ֽ16
******************************************************************************/
	AES_ConfigParams config;
	config.direction = AES_DIRECTION_ENCRYPT;
	config.srcAddr = sources;
	config.destAddr = destinations;
	config.packetLength = 0x1c0;		// ĳΪ0x10򱣳ֲ
	config.destLength = 0x1c0;
	config.keyAddr = key;
	config.keySize = AES_CIPH_KEY_SIZE_128BIT;
	config.cipherMode = AES_CIPH_MODE_ECB;
	config.cipherAlgorithm = AES_CIPH_ALG_AES;
	config.hashAlgorithm = AES_HASH_ALG_NULL;
	config.hashMode = AES_HASH_MODE_NULL;

	AES_configMode(AES_BASE, &config);

	while(AES_IS_BUSY(AES_BASE));	// Ƿڼ

	log_info("The ciphertext of sources is\r\n");
	for(int i = 0;i<112;i++){
		printf("0x%.8x,\r\n",destinations[i]);
	}

/*****************************************************************************
 * 448ֽ16
******************************************************************************/
	AES_ConfigParams config2;
	config2.direction = AES_DIRECTION_DECRYPT;
	config2.srcAddr = sources2;
	config2.destAddr = destinations2;
	config2.packetLength = 0x1c0;
	config2.destLength = 0x1c0;
	config2.keyAddr = key;
	config2.keySize = AES_CIPH_KEY_SIZE_128BIT;
	config2.cipherMode = AES_CIPH_MODE_ECB;
	config2.cipherAlgorithm = AES_CIPH_ALG_AES;
	config2.hashAlgorithm = AES_HASH_ALG_NULL;
	config2.hashMode = AES_HASH_MODE_NULL;

	AES_configMode(AES_BASE, &config2);
	while(AES_IS_BUSY(AES_BASE));	// Ƿڼ

	log_info("The data after decrypting sources2 is:\r\n");
	for(int i = 0;i<112;i++){
		printf("0x%.8x,\r\n",destinations2[i]);
	}

    while (1) {
    }

    return 0;
}


