/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

#include "IQMathLib.h"
#include "gs32_math.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */


/*
_IQNtoF
_IQNfrac
_IQNsinPU
_IQNcosPU
_IQNsin
_IQNcos
_IQNasin
_IQNacos
_IQNatan
_IQNatan2
_IQNatan2PU
_IQsat
_IQNmpy
_IQNrmpy
__IQNmpyIQX
_IQNdiv
_atoIQN
_IQNtoa
_IQNlog
_IQNexp
_IQNsqrt
*/

//add macro:
//MATH_TYPE IQ_MATH
//IQMATH_NICE 1

void IQMath_wrap(void)
{
	volatile int	input_i1 = 123456 , input_i2 = 24576 , input_i3 = 1566 , iqNInput = 7654321;
	volatile int8_t q_value = 12, q_value1 = 8;
	volatile uint8_t q_value_const = 6;
	const char	input_s1[] = "%5.7f";
	volatile char	input_s2[] = "-234.567";
	volatile int result_i;
	volatile float result_f;
	volatile uint32_t cycle;

	CPU_clearCycleCnt();
	result_f = _IQ12toF( input_i1 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12toF		( %d )	= %f	cycle:	%u\n", input_i1 , result_f, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12frac( input_i1 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12frac		( %d )	= %d		cycle:	%u\n",input_i1 , result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ8sinPU( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ8sinPU		( %d )	= %d		cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ24cosPU( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ24cosPU		( %d )	= %d	cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ4sin( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ4sin		( %d )	= %d		cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ8cos( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ8cos		( %d )	= %d		cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12asin( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12asin		( %d )	= %d		cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12acos( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12acos		( %d )	= %d		cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ16atan( input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ16atan		( %d )	= %d		cycle:	%u\n",input_i3, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12atan2( input_i3 , input_i2 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12atan2		( %d , %d )	= %d	cycle:	%u\n",input_i3 , input_i2 , result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12atan2PU( input_i3 , input_i2 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12atan2PU	( %d , %d )	= %d	cycle:	%u\n",input_i3 , input_i2, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQsat( input_i1 , input_i2 , input_i3 );
	cycle = CPU_getCycleCnt();
	log_info("_IQsat		( %d , %d , %d )	= %d	cycle:	%u\n", input_i1, input_i2, input_i3 , result_i , cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12mpy( input_i1 , input_i2 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12mpy		( %d , %d )	= %d	cycle:	%u\n",input_i1 , input_i2 , result_i , cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12rmpy( input_i1 , input_i2 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12rmpy		( %d , %d )	= %d	cycle:	%u\n",input_i1 , input_i2, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12mpyIQX( input_i1 , q_value , input_i3 , q_value1  );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12mpyIQX	( %d, %d, %d, %d )	= %d	cycle:	%u\n",input_i1 , q_value , input_i3 , q_value1, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12div( input_i1 , input_i2 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12div		( %d , %d )	= %d		cycle:	%u\n",input_i1, input_i2, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _atoIQ9( input_s2 );
	cycle = CPU_getCycleCnt();
	log_info("_atoIQ9		( %s )	= %d		cycle:	%u\n",input_s2, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ10toa( input_s2 , input_s1 , iqNInput );
	cycle = CPU_getCycleCnt();
	log_info("_IQ10toa		( %s , %s , %d )	= %d	cycle:	%u\n", input_s2 , input_s1, iqNInput , result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ12log( input_i1 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ12log		( %d )	= %d			cycle:	%u\n",input_i1, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ13exp( input_i2  );
	cycle = CPU_getCycleCnt();
	log_info("_IQ13exp		( %d )	= %d		cycle:	%u\n",input_i2, result_i, cycle);

	CPU_clearCycleCnt();
	result_i = _IQ8sqrt( input_i1 );
	cycle = CPU_getCycleCnt();
	log_info("_IQ8sqrt		( %d )	= %d			cycle:	%u\n",input_i1, result_i, cycle);

}


