/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

#include <math.h>
#include <stdlib.h>

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */


void libc_math_test(void)
{
	volatile long int input_l32 = -3963;
	volatile float   input_f32 = 501.37;
	volatile float   input_f32_2 = 5.485;
	volatile float   input_f32_3 = 4.93;
	const uint32_t input5 = 5;
	float result_f;
	volatile uint32_t cycle;
	volatile long int result_l;

	CPU_clearCycleCnt();
	result_f = roundf( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("roundf	( %f )	= %f		cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = floorf( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("floorf	( %f )	= %f		cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_f = ceilf( input_f32 );
	cycle = CPU_getCycleCnt();
	log_info("ceilf	( %f )	= %f		cycle:	%u\n",input_f32, result_f, cycle);

	CPU_clearCycleCnt();
	result_l = labs( input_l32 );
	cycle = CPU_getCycleCnt();
	log_info("labs	( %ld )	= %ld			cycle:	%u\n",input_l32, result_l, cycle);

}
