/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

#include "gs32_math.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */


/*
__smin
__smax
__umin
__umax
__andn
__orn
__nxor
__sat16
__sat16u
__sat32u
__rbit
__flip32
__rbit_msbi
__clz
__ctz
__bswap32
__bswap16
*/

void integer_wrap(void)
{
	volatile uint32_t	input_uint_1 = 0xF0000F00, input_uint_2 = 0xF003F0, input_uint_3 = 0xF0F0, input_uint_4 = 0x20F;
	volatile int 		input_int_1 = -597, input_int_2 = 789;
	const int 			input_const_int = 4;
	uint32_t result_uint;
	int		 result_int;
	volatile uint32_t cycle;

	CPU_clearCycleCnt();
	result_int = __smin( input_int_1 , input_int_2 );
	cycle = CPU_getCycleCnt();
	log_info("__smin	( %d, %d )	= %d		cycle:	%u\n",input_int_1 , input_int_2, result_int, cycle);

	CPU_clearCycleCnt();
	result_int = __smax( input_int_1 , input_int_2 );
	cycle = CPU_getCycleCnt();
	log_info("__smax	( %d, %d )	= %d		cycle:	%u\n",input_int_1 , input_int_2, result_int, cycle);

	CPU_clearCycleCnt();
	result_uint = __umin( input_uint_3 , input_uint_4 );
	cycle = CPU_getCycleCnt();
	log_info("__umin	( %u, %u )	= %u		cycle:	%u\n",input_uint_3 , input_uint_4, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __umax( input_uint_3 , input_uint_4 );
	cycle = CPU_getCycleCnt();
	log_info("__umax	( %u, %u )	= %u		cycle:	%u\n",input_uint_3 , input_uint_4, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __andn( input_uint_1 , input_uint_2 );
	cycle = CPU_getCycleCnt();
	log_info("__andn	( 0x%x, 0x%x )	= 0x%x	cycle:	%u\n",input_uint_1 , input_uint_2, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __orn( input_uint_1 , input_uint_2 );
	cycle = CPU_getCycleCnt();
	log_info("__orn	( 0x%x, 0x%x )	= 0x%x	cycle:	%u\n",input_uint_1 , input_uint_2, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __nxor( input_uint_1 , input_uint_2 );
	cycle = CPU_getCycleCnt();
	log_info("__nxor	( 0x%x, 0x%x )	= 0x%x	cycle:	%u\n",input_uint_1 , input_uint_2, result_uint, cycle);

	CPU_clearCycleCnt();
	result_int = __sat16( input_int_1 );
	cycle = CPU_getCycleCnt();
	log_info("__sat16	( 0x%x )	= 0x%x	cycle:	%u\n",input_int_1, result_int, cycle);

	CPU_clearCycleCnt();
	result_uint = __sat16u( input_uint_1 );
	cycle = CPU_getCycleCnt();
	log_info("__sat16u	( 0x%x )	= 0x%x		cycle:	%u\n",input_uint_1, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __sat32u( input_uint_2 );
	cycle = CPU_getCycleCnt();
	log_info("__sat32u	( %d )	= %u	cycle:	%u\n",input_uint_2, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __abs_sat( input_int_1 );
	cycle = CPU_getCycleCnt();
	log_info("__abs_sat	( 0x%x )	= 0x%x		cycle:	%u\n",input_int_1, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __rbit( input_uint_1 );
	cycle = CPU_getCycleCnt();
	log_info("__rbit	( 0x%x )	= 0x%x	cycle:	%u\n",input_uint_1, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __flip32( input_uint_1 );
	cycle = CPU_getCycleCnt();
	log_info("__flip32	( 0x%x )	= 0x%x	cycle:	%u\n",input_uint_1, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __rbit_msbi( input_int_1 , input_const_int);
	cycle = CPU_getCycleCnt();
	log_info("__rbit_msbi( 0x%x , %d )	= 0x%x		cycle:	%u\n",input_uint_1, input_const_int, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __clo( input_uint_3 );
	cycle = CPU_getCycleCnt();
	log_info("__clo	( 0x%x )	= 0x%x		cycle:	%u\n",input_uint_3, result_uint, cycle);

	CPU_clearCycleCnt();
	result_int = __clz( input_uint_3 );
	cycle = CPU_getCycleCnt();
	log_info("__clz	( 0x%x )	= 0x%x		cycle:	%u\n",input_uint_3, result_int, cycle);

	CPU_clearCycleCnt();
	result_int = __ctz( input_uint_1 );
	cycle = CPU_getCycleCnt();
	log_info("__ctz	( 0x%x )	= 0x%x		cycle:	%u\n",input_uint_1, result_int, cycle);

	CPU_clearCycleCnt();
	result_uint = __bswap32( input_uint_1 );
	cycle = CPU_getCycleCnt();
	log_info("__bswap32	( 0x%x )	= 0x%x	cycle:	%u\n",input_uint_1, result_uint, cycle);

	CPU_clearCycleCnt();
	result_uint = __bswap16( input_uint_1 );
	cycle = CPU_getCycleCnt();
	log_info("__bswap16	( 0x%x )	= 0x%x		cycle:	%u\n",input_uint_1, result_uint, cycle);

	CPU_clearCycleCnt();
	__nop_cnt( 255 );
	cycle = CPU_getCycleCnt();
	log_info("__nop_cnt	( 255 )				cycle:	%u\n", cycle);

}


#define ln2 0.69314718
int   result_data[10000]={0};
float result_cos[256]={0.0};
float result_sin[256]={0.0};
float result_atan[256]={0.0};

float PI=3.1415926;
float inte=12345;

uint32_t instr_repeat[20];
void repeat_test(void)
{
    uint16_t i;
    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] =i+12345;}
    instr_repeat[0] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] =12345-i;}
    instr_repeat[1] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = i* 12345;}
    instr_repeat[3] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = 12345/i ;}
    instr_repeat[4] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = PI+i;}
    instr_repeat[5] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = i-PI;}
    instr_repeat[6] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = PI*i;}
    instr_repeat[7] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = i/PI;}
    instr_repeat[8] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<256;i++){result_sin[i] = __sin(100*PI*i/3200);}
    instr_repeat[9] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<256;i++){result_sin[i] = __sinpuf32(100*PI*i/3200);}
    instr_repeat[10] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<256;i++){result_cos[i] = __cos(100*PI*i/3200);}
    instr_repeat[11] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<256;i++){result_cos[i] = __cospuf32(100*PI*i/3200);}
    instr_repeat[12] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<256;i++){result_atan[i] = __atan(100*PI*i/3200);}
    instr_repeat[13] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<256;i++){result_atan[i] = __atan2((float)i, (float)PI);}
    instr_repeat[14] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = __fmin((float)i, (float)PI);}
    instr_repeat[15] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = __fmax((float)i, (float)PI);}
    instr_repeat[16] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for(i=0;i<10000;i++){result_data[i]= __expf32((100*PI*i/3200) * ln2);}
    instr_repeat[17] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){result_data[i] = __sqrt( PI*i );}
    instr_repeat[18] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,1);
    __RV_CSR_WRITE(CSR_MINSTRET, 0);
    for (i=0;i<10000;i++){ __mv3_x2mpr_r0( i*2 , i, inte);}
    instr_repeat[19] = __RV_CSR_READ(CSR_MINSTRET);

    GPIO_writePin(23,0);

    log_info("Addition (i+12345)     \t\tloop: 10000\tins count: %u\n", instr_repeat[0]);
    log_info("Subtraction (12345-i)  \t\tloop: 10000\tins count: %u\n", instr_repeat[1]);
    log_info("Multiplication (i*12345)\t\tloop: 10000\tins count: %u\n", instr_repeat[3]);
    log_info("Division (12345/i)     \t\tloop: 10000\tins count: %u\n", instr_repeat[4]);
    log_info("Float add (PI+i)       \t\tloop: 10000\tins count: %u\n", instr_repeat[5]);
    log_info("Float sub (i-PI)       \t\tloop: 10000\tins count: %u\n", instr_repeat[6]);
    log_info("Float mul (PI*i)       \t\tloop: 10000\tins count: %u\n", instr_repeat[7]);
    log_info("Float div (i/PI)       \t\tloop: 10000\tins count: %u\n", instr_repeat[8]);
    log_info("sin                    \t\tloop: 256\tins count: %u\n", instr_repeat[9]);
    log_info("sinpuf32               \t\tloop: 256\tins count: %u\n", instr_repeat[10]);
    log_info("cos                    \t\tloop: 256\tins count: %u\n", instr_repeat[11]);
    log_info("cospuf32               \t\tloop: 256\tins count: %u\n", instr_repeat[12]);
    log_info("atan                   \t\tloop: 256\tins count: %u\n", instr_repeat[13]);
    log_info("atan2                  \t\tloop: 256\tins count: %u\n", instr_repeat[14]);
    log_info("fmin                   \t\tloop: 10000\tins count: %u\n", instr_repeat[15]);
    log_info("fmax                   \t\tloop: 10000\tins count: %u\n", instr_repeat[16]);
    log_info("exp                    \t\tloop: 10000\tins count: %u\n", instr_repeat[17]);
    log_info("sqrt                   \t\tloop: 10000\tins count: %u\n", instr_repeat[18]);
    log_info("mv3_x2mpr_r0           \t\tloop: 10000\tins count: %u\n", instr_repeat[19]);


}
