/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"            //smp thread safe

#include "gs32_transform.h"
#include "gs32_pwm_clu.h"
#include "gs32_NLPID_clu.h"
#include "rampgen.h"
#include "transform_test.h"
#include "pwm_test.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define PI (3.1415926536) // The value of PI

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         External Function Prototypes                       */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void CLU_loop_test(void)
{
	ABC_DQ_POS abc_dq_pos;
	DQ_ABC dq_abc;
	PWM_VECT_3P2L_Obj pwm_vect_obj;
	PWM_ZERO_Obj pwm_zero_obj;
	SVPWM_3P3L_Obj svpwm_obj;
	NLPID nlpid;
	NLPID_SPS nlpid_sps;
	NLPID_CSS nlpid_css;
	float result_data[1000];
	uint32_t instr_cp[30] = {0};
	int i;

	float a = 1.0f, b = 0.5f, c = -0.5f;
	float d = 0.8f, q = 0.6f;
	float angle = PI/4;
	float sine_val = __sin(angle);
	float cosine_val = __cos(angle);
	nlpid.sps = &nlpid_sps;
	nlpid.css = &nlpid_css;

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    ABC_DQ0_run(&abc_dq_pos, a, b, c, sine_val, cosine_val);
	}
	instr_cp[0] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    ABC_DQ1_run(&abc_dq_pos, a, b, c, angle);
	}
	instr_cp[1] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    DQ0_ABC_run(&dq_abc, d, q, sine_val, cosine_val);
	}
	instr_cp[2] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    DQ2_ABC_run(&dq_abc, d, q, angle);
	}
	instr_cp[3] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    ABC_alphabeta_CLARKE_run(&abc_dq_pos, a, b, c);
	}
	instr_cp[4] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    alphabeta_DQ0_PARK_run(&abc_dq_pos, sine_val, cosine_val);
	}
	instr_cp[5] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    alphabeta_DQ1_PARK_run(&abc_dq_pos, angle);
	}
	instr_cp[6] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    DQ0_alphabeta_IPARK_run(&dq_abc, d, q, sine_val, cosine_val);
	}
	instr_cp[7] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    DQ1_alphabeta_IPARK_run(&dq_abc, d, q, angle);
	}
	instr_cp[8] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    alphabeta_ABC_ICLARKE_run(&dq_abc);
	}
	instr_cp[9] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    PWM_vect_3P2L_run(&pwm_vect_obj);
	}
	instr_cp[10] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    PWM_zero_run(&pwm_zero_obj);
	}
	instr_cp[11] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    SVPWM_3P3L_run(&svpwm_obj, PI_CLOOP);
	}
	instr_cp[12] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    NLPID_setfilterBW(&nlpid, 100.0f);
	}
	instr_cp[13] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    NLPID_setActivefilterBW(&nlpid, 100.0f, 0.001f);
	}
	instr_cp[14] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    result_data[i % 1000] = NLPID_getfilterBW(&nlpid);
	}
	instr_cp[15] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    result_data[i % 1000] = NLPID_getgamma( abc_dq_pos.alpha , abc_dq_pos.beta );
	}
	instr_cp[16] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    NLPID_setgamma(&nlpid);
	}
	instr_cp[17] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    NLPID_setActivegamma(&nlpid);
	}
	instr_cp[18] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    result_data[i % 1000] = NLPID_run_C1(&nlpid, 1.0f, 0.8f, 0.5f);
	}
	instr_cp[19] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,1);
	__RV_CSR_WRITE(CSR_MINSTRET, 0);
	for (i=0; i<1000; i++) {
	    result_data[i % 1000] = NLPID_run_C2(&nlpid, 1.0f, 0.8f, 0.5f);
	}
	instr_cp[20] = __RV_CSR_READ(CSR_MINSTRET);

	GPIO_writePin(23,0);


    printf("\r\n");
	log_info("CLU function performance test results (number of instructions):\n");
	log_info("ABC_DQ0_run            \t\tloop: 1000\tins count: %u\n", instr_cp[0]);
	log_info("ABC_DQ1_run            \t\tloop: 1000\tins count: %u\n", instr_cp[1]);
	log_info("DQ0_ABC_run            \t\tloop: 1000\tins count: %u\n", instr_cp[2]);
	log_info("DQ2_ABC_run            \t\tloop: 1000\tins count: %u\n", instr_cp[3]);
	log_info("ABC_alphabeta_CLARKE   \t\tloop: 1000\tins count: %u\n", instr_cp[4]);
	log_info("alphabeta_DQ0_PARK     \t\tloop: 1000\tins count: %u\n", instr_cp[5]);
	log_info("alphabeta_DQ1_PARK     \t\tloop: 1000\tins count: %u\n", instr_cp[6]);
	log_info("DQ0_alphabeta_IPARK    \t\tloop: 1000\tins count: %u\n", instr_cp[7]);
	log_info("DQ1_alphabeta_IPARK    \t\tloop: 1000\tins count: %u\n", instr_cp[8]);
	log_info("alphabeta_ABC_ICLARKE  \t\tloop: 1000\tins count: %u\n", instr_cp[9]);
	log_info("PWM_vect_3P2L_run      \t\tloop: 1000\tins count: %u\n", instr_cp[10]);
	log_info("PWM_zero_run           \t\tloop: 1000\tins count: %u\n", instr_cp[11]);
	log_info("SVPWM_3P3L_run         \t\tloop: 1000\tins count: %u\n", instr_cp[12]);
	log_info("NLPID_setfilterBW      \t\tloop: 1000\tins count: %u\n", instr_cp[13]);
	log_info("NLPID_setActivefilterBW\t\tloop: 1000\tins count: %u\n", instr_cp[14]);
	log_info("NLPID_getfilterBW      \t\tloop: 1000\tins count: %u\n", instr_cp[15]);
	log_info("NLPID_getgamma         \t\tloop: 1000\tins count: %u\n", instr_cp[16]);
	log_info("NLPID_setgamma         \t\tloop: 1000\tins count: %u\n", instr_cp[17]);
	log_info("NLPID_setActivegamma   \t\tloop: 1000\tins count: %u\n", instr_cp[18]);
	log_info("NLPID_run_C1           \t\tloop: 1000\tins count: %u\n", instr_cp[19]);
	log_info("NLPID_run_C2           \t\tloop: 1000\tins count: %u\n", instr_cp[20]);

}


/**
  * @brief  main function.
  * @param  None
  * @return None
  */
int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    GPIO_enableWritePin(23);

    /* Monitor IO23 output changes and measure calculation time */
    CLU_loop_test();

    ABC_DQ_POS_dsp_test();
    ABC_DQ1_POS_dsp_test();
    ABC_DQ0_dsp_test();
    ABC_DQ1_dsp_test();
    ABC_DQ_NEG_dsp_test();
    ABC_DQ1_NEG_dsp_test();
    DQ_ABC_dsp_Test();
    DQ1_ABC_dsp_Test();
    DQ0_ABC_dsp_Test();
    DQ2_ABC_dsp_Test();
    ABC_alphabeta_DQ0_dsp_test();
    ABC_alphabeta_DQ1_dsp_test();
    DQ0_alphabeta_ABC_dsp_Test();
    DQ1_alphabeta_ABC_dsp_Test();

	/*test 3p2l PWM zero */
	dpwm_zero_test_run();

	/*test 3p2l PWM vector */
	pwm_vect_3p2l_test_run();

	/*test 3p3l PWM vector */
	svpwm_3p3l_test_run();

	for(;;);
    return 0;
}


