/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

#include "gs32_math.h"
#include "gs32_pwm_clu.h"
#include "gs32_pwm.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define SAMPLE_SIZE 1000
#define ERROR_THRD 2

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */


PWM_VECT_3P2L_Obj PWM_VECT_3P2L_ref = {0,0,0,0,0,0,0,0,0,0,0,0};
PWM_VECT_3P2L_Obj PWM_VECT_3P2L_res = {0,0,0,0,0,0,0,0,0,0,0,0};

SVPWM_3P3L_Obj PWM_VECT_3P3L_ref = {0,0,0,0,0,0,0,0,0,0,0,0};
SVPWM_3P3L_Obj PWM_VECT_3P3L_res = {0,0,0,0,0,0,0,0,0,0,0,0};

PWM_ZERO_Obj DPWM_ZERO_ref = {0,0,0,0,0,0,0,0,0,0,0,0};
PWM_ZERO_Obj DPWM_ZERO_res = {0,0,0,0,0,0,0,0,0,0,0,0};

volatile uint16_t epwm1_cmpa[SAMPLE_SIZE] = {0}, epwm2_cmpa[SAMPLE_SIZE] = {0}, epwm3_cmpa[SAMPLE_SIZE] = {0};
volatile uint16_t cmp_index;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

void dpwm_zero_test_run(void)
{
	uint32_t flag = 0;
	vuint32_t  error_cnt = 0;
	uint16 ref_cmpa[SAMPLE_SIZE] = {0};
	uint16 res_cmpa[SAMPLE_SIZE] = {0};
	uint16 ref_cmpb[SAMPLE_SIZE] = {0};
	uint16 res_cmpb[SAMPLE_SIZE] = {0};
	uint16 ref_cmpc[SAMPLE_SIZE] = {0};
	uint16 res_cmpc[SAMPLE_SIZE] = {0};

	DPWM_ZERO_ref.PRD_pwm  = 1500;
	DPWM_ZERO_ref.Udc = 270;
	DPWM_ZERO_ref.Speed = 1000;
	DPWM_ZERO_res.PRD_pwm  = DPWM_ZERO_ref.PRD_pwm;
	DPWM_ZERO_res.Udc = DPWM_ZERO_ref.Udc;
	DPWM_ZERO_res.Speed = DPWM_ZERO_ref.Speed;

	for(volatile uint32_t mode = 0; mode <8; mode++)
	{
		cmp_index = 0;
		PWM_zero_config(mode);
		for(uint32_t i=0; i<SAMPLE_SIZE; i++)
		{
			DPWM_ZERO_ref.Ualpha = 150 * __sinpuf32(1.0f/SAMPLE_SIZE * i);
			DPWM_ZERO_ref.Ubeta =  150 * __sin(6.2831853f/SAMPLE_SIZE * i + 1.570796325f);
			PWM_zero_run_ref(&DPWM_ZERO_ref,  mode);

			DPWM_ZERO_res.Ualpha = DPWM_ZERO_ref.Ualpha;
			DPWM_ZERO_res.Ubeta = DPWM_ZERO_ref.Ubeta;
			PWM_zero_run(&DPWM_ZERO_res);

			epwm1_cmpa[cmp_index] = DPWM_ZERO_res.CMPa;
			epwm2_cmpa[cmp_index] = DPWM_ZERO_res.CMPb;
			epwm3_cmpa[cmp_index] = DPWM_ZERO_res.CMPc;
			cmp_index++;
			if(cmp_index>=SAMPLE_SIZE) cmp_index=0;

			ref_cmpa[i] = DPWM_ZERO_ref.CMPa;
			res_cmpa[i] = DPWM_ZERO_res.CMPa;
			ref_cmpb[i] = DPWM_ZERO_ref.CMPb;
			res_cmpb[i] = DPWM_ZERO_res.CMPb;
			ref_cmpc[i] = DPWM_ZERO_ref.CMPc;
			res_cmpc[i] = DPWM_ZERO_res.CMPc;

			if(i == SAMPLE_SIZE-1)
			{
				flag = 1;
				log_info("DPWM_ZERO mode %d test end, result: %s\r\n", mode, (error_cnt==0)?"Pass":"Fail");
			}
			if ((__fabs(ref_cmpa[i]-res_cmpa[i])>ERROR_THRD)||(__fabs(ref_cmpb[i]-res_cmpb[i])>ERROR_THRD)||(__fabs(ref_cmpc[i]-res_cmpc[i])>ERROR_THRD))
			{
				error_cnt++;
			}
		}
	}
}

void pwm_vect_3p2l_test_run(void)
{
	uint32_t flag = 0;
	vuint32_t  error_cnt = 0;
	uint16 ref_cmpa[SAMPLE_SIZE] = {0};
	uint16 res_cmpa[SAMPLE_SIZE] = {0};
	uint16 ref_cmpb[SAMPLE_SIZE] = {0};
	uint16 res_cmpb[SAMPLE_SIZE] = {0};
	uint16 ref_cmpc[SAMPLE_SIZE] = {0};
	uint16 res_cmpc[SAMPLE_SIZE] = {0};

	PWM_VECT_3P2L_ref.PRD_pwm  = 1500;
	PWM_VECT_3P2L_ref.Udc = 270;
	PWM_VECT_3P2L_res.PRD_pwm  = PWM_VECT_3P2L_ref.PRD_pwm;
	PWM_VECT_3P2L_res.Udc = PWM_VECT_3P2L_ref.Udc;

	for(uint32_t mode = 0; mode <7; mode++)
	{
		cmp_index = 0;
		PWM_vect_3P2L_config(mode);
		for(uint32_t i=0; i<SAMPLE_SIZE; i++)
		{
			PWM_VECT_3P2L_ref.Ualpha = 150 * __sin(6.2831853f/SAMPLE_SIZE * i);
			PWM_VECT_3P2L_ref.Ubeta =  150 * __sin(6.2831853f/SAMPLE_SIZE * i + 1.570796325f);
			PWM_vect_3P2L_run_ref(&PWM_VECT_3P2L_ref,  mode);

			PWM_VECT_3P2L_res.Ualpha = PWM_VECT_3P2L_ref.Ualpha;
			PWM_VECT_3P2L_res.Ubeta = PWM_VECT_3P2L_ref.Ubeta;
			PWM_vect_3P2L_run(&PWM_VECT_3P2L_res);

			epwm1_cmpa[cmp_index] = PWM_VECT_3P2L_res.CMPa;
			epwm2_cmpa[cmp_index] = PWM_VECT_3P2L_res.CMPb;
			epwm3_cmpa[cmp_index] = PWM_VECT_3P2L_res.CMPc;
			cmp_index++;
			if(cmp_index>=SAMPLE_SIZE) cmp_index=0;

			ref_cmpa[i] = PWM_VECT_3P2L_ref.CMPa;
			res_cmpa[i] = PWM_VECT_3P2L_res.CMPa;
			ref_cmpb[i] = PWM_VECT_3P2L_ref.CMPb;
			res_cmpb[i] = PWM_VECT_3P2L_res.CMPb;
			ref_cmpc[i] = PWM_VECT_3P2L_ref.CMPc;
			res_cmpc[i] = PWM_VECT_3P2L_res.CMPc;

			if(i == SAMPLE_SIZE-1)
			{
				flag = 1;
				log_info("PWM_VECT 2P2L mode %d test end, result: %s\r\n", mode, (error_cnt==0)?"Pass":"Fail");
			}
			if ((__fabs(ref_cmpa[i]-res_cmpa[i])>ERROR_THRD)||(__fabs(ref_cmpb[i]-res_cmpb[i])>ERROR_THRD)||(__fabs(ref_cmpc[i]-res_cmpc[i])>ERROR_THRD))
			{
				error_cnt++;
			}
		}
	}
}

void svpwm_3p3l_test_run(void)
{
	uint32_t flag = 0;
	vuint32_t  error_cnt = 0;
	uint16 ref_cmpa[SAMPLE_SIZE] = {0};
	uint16 res_cmpa[SAMPLE_SIZE] = {0};
	uint16 ref_cmpb[SAMPLE_SIZE] = {0};
	uint16 res_cmpb[SAMPLE_SIZE] = {0};
	uint16 ref_cmpc[SAMPLE_SIZE] = {0};
	uint16 res_cmpc[SAMPLE_SIZE] = {0};

	PWM_VECT_3P3L_ref.PRD_pwm  = 1500;
	PWM_VECT_3P3L_ref.Udc_ref = 270;
	PWM_VECT_3P3L_ref.Udc1 = 270/2;
	PWM_VECT_3P3L_ref.Udc2 = 270/2;
	PWM_VECT_3P3L_res.PRD_pwm  = PWM_VECT_3P3L_ref.PRD_pwm;
	PWM_VECT_3P3L_res.Udc_ref = PWM_VECT_3P3L_ref.Udc_ref;
	PWM_VECT_3P3L_res.Udc1 = PWM_VECT_3P3L_ref.Udc1;
	PWM_VECT_3P3L_res.Udc2 = PWM_VECT_3P3L_ref.Udc2;

	for(uint32_t mode = 0; mode <3; mode++)
	{
		for(uint32_t i=0; i<SAMPLE_SIZE; i++)
		{
			PWM_VECT_3P3L_ref.Ualpha = 150 * __sin(6.2831853f/SAMPLE_SIZE * i);
			PWM_VECT_3P3L_ref.Ubeta =  150 * __sin(6.2831853f/SAMPLE_SIZE * i + 1.570796325f);
			SVPWM_3P3L_run_ref(&PWM_VECT_3P3L_ref,  mode);

			PWM_VECT_3P3L_res.Ualpha = PWM_VECT_3P3L_ref.Ualpha;
			PWM_VECT_3P3L_res.Ubeta = PWM_VECT_3P3L_ref.Ubeta;
			SVPWM_3P3L_run(&PWM_VECT_3P3L_res,  mode);

			ref_cmpa[i] = PWM_VECT_3P3L_ref.CMPa1;
			res_cmpa[i] = PWM_VECT_3P3L_res.CMPa1;
			ref_cmpb[i] = PWM_VECT_3P3L_ref.CMPb1;
			res_cmpb[i] = PWM_VECT_3P3L_res.CMPb1;
			ref_cmpc[i] = PWM_VECT_3P3L_ref.CMPc1;
			res_cmpc[i] = PWM_VECT_3P3L_res.CMPc1;

			if(i == SAMPLE_SIZE-1)
			{
				flag = 1;
				log_info("PWM_VECT 3P3L mode %d test end, result: %s\r\n", mode, (error_cnt==0)?"Pass":"Fail");
			}
			if ((__fabs(ref_cmpa[i]-res_cmpa[i])>ERROR_THRD)||(__fabs(ref_cmpb[i]-res_cmpb[i])>ERROR_THRD)||(__fabs(ref_cmpc[i]-res_cmpc[i])>ERROR_THRD))
			{
				error_cnt++;
			}
		}
	}
}

