/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************

void CLB_init(){
	PinMux_init();
	myTILE1_init();
	initTILE1(myCLBForTILE1_BASE);
	pwm_set();


}
void PinMux_init()
{
	//
	// PinMux for modules assigned to CPU1
	//

	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> myEPWM2 Pinmux
	//
	GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_32_CLB_OUTPUTXBAR1);
	GPIO_setPadConfig(32, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(32, GPIO_QUAL_SYNC);


	GPIO_setPinConfig(GPIO_33_CLB_OUTPUTXBAR2);
	GPIO_setPadConfig(33, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(33, GPIO_QUAL_SYNC);


}
void myTILE1_init(){

	//
	// myTILE1 CLB_IN0 initialization
	//

	// myTILE1 CLB_IN0 initialization
	//
	CLB_configGlobalInputMux(myCLBForTILE1_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL1_OUT);
	CLB_configGPInputMux(myCLBForTILE1_BASE, CLB_IN0, CLB_GP_IN_MUX_GP_REG);
	CLB_selectInputFilter(myCLBForTILE1_BASE, CLB_IN0,CLB_FILTER_NONE);
	// myTILE1 CLB_IN1 initialization
	//
	CLB_configGlobalInputMux(myCLBForTILE1_BASE, CLB_IN1, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL2_OUT);
	CLB_configGPInputMux(myCLBForTILE1_BASE, CLB_IN1, CLB_GP_IN_MUX_GP_REG);

	CLB_selectInputFilter(myCLBForTILE1_BASE, CLB_IN1, CLB_FILTER_RISING_EDGE);
	// myTILE1 CLB_IN2 initialization
	//
	CLB_configGlobalInputMux(myCLBForTILE1_BASE, CLB_IN2,CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL3_OUT);
	CLB_configGPInputMux(myCLBForTILE1_BASE, CLB_IN2, CLB_GP_IN_MUX_GP_REG);

	CLB_selectInputFilter(myCLBForTILE1_BASE, CLB_IN2,CLB_FILTER_NONE );
	// myTILE1 CLB_IN3 initialization
	//
	CLB_configGlobalInputMux(myCLBForTILE1_BASE, CLB_IN3, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL1_OUT);
	CLB_configGPInputMux(myCLBForTILE1_BASE, CLB_IN3, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLBForTILE1_BASE, CLB_IN3,CLB_FILTER_RISING_EDGE);
	// myTILE1 CLB_IN5 initialization
	//1
	CLB_configGlobalInputMux(myCLBForTILE1_BASE, CLB_IN5, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL1_OUT);
	CLB_configGPInputMux(myCLBForTILE1_BASE, CLB_IN5, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLBForTILE1_BASE, CLB_IN5,CLB_FILTER_NONE );


}

void pwm_set()
{
	EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
							EPWM_HSCLOCK_DIVIDER_1);

	EPWM_setTimeBaseCounter(EPWM1_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM1_BASE, 0x2000);

	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 0x1000);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 0x7FFF);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);

	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

	EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);

	EPWM_setDigitalCompareEventSource(EPWM1_BASE,EPWM_DC_MODULE_B,EPWM_DC_EVENT_1,EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

	EPWM_setTimeBaseCounter(EPWM2_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM2_BASE, 0xbb80);

	EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, 0xB798);
	EPWM_setCounterCompareShadowLoadMode(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, 0x7FFF);
	EPWM_setCounterCompareShadowLoadMode(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);

	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

	EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP);

	EPWM_setDigitalCompareEventSource(EPWM2_BASE,EPWM_DC_MODULE_B,EPWM_DC_EVENT_1,EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

	HWREG(0x4003F000 + 0x120) = 0x10000;
	HWREG(0x4003F000 + 0x44) = 0x40000;
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

