//#############################################################################
//
// FILE:   epg_ex1_generate_clocks.c
//
// TITLE:   EPG Generating Synchronous Clocks
//
//! \addtogroup driver_example_list
//! <h1> EPG Generating Synchronous Clocks </h1>
//!
//! This example shows how to generate 2 synchronous clocks with edges being
//! offset by 2 clock cycles. It configures Signal Generator to shift a
//! periodic data. Generated Clock has period EPG CLOCK/6.
//!
//! \b External \b Connections \n
//!  - None. Signal is generated on GPIO 2, 3. Can be visualized
//!    through oscilloscope.
//!
//! \b Watch \b Variables \n
//!  - sigGenActiveData - Active Data of signal generator transform output
//!
//
//#############################################################################
/*
 *   Copyright (c) Gejian Semiconductors 2024
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
//###########################################################################
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "epg_ex1_generate_clocks_board.h"
#include "epg.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

uint32_t sigGenActiveData = 0;  // ת

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

int main(void)
{
	 Device_init();
	 SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_EPG);
	 UartPrint_init(LOG_SCI_BASE, 115200);
	 printf("print ok\r\n");

	 Board_init();

	 while(1)
	 {
		sigGenActiveData = EPG_getData0ActiveReg(EPG_BASE, EPG_SIGGEN0);
		//
        // Delay before reading the transformed data by signal generator
        //
		DELAY_US(1000000);
	 }

	 return 0;
}
