#include "epg_ex7_generate_two_offset_clocks_board.h"
#include "epg.h"
#include "xbar.h"

#define CLK_GEN_PERIOD      99U
#define CLK_GEN_OFFSET      0U
#define SIG_GEN_DATA_LENGTH 12U
#define SIG_GEN_DATA0_0_12  0b000001111110U                  
#define SIG_GEN_DATA0_16_27 (SIG_GEN_DATA0_0_12 << 2)        

void PinMux_init(void)
{
	// OUTPUTXBAR Pin Mux
	// OUTPUTXBAR1_PIN GPIO_2
    GPIO_setPinConfig(OUTPUTXBAR1_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR1_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR1_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR1_GPIO, GPIO_QUAL_SYNC);

    // OUTPUTXBAR2_PIN GPIO_3
    GPIO_setPinConfig(OUTPUTXBAR2_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR2_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR2_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR2_GPIO, GPIO_QUAL_SYNC);
}


void XBAR_Init(void)
{
    //
    // Connect EPG Output to GPIO through xbar
    //
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,
							XBAR_OUT_MUX30_EPGOUT0);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT2,
							XBAR_OUT_MUX31_EPGOUT1);

	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_MUX30);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT2, XBAR_MUX31);
}

void EPG_Init(void)
{
	uint32_t sigGenData = 0;

    //
    // Select Clock Generator output for EPG output of 0,1
    //
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT0, EPG_OUT_SEL_CLK);
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT1, EPG_OUT_SEL_CLK);

    //
    // Select Clock Generator Data output for EPG output of 0,1
    //
    EPG_selectClkOutput(EPG_BASE, EPG_OUT0, EPG_CLKGEN0_CLKOUT0_DCLK);
    EPG_selectClkOutput(EPG_BASE, EPG_OUT1, EPG_CLKGEN0_CLKOUT1_DCLK);

    //
    // Set Clock Generator 0 period to CLK_GEN_PERIOD
    //
    EPG_setClkGenPeriod(EPG_BASE, EPG_CLKGEN0, CLK_GEN_PERIOD);

    //
    // Set offset of clock generator output 0 to 0
    //
    EPG_setClkGenOffset(EPG_BASE, EPG_CLKGEN0, 0, CLK_GEN_OFFSET);

    //
    // Set offset of clock generator output 1 to 25
    //
    EPG_setClkGenOffset(EPG_BASE, EPG_CLKGEN0, 1, 25);

    //
    // Enable EPG
    //
    EPG_enableGlobal(EPG_BASE);
}


void Board_init(void)
{
	PinMux_init();
	XBAR_Init();
	EPG_Init();
}
