#include "epg_ex9_generate_serial_data_board.h"
#include "epg.h"
#include "xbar.h"

void PinMux_init(void)
{
	// OUTPUTXBAR Pin Mux
	// OUTPUTXBAR1_PIN GPIO_2
    GPIO_setPinConfig(OUTPUTXBAR1_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR1_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR1_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR1_GPIO, GPIO_QUAL_SYNC);

    // OUTPUTXBAR2_PIN GPIO_3
    GPIO_setPinConfig(OUTPUTXBAR2_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR2_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR2_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR2_GPIO, GPIO_QUAL_SYNC);
}


void XBAR_Init(void)
{
    //
    // Connect EPG Output to GPIO through xbar
    //
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,
							XBAR_OUT_MUX30_EPGOUT0);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT2,
							XBAR_OUT_MUX31_EPGOUT1);

	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_MUX30);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT2, XBAR_MUX31);
}

void EPG_Init(void)
{
	uint32_t sigGenData = 0;

    //
    // Select Signal Generator output for EPG output of 0,1
    //
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT0, EPG_OUT_SEL_SIG);
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT1, EPG_OUT_SEL_SIG);

	EPG_selectSignalOutput(EPG_BASE, EPG_OUT0, EPG_SIGGEN0_DATATRANOUT0);
	EPG_selectSignalOutput(EPG_BASE, EPG_OUT1, EPG_SIGGEN0_DATATRANOUT2);

    //
    // Set Clock Generator 0 period
    //
    EPG_setClkGenPeriod(EPG_BASE, EPG_CLKGEN0, CLK_GEN_PERIOD);

    //
    // Set the source of signal generator 0 to clk generator output 0
    //
    EPG_selectSigGenClkSource(EPG_BASE, EPG_SIGGEN0, EPG_CLKGEN0_CLKOUT0_GCLK);

    //
    // Set offset of clock generator output 0 to 0
    //
    EPG_setClkGenOffset(EPG_BASE, EPG_CLKGEN0, 0, 0);

    EPG_setDataBitLen(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA_LENGTH);
    EPG_setSignalGenMode(EPG_BASE, EPG_SIGGEN0, SIG_GEN_MODE);
    EPG_setData0Word(EPG_BASE, EPG_SIGGEN0, (SIG_GEN_DATA0_0_15 | (uint32_t)SIG_GEN_DATA0_16_31 << 16));

    //
    // Enable EPG
    //
    EPG_enableGlobal(EPG_BASE);

    //
    // Enable signal generator
    //
    EPG_enableSignalGen(EPG_BASE, EPG_SIGGEN0);
}


void Board_init(void)
{
	PinMux_init();		
	XBAR_Init();		
	EPG_Init();			
}
