
/* Includes ------------------------------------------------------------------*/
#include "device.h"
#include "board_cfg.h"
#include "load_img.h"
#include <sys/stat.h>
#include "log.h"


#define myEQEP0_BASE EQEP1_BASE
#define sum 200
#define COMPARE_SHADOW 0
#define myEPWM0_BASE  EPWM2_BASE


uint32_t interruptCount2 = 0;



//Temprory

uint32_t CNT=0;
uint32_t QPOSCNT=0;
uint32_t DIR=0;
uint32_t CNT_TEMP[2]={0,0};
int32_t CNT_DV[2];
volatile uint32_t EQEP_OK=0;
uint32_t i=0;
uint32_t ComValue=1;

uint64_t TEMP1=0;
uint64_t TEMP2=0;
int32_t CNT_DV_1=0;
void eqep_test11_GPIO_Init();
void eqep_test11_myEQEP0_init();
void eqep_test11_initEPWM(void);
#if myEQEP0_BASE == EQEP1_BASE
void EQEP1_INT_IRQHandler(void);
#elif myEQEP0_BASE == EQEP2_BASE
void EQEP2_INT_IRQHandler(void);
#endif
void EPWM2XINT_IRQHandler(void);

int16_t EQEP_getQDLF(uint32_t base);

uint32_t QPOSCNT_num[sum];
uint32_t PCMINT_num=0;
uint32_t PCRINT_num=0;
int32_t DIR_num[sum];
uint32_t EQEPCount1=0;


//
// EQEP1 -> myEQEP0 Pinmux
//
//
// EQEP1_A - GPIO Settings
//

#define myEQEP0_EQEPA_GPIO 50
#define myEQEP0_EQEPA_PIN_CONFIG GPIO_50_EQEP1_A
//
// EQEP1_B - GPIO Settings
//

#define myEQEP0_EQEPB_GPIO 51
#define myEQEP0_EQEPB_PIN_CONFIG GPIO_51_EQEP1_B
//
// EQEP1_INDEX - GPIO Settings
//

#define myEQEP0_EQEPINDEX_GPIO 53
#define myEQEP0_EQEPINDEX_PIN_CONFIG GPIO_53_EQEP1_INDEX
//
// EQEP1_STROBE - GPIO Settings
//

#define myEQEP0_EQEPSTROBE_GPIO 52
#define myEQEP0_EQEPSTROBE_PIN_CONFIG GPIO_52_EQEP1_STROBE



/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */

int main(void)
{
	int ret;


	Device_init();

	UartPrint_init(SCIA_BASE, 115200);

	printf("eqep_test11_begin!\r\n");

	eqep_test11_GPIO_Init();


    //epeq1a
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX01);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 2);
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX01_INPUTXBAR1);

	//epeq1b
    XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX03);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 3);
    XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX03_INPUTXBAR2);




    Interrupt_register(INT_EPWM2,EPWM2XINT_IRQHandler);
	Interrupt_SetPriority(INT_EPWM2,2,2);
	Interrupt_enable(INT_EPWM2);

#if myEQEP0_BASE == EQEP1_BASE
	Interrupt_register(INT_EQEP1,EQEP1_INT_IRQHandler);
	Interrupt_SetPriority(INT_EQEP1,0,0);
	Interrupt_enable(INT_EQEP1);
#elif myEQEP0_BASE == EQEP2_BASE
	Interrupt_register(INT_EQEP2,EQEP2_INT_IRQHandler);
	Interrupt_SetPriority(INT_EQEP2,0,0);
	Interrupt_enable(INT_EQEP2);
#endif


    __enable_irq();

    eqep_test11_myEQEP0_init();
	eqep_test11_initEPWM();


	while(1)
	{

		if( EQEP_OK == 1)
		{
			HWREG(0x400CD558)=0xBEEF;//make EDA simulation stop
			printf("Please refer to the test11 instructions to determine if it is correct!!!\r\n");
			printf("Please set COMPARE_SHADOW =0 or 1 or 2!!!\r\n");
			EQEP_OK = 2;

		}
	}

}

void eqep_test11_GPIO_Init()
{
	//
	// EPWM2 -> myEPWM0 Pinmux
	//
	GPIO_setPinConfig(GPIO_2_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(2,true);

	GPIO_setPinConfig(GPIO_3_EPWM2_B);
	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(3, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(3,true);




	//eqep1A
    GPIO_setAnalogMode(20,GPIO_ANALOG_DISABLED);//set Agpio13 to digital mode


    //eqep1B
    GPIO_setAnalogMode(21,GPIO_ANALOG_DISABLED);//set Agpio20 to digital mode


	//eqep1I
    GPIO_setAnalogMode(13,GPIO_ANALOG_DISABLED);//set Agpio21 to digital mode



	//eqep1A

	GPIO_setPinConfig(myEQEP0_EQEPA_PIN_CONFIG);
	GPIO_setPadConfig(myEQEP0_EQEPA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEQEP0_EQEPA_GPIO, GPIO_QUAL_SYNC);

    //eqep1B
	GPIO_setPinConfig(myEQEP0_EQEPB_PIN_CONFIG);
	GPIO_setPadConfig(myEQEP0_EQEPB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEQEP0_EQEPB_GPIO, GPIO_QUAL_SYNC);

	//eqep1I
	GPIO_setPinConfig(myEQEP0_EQEPINDEX_PIN_CONFIG);
	GPIO_setPadConfig(myEQEP0_EQEPINDEX_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEQEP0_EQEPINDEX_GPIO, GPIO_QUAL_SYNC);

	//eqep1S
	GPIO_setPinConfig(myEQEP0_EQEPSTROBE_PIN_CONFIG);
	GPIO_setPadConfig(myEQEP0_EQEPSTROBE_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEQEP0_EQEPSTROBE_GPIO, GPIO_QUAL_SYNC);

	//gpio10
	GPIO_setPinConfig(GPIO_10_GPIO10);
	GPIO_setPadConfig(10, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(10, GPIO_QUAL_SYNC);

	GPIO_enableWritePin(10);



}


void eqep_test11_myEQEP0_init(){

	//
	// Disable, clear all flags and interrupts
	//
	EQEP_disableInterrupt(myEQEP0_BASE,
		(EQEP_INT_GLOBAL            |
		EQEP_INT_POS_CNT_ERROR      |
		EQEP_INT_PHASE_ERROR        |
		EQEP_INT_DIR_CHANGE         |
		EQEP_INT_WATCHDOG           |
		EQEP_INT_UNDERFLOW          |
		EQEP_INT_OVERFLOW           |
		EQEP_INT_POS_COMP_READY     |
		EQEP_INT_POS_COMP_MATCH     |
		EQEP_INT_STROBE_EVNT_LATCH  |
		EQEP_INT_INDEX_EVNT_LATCH   |
		EQEP_INT_UNIT_TIME_OUT      |
		EQEP_INT_QMA_ERROR));
	EQEP_clearInterruptStatus(myEQEP0_BASE,
		(EQEP_INT_GLOBAL            |
		EQEP_INT_POS_CNT_ERROR      |
		EQEP_INT_PHASE_ERROR        |
		EQEP_INT_DIR_CHANGE         |
		EQEP_INT_WATCHDOG           |
		EQEP_INT_UNDERFLOW          |
		EQEP_INT_OVERFLOW           |
		EQEP_INT_POS_COMP_READY     |
		EQEP_INT_POS_COMP_MATCH     |
		EQEP_INT_STROBE_EVNT_LATCH  |
		EQEP_INT_INDEX_EVNT_LATCH   |
		EQEP_INT_UNIT_TIME_OUT      |
		EQEP_INT_QMA_ERROR));


	EQEP_SourceSelect source_myEQEP0 =
	{
		EQEP_SOURCE_PWMXBAR1, 		// eQEPA source
		EQEP_SOURCE_PWMXBAR2,		// eQEPB source
		EQEP_SOURCE_DEVICE_PIN,  	// eQEP Index source

	};


	//
	// Selects the source for eQEPA/B/I signals
	//
	EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
	//
	// Set the strobe input source of the eQEP module.
	//
	EQEP_setStrobeSource(myEQEP0_BASE,EQEP_STROBE_FROM_GPIO);
	//
	// Sets the polarity of the eQEP module's input signals.
	//
	EQEP_setInputPolarity(myEQEP0_BASE,false,false,false,false);
	//
	// Configures eQEP module's quadrature decoder unit.
	//
	EQEP_setDecoderConfig(myEQEP0_BASE, (EQEP_CONFIG_CLOCK_DIR | EQEP_CONFIG_1X_RESOLUTION | EQEP_CONFIG_NO_SWAP | EQEP_CONFIG_IGATE_DISABLE));
	//
	// Set the emulation mode of the eQEP module.
	//
	EQEP_setEmulationMode(myEQEP0_BASE,EQEP_EMULATIONMODE_RUNFREE);
	//
	// Configures eQEP module position counter unit.
	//
	EQEP_setPositionCounterConfig(myEQEP0_BASE,EQEP_POSITION_RESET_MAX_POS,4294967295U);
	//
	// Sets the current encoder position.
	//
	EQEP_setPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module unit timer.
	//
	//EQEP_enableUnitTimer(myEQEP0_BASE,1200000U);
	EQEP_enableUnitTimer(myEQEP0_BASE,200000U);
	//
	// Disables the eQEP module watchdog timer.
	//
	EQEP_disableWatchdog(myEQEP0_BASE);
	//
	// Configures the quadrature modes in which the position count can be latched.
	//
	EQEP_setLatchMode(myEQEP0_BASE,(EQEP_LATCH_UNIT_TIME_OUT|EQEP_LATCH_RISING_STROBE|EQEP_LATCH_RISING_INDEX));
	//
	// Set the quadrature mode adapter (QMA) module mode.
	//
	EQEP_setQMAModuleMode(myEQEP0_BASE,EQEP_QMA_MODE_BYPASS);
	//
	// Disable Direction Change During Index
	//
	EQEP_disableDirectionChangeDuringIndex(myEQEP0_BASE);
	//
	// Configures the mode in which the position counter is initialized.
	//
	EQEP_setPositionInitMode(myEQEP0_BASE,(EQEP_INIT_DO_NOTHING));
	//
	// Sets the software initialization of the encoder position counter.
	//
	EQEP_setSWPositionInit(myEQEP0_BASE,true);
	//
	// Sets the init value for the encoder position counter.
	//
	EQEP_setInitialPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module.
	//
	EQEP_enableModule(myEQEP0_BASE);
	//
	// Configures eQEP module edge-capture unit.
	//
	EQEP_setCaptureConfig(myEQEP0_BASE,EQEP_CAPTURE_CLK_DIV_64,EQEP_UNIT_POS_EVNT_DIV_32);

	// Enables individual eQEP module interrupt sources.
	//
#if (COMPARE_SHADOW==0)
	EQEP_enableInterrupt(myEQEP0_BASE,(EQEP_INT_POS_COMP_MATCH));
#elif (COMPARE_SHADOW==1 || COMPARE_SHADOW==2)
	EQEP_enableInterrupt(myEQEP0_BASE,(EQEP_INT_POS_COMP_READY));
#endif

#if (COMPARE_SHADOW==0)
	EQEP_setCompareConfig(myEQEP0_BASE,(EQEP_COMPARE_STROBE_SYNC_OUT|EQEP_COMPARE_NO_SHADOW),2,4000);
#elif (COMPARE_SHADOW==1)
	EQEP_setCompareConfig(myEQEP0_BASE,(EQEP_COMPARE_STROBE_SYNC_OUT|EQEP_COMPARE_LOAD_ON_ZERO),1,4000);
#elif (COMPARE_SHADOW==2)
	EQEP_setCompareConfig(myEQEP0_BASE,(EQEP_COMPARE_STROBE_SYNC_OUT|EQEP_COMPARE_LOAD_ON_MATCH),1,4000);
#endif
	//PCSPW=value*4*Systick
	EQEP_setComparePulseWidth(myEQEP0_BASE,400);//ԣһÿȵ廹ûв꣬µλƥ¼ʱ彫µ¼ʱ㿪ʼõȣԵ㣬ֵ4000


#if (COMPARE_SHADOW==0)
	//Active LOW pulse output
	HWREGH(myEQEP0_BASE + EQEP_O_QPOSCTL) |= EQEP_QPOSCTL_PCPOL;
#endif

	EQEP_enableCompare(myEQEP0_BASE);



}

void eqep_test11_initEPWM(void)
{

    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(myEPWM0_BASE, 0);
    EPWM_setTimeBaseCounter(myEPWM0_BASE, 0);

    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(myEPWM0_BASE,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(myEPWM0_BASE,
                                             EPWM_COUNTER_COMPARE_B);

    //
    // Set the compare A value to half the period value, compare B to 0
    //
#if (COMPARE_SHADOW==0)
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_A, 100);
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_B, 0);
#else
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_A, 10001);
    EPWM_setCounterCompareValue(myEPWM0_BASE, EPWM_COUNTER_COMPARE_B, 1);
#endif
    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(myEPWM0_BASE, EPWM_INT_TBCTR_PERIOD);
    EPWM_enableInterrupt(myEPWM0_BASE);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(myEPWM0_BASE, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(myEPWM0_BASE, EPWM_CLOCK_DIVIDER_4,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
#if (COMPARE_SHADOW==0)
    EPWM_setPeriodLoadMode(myEPWM0_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(myEPWM0_BASE, 200);
#else
    EPWM_setPeriodLoadMode(myEPWM0_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(myEPWM0_BASE, 20000);
#endif


    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(myEPWM0_BASE, EPWM_COUNTER_MODE_UP_DOWN);


    SysCtl_enablePeripheral_TBCLKSYNC();


}

/**
 * \brief   ePWM1 ISR--interrupts once every 4 QCLK counts (one period)
 *
 * \param   none
 *
 * \retval  None
 */
void EPWM2XINT_IRQHandler(void)
{



    interruptCount2++;


	if(EQEP_OK == 0)
	{

		QPOSCNT = EQEP_getPosition(myEQEP0_BASE);


		QPOSCNT_num[EQEPCount1] = QPOSCNT;


		EQEPCount1++;


		if(EQEPCount1 >= sum)
		{
			EQEP_OK = 1;
		}
	}


	if( ((interruptCount2/4)%2 == 1) && (interruptCount2 % 4 == 0))
	{ //epwmb 1->0
		EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
									EPWM_AQ_OUTPUT_HIGH,
									EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
									EPWM_AQ_OUTPUT_NO_CHANGE,
									EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
		#if (COMPARE_SHADOW == 1 || COMPARE_SHADOW == 2)
				HWREG(myEQEP0_BASE + EQEP_O_QPOSCMP) = ComValue;
				ComValue++;

				if(ComValue == 4)
				{
				ComValue=1;
				}
		#endif

	}
	else if ( ((interruptCount2/4)%2 == 0) && (interruptCount2 % 4 == 0))
	{ //epwmb 0->1
		EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
									EPWM_AQ_OUTPUT_LOW,
									EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_B,
									EPWM_AQ_OUTPUT_NO_CHANGE,
									EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	}

	if(interruptCount2 == 4)
	{
        EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A,
                                      EPWM_AQ_OUTPUT_HIGH,
                                      EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
        EPWM_setActionQualifierAction(myEPWM0_BASE, EPWM_AQ_OUTPUT_A,
                                      EPWM_AQ_OUTPUT_LOW,
                                      EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	}
    //
    // Clear interrupt flag and issue ACK
    //
    EPWM_clearEventTriggerInterruptFlag(myEPWM0_BASE);
}


#if myEQEP0_BASE == EQEP1_BASE
void EQEP1_INT_IRQHandler(void)
#elif myEQEP0_BASE == EQEP2_BASE
void EQEP2_INT_IRQHandler(void)
#endif
{

#if (COMPARE_SHADOW==0)

	if((EQEP_OK == 0)&&((EQEP_getInterruptStatus(myEQEP0_BASE) >> 8) & 1 == 1))
	{
		PCMINT_num++;
	}
	EQEP_clearInterruptStatus(myEQEP0_BASE,EQEP_INT_POS_COMP_MATCH|EQEP_INT_GLOBAL);
#elif (COMPARE_SHADOW==1 || COMPARE_SHADOW == 2)
	if((EQEP_getInterruptStatus(myEQEP0_BASE) >> 7) & 1 == 1)
	{
		PCRINT_num++;
	}
	EQEP_clearInterruptStatus(myEQEP0_BASE,EQEP_INT_POS_COMP_READY|EQEP_INT_GLOBAL);

#endif

}


int16_t EQEP_getQDLF(uint32_t base)
{
    int16_t direction;

    //
    // Check the arguments.
    //
    ASSERT(EQEP_isBaseValid(base));

    //
    // Return the direction of rotation.
    //
    if((HWREGH(base + EQEP_O_QEPSTS) & EQEP_QEPSTS_QDLF) != 0U)
    {
        direction = 1;
    }
    else
    {
        direction = -1;
    }

    return(direction);
}


/*****END OF FILE****/
