
/* Includes ------------------------------------------------------------------*/
#include "device.h"
#include "board_cfg.h"
#include "load_img.h"
#include <sys/stat.h>
#include "log.h"


#define myEQEP0_BASE EQEP1_BASE
#define sum 200


uint32_t interruptCount1 = 0;
uint32_t interruptCount2 = 0;


//Temprory

uint32_t CNT=0;
uint32_t QPOSSLAT=0;
uint32_t DIR=0;
uint32_t CNT_TEMP[2]={0,0};
int32_t CNT_DV[2];
volatile uint32_t EQEP_OK=0;
uint32_t i=0;

uint64_t TEMP1=0;
uint64_t TEMP2=0;
int32_t CNT_DV_1=0;
void eqep_test16_GPIO_Init();
void eqep_test16_myEQEP0_init();
void eqep_test16_initEPWM(void);
void EQEP1_INT_IRQHandler(void);
void EPWM1XINT_IRQHandler(void);
void EPWM2XINT_IRQHandler(void);

int16_t EQEP_getQDLF(uint32_t base);

uint32_t QPOSSLAT_num[sum];
uint32_t INT_num[sum];
int32_t DIR_num[sum];
uint32_t EQEPCount1=0;

/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */

int main(void)
{
	int ret;

	Device_init();
    UartPrint_init(SCIA_BASE, 115200);

	printf("eqep_test16_begin!\r\n");

	eqep_test16_GPIO_Init();

	eqep_test16_myEQEP0_init();


    //epeq1a
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX01);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX01_INPUTXBAR1);

	//epeq1b
    XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX03);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
    XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX03_INPUTXBAR2);


    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX13);
    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_OUT_MUX13_ADCSOCAO);




    Interrupt_register(INT_EPWM1,EPWM1XINT_IRQHandler);
	Interrupt_SetPriority(INT_EPWM1,2,2);
	Interrupt_enable(INT_EPWM1);


	Interrupt_register(INT_EPWM2,EPWM2XINT_IRQHandler);
	Interrupt_SetPriority(INT_EPWM2,1,1);
	Interrupt_enable(INT_EPWM2);



	Interrupt_register(INT_EQEP1,EQEP1_INT_IRQHandler);
	Interrupt_SetPriority(INT_EQEP1,0,0);
	Interrupt_enable(INT_EQEP1);

    __enable_irq();


	eqep_test16_initEPWM();

	while(1)
	{


		if( EQEP_OK == 1)
		{
			HWREG(0x400CD558)=0xBEEF;//make EDA simulation stop

				if( QPOSSLAT_num[0]==0 && QPOSSLAT_num[1]==4 && QPOSSLAT_num[2]==8 && QPOSSLAT_num[3]==7 && QPOSSLAT_num[4]==3)
				{

					printf("eqep_test16_ok!\r\n");


				}
				else
				{

					printf("eqep_test16_error!\r\n");

				}

			EQEP_OK = 2;

		}
	}


}


void eqep_test16_GPIO_Init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_0_EPWM1_A);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(0,true);

	GPIO_setPinConfig(GPIO_1_EPWM1_B);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(1,true);

    //
	// EPWM2 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_2_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(2,true);


	//eqep1A
	GPIO_setPinConfig(GPIO_50_EQEP1_A);
	GPIO_setPadConfig(50, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(50, GPIO_QUAL_SYNC);
    //eqep1B
	GPIO_setPinConfig(GPIO_51_EQEP1_B);
	GPIO_setPadConfig(51, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(51, GPIO_QUAL_SYNC);

	//eqep1S
	GPIO_setPinConfig(GPIO_52_EQEP1_STROBE);
	GPIO_setPadConfig(52, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(52, GPIO_QUAL_SYNC);

	//gpio10
	GPIO_setPinConfig(GPIO_34_OUTPUTXBAR1);
	GPIO_setPadConfig(34, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(34, GPIO_QUAL_SYNC);

	GPIO_setDirectionMode(34, GPIO_DIR_MODE_OUT);


}


void eqep_test16_myEQEP0_init(){

	//
	// Disable, clear all flags and interrupts
	//
	EQEP_disableInterrupt(myEQEP0_BASE,
		(EQEP_INT_GLOBAL            |
		EQEP_INT_POS_CNT_ERROR      |
		EQEP_INT_PHASE_ERROR        |
		EQEP_INT_DIR_CHANGE         |
		EQEP_INT_WATCHDOG           |
		EQEP_INT_UNDERFLOW          |
		EQEP_INT_OVERFLOW           |
		EQEP_INT_POS_COMP_READY     |
		EQEP_INT_POS_COMP_MATCH     |
		EQEP_INT_STROBE_EVNT_LATCH  |
		EQEP_INT_INDEX_EVNT_LATCH   |
		EQEP_INT_UNIT_TIME_OUT      |
		EQEP_INT_QMA_ERROR));
	EQEP_clearInterruptStatus(myEQEP0_BASE,
		(EQEP_INT_GLOBAL            |
		EQEP_INT_POS_CNT_ERROR      |
		EQEP_INT_PHASE_ERROR        |
		EQEP_INT_DIR_CHANGE         |
		EQEP_INT_WATCHDOG           |
		EQEP_INT_UNDERFLOW          |
		EQEP_INT_OVERFLOW           |
		EQEP_INT_POS_COMP_READY     |
		EQEP_INT_POS_COMP_MATCH     |
		EQEP_INT_STROBE_EVNT_LATCH  |
		EQEP_INT_INDEX_EVNT_LATCH   |
		EQEP_INT_UNIT_TIME_OUT      |
		EQEP_INT_QMA_ERROR));


	EQEP_SourceSelect source_myEQEP0 =
	{
		EQEP_SOURCE_PWMXBAR1, 		// eQEPA source
		EQEP_SOURCE_PWMXBAR2,		// eQEPB source
		EQEP_SOURCE_PWMXBAR3,  	// eQEP Index source

	};

	//
	// Selects the source for eQEPA/B/I signals
	//
	EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
	//
	// Set the strobe input source of the eQEP module.
	//
	EQEP_setStrobeSource(myEQEP0_BASE,EQEP_STROBE_OR_ADCSOCA);
	//
	// Sets the polarity of the eQEP module's input signals.
	//
	EQEP_setInputPolarity(myEQEP0_BASE,false,false,false,false);
	//
	// Configures eQEP module's quadrature decoder unit.
	//
	EQEP_setDecoderConfig(myEQEP0_BASE, (EQEP_CONFIG_QUADRATURE | EQEP_CONFIG_1X_RESOLUTION | EQEP_CONFIG_NO_SWAP | EQEP_CONFIG_IGATE_DISABLE));
	//
	// Set the emulation mode of the eQEP module.
	//
	EQEP_setEmulationMode(myEQEP0_BASE,EQEP_EMULATIONMODE_RUNFREE);
	//
	// Configures eQEP module position counter unit.
	//
	EQEP_setPositionCounterConfig(myEQEP0_BASE,EQEP_POSITION_RESET_MAX_POS,4294967295U);
	//
	// Sets the current encoder position.
	//
	EQEP_setPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module unit timer.
	//
	//EQEP_enableUnitTimer(myEQEP0_BASE,1200000U);
	EQEP_enableUnitTimer(myEQEP0_BASE,200000U);
	//
	// Disables the eQEP module watchdog timer.
	//
	EQEP_disableWatchdog(myEQEP0_BASE);
	//
	// Configures the quadrature modes in which the position count can be latched.
	//
	EQEP_setLatchMode(myEQEP0_BASE,(EQEP_LATCH_EDGE_DIR_STROBE));
	//
	// Set the quadrature mode adapter (QMA) module mode.
	//
	EQEP_setQMAModuleMode(myEQEP0_BASE,EQEP_QMA_MODE_BYPASS);
	//
	// Disable Direction Change During Index
	//
	EQEP_disableDirectionChangeDuringIndex(myEQEP0_BASE);
	//
	// Configures the mode in which the position counter is initialized.
	//
	EQEP_setPositionInitMode(myEQEP0_BASE,(EQEP_INIT_DO_NOTHING));
	//
	// Sets the software initialization of the encoder position counter.
	//
	EQEP_setSWPositionInit(myEQEP0_BASE,true);
	//
	// Sets the init value for the encoder position counter.
	//
	EQEP_setInitialPosition(myEQEP0_BASE,0U);
	// Enables individual eQEP module interrupt sources.
	//
	EQEP_enableInterrupt(myEQEP0_BASE,(EQEP_INT_STROBE_EVNT_LATCH));
	//
	// Enables the eQEP module.
	//
	EQEP_enableModule(myEQEP0_BASE);

	HWREG(myEQEP0_BASE + EQEP_O_QEPSRCSEL) |= 0x01<<12;
}

void eqep_test16_initEPWM(void)
{


    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(EPWM1_BASE, 0);
    EPWM_setTimeBaseCounter(EPWM1_BASE, 0);

    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(EPWM1_BASE,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(EPWM1_BASE,
                                             EPWM_COUNTER_COMPARE_B);

    //
    // Set the compare A value to half the period value, compare B to 0
    //
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 10001);
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 1);

    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(EPWM1_BASE, EPWM_INT_TBCTR_PERIOD);
    EPWM_enableInterrupt(EPWM1_BASE);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(EPWM1_BASE, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_4,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
    EPWM_setPeriodLoadMode(EPWM1_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(EPWM1_BASE, 20000);

    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);

 /**********************************EPWM2***************************************************/

    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(EPWM2_BASE, 0);
    EPWM_setTimeBaseCounter(EPWM2_BASE, 0);


    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(EPWM2_BASE,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(EPWM2_BASE,
                                             EPWM_COUNTER_COMPARE_B);
//	HWREGH(EPWM2_BASE + EPWM_O_AQCTL) |= 0x01>>6;
    //
    // Set the compare A value to half the period value, compare B to 0
    //
    EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, 5001);
    EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, 10000);

    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
	EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(EPWM2_BASE, EPWM_INT_TBCTR_ZERO);
    EPWM_enableInterrupt(EPWM2_BASE);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(EPWM2_BASE, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(EPWM2_BASE, EPWM_CLOCK_DIVIDER_4,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
    EPWM_setPeriodLoadMode(EPWM2_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(EPWM2_BASE, 20000);

    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP_DOWN);
    //
    // Sync the ePWM time base clock
    //

    //ADCSOCA
    EPWM_enableADCTrigger(EPWM2_BASE, EPWM_SOC_A);
    EPWM_setADCTriggerSource(EPWM2_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_U_CMPA);
    EPWM_setADCTriggerEventPrescale(EPWM2_BASE, EPWM_SOC_A,1);
#if GS32_PART_NUM == 0x0049 || GS32_PART_NUM == 0x0379
    HWREG(0x40008004) &= ~0x02;
    HWREG(0x40008004) |= 0x02;
#elif GS32_PART_NUM == 0x0039 || GS32_PART_NUM == 0x0025A
    HWREG(0x4003F004) &= ~0x02;
    HWREG(0x4003F004) |= 0x02;
#endif
    SysCtl_enablePeripheral_TBCLKSYNC();


}

/**
 * \brief   ePWM1 ISR--interrupts once every 4 QCLK counts (one period)
 *
 * \param   none
 *
 * \retval  None
 */
void EPWM1XINT_IRQHandler(void)
{



    interruptCount1++;


    if( interruptCount1 % 6 == 2)
    { //epwm1b 0,1 -> 0,0

		EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    }
	else if(interruptCount1 % 6 == 3)
    {
		EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
         EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    }

	else if(interruptCount1 % 6 == 0)
	{
		EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
							  EPWM_AQ_OUTPUT_LOW,
							  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
							  EPWM_AQ_OUTPUT_HIGH,
							  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	}



    //
    // Clear interrupt flag and issue ACK
    //
    EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);
}

void EPWM2XINT_IRQHandler(void)
{
	interruptCount2++;
	if ( interruptCount2 % 6 == 1 )
	{

		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

	}
	else if ( interruptCount2 % 6 == 3 )
	{
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	}
	else if ( interruptCount2 % 6 == 4 )
	{
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	}
	else if ( interruptCount2 % 6 == 0 )
	{
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	}
		EPWM_clearEventTriggerInterruptFlag(EPWM2_BASE);
}

void EQEP1_INT_IRQHandler(void)
{


	DIR = EQEP_getQDLF(myEQEP0_BASE);
	if(( EQEP_OK == 0 )&&((EQEP_getInterruptStatus(myEQEP0_BASE) >> 9) & 1 == 1))
	{
		QPOSSLAT = EQEP_getStrobePositionLatch(myEQEP0_BASE);


		INT_num[EQEPCount1] = interruptCount2 % 6 + 1;


		QPOSSLAT_num[EQEPCount1] = QPOSSLAT;


		EQEPCount1++;
		if(EQEPCount1 >= sum)
		{
			EQEP_OK = 1;
		}
	}
	EQEP_clearInterruptStatus(myEQEP0_BASE,EQEP_INT_STROBE_EVNT_LATCH|EQEP_INT_GLOBAL);
}


int16_t EQEP_getQDLF(uint32_t base)
{
    int16_t direction;

    //
    // Check the arguments.
    //
    ASSERT(EQEP_isBaseValid(base));

    //
    // Return the direction of rotation.
    //
    if((HWREGH(base + EQEP_O_QEPSTS) & EQEP_QEPSTS_QDLF) != 0U)
    {
        direction = 1;
    }
    else
    {
        direction = -1;
    }

    return(direction);
}


/*****END OF FILE****/
