
/* Includes ------------------------------------------------------------------*/
#include "device.h"
#include "board_cfg.h"
#include "load_img.h"
#include <sys/stat.h>
#include "log.h"
#include "cmpss_ex2_board.h"

#define myEQEP0_BASE EQEP1_BASE
#define sum 500


uint32_t interruptCount1 = 0;
uint32_t interruptCount2 = 0;
uint32_t cmpss_num = 0;
uint32_t ok_ans = 0;
//Temprory

uint32_t CNT=0;
uint32_t QPOSILAT=0;
uint32_t DIR=0;
uint32_t CNT_TEMP[2]={0,0};
int32_t CNT_DV[2];
volatile uint32_t EQEP_OK=0;
uint32_t i=0;
uint32_t EQEP_F=0;

uint64_t TEMP1=0;
uint64_t TEMP2=0;
int32_t CNT_DV_1=0;
void eqep_test21_GPIO_Init();
void eqep_test21_myEQEP0_init();
void eqep_test21_initEPWM(void);

void EPWM1XINT_IRQHandler(void);
int16_t EQEP_getQDLF(uint32_t base);



uint32_t QPOSCNT_num[sum];
uint32_t COEF_num[sum];

uint32_t EQEPCount1=0;

uint32_t EQEPCount2=0;
/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void)
{
	int ret;

    Device_init();
    UartPrint_init(SCIA_BASE, 115200);


	printf("eqep_test21_begin!\r\n");
	printf("Please Connect A2 to 3.3V using jumper wires!\r\n");
	eqep_test21_GPIO_Init();


	eqep_test21_myEQEP0_init();

    //epeq1a
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX01);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX01_INPUTXBAR1);

	//epeq1b
    XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX03);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
    XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX03_INPUTXBAR2);
	//epeq1I
    XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX05);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT3, 2);
    XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX05_INPUTXBAR3);




    Interrupt_register(INT_EPWM1,EPWM1XINT_IRQHandler);
	Interrupt_SetPriority(INT_EPWM1,2,2);
	Interrupt_enable(INT_EPWM1);

    __enable_irq();

    Board_init();

	eqep_test21_initEPWM();

	while(1)
	{

#if GS32F00xx == 0x0012
		if( EQEP_OK == 1)
		{
			for(i=0;i < sum - 2;i++)
			{


				if( QPOSCNT_num[i]==i )
				{
					ok_ans++;
				}
				else
				{

					printf("ERROR:%d\r\n",i);

				}

			}

			if(ok_ans == sum - 2)
			{
				printf("test_ok\r\n");
			}


			EQEP_OK = 2;
		}

#endif


		if( EQEP_OK == 1)
		{
			for(i=0;i < sum - 2;i++)
			{
				if( QPOSCNT_num[i]==i*2+1 )
				{
					ok_ans++;
				}
			}

			if(ok_ans == sum - 2)
			{
				printf("eqep_test21_ok!\r\n");
			}
			else
			{
				printf("eqep_test21_error!\r\n");
			}


			EQEP_OK = 2;
		}


	}
}


void eqep_test21_GPIO_Init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_0_EPWM1_A);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(0,true);

	GPIO_setPinConfig(GPIO_1_EPWM1_B);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(1,true);

    //
	// EPWM2 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_2_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(2,true);


	//eqep1A
	GPIO_setPinConfig(GPIO_50_EQEP1_A);
	GPIO_setPadConfig(50, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(50, GPIO_QUAL_SYNC);
    //eqep1B
	GPIO_setPinConfig(GPIO_51_EQEP1_B);
	GPIO_setPadConfig(51, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(51, GPIO_QUAL_SYNC);
	//eqep1I
	GPIO_setPinConfig(GPIO_53_EQEP1_INDEX);
	GPIO_setPadConfig(53, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(53, GPIO_QUAL_SYNC);

	//gpio30
	GPIO_setPinConfig(GPIO_10_GPIO10);
	GPIO_setPadConfig(10, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(10, GPIO_QUAL_SYNC);

	GPIO_enableWritePin(10);



}


void eqep_test21_myEQEP0_init(){

		//
		// Disable, clear all flags and interrupts
		//
		EQEP_disableInterrupt(myEQEP0_BASE,
			(EQEP_INT_GLOBAL            |
			EQEP_INT_POS_CNT_ERROR      |
			EQEP_INT_PHASE_ERROR        |
			EQEP_INT_DIR_CHANGE         |
			EQEP_INT_WATCHDOG           |
			EQEP_INT_UNDERFLOW          |
			EQEP_INT_OVERFLOW           |
			EQEP_INT_POS_COMP_READY     |
			EQEP_INT_POS_COMP_MATCH     |
			EQEP_INT_STROBE_EVNT_LATCH  |
			EQEP_INT_INDEX_EVNT_LATCH   |
			EQEP_INT_UNIT_TIME_OUT      |
			EQEP_INT_QMA_ERROR));
		EQEP_clearInterruptStatus(myEQEP0_BASE,
			(EQEP_INT_GLOBAL            |
			EQEP_INT_POS_CNT_ERROR      |
			EQEP_INT_PHASE_ERROR        |
			EQEP_INT_DIR_CHANGE         |
			EQEP_INT_WATCHDOG           |
			EQEP_INT_UNDERFLOW          |
			EQEP_INT_OVERFLOW           |
			EQEP_INT_POS_COMP_READY     |
			EQEP_INT_POS_COMP_MATCH     |
			EQEP_INT_STROBE_EVNT_LATCH  |
			EQEP_INT_INDEX_EVNT_LATCH   |
			EQEP_INT_UNIT_TIME_OUT      |
			EQEP_INT_QMA_ERROR));
#if GS32F00xx == 0x0012
		EQEP_SourceSelect source_myEQEP0 =
		{
			EQEP_SOURCE_CMPSS1, 		// eQEPA source
			EQEP_SOURCE_CMPSS2,		// eQEPB source
			EQEP_SOURCE_PWMXBAR3,  	// eQEP Index source

		};
#endif

	EQEP_SourceSelect source_myEQEP0 =
	{
		EQEP_SOURCE_PWMXBAR1, 		// eQEPA source
		EQEP_SOURCE_CMPSS1,		// eQEPB source
		EQEP_SOURCE_DEVICE_PIN,  	// eQEP Index source

	};
	//
	// Selects the source for eQEPA/B/I signals
	//
	EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
	//
	// Set the strobe input source of the eQEP module.
	//
	EQEP_setStrobeSource(myEQEP0_BASE,EQEP_STROBE_FROM_GPIO);
	//
	// Sets the polarity of the eQEP module's input signals.
	//
	EQEP_setInputPolarity(myEQEP0_BASE,false,false,false,false);
	//
	// Configures eQEP module's quadrature decoder unit.
	//
	EQEP_setDecoderConfig(myEQEP0_BASE, (EQEP_CONFIG_CLOCK_DIR | EQEP_CONFIG_1X_RESOLUTION | EQEP_CONFIG_NO_SWAP | EQEP_CONFIG_IGATE_DISABLE));
	//
	// Set the emulation mode of the eQEP module.
	//
	EQEP_setEmulationMode(myEQEP0_BASE,EQEP_EMULATIONMODE_RUNFREE);
	//
	// Configures eQEP module position counter unit.
	//
	EQEP_setPositionCounterConfig(myEQEP0_BASE,EQEP_POSITION_RESET_IDX,4294967295U);
	//
	// Sets the current encoder position.
	//
	EQEP_setPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module unit timer.
	//
	//EQEP_enableUnitTimer(myEQEP0_BASE,1200000U);
	EQEP_enableUnitTimer(myEQEP0_BASE,200000U);
	//
	// Disables the eQEP module watchdog timer.
	//
	EQEP_disableWatchdog(myEQEP0_BASE);
	//
	// Configures the quadrature modes in which the position count can be latched.
	//
	EQEP_setLatchMode(myEQEP0_BASE,(EQEP_LATCH_UNIT_TIME_OUT|EQEP_LATCH_RISING_STROBE|EQEP_LATCH_RISING_INDEX));
	//
	// Set the quadrature mode adapter (QMA) module mode.
	//
	EQEP_setQMAModuleMode(myEQEP0_BASE,EQEP_QMA_MODE_BYPASS);
	//
	// Disable Direction Change During Index
	//
	EQEP_disableDirectionChangeDuringIndex(myEQEP0_BASE);
	//
	// Configures the mode in which the position counter is initialized.
	//
	EQEP_setPositionInitMode(myEQEP0_BASE,(EQEP_INIT_DO_NOTHING));
	//
	// Sets the software initialization of the encoder position counter.
	//
	EQEP_setSWPositionInit(myEQEP0_BASE,true);
	//
	// Sets the init value for the encoder position counter.
	//
	EQEP_setInitialPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module.
	//
	EQEP_enableModule(myEQEP0_BASE);
	//
	// Configures eQEP module edge-capture unit.
	//systick128分频6.4us为QCTIMER,大计6.4*65536=419.4304 ms
	//upevent个CLK 1 / 500 / 4 =0.5ms 0.5*1024=512ms
	EQEP_setCaptureConfig(myEQEP0_BASE,EQEP_CAPTURE_CLK_DIV_128,EQEP_UNIT_POS_EVNT_DIV_1024);


}

void eqep_test21_initEPWM(void)
{

    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(EPWM1_BASE, 0);
    EPWM_setTimeBaseCounter(EPWM1_BASE, 0);

    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(EPWM1_BASE,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(EPWM1_BASE,
                                             EPWM_COUNTER_COMPARE_B);

    //
    // Set the compare A value to half the period value, compare B to 0
    //
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 10001);
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 1);

    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    EPWM_setActionQualifierAction(EPWM1_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);


    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(EPWM1_BASE, EPWM_INT_TBCTR_PERIOD);
    EPWM_enableInterrupt(EPWM1_BASE);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(EPWM1_BASE, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
    EPWM_setPeriodLoadMode(EPWM1_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(EPWM1_BASE, 20000);

    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);

    SysCtl_enablePeripheral_TBCLKSYNC();
}

/**
 * \brief   ePWM1 ISR--interrupts once every 4 QCLK counts (one period)
 *
 * \param   none
 *
 * \retval  None
 */
void EPWM1XINT_IRQHandler(void)
{
#if GS32F00xx == 0x0012
	//only 1.2FPGA TEST

	if( interruptCount1 == 0)//启CAP和CNT
	{
		//HWREGH(myEQEP0_BASE + EQEP_O_QEPCTL) |= 0x08;
		EQEP_enableCapture(myEQEP0_BASE);
		HWREG(0x400CD000+0x554) |= 0x01<<2;

	}

	if(( interruptCount1%2 == 0)&&(EQEP_OK==0))
	{
		//CMPSS1 LOW
		HWREG(0x400CD000+0x554) &= ~0x01;
		HWREG(0x400CD000+0x554) |=  0x02;
		QPOSCNT_num[cmpss_num] = EQEP_getPosition(myEQEP0_BASE);
		cmpss_num++;
		if(cmpss_num  >= sum)
		{
			EQEP_OK = 1;
		}
	}
	else
	{
		//CMPSS1 HIGH
		HWREG(0x400CD000+0x554) &= ~0x02;
		HWREG(0x400CD000+0x554) |=  0x01;
	}

	interruptCount1++;

    //
    // Clear interrupt flag and issue ACK
    //
    EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);
#endif

	if(( interruptCount1%2 == 0)&&(EQEP_OK==0))
	{
		GPIO_togglePin(10);
		QPOSCNT_num[cmpss_num] = EQEP_getPosition(myEQEP0_BASE);
		cmpss_num++;
		if(cmpss_num  >= sum)
		{
			EQEP_OK = 1;
		}
	}

	interruptCount1++;

    //
    // Clear interrupt flag and issue ACK
    //
    EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);
}





int16_t EQEP_getQDLF(uint32_t base)
{
    int16_t direction;

    //
    // Check the arguments.
    //
    ASSERT(EQEP_isBaseValid(base));

    //
    // Return the direction of rotation.
    //
    if((HWREGH(base + EQEP_O_QEPSTS) & EQEP_QEPSTS_QDLF) != 0U)
    {
        direction = 1;
    }
    else
    {
        direction = -1;
    }

    return(direction);
}


/*****END OF FILE****/
