/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//
// Defines that select the example to compile in.
// Only one example should be set as 1 the rest should be set as 0.
//
#define EXAMPLE1 0 // Use DATA registers to toggle I/O's
#define EXAMPLE2 0 // Use SET/CLEAR registers to toggle I/O's
#define EXAMPLE3 1 // Use TOGGLE registers to toggle I/O's

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

void Gpio_select(void);
void Gpio_example1(void);
void Gpio_example2(void);
void Gpio_example3(void);

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    // Initialize the device
    Device_init();

    //
    // For this example use the following configuration:
    //
    Gpio_select();

#if EXAMPLE1
    //
    // This example uses DATA registers to toggle I/O's
    //
    Gpio_example1();

#endif // - EXAMPLE1

#if EXAMPLE2
    //
    // This example uses SET/CLEAR registers to toggle I/O's
    //
    Gpio_example2();

#endif

#if EXAMPLE3
    //
    // This example uses TOGGLE registers to toggle I/O's
    //
    Gpio_example3();

#endif

    while (1) {
    }

    return 0;
}

//
// Gpio_example1 - Gpio example 1 that toggle's I/Os using DATA registers
//
void Gpio_example1(void)
{
    for (;;) {
        GpioDataRegs.GPADAT.all = 0xAAAAAAAA;

        DELAY_US(100 * 1000);

        GpioDataRegs.GPADAT.all = 0x55555555;

        DELAY_US(100 * 1000);
    }
}

//
// Gpio_example2 - Gpio example 2 that toggle's I/Os using SET/CLEAR registers
//
void Gpio_example2(void)
{
    for (;;) {
        GpioDataRegs.GPASET.all   = 0xAAAAAAAA;
        GpioDataRegs.GPACLEAR.all = 0x55555555;

        DELAY_US(100 * 1000);

        GpioDataRegs.GPACLEAR.all = 0xAAAAAAAA;
        GpioDataRegs.GPASET.all   = 0x55555555;

        DELAY_US(100 * 1000);
    }
}

//
// Gpio_example3 - Gpio example 2 that toggle's I/Os using TOGGLE registers
//
void Gpio_example3(void)
{
    //
    // Set pins to a known state
    //
    GpioDataRegs.GPASET.all   = 0xAAAAAAAA;
    GpioDataRegs.GPACLEAR.all = 0x55555555;

    //
    // Use TOGGLE registers to flip the state of
    // the pins.
    // Any bit set to a 1 will flip state (toggle)
    // Any bit set to a 0 will not toggle.
    //
    for (;;) {
        GpioDataRegs.GPATOGGLE.all = 0xFFFFFFFF;
        DELAY_US(100 * 1000);
    }
}

//
// Gpio_select - Sets the gpios functionality
//
void Gpio_select(void)
{
    GpioCtrlRegs.GPAMUX1.all = 0x00000000; // All GPIO
    GpioCtrlRegs.GPAMUX2.all = 0x00000000; // All GPIO
    GpioCtrlRegs.GPADIR.all  = 0xFFFFFFFF; // All outputs
}
